/*************************************************************************
 *
 *  $RCSfile: adritem.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: sj $ $Date: 2001/05/22 09:58:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _SBXVAR_HXX //autogen
#include <svtools/sbxvar.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_USEROPTIONS_HXX
#include <svtools/useroptions.hxx>
#endif
#pragma hdrstop

#include "adritem.hxx"
#include "svxids.hrc"

// -----------------------------------------------------------------------

String ConvertToStore_Impl( const String& rText )
{
	String sRet;
	USHORT i = 0;

	while ( i < rText.Len() )
	{
		if ( rText.GetChar(i) == '\\' || rText.GetChar(i) == '#' )
			sRet += '\\';
		sRet += rText.GetChar(i++);
	}
	return sRet;
}

// -----------------------------------------------------------------------

TYPEINIT1(SvxAddressItem, SfxStringItem);

// -----------------------------------------------------------------------

SvxAddressItem::SvxAddressItem( USHORT nWhich ) :

	SfxStringItem( nWhich, String() )

{
	SvtUserOptions aUserOpt;

	aName = aUserOpt.GetLastName();
	aFirstName = aUserOpt.GetFirstName();
	aShortName = aUserOpt.GetID();

	SetToken( POS_COMPANY, aUserOpt.GetCompany() );
	SetToken( POS_STREET, aUserOpt.GetStreet() );
	SetToken( POS_CITY, aUserOpt.GetCity() );
	SetToken( POS_STATE, aUserOpt.GetState() );
	SetToken( POS_PLZ, aUserOpt.GetZip() );
	SetToken( POS_COUNTRY, aUserOpt.GetCountry() );
	SetToken( POS_POSITION, aUserOpt.GetPosition() );
	SetToken( POS_TITLE, aUserOpt.GetTitle() );
	SetToken( POS_TEL_PRIVATE, aUserOpt.GetTelephoneHome() );
	SetToken( POS_TEL_COMPANY, aUserOpt.GetTelephoneWork() );
	SetToken( POS_FAX, aUserOpt.GetFax() );
	SetToken( POS_EMAIL, aUserOpt.GetEmail() );
}

// -----------------------------------------------------------------------

SvxAddressItem::SvxAddressItem( const SvxAddressItem& rItem ) :

	SfxStringItem( rItem.Which(), rItem.GetValue() ),

	aName		( rItem.aName ),
	aFirstName	( rItem.aFirstName ),
	aShortName	( rItem.aShortName )

{
}

// -----------------------------------------------------------------------

SvxAddressItem::SvxAddressItem( const String &rAdress,
								const String &rShortName,
								const String &rFirstName,
								const String &rName,
								USHORT nWhich ) :

	SfxStringItem( nWhich, rAdress ),

	aName		( rName ),
	aFirstName	( rFirstName ),
	aShortName	( rShortName )

{
}

// -----------------------------------------------------------------------

void SvxAddressItem::Store()
{
	SvtUserOptions aUserOpt;
	aUserOpt.SetCompany( GetCompany() );
	aUserOpt.SetFirstName( GetFirstName() );
	aUserOpt.SetLastName( GetName() );
	aUserOpt.SetID( GetShortName() );
	aUserOpt.SetStreet( GetStreet() );
	aUserOpt.SetCity( GetCity() );
	aUserOpt.SetState( GetState() );
	aUserOpt.SetZip( GetPLZ() );
	aUserOpt.SetCountry( GetCountry() );
	aUserOpt.SetPosition( GetPosition() );
	aUserOpt.SetTitle( GetTitle() );
	aUserOpt.SetTelephoneHome( GetTelPriv() );
	aUserOpt.SetTelephoneWork( GetTelCompany() );
	aUserOpt.SetFax( GetFax() );
	aUserOpt.SetEmail( GetEmail() );
}

// -----------------------------------------------------------------------

SfxPoolItem* SvxAddressItem::Clone( SfxItemPool * ) const
{
	return new SvxAddressItem( *this );
}

// -----------------------------------------------------------------------

SfxPoolItem* SvxAddressItem::Create( SvStream& rStream, USHORT nVersion ) const
{
	DBG_ERROR( "wer will denn ein SvxAdddressItem laden?" );

	String aAdr, aShortName, aFirstName, aName;
	rStream.ReadByteString(aAdr);
	rStream.ReadByteString(aShortName);
	rStream.ReadByteString(aFirstName);
	rStream.ReadByteString(aName);
	return new SvxAddressItem( aAdr, aShortName, aFirstName, aName, Which() );
}

// -----------------------------------------------------------------------

int SvxAddressItem::operator==( const SfxPoolItem& rAttr ) const
{
	DBG_ASSERT( SfxPoolItem::operator==(rAttr), "unequal types" );

	const SvxAddressItem& rItem = (const SvxAddressItem&)rAttr;

	return SfxStringItem::operator==(rAttr) &&
		   ( rItem.GetName() == aName ) &&
		   ( rItem.GetFirstName() == aFirstName ) &&
		   ( rItem.GetShortName() == aShortName );
}

// -----------------------------------------------------------------------

BOOL SvxAddressItem::SetToken( USHORT nPos, const String &rVal )
{
	// nach dem 'nPos'-ten Token suchen
	String aAdress( GetValue() );
	USHORT nStart, nEnd = 0;
	for ( USHORT nNo = 0; nNo <= nPos; ++nNo )
	{
		// End-'#' finden
		for ( nStart = nEnd;
			  nEnd < aAdress.Len() && aAdress.GetChar(nEnd) != '#';
			  ++nEnd )
			if ( aAdress.GetChar(nEnd) == '\\' )
				++nEnd;

		// aAdress[nEnd] == '#' oder am Ende, also eine Position weiter gehen
		++nEnd;

		// ggf. fehlende '#' auff"ullen
		if ( nNo < nPos && nEnd >= aAdress.Len() )
			aAdress += '#';
	}

	// gefunden
	aAdress.Erase( nStart, nEnd-nStart-1 );
	aAdress.Insert( rVal, nStart );
	SetValue( aAdress );
	return TRUE;
}

// -----------------------------------------------------------------------

String SvxAddressItem::GetToken( USHORT nPos ) const
{
	String sRet, sEmpty;
	const String &rAdress = GetValue();
	USHORT i = 0, nTxt = 0;

	while ( i < rAdress.Len() )
	{
		while ( i < rAdress.Len() && rAdress.GetChar(i) != '#' )
		{
			if ( rAdress.GetChar(i) == '\\' )
				i++;
			sRet += rAdress.GetChar(i++);
		}

		// rAdress[i] == '#' oder am Ende, also eine Position weiter gehen
		i++;

		if ( nPos == nTxt )
			return sRet;
		else if ( i >= rAdress.Len() )
			return sEmpty;
		else
		{
			sRet.Erase();
			nTxt++;
		}
	}
	return sEmpty;
}


