/*************************************************************************
 *
 *  $RCSfile: svdoole2.hxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: ka $ $Date: 2001/09/13 09:21:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVDOOLE2_HXX
#define _SVDOOLE2_HXX

#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif

#ifndef _SVDORECT_HXX
#include "svdorect.hxx"
#endif
#ifndef _GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif
#ifndef _GDIMTF_HXX //autogen
#include <vcl/gdimtf.hxx>
#endif
#ifndef _SOT_STORAGE_HXX
#include <sot/storage.hxx>
#endif

//************************************************************
//   Vorausdeklarationen
//************************************************************

class SvPersist;
class SvInPlaceObjectRef;
class SvEmbeddedInfoObject;

// ***********************************************************
//  SvInPlaceObject dummy implementation for displaying
//  plugins with the StarOffice Player without so3
// ***********************************************************

#ifdef SVX_LIGHT

#ifndef _OWNLIST_HXX
#include <svtools/ownlist.hxx>
#endif

namespace com { namespace sun { namespace star {
	namespace awt {
	class XToolkit;
	class XWindowPeer;
	}

	namespace plugin {
	class XPlugin;
	}
}}}

class INetURLObject;

class SvInPlaceObject : public SvRefBase
{
private:
	INetURLObject*	pURL;
	SvCommandList	aCmdList;
	USHORT			nPlugInMode;
	String			aMimeType;
	::com::sun::star::uno::Reference< ::com::sun::star::plugin::XPlugin >		xPlugin;
	Rectangle		aRect;

public:
	SvInPlaceObject();
	~SvInPlaceObject();

	void CreatePlugin( ::com::sun::star::uno::Reference< ::com::sun::star::awt::XToolkit > xToolkit,
					   ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindowPeer > xPeer );	// this method is called from the views DoConnect method
																	// Only the view knows the parent window for the plugin
	static SvInPlaceObject* Load( SotStorageRef xSt );
	void SetSizeAndPos( const Rectangle& rRect );
	void DoDisconnect();											// destroys the plugin for this inplace dummy
};

SV_DECL_REF(SvInPlaceObject);
SV_IMPL_REF(SvInPlaceObject);

#endif // SVX_LIGHT

//************************************************************
//   SdrOle2Obj
//************************************************************

class SvxUnoShapeModifyListener;

class SdrOle2ObjImpl;

class SdrOle2Obj :  public SdrRectObj
{
protected:
	SvInPlaceObjectRef*			ppObjRef;    // Referenz auf Objekt

	String						aName;       // Name des Objektes

	Graphic*					pGraphic;
	String						aProgName;

	// wg. Kompatibilitaet erstmal am SdrTextObj
	BOOL						bFrame : 1;
	BOOL						bInDestruction : 1;

	SdrOle2ObjImpl*				mpImpl;

	SvxUnoShapeModifyListener*	pModifyListener;

protected:

	void ImpSetVisAreaSize();
    void ImpAssign( const SdrObject& rObj, SdrPage* pNewPage = NULL, SdrModel* pNewModel = NULL );
    void ImpCopyObject( SvPersist& rSrcPersist, SvPersist& rDstPersist, String& rPersistName );

	void CreatePersistName( SvPersist* pPers );
	void Init();

public:
	TYPEINFO();

	SdrOle2Obj(FASTBOOL bFrame_=FALSE);
	SdrOle2Obj(const SvInPlaceObjectRef& rNewObjRef, FASTBOOL bFrame_=FALSE);
	SdrOle2Obj(const SvInPlaceObjectRef& rNewObjRef, const String& rNewObjName, FASTBOOL bFrame_=FALSE);
	SdrOle2Obj(const SvInPlaceObjectRef& rNewObjRef, const String& rNewObjName, const Rectangle& rNewRect, FASTBOOL bFrame_=FALSE);
	virtual ~SdrOle2Obj();

	// Ein OLE-Zeichenobjekt kann eine StarView-Grafik beinhalten.
	// Diese wird angezeigt, wenn das OLE-Objekt leer ist.
	void        SetGraphic(const Graphic* pGrf);
	Graphic*    GetGraphic() const { return pGraphic; }

    // OLE object has got a separate PersistName member now;
    // !!! use ::SetPersistName( ... ) only, if you know what you do !!!
    String      GetPersistName() const;
    void        SetPersistName( const String& rPersistName );

	virtual FASTBOOL HasSetName() const;

	virtual void    SetName(const String& rStr);
	virtual String  GetName() const;

	// Einem SdrOle2Obj kann man ein Applikationsnamen verpassen, den man
	// spaeter wieder abfragen kann (SD braucht das fuer Praesentationsobjekte).
	void SetProgName(const String& rNam) { aProgName=rNam; }
	const String& GetProgName() const { return aProgName; }
	FASTBOOL IsEmpty() const;
	void SetObjRef(const SvInPlaceObjectRef& rNewObjRef);
	const SvInPlaceObjectRef& GetObjRef() const;

	virtual void SetPage(SdrPage* pNewPage);
	virtual void SetModel(SdrModel* pModel);

	virtual void TakeObjInfo(SdrObjTransformInfoRec& rInfo) const;
	virtual UINT16 GetObjIdentifier() const;
	virtual FASTBOOL Paint(ExtOutputDevice& rOut, const SdrPaintInfoRec& rInfoRec) const;
	virtual SdrObject* CheckHit(const Point& rPnt, USHORT nTol, const SetOfByte* pVisiLayer) const;
	
    virtual SdrObject* Clone(SdrPage* pPage, SdrModel* pModel) const;
	
    virtual void TakeObjNameSingul(String& rName) const;
	virtual void TakeObjNamePlural(String& rName) const;

	virtual void operator=(const SdrObject& rObj);
	virtual FASTBOOL HasSpecialDrag() const;

	virtual void NbcMove(const Size& rSize);
	virtual void NbcResize(const Point& rRef, const Fraction& xFact, const Fraction& yFact);
	virtual void NbcSetSnapRect(const Rectangle& rRect);
	virtual void NbcSetLogicRect(const Rectangle& rRect);
	virtual void SetGeoData(const SdrObjGeoData& rGeo);

	// fuer Import:
	FASTBOOL HasGDIMetaFile() const;
	const GDIMetaFile* GetGDIMetaFile() const;

	virtual void WriteData(SvStream& rOut) const;
	virtual void ReadData(const SdrObjIOHeader& rHead, SvStream& rIn);

	BOOL Unload();

	void Connect();
	void Disconnect();

	::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel > getXModel() const;
};

#endif //_SVDOOLE2_HXX

