/*************************************************************************
 *
 *  $RCSfile: dbtools.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:00:55 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SVX_DBTOOLS_HXX
#define _SVX_DBTOOLS_HXX

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

enum DatabaseStatusCode {
	DBSTATUSCODE_SUCCESS = 1,
	DBSTATUSCODE_WARNING = 2,
	DBSTATUSCODE_NODATA = 3,
	DBSTATUSCODE_ERROR = 4
};

// Datenbank status erweitert
class DatabaseStatus
{
	DatabaseStatusCode RetCode;
	XubString Message;
	XubString SQLStatus;
	INT32 ErrorCode;
	INT32 RecordsAffected;
public:

	DatabaseStatus()
		:RetCode(DBSTATUSCODE_SUCCESS)
		,ErrorCode(0)
		,RecordsAffected(0) {}

	void setRetCode(DatabaseStatusCode eCode) {RetCode = eCode;}
	void setMessage(XubString m) {Message = m;}
	void setSQLStatus(XubString s) {SQLStatus = s;}
	void setErrorCode(INT32 nCode) {ErrorCode = nCode;}
	void setRecordsAffected(INT32 r) {RecordsAffected = r;}

	DatabaseStatusCode getRetCode() const {return RetCode;}
	XubString getMessage() const {return Message;}
	XubString getSQLStatus() const {return SQLStatus;}
	INT32 getErrorCode() const {return ErrorCode;}
	INT32 getRecordsAffected() const {return RecordsAffected;}

	BOOL isOk() const {return RetCode == DBSTATUSCODE_SUCCESS ||
							  RetCode == DBSTATUSCODE_WARNING;}

	BOOL isWarning() const {return RetCode == DBSTATUSCODE_WARNING;}
	BOOL isError() const {return RetCode == DBSTATUSCODE_ERROR;}
	BOOL hasNoData() const {return RetCode == DBSTATUSCODE_NODATA;}
};


#endif // _SVX_DBTOOLS_HXX

