/*************************************************************************
 *
 *  $RCSfile: parrtf.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jp $ $Date: 2001/11/27 16:22:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _PARRTF_HXX
#define _PARRTF_HXX

#ifndef _SVPARSER_HXX
#include <svparser.hxx>
#endif
#ifndef _SVARRAY_HXX
#include <svarray.hxx>
#endif

struct RtfParserState_Impl
{
	rtl_TextEncoding eCodeSet;
	BYTE nUCharOverread;

	RtfParserState_Impl( BYTE nUOverread, rtl_TextEncoding eCdSt )
		: eCodeSet( eCdSt ), nUCharOverread( nUOverread )
	{}
};

SV_DECL_VARARR( RtfParserStates_Impl, RtfParserState_Impl, 16, 16 )

class SvRTFParser : public SvParser
{
	RtfParserStates_Impl aParserStates;

	int nOpenBrakets;
	rtl_TextEncoding eCodeSet, eUNICodeSet;
	BYTE nUCharOverread;

protected:
	sal_Unicode GetHexValue();
	void ScanText( const sal_Unicode = 0 );
	void SkipGroup();

	// scanne das naechste Token,
	virtual int _GetNextToken();

	virtual void ReadUnknownData();
	virtual void ReadBitmapData();
	virtual void ReadOLEData();

	virtual ~SvRTFParser();

	rtl_TextEncoding GetCodeSet() const 			{ return eCodeSet; }
	void SetEncoding( rtl_TextEncoding eEnc );

	rtl_TextEncoding GetUNICodeSet() const 			{ return eUNICodeSet; }
	void SetUNICodeSet( rtl_TextEncoding eSet )		{ eUNICodeSet = eSet; }

public:
	SvRTFParser( SvStream& rIn, BYTE nStackSize = 3 );

	virtual SvParserState CallParser();   // Aufruf des Parsers

	int GetOpenBrakets() const { return nOpenBrakets; }

	// fuers asynchrone lesen aus dem SvStream
//	virtual void SaveState( int nToken );
//	virtual void RestoreState();
	virtual void Continue( int nToken );
};


/*************************************************************************

	  Source Code Control System - Header

	  $Header: /cvs/util/svtools/source/svrtf/parrtf.hxx,v 1.3 2001/11/27 16:22:04 jp Exp $

	  Source Code Control System - Update

	  $Log: parrtf.hxx,v $
	  Revision 1.3  2001/11/27 16:22:04  jp
	  Bug #91596#: handle the encoding correct
	
	  Revision 1.2  2000/11/08 16:02:17  jp
	  overread correct count unicode dummy characters

	  Revision 1.1.1.1  2000/09/18 16:59:05  hr
	  initial import

	  Revision 1.14  2000/09/18 14:13:46  willem.vandorp
	  OpenOffice header added.

	  Revision 1.13  2000/08/31 13:51:38  willem.vandorp
	  Header and footer replaced

	  Revision 1.12  2000/04/14 12:40:41  jp
	  Unicode changes

	  Revision 1.11  2000/03/28 11:47:42  jp
	  changes for Unicode

	  Revision 1.10  1998/04/20 08:16:22  JP
	  neu: CodeSet und UNICodeSet


	  Rev 1.9   20 Apr 1998 10:16:22   JP
   neu: CodeSet und UNICodeSet

	  Rev 1.8   03 Apr 1998 18:55:20   JP
   RTF-Parser um neue Tokens erweitert, nTokenValue wurde ein long

	  Rev 1.7   24 Jul 1996 20:37:16   JP
   neu: GetOpenBrakets - Anzahl geoeffneter Klammern

	  Rev 1.6   08 May 1996 17:37:48   JP
   Erweiterung fuers asynchrone Laden

	  Rev 1.5   05 Feb 1996 19:24:28   JP
   BasisKlass SvParser in eingenes Modul verschoben

	  Rev 1.4   30 Mar 1995 12:19:50   JP
   NextToken in die BasisKlasse verschoben

	  Rev 1.3   29 Mar 1995 15:23:06   JP
   SvParser: TokenStackverwaltung jetzt in der Basis-Klasse, define fuer no RTF-Parser

	  Rev 1.2   23 Feb 1995 12:46:20   KH
   Mac Anpassung

	  Rev 1.1   06 Jan 1995 12:10:52   JP
   fuer Tokenvalue reicht ein short

	  Rev 1.0   22 Dec 1994 17:19:58   JP
   Initial revision.

*************************************************************************/
#endif
	//_PARRTF_HXX
