/*************************************************************************
 *
 *  $RCSfile: iodlg.cxx,v $
 *
 *  $Revision: 1.49.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 10:54:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// includes --------------------------------------------------------------

#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif

#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_LSTBOX_HXX
#include <vcl/lstbox.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_TIMER_HXX
#include <vcl/timer.hxx>
#endif

#ifndef _UNOTOOLS_UCBHELPER_HXX
#include <unotools/ucbhelper.hxx>
#endif
#ifndef _UCBHELPER_CONTENTBROKER_HXX
#include <ucbhelper/contentbroker.hxx>
#endif

#ifndef _EHDL_HXX
#include "ehdl.hxx"
#endif
#ifndef SVTOOLS_URIHELPER_HXX
#include "urihelper.hxx"
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include "pathoptions.hxx"
#endif
#ifndef INCLUDED_SVTOOLS_VIEWOPTIONS_HXX
#include "viewoptions.hxx"
#endif
#ifndef _SVT_FILEVIEW_HXX
#include "fileview.hxx"
#endif

#ifndef _SVTOOLS_INETOPTIONS_HXX_
#include <inetoptions.hxx>
#endif
#ifndef _SFXECODE_HXX
#include "sfxecode.hxx"
#endif
#ifndef _SVARRAY_HXX
#include "svarray.hxx"
#endif
#ifndef _SVTABBX_HXX
#include "svtabbx.hxx"
#endif

#define _SVSTDARR_USHORTS
#define _SVSTDARR_STRINGSDTOR
#include "svstdarr.hxx"

#ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_
#include <toolkit/helper/vclunohelper.hxx>
#endif
#ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
#include <unotools/localfilehelper.hxx>
#endif

#ifndef _IODLGIMPL_HXX
#include "iodlg.hxx"
#endif
#ifndef _SVTOOLS_HRC
#include "svtools.hrc"
#endif
#ifndef _SVTOOLS_IODLGIMPL_HRC
#include "iodlg.hrc"
#endif

#ifndef _IODLGIMP_HXX
#include "iodlgimp.hxx"
#endif
#ifndef _SVTOOLS_INETTBC_HXX
#include "inettbc.hxx"
#endif
#ifndef _SVTOOLS_SVTUNO_HXX
#include "svtuno.hxx"
#endif
#ifndef _SVTOOLS_SVTDATA_HXX
#include "svtdata.hxx"
#endif
#ifndef _SVT_HELPID_HRC
#include "helpid.hrc"
#endif

#ifndef  _RTL_USTRING_HXX
#include <rtl/ustring.hxx>
#endif

#ifndef  _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTPROVIDERMANAGER_HPP_
#include <com/sun/star/ucb/XContentProviderManager.hpp>
#endif
#ifndef  _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERSUPPLIER_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderSupplier.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_COMMONFILEPICKERELEMENTIDS_HPP_
#include <com/sun/star/ui/dialogs/CommonFilePickerElementIds.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_EXTENDEDFILEPICKERELEMENTIDS_HPP_
#include <com/sun/star/ui/dialogs/ExtendedFilePickerElementIds.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_CONTROLACTIONS_HPP_
#include <com/sun/star/ui/dialogs/ControlActions.hpp>
#endif

#ifndef  _COM_SUN_STAR_UTIL_URL_HPP_
#include <com/sun/star/util/URL.hpp>
#endif
#ifndef  _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include <com/sun/star/uno/Exception.hpp>
#endif
#ifndef  _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef  _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif
#ifndef  _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif

#ifndef _OSL_FILE_H_
#include <osl/file.h>
#endif
#ifndef _SV_WAITOBJ_HXX
#include <vcl/waitobj.hxx>
#endif
#ifndef _UCBHELPER_CONTENT_HXX
#include <ucbhelper/content.hxx>
#endif


//#define AUTOSELECT_USERFILTER
	// define this for the experimental feature of user-filter auto selection
	// means if the user enters e.g. *.doc<enter>, and there is a filter which is responsible for *.doc files (only),
	// then this filter is selected automatically

using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ui::dialogs;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::ucb;
using namespace ::rtl;
using namespace ::utl;

sal_Bool SupportsLocalDir();

#define IODLG_CONFIGNAME		String(DEFINE_CONST_UNICODE("FileDialog"))
#define IMPGRF_CONFIGNAME		String(DEFINE_CONST_UNICODE("ImportGraphicDialog"))

#define GET_DECODED_NAME(aObj) \
	aObj.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET )

// Zeit die beim Traveln in der Filterbox gewartet wird,
// bis in der Browsebox gefiltert wird ( in ms ).
#define TRAVELFILTER_TIMEOUT	750

#define WIDTH_ADDITION	15

// functions -------------------------------------------------------------

namespace {

	//-----------------------------------------------------------------------------
	String getMostCurrentFilter( SvtExpFileDlg_Impl* pImpl )
	{
		DBG_ASSERT( pImpl, "invalid impl pointer" );
		const SvtFileDialogFilter_Impl* pFilter = pImpl->_pUserFilter;

		if ( !pFilter )
			pFilter = pImpl->GetCurFilter();

		// Filtern.
		if ( !pFilter )
			return String();

		return pFilter->GetType();
	}

	//-----------------------------------------------------------------------------
	sal_Bool restoreCurrentFilter( SvtExpFileDlg_Impl* _pImpl )
	{
		DBG_ASSERT( _pImpl->GetCurFilter(), "restoreCurrentFilter: no current filter!" );
		DBG_ASSERT( _pImpl->GetCurFilterDisplayName().Len(), "restoreCurrentFilter: no current filter (no display name)!" );

		_pImpl->SelectFilterListEntry( _pImpl->GetCurFilterDisplayName() );

#ifdef DBG_UTIL
		String sSelectedDisplayName;
		DBG_ASSERT(	( _pImpl->GetSelectedFilterEntry( sSelectedDisplayName ) == _pImpl->GetCurFilter() )
				&&	( sSelectedDisplayName == _pImpl->GetCurFilterDisplayName() ),
			"restoreCurrentFilter: inconsistence!" );
#endif
		return _pImpl->m_bNeedDelayedFilterExecute;
	}

	//-----------------------------------------------------------------------------
	String GetFsysExtension_Impl( const String& rFile )
	{
		const sal_Unicode* p0 = rFile.GetBuffer();
		const sal_Unicode* p1 = p0 + rFile.Len() - 1;
		while ( p1 >= p0 && *p1 != sal_Unicode( '.' ) )
			p1--;
		if ( p1 >= p0 )
			return String( rFile.Copy( p1 - p0 + 1 ) );
		return String();
	}

	//-----------------------------------------------------------------------------
	void SetFsysExtension_Impl( String& rFile, const String& rExtension )
	{
		const sal_Unicode* p0 = rFile.GetBuffer();
		const sal_Unicode* p1 = p0 + rFile.Len() - 1;
		while ( p1 >= p0 && *p1 != sal_Unicode( '.' ) )
			p1--;
		if ( p1 >= p0 )
			// remove old extension
			rFile.Erase( p1 - p0 + 1 - ( rExtension.Len() > 0 ? 0 : 1 ) );
		else if ( rExtension.Len() )
			// no old extension
			rFile += sal_Unicode( '.' );
		rFile += rExtension;
	}

	//-----------------------------------------------------------------------------
	sal_Bool IsFileURL( const String& rURL )
	{
		return ( INetURLObject::CompareProtocolScheme( rURL ) == INET_PROT_FILE );
	}

}

//***************************************************************************
// ControlChain_Impl
//***************************************************************************

struct ControlChain_Impl
{
	Window* 		   _pControl;
	ControlChain_Impl* _pNext;
	BOOL			   _bHasOwnerShip;

	ControlChain_Impl( Window* pControl, ControlChain_Impl* pNext, BOOL bFlag );
	~ControlChain_Impl();
};

//***************************************************************************

ControlChain_Impl::ControlChain_Impl
(
	Window* pControl,
	ControlChain_Impl* pNext,
	BOOL bHasOwnerShip
)
	: _pControl( pControl ),
	  _pNext( pNext ),
	  _bHasOwnerShip( TRUE )
{
}

//***************************************************************************

ControlChain_Impl::~ControlChain_Impl()
{
	if ( _bHasOwnerShip )
	{
		delete _pControl;
	}
	delete _pNext;
}

//*****************************************************************************
// SvtFileDialog
//*****************************************************************************

//*****************************************************************************

SvtFileDialog::SvtFileDialog
(
	ULONG nBits,
	ULONG nExtraBits
) :
	ModalDialog( NULL, SvtResId( DLG_SVT_EXPLORERFILE ) )

	,_pFileView( NULL )
	,_pCbReadOnly( NULL )
	,_pCbLinkBox( NULL)
    ,_pCbPreviewBox( NULL )
    ,_pCbSelection( NULL )
    ,_pPbPlay( NULL )
    ,_pPrevWin( NULL )
    ,_pPrevBmp( NULL )
	,_pImp( new SvtExpFileDlg_Impl( nBits ) )
	,_pFileNotifier( NULL )
    ,_nExtraBits( nExtraBits )
    ,_bIsInExecute( FALSE )
    ,_bIgnoreSelect( FALSE )
	,_pUserControls( NULL )
{
	Init_Impl( nBits );
}

//*****************************************************************************

SvtFileDialog::SvtFileDialog ( ULONG nBits )
    :ModalDialog( NULL, SvtResId( DLG_SVT_EXPLORERFILE ) )
	,_pFileView( NULL )
	,_pCbReadOnly( NULL )
	,_pCbLinkBox( NULL)
    ,_pCbPreviewBox( NULL )
    ,_pCbSelection( NULL )
    ,_pPbPlay( NULL )
    ,_pPrevWin( NULL )
    ,_pPrevBmp( NULL )
	,_pImp( new SvtExpFileDlg_Impl( nBits ) )
	,_pFileNotifier( NULL )
    ,_nExtraBits( 0L )
    ,_bIsInExecute( FALSE )
    ,_bIgnoreSelect( FALSE )
    ,_pUserControls( NULL )
{
	Init_Impl( nBits );
}

//*****************************************************************************

SvtFileDialog::~SvtFileDialog()
{
	if ( _pImp->_aIniKey.Len() )
	{
		SvtViewOptions aDlgOpt( E_DIALOG, _pImp->_aIniKey );

		// the size to store in the config
        Size aSize = _pImp->_aDlgSize;
	    if	(	_pPrevWin
			&&	( _pPrevWin->GetPosPixel().X() > _pFileView->GetPosPixel().X() )
			)
	    {
    	    long nWinDeltaW = _pPrevWin->GetOutputSizePixel().Width() + _pImp->_a6Size.Width();
            aSize.Width() -= nWinDeltaW;
	    }

		// need to build an own window state from _pImp->_aDlgSize instead of the WindowState provided
		// by VCL
		String sWindowState;
		sWindowState = String::CreateFromInt32( aSize.Width() );
		sWindowState += ',';
		sWindowState += String::CreateFromInt32( aSize.Height() );

		// and make persistent
        aDlgOpt.SetWindowState( sWindowState );
	}

	_pFileView->SetSelectHdl( Link() );

	delete _pImp;
	delete _pFileView;

	delete _pCbReadOnly;
	delete _pCbLinkBox;
    delete _pCbPreviewBox;
    delete _pCbSelection;
    delete _pPbPlay;
    delete _pPrevWin;
    delete _pPrevBmp;

	delete _pUserControls;
}

//*****************************************************************************

void SvtFileDialog::Init_Impl
(
	ULONG nStyle
)
{
	_pImp->_nStyle = nStyle;
	_pImp->_a6Size = LogicToPixel( Size( 6, 6 ), MAP_APPFONT );
	_pImp->_eMode = ( nStyle & WB_SAVEAS ) ? FILEDLG_MODE_SAVE : FILEDLG_MODE_OPEN;
	_pImp->_eDlgType = FILEDLG_TYPE_FILEDLG;

#ifdef FILTER_MRU_LIST
	m_bUseFilterCaching = ( FILEDLG_MODE_OPEN == _pImp->_eMode );
#endif

	if ( ( nStyle & SFXWB_PATHDIALOG ) == SFXWB_PATHDIALOG )
		_pImp->_eDlgType = FILEDLG_TYPE_PATHDLG;

	// Set the directory for the "back to the default dir" button
	INetURLObject aStdDirObj( SvtPathOptions().GetWorkPath() );
	SetStandardDir( aStdDirObj.GetMainURL( INetURLObject::NO_DECODE ) );

	// Reichweite bestimmen.
	if ( !( nStyle & SFXWB_NOREMOTE ) )
	{
		_pImp->_nState |= FILEDLG_STATE_REMOTE;
	}

	// Kontrollelement erzeugen, wobei die Reihenfolge die Tab-Steuerung
	// bestimmt.
	_pImp->_pFtFileName = new FixedText( this, SvtResId( FT_EXPLORERFILE_FILENAME ) );

    SvtURLBox* pURLBox = (SvtURLBox*)( _pImp->_pEdFileName = new SvtURLBox( this ) );
    Edit aDummy( this, SvtResId( ED_EXPLORERFILE_FILENAME ) );
    _pImp->_pEdFileName->SetPosSizePixel( aDummy.GetPosPixel(), aDummy.GetSizePixel() );
    _pImp->_pEdFileName->Show();
    pURLBox->SetSelectHdl( LINK( this, SvtFileDialog, EntrySelectHdl_Impl ) );
    pURLBox->SetOpenHdl( STATIC_LINK( this, SvtFileDialog, OpenHdl_Impl ) );
    // bei SaveAs oder im PfadDialog nur Verzeichnisse automatisch erg"anzen
    BOOL bOnlyDir = ( _pImp->_eMode != FILEDLG_MODE_OPEN ||
                        _pImp->_eDlgType == FILEDLG_TYPE_PATHDLG );
    pURLBox->SetOnlyDirectories( bOnlyDir );
    _pImp->_pEdFileName->SetHelpId( HID_FILEDLG_AUTOCOMPLETEBOX );

	_pImp->_pFtFileVersion = new FixedText(	this, SvtResId( FT_EXPLORERFILE_FILEVERSION ) );
    _pImp->_pFtFileVersion->SetText( SvtResId( STR_SVT_FILEPICKER_VERSION ) );
	_pImp->_pLbFileVersion = new ListBox( this, SvtResId( LB_EXPLORERFILE_FILEVERSION ) );
	_pImp->_pLbFileVersion->SetHelpId( HID_FILEOPEN_VERSION );

    _pImp->_pFtFileType = new FixedText( this, SvtResId( FT_EXPLORERFILE_FILETYPE ) );
	_pImp->CreateFilterListControl( this, SvtResId( LB_EXPLORERFILE_FILETYPE ) );

	// move the filter listbox to the space occupied by the version listbox
    // if that box isn't needed
    if ( !( _nExtraBits & SFX_EXTRA_SHOWVERSIONS ) &&
         !( _nExtraBits & SFX_EXTRA_TEMPLATES ) &&
         !( _nExtraBits & SFX_EXTRA_IMAGE_TEMPLATE ) )
	{
		_pImp->_pFtFileType->SetPosPixel( _pImp->_pFtFileVersion->GetPosPixel() );
		_pImp->GetFilterListControl()->SetPosPixel( _pImp->_pLbFileVersion->GetPosPixel() );
	}

	_pImp->_pFtCurrentPath = new FixedText( this, SvtResId( FT_EXPLORERFILE_CURRENTPATH ) );
    WinBits nTmpStyle = _pImp->_pFtCurrentPath->GetStyle();
    nTmpStyle |= WB_PATHELLIPSIS;
    _pImp->_pFtCurrentPath->SetStyle( nTmpStyle );

    _pImp->_pBtnFileOpen = new PushButton( this, SvtResId( BTN_EXPLORERFILE_OPEN ) );
	_pImp->_pBtnCancel = new CancelButton( this, SvtResId( BTN_EXPLORERFILE_CANCEL ) );
	_pImp->_pBtnHelp = new HelpButton( this, SvtResId( BTN_EXPLORERFILE_HELP ) );
	_pImp->_pBtnLocal = new PushButton( this, SvtResId( BTN_EXPLORERFILE_LOCAL ) );
	_pImp->_pBtnLocal->SetImage( SvtResId( IMG_FILEDLG_BTN_LOCAL ) );

	if ( IsFileURL( GetStandardDir() ) /* || ! SupportsLocalDir() */ ) // enable to fix #83785# when SupportsLocalDir() has been fixed
		_pImp->_pBtnLocal->Hide();
	else
	{
		_pImp->_pBtnLocal->SetClickHdl( LINK( this, SvtFileDialog, LocalFileSystemHdl_Impl ) );
	}

	_pImp->_pBtnUp = new SvtUpButton_Impl( this, SvtResId( BTN_EXPLORERFILE_UP ) );
	_pImp->_pBtnNewFolder = new ImageButton( this, SvtResId( BTN_EXPLORERFILE_NEWFOLDER ) );
	_pImp->_pBtnNewFolder->SetStyle( _pImp->_pBtnNewFolder->GetStyle() | WB_NOPOINTERFOCUS );
	_pImp->_pBtnStandard = new SvtTravelButton_Impl( this, SvtResId( BTN_EXPLORERFILE_STANDARD ) );

	if ( ( nStyle & SFXWB_MULTISELECTION ) == SFXWB_MULTISELECTION )
		_pImp->_bMultiSelection = TRUE;

	_pFileView = new SvtFileView( this, SvtResId( CTL_EXPLORERFILE_FILELIST ),
									   FILEDLG_TYPE_PATHDLG == _pImp->_eDlgType,
									   _pImp->_bMultiSelection );
	_pFileView->EnableAutoResize();

	_pFileView->SetHelpId( HID_FILEDLG_STANDARD );
	_pFileView->SetStyle( _pFileView->GetStyle() | WB_TABSTOP );

	// Positionen und Groessen der Knoepfe bestimmen.
	Image aNewFolderImg( SvtResId( IMG_FILEDLG_CREATEFOLDER ) );
	_pImp->_pBtnNewFolder->SetImage( aNewFolderImg );
	Size aSize( aNewFolderImg.GetSizePixel() );
	aSize.Width() += FILEDIALOG_DEF_IMAGEBORDER;
	aSize.Height() += FILEDIALOG_DEF_IMAGEBORDER;
	_pImp->_pBtnNewFolder->SetSizePixel( aSize );
	_pImp->_pBtnLocal->SetSizePixel( aSize );
	_pImp->_pBtnUp->SetSizePixel( aSize );
	_pImp->_pBtnStandard->SetSizePixel( aSize );

	Size aDlgSize = GetOutputSizePixel();
	long n6AppFontInPixel =
			LogicToPixel( Size( 6, 0 ), MAP_APPFONT ).Width();
	long n3AppFontInPixel =
			LogicToPixel( Size( 3, 0 ), MAP_APPFONT ).Width();
	// calculate the length of all buttons with little spacing to set the position of the first button "local dir"
	const USHORT nBtnCount = 4; // "local dir", "previous level", "new folder" and "standard dir"
	long nDelta = n6AppFontInPixel; // right border
	nDelta += ( nBtnCount * aSize.Width() ); // button count * button width
	nDelta += ( ( 2 * n3AppFontInPixel ) + ( n3AppFontInPixel / 2 ) ); // spacing 2*big 1*small
	Point aPos( _pImp->_pBtnLocal->GetPosPixel() );
	aPos.X() = aDlgSize.Width();
	aPos.X() -= nDelta;
	_pImp->_pBtnLocal->SetPosPixel( aPos );
	nDelta = aPos.X();
	nDelta -= ( n6AppFontInPixel * 2 );
	Size aCurPathSize( _pImp->_pFtCurrentPath->GetOutputSizePixel() );
	aCurPathSize.Width() = nDelta;
	_pImp->_pFtCurrentPath->SetOutputSizePixel( aCurPathSize );
	aPos.X() += aSize.Width();
	aPos.X() += n3AppFontInPixel;
	_pImp->_pBtnUp->SetPosPixel( aPos );
	aPos.X() += aSize.Width();
	aPos.X() += n3AppFontInPixel;
	_pImp->_pBtnNewFolder->SetPosPixel( aPos );
	aPos.X() += aSize.Width();
	aPos.X() += ( n3AppFontInPixel / 2 );
	_pImp->_pBtnStandard->SetPosPixel( aPos );
	nDelta = aSize.Height();
	nDelta -= aCurPathSize.Height();
	nDelta /= 2;
	Point aCurPathPos = _pImp->_pFtCurrentPath->GetPosPixel();
	aCurPathPos.Y() += nDelta;
	_pImp->_pFtCurrentPath->SetPosPixel( aCurPathPos );

	// Zahl der Pixel bestimmen, um die die anderen Elemente in der Position
	// Angepasst werden muessen.
	aPos.Y() += aSize.Height();
	aPos.Y() += LogicToPixel( Size( 0, 6 ), MAP_APPFONT ).Height();
	long nYOffset = aPos.Y();
	aPos = _pFileView->GetPosPixel();
	nYOffset -= aPos.Y();

	// Positionen der uebrigen Elemente anpassen.
	aPos.Y() += nYOffset;
	_pFileView->SetPosPixel( aPos );

	aPos = _pImp->_pFtFileName->GetPosPixel();
	aPos.Y() += nYOffset;
	_pImp->_pFtFileName->SetPosPixel( aPos );

	aPos = _pImp->_pEdFileName->GetPosPixel();
	aPos.Y() += nYOffset;
	_pImp->_pEdFileName->SetPosPixel( aPos );

	aPos = _pImp->_pFtFileVersion->GetPosPixel();
	aPos.Y() += nYOffset;
	_pImp->_pFtFileVersion->SetPosPixel( aPos );

	aPos = _pImp->_pLbFileVersion->GetPosPixel();
	aPos.Y() += nYOffset;
	_pImp->_pLbFileVersion->SetPosPixel( aPos );

	aPos = _pImp->_pFtFileType->GetPosPixel();
	aPos.Y() += nYOffset;
	_pImp->_pFtFileType->SetPosPixel( aPos );

	aPos = _pImp->GetFilterListControl()->GetPosPixel();
	aPos.Y() += nYOffset;
	_pImp->GetFilterListControl()->SetPosPixel( aPos );

	aPos = _pImp->_pBtnFileOpen->GetPosPixel();
	aPos.Y() += nYOffset;
	_pImp->_pBtnFileOpen->SetPosPixel( aPos );

	aPos = _pImp->_pBtnCancel->GetPosPixel();
	aPos.Y() += nYOffset;
	_pImp->_pBtnCancel->SetPosPixel( aPos );

	aPos = _pImp->_pBtnHelp->GetPosPixel();
	aPos.Y() += nYOffset + 3; // a little more spacing between Cancel- and HelpButton
	_pImp->_pBtnHelp->SetPosPixel( aPos );

	// Groesse des Dialoges anpassen.
	aSize = GetSizePixel();
	aSize.Height() += nYOffset;
	SetSizePixel( aSize );

	if ( nStyle & SFXWB_READONLY )
	{
		_pCbReadOnly = new CheckBox( this, SvtResId( CB_EXPLORERFILE_READONLY ) );
		_pCbReadOnly->SetHelpId( HID_FILEOPEN_READONLY );
        _pCbReadOnly->SetText( SvtResId( STR_SVT_FILEPICKER_READONLY ) );
		AddControl( _pCbReadOnly );
		ReleaseOwnerShip( _pCbReadOnly );
		_pCbReadOnly->SetClickHdl( LINK( this, SvtFileDialog, ClickHdl_Impl ) );
	}

    if ( nStyle & SFXWB_PASSWORD )
	{
		_pImp->_pCbPassword = new CheckBox( this, SvtResId( CB_EXPLORERFILE_PASSWORD ) );
	    _pImp->_pCbPassword->SetText( SvtResId( STR_SVT_FILEPICKER_PASSWORD ) );
		AddControl( _pImp->_pCbPassword );
		ReleaseOwnerShip( _pImp->_pCbPassword );
		_pImp->_pCbPassword->SetClickHdl( LINK( this, SvtFileDialog, ClickHdl_Impl ) );
	}

    // set the ini file for extracting the size
   	_pImp->_aIniKey = IODLG_CONFIGNAME;

    AddControls_Impl( );

	// Beschriftungen dem Modus anpassen.
	USHORT nResId = STR_EXPLORERFILE_OPEN;
	USHORT nButtonResId = 0;

	if ( nStyle & WB_SAVEAS )
	{
		nResId = STR_EXPLORERFILE_SAVE;
		nButtonResId = STR_EXPLORERFILE_BUTTONSAVE;
	}

	if ( ( nStyle & SFXWB_PATHDIALOG ) == SFXWB_PATHDIALOG )
	{
		_pImp->_pFtFileName->SetText( SvtResId( STR_PATHNAME ) );
		nResId = STR_PATHSELECT;
		nButtonResId = STR_BUTTONSELECT;
	}

	SetText( SvtResId( nResId ) );

	if ( nButtonResId )
		_pImp->_pBtnFileOpen->SetText( SvtResId( nButtonResId ) );

	if ( FILEDLG_TYPE_FILEDLG != _pImp->_eDlgType )
	{
		_pImp->_pFtFileType->Hide();
		_pImp->GetFilterListControl()->Hide();
	}
    if ( !( _nExtraBits & SFX_EXTRA_SHOWVERSIONS ) &&
         !( _nExtraBits & SFX_EXTRA_TEMPLATES ) &&
         !( _nExtraBits & SFX_EXTRA_IMAGE_TEMPLATE ) )
	{
		_pImp->_pFtFileVersion->Hide();
		_pImp->_pLbFileVersion->Hide();
	}

	// Einstellungen der Steuerelemente vornehmen.
	_pImp->_pBtnNewFolder->SetClickHdl( STATIC_LINK( this, SvtFileDialog, NewFolderHdl_Impl ) );
	_pImp->_pBtnFileOpen->SetClickHdl( STATIC_LINK( this, SvtFileDialog, OpenHdl_Impl ) );
	_pImp->SetFilterListSelectHdl( STATIC_LINK( this, SvtFileDialog, FilterSelectHdl_Impl ) );
	_pImp->_pEdFileName->SetGetFocusHdl( STATIC_LINK( this, SvtFileDialog, FileNameGetFocusHdl_Impl ) );
	_pImp->_pEdFileName->SetModifyHdl( STATIC_LINK( this, SvtFileDialog, FileNameModifiedHdl_Impl ) );
	_pFileView->SetSelectHdl( LINK( this, SvtFileDialog, SelectHdl_Impl ) );
	_pFileView->SetDoubleClickHdl( LINK( this, SvtFileDialog, DblClickHdl_Impl ) );
	_pFileView->SetOpenDoneHdl( LINK( this, SvtFileDialog, OpenDoneHdl_Impl ) );

	// Resourcen freigeben.
	FreeResource();

	// Timer fuer Filterbox Travel setzen
	_pImp->_aFilterTimer.SetTimeout( TRAVELFILTER_TIMEOUT );
	_pImp->_aFilterTimer.SetTimeoutHdl( STATIC_LINK( this, SvtFileDialog, FilterSelectHdl_Impl ) );

	if ( WB_SAVEAS & nStyle )
	{
		// different help ids if in save-as mode
		// 90744 - 09.08.2001 - frank.schoenheit@sun.com
		SetHelpId( HID_FILESAVE_DIALOG );

		_pImp->_pEdFileName->SetHelpId( HID_FILESAVE_FILEURL );
		_pImp->_pBtnLocal->SetHelpId( HID_FILESAVE_LOCALSYSTEM );
		_pImp->_pBtnFileOpen->SetHelpId( HID_FILESAVE_DOSAVE );
		_pImp->_pBtnNewFolder->SetHelpId( HID_FILESAVE_CREATEDIRECTORY );
		_pImp->_pBtnStandard->SetHelpId( HID_FILESAVE_DEFAULTDIRECTORY );
		_pImp->_pBtnUp->SetHelpId( HID_FILESAVE_LEVELUP );
		_pImp->_pLbFileVersion->SetHelpId( HID_FILESAVE_TEMPLATE );
		_pImp->GetFilterListControl()->SetHelpId( HID_FILESAVE_FILETYPE );
		_pFileView->SetHelpId( HID_FILESAVE_FILEVIEW );

		if ( _pImp->_pCbPassword ) _pImp->_pCbPassword->SetHelpId( HID_FILESAVE_SAVEWITHPASSWORD );
		if ( _pImp->_pCbAutoExtension ) _pImp->_pCbAutoExtension->SetHelpId( HID_FILESAVE_AUTOEXTENSION );
		if ( _pImp->_pCbOptions ) _pImp->_pCbOptions->SetHelpId( HID_FILESAVE_CUSTOMIZEFILTER );
		if ( _pCbSelection ) _pCbSelection->SetHelpId( HID_FILESAVE_SELECTION );
	}

	// correct the z-order of the controls
	implArrangeControls();
}

//*****************************************************************************

IMPL_STATIC_LINK( SvtFileDialog, NewFolderHdl_Impl, PushButton*, pBtn )
{
	INetURLObject aObj( pThis->_pFileView->GetViewURL() );
	String sFolderName = aObj.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET, RTL_TEXTENCODING_UTF8 );
    svtools::QueryFolderNameDialog aDlg( sFolderName, String( SvtResId( STR_SVT_NEW_FOLDER ) ) );
    sal_Bool bHandled = sal_False;

	while ( !bHandled )
	{
		if ( aDlg.Execute() == RET_OK )
			bHandled = pThis->_pFileView->CreateNewFolder( aDlg.GetName() );
		else
			bHandled = sal_True;
	}

	return 0;
}

//*****************************************************************************

IMPL_STATIC_LINK( SvtFileDialog, ViewHdl_Impl, ImageButton*, pBtn )
{
	return 0;
}

//*****************************************************************************
//-----------------------------------------------------------------------------
sal_Bool SvtFileDialog::createNewUserFilter( const String& _rNewFilter, sal_Bool _bAllowUserDefExt )
{
	// delete the old user filter and create a new one
	DELETEZ( _pImp->_pUserFilter );
	_pImp->_pUserFilter = new SvtFileDialogFilter_Impl( _rNewFilter, _rNewFilter );

	// remember the extension
	sal_Bool bIsAllFiles = _rNewFilter.EqualsAscii( FILEDIALOG_FILTER_ALL );
	if ( bIsAllFiles )
		EraseDefaultExt();
	else
		SetDefaultExt( _rNewFilter.Copy( 2 ) );
		// TODO: this is nonsense. In the whole file there are a lotta places where we assume that a user filter
		// is always "*.<something>". But changing this would take some more time than I have now ...
		// 05.12.2001 - 95486 - fs@openoffice.org

	// now, the default extension is set to the one of the user filter (or empty)
	// if the former is not allowed (_bAllowUserDefExt = <FALSE/>), we have to use the ext of the current filter
	// (if possible)
	sal_Bool bUseCurFilterExt = sal_True;
	String sUserFilter = _pImp->_pUserFilter->GetType();
	xub_StrLen nSepPos = sUserFilter.SearchBackward( '.' );
	if ( STRING_NOTFOUND != nSepPos )
	{
		String sUserExt = sUserFilter.Copy( nSepPos + 1 );
		if	(	( STRING_NOTFOUND == sUserExt.Search( '*' ) )
			&&	( STRING_NOTFOUND == sUserExt.Search( '?' ) )
			)
			bUseCurFilterExt = sal_False;
	}

	if ( !_bAllowUserDefExt || bUseCurFilterExt )
	{
		if ( _pImp->GetCurFilter( ) )
			SetDefaultExt( _pImp->GetCurFilter( )->GetType().Copy(2) );
		else
			EraseDefaultExt();
	}

	// outta here
	return bIsAllFiles;
}

namespace
{
	//-------------------------------------------------------------------------
	sal_Bool lcl_getHomeDirectory( const String& _rForURL, String& /* [out] */ _rHomeDir )
	{
		_rHomeDir.Erase();

		// now ask the content broker for a provider for this scheme
		//
		try
		{
			// get the content provider manager
			::ucb::ContentBroker* pBroker = ::ucb::ContentBroker::get();
			Reference< XContentProviderManager > xProviderManager;
			if ( pBroker )
				xProviderManager = pBroker->getContentProviderManagerInterface();

			//
			// get the provider for the current scheme
			Reference< XContentProvider > xProvider;
			if ( xProviderManager.is() )
				xProvider = xProviderManager->queryContentProvider( _rForURL );

			DBG_ASSERT( xProvider.is(), "lcl_getHomeDirectory: could not find a (valid) content provider for the current URL!" );
			Reference< XPropertySet > xProviderProps( xProvider, UNO_QUERY );
			if ( xProviderProps.is() )
			{
				Reference< XPropertySetInfo > xPropInfo = xProviderProps->getPropertySetInfo();
				const ::rtl::OUString sHomeDirPropertyName( RTL_CONSTASCII_USTRINGPARAM( "HomeDirectory" ) );
				if ( !xPropInfo.is() || xPropInfo->hasPropertyByName( sHomeDirPropertyName ) )
				{
					::rtl::OUString sHomeDirectory;
					xProviderProps->getPropertyValue( sHomeDirPropertyName ) >>= sHomeDirectory;
					_rHomeDir = sHomeDirectory;
				}
			}
		}
		catch( const Exception& )
		{
			DBG_ERROR( "lcl_getHomeDirectory: caught an exception!" );
		}
		return 0 < _rHomeDir.Len();
	}
}
//-----------------------------------------------------------------------------
#define FLT_NONEMPTY		0x0001
#define FLT_CHANGED			0x0002
#define FLT_USERFILTER		0x0004
#define FLT_ALLFILESFILTER	0x0008

//-----------------------------------------------------------------------------
sal_uInt16 SvtFileDialog::adjustFilter( const String& _rFilter )
{
	sal_uInt16 nReturn = 0;

	const sal_Bool bNonEmpty = ( _rFilter.Len() != 0 );
	if ( bNonEmpty )
	{
		nReturn |= FLT_NONEMPTY;

		sal_Bool bFilterChanged = sal_True;

		// search for a corresponding filter
		SvtFileDialogFilter_Impl* pFilter = FindFilter_Impl( _rFilter, FALSE, bFilterChanged );

#ifdef AUTOSELECT_USERFILTER
		// if we found a filter which without allowing multi-extensions -> select it
		if ( pFilter )
		{
			_pImp->SelectFilterListEntry( pFilter->GetName() );
			_pImp->SetCurFilter( pFilter );
		}
#endif // AUTOSELECT_USERFILTER

		// look for multi-ext filters if necessary
		if ( !pFilter )
			pFilter = FindFilter_Impl( _rFilter, TRUE, bFilterChanged );

		if ( bFilterChanged )
			nReturn |= FLT_CHANGED;

		if ( !pFilter )
		{
			nReturn |= FLT_USERFILTER;
			// no filter found : use it as user defined filter
#ifdef AUTOSELECT_USERFILTER
			if ( createNewUserFilter( _rFilter, sal_True ) )
#else
			if ( createNewUserFilter( _rFilter, sal_False ) )
#endif
			{	// it's the "all files" filter
				nReturn |= FLT_ALLFILESFILTER;

#ifdef AUTOSELECT_USERFILTER
				// select the "all files" entry
				String sAllFilesFilter( SvtResId( STR_FILTERNAME_ALL ) );
				if ( _pImp->HasFilterListEntry( sAllFilesFilter ) )
				{
					_pImp->SelectFilterListEntry( sAllFilesFilter );
					_pImp->SetCurFilter( _pImp->GetSelectedFilterEntry( sAllFilesFilter ) );
				}
				else
					_pImp->SetNoFilterListSelection( );	// there is no "all files" entry
#endif // AUTOSELECT_USERFILTER
			}
#ifdef AUTOSELECT_USERFILTER
			else
				_pImp->SetNoFilterListSelection( );
#endif // AUTOSELECT_USERFILTER
		}
	}

	return nReturn;
}

//-----------------------------------------------------------------------------
IMPL_STATIC_LINK( SvtFileDialog, OpenHdl_Impl, void*, pVoid )
{
	if ( pThis->_pImp->_bMultiSelection && pThis->_pFileView->GetSelectionCount() > 1 )
	{
		// bei Multiselektion spezielles Open
		pThis->OpenMultiSelection_Impl();
		return 0;
	}

	String aFileName;
    String aOldPath( pThis->_pFileView->GetViewURL() );
	if ( pThis->_pImp->_bDoubleClick || pThis->_pFileView->HasChildPathFocus() )
		// Selection done by doubleclicking in the view, get filename from the view
		aFileName = pThis->_pFileView->GetCurrentURL();

	if ( !aFileName.Len() )
	{
		// if an entry is selected in the view ....
		if ( pThis->_pFileView->GetSelectionCount() )
		{	// -> use this one. This will allow us to step down this folder
			// #i8928# - 2002-12-20 - fs@openoffice.org
			aFileName = pThis->_pFileView->GetCurrentURL();
		}
	}

	if ( !aFileName.Len() )
	{
		if ( pThis->_pImp->_eMode == FILEDLG_MODE_OPEN && pThis->_pImp->_pEdFileName->IsTravelSelect() )
			// OpenHdl called from URLBox; travelling through the list of URLs should not cause an opening
			return 0;		            // MBA->PB: seems to be called never ?!

		// get the URL from from the edit field ( if not empty )
		if ( pThis->_pImp->_pEdFileName->GetText().Len() )
		{
			String aText = pThis->_pImp->_pEdFileName->GetText();

			// did we reach the root?
			if ( !INetURLObject( aOldPath ).getSegmentCount() )
			{
				if ( ( aText.Len() == 2 && aText.EqualsAscii( ".." ) ) ||
					 ( aText.Len() == 3 && ( aText.EqualsAscii( "..\\" ) || aText.EqualsAscii( "../" ) ) ) )
					// don't go higher than the root
					return 0;
			}

#if defined( UNX ) || defined( FS_PRIV_DEBUG )
			if ( ( 1 == aText.Len() ) && ( '~' == aText.GetBuffer()[0] ) )
			{
				// go to the home directory
				if ( lcl_getHomeDirectory( pThis->_pFileView->GetViewURL(), aFileName ) )
					// in case we got a home dir, reset the text of the edit
					pThis->_pImp->_pEdFileName->SetText( String() );
			}
			if ( !aFileName.Len() )
#endif
			{
				// get url from autocomplete edit
        		aFileName = pThis->_pImp->_pEdFileName->GetURL();
			}
		}
		else if ( pVoid == pThis->_pImp->_pBtnFileOpen )
			// OpenHdl was called for the "Open" Button; if edit field is empty, use selected element in the view
			aFileName = pThis->_pFileView->GetCurrentURL();
	}

	// MBA->PB: ?!
	if ( !aFileName.Len() && pVoid == pThis->_pImp->_pEdFileName && pThis->_pImp->_pUserFilter )
	{
		DELETEZ( pThis->_pImp->_pUserFilter );
		return 0;
	}

	USHORT nLen = aFileName.Len();
	if ( !nLen )
	{
		// if the dialog was opened to select a folder, the last selected folder should be selected
		if( pThis->_pImp->_eDlgType == FILEDLG_TYPE_PATHDLG )
		{
			aFileName =	pThis->_pImp->_pFtCurrentPath->GetText();
			nLen = aFileName.Len();
		}
		else
			// no file selected !
			return 0;
	}

	// mark input as selected
	pThis->_pImp->_pEdFileName->SetSelection( Selection( 0, nLen ) );

	// if a path with wildcards is given, divide the string into path and wildcards
	String aFilter;
	if ( !pThis->IsolateFilterFromPath_Impl( aFileName, aFilter ) )
		return 0;

	// if a filter was retrieved, there were wildcards !
	sal_uInt16 nNewFilterFlags = pThis->adjustFilter( aFilter );
#if 0
	// FS: ???
	// seems that bWildCardOnly is always sal_False
	sal_Bool bWildCardOnly =	( 0 != ( nNewFilterFlags & FLT_NONEMPTY ) )
							&&	( _pImp->_pEdFileName->GetText().Len() == 0 );
#endif
	if ( nNewFilterFlags & FLT_CHANGED )
	{
		// cut off all text before wildcard in edit and select wildcard
		pThis->_pImp->_pEdFileName->SetText( aFilter );
		pThis->_pImp->_pEdFileName->SetSelection( Selection( 0, aFilter.Len() ) );
	}

	INetURLObject aFileObject( aFileName );

#if 0
	// Protokoll pruefen.
	INetProtocol eProt = aFileObject.GetProtocol();
	if	(	!bWildCardOnly
		&&	 ( eProt != INET_PROT_FILE )
		&&	!( pThis->_pImp->_nState & FILEDLG_STATE_REMOTE )
		)
	{
		// MBA->PB : ?!
		ErrorHandler::HandleError( ERRCODE_SFX_INVALIDSYNTAX );
		return 0;
	}
#endif

	// Pr"ufen, ob es sich um einen Ordner handelt.
    BOOL bFolder = FALSE;

    if ( aFileName.Len() )
        bFolder = UCBContentHelper::IsFolder( aFileName );

#if 0   // This should be handled by the ftp content provider itself.
        // The ftp content provider should display an error box, too if
        // there is no support for access via proxy

    // Pr"ufen, ob der Ordner als Textdarstellung angezeigt werden soll.
    if ( bFolder && INET_PROT_FTP == eProt )
    {
    	SvtInetOptions aInetOptions;
        if ( aInetOptions.ShouldUseFtpProxy( aFileName ) )
            bFolder = FALSE;
    }
#endif

    // wenn SpeichernUnter
	// und kein existierender Folder
	// und AutoExtensions an ist
	// und es eine Default-Extension gibt, die ungleich "*" ist
	if ( !bFolder && pThis->_pImp->_pCbAutoExtension &&
		 pThis->_pImp->_pCbAutoExtension->IsChecked() &&
		 pThis->GetDefaultExt().Len() && pThis->GetDefaultExt() != '*' )
	{
		// und diese nicht eh schon dran haengt
		String aExt = DEFINE_CONST_UNICODE("*.");
		INetURLObject aTemp( aFileName );
		aExt += aTemp.GetExtension().ToLowerAscii();
		const String& rType = pThis->_pImp->GetCurFilter()->GetType();
		String aType = rType;
		aType.ToLowerAscii();

		if ( ! aType.EqualsAscii(FILEDIALOG_FILTER_ALL) )
		{
			USHORT nWildCard = aType.GetTokenCount( FILEDIALOG_DEF_EXTSEP );
			USHORT nIndex, nPos = 0;

			for ( nIndex = 0; nIndex < nWildCard; nIndex++ )
			{
				if ( aExt == aType.GetToken( 0, FILEDIALOG_DEF_EXTSEP, nPos ) )
					break;
			}

			if ( nIndex >= nWildCard )
			{
				aFileName += '.';
				aFileName += pThis->GetDefaultExt();
			}
		}
	}

	BOOL bOpenFolder = ( FILEDLG_TYPE_PATHDLG == pThis->_pImp->_eDlgType ) &&
					   !pThis->_pImp->_bDoubleClick && pVoid != pThis->_pImp->_pEdFileName;
	if ( bFolder )
	{
		if ( aFileObject.GetMainURL( INetURLObject::NO_DECODE ) != pThis->_pFileView->GetViewURL() )
		{
			pThis->_bIgnoreSelect = TRUE;
			pThis->_pFileView->Initialize( aFileName, getMostCurrentFilter( pThis->_pImp ) );
			pThis->_bIgnoreSelect = FALSE;
			pThis->_pImp->_aViewURL = aFileName;
			pThis->_aPath = aFileName;

            pThis->UpdateControls( aFileName );
		}
		else if ( nNewFilterFlags & FLT_CHANGED )
			pThis->ExecuteFilter();

		if ( bOpenFolder )
		{
			pThis->_pImp->_aViewURL = aFileName;
			pThis->_aPath = aFileName;
		}
		else
			return 0;
	}
    else if ( !( nNewFilterFlags & FLT_NONEMPTY ) )
	{
		// Ggf. URL speichern.
        pThis->_aPath = aFileName;
	}
	else
	{
		// Ggf. neu filtern.
		if ( nNewFilterFlags & FLT_CHANGED )
			pThis->ExecuteFilter();
		return 0;
	}

    INetURLObject aFileObj( aFileName );
    if ( aFileObj.HasError() )
    {
        ErrorHandler::HandleError( ERRCODE_IO_GENERAL );
        return 0;
    }

	switch ( pThis->_pImp->_eMode )
	{
		case FILEDLG_MODE_SAVE:
		{
			if ( ::utl::UCBContentHelper::Exists( aFileObj.GetMainURL( INetURLObject::NO_DECODE ) ) )
			{
				QueryBox aBox( pThis, WB_YES_NO, SvtResId( STR_SVT_ALREADYEXISTOVERWRITE ) );
				if ( aBox.Execute() != RET_YES )
					return 0;
			}
			else
			{
				String aCurPath;
				if ( ::utl::LocalFileHelper::ConvertURLToSystemPath( aFileName, aCurPath ) )
				{
					// if content does not exist: at least its path must exist
					INetURLObject aPathObj = aFileObj;
					aPathObj.removeSegment();
					BOOL bFolder = UCBContentHelper::IsFolder( aPathObj.GetMainURL( INetURLObject::NO_DECODE ) );
					if ( !bFolder )
					{
						ErrorHandler::HandleError( ERRCODE_IO_NOTEXISTSPATH );
						return 0;
					}
				}
			}
		}
		break;

		case FILEDLG_MODE_OPEN:
		{
			// do an existence check herein, again
			// 16.11.2001 - 93107 - frank.schoenheit@sun.com

			if ( INET_PROT_FILE == aFileObj.GetProtocol( ) )
			{
				sal_Bool bExists = sal_False;
				try
				{
					::ucb::Content aExistenceCheck( aFileObj.GetMainURL( INetURLObject::NO_DECODE ), Reference< XCommandEnvironment >() );
					bExists = aExistenceCheck.isDocument() || aExistenceCheck.isFolder();
				}
				catch( const Exception& )
				{
				}

				if ( !bExists )
				{
					String sError( SvtResId( RID_FILEOPEN_NOTEXISTENTFILE ) );

					String sInvalidFile( aFileObj.GetMainURL( INetURLObject::DECODE_TO_IURI ) );
					if ( INET_PROT_FILE == aFileObj.GetProtocol() )
					{	// if it's a file URL, transform the URL into system notation
						::rtl::OUString sURL( sInvalidFile );
						::rtl::OUString sSystem;
						osl_getSystemPathFromFileURL( sURL.pData, &sSystem.pData );
						sInvalidFile = sSystem;
					}
					sError.SearchAndReplaceAscii( "$name$", sInvalidFile );

					ErrorBox aError( pThis, WB_OK, sError );
					aError.Execute();
					return 0;
				}
			}
		}
		break;

		default:
			DBG_ERROR("SvtFileDialog, OpenHdl_Impl: invalid mode!");
	}

	// Interessenten benachrichtigen.
	long nRet;

	if ( pThis->_aOKHdl.IsSet() )
		nRet = pThis->_aOKHdl.Call( pThis );
	else
		nRet = pThis->OK();

	if ( nRet )
	{
		pThis->UpdateHistory_Impl();
		pThis->EndDialog( TRUE );
	}

	return nRet;
}

//*****************************************************************************

IMPL_STATIC_LINK( SvtFileDialog, FilterSelectHdl_Impl, ListBox*, pBox )
{
	DBG_ASSERT( pBox, "SvtFileDialog:keine Instanz" );

	// wurde der Handler vom Travel-Timer gefeuert?
	if ( pBox == (ListBox*)&pThis->_pImp->_aFilterTimer )
	{
		// Anzeige erneut filtern.
		pThis->ExecuteFilter();
		return 0;
	}

	String sSelectedFilterDisplayName;
	SvtFileDialogFilter_Impl* pSelectedFilter = pThis->_pImp->GetSelectedFilterEntry( sSelectedFilterDisplayName );
	if ( !pSelectedFilter )
	{	// there is no current selection. This happens if for instance the user selects a group separator using
		// the keyboard, and then presses enter: When the selection happens, we immediately deselect the entry,
		// so in this situation there is no current selection.
		if ( restoreCurrentFilter( pThis->_pImp ) )
			pThis->ExecuteFilter();
	}
	else
	{
		if ( pSelectedFilter->isGroupSeparator() )
		{	// group separators can't be selected
			// return to the previously selected entry
			if ( pThis->_pImp->IsFilterListTravelSelect() )
			{
				pThis->_pImp->SetNoFilterListSelection( );

				// stop the timer for executing the filter
				if ( pThis->_pImp->_aFilterTimer.IsActive() )
					pThis->_pImp->m_bNeedDelayedFilterExecute = sal_True;
				pThis->_pImp->_aFilterTimer.Stop();
			}
			else
			{
				if ( restoreCurrentFilter( pThis->_pImp ) )
					pThis->ExecuteFilter();
			}
		}
		else if	(	( pSelectedFilter != pThis->_pImp->GetCurFilter() )
				||	pThis->_pImp->_pUserFilter
				)
		{
			// Ggf. Filter des Benutzers entfernen.
			DELETEZ( pThis->_pImp->_pUserFilter );
			pThis->_pImp->SetCurFilter( pSelectedFilter, sSelectedFilterDisplayName );

			// Ggf. Endung anzeigen.
			const String& rType = pSelectedFilter->GetType();
			pThis->SetDefaultExt( rType.Copy( 2 ) );
			USHORT nSepPos = pThis->GetDefaultExt().Search( FILEDIALOG_DEF_EXTSEP );

			if ( nSepPos != STRING_NOTFOUND )
				pThis->EraseDefaultExt( nSepPos );

			// beim Speichern
			// und automatischer Dateinamenserweiterung...
			if ( pThis->_pImp->_pCbAutoExtension &&
				 pThis->_pImp->_pCbAutoExtension->IsChecked())
			{
				// Dateiextension beim Filterwechsel anpassen
				String aNewFile = pThis->_pImp->_pEdFileName->GetText();
				String aExt = GetFsysExtension_Impl( aNewFile );

				// aber nur wenn bereits eine Endung vorhanden ist
				if ( aExt.Len() )
				{
					SetFsysExtension_Impl( aNewFile, pThis->GetDefaultExt() );
					pThis->_pImp->_pEdFileName->SetText( aNewFile );
				}
			}

			// wenn der Benutzer schnell durch die Filterbox
			// travelt, nicht sofort Filtern
			if ( pThis->_pImp->IsFilterListTravelSelect() )
			{
				// FilterSelectHdl_Impl soll in
				// TRAVELFILTER_TIMEOUT ms neu gefeuert werden
				pThis->_pImp->_aFilterTimer.Start();
			}
			else
			{
				// evtl. vorher gestarteten Timer stoppen
				pThis->_pImp->_aFilterTimer.Stop();

				// Anzeige erneut filtern.
				pThis->ExecuteFilter();
			}
		}
	}

	return 0;
}

//*****************************************************************************

IMPL_STATIC_LINK( SvtFileDialog, FileNameGetFocusHdl_Impl, void*, EMPTYARG )
{
	pThis->_pFileView->SetNoSelection();
	pThis->_pFileView->Update();
	return 0;
}

//*****************************************************************************

IMPL_STATIC_LINK( SvtFileDialog, FileNameModifiedHdl_Impl, void*, EMPTYARG )
{
	FileNameGetFocusHdl_Impl( pThis, NULL );
	return 0;
}

//*****************************************************************************

SvtFileDialogFilter_Impl* SvtFileDialog::FindFilter_Impl
(
	const String& _rFilter,
	sal_Bool _bMultiExt,/*	TRUE - auch Filter mit mehreren Endungen
							beruecksichtigen
							FALSE - keine ...
						*/
	sal_Bool& _rFilterChanged
)

/*	[Beschreibung]

	Die Methode sucht in den eingef"ugten Filtern nach der
	spezifizierten Endung.
*/

{
	SvtFileDialogFilter_Impl* pFoundFilter = NULL;
	SvtFileDialogFilterList_Impl* pList = _pImp->_pFilter;
	USHORT nFilter = pList->Count();

	while ( nFilter-- )
	{
		SvtFileDialogFilter_Impl* pFilter = pList->GetObject( nFilter );
		const String& rType = pFilter->GetType();
		String aSingleType = rType;
		USHORT nWildCard = rType.GetTokenCount(	FILEDIALOG_DEF_EXTSEP );

		if ( _bMultiExt )
		{
			USHORT nIdx = 0;
			while ( !pFoundFilter && nIdx != STRING_NOTFOUND )
			{
				aSingleType = rType.GetToken( 0, FILEDIALOG_DEF_EXTSEP, nIdx );
#ifdef UNX
				if ( aSingleType.CompareTo( _rFilter ) == COMPARE_EQUAL )
#else
				if ( aSingleType.CompareIgnoreCaseToAscii( _rFilter ) == COMPARE_EQUAL )
#endif
					pFoundFilter = pFilter;
			}
		}
#ifdef UNX
		else if ( rType.CompareTo( _rFilter ) == COMPARE_EQUAL )
#else
		else if ( rType.CompareIgnoreCaseToAscii( _rFilter ) == COMPARE_EQUAL )
#endif
			pFoundFilter = pFilter;

		if ( pFoundFilter )
		{
			// Filter aktivieren.
			_rFilterChanged = _pImp->_pUserFilter || ( _pImp->GetCurFilter() != pFilter );
			
			createNewUserFilter( _rFilter, sal_False );

			break;
		}
	}
	return pFoundFilter;
}

//*****************************************************************************

void SvtFileDialog::ExecuteFilter()
{
	_pImp->m_bNeedDelayedFilterExecute = sal_False;

	// preserve the filename (FS: why?)
	String aFileName = _pImp->_pEdFileName->GetText();

	{
		WaitObject aWaitCursor( this );
		_pFileView->ExecuteFilter( getMostCurrentFilter( _pImp ) );
	}

	// restore the filename
	_pFileView->SetNoSelection();
	_pImp->_pEdFileName->SetText( aFileName );
	_pImp->_pEdFileName->SetSelection( Selection( 0, aFileName.Len() ) );

	// notify listeners
	FilterSelect();
}

//*****************************************************************************

void SvtFileDialog::UpdateHistory_Impl()

/*	[Desription]

	This method forwards the update of the folder history
	to the favorites button.
*/

{
//!	_pImp->_pBtnStandard->UpdateHistory();
}

//*****************************************************************************

void SvtFileDialog::OpenMultiSelection_Impl()

/*	[Beschreibung]

	OpenHandler f"ur MultiSelektion
*/

{
	String aPath;
	ULONG nCount = _pFileView->GetSelectionCount();
	SvLBoxEntry* pEntry = nCount ? _pFileView->FirstSelected() : NULL;

	if ( nCount && pEntry )
		_aPath = _pFileView->GetURL( pEntry );

	// Interessenten benachrichtigen.
	long nRet;

	if ( _aOKHdl.IsSet() )
		nRet = _aOKHdl.Call( this );
	else
		nRet = OK();

	if ( nRet )
	{
		delete _pImp->_pPathList;
		_pImp->_pPathList = new SvStringsDtor;

		while ( pEntry )
		{
			String* pURL = new String( _pFileView->GetURL( pEntry ) );
			_pImp->_pPathList->Insert( pURL, _pImp->_pPathList->Count() );
            pEntry = _pFileView->NextSelected( pEntry );
		}
		UpdateHistory_Impl();
		EndDialog( TRUE );
	}
}

//*****************************************************************************

void SvtFileDialog::UpdateControls( const String& rURL )
{
   	_pImp->_pEdFileName->SetBaseURL( rURL );

	INetURLObject aObj( rURL );

	//
	{
		String sText;
		DBG_ASSERT( INET_PROT_NOT_VALID != aObj.GetProtocol(), "SvtFileDialog::UpdateControls: Invalid URL!" );

		if ( aObj.getSegmentCount() )
		{
			::utl::LocalFileHelper::ConvertURLToSystemPath( rURL, sText );
			if ( sText.Len() )
			{
				// no Fsys path for server file system ( only UCB has mountpoints! )
				if ( INET_PROT_FILE != aObj.GetProtocol() )
					sText = rURL.Copy( INetURLObject::GetScheme( aObj.GetProtocol() ).Len() );
			}

			if ( !sText.Len() && aObj.getSegmentCount() )
				sText = rURL;
		}

		// path mode ?
		if ( FILEDLG_TYPE_PATHDLG == _pImp->_eDlgType )
			// -> set new path in the edit field
			_pImp->_pEdFileName->SetText( sText );

		// in the "current path" field, truncate the trailing slash
		if ( aObj.hasFinalSlash() )
		{
			aObj.removeFinalSlash();
			String sURL( aObj.GetMainURL( INetURLObject::NO_DECODE ) );
			if ( !::utl::LocalFileHelper::ConvertURLToSystemPath( sURL, sText ) )
				sText = sURL;
		}

		_pImp->_pFtCurrentPath->SetText( sText );
	}

	//
    if ( aObj.GetProtocol() == INET_PROT_FILE )
    {
        _pImp->_aToggleURLLocal = rURL;
        _pImp->_pBtnLocal->SetPressed( TRUE );
    }
    else
    {
        _pImp->_aToggleURLRemote = rURL;
        _pImp->_pBtnLocal->SetPressed( FALSE );
    }

	//
    _aPath = rURL;
    if ( _pFileNotifier )
		_pFileNotifier->Notify( DIRECTORY_CHANGED, 0 );
}

//*****************************************************************************

IMPL_LINK( SvtFileDialog, SelectHdl_Impl, SvTabListBox*, pBox )
{
    if ( _bIgnoreSelect )
        return 0;

	SvLBoxEntry* pEntry = pBox->FirstSelected();
	DBG_ASSERT( pEntry, "SelectHandler without selected entry" );
	SvtContentEntry* pUserData = (SvtContentEntry*)pEntry->GetUserData();

	if ( pUserData )
	{
		INetURLObject aObj( pUserData->maURL );
		if ( FILEDLG_TYPE_PATHDLG == _pImp->_eDlgType )
		{
			if ( aObj.GetProtocol() == INET_PROT_FILE )
			{
				if ( !pUserData->mbIsFolder )
					aObj.removeSegment();
				String aName = aObj.getFSysPath( (INetURLObject::FSysStyle)(INetURLObject::FSYS_DETECT & ~INetURLObject::FSYS_VOS) );
				_pImp->_pEdFileName->SetText( aName );
				_pImp->_pEdFileName->SetSelection( Selection( 0, aName.Len() ) );
				_aPath = pUserData->maURL;
			}
			else if ( !pUserData->mbIsFolder )
			{
				_pImp->_pEdFileName->SetText( pUserData->maURL );
				_pImp->_pEdFileName->SetSelection( Selection( 0, pUserData->maURL.Len() ) );
				_aPath = pUserData->maURL;
			}
			else
				_pImp->_pEdFileName->SetText( UniString() );
			_pImp->_aViewURL = pUserData->maURL;
		}
		else
		{
			if ( !pUserData->mbIsFolder )
			{
				String aName = pBox->GetEntryText( pEntry, 0 );
				_pImp->_pEdFileName->SetText( aName );
				_pImp->_pEdFileName->SetSelection( Selection( 0, aName.Len() ) );
				_aPath = pUserData->maURL;
			}
		}
	}

	if ( _pImp->_bMultiSelection && _pFileView->GetSelectionCount() > 1 )
	{
		// bei Multiselektion den Datei-Edit leeren
		_pImp->_pEdFileName->SetText( String() );
	}

	FileSelect();

	return 0;
}

//*****************************************************************************

IMPL_LINK( SvtFileDialog, DblClickHdl_Impl, SvTabListBox*, EMPTYARG )
{
	_pImp->_bDoubleClick = TRUE;
	OpenHdl_Impl( this, NULL );
	_pImp->_bDoubleClick = FALSE;

	return 0;
}

//*****************************************************************************

IMPL_LINK( SvtFileDialog, EntrySelectHdl_Impl, ComboBox*, EMPTYARG )
{
	FileSelect();

    return 0;
}

//*****************************************************************************

IMPL_LINK( SvtFileDialog, OpenDoneHdl_Impl, SvtFileView*, pView )
{
	_pImp->_aCWD = pView->GetViewURL();
	_pImp->_pBtnUp->Enable( ::utl::UCBContentHelper::HasParentFolder( _pImp->_aCWD ) );
	_pImp->_pBtnNewFolder->Enable( ::utl::UCBContentHelper::CanMakeFolder( _pImp->_aCWD ) );

	return 0;
}

//*****************************************************************************

IMPL_LINK( SvtFileDialog, LocalFileSystemHdl_Impl, PushButton*, EMPTYARG )
{
	// pressed status of the button
	BOOL bPressed = _pImp->_pBtnLocal->IsPressed();

    String aURL = _pFileView->GetViewURL();
    if ( INetURLObject( aURL ).GetProtocol() == INET_PROT_FILE )
        OpenURL_Impl( _pImp->_aToggleURLRemote );
    else
        OpenURL_Impl( _pImp->_aToggleURLLocal );

	// pressed status of the button toggles
	_pImp->_pBtnLocal->SetPressed( !bPressed );
	return 0;
}

//*****************************************************************************

IMPL_LINK( SvtFileDialog, AutoExtensionHdl_Impl, CheckBox*, EMPTYARG )
{
	if ( _pFileNotifier )
		_pFileNotifier->Notify( CTRL_STATE_CHANGED,
                                ExtendedFilePickerElementIds::CHECKBOX_AUTOEXTENSION );

	if ( _pImp->_pCbAutoExtension && _pImp->_pCbAutoExtension->IsChecked() )
	{
		// update extension
		String aNewFile = _pImp->_pEdFileName->GetText();
		String aExt = GetFsysExtension_Impl( aNewFile );

		// only when an extension exists
		if ( aExt.Len() )
		{
			SetFsysExtension_Impl( aNewFile, GetDefaultExt() );
			_pImp->_pEdFileName->SetText( aNewFile );
		}
	}

    return 0;
}

//*****************************************************************************

IMPL_LINK( SvtFileDialog, ClickHdl_Impl, CheckBox*, pCheckBox )
{
    if ( ! _pFileNotifier )
        return 0;

    sal_Int16 nId = -1;

    if ( pCheckBox == _pImp->_pCbOptions )
        nId = ExtendedFilePickerElementIds::CHECKBOX_FILTEROPTIONS;
    else if ( pCheckBox == _pCbSelection )
        nId = ExtendedFilePickerElementIds::CHECKBOX_SELECTION;
    else if ( pCheckBox == _pCbReadOnly )
        nId = ExtendedFilePickerElementIds::CHECKBOX_READONLY;
    else if ( pCheckBox == _pImp->_pCbPassword )
        nId = ExtendedFilePickerElementIds::CHECKBOX_PASSWORD;
    else if ( pCheckBox == _pCbLinkBox )
        nId = ExtendedFilePickerElementIds::CHECKBOX_LINK;
    else if ( pCheckBox == _pCbPreviewBox )
        nId = ExtendedFilePickerElementIds::CHECKBOX_PREVIEW;

	if ( nId != -1 )
        _pFileNotifier->Notify( CTRL_STATE_CHANGED, nId );

    return 0;
}

//*****************************************************************************

IMPL_LINK( SvtFileDialog, PlayButtonHdl_Impl, PushButton*, EMPTYARG )
{
    if ( _pFileNotifier )
        _pFileNotifier->Notify( CTRL_STATE_CHANGED,
                                ExtendedFilePickerElementIds::PUSHBUTTON_PLAY );

    return 0;
}

//*****************************************************************************

long SvtFileDialog::Notify( NotifyEvent& rNEvt )

/*	[Beschreibung]

	Die Methode wird gerufen, <BACKSPACE> abzufangen.
*/

{
	USHORT nType = rNEvt.GetType();
	long nRet = 0;

	if ( EVENT_KEYINPUT == nType && rNEvt.GetKeyEvent() )
	{
		const KeyCode& rKeyCode = rNEvt.GetKeyEvent()->GetKeyCode();
		USHORT nCode = rKeyCode.GetCode();

		if ( !rKeyCode.GetModifier() &&
			 KEY_BACKSPACE == nCode && !_pImp->_pEdFileName->HasChildPathFocus() )
		{
			nRet = 0; //! (long)_pFileView->DoBeamerKeyInput( *rNEvt.GetKeyEvent() );

			if ( !nRet && _pImp->_pBtnUp->IsEnabled() )
			{
				PrevLevel_Impl();
				nRet = 1;
			}
		}
//		else if ( rKeyCode.IsMod1() && ( KEY_C == nCode || KEY_V == nCode || KEY_X == nCode ) )
//		{
/* (mhu)
			String aVerb = KEY_C == nCode ? DEFINE_CONST_UNICODE(SVT_MENUPART_VERB_COPY) :
				( KEY_V == nCode ? DEFINE_CONST_UNICODE(SVT_MENUPART_VERB_PASTE) : DEFINE_CONST_UNICODE(SVT_MENUPART_VERB_CUT) );
//(dv)			if ( !CntPopupMenu::DoVerbCommand( aVerb, _pFileView->GetView() ) )
//(dv)				Sound::Beep();
*/
//		}
	}
	return nRet ? nRet : ModalDialog::Notify( rNEvt );
}

//*****************************************************************************

long SvtFileDialog::OK()
{
	return TRUE;
}

//*****************************************************************************

class SvtDefModalDialogParent_Impl
{
private:
	Window*	_pOld;

public:
	SvtDefModalDialogParent_Impl( Window *pNew ) :
		_pOld( Application::GetDefDialogParent() )
		{ Application::SetDefDialogParent( pNew ); }

	~SvtDefModalDialogParent_Impl() { Application::SetDefDialogParent( _pOld ); }
};

//*****************************************************************************

namespace
{
	//---------------------------------------------------------------------
	static String lcl_ensureFinalSlash( const String& _rDir )
	{
		INetURLObject aWorkPathObj( _rDir, INET_PROT_FILE );
		aWorkPathObj.setFinalSlash();
		return  aWorkPathObj.GetMainURL( INetURLObject::NO_DECODE );
	}

	//---------------------------------------------------------------------
	/// checks a path for existence, returns a existent path (in all concience)
	static String lcl_checkExistence( const String& _rPath, const String& _rFallback, Window* _pMessageParent )
	{
		String sPath( _rPath );
		if ( !UCBContentHelper::Exists( sPath ) )
		{
			INetURLObject aURLParser( sPath, INET_PROT_FILE );

			sal_Bool bErrorMessage = sal_True;
			if ( 1 < aURLParser.getSegmentCount() )
			{	// if the path has more than one segment .....
				if ( !aURLParser.hasFinalSlash() && aURLParser.hasExtension() )
				{	// ... and no final slash, but an extension (we assume it's intended to be a file) ....
					aURLParser.removeSegment( );
					aURLParser.setFinalSlash( );
					// ... we check the path above the given one for existence
					if ( UCBContentHelper::IsFolder( aURLParser.GetMainURL( INetURLObject::NO_DECODE ) ) )
					{	// only the file itself does not exist, but the parent folder does
						// -> no need to display an error message
						bErrorMessage = sal_False;
					}
				}
			}
			if ( bErrorMessage )
			{
				// display an error message
				String sError( SvtResId( RID_FILEOPEN_INVALIDFOLDER ) );
				::rtl::OUString sInvalidPath = sPath;
				// if it's a file URL, transform the URL into system notation
				if ( INET_PROT_FILE == aURLParser.GetProtocol() )
				{
					::rtl::OUString aURL( aURLParser.GetMainURL( INetURLObject::DECODE_TO_IURI ) );
					osl_getSystemPathFromFileURL( aURL.pData, &sInvalidPath.pData );
				}
				sError.SearchAndReplaceAscii( "$name$", sInvalidPath );

				// show the error
				ErrorBox aError( _pMessageParent, WB_OK, sError );
				aError.Execute();

				// default the directory
				String sStandard = lcl_ensureFinalSlash( _rFallback );
				if ( sStandard == lcl_ensureFinalSlash( sPath ) )
				{
					// oops ... it was the standard dir itself which does not exist ...
					// as a fallback, get the user directory
					sPath = lcl_ensureFinalSlash( SvtPathOptions().SubstituteVariable( String::CreateFromAscii( "$(USERURL)" ) ) );
				}
				else
					sPath = sStandard;
			}
		}
		return sPath;
	}
	//---------------------------------------------------------------------
	/// checks a path for existence, returns a existent path (in all concience)
	static String lcl_convertToURL( const String& _rPath, const String& _rFallback )
	{
		String aPath( _rPath );

		// an URL parser for the fallback
		INetURLObject aURLParser( _rFallback );
		aURLParser.setFinalSlash();

		// set the path
		bool bWasAbsolute = FALSE;
		aURLParser = aURLParser.smartRel2Abs( aPath, bWasAbsolute );
		aPath = aURLParser.GetMainURL( INetURLObject::NO_DECODE );

		// is it am existent folder?
		if ( UCBContentHelper::IsFolder( aPath ) )
		{	// yes -> ensure that it has a trailing slash
			aURLParser.setFinalSlash();
			aPath = aURLParser.GetMainURL( INetURLObject::NO_DECODE );
		}

		// outta here
		return aPath;
	}
}

short SvtFileDialog::Execute()
{
	// #53016# evtl. nur ein Filename ohne Pfad?
	String aFileNameOnly;
	if( _aPath.Len() && (_pImp->_eMode == FILEDLG_MODE_SAVE)
					 && (_aPath.Search(':') == STRING_NOTFOUND)
					 && (_aPath.Search('\\') == STRING_NOTFOUND)
					 && (_aPath.Search('/') == STRING_NOTFOUND))
	{
		aFileNameOnly = _aPath;
		_aPath.Erase();
	}

	// im Pfaddialog nur File-Protokoll g"ultig
	if ( FILEDLG_TYPE_PATHDLG == _pImp->_eDlgType )
	{
		if ( _aPath.Len() )
		{
			INetURLObject aTemp;
			aTemp.SetSmartURL( _aPath );
			if ( aTemp.GetProtocol() != INET_PROT_FILE )
				_aPath.Erase();
		}

		if ( !_aPath.Len() && _pImp->_aPathURL.Len() )
			_aPath = _pImp->_aPathURL;
	}

	// kein Startpfad angegeben?
	sal_Bool bImplicitStartPath = sal_False;
	if ( !_aPath.Len() )
	{
		// dann das Standard-Dir verwenden
		_aPath = lcl_ensureFinalSlash( _pImp->GetStandardDir() );

		// #53016# vorgegebener Dateiname an Pfad anh"angen
		if ( aFileNameOnly.Len() )
			_aPath += aFileNameOnly;

		bImplicitStartPath = sal_True;
	}

	//.....................................................................
	// convert input (_aPath) to url
	_aPath = lcl_convertToURL( _aPath, GetStandardDir() );

	//.....................................................................
	// if the caller gave us a start path, and this path does not exist, show an error message
	if ( !bImplicitStartPath )
		_aPath = lcl_checkExistence( _aPath, _pImp->GetStandardDir(), GetParent() );

	// Ggf. Filter anzeigen.
	_pImp->InitFilterList();

	// Initialen Filter einstellen.
	USHORT nFilterCount = GetFilterCount();
	String aAll( SvtResId( STR_FILTERNAME_ALL ) );
	BOOL bHasAll = _pImp->HasFilterListEntry( aAll );
	if ( _pImp->GetCurFilter() || nFilterCount == 1 || ( nFilterCount == 2 && bHasAll ) )
	{
		// Ggf. einzigen Filter als aktuellen Filter setzen oder den einzigen
		// Filter, der nicht auf alle Dateien verweist.
		if ( !_pImp->GetCurFilter() )
		{
			USHORT nPos = 0;
			if ( 2 == nFilterCount && bHasAll )
			{
				nPos = nFilterCount;
				while ( nPos-- )
				{
					if ( GetFilterName( nPos ) != aAll )
						break;
				}
			}
			SvtFileDialogFilter_Impl* pNewCurFilter = _pImp->_pFilter->GetObject( nPos );
			DBG_ASSERT( pNewCurFilter, "SvtFileDialog::Execute: invalid filter pos!" );
			_pImp->SetCurFilter( pNewCurFilter, pNewCurFilter->GetName() );
		}

		// Anzeige anpassen.
		_pImp->SelectFilterListEntry( _pImp->GetCurFilter()->GetName() );
		String aType( _pImp->GetCurFilter()->GetType() );
		SetDefaultExt( aType.Copy( 2 ) );
		USHORT nSepPos = GetDefaultExt().Search( FILEDIALOG_DEF_EXTSEP );
		if ( nSepPos != STRING_NOTFOUND )
			EraseDefaultExt( nSepPos );
	}
	else
	{
		// Ggf. Filter fuer alle Dateien setzen bzw. erzeugen.
		if ( !bHasAll )
		{
			SvtFileDialogFilter_Impl* pAllFilter = implAddFilter( aAll, DEFINE_CONST_UNICODE(FILEDIALOG_FILTER_ALL) );
			_pImp->InsertFilterListEntry( pAllFilter );
			_pImp->SetCurFilter( pAllFilter, aAll );
		}
		_pImp->SelectFilterListEntry( aAll );
	}

	_pImp->_pDefaultFilter = _pImp->GetCurFilter();

	// HACK #50065#
	// ggf. Filter isolieren.
	String aFilter;

	if ( !IsolateFilterFromPath_Impl( _aPath, aFilter ) )
		return 0;

	sal_uInt16 nNewFilterFlags = adjustFilter( aFilter );
	if ( nNewFilterFlags & ( FLT_NONEMPTY | FLT_USERFILTER ) )
	{
		_pImp->_pEdFileName->SetText( aFilter );
	}
	// HACK #50065#

	// Instanz fuer den gesetzten Pfad erzeugen und anzeigen.
	INetURLObject aFolderURL( _aPath );
	String aFileName( aFolderURL.getName( INetURLObject::LAST_SEGMENT, false ) );
	USHORT nFileNameLen = aFileName.Len();
	BOOL bFileToSelect;
	if ( ( bFileToSelect = nFileNameLen && aFileName.GetChar( nFileNameLen - 1 ) != INET_PATH_TOKEN ) )
	{
		_pImp->_pEdFileName->SetText( GET_DECODED_NAME( aFolderURL ) );
		aFolderURL.removeSegment();
	}

	INetURLObject aObj = aFolderURL;
	if ( aObj.GetProtocol() == INET_PROT_FILE )
	{
		// Ordner als aktuelles Verzeichnis setzen.
		aObj.setFinalSlash();
		_pImp->_aCWD = aObj.GetMainURL( INetURLObject::NO_DECODE );
	}

    _pImp->_aToggleURLRemote = GetStandardDir();
    _pImp->_aToggleURLLocal = DEFINE_CONST_UNICODE("file:///");

	UpdateControls( aObj.GetMainURL( INetURLObject::NO_DECODE ) );

    // Somebody might want to enable some controls acording to the current filter
    FilterSelect();

	// Zustand der Steuerelemente anpassen.
//	EndListeningAll();

    ViewHdl_Impl( this, NULL );
	_pFileView->Initialize( aObj.GetMainURL( INetURLObject::NO_DECODE ), getMostCurrentFilter( _pImp ) );
	_pFileView->Show();
	SvtDefModalDialogParent_Impl aDefParent( this );


#ifdef FILTER_MRU_LIST
	if ( m_bUseFilterCaching )
		_pImp->InitFilterCache_Impl();
#endif

	// ggf. Gr"osse aus Ini lesen und setzen
	InitSize();

	// Start des Dialogs.
    _bIsInExecute = TRUE;
	short nResult = ModalDialog::Execute();
    _bIsInExecute = FALSE;

	// letztes Verzeichnis merken
	if ( RET_OK == nResult )
	{
		INetURLObject aURL( _aPath );
		if ( aURL.GetProtocol() == INET_PROT_FILE )
		{
			// nur bei File-URL's und nicht bei virtuelle Folder
			// das ausgew"ahlte Verzeichnis merken
			sal_Int32 nLevel = aURL.getSegmentCount();
			sal_Bool bDir = UCBContentHelper::IsFolder( aURL.GetMainURL( INetURLObject::NO_DECODE ) );
			BOOL bClassPath = ( ( _pImp->_nStyle & SFXWB_CLASSPATH ) == SFXWB_CLASSPATH );
			if ( nLevel > 1 && ( FILEDLG_TYPE_FILEDLG == _pImp->_eDlgType || !bDir ) )
				aURL.removeSegment();
		}

#ifdef FILTER_MRU_LIST
		// benutzen Filter cachen (UserFilter, DefaultFilter und <Alle> nicht, nur im
		// FileOpen-Mode)
		String aAll( SvtResId( STR_FILTERNAME_ALL ) );
		if	(	!_pImp->_pUserFilter
			&&	m_bUseFilterCaching
			&&	( COMPARE_EQUAL				!=	aAll.CompareTo( _pImp->GetCurFilter()->GetName() ) )
			&&	( _pImp->_pDefaultFilter	!=	_pImp->GetCurFilter() )
			)
		{
			_pImp->CacheFilter_Impl( _pImp->GetCurFilter()->GetName() );
		}
#endif
	}

#ifdef FILTER_MRU_LIST
	if ( m_bUseFilterCaching )
		_pImp->SaveFilterCache_Impl();
#endif

    return nResult;
}

//*****************************************************************************

void SvtFileDialog::FileSelect()
{
	if ( _pFileNotifier )
		_pFileNotifier->Notify( FILE_SELECTION_CHANGED, 0 );
}

//*****************************************************************************

void SvtFileDialog::FilterSelect()
{
	if ( _pFileNotifier )
		_pFileNotifier->Notify( CTRL_STATE_CHANGED,
                                CommonFilePickerElementIds::LISTBOX_FILTER );
}

//*****************************************************************************

void SvtFileDialog::SetStandardDir( const String& rStdDir )

/*	[Beschreibung]

	Die Methode setzt den Pfad f"ur den Standardknopf.
*/

{
    INetURLObject aObj( rStdDir );
    DBG_ASSERT( aObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid protocol!" );
	aObj.setFinalSlash();
	_pImp->SetStandardDir( aObj.GetMainURL( INetURLObject::NO_DECODE ) );
}

//*****************************************************************************

const String& SvtFileDialog::GetStandardDir() const

/*	[Beschreibung]

	Diese Methode gibt den eingestellten Standardpfad zur"uck.
*/

{
	return _pImp->GetStandardDir();
}

//*****************************************************************************

const String& SvtFileDialog::GetViewURL() const

/*	[Beschreibung]

	Diese Methode gibt die ausgew"ahlte ViewURL zur"uck.
*/

{
	return _pImp->GetViewURL();
}

//*****************************************************************************

void SvtFileDialog::PrevLevel_Impl()
{
	String aNewURL;
	if ( _pFileView->PreviousLevel( aNewURL ) )
	{
		UpdateControls( aNewURL );
	}
}

//*****************************************************************************

void SvtFileDialog::OpenURL_Impl( const String& rURL )
{
	_pFileView->Initialize( rURL, getMostCurrentFilter( _pImp ) );
	UpdateControls( rURL );
}

//*****************************************************************************
SvtFileDialogFilter_Impl* SvtFileDialog::implAddFilter( const String& _rFilter, const String& _rType )
{
	SvtFileDialogFilter_Impl* pNewFilter = new SvtFileDialogFilter_Impl( _rFilter, _rType );
	_pImp->_pFilter->C40_INSERT( SvtFileDialogFilter_Impl, pNewFilter, (USHORT)0 );

	if ( !_pImp->GetCurFilter() )
		_pImp->SetCurFilter( pNewFilter, _rFilter );

	return pNewFilter;
}

//*****************************************************************************

void SvtFileDialog::AddFilter( const String& _rFilter, const String& _rType )
{
	DBG_ASSERT( !IsInExecute(), "SvtFileDialog::AddFilter: currently executing!" );
	implAddFilter( _rFilter, _rType );
}

//*****************************************************************************
void SvtFileDialog::AddFilterGroup( const String& _rFilter, const Sequence< StringPair >& _rFilters )
{
	DBG_ASSERT( !IsInExecute(), "SvtFileDialog::AddFilter: currently executing!" );

	implAddFilter( _rFilter, String() );
	const StringPair* pSubFilters		=				_rFilters.getConstArray();
	const StringPair* pSubFiltersEnd	= pSubFilters +	_rFilters.getLength();
	for ( ; pSubFilters != pSubFiltersEnd; ++pSubFilters )
		implAddFilter( pSubFilters->First, pSubFilters->Second );
}

//*****************************************************************************

//-----------------------------------------------------------------------------
void SvtFileDialog::SetCurFilter( const String& rFilter )
{
	DBG_ASSERT( !IsInExecute(), "SvtFileDialog::SetCurFilter: currently executing!" );

	// Entsprechenden Filter suchen.
	USHORT nPos = _pImp->_pFilter->Count();

    while ( nPos-- )
	{
		SvtFileDialogFilter_Impl* pFilter = _pImp->_pFilter->GetObject( nPos );
		if ( pFilter->GetName() == rFilter )
		{
			_pImp->SetCurFilter( pFilter, rFilter );
			break;
		}
	}
}

//*****************************************************************************

String SvtFileDialog::GetCurFilter() const
{
	String aFilter;

	const SvtFileDialogFilter_Impl* pCurrentFilter = _pImp->GetCurFilter();
    if ( pCurrentFilter )
		aFilter = pCurrentFilter->GetName();

    return aFilter;
}

//*****************************************************************************

USHORT SvtFileDialog::GetFilterCount() const
{
	return _pImp->_pFilter->Count();
}

//*****************************************************************************

const String& SvtFileDialog::GetFilterName( USHORT nPos ) const
{
	DBG_ASSERT( nPos < GetFilterCount(), "invalid index" );
	return _pImp->_pFilter->GetObject( nPos )->GetName();
}

//*****************************************************************************

const String& SvtFileDialog::GetFilterType( USHORT nPos ) const
{
	DBG_ASSERT( nPos < GetFilterCount(), "invalid index" );
	return _pImp->_pFilter->GetObject( nPos )->GetType();
}

//*****************************************************************************

void SvtFileDialog::SetDefaultButtonText( const XubString& rText, ULONG nHelpId )
{
	if ( _pImp && _pImp->_pBtnFileOpen )
	{
		_pImp->_pBtnFileOpen->SetText( rText );
		if ( nHelpId )
			_pImp->_pBtnFileOpen->SetHelpId( nHelpId );
	}
}

//*****************************************************************************

void SvtFileDialog::InitSize()
{
	if ( ! _pImp->_aIniKey.Len() )
        return;

	Size aDlgSize = GetResizeOutputSizePixel();
	SetMinOutputSizePixel( aDlgSize );

	if ( !_pImp->_nFixDeltaHeight )
	{
		// Fixgr"ossen errechnen und merken
		Point aPnt = _pFileView->GetPosPixel();
		long nBoxH = _pFileView->GetSizePixel().Height();
		long nH = GetSizePixel().Height();
		_pImp->_nFixDeltaHeight = nH - nBoxH;
	}

	// initialize from config
	SvtViewOptions aDlgOpt( E_DIALOG, _pImp->_aIniKey );

	if ( aDlgOpt.Exists() )
	{
		String sWindowState = aDlgOpt.GetWindowState();
		if ( sWindowState.GetTokenCount( ',' ) == 2 )
		{
			Size aNewSize(
				sWindowState.GetToken( 0, ',' ).ToInt32(),
				sWindowState.GetToken( 1, ',' ).ToInt32()
			);
			if ( aNewSize.Width() < aDlgSize.Width() || aNewSize.Height() < aDlgSize.Height() )
				aNewSize = aDlgSize;
			SetOutputSizePixel( aNewSize );
		}
	}
}

//*****************************************************************************

SvStringsDtor* SvtFileDialog::GetPathList() const
{
	SvStringsDtor*	pList = new SvStringsDtor;
	ULONG			nCount = _pFileView->GetSelectionCount();
	SvLBoxEntry*	pEntry = nCount ? _pFileView->FirstSelected() : NULL;

	if ( ! pEntry )
	{
		String* pURL;

        if ( _pImp->_pEdFileName->GetText().Len() && _bIsInExecute )
            pURL = new String( _pImp->_pEdFileName->GetURL() );
        else
            pURL = new String( _aPath );

        pList->Insert( pURL, pList->Count() );
	}
	else
	{
		while ( pEntry )
		{
			String* pURL = new String( _pFileView->GetURL( pEntry ) );
			pList->Insert( pURL, pList->Count() );
			pEntry = _pFileView->NextSelected( pEntry );
		}
	}

	return pList;
}

//*****************************************************************************

void SvtFileDialog::implArrangeControls()
{
	// this is the list of controls in the order they should be tabbed
	// the focus is initially in the first control of this list
	Control* pControls[] =
	{
		_pImp->_pEdFileName, _pImp->_pLbFileVersion, _pImp->GetFilterListControl(),		// edit fields/list boxes
		_pImp->_pCbPassword, _pImp->_pCbAutoExtension, _pImp->_pCbOptions,				// checkboxes
		_pCbReadOnly, _pCbLinkBox, _pCbPreviewBox, _pCbSelection, _pPbPlay,				// check boxes (continued)
		_pImp->_pBtnFileOpen, _pImp->_pBtnCancel, _pImp->_pBtnHelp,						// buttons
		_pImp->_pBtnLocal, _pImp->_pBtnUp, _pImp->_pBtnNewFolder, _pImp->_pBtnStandard,	// image buttons
		_pFileView																		// the file view
	};

	// loop through all these controls and adjust the z-order
	Window* pPreviousWin = NULL;
	Control** pCurrent = pControls;
	for ( sal_Int32 i = 0; i < sizeof( pControls ) / sizeof( pControls[ 0 ] ); ++i, ++pCurrent )
	{
		if ( !*pCurrent )
			// this control is not available in the current operation mode -> skip
			continue;

		if ( pPreviousWin )
			(*pCurrent)->SetZOrder( pPreviousWin, WINDOW_ZORDER_BEHIND );
		else
			(*pCurrent)->SetZOrder( NULL, WINDOW_ZORDER_FIRST );

		pPreviousWin = *pCurrent;
	}
}

//*****************************************************************************

BOOL SvtFileDialog::IsolateFilterFromPath_Impl( String& rPath, String& rFilter )
{
	String aEmpty;
	String aReversePath( rPath );
	aReversePath.Reverse();
	USHORT nQuestionMarkPos = rPath.Search( '?' );

	if ( nQuestionMarkPos != STRING_NOTFOUND )
	{
		// Fragezeichen als Wildcard nur bei Files
		INetProtocol eProt = INetURLObject::CompareProtocolScheme( rPath );

		if ( INET_PROT_NOT_VALID != eProt && INET_PROT_FILE != eProt )
			nQuestionMarkPos = STRING_NOTFOUND;
	}
	USHORT nWildCardPos = Min( rPath.Search( FILEDIALOG_DEF_WILDCARD ), nQuestionMarkPos );
	rFilter = aEmpty;

	if ( nWildCardPos != STRING_NOTFOUND )
	{
		USHORT nPathTokenPos = aReversePath.Search( INET_PATH_TOKEN );

		if ( nPathTokenPos == STRING_NOTFOUND )
		{
			String aDelim(
#ifdef WNT
					'\\'
#elif MAC
					':'
#else
					'/'
#endif
			);

			nPathTokenPos = aReversePath.Search( aDelim );
#if !defined( UNX ) && !defined( MAC )
			if ( nPathTokenPos == STRING_NOTFOUND )
			{
				nPathTokenPos = aReversePath.Search( ':' );
			}
#endif
		}

		// Syntax pr"ufen.
		if ( nPathTokenPos != STRING_NOTFOUND )
		{
			if ( nPathTokenPos < (rPath.Len() - nWildCardPos - 1) )
			{
				ErrorHandler::HandleError( ERRCODE_SFX_INVALIDSYNTAX );
				return FALSE;
			}

			// Filter abschneiden.
			rFilter = aReversePath;
			rFilter.Erase( nPathTokenPos );
			rFilter.Reverse();

			// Ordner bestimmen.
			rPath = aReversePath;
			rPath.Erase( 0, nPathTokenPos );
			rPath.Reverse();
		}
		else
		{
			rFilter = rPath;
			rPath = aEmpty;
		}
	}

	return TRUE;
}

//*****************************************************************************

//-----------------------------------------------------------------------------
namespace {
	// move the control with the given offset
	void lcl_MoveControl( Control* _pControl, sal_Int32 _nDeltaX, sal_Int32 _nDeltaY, sal_Int32& _rMaxY )
	{
		if ( _pControl )
		{
			Point aNewPos = _pControl->GetPosPixel();

			// adjust the vertical position
			aNewPos.Y() += _nDeltaY;
			if ( aNewPos.Y() > _rMaxY )
				_rMaxY = aNewPos.Y();

			// adjust the horizontal position
			aNewPos.X() += _nDeltaX;

			_pControl->SetPosPixel( aNewPos );
		}
	}
}

//-----------------------------------------------------------------------------
void SvtFileDialog::Resize()
{
	if ( IsRollUp() )
		return;

	Size aDlgSize = GetResizeOutputSizePixel();
	Size aOldSize = _pImp->_aDlgSize;
	_pImp->_aDlgSize = aDlgSize;
	long nWinDeltaW = 0;

	if ( _pPrevWin &&
         _pPrevWin->GetPosPixel().X() > _pFileView->GetPosPixel().X() )
	{
		nWinDeltaW = _pPrevWin->GetOutputSizePixel().Width() + _pImp->_a6Size.Width();
	}

	Size aNewSize = _pFileView->GetSizePixel();
	Point aBoxPos( _pFileView->GetPosPixel() );
	long nDeltaY = aNewSize.Height();
	long nDeltaX = aNewSize.Width();
	aNewSize.Height() = aDlgSize.Height() - _pImp->_nFixDeltaHeight;
	aNewSize.Width() = aDlgSize.Width() - aBoxPos.X() - _pImp->_a6Size.Width() - nWinDeltaW;
	if ( aOldSize.Height() )
		nDeltaY = _pImp->_aDlgSize.Height() - aOldSize.Height();
	else
		nDeltaY = aNewSize.Height() - nDeltaY;
	nDeltaX = aNewSize.Width() - nDeltaX;

	if ( nWinDeltaW )
		nWinDeltaW = nDeltaX * 2 / 3;
	aNewSize.Width() -= nWinDeltaW;
	nDeltaX -= nWinDeltaW;

	_pFileView->SetSizePixel( aNewSize );

	if ( !nDeltaY && !nDeltaX )
		// Dieses Resize wurde nur zum Ein - oder Ausblenden des Indicators aufgerufen
		return;

	long nMaxYPos = 0;

	// -------------
	// move controls

	// controls to move vertically
	{
		Control* aMoveControlsVert[] =
		{
			_pImp->_pFtFileName, _pImp->_pEdFileName, _pImp->_pFtFileVersion, _pImp->_pLbFileVersion,
			_pImp->_pFtFileType, _pImp->GetFilterListControl(), _pCbReadOnly, _pCbLinkBox, _pCbPreviewBox,
			_pPbPlay, _pImp->_pCbPassword, _pImp->_pCbAutoExtension, _pImp->_pCbOptions, _pCbSelection
		};
		Control** ppMoveControls = aMoveControlsVert;
		Control** ppMoveControlsEnd = ppMoveControls + sizeof( aMoveControlsVert ) / sizeof( aMoveControlsVert[0] );
		for ( ; ppMoveControls != ppMoveControlsEnd; ++ppMoveControls )
			lcl_MoveControl( *ppMoveControls, 0, nDeltaY, nMaxYPos );
	}

	// controls to move vertically and horizontally
	{
		Control* aMoveControlsBoth[] =
		{
			_pImp->_pBtnFileOpen, _pImp->_pBtnCancel, _pImp->_pBtnHelp
		};
		Control** ppMoveControls = aMoveControlsBoth;
		Control** ppMoveControlsEnd = ppMoveControls + sizeof( aMoveControlsBoth ) / sizeof( aMoveControlsBoth[0] );
		for ( ; ppMoveControls != ppMoveControlsEnd; ++ppMoveControls )
			lcl_MoveControl( *ppMoveControls, nDeltaX, nDeltaY, nMaxYPos );
	}

	// controls to move horizontally
	{
		Control* aMoveControlsHor[] =
		{
			_pImp->_pBtnLocal, _pImp->_pBtnUp, _pImp->_pBtnNewFolder, _pImp->_pBtnStandard
		};
		Control** ppMoveControls = aMoveControlsHor;
		Control** ppMoveControlsEnd = ppMoveControls + sizeof( aMoveControlsHor ) / sizeof( aMoveControlsHor[0] );
		for ( ; ppMoveControls != ppMoveControlsEnd; ++ppMoveControls )
			lcl_MoveControl( *ppMoveControls, nDeltaX, 0, nMaxYPos );
	}

	// ---------------
	// resize controls
	{
		Control* aSizeControls[] =
		{
			_pImp->_pEdFileName, _pImp->_pLbFileVersion, _pImp->GetFilterListControl(), _pImp->_pFtCurrentPath,
		};
		sal_Int32 nSizeControls = sizeof( aSizeControls ) / sizeof( aSizeControls[0] );
		Control** ppSizeControls = aSizeControls;
		for ( sal_Int32 j=0; j<nSizeControls; ++j, ++ppSizeControls )
		{
			aNewSize = (*ppSizeControls)->GetSizePixel();
			aNewSize.Width() += nDeltaX;
			(*ppSizeControls)->SetSizePixel( aNewSize );
		}
	}

	// zus"atzliche Controls ausrichten
	if ( _pPrevWin &&
         _pPrevWin->GetPosPixel().X() > _pFileView->GetPosPixel().X() )
	{
		// Controls vom Typ Window speziell ausrichten
		// auch die Gr"osse anpassen
		Point aNewPos = _pPrevWin->GetPosPixel();
		aNewPos.X() += nDeltaX;
		_pPrevWin->SetPosPixel( aNewPos );
        _pPrevBmp->SetPosPixel( aNewPos );
		aNewSize = _pPrevWin->GetOutputSizePixel();
		aNewSize.Width() += nWinDeltaW;
		aNewSize.Height() += nDeltaY;
		if ( !aOldSize.Height() )
			aNewSize.Height() -= ( _pImp->_a6Size.Height() / 2 );
		_pPrevWin->SetOutputSizePixel( aNewSize );
		_pPrevBmp->SetOutputSizePixel( aNewSize );
        _pPrevBmp->Invalidate();
	}

    if ( _pFileNotifier )
		_pFileNotifier->Notify( DIALOG_SIZE_CHANGED, 0 );
}

//*****************************************************************************

void SvtFileDialog::SetPathURL( const XubString& rPathURL )

/*	[Beschreibung]

*/

{
	_pImp->_aPathURL = rPathURL;
}

//*****************************************************************************

Image* SvtFileDialog::GetFolderImage() const
{
	return _pImp->_pFolderImage;
}

//-----------------------------------------------------------------------------
Control* SvtFileDialog::implGetControl( sal_Int16 _nControlId, sal_Bool _bLabelControl ) const
{
	Control* pReturn = NULL;

	switch ( _nControlId )
	{
		case CommonFilePickerElementIds::CONTROL_FILEVIEW:
			pReturn = _bLabelControl ? NULL : static_cast< Control* >( _pFileView );
			break;

		case CommonFilePickerElementIds::EDIT_FILEURL:
			pReturn =	_bLabelControl
					?	static_cast< Control* >( _pImp->_pFtFileName )
					:	static_cast< Control* >( _pImp->_pEdFileName );
			break;

		case ExtendedFilePickerElementIds::CHECKBOX_AUTOEXTENSION:
			pReturn = _pImp->_pCbAutoExtension;
			break;

		case ExtendedFilePickerElementIds::CHECKBOX_PASSWORD:
			pReturn = _pImp->_pCbPassword;
			break;

		case ExtendedFilePickerElementIds::CHECKBOX_FILTEROPTIONS:
			pReturn = _pImp->_pCbOptions;
			break;

		case ExtendedFilePickerElementIds::CHECKBOX_READONLY:
			pReturn = _pCbReadOnly;
			break;

		case ExtendedFilePickerElementIds::CHECKBOX_LINK:
			pReturn = _pCbLinkBox;
			break;

		case ExtendedFilePickerElementIds::CHECKBOX_PREVIEW:
			pReturn = _pCbPreviewBox;
			break;

		case ExtendedFilePickerElementIds::CHECKBOX_SELECTION:
			pReturn = _pCbSelection;
			break;

		case CommonFilePickerElementIds::LISTBOX_FILTER:
			pReturn = _bLabelControl ? _pImp->_pFtFileType : _pImp->GetFilterListControl();
			break;

		case ExtendedFilePickerElementIds::LISTBOX_VERSION:
		case ExtendedFilePickerElementIds::LISTBOX_TEMPLATE:		// the version Box will be reused here
		case ExtendedFilePickerElementIds::LISTBOX_IMAGE_TEMPLATE:	// the version Box will be reused here
			pReturn =	_bLabelControl
					?	static_cast< Control* >( _pImp->_pFtFileVersion )
					:	static_cast< Control* >( _pImp->_pLbFileVersion );
			break;

		case ExtendedFilePickerElementIds::LISTBOX_VERSION_LABEL:
		case ExtendedFilePickerElementIds::LISTBOX_TEMPLATE_LABEL:
		case ExtendedFilePickerElementIds::LISTBOX_IMAGE_TEMPLATE_LABEL:
			pReturn = _pImp->_pFtFileVersion;
			break;

		case CommonFilePickerElementIds::PUSHBUTTON_OK:
			pReturn = _pImp->_pBtnFileOpen;
			break;

		case CommonFilePickerElementIds::PUSHBUTTON_CANCEL:
			pReturn = _pImp->_pBtnCancel;
			break;

		case ExtendedFilePickerElementIds::PUSHBUTTON_PLAY:
			pReturn = _pPbPlay;
			break;

		default:
			DBG_ERRORFILE( "SvtFileDialog::implGetControl: invalid id!" );
	}
	return pReturn;
}

//-----------------------------------------------------------------------------
void SvtFileDialog::SetValue( sal_Int16 nId,
                                   sal_Int16 nCtrlAction,
                                   const Any &rValue )
{
	Control* pControl = implGetControl( nId, sal_False );
	DBG_ASSERT( pControl, "SvtFileDialog::SetValue: don't have this control in the current mode!" );
	if ( pControl )
	{
		if ( ControlActions::SET_HELP_URL == nCtrlAction )
		{	// special handling for retrieving the help url
			::rtl::OUString aHelpURL;
			rValue >>= aHelpURL;

			String sHelpURL( aHelpURL );
			if ( COMPARE_EQUAL == sHelpURL.CompareIgnoreCaseToAscii( "HID:", sizeof( "HID:" ) - 1 ) )
			{
				String sID = sHelpURL.Copy( sizeof( "HID:" ) - 1 );
				sal_Int32 nHelpId = sID.ToInt32();

				if ( CommonFilePickerElementIds::CONTROL_FILEVIEW == nId )
					// the file view "overloaded" the SetHelpId
					static_cast< SvtFileView* >( pControl )->SetHelpId( nHelpId );
				else
					pControl->SetHelpId( nHelpId );
			}
			else
				DBG_ERRORFILE( "SvtFileDialog::SetValue: unsupported help URL type!" );
		}
		else
		{
			switch ( nId )
			{
				case ExtendedFilePickerElementIds::CHECKBOX_AUTOEXTENSION:
				case ExtendedFilePickerElementIds::CHECKBOX_PASSWORD:
				case ExtendedFilePickerElementIds::CHECKBOX_FILTEROPTIONS:
				case ExtendedFilePickerElementIds::CHECKBOX_READONLY:
				case ExtendedFilePickerElementIds::CHECKBOX_LINK:
				case ExtendedFilePickerElementIds::CHECKBOX_PREVIEW:
				case ExtendedFilePickerElementIds::CHECKBOX_SELECTION:
				{
					DBG_ASSERT( WINDOW_CHECKBOX == pControl->GetType(), "SvtFileDialog::SetValue: implGetControl returned nonsense!" );
					sal_Bool bChecked = sal_False;
					if ( rValue >>= bChecked )
						static_cast< CheckBox* >( pControl )->Check( bChecked );
				}
				break;

				case CommonFilePickerElementIds::LISTBOX_FILTER:
				{
					DBG_ERRORFILE( "Use the XFilterManager to access the filter listbox" );
				}
				break;

				case ExtendedFilePickerElementIds::LISTBOX_VERSION:
				case ExtendedFilePickerElementIds::LISTBOX_TEMPLATE:
				case ExtendedFilePickerElementIds::LISTBOX_IMAGE_TEMPLATE:
					DBG_ASSERT( WINDOW_LISTBOX == pControl->GetType(), "SvtFileDialog::SetValue: implGetControl returned nonsense!" );
					SetListboxValue( static_cast< ListBox* >( pControl ), nCtrlAction, rValue );
					break;
			}
		}
	}
}

//-----------------------------------------------------------------------------
Any SvtFileDialog::GetValue( sal_Int16 nId, sal_Int16 nCtrlAction ) const
{
	Any aRet;

	Control* pControl = implGetControl( nId, sal_False );
	DBG_ASSERT( pControl, "SvtFileDialog::GetValue: don't have this control in the current mode!" );
	if ( pControl )
	{
		if ( ControlActions::GET_HELP_URL == nCtrlAction )
		{	// special handling for retrieving the help url

			sal_Int32 nHelpId = pControl->GetHelpId();
			if ( CommonFilePickerElementIds::CONTROL_FILEVIEW == nId )
				// the file view "overloaded" the SetHelpId
				nHelpId = static_cast< SvtFileView* >( pControl )->GetHelpId( );

			::rtl::OUString sHelpURL( RTL_CONSTASCII_USTRINGPARAM( "HID:" ) );
			sHelpURL += ::rtl::OUString::valueOf( (sal_Int32)nHelpId );
			aRet <<= aRet;
		}
		else
		{
			switch ( nId )
			{
				case ExtendedFilePickerElementIds::CHECKBOX_AUTOEXTENSION:
				case ExtendedFilePickerElementIds::CHECKBOX_PASSWORD:
				case ExtendedFilePickerElementIds::CHECKBOX_FILTEROPTIONS:
				case ExtendedFilePickerElementIds::CHECKBOX_READONLY:
				case ExtendedFilePickerElementIds::CHECKBOX_LINK:
				case ExtendedFilePickerElementIds::CHECKBOX_PREVIEW:
				case ExtendedFilePickerElementIds::CHECKBOX_SELECTION:
				{
					DBG_ASSERT( WINDOW_CHECKBOX == pControl->GetType(), "SvtFileDialog::GetValue: implGetControl returned nonsense!" );
					sal_Bool bChecked = static_cast< CheckBox* >( pControl )->IsChecked();
					aRet <<= bChecked;
				}
				break;

				case CommonFilePickerElementIds::LISTBOX_FILTER:
				{
					if( nCtrlAction == ControlActions::GET_ITEMS )
					{
						DBG_ERRORFILE( "Use the XFilterManager to access the filter listbox" );
					}
					else if ( nCtrlAction == ControlActions::GET_SELECTED_ITEM )
					{
						OUString aFilter = GetCurFilter();
						aRet <<= aFilter;
					}
					else if ( nCtrlAction == ControlActions::GET_SELECTED_ITEM_INDEX )
					{
						DBG_ERRORFILE( "Use the XFilterManager to access the filter listbox" );
					}
				}
				break;

				case ExtendedFilePickerElementIds::LISTBOX_VERSION:
				case ExtendedFilePickerElementIds::LISTBOX_TEMPLATE:
				case ExtendedFilePickerElementIds::LISTBOX_IMAGE_TEMPLATE:
					DBG_ASSERT( WINDOW_LISTBOX == pControl->GetType(), "SvtFileDialog::GetValue: implGetControl returned nonsense!" );
					aRet = GetListboxValue( static_cast< ListBox* >( pControl ), nCtrlAction );
					break;
			}
		}
	}

    return aRet;
}

//-----------------------------------------------------------------------------
void SvtFileDialog::SetLabel( sal_Int16 nId, const OUString &rLabel )
{
	Control* pControl = implGetControl( nId, sal_True );
	DBG_ASSERT( pControl, "SvtFileDialog::GetValue: don't have this control in the current mode!" );
	if ( pControl )
		pControl->SetText( rLabel );
}

//-----------------------------------------------------------------------------
OUString SvtFileDialog::GetLabel( sal_Int16 nId ) const
{
    OUString sLabel;

	Control* pControl = implGetControl( nId, sal_True );
	DBG_ASSERT( pControl, "SvtFileDialog::GetValue: don't have this control in the current mode!" );
	if ( pControl )
		sLabel = pControl->GetText();

    return sLabel;
}

//-----------------------------------------------------------------------------
void SvtFileDialog::EnableControl( sal_Int16 nId, sal_Bool _bEnable )
{
	Control* pControl = implGetControl( nId, sal_False );
	DBG_ASSERT( pControl, "SvtFileDialog::GetValue: don't have this control in the current mode!" );
	if ( pControl )
		pControl->Enable( _bEnable );

	Control* pLabel = implGetControl( nId, sal_True );
	// the label does not necessarily need to be there
	if ( pLabel )
		pLabel->Enable( _bEnable );
}

// -----------------------------------------------------------------------
void SvtFileDialog::AddControls_Impl( )
{
	// create the "insert as link" checkbox, if needed
    if ( _nExtraBits & SFX_EXTRA_INSERTASLINK )
	{
		_pCbLinkBox = new CheckBox( this );
        _pCbLinkBox ->SetText( SvtResId( STR_SVT_FILEPICKER_INSERT_AS_LINK ) );
		_pCbLinkBox ->SetHelpId( HID_FILEDLG_LINK_CB );
		AddControl( _pCbLinkBox  );
		ReleaseOwnerShip( _pCbLinkBox );
		_pCbLinkBox->SetClickHdl( LINK( this, SvtFileDialog, ClickHdl_Impl ) );
	}

	// create the "show preview" checkbox ( and the preview window, too ), if needed
	if ( _nExtraBits & SFX_EXTRA_SHOWPREVIEW  )
    {
    	_pImp->_aIniKey = IMPGRF_CONFIGNAME;

        // "Vorschau"
	    _pCbPreviewBox = new CheckBox( this );
	    _pCbPreviewBox->SetText( SvtResId( STR_SVT_FILEPICKER_SHOW_PREVIEW ) );
	    _pCbPreviewBox->SetHelpId( HID_FILEDLG_PREVIEW_CB );
	    AddControl( _pCbPreviewBox );
		ReleaseOwnerShip( _pCbPreviewBox );
		_pCbPreviewBox->SetClickHdl( LINK( this, SvtFileDialog, ClickHdl_Impl ) );

	    // Preview-Fenster erst hier erzeugen
	    _pPrevWin = new Window( this, WinBits( WB_BORDER ) );
	    AddControl( _pPrevWin );
		ReleaseOwnerShip( _pPrevWin );
        _pPrevWin->Hide();

        _pPrevBmp = new FixedBitmap( this, WinBits( WB_BORDER ) );
	    _pPrevBmp->SetBackground( Wallpaper( Color( COL_WHITE ) ) );
        _pPrevBmp->Show();
    }

    if ( _nExtraBits & SFX_EXTRA_AUTOEXTENSION )
    {
		_pImp->_pCbAutoExtension = new CheckBox( this, SvtResId( CB_AUTO_EXTENSION ) );
	    _pImp->_pCbAutoExtension->SetText( SvtResId( STR_SVT_FILEPICKER_AUTO_EXTENSION ) );
		_pImp->_pCbAutoExtension->Check( TRUE );
		AddControl( _pImp->_pCbAutoExtension );
		ReleaseOwnerShip( _pImp->_pCbAutoExtension );
		_pImp->_pCbAutoExtension->SetClickHdl( LINK( this, SvtFileDialog, AutoExtensionHdl_Impl ) );
    }

    if ( _nExtraBits & SFX_EXTRA_FILTEROPTIONS )
	{
		_pImp->_pCbOptions = new CheckBox( this, SvtResId( CB_OPTIONS ) );
	    _pImp->_pCbOptions->SetText( SvtResId( STR_SVT_FILEPICKER_FILTER_OPTIONS ) );
		AddControl( _pImp->_pCbOptions );
		ReleaseOwnerShip( _pImp->_pCbOptions );
		_pImp->_pCbOptions->SetClickHdl( LINK( this, SvtFileDialog, ClickHdl_Impl ) );
	}

    if ( _nExtraBits & SFX_EXTRA_SELECTION )
	{
        _pCbSelection = new CheckBox( this, SvtResId( CB_OPTIONS ) );
	    _pCbSelection->SetText( SvtResId( STR_SVT_FILEPICKER_SELECTION ) );
		AddControl( _pCbSelection );
		ReleaseOwnerShip( _pCbSelection );
		_pCbSelection->SetClickHdl( LINK( this, SvtFileDialog, ClickHdl_Impl ) );
	}

    if ( _nExtraBits & SFX_EXTRA_PLAYBUTTON )
	{
		_pPbPlay = new PushButton( this );
	    _pPbPlay->SetText( SvtResId( STR_SVT_FILEPICKER_PLAY ) );
		_pPbPlay->SetHelpId( HID_FILESAVE_DOPLAY );
		AddControl( _pPbPlay );
		ReleaseOwnerShip( _pPbPlay );
		_pPbPlay->SetClickHdl( LINK( this, SvtFileDialog, PlayButtonHdl_Impl ) );
	}

    if ( _nExtraBits & SFX_EXTRA_TEMPLATES )
	{
		_pImp->_pFtFileVersion->SetText( SvtResId( STR_SVT_FILEPICKER_TEMPLATES ) );
	}
    else if ( _nExtraBits & SFX_EXTRA_IMAGE_TEMPLATE )
	{
		_pImp->_pFtFileVersion->SetText( SvtResId( STR_SVT_FILEPICKER_IMAGE_TEMPLATE ) );
		_pImp->_pLbFileVersion->SetHelpId( HID_FILEOPEN_IMAGE_TEMPLATE );
	}
}

// -----------------------------------------------------------------------
void SvtFileDialog::SetListboxValue( ListBox* pListbox,
                                          sal_Int16 nCtrlAction,
                                          const Any& rValue )
{
    switch ( nCtrlAction ) {
    case ControlActions::ADD_ITEM:
        {
            OUString aEntry;
            rValue >>= aEntry;
            if ( aEntry.getLength() )
                pListbox->InsertEntry( aEntry );
        }
        break;
    case ControlActions::ADD_ITEMS:
        {
			Sequence < OUString > aTemplateList;
			rValue >>= aTemplateList;

			if ( aTemplateList.getLength() )
			{
				for ( long i=0; i < aTemplateList.getLength(); i++ )
					pListbox->InsertEntry( aTemplateList[i] );
			}
        }
        break;
    case ControlActions::DELETE_ITEM:
        {
            sal_Int32 nPos;
            if ( rValue >>= nPos )
                pListbox->RemoveEntry( (USHORT) nPos );
        }
        break;
    case ControlActions::DELETE_ITEMS:
		pListbox->Clear();
        break;
    case ControlActions::SET_SELECT_ITEM:
        {
            sal_Int32 nPos;
            if ( rValue >>= nPos )
                pListbox->SelectEntryPos( (USHORT) nPos );
        }
        break;
    default:
        DBG_ERRORFILE( "Wrong ControlAction for SetListboxValue()" );
    }
}

// -----------------------------------------------------------------------
Any SvtFileDialog::GetListboxValue( ListBox* pListbox,
                                         sal_Int16 nCtrlAction ) const
{
    Any aRet;

    switch ( nCtrlAction ) {
    case ControlActions::GET_ITEMS:
        {
            USHORT nCount = pListbox->GetEntryCount();
            Sequence < OUString > aList( nCount );

            for ( USHORT i=0; i<nCount; i++ )
            {
                aList[i] = pListbox->GetEntry( i );
            }

            aRet <<= aList;
        }
        break;
    case ControlActions::GET_SELECTED_ITEM:
        {
            USHORT nPos = pListbox->GetSelectEntryPos();
            if ( nPos != LISTBOX_ENTRY_NOTFOUND )
            {
                OUString aEntry = pListbox->GetEntry( nPos );
                aRet <<= aEntry;
            }
        }
        break;
	case ControlActions::GET_SELECTED_ITEM_INDEX:
		{
            USHORT		nPos = pListbox->GetSelectEntryPos();
			sal_Int32	iPos = nPos != LISTBOX_ENTRY_NOTFOUND ? nPos : -1;

			aRet <<= iPos;
		}
		break;
    default:
        DBG_ERRORFILE( "Wrong ControlAction for GetListboxValue()" );
    }

    return aRet;
}

// -----------------------------------------------------------------------
sal_Int32 SvtFileDialog::getTargetColorDepth()
{
    if ( _pPrevBmp )
        return _pPrevBmp->GetBitCount();
    else
        return 0;
}

// -----------------------------------------------------------------------
sal_Int32 SvtFileDialog::getAvailableWidth()
{
    if ( _pPrevBmp )
        return _pPrevBmp->GetOutputSizePixel().Width();
    else
        return 0;
}

// -----------------------------------------------------------------------
sal_Int32 SvtFileDialog::getAvailableHeight()
{
    if ( _pPrevBmp )
        return _pPrevBmp->GetOutputSizePixel().Height();
    else
        return 0;
}

// -----------------------------------------------------------------------
void SvtFileDialog::setImage( sal_Int16 aImageFormat,
                                   const Any& rImage )
{
    if ( ! _pPrevBmp || ! _pPrevBmp->IsVisible() )
        return;

    Sequence < sal_Int8 > aBmpSequence;

    if ( rImage >>= aBmpSequence )
    {
        Bitmap          aBmp;
        SvMemoryStream  aData( aBmpSequence.getArray(),
                               aBmpSequence.getLength(),
                               STREAM_READ );
        aData >> aBmp;

        _pPrevBmp->SetBitmap( aBmp );
    }
    else
    {
        Bitmap aEmpty;
        _pPrevBmp->SetBitmap( aEmpty );
    }
}

// -----------------------------------------------------------------------
sal_Bool SvtFileDialog::setShowState( sal_Bool bShowState )
{
    if ( _pPrevBmp )
    {
        _pPrevBmp->Show( bShowState );
        return sal_True;
    }
    else
        return sal_False;
}

// -----------------------------------------------------------------------
sal_Bool SvtFileDialog::getShowState()
{
    if ( _pPrevBmp )
        return _pPrevBmp->IsVisible();
    else
        return sal_False;
}

// -----------------------------------------------------------------------
void SvtFileDialog::ReleaseOwnerShip( Window* pUserControl )

/*
  [Beschreibung]
  Die Methode sorgt dafuer das das spezifizierte Element nicht mehr im Besitz
  der Instanz ist.
*/

{
	ControlChain_Impl* pElement = _pUserControls;
	while ( pElement )
	{
		if ( pElement->_pControl == pUserControl )
		{
			pElement->_bHasOwnerShip = FALSE;
			break;
		}
		pElement = pElement->_pNext;
	}
}

//***************************************************************************

BOOL SvtFileDialog::AddControl( Window* pControl, BOOL bNewLine )
{
	// control already exists
	ControlChain_Impl* pElement = _pUserControls;
	while ( pElement )
	{
		if ( pElement->_pControl == pControl )
			return FALSE;
		pElement = pElement->_pNext;
	}

	// Check if controls have already been added.
	Size aNewControlSize( pControl->GetOutputSizePixel() );
	Size aDlgSize( GetOutputSizePixel() );
	WindowType nType = pControl->GetType();
	if ( !aNewControlSize.Height() )
	{
		// Detect a size.
		Size aSize( 0, 10 );
		if ( nType == WINDOW_PUSHBUTTON )
		{
			Size aDefSiz = LogicToPixel( Size( 50, 14 ), MAP_APPFONT );
			long nTextWidth = pControl->GetTextWidth( pControl->GetText() );
			aSize.Width() = nTextWidth + WIDTH_ADDITION;

			// PushButton:	Mindestbreite 50 logische Einheiten,
			//				H"ohe immer 14 logische Einheiten
			if ( aDefSiz.Width() > aSize.Width() )
				aSize.Width() = aDefSiz.Width();
			aSize.Height() = aDefSiz.Height();
			aNewControlSize = aSize;
		}
		else
			aNewControlSize = LogicToPixel( aSize, MAP_APPFONT );
		if ( nType != WINDOW_PUSHBUTTON )
			aNewControlSize.Width() = pControl->GetTextWidth( pControl->GetText() ) + WIDTH_ADDITION;
		if ( nType == WINDOW_CHECKBOX )
			aNewControlSize.Width() += WIDTH_ADDITION;
		if ( nType == WINDOW_WINDOW )
		{
			aNewControlSize.Height() = GetOutputSizePixel().Height() - 18;
			aNewControlSize.Width() = 200;
			aDlgSize.Width() += 210;
			SetOutputSizePixel( aDlgSize );
		}
		pControl->SetOutputSizePixel( aNewControlSize );
	}
	Point aNewControlPos;
	Size* pNewDlgSize = NULL;
	BOOL bNewRow = bNewLine;
	FASTBOOL bFirstNewRow = FALSE;

	if ( nType == WINDOW_WINDOW )
	{
		aNewControlPos.X() = aDlgSize.Width() - 210;
		aNewControlPos.Y() = 8;
	}
	else if ( _pUserControls )
	{
		Point aNewControlRange( _pUserControls->_pControl->GetPosPixel() );
		long nPrevControlHeight = _pUserControls->_pControl->GetSizePixel().Height();
		aNewControlRange +=
			Point( _pUserControls->_pControl->GetOutputSizePixel().Width(), 0 );
		aNewControlPos = aNewControlRange;
		if ( nPrevControlHeight > aNewControlSize.Height() )
		{
			long nY = nPrevControlHeight;
			nY -= aNewControlSize.Height();
			nY /= 2;
			aNewControlPos.Y() += nY;
		}
		aNewControlPos += LogicToPixel( Point( 3, 0 ), MAP_APPFONT );
		aNewControlRange += LogicToPixel( Point( 9, 0 ), MAP_APPFONT );
		aNewControlRange += Point( aNewControlSize.Width(), 0 );

		// Check if a new row has to be created.
		if ( aNewControlRange.X() > aDlgSize.Width() )
			bNewRow = TRUE;
	}
	else
	{
		// Create a new row if there was no usercontrol before.
		bNewRow = TRUE;
		bFirstNewRow = TRUE;
	}

	// Check if a new row has to be created.
	Size aBorderSize = LogicToPixel( Size( 6, 6 ), MAP_APPFONT );
	long nLeftBorder = aBorderSize.Width();
	long nLowerBorder = aBorderSize.Height();
	if ( bNewRow )
	{
		// Set control at the beginning of a new line.
		long nSmallBorderHeight = nLowerBorder / 2;
		aNewControlPos = Point( nLeftBorder, 0 );
		aNewControlPos += Point( 0, aDlgSize.Height() );
		aNewControlPos.Y() -= nSmallBorderHeight;
		// Set new size.
		pNewDlgSize = new Size( aDlgSize );
		pNewDlgSize->Height() -= nSmallBorderHeight;
		pNewDlgSize->Height() += aNewControlSize.Height();
		pNewDlgSize->Height() += nLowerBorder;
	}
	else
	{
		// Check if the window has to be resized.
		Size aNewControlRange( 0, aNewControlPos.Y() );
		aNewControlRange.Height() += aNewControlSize.Height();
		aNewControlRange.Height() += nLowerBorder;
		if ( aNewControlRange.Height() > aDlgSize.Height() )
			pNewDlgSize = new Size( aDlgSize.Width(), aNewControlRange.Height() );
	}

	// Update view.
	if ( pNewDlgSize )
	{
		SetOutputSizePixel( *pNewDlgSize );
		delete pNewDlgSize;
	}
	pControl->SetPosPixel( aNewControlPos );
	pControl->Show();
	_pUserControls = new ControlChain_Impl( pControl, _pUserControls, TRUE );

	return TRUE;
}

// -----------------------------------------------------------------------
// -----------------------------------------------------------------------
// -----------------------------------------------------------------------

//TODO! This function exploits the fact that the client side UCB distributes
// itself to the server side with an empty identifier.
sal_Bool SupportsLocalDir()
{
    Reference< XRemoteContentProviderSupplier > xSupplier;
    Reference< XMultiServiceFactory > xFactory = ::comphelper::getProcessServiceFactory();

    if ( xFactory.is() )
    {
        try
        {
            xSupplier = Reference< XRemoteContentProviderSupplier >(
                             xFactory->createInstance( OUString(
                                  RTL_CONSTASCII_USTRINGPARAM(
                                  "com.sun.star.ucb.RemoteContentProviderAcceptor")) ),
                             UNO_QUERY);
        }
        catch ( Exception const & )
        {}
    }
    OSL_ENSURE(xSupplier.is(), "unexpected situation");

    return xSupplier.is()
           && xSupplier->queryRemoteContentProvider(rtl::OUString()).is();
}

// QueryFolderNameDialog -------------------------------------------------------

namespace svtools {

QueryFolderNameDialog::QueryFolderNameDialog
(
	const String& rTitle,
	const String& rDefaultText,
	String* pGroupName
) :
	ModalDialog( GetpApp()->GetDefModalDialogParent(), SvtResId( DLG_SVT_QUERYFOLDERNAME ) ),

	aNameText	( this, SvtResId( FT_SVT_QUERYFOLDERNAME_DLG_NAME ) ),
	aNameEdit	( this, SvtResId( ED_SVT_QUERYFOLDERNAME_DLG_NAME ) ),
	aNameLine	( this, SvtResId( FL_SVT_QUERYFOLDERNAME_DLG_NAME ) ),
	aOKBtn		( this, SvtResId( BT_SVT_QUERYFOLDERNAME_DLG_OK ) ),
	aCancelBtn	( this, SvtResId( BT_SVT_QUERYFOLDERNAME_DLG_CANCEL ) )
{
	FreeResource();
	SetText( rTitle );
	aNameEdit.SetText( rDefaultText );
	aNameEdit.SetSelection( Selection( 0, rDefaultText.Len() ) );
	aOKBtn.SetClickHdl( LINK( this, QueryFolderNameDialog, OKHdl ) );
	aNameEdit.SetModifyHdl( LINK( this, QueryFolderNameDialog, NameHdl ) );

	if ( pGroupName )
		aNameLine.SetText( *pGroupName );
};

// -----------------------------------------------------------------------
IMPL_LINK( QueryFolderNameDialog, OKHdl, Button *, EMPTYARG )
{
	// trim the strings
	aNameEdit.SetText( aNameEdit.GetText().EraseLeadingChars().EraseTrailingChars() );
	EndDialog( RET_OK );
	return 1;
}

// -----------------------------------------------------------------------
IMPL_LINK( QueryFolderNameDialog, NameHdl, Edit *, EMPTYARG )
{
	// trim the strings
	String aName = aNameEdit.GetText();
	aName.EraseLeadingChars().EraseTrailingChars();
	if ( aName.Len() )
	{
		if ( !aOKBtn.IsEnabled() )
			aOKBtn.Enable( TRUE );
	}
	else
	{
		if ( aOKBtn.IsEnabled() )
			aOKBtn.Enable( FALSE );
	}

	return 0;
}

}
