/*************************************************************************
 *
 *  $RCSfile: filepicker.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: fs $ $Date: 2001/10/31 09:23:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "filepicker.hxx"
#include "iodlg.hxx"

#ifndef _LIST_
#include <list>
#endif
#ifndef _FUNCTIONAL_
#include <functional>
#endif
#ifndef _ALGORITHM_
#include <algorithm>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#define _SVSTDARR_STRINGSDTOR
#include "svstdarr.hxx"

#ifndef  _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef  _COM_SUN_STAR_CONTAINER_XCONTENTENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XContentEnumerationAccess.hpp>
#endif
#ifndef  _COM_SUN_STAR_CONTAINER_XSET_HPP_
#include <com/sun/star/container/XSet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_FILEPICKEREVENT_HPP_
#include <com/sun/star/ui/dialogs/FilePickerEvent.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_FILEPREVIEWIMAGEFORMATS_HPP_
#include <com/sun/star/ui/dialogs/FilePreviewImageFormats.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_TEMPLATEDESCRIPTION_HPP_
#include <com/sun/star/ui/dialogs/TemplateDescription.hpp>
#endif

#ifndef  _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif
#ifndef _UNOTOOLS_UCBHELPER_HXX
#include <unotools/ucbhelper.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <pathoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MISCOPT_HXX
#include <miscopt.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _COMPHELPER_SEQUENCE_HXX_ 
#include <comphelper/sequence.hxx>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_ 
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef SVTOOLS_PICKERHISTORYACCESS_HXX
#include "pickerhistoryaccess.hxx"
#endif

// define ----------------------------------------------------------------

#define MAKE_ANY    ::com::sun::star::uno::makeAny

// using ----------------------------------------------------------------

using namespace     ::com::sun::star::container;
using namespace     ::com::sun::star::lang;
using namespace     ::com::sun::star::ui::dialogs;
using namespace     ::com::sun::star::uno;
using namespace     ::com::sun::star::beans;
using namespace     ::rtl;
using namespace     ::utl;

//=====================================================================

struct FilterEntry;
typedef ::std::list< FilterEntry >		FilterList;		// can be maintained more effectively

typedef StringPair						UnoFilterEntry;
typedef Sequence< UnoFilterEntry >		UnoFilterList;	// can be transported more effectively

struct FilterEntry
{
protected:
	::rtl::OUString		m_sTitle;
	::rtl::OUString		m_sFilter;

	UnoFilterList		m_aSubFilters;

public:
	FilterEntry( const ::rtl::OUString& _rTitle, const ::rtl::OUString& _rFilter )
		:m_sTitle( _rTitle )
		,m_sFilter( _rFilter )
	{
	}

	FilterEntry( const ::rtl::OUString& _rTitle, const UnoFilterList& _rSubFilters );

	::rtl::OUString		getTitle() const { return m_sTitle; }
	::rtl::OUString		getFilter() const { return m_sFilter; }

	/// determines if the filter has sub filter (i.e., the filter is a filter group in real)
	sal_Bool			hasSubFilters( ) const;

	/** retrieves the filters belonging to the entry
	@return
		the number of sub filters
	*/
	sal_Int32			getSubFilters( UnoFilterList& _rSubFilterList );

	// helpers for iterating the sub filters
	const UnoFilterEntry*	beginSubFilters() const { return m_aSubFilters.getConstArray(); }
	const UnoFilterEntry*	endSubFilters() const { return m_aSubFilters.getConstArray() + m_aSubFilters.getLength(); }
};

//---------------------------------------------------------------------
FilterEntry::FilterEntry( const ::rtl::OUString& _rTitle, const UnoFilterList& _rSubFilters )
	:m_sTitle( _rTitle )
	,m_aSubFilters( _rSubFilters )
{
}

//---------------------------------------------------------------------
sal_Bool FilterEntry::hasSubFilters( ) const
{
	return ( 0 < m_aSubFilters.getLength() );
}

//---------------------------------------------------------------------
sal_Int32 FilterEntry::getSubFilters( UnoFilterList& _rSubFilterList )
{
	_rSubFilterList = m_aSubFilters;
	return m_aSubFilters.getLength();
}

// struct ElementEntry_Impl ----------------------------------------------

struct ElementEntry_Impl
{
	sal_Int16		m_nElementID;
	sal_Int16		m_nControlAction;
	UNOANY			m_aValue;
	UNOOUSTRING		m_aLabel;
    sal_Bool        m_bEnabled      : 1;

    sal_Bool        m_bHasValue     : 1;
    sal_Bool        m_bHasLabel     : 1;
    sal_Bool        m_bHasEnabled   : 1;

                    ElementEntry_Impl( sal_Int16 nId );

    void            setValue( const UNOANY& rVal ) { m_aValue = rVal; m_bHasValue = sal_True; }
    void            setAction( sal_Int16 nAction ) { m_nControlAction = nAction; }
    void            setLabel( const UNOOUSTRING& rVal ) { m_aLabel = rVal; m_bHasLabel = sal_True; }
    void            setEnabled( sal_Bool bEnabled ) { m_bEnabled = bEnabled; m_bHasEnabled = sal_True; }
};

typedef std::list < ElementEntry_Impl > ElementList;

ElementEntry_Impl::ElementEntry_Impl( sal_Int16 nId )
    : m_nElementID( nId )
    , m_nControlAction( 0 )
    , m_bEnabled( sal_False )
    , m_bHasValue( sal_False )
    , m_bHasLabel( sal_False )
    , m_bHasEnabled( sal_False )
{}

//------------------------------------------------------------------------------------
// SvtFilePicker_Impl
//------------------------------------------------------------------------------------

class SvtFilePicker_Impl
{
public:
	SvtFileDialog*		m_pDlg;
	FilterList*			m_pFilterList;
	ElementList*		m_pElemList;
	SvtFilePicker*		m_pOwner;

	sal_Bool			m_bMultiSelection;
    sal_Int16           m_nServiceType;
	UNOOUSTRING			m_aTitle;
	UNOOUSTRING			m_aDefaultName;
	UNOOUSTRING			m_aDisplayDirectory;
	UNOOUSTRING			m_aCurrentFilter;

	::rtl::OUString		m_sHelpURL;

	Reference< XFilePickerListener >	m_xListener;

public:
						SvtFilePicker_Impl( SvtFilePicker* pOwner );
						~SvtFilePicker_Impl();

	sal_Int16			execute();
	ULONG				getWinBits( ULONG& rExtraBits );
	void				notify( short nEventId, short nControlId );
	void				clearOwner() { m_pOwner = NULL; }

    sal_Bool            FilterNameExists( const ::rtl::OUString& rTitle );
	sal_Bool			FilterNameExists( const UnoFilterList& _rGroupedFilters );

	void				ensureFilterList( const ::rtl::OUString& _rInitialCurrentFilter );

	static sal_Int32		getHelpId( const ::rtl::OUString& _rHelpURL );
	static ::rtl::OUString	getHelpURL( sal_Int32 _nHelpId );

private:
	void					createFileDialog();
};

//-----------------------------------------------------------------------------
SvtFilePicker_Impl::SvtFilePicker_Impl( SvtFilePicker* pOwner ) :
	m_pDlg				( NULL ),
	m_pFilterList		( NULL ),
	m_pElemList			( NULL ),
	m_bMultiSelection	( sal_False ),
	m_pOwner			( pOwner )
{
}

//------------------------------------------------------------------------------------
SvtFilePicker_Impl::~SvtFilePicker_Impl()
{
	if ( m_pFilterList && !m_pFilterList->empty() )
		m_pFilterList->erase( m_pFilterList->begin(), m_pFilterList->end() );
	delete m_pFilterList;

	if ( m_pElemList && !m_pElemList->empty() )
		m_pElemList->erase( m_pElemList->begin(), m_pElemList->end() );
	delete m_pElemList;

	delete m_pDlg;
}

//------------------------------------------------------------------------------------
ULONG SvtFilePicker_Impl::getWinBits( ULONG& rExtraBits )
{
	// set the winbits for creating the filedialog
	ULONG nBits = 0L;
    rExtraBits = 0L;

	// set the standard bits acording to the service name
    if ( m_nServiceType == TemplateDescription::FILEOPEN_SIMPLE )
	{
		nBits = WB_OPEN;
	}
	else if ( m_nServiceType == TemplateDescription::FILESAVE_SIMPLE )
	{
		nBits = WB_SAVEAS;
	}
#if SUPD>639
	else if ( m_nServiceType == TemplateDescription::FILESAVE_AUTOEXTENSION )
	{
		nBits = WB_SAVEAS;
        rExtraBits = SFX_EXTRA_AUTOEXTENSION;
	}
#endif
	else if ( m_nServiceType == TemplateDescription::FILESAVE_AUTOEXTENSION_PASSWORD )
	{
		nBits = WB_SAVEAS | SFXWB_PASSWORD;
        rExtraBits = SFX_EXTRA_AUTOEXTENSION;
	}
    else if ( m_nServiceType == TemplateDescription::FILESAVE_AUTOEXTENSION_PASSWORD_FILTEROPTIONS )
	{
		nBits = WB_SAVEAS | SFXWB_PASSWORD;
        rExtraBits = SFX_EXTRA_AUTOEXTENSION | SFX_EXTRA_FILTEROPTIONS;
	}
    else if ( m_nServiceType == TemplateDescription::FILESAVE_AUTOEXTENSION_TEMPLATE )
	{
		nBits = WB_SAVEAS;
        rExtraBits = SFX_EXTRA_AUTOEXTENSION | SFX_EXTRA_TEMPLATES;
	}
    else if ( m_nServiceType == TemplateDescription::FILESAVE_AUTOEXTENSION_SELECTION )
	{
		nBits = WB_SAVEAS;
        rExtraBits = SFX_EXTRA_AUTOEXTENSION | SFX_EXTRA_SELECTION;
    }

    else if ( m_nServiceType == TemplateDescription::FILEOPEN_LINK_PREVIEW_IMAGE_TEMPLATE )
	{
		nBits = WB_OPEN;
        rExtraBits = SFX_EXTRA_INSERTASLINK | SFX_EXTRA_SHOWPREVIEW | SFX_EXTRA_IMAGE_TEMPLATE;
	}
    else if ( m_nServiceType == TemplateDescription::FILEOPEN_PLAY )
	{
		nBits = WB_OPEN;
        rExtraBits = SFX_EXTRA_PLAYBUTTON;
    }
    else if ( m_nServiceType == TemplateDescription::FILEOPEN_READONLY_VERSION )
	{
		nBits = WB_OPEN | SFXWB_READONLY;
        rExtraBits = SFX_EXTRA_SHOWVERSIONS;
	}
    else if ( m_nServiceType == TemplateDescription::FILEOPEN_LINK_PREVIEW )
	{
		nBits = WB_OPEN;
        rExtraBits = SFX_EXTRA_INSERTASLINK | SFX_EXTRA_SHOWPREVIEW;
	}
	if ( m_bMultiSelection && ( ( nBits & WB_OPEN ) == WB_OPEN ) )
		nBits |= SFXWB_MULTISELECTION;

	return nBits;
}

//------------------------------------------------------------------------------------
sal_Int32 SvtFilePicker_Impl::getHelpId( const ::rtl::OUString& _rHelpURL )
{
	sal_Int32 nId = 0;
	String sHelpURL( _rHelpURL );
	if ( COMPARE_EQUAL == sHelpURL.CompareIgnoreCaseToAscii( "HID:", sizeof( "HID:" ) - 1 ) )
	{
		String sID = sHelpURL.Copy( sizeof( "HID:" ) - 1 );
		nId = sID.ToInt32();;
	}
	return nId;
}

//------------------------------------------------------------------------------------
::rtl::OUString SvtFilePicker_Impl::getHelpURL( sal_Int32 _nHelpId )
{
	::rtl::OUString sHelpURL( RTL_CONSTASCII_USTRINGPARAM( "HID:" ) );
	sHelpURL += ::rtl::OUString::valueOf( (sal_Int32)_nHelpId );
	return sHelpURL;
}

//------------------------------------------------------------------------------------
void SvtFilePicker_Impl::createFileDialog()
{
	if ( m_pDlg )
		return;

	ULONG	nExtraBits;
    ULONG	nBits = getWinBits( nExtraBits );

	m_pDlg = new SvtFileDialog( nBits, nExtraBits );

	// synchronize the help id of the dialog with out help URL property
	if ( m_sHelpURL.getLength() )
	{	// somebody already set the help URL while we had no dialog yet
		m_pDlg->SetHelpId( getHelpId( m_sHelpURL ) );
	}
	else
	{
		m_sHelpURL = getHelpURL( m_pDlg->GetHelpId( ) );
	}
}

//------------------------------------------------------------------------------------
sal_Int16 SvtFilePicker_Impl::execute()
{
	if ( !m_pDlg )
		createFileDialog();

	FileNotifyHelper_Impl *pNotifier = new FileNotifyHelper_Impl( this );
	m_pDlg->SetFileCallback( pNotifier );

	// set the title
	if ( m_aTitle.getLength() > 0 )
		m_pDlg->SetText( m_aTitle );

	// set the default directory
	// --**-- doesn't match the spec yet
	if ( m_aDisplayDirectory.getLength() > 0 || m_aDefaultName.getLength() > 0 )
	{
		if ( m_aDisplayDirectory.getLength() > 0 )
		{

			INetURLObject aPath( m_aDisplayDirectory );
			if ( m_aDefaultName.getLength() > 0 )
				aPath.insertName( m_aDefaultName );
			m_pDlg->SetPath( aPath.GetMainURL( INetURLObject::NO_DECODE ) );
		}
		else if ( m_aDefaultName.getLength() > 0 )
			m_pDlg->SetPath( m_aDefaultName );
	}
	else
	{
		// Default-Standard-Dir setzen
		INetURLObject aStdDirObj( SvtPathOptions().GetWorkPath() );
		m_pDlg->SetPath( aStdDirObj.GetMainURL( INetURLObject::NO_DECODE ) );
	}

	// set the control values and set the control labels, too
    if ( m_pElemList && !m_pElemList->empty() )
    {
		ElementList::iterator aListIter;
		for ( aListIter = m_pElemList->begin();
			  aListIter != m_pElemList->end(); ++aListIter )
		{
			ElementEntry_Impl& rEntry = *aListIter;
            if ( rEntry.m_bHasValue )
                m_pDlg->SetValue( rEntry.m_nElementID, rEntry.m_nControlAction, rEntry.m_aValue );
            if ( rEntry.m_bHasLabel )
                m_pDlg->SetLabel( rEntry.m_nElementID, rEntry.m_aLabel );
            if ( rEntry.m_bHasEnabled )
                m_pDlg->EnableControl( rEntry.m_nElementID, rEntry.m_bEnabled );
		}
    }

    if ( m_pFilterList && !m_pFilterList->empty() )
	{
		for	(	FilterList::iterator aListIter = m_pFilterList->begin();
				aListIter != m_pFilterList->end();
				++aListIter
			)
		{
			if ( aListIter->hasSubFilters() )
			{	// it's a filter group
				UnoFilterList aSubFilters;
				aListIter->getSubFilters( aSubFilters );

				m_pDlg->AddFilterGroup( aListIter->getTitle(), aSubFilters );
			}
			else
				// it's a single filter
				m_pDlg->AddFilter( aListIter->getTitle(), aListIter->getFilter() );
		}
	}

	// set the default filter
	if ( m_aCurrentFilter.getLength() > 0 )
		m_pDlg->SetCurFilter( m_aCurrentFilter );

	// now we are ready to execute the dialog
	sal_Int16 nRet = m_pDlg->Execute();

	m_pDlg->SetFileCallback( NULL );
	delete pNotifier;

	return nRet;
}

//------------------------------------------------------------------------------------
void SvtFilePicker_Impl::notify( short nEventId, short nControlId )
{
	if ( !m_xListener.is() || !m_pOwner )
		return;

    FilePickerEvent aEvent( *m_pOwner, nControlId );

	switch ( nEventId ) {
	case FILE_SELECTION_CHANGED:
		m_xListener->fileSelectionChanged( aEvent );
		break;
	case DIRECTORY_CHANGED:
		m_xListener->directoryChanged( aEvent );
		break;
	case HELP_REQUESTED:
		m_xListener->helpRequested( aEvent );
		break;
	case CTRL_STATE_CHANGED:
		m_xListener->controlStateChanged( aEvent );
		break;
	case DIALOG_SIZE_CHANGED:
		m_xListener->dialogSizeChanged();
		break;
	default:
		DBG_ERRORFILE( "SvtFilePicker_Impl::notify(): Unknown event id!" );
	}
}

//------------------------------------------------------------------------------------
namespace {
	//................................................................................
	struct FilterTitleMatch : public ::std::unary_function< FilterEntry, bool >
	{
	protected:
		const ::rtl::OUString& rTitle;

	public:
		FilterTitleMatch( const ::rtl::OUString& _rTitle ) : rTitle( _rTitle ) { }

		//............................................................................
		bool operator () ( const FilterEntry& _rEntry )
		{
			sal_Bool bMatch;
			if ( !_rEntry.hasSubFilters() )
				// a real filter
				bMatch = ( _rEntry.getTitle() == rTitle );
			else
				// a filter group -> search the sub filters
				bMatch =
					_rEntry.endSubFilters() != ::std::find_if(
						_rEntry.beginSubFilters(),
						_rEntry.endSubFilters(),
						*this
					);

			return bMatch ? true : false;
		}
		bool operator () ( const UnoFilterEntry& _rEntry )
		{
			return _rEntry.First == rTitle ? true : false;
		}
	};
}

//------------------------------------------------------------------------------------
sal_Bool SvtFilePicker_Impl::FilterNameExists( const ::rtl::OUString& rTitle )
{
    sal_Bool bRet = sal_False;

    if ( m_pFilterList )
		bRet =
			m_pFilterList->end() != ::std::find_if(
				m_pFilterList->begin(),
				m_pFilterList->end(),
				FilterTitleMatch( rTitle )
			);

    return bRet;
}

//------------------------------------------------------------------------------------
sal_Bool SvtFilePicker_Impl::FilterNameExists( const UnoFilterList& _rGroupedFilters )
{
    sal_Bool bRet = sal_False;

	if ( m_pFilterList )
	{
		const UnoFilterEntry* pStart = _rGroupedFilters.getConstArray();
		const UnoFilterEntry* pEnd = pStart + _rGroupedFilters.getLength();
		for ( ; pStart != pEnd; ++pStart )
			if ( m_pFilterList->end() != ::std::find_if( m_pFilterList->begin(), m_pFilterList->end(), FilterTitleMatch( pStart->First ) ) )
				break;

		bRet = pStart != pEnd;
	}

	return bRet;
}

//------------------------------------------------------------------------------------
void SvtFilePicker_Impl::ensureFilterList( const ::rtl::OUString& _rInitialCurrentFilter )
{
	if ( !m_pFilterList )
    {
		m_pFilterList = new FilterList;

        // set the first filter to the current filter
        if ( ! m_aCurrentFilter.getLength() )
            m_aCurrentFilter = _rInitialCurrentFilter;
    }
}

//------------------------------------------------------------------------------------
// class SvtFilePicker
//------------------------------------------------------------------------------------
#define PROPERTY_ID_HELPURL		1
SvtFilePicker::SvtFilePicker( const Reference < XMultiServiceFactory >& xFactory )
	:OPropertyContainer( GetBroadcastHelper() )
{
	m_pImpl = new SvtFilePicker_Impl( this );

	// the only property we have
	registerProperty(
		::rtl::OUString::createFromAscii( "HelpURL" ), PROPERTY_ID_HELPURL,
		PropertyAttribute::BOUND | PropertyAttribute::TRANSIENT,
		&m_pImpl->m_sHelpURL, ::getCppuType( &m_pImpl->m_sHelpURL )
	);
}

SvtFilePicker::~SvtFilePicker()
{
	m_pImpl->clearOwner();

	delete m_pImpl;
}

//------------------------------------------------------------------------------------
// disambiguate XInterface
//------------------------------------------------------------------------------------
Any SAL_CALL SvtFilePicker::queryInterface( const Type& _rType ) throw (RuntimeException)
{
	Any aReturn = SvtFilePicker_Base::queryInterface( _rType );
	if ( !aReturn.hasValue() )
		aReturn = OPropertyContainer::queryInterface( _rType );
	return aReturn;
}

void SAL_CALL SvtFilePicker::acquire(  ) throw ()
{
	SvtFilePicker_Base::acquire();
}

void SAL_CALL SvtFilePicker::release(  ) throw ()
{
	SvtFilePicker_Base::release();
}

//------------------------------------------------------------------------------------
// disambiguate XTypeProvider
//------------------------------------------------------------------------------------
Sequence< Type > SAL_CALL SvtFilePicker::getTypes(  ) throw (RuntimeException)
{
	return ::comphelper::concatSequences(
		SvtFilePicker_Base::getTypes(),
		OPropertyContainer::getTypes()
	);
}

Sequence< sal_Int8 > SAL_CALL SvtFilePicker::getImplementationId(  ) throw (RuntimeException)
{
	static ::cppu::OImplementationId * pId = 0;
	if (! pId)
	{
		::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
		if (! pId)
		{
			static ::cppu::OImplementationId aId;
			pId = &aId;
		}
	}
	return pId->getImplementationId();
}

//------------------------------------------------------------------------------------
// XExecutableDialog functions
//------------------------------------------------------------------------------------

void SAL_CALL SvtFilePicker::setTitle( const UNOOUSTRING& aTitle ) throw( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	m_pImpl->m_aTitle = aTitle;
}

//------------------------------------------------------------------------------------
sal_Int16 SAL_CALL SvtFilePicker::execute() throw( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	return m_pImpl->execute();
}

//------------------------------------------------------------------------------------
// XFilePicker functions
//------------------------------------------------------------------------------------

void SAL_CALL SvtFilePicker::setMultiSelectionMode( sal_Bool bMode ) throw( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	m_pImpl->m_bMultiSelection = bMode;
}

void SAL_CALL SvtFilePicker::setDefaultName( const UNOOUSTRING& aName ) throw( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	m_pImpl->m_aDefaultName = aName;
}

void SAL_CALL SvtFilePicker::setDisplayDirectory( const UNOOUSTRING& aDirectory )
    throw( UNOILLEGALARGUMENTEXCEPTION, UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	m_pImpl->m_aDisplayDirectory = aDirectory;
}

UNOOUSTRING SAL_CALL SvtFilePicker::getDisplayDirectory() throw( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	if ( m_pImpl->m_pDlg )
    {
        UNOOUSTRING aPath = m_pImpl->m_pDlg->GetPath();

        if( !UCBContentHelper::IsFolder( aPath ) )
        {
            INetURLObject aFolder( aPath );
            aFolder.CutLastName();
            aPath = aFolder.GetMainURL( INetURLObject::NO_DECODE );
        }
        return aPath;
    }
    else
        return m_pImpl->m_aDisplayDirectory;
}

UNOSEQUENCE< UNOOUSTRING > SAL_CALL SvtFilePicker::getFiles() throw( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	if ( ! m_pImpl->m_pDlg )
	{
		UNOSEQUENCE< UNOOUSTRING > aEmpty;
		return aEmpty;
	}

	// if there is more than one path we have to return the path to the
	// files first and then the list of the selected entries

	SvStringsDtor* pPathList = m_pImpl->m_pDlg->GetPathList();
	USHORT i, nCount = pPathList->Count();
	USHORT nTotal = nCount > 1 ? nCount+1: nCount;

	UNOSEQUENCE< UNOOUSTRING > aPath( nTotal );

	if ( nCount == 1 )
		aPath[0] = UNOOUSTRING( *pPathList->GetObject( 0 ) );
	else if ( nCount > 1 )
	{
		INetURLObject aObj( *pPathList->GetObject( 0 ) );
		aObj.removeSegment();
		aPath[0] = aObj.GetMainURL( INetURLObject::NO_DECODE );

		for ( i = 0; i < nCount; /* i++ is done below */ )
		{
			aObj.SetURL( *pPathList->GetObject(i++) );
			aPath[i] = aObj.getName();
		}
	}

	delete pPathList;
	return aPath;
}

//------------------------------------------------------------------------------------
// XFilePickerControlAccess functions
//------------------------------------------------------------------------------------

void SAL_CALL SvtFilePicker::setValue( sal_Int16 nElementID,
                                       sal_Int16 nControlAction,
                                       const UNOANY& rValue )
    throw( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	if ( m_pImpl->m_pDlg )
	{
		m_pImpl->m_pDlg->SetValue( nElementID, nControlAction, rValue );
	}
	else
	{
		if ( !m_pImpl->m_pElemList )
			m_pImpl->m_pElemList = new ElementList;

        sal_Bool bFound = sal_False;
		ElementList::iterator aListIter;

        for ( aListIter = m_pImpl->m_pElemList->begin();
			  aListIter != m_pImpl->m_pElemList->end(); ++aListIter )
		{
			ElementEntry_Impl& rEntry = *aListIter;
            if ( ( rEntry.m_nElementID == nElementID ) &&
                 ( !rEntry.m_bHasValue || ( rEntry.m_nControlAction == nControlAction ) ) )
            {
                rEntry.setAction( nControlAction );
                rEntry.setValue( rValue );
                bFound = sal_True;
            }
		}

        if ( !bFound )
        {
            ElementEntry_Impl aNew( nElementID );
            aNew.setAction( nControlAction );
            aNew.setValue( rValue );
            m_pImpl->m_pElemList->insert( m_pImpl->m_pElemList->end(), aNew );
        }
	}
}

//------------------------------------------------------------------------------------

UNOANY SAL_CALL SvtFilePicker::getValue( sal_Int16 nElementID, sal_Int16 nControlAction )
    throw( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	UNOANY      aAny;

	// execute() called?
	if ( m_pImpl->m_pDlg )
	{
		aAny = m_pImpl->m_pDlg->GetValue( nElementID, nControlAction );
	}
    else if ( m_pImpl->m_pElemList && !m_pImpl->m_pElemList->empty() )
    {
		ElementList::iterator aListIter;
		for ( aListIter = m_pImpl->m_pElemList->begin();
			  aListIter != m_pImpl->m_pElemList->end(); ++aListIter )
		{
			ElementEntry_Impl& rEntry = *aListIter;
            if ( ( rEntry.m_nElementID == nElementID ) &&
                 ( rEntry.m_bHasValue ) &&
                 ( rEntry.m_nControlAction == nControlAction ) )
            {
                aAny = rEntry.m_aValue;
                break;
            }
		}
    }

    return aAny;
}


//------------------------------------------------------------------------------------
void SAL_CALL SvtFilePicker::setLabel( sal_Int16 nLabelID, const UNOOUSTRING& rValue )
    throw ( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	if ( m_pImpl->m_pDlg )
	{
		m_pImpl->m_pDlg->SetLabel( nLabelID, rValue );
	}
	else
	{
		if ( !m_pImpl->m_pElemList )
			m_pImpl->m_pElemList = new ElementList;

        sal_Bool bFound = sal_False;
		ElementList::iterator aListIter;

        for ( aListIter = m_pImpl->m_pElemList->begin();
			  aListIter != m_pImpl->m_pElemList->end(); ++aListIter )
		{
			ElementEntry_Impl& rEntry = *aListIter;
            if ( rEntry.m_nElementID == nLabelID )
            {
                rEntry.setLabel( rValue );
                bFound = sal_True;
            }
		}

        if ( !bFound )
        {
            ElementEntry_Impl aNew( nLabelID );
            aNew.setLabel( rValue );
            m_pImpl->m_pElemList->insert( m_pImpl->m_pElemList->end(), aNew );
        }
	}
}

//------------------------------------------------------------------------------------
UNOOUSTRING SAL_CALL SvtFilePicker::getLabel( sal_Int16 nLabelID )
    throw ( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	UNOOUSTRING aLabel;

    if ( m_pImpl->m_pDlg )
	{
		aLabel = m_pImpl->m_pDlg->GetLabel( nLabelID );
	}
    else if ( m_pImpl->m_pElemList && !m_pImpl->m_pElemList->empty() )
    {
		ElementList::iterator aListIter;
		for ( aListIter = m_pImpl->m_pElemList->begin();
			  aListIter != m_pImpl->m_pElemList->end(); ++aListIter )
		{
			ElementEntry_Impl& rEntry = *aListIter;
            if ( rEntry.m_nElementID == nLabelID )
            {
                if ( rEntry.m_bHasLabel )
                    aLabel = rEntry.m_aLabel;
                break;
            }
		}
    }

	return aLabel;
}

//------------------------------------------------------------------------------------
void SAL_CALL SvtFilePicker::enableControl( sal_Int16 nElementID, sal_Bool bEnable )
    throw( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
    if ( m_pImpl->m_pDlg )
	{
		m_pImpl->m_pDlg->EnableControl( nElementID, bEnable );
	}
    else
    {
		if ( !m_pImpl->m_pElemList )
			m_pImpl->m_pElemList = new ElementList;

        sal_Bool bFound = sal_False;
		ElementList::iterator aListIter;

        for ( aListIter = m_pImpl->m_pElemList->begin();
			  aListIter != m_pImpl->m_pElemList->end(); ++aListIter )
		{
			ElementEntry_Impl& rEntry = *aListIter;
            if ( rEntry.m_nElementID == nElementID )
            {
                rEntry.setEnabled( bEnable );
                bFound = sal_True;
            }
		}

        if ( !bFound )
        {
            ElementEntry_Impl aNew( nElementID );
            aNew.setEnabled( bEnable );
            m_pImpl->m_pElemList->insert( m_pImpl->m_pElemList->end(), aNew );
        }
    }
}

//------------------------------------------------------------------------------------
// XFilePickerNotifier functions
//------------------------------------------------------------------------------------

void SAL_CALL SvtFilePicker::addFilePickerListener( const Reference< XFilePickerListener >& xListener ) throw ( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	m_pImpl->m_xListener = xListener;
}

//------------------------------------------------------------------------------------
void SAL_CALL SvtFilePicker::removeFilePickerListener( const Reference< XFilePickerListener >& xListener ) throw ( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	m_pImpl->m_xListener.clear();
}

//------------------------------------------------------------------------------------
// XFilePreview functions
//------------------------------------------------------------------------------------

UNOSEQUENCE< sal_Int16 > SAL_CALL SvtFilePicker::getSupportedImageFormats()
    throw ( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
    UNOSEQUENCE< sal_Int16 > aFormats( 1 );

    aFormats[0] = FilePreviewImageFormats::BITMAP;

    return aFormats;
}

//------------------------------------------------------------------------------------
sal_Int32 SAL_CALL SvtFilePicker::getTargetColorDepth() throw ( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
    sal_Int32 nDepth = 0;

    if ( m_pImpl->m_pDlg )
        nDepth = m_pImpl->m_pDlg->getTargetColorDepth();

    return nDepth;
}

//------------------------------------------------------------------------------------
sal_Int32 SAL_CALL SvtFilePicker::getAvailableWidth() throw ( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
    sal_Int32 nWidth = 0;

    if ( m_pImpl->m_pDlg )
        nWidth = m_pImpl->m_pDlg->getAvailableWidth();

    return nWidth;
}

//------------------------------------------------------------------------------------
sal_Int32 SAL_CALL SvtFilePicker::getAvailableHeight() throw ( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
    sal_Int32 nHeigth = 0;

    if ( m_pImpl->m_pDlg )
        nHeigth = m_pImpl->m_pDlg->getAvailableHeight();

    return nHeigth;
}

//------------------------------------------------------------------------------------
void SAL_CALL SvtFilePicker::setImage( sal_Int16 aImageFormat, const UNOANY& rImage )
    throw ( UNOILLEGALARGUMENTEXCEPTION, UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
    if ( m_pImpl->m_pDlg )
        m_pImpl->m_pDlg->setImage( aImageFormat, rImage );
}

//------------------------------------------------------------------------------------
sal_Bool SAL_CALL SvtFilePicker::setShowState( sal_Bool bShowState )
    throw ( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
    sal_Bool bRet = sal_False;

    if ( m_pImpl->m_pDlg )
        bRet = m_pImpl->m_pDlg->setShowState( bShowState );

    return bRet;
}

//------------------------------------------------------------------------------------
sal_Bool SAL_CALL SvtFilePicker::getShowState() throw ( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
    sal_Bool bRet = sal_False;

    if ( m_pImpl->m_pDlg )
        bRet = m_pImpl->m_pDlg->getShowState();

    return bRet;
}

//------------------------------------------------------------------------------------
// XFilterGroupManager functions
//------------------------------------------------------------------------------------

void SAL_CALL SvtFilePicker::appendFilterGroup(	const ::rtl::OUString& sGroupTitle,
												const Sequence< StringPair >& aFilters )
	throw ( IllegalArgumentException, RuntimeException )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );

	// check the names
	if ( m_pImpl->FilterNameExists( aFilters ) )
		// TODO: a more precise exception message
        throw IllegalArgumentException();

	// ensure that we have a filter list
	::rtl::OUString sInitialCurrentFilter;
	if ( aFilters.getLength() )
		sInitialCurrentFilter = aFilters[0].First;
	m_pImpl->ensureFilterList( sInitialCurrentFilter );

	// append the filter
	m_pImpl->m_pFilterList->insert( m_pImpl->m_pFilterList->end(), FilterEntry( sGroupTitle, aFilters ) );
}

//------------------------------------------------------------------------------------
// XFilterManager functions
//------------------------------------------------------------------------------------

void SAL_CALL SvtFilePicker::appendFilter( const UNOOUSTRING& aTitle,
                                           const UNOOUSTRING& aFilter )
    throw( IllegalArgumentException, RuntimeException )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	// check the name
	if ( m_pImpl->FilterNameExists( aTitle ) )
		// TODO: a more precise exception message
        throw IllegalArgumentException();

	// ensure that we have a filter list
	m_pImpl->ensureFilterList( aTitle );

	// append the filter
	m_pImpl->m_pFilterList->insert( m_pImpl->m_pFilterList->end(), FilterEntry( aTitle, aFilter ) );
}

//------------------------------------------------------------------------------------
void SAL_CALL SvtFilePicker::setCurrentFilter( const UNOOUSTRING& aTitle )
    throw( UNOILLEGALARGUMENTEXCEPTION, UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
    if ( ! m_pImpl->FilterNameExists( aTitle ) )
        throw UNOILLEGALARGUMENTEXCEPTION();

	m_pImpl->m_aCurrentFilter = aTitle;

    if ( m_pImpl->m_pDlg )
        m_pImpl->m_pDlg->SetCurFilter( aTitle );
}

//------------------------------------------------------------------------------------
UNOOUSTRING SAL_CALL SvtFilePicker::getCurrentFilter()
    throw( UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	UNOOUSTRING aFilter = m_pImpl->m_pDlg ? UNOOUSTRING( m_pImpl->m_pDlg->GetCurFilter() ) :
                                            UNOOUSTRING( m_pImpl->m_aCurrentFilter );
	return aFilter;
}


//------------------------------------------------------------------------------------
// XInitialization functions
//------------------------------------------------------------------------------------

void SAL_CALL SvtFilePicker::initialize( const UNOSEQUENCE< UNOANY >& rArguments )
	throw ( UNOEXCEPTION, UNORUNTIMEEXCEPTION )
{
    ::vos::OGuard aGuard( Application::GetSolarMutex() );
	DBG_ASSERT( rArguments.getLength() == 1, "SvtFilePicker::initialize() : Wrong number of arguments!" );

	if ( rArguments.getLength() )
	{
		sal_Int16 nType;

		if ( rArguments[0] >>= nType )
			m_pImpl->m_nServiceType = nType;
	}
}

// ------------------------------------------------------------------------
// misc. helpers
//------------------------------------------------------------------------------------
#define SYSTEM_FILE_OPEN_SERVICE_NAME "com.sun.star.ui.dialogs.SystemFilePicker"

sal_Bool SvtFilePicker::HasSystemFilePicker( const Reference< XMultiServiceFactory > xFactory )
{
    sal_Bool bRet = sal_False;

	Reference< XContentEnumerationAccess > xEnumAccess( xFactory, UNO_QUERY );
    Reference< XSet > xSet( xFactory, UNO_QUERY );

    if ( ! xEnumAccess.is() || ! xSet.is() )
        return bRet;

    try
    {
    	OUString aFileService( RTL_CONSTASCII_USTRINGPARAM( SYSTEM_FILE_OPEN_SERVICE_NAME ) );

        Reference< XEnumeration > xEnum = xEnumAccess->createContentEnumeration( aFileService );
        if ( xEnum.is() && xEnum->hasMoreElements() )
            bRet = sal_True;
    }

    catch( IllegalArgumentException ) {}
    catch( ElementExistException ) {}

    return bRet;
}

//------------------------------------------------------------------------------------
sal_Bool SvtFilePicker::UseSystemFilePicker()
{
    SvtMiscOptions aOptions;

    sal_Bool bRet = aOptions.UseSystemFileDialog();

    return bRet;
}

//------------------------------------------------------------------------------------
// XServiceInfo
//------------------------------------------------------------------------------------

/* XServiceInfo */
UNOOUSTRING SAL_CALL SvtFilePicker::getImplementationName() throw( UNORUNTIMEEXCEPTION )
{
	return impl_getStaticImplementationName();
}

/* XServiceInfo */
sal_Bool SAL_CALL SvtFilePicker::supportsService( const UNOOUSTRING& sServiceName ) throw( UNORUNTIMEEXCEPTION )
{
    UNOSEQUENCE< UNOOUSTRING > seqServiceNames = getSupportedServiceNames();
    const UNOOUSTRING* pArray = seqServiceNames.getConstArray();
    for ( sal_Int32 i = 0; i < seqServiceNames.getLength(); i++ )
	{
        if ( sServiceName == pArray[i] )
		{
            return sal_True ;
		}
	}
    return sal_False ;
}

/* XServiceInfo */
UNOSEQUENCE< UNOOUSTRING > SAL_CALL SvtFilePicker::getSupportedServiceNames() throw( UNORUNTIMEEXCEPTION )
{
	return impl_getStaticSupportedServiceNames();
}

/* Helper for XServiceInfo */
UNOSEQUENCE< UNOOUSTRING > SvtFilePicker::impl_getStaticSupportedServiceNames()
{
	UNOMUTEXGUARD aGuard( UNOMUTEX::getGlobalMutex() );
    UNOSEQUENCE< UNOOUSTRING > seqServiceNames( 1 );
    UNOOUSTRING* pArray = seqServiceNames.getArray();
    pArray[0] = UNOOUSTRING::createFromAscii( "com.sun.star.ui.dialogs.FilePicker" );
    return seqServiceNames ;
}

/* Helper for XServiceInfo */
UNOOUSTRING SvtFilePicker::impl_getStaticImplementationName()
{
	return UNOOUSTRING::createFromAscii( "com.sun.star.svtools.FileOpen" );
}

/* Helper for registry */
Reference< UNOXINTERFACE > SAL_CALL SvtFilePicker::impl_createInstance( const Reference< UNOXMULTISERVICEFACTORY >& xServiceManager ) throw( UNOEXCEPTION )
{
    static sal_Bool bCheckedSystemFilePicker = sal_False;
    static sal_Bool bHasSystemFilePicker = sal_True;

    Reference< UNOXINTERFACE > xRet;

    if ( ! bCheckedSystemFilePicker )
        bHasSystemFilePicker = HasSystemFilePicker( xServiceManager );

    if ( bHasSystemFilePicker && UseSystemFilePicker() )
    {
    	OUString aFileService( RTL_CONSTASCII_USTRINGPARAM( SYSTEM_FILE_OPEN_SERVICE_NAME ) );
        xRet = xServiceManager->createInstance( aFileService );
    }

    if ( !xRet.is() )
        xRet = Reference< UNOXINTERFACE >( *new SvtFilePicker( xServiceManager ) );

	::svt::addFilePicker( xRet );

    return xRet;
}

//------------------------------------------------------------------------------------
// property set related methods
//------------------------------------------------------------------------------------
::cppu::IPropertyArrayHelper* SvtFilePicker::createArrayHelper( ) const
{
	Sequence< Property > aProps;
	describeProperties( aProps );
	return new cppu::OPropertyArrayHelper( aProps );
}

::cppu::IPropertyArrayHelper& SAL_CALL SvtFilePicker::getInfoHelper()
{
	return *const_cast< SvtFilePicker* >( this )->getArrayHelper();
}

Reference< XPropertySetInfo > SAL_CALL SvtFilePicker::getPropertySetInfo(  ) throw(RuntimeException)
{
	return ::cppu::OPropertySetHelper::createPropertySetInfo( getInfoHelper() );
}

void SAL_CALL SvtFilePicker::setFastPropertyValue_NoBroadcast( sal_Int32 _nHandle, const Any& _rValue ) throw (Exception)
{
	OPropertyContainer::setFastPropertyValue_NoBroadcast( _nHandle, _rValue );

	// if the HelpURL changed, forward this to the dialog
	if ( PROPERTY_ID_HELPURL == _nHandle )
		if ( m_pImpl && m_pImpl->m_pDlg )
			m_pImpl->m_pDlg->SetHelpId( SvtFilePicker_Impl::getHelpId( m_pImpl->m_sHelpURL ) );
}

//------------------------------------------------------------------------------------
// class FileNotifyHelper_Impl
//------------------------------------------------------------------------------------
void FileNotifyHelper_Impl::Notify( short nEventId, short nControlId )
{
	if ( mpParent )
        mpParent->notify( nEventId, nControlId );
}
