/*************************************************************************
 *
 *  $RCSfile: sbxobj.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:58:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SBX_SBXOBJECT_HXX
#define _SBX_SBXOBJECT_HXX

#include <sbxvar.hxx>

#ifndef _SFXLSTNER_HXX
#include <lstner.hxx>
#endif

#ifndef __SBX_SBXOBJECT_HXX
#define __SBX_SBXOBJECT_HXX

///////////////////////////////////////////////////////////////////////////

class SbxProperty;
class SvDispatch;

class SbxObject : public SbxVariable, public SfxListener
{
	SbxArray* FindVar( SbxVariable*, USHORT& );
	// AB 23.3.1997, Spezial-Methode fuer VCPtrRemove (s.u.)
	SbxArray* VCPtrFindVar( SbxVariable*, USHORT& );
protected:
	SbxArrayRef  pMethods;			// Methoden
	SbxArrayRef  pProps;			// Properties
	SbxArrayRef  pObjs;				// Objekte
	SbxProperty* pDfltProp;			// Default-Property
	String       aClassName;        // Klassenname
	virtual BOOL LoadData( SvStream&, USHORT );
	virtual BOOL StoreData( SvStream& ) const;
	virtual ~SbxObject();
	virtual void SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
							 const SfxHint& rHint, const TypeId& rHintType );
public:
	SBX_DECL_PERSIST_NODATA(SBXCR_SBX,SBXID_OBJECT,1);
	TYPEINFO();
	SbxObject( const String& rClassname );
	SbxObject( const SbxObject& );
	SbxObject& operator=( const SbxObject& );
	virtual SbxDataType GetType() const;
	virtual SbxClassType GetClass() const;
	virtual void Clear();

	virtual BOOL  IsClass( const String& ) const;
	const String& GetClassName() const { return aClassName; }
	void		  SetClassName( const String &rNew ) { aClassName = rNew; }
	// Default-Property
	SbxProperty* GetDfltProperty() const { return pDfltProp; }
	void SetDfltProperty( const String& r );
	void SetDfltProperty( SbxProperty* );
	// Suchen eines Elements
	virtual SbxVariable* FindUserData( UINT32 nUserData );
	virtual SbxVariable* Find( const String&, SbxClassType );
	SbxVariable* FindQualified( const String&, SbxClassType );
	// Quick-Call-Interface fuer Methoden
	virtual BOOL Call( const String&, SbxArray* = NULL );
	// Execution von DDE-Kommandos
	SbxVariable* Execute( const String& );
	// Elemente verwalten
	virtual BOOL GetAll( SbxClassType ) { return TRUE; }
	SbxVariable* Make( const String&, SbxClassType, SbxDataType );
	virtual SbxObject* MakeObject( const String&, const String& );
	virtual void Insert( SbxVariable* );
	// AB 23.4.1997, Optimierung, Einfuegen ohne Ueberpruefung auf doppelte
	// Eintraege und ohne Broadcasts, wird nur in SO2/auto.cxx genutzt
	void QuickInsert( SbxVariable* );
	// AB 23.3.1997, Spezial-Methode, gleichnamige Controls zulassen
	void VCPtrInsert( SbxVariable* );
	virtual void Remove( const String&, SbxClassType );
	virtual void Remove( SbxVariable* );
	// AB 23.3.1997, Loeschen per Pointer fuer Controls (doppelte Namen!)
	void VCPtrRemove( SbxVariable* );
	void SetPos( SbxVariable*, USHORT );

	// Makro-Recording
	virtual String GenerateSource( const String &rLinePrefix,
								   const SbxObject *pRelativeTo );
	// Direktzugriff auf die Arrays
	SbxArray* GetMethods()		{ return pMethods;	}
	SbxArray* GetProperties()	{ return pProps; 	}
	SbxArray* GetObjects()		{ return pObjs; 	}
	// Hooks
	virtual SvDispatch* GetSvDispatch();
	// Debugging
	void Dump( SvStream&, BOOL bDumpAll=FALSE );

	static void GarbageCollection( ULONG nObjects = 0 /* ::= all */ );
};

#ifndef __SBX_SBXOBJECTREF_HXX

#ifndef SBX_OBJECT_DECL_DEFINED
#define SBX_OBJECT_DECL_DEFINED
SV_DECL_REF(SbxObject)
#endif
SV_IMPL_REF(SbxObject)

#endif
#endif
#endif
