/*************************************************************************
 *
 *  $RCSfile: dumppoly.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: tl $ $Date: 2001/07/20 13:20:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>


#ifndef _XPOLY_HXX //autogen
#include <svx/xpoly.hxx>
#endif
#ifndef _XOUTX_HXX //autogen
#include <svx/xoutx.hxx>
#endif
#ifndef _SV_GEN_HXX //autogen
#include <tools/gen.hxx>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#ifndef _SV_METRIC_HXX //autogen
#include <vcl/metric.hxx>
#endif
#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

#include "types.hxx"
#include "utility.hxx"

#define BYTES_PER_LINE  16
#define FONT_NAME       FONTNAME_MATH
#define FONT_WEIGHT		WEIGHT_NORMAL
#define FONT_ITALIC     ITALIC_NONE
#define INIT_SIZE		1024
#define INC_SIZE		1024


// chars to map into polygons
sal_Unicode aChars[] =
{
	MS_LINE,		MS_DLINE,		MS_SQRT,		MS_SQRT2,
	MS_HAT,			MS_TILDE,		MS_BAR,			MS_VEC,
	MS_LBRACE,		MS_RBRACE,		MS_LPARENT,		MS_RPARENT,
	MS_LANGLE,		MS_RANGLE,		MS_LBRACKET,	MS_RBRACKET,
	MS_LDBRACKET,	MS_RDBRACKET,	MS_LCEIL,		MS_RCEIL,
	MS_LFLOOR,		MS_RFLOOR,		MS_OVERBRACE,	MS_UNDERBRACE
};


class MyApp : public Application
{
public:
	virtual void Main();
};


MyApp  aMyApp;


ULONG BinDataTextOut(SvMemoryStream &rMemStrm, SvFileStream &rOutStrm);

////////////////////////////////////////
// Mit diesem kleinen Programm werden die Polygon Daten erzeugt, die in den
// StarMath resource Dateien verwendet werden.
// Das Executable ist spter im bin Verzeichnis des Projects.
//

void MyApp::Main()
{
	WorkWindow aMainWin (NULL, WB_APP | WB_STDWORK);
	String aWinText( String::CreateFromAscii( "StarMath - DumpPoly" ) );
	aMainWin.SetText( aWinText );
	aMainWin.SetOutputSizePixel( Size(600, 400) );
	aMainWin.ShowFullScreenMode( FALSE );

	aMainWin.Show();

	String aFileName( String::CreateFromAscii( "dumppoly.txt" ) );
	SvFileStream    aOutStrm (aFileName, STREAM_WRITE | STREAM_TRUNC);

	// hier nehmen wir TRUE
	// (das Ergebnis ist deutlich besser)
	BOOL    bOptimizeSize = TRUE;

	// hier ein doppelt so groer Font wie die default-Basisgre
	// (in der Hoffnung auf etwas mehr Genauigkeit/Details bei den Polygonen)
    String  aFontName( String::CreateFromAscii( FONT_NAME ) );
    Font    aFont( aFontName, Size(0, SmPtsTo100th_mm(24)) );
    //aFont.SetCharSet(RTL_TEXTENCODING_SYMBOL);
    //aFont.SetFamily();
	//aFont.SetStyleName();
	aFont.SetWeight(FONT_WEIGHT);
	aFont.SetItalic(FONT_ITALIC);
	//aFont.SetPitch();

	Window *pWin = new Window(&aMainWin, WB_APP | WB_STDWORK);
	//! denselben MapMode wie im Math setzen
	pWin->SetMapMode( MapMode(MAP_100TH_MM) );
	pWin->SetFont(aFont);

	int nCount = sizeof(aChars) / sizeof(aChars[0]);
	for (int i = 0;  i < nCount;  i++)
	{
		// jedesmal einen neuen LEEREN memory-stream anlegen
		SvMemoryStream  aMemStrm (INIT_SIZE, INC_SIZE);

		sal_Unicode	  cChar 	 = aChars[i];
		Size		  aFontSize	 (pWin->GetFontMetric().GetSize().Width(),
								  pWin->GetFont().GetSize().Height());
		XPolyPolygon  aPoly   	 (XOutGetCharOutline(cChar, *pWin, bOptimizeSize));
		Rectangle	  aBoundRect (aPoly.GetBoundRect());

        aMemStrm << (sal_Unicode) cChar
				 << aFontSize
				 << aBoundRect.TopLeft()
				 << aBoundRect.GetSize()
				 << aPoly;
		if (aMemStrm.Tell() & 0x01)	// ungerade Anzahl Bytes im Stream?
			aMemStrm << '\0';		// auf Vielfaches von 2Byte erhhen

		char aBuf[81];
		sprintf(aBuf, "// Zeichen: 0x%04X    Font: %s",
            (sal_uInt16) cChar, FONT_NAME);
		aOutStrm.WriteLines( ByteString( aBuf ) );

		// zurueckspulen zum auslesen
		aMemStrm.Seek(STREAM_SEEK_TO_BEGIN);
		BinDataTextOut(aMemStrm, aOutStrm);
	}

	delete pWin;

	Execute();
}


ULONG BinDataTextOut(SvMemoryStream &rMemStrm, SvFileStream &rOutStrm)
{
    unsigned char  aLineBuf[BYTES_PER_LINE],
				   a2ByteBuf[25];
	ULONG  i, k, n;

	ByteString aTmpStr;
	k = 0;
	while (!rMemStrm.IsEof())
	{
        memset(aLineBuf, BYTES_PER_LINE, 0);
        n = rMemStrm.Read( aLineBuf, BYTES_PER_LINE );
		if (n)
		{
//			aTmpStr += "\"";
			DBG_ASSERT((n & 0x01) == 0, "ungerade Anzahl von Bytes");
			for(i = 0;  i < n;  i+=2)
			{
                //! Little Endian oder Big Endian bleibt dem Stream
				//! berlassan. (Kommt beim laden wieder hin)
				INT16 nVal = ((USHORT) aLineBuf[i]) << 8 | aLineBuf[i+1];

				sprintf((char *) a2ByteBuf,
					"%6hd;  ", nVal);
//				sprintf((char *) aByteBuf, "\\x%02X", (unsigned) aLineBuf[i]);
				aTmpStr += ByteString((char *) a2ByteBuf);
			}
            k += BYTES_PER_LINE >> 1;
			aTmpStr += "\n";
//			aTmpStr += "\"\n";
		}
	}
#ifdef NEVER
	//! Das ';'  darf nur hinter der letzten aller zu einem Polygon
	//! gehoerenden Zeilen stehen!!
	USHORT nPos = aTmpStr.SearchCharBackward("\"");
	aTmpStr.Insert(";", nPos + 1);;
#endif
	rOutStrm.WriteLines(aTmpStr);

	return rOutStrm.GetError();
}


