/*************************************************************************
 *
 *  $RCSfile: soipc.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:25 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SOIPC_HXX
#define _SOIPC_HXX

#ifndef _PSTREAM_HXX
#include <pstream.hxx>
#endif
#ifndef _SO2REF_HXX
#include <so2ref.hxx>
#endif
#ifndef _IPC2_HXX
#include <ipc2.hxx>
#endif

/*************************************************************************
*************************************************************************/
class SvStorage;
class MemoryBlock;
class SvObject;

#define SO_PERSIST_LOADMONIKER      0x04
#define SO_PERSIST_LOAD             0x05
#define SO_PERSIST_INITNEW          0x06
#define SO_PERSIST_SAVE             0x07
#define SO_PERSIST_SAVEAS           0x08
#define SO_PERSIST_SAVECOMPLETED    0x09
#define SO_PERSIST_HANDSOFF         0x0A
#define SO_PERSIST_ISMODIFIED       0x0B
#define SO_PERSIST_FILLCLASS        0x0C

#define SO_EMBOBJ_VERB              0x10
#define SO_EMBOBJ_DRAW              0x11 /* ToDo */
#define SO_EMBOBJ_SETVISAREA        0x12
#define SO_EMBOBJ_CLIENTCONNECT     0x13
#define SO_EMBOBJ_CLIENTDISCONNECT  0x14
#define SO_EMBOBJ_EMBED_TRUE        0x15
#define SO_EMBOBJ_EMBED_FALSE       0x16
#define SO_EMBOBJ_OPEN_TRUE         0x17
#define SO_EMBOBJ_OPEN_FALSE        0x18
#define SO_EMBOBJ_GETVISAREA        0x19
#define SO_EMBOBJ_SETDOCUMENTNAME   0x1A
#define SO_EMBOBJ_PLUGIN			0x1B

#define SO_EMBCLI_CONNECTED_TRUE    0x20
#define SO_EMBCLI_CONNECTED_FALSE   0x21
#define SO_EMBCLI_EMBEDDED_TRUE     0x22
#define SO_EMBCLI_EMBEDDED_FALSE    0x23
#define SO_EMBCLI_OPENED_TRUE       0x24
#define SO_EMBCLI_OPENED_FALSE      0x25
#define SO_EMBCLI_SAVEOBJECT        0x26
#define SO_EMBCLI_PLUGIN            0x27
#define SO_EMBCLI_CANPLUGIN         0x28

#define SO_ADVISE_CLOSE         	0x30 /* ToDo */

#define SO_ADVSNK_CLOSED       		0x40
#define SO_ADVSNK_VIEW_CHANGED      0x41
#define SO_ADVSNK_DATA_CHANGED      0x42
#define SO_ADVSNK_SAVED             0x43
#define SO_ADVSNK_RENAMED           0x44 /* ToDo */

#define SO_DATAOBJ_GETDATA          0x50
#define SO_DATAOBJ_GETTYPELIST      0x51 /* ToDo */

#define SO_PSEUDOOBJ_UPDATE			0x60
#define SO_PSEUDOOBJ_ISUPTODATE		0x61

#define SO_DISPATCH_NOTIFY          0x70 /* ToDo */

#define SO_BINDCTX_GETMODE  		0x80


class SvSoIPCServer : public SvIPCServiceMgr
{
public:
					SvSoIPCServer();

	// die Objekte gehoeren nicht dem ServiceMgr
	virtual SvIPCService* GetObject( SvGlobalName& rAdr );
};

class SvSoIPCService : public SvIPCService
{
friend SvSoIPCServer;
	SvObject * pObj;
protected:
	virtual BOOL Request( ULONG nSeviceId, SvStream* pIn, SvStream* pOut );
	virtual void NotifyLock( BOOL bLock );
public:
				SvSoIPCService( SvObject * pObj );
				~SvSoIPCService();

	SvObject *	GetObj() { return pObj; }
};

class ErrorBox;

// muss struct wegen define auf IUnknown
class SvSoIPCClient : public SvIPCClient
{
	SvObject *      pObj;
	ErrorBox *		pTimeoutBox;
public:
	BOOL            bLoad;		// embedded Editing
	BOOL            bInitNew;   // embedded Editing


				SvSoIPCClient( const SvGlobalName& rType, SvObject * pObj );
				SvSoIPCClient( SvServiceSocket& rSocket, SvObject * pObj );
				~SvSoIPCClient();

	void 		Connected();

				// das So-Objekt, mit dem der Client verbunden ist
	SvObject *  GetObj() const { return pObj; }

				// Timeout handling
	virtual ULONG Timeout();
				 // Transaktion ist im Timeout-Handler fertig geworden
	virtual void TransactionArrived();

	BOOL        Transact_BoolRet( ULONG nServiceId, const SvStream * pIn = NULL );
	ErrCode 	Transact_ErrRet( ULONG nServiceId, const SvStream * pIn = NULL );
	void        SendBoolNotify( ULONG nServiceId, BOOL bVal );

	void        Disconnect();
};

#endif // _SOIPC_HXX
