/*************************************************************************
 *
 *  $RCSfile: fsetvwsh.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: mba $ $Date: 2001/09/13 12:25:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SPLITWIN_HXX //autogen wg. SplitWindow
#include <vcl/splitwin.hxx>
#endif
#ifndef _UNDO_HXX //autogen wg. SfxUndoAction
#include <svtools/undo.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen wg. SfxBoolItem
#include <svtools/eitem.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen wg. QueryBox
#include <vcl/msgbox.hxx>
#endif

#include <svtools/urihelper.hxx>
#include <svtools/asynclink.hxx>

#pragma hdrstop

#include "sfxresid.hxx"
#include "fsetobsh.hxx"
#include "shell.hxx"
#include "msg.hxx"
#include "msgpool.hxx"
#include "view.hrc"
#include "mnumgr.hxx"
#include "objface.hxx"
#include "hintpost.hxx"
#include "request.hxx"
#include "urlframe.hxx"
#include "genlink.hxx"
#include "framedlg.hxx"
#include "dispatch.hxx"
#include "docfile.hxx"
#include "fsetvwsh.hxx"
#include "topfrm.hxx"
#include "sfxtypes.hxx"
#include "sfxbasecontroller.hxx"

//=========================================================================

DBG_NAME(SfxFrameSetViewShell);

#define SfxFrameSetViewShell
#include "sfxslots.hxx"

//=========================================================================

TYPEINIT1(SfxFrameSetViewShell, SfxViewShell);

SFX_IMPL_INTERFACE(SfxFrameSetViewShell,SfxViewShell,SfxResId(0))
{
//	SFX_POPUPMENU_REGISTRATION( SfxResId( RID_FRAMESET_MENU ) );
}

//=========================================================================
class SfxFrameSetWindow_Impl : public SplitWindow
{
friend class SfxFrameSetViewShell;

private:
	SfxFrameSetViewShell*	pShell;
	long					nDefaultSplitSize;
	sal_Bool				bFirstResize;

public:
							SfxFrameSetWindow_Impl( SfxFrameSetViewShell* pSh,
									Window *pParent, WinBits nBits = WB_3DLOOK ) :
								SplitWindow( pParent, nBits | WB_NOSPLITDRAW ),
								pShell( pSh ), bFirstResize( sal_True )
							{
								nDefaultSplitSize = GetSplitSize( 0 );
							}

	void					UpdateFrameSize( SfxFrameSetDescriptor* );
	void					UpdateFrameSpacing( SfxFrameSetDescriptor* );
	virtual void			Command( const CommandEvent& rCEvt );
	void					Resize();
	void					DeleteEmptySets( sal_uInt16 nSet=0 );
	virtual void 			KeyInput( const KeyEvent& rKeyEvent );
};

void SfxFrameSetWindow_Impl::KeyInput( const KeyEvent& rKeyEvent )
{
	if ( !pShell || !pShell->KeyInput( rKeyEvent ) )
		SplitWindow::KeyInput( rKeyEvent );
}

struct SfxFrameSet_Impl
{
	sal_Bool                    bInit;
	sal_Bool                    bLoading;
	SfxURLFrame*                pActiveFrame;
    svtools::AsynchronLink      aLink;
	SfxFrameSetWindow_Impl*     pWindow;
	sal_uInt16                  nLoadingFrames;
};

//=========================================================================

class UndoAction_Impl : public SfxUndoAction
{
friend class SfxFrameSetViewShell;

	SfxFrameSetDescriptor*	pUndo;
	SfxFrameSetDescriptor*	pRedo;
	SfxFrameSetViewShell*	pShell;
	sal_Bool					bCloseChildren;
	XubString 					aComment;

public:
							UndoAction_Impl( SfxFrameSetViewShell *pSh,
									SfxFrameSetDescriptor *pD1,
									SfxFrameSetDescriptor *pD2,
									const XubString& rComment,
									sal_Bool bClose = sal_False ) :
								pShell( pSh ),
								pUndo( pD1 ),
								pRedo( pD2 ),
								aComment( rComment ),
								bCloseChildren( bClose )
							{}

							~UndoAction_Impl()
							{
								delete pUndo;
								delete pRedo;
							}

	virtual void			Undo();
	virtual void			Redo();
	virtual UniString		GetComment() const;
};

UniString	UndoAction_Impl::GetComment() const
{
	return aComment;
}

//-------------------------------------------------------------------------

void UndoAction_Impl::Undo()
{
	DBG_ASSERT( pUndo, "Keine Undo-Information!");
	SfxViewFrame *pViewFrame = pShell->GetViewFrame();
	pShell->GetSplitWindow()->SetUpdateMode( sal_False );
	if ( bCloseChildren )
		pViewFrame->GetFrame()->CloseChildFrames();
	if ( pUndo )
		pShell->ReFill( pUndo );
	pShell->GetSplitWindow()->SetUpdateMode( sal_True );

	SfxFrameSetObjectShell *pDoc =
		PTR_CAST( SfxFrameSetObjectShell, pViewFrame->GetObjectShell() );
	pShell->EndListening( *pDoc );
	pDoc->TakeDescriptor( pShell->GetDescriptor_Impl() );
	pShell->StartListening( *pDoc );
}

//-------------------------------------------------------------------------

void UndoAction_Impl::Redo()
{
	DBG_ASSERT( pRedo, "Keine Redo-Information!");
	SfxViewFrame *pViewFrame = pShell->GetViewFrame();
	pShell->GetSplitWindow()->SetUpdateMode( sal_False );
	if ( bCloseChildren )
		pViewFrame->GetFrame()->CloseChildFrames();
	if ( pRedo )
		pShell->ReFill( pRedo );
	pShell->GetSplitWindow()->SetUpdateMode( sal_True );

	SfxFrameSetObjectShell *pDoc =
		PTR_CAST( SfxFrameSetObjectShell, pViewFrame->GetObjectShell() );
	pShell->EndListening( *pDoc );
	pDoc->TakeDescriptor( pShell->GetDescriptor_Impl() );
	pShell->StartListening( *pDoc );
}

void SfxFrameSetWindow_Impl::DeleteEmptySets( sal_uInt16 nSet )
{
	for ( sal_uInt16 n=0; n<GetItemCount(nSet); )
	{
		sal_uInt16 nId = GetItemId( n, nSet );
		if ( !GetItemWindow( nId ) )
		{
			if ( GetItemCount( nId ) )
				DeleteEmptySets( nId );
			if ( !GetItemCount( nId ) )
				RemoveItem( nId );
			else
				n++;
		}
		else
			n++;
	}
}


void SfxFrameSetWindow_Impl::Command ( const CommandEvent& rCEvt )
/* [Beschreibung]
 */
{
	// Nur ContextMenu
	if ( rCEvt.GetCommand() != COMMAND_CONTEXTMENU )
		return;

	// Die ItemId des Sets holen, zu dem der Zwischenraum geh"ort, auf den
	// geclickt wurde
	sal_uInt16 nId = GetItemId( rCEvt.GetMousePosPixel() );
	sal_uInt16 nSet = GetSet( nId );
}

//-------------------------------------------------------------------------

void SfxFrameSetWindow_Impl::UpdateFrameSize( SfxFrameSetDescriptor* pSet )
{
	for ( sal_uInt16 n=0; n<pSet->GetFrameCount(); n++ )
	{
		SfxFrameDescriptor *pD = pSet->GetFrame( n );
		sal_uInt16 nItemId = pD->GetItemId();
		if ( IsItemValid( nItemId ) )
		{
			long nSize = GetItemSize( nItemId );
			pD->SetWidth( nSize );
		}
		if ( pD->GetFrameSet() )
			UpdateFrameSize( pD->GetFrameSet() );
	}
}

void SfxFrameSetWindow_Impl::Resize()
{
	SplitWindow::Resize();
	if ( bFirstResize )
		bFirstResize = sal_False;
}


//-------------------------------------------------------------------------

void SfxFrameSetWindow_Impl::UpdateFrameSpacing( SfxFrameSetDescriptor* pSet )
{
	sal_uInt16 nSet = 0;
	if ( pSet->GetParentFrame() )
		nSet = pSet->GetParentFrame()->GetItemId();

	if ( nSet && !IsItemValid( nSet ) )
		return;

	if ( pSet->IsFrameSpacingSet() )
	{
		// Wenn explizit ein FrameSpacing gesetzt ist, wird es in das
		// Splitwindow "ubernommen, sonst bleibt es SV "uberlassen
		SetSplitSize( nSet, pSet->GetFrameSpacing(), sal_True );
	}

	for ( sal_uInt16 n=0; n<pSet->GetFrameCount(); n++ )
	{
		SfxFrameDescriptor *pD = pSet->GetFrame( n );
		if ( pD->GetFrameSet() )
			UpdateFrameSpacing( pD->GetFrameSet() );
	}
}

//------------------------------------------------------------------
IMPL_LINK( SfxFrameSetViewShell, SplitHdl_Impl, SfxFrameSetWindow_Impl*, pWindow )
{
	SfxFrameSetDescriptor *pSet = GetDescriptor_Impl();
	if ( IsInEditMode() )
	{
		// F"ur das Undo eine Kopie des alten Descriptors ziehen
		SfxFrameSetDescriptor *pUndo = pSet->Clone();

		// Die Descriptoren updaten
		pImp->pWindow->UpdateFrameSize( pSet );

		// Die "Anderungen an das Dokument weitergeben
		SfxFrameSetObjectShell *pDoc =
			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
		EndListening( *pDoc );
		pDoc->TakeDescriptor( pSet );
		StartListening( *pDoc );

		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
		GetUndoManager()->AddUndoAction( new UndoAction_Impl( this,
					pUndo, pSet->Clone(), String( SfxResId( STR_FRAMESIZE ) ) ) );
	}
	else
		pImp->pWindow->UpdateFrameSize( pSet );

	return 1L;
}

void SfxFrameSetViewShell::UpdateFrameBorder( SfxFrameSetDescriptor* pSet )
{
	sal_uInt16 nSet = 0;
	if ( pSet->GetParentFrame() )
		nSet = pSet->GetParentFrame()->GetItemId();

	if ( nSet && !pImp->pWindow->IsItemValid( nSet ) )
		return;

	for ( sal_uInt16 n=0; n<pSet->GetFrameCount(); n++ )
	{
		SfxFrameDescriptor *pD = pSet->GetFrame( n );
		SfxFrameSetDescriptor *pSubSet = pD->GetFrameSet();

		if ( !pSubSet || pSubSet->IsRootFrameSet() )
		{
			SfxURLFrame* pURL = PTR_CAST( SfxURLFrame,
				GetViewFrame()->GetFrame()->SearchFrame_Impl( pD->GetItemId(), sal_True ) );
			pURL->Update();
		}

		if ( pD->GetFrameSet() )
			UpdateFrameBorder( pD->GetFrameSet() );
	}
}

//-------------------------------------------------------------------------

void SfxFrameSetViewShell::Construct()
{
	StartListening( *SFX_APP() );
	SfxViewFrame *pViewFrame = GetViewFrame();
	SfxFrame *pFrame = pViewFrame->GetFrame();

	pViewFrame->UpdateTitle( );
	DBG_ASSERT( !pViewFrame->GetActiveChildFrame_Impl(), "Constructing FrameSetView in Frame with active child!" );

	// Am FrameSetDokument horchen
	SfxFrameSetObjectShell *pObj = PTR_CAST( SfxFrameSetObjectShell,
									pViewFrame->GetObjectShell());
	DBG_ASSERT( pObj, "Falsche ObjectShell!");
	StartListening( *pObj );

	SFX_ITEMSET_ARG( pObj->GetMedium()->GetItemSet(), pDescrItem,
					 SfxFrameDescriptorItem, SID_FRAMEDESCRIPTOR, sal_False);

	if ( IsImplementedAsFrameset_Impl() ) pDescrItem = 0;

	// Das SplitWindow als EditWindow erzeugen bzw. vom Parent holen
	pImp = new SfxFrameSet_Impl;
	pImp->pActiveFrame = NULL;

	pImp->nLoadingFrames = 0;
	pImp->bInit = sal_False;
	pImp->bLoading = sal_True;

	if ( pFrame->IsTop() || !GetParentFrameSet() )
	{
		// TopFrame oder FloatingFrame
		pImp->pWindow = new SfxFrameSetWindow_Impl( this, &pViewFrame->GetWindow() );
		SetWindow( pImp->pWindow );
		pImp->pWindow->SetSplitHdl( LINK( this, SfxFrameSetViewShell, SplitHdl_Impl ) );

		// Event anmelden zum asynchronen Nachladen der Dokumente in den Frames
		// ( Zuerst mu\s die ::com::sun::star::sdbcx::View vollst"andig konstruiert werden )
		pImp->aLink = LINK( this, SfxFrameSetViewShell, EventHdl_Impl );
	}
	else
	{
		// Parent des ViewFrames mu\s ein ::com::sun::star::util::URL-Frame sein
		SfxFrameSetViewShell *pShell = GetParentFrameSet();
		while ( !pShell->GetWindow() )
			pShell = pShell->GetParentFrameSet();
		pImp->pWindow = pShell->pImp->pWindow;
		pImp->aLink = LINK( this, SfxFrameSetViewShell, EventHdl_Impl );
	}

	// Zuerst nachsehen, ob der FrameSetDescriptor des Dokuments oder ein
	// anderer genommen werden soll, der in BrowseForward/Backward gesetzt wurde
	SfxFrameDescriptor *pFrm = NULL;
	if( pDescrItem )
		pFrm = pDescrItem->GetProperties().pFrame;
	sal_Bool bReFill = ( pFrm != NULL && pFrm->GetFrameSet() != NULL );

	// Eventuell ist ein Reload mit ReFill angefordert worden. Der kann nur genommen
	// werden, sofern sich die Struktur der Seite nicht ge"andert hat
	SfxFrame *pTopFrame = pFrame->GetTopFrame();
	sal_Bool bReload = pTopFrame->GetCurrentDocument()->IsReloading();

	// Anmerkung: wenn die FrameSetObjectShell auch auf FrameDescriptor statt
	// FrameSetDescriptor umgestellt ist, kann das in CompareOriginal einbezogen
	// werden
	if ( bReload && bReFill && pFrame == pTopFrame &&
		pTopFrame->GetDescriptor()->GetURL() != pFrm->GetURL() )
		// AutoReload mit neuer ::com::sun::star::util::URL
		bReFill = sal_False;

	if ( bReFill &&
		!pObj->GetFrameSetDescriptor()->CompareOriginal(*pFrm->GetFrameSet() ) )
		// Struktur ver"andert
		bReFill = sal_False;

	if( !bReFill )
	{
		// Kein gesetzter oder nicht mehr g"ultiger Descriptor; Description
		// von der DocShell abkopieren
		if ( pFrm && pFrm->GetFrameSet() )
			delete pFrm->GetFrameSet();
		pFrm = pFrame->GetDescriptor();
		pObj->GetFrameSetDescriptor()->Clone( pFrm );
	}
	else
	{
		DBG_ASSERT( pFrm->GetFrameSet(), "Descriptor ohne Framset !" );
		pFrm = pFrm->Clone();

		// Den Frame mit dem richtigen Descriptor versehen
		pFrame->SetDescriptor( pFrm );
	}

	// Eigenen Pointer zum schnellen Zugriff merken
	pDescriptor = pFrm->GetFrameSet();

	// Das FrameSet asynchron aufbauen; sonst funzt die ExplorerViewShell nicht
	pImp->aLink.Call( this );
	SetUndoManager( new SfxUndoManager() );
	pObj->GetMedium()->GetItemSet()->ClearItem( SID_FRAMEDESCRIPTOR );

	SFX_ITEMSET_ARG( pObj->GetMedium()->GetItemSet(),
				pItem, SfxBoolItem, SID_TEMPLATE, sal_False );
	if ( pItem && pItem->GetValue() && GetWindow() && !IsImplementedAsFrameset_Impl() )
		SetEditMode( sal_True );
}

//-------------------------------------------------------------------------

IMPL_LINK( SfxFrameSetViewShell, EventHdl_Impl, void*, pVoid )
/*	[Beschreibung]
	Event-Handler, "uber den das FrameSet im SplitWindow initial erzeugt
	wird.
*/
{
	// Vor dem ersten Resize Frameset nicht aufbauen, da sonst der gr"o\ste
	// Frame nicht ermittelt werden kann
	if ( pImp->pWindow->bFirstResize &&
		 GetViewFrame()->GetFrame()->GetTopFrame()->
		 GetCurrentViewFrame()->IsVisible() )
	{
		pImp->aLink.Call( this,sal_False,sal_True );
		return 0L;
	}

	pImp->bInit = sal_True;
	Fill( pDescriptor );

	if ( !pImp->nLoadingFrames )
	{
		pImp->bLoading = sal_False;
		GetObjectShell()->FinishedLoading();
		GetViewFrame()->GetDispatcher()->Execute( SID_EDIT_FRAMESET );

		// Wenn ich selbst in einem Frameset sitze, wurde dort das LoadFinished bisher
		// unterdr"uckt; also jetzt erneut senden
		SfxURLFrame *pURL = PTR_CAST( SfxURLFrame, GetViewFrame()->GetFrame()->GetParentFrame() );
		if ( pURL )
			pURL->LoadFinished_Impl();
	}

	return 0L;
}

//-------------------------------------------------------------------------

void SfxFrameSetViewShell::ReFill( const SfxFrameSetDescriptor *pSet )
/*	[Beschreibung]
	Diese Methode baut das FrameSet im SplitWindow anhand des
	"ubergebenen FrameSetDescriptors neu auf, indem es das SplitWindow
	leert und dann wieder neu f"ullt.
	Aus Performance-Gr"unden wird nur das Splitwindow geleert, die Frames
	aber nicht sofort geclosed, um sie gleich wieder ins Splitwindow einf"ugen
	zu k"onnen, ohne die Dokumente neu laden zu m"ussen.
*/
{
	SfxFrame *pFrame = GetViewFrame()->GetFrame();
	SfxFrameDescriptor *pFrm = pFrame->GetDescriptor();

	// Den FrameSet-Descriptor bis zum Ende retten
	SfxFrameSetDescriptor *pOld = pDescriptor;
	if ( pOld != pSet )
	{
		pFrm->SetFrameSet( NULL );
		pDescriptor = pSet->Clone( pFrm );
	}

	// Alle Frames erst einmal invalidieren
	SfxFrameIterator aIter( *pFrame, sal_True );
	SfxFrame *pChild = aIter.FirstFrame();
	while ( pChild )
	{
		SfxFrame *pNext = aIter.NextFrame( *pChild );
		((SfxURLFrame*)pChild)->SetValidItem_Impl( sal_False );
		pChild = pNext;
	}

	Fill( pDescriptor );

	// Alle URLFrames, die nicht mehr im Frameset vertreten sind, k"onnen
	// jetzt abger"aumt werden
	pChild = aIter.FirstFrame();
	while ( pChild )
	{
		SfxFrame *pNext = aIter.NextFrame( *pChild );
		if ( !((SfxURLFrame*)pChild)->IsValidItem_Impl() )
		{
			// Vorsicht: wenn pNext ein Kind von pChild ist, mu\s erst
			// das nachfolgende Geschwister von pChild als pNext geholt werden
			while ( pNext && pNext->IsParent( pChild ) )
				pNext = aIter.NextFrame( *pNext );
			pChild->DoClose();
		}
		pChild = pNext;
	}

	// Jetzt noch eventuell vorhandene leere Framesets abr"aumen
	pImp->pWindow->DeleteEmptySets();

	// Jetzt pOld l"oschen, alle Frames sind jetzt frei
	if ( pOld != pDescriptor )
		delete pOld;
}

//------------------------------------------------------------------------

void SfxFrameSetViewShell::Fill( const SfxFrameSetDescriptor* pSet )
/*	[Beschreibung]
	Mit dieser Methode wird das FrameSet im SplitWindow anhand des
	"ubergebenen FrameSetDescriptors gef"ullt.
*/
{
	// kein Event mehr empfangen
	pImp->aLink.ClearPendingCall();
	SfxFrameSetWindow_Impl *pWindow = pImp->pWindow;
	pWindow->SetUpdateMode( sal_False );

	// Das FrameSet aufbauen
	SfxFrame *pFrame = GetViewFrame()->GetFrame();
	sal_uInt16 nId = pSet->GetParentFrame() ? pSet->GetParentFrame()->GetItemId() : 0;

	DBG_ASSERT( !nId || pWindow->IsItemValid( nId ), "SplitwindowItem existiert nicht!" );

	DockingWindow* pDock = (DockingWindow*)pWindow->GetItemWindow( nId );
	if ( nId )
	{
		if ( pWindow->IsItemValid( nId ) )
			//Es gibt noch ein Item, das durch das neue Set ersetzt werden soll
			UpdateFrame_Impl( PTR_CAST( SfxURLFrame, pFrame ) );
	}
	else
	{
		WindowAlign eAlign = WINDOWALIGN_LEFT;
		if ( !pDescriptor->IsColSet() )
			eAlign = WINDOWALIGN_TOP;
		pWindow->SetAlign( eAlign );
	}

	if ( pSet->GetWallpaper() )
		pWindow->SetItemBackground( nId, *pSet->GetWallpaper() );

	MakeWindows( pSet, pFrame, nId );
	pWindow->SetUpdateMode( sal_True );
	if ( pDock )
		pDock->Hide();

	SfxFrameSetViewShell *pFrameSet = this;
	while ( !pFrameSet->GetWindow() )
		pFrameSet = pFrameSet->GetParentFrameSet();
	if ( !pFrameSet->IsInEditMode() )
	{
		if ( !pFrameSet->GetActiveFrame() || pFrameSet->GetActiveFrame() == pFrame )
		{
			SfxFrameIterator aIter( *pFrame, sal_False );
			SfxFrame *pChild = aIter.FirstFrame();
			SfxFrame *pAktFrame = NULL;
			long aMaxArea=0L;
			Size aSize( pWindow->GetOutputSizePixel() );
			long nSplitHeight = pWindow->GetAlign() == WINDOWALIGN_LEFT ? aSize.Height() : aSize.Width();
			while ( pChild )
			{
				SfxFrame *pNext = aIter.NextFrame( *pChild );
				sal_uInt16 nItemId = pChild->GetFrameId_Impl();
				long nWidth = pWindow->GetItemSize( nItemId, 0 );
				sal_uInt16 nSet = pWindow->GetSet( nItemId );
				long nHeight = nSet ? pWindow->GetItemSize( nSet, 0 ) : nSplitHeight;
				long aArea = nWidth * nHeight;
				if ( aArea > aMaxArea )
				{
					aMaxArea = aArea;
					pAktFrame = pChild;
				}

				pChild = pNext;
			}

			if ( pAktFrame )
				pFrameSet->SetActiveFrame( (SfxURLFrame*) pAktFrame );
		}
	}

	// Alle neuen Mitglieder begr"us\sen ...
	SfxFrameIterator aIter( *pFrame, sal_False );
	SfxFrame *pChild = aIter.FirstFrame();
	while ( pChild )
	{
		SfxFrame *pNext = aIter.NextFrame( *pChild );
		if ( pImp->pWindow->IsItemValid( pChild->GetFrameId_Impl() ) )
			pChild->GetWindow().Update();
		pChild = pNext;
	}
}

//-------------------------------------------------------------------------

void SfxFrameSetViewShell::MakeWindows( const SfxFrameSetDescriptor *pSet,
					SfxFrame *pParent,
					sal_uInt16 nSet )

/*	[Beschreibung]

	Mit dieser Methode wird aus einem FrameSetDescriptor ein ItemSet in
	einem SplitWindow gef"ullt ( nSet = 0 ist das RootSet ).
	F"ur jeden FrameDescriptor im FrameSetDescriptor wird ein SfxURLFrame
	mit gleicher ItemId erzeugt, sofern ein SfxURLFrame der gleichen ItemId
	nicht schon vorhanden ist, weil MakeWindows nicht zum Neuaufbau des
	FrameSets, sondern zum Update mit einem ver"anderten FrameSetDescriptor
	aufgerufen wurde.
	SfxURLFrames mit Descriptoren, die wieder ein FrameSet enthalten, f"ugen
	ein ItemSet in das SplitWindow ein, solche ohne FrameSet ein ItemWindow.
*/
{
	DBG_CHKTHIS(SfxFrameSetViewShell,0);
	sal_uInt16 nActSet = nSet;
	SfxFrame *pFrame = GetViewFrame()->GetFrame();
	SfxFrameSetWindow_Impl *pWindow = pImp->pWindow;
	SfxFrameSetViewShell *pFrameSet = this;
	while ( !pFrameSet->GetWindow() )
		pFrameSet = pFrameSet->GetParentFrameSet();

	if ( pSet->IsFrameSpacingSet() )
	{
		// Wenn explizit ein FrameSpacing gesetzt ist, wird es in das
		// Splitwindow "ubernommen, sonst bleibt es SV "uberlassen
		pWindow->SetSplitSize( nSet, pSet->GetFrameSpacing(), sal_True );
	}

	// F"ur jeden SfxFrameSetDescriptor wird im Splitwindow ein neues
	// ItemSet angelegt (Ausnahme: das Root-ItemSet existiert schon).
	for ( sal_uInt16 nWindowPos=0, nFrame=0; nFrame<pSet->GetFrameCount(); nFrame++ )
	{
		SfxFrameDescriptor* pFD = pSet->GetFrame( nFrame );
		long nWidth = pFD->GetSize();

		SfxURLFrame *pURLFrame = NULL;
		sal_uInt16 n = pFD->GetItemId();
		if ( !n )
		{
			n = pDescriptor->MakeItemId();
			pFD->SetItemId( n );
		}
		else
		{
			// Der Descriptor hat schon eine ID; wenn es einen Frame
			// mit dieser ID gibt, soll der genommen werden
			pURLFrame = (SfxURLFrame*) pParent->SearchFrame_Impl( n );
			if ( pURLFrame )
				pURLFrame->SetValidItem_Impl( sal_True );
		}
/*
		if ( !nWidth && pWindow->IsItemValid( n ) )
		{
			// Frames mit Breite 0 werden nicht eingef"ugt, auch wenn es
			// den URLFrame daf"ur geben mu\s ( wg. ::com::sun::star::script::JavaScript )
			pWindow->RemoveItem( n );
		}
*/
		// ItemBits; im Editmode ist Gr"o\sen"anderung immer erlaubt
		sal_uInt16 nBits = pFD->GetWinBits();
		if ( IsInEditMode() )
			nBits = nBits & ~SWIB_FIXED;

		if ( pFD->GetFrameSet() && !pFD->GetFrameSet()->IsRootFrameSet() )
		{
			// Es wird ein Sub-FrameSet eingef"ugt (direkte Rekursion)
			// ItemSet einf"ugen und mit dem ChildFrameSet weitermachen
			if ( pURLFrame )
			{
				// Zuletzt war dieses Item kein Set, sondern ein Window
				// eines Frames. Der Frame wird anschlie\end bseitigt.
				pWindow->RemoveItem( n );
				pURLFrame->SetValidItem_Impl( sal_False );
				pURLFrame->SetFrameId_Impl( USHRT_MAX );
			}

			if ( pWindow->IsItemValid( n ) )
			{
				if ( pWindow->GetSet( n ) != nActSet ||
						pWindow->GetItemPos( n, nActSet ) != nWindowPos )
				{
					// Es gibt schon ein ItemSet mit dieser Id im SplitWindow;
					// allerdings ist das ParentSet ein anderes, oder die
					// Position im Set hat sich ge"andert
					pWindow->MoveItem( n, nWindowPos, nActSet );
				}

				pWindow->SetItemBits( n, nBits );
				pWindow->SetItemSize( n, nWidth );
				nWindowPos++;
			}
			else // if ( nWidth )
			{
				// Item neu einf"ugen
				pWindow->InsertItem( n, nWidth, nWindowPos++,
					nActSet, nBits );
			}

//			if ( nWidth )
			{
				if ( pFD->GetFrameSet()->GetWallpaper() )
					pWindow->SetItemBackground( n, *pFD->GetFrameSet()->GetWallpaper() );
				MakeWindows( pFD->GetFrameSet(), pParent, n );
			}
		}
		else if ( !pURLFrame || pURLFrame->GetParentFrame() != pParent )
		{
			// Der gesuchte Frame existiert noch nicht; es wird daher
			// zun"achst ein Item neu erzeugt; falls es sich dabei um
			// ein FrameSetDocument handelt, baut der URLFrame beim
			// Laden den Rest des FrameSets auf (->UpdateFrame).
			if ( pWindow->IsItemValid( n ) )
				pWindow->RemoveItem( n );
			if ( pURLFrame )
			{
				pURLFrame->SetValidItem_Impl( sal_False );
				pURLFrame->SetFrameId_Impl( USHRT_MAX );
			}

			if ( pImp->bLoading && pFD->GetActualURL().GetMainURL().Len() )
				pImp->nLoadingFrames++;

//            pURLFrame = new SfxURLFrame( pFD, pFrameSet, pParent );
//			if ( nWidth )
			{
				if( !pWindow->IsItemValid( n ) )
					pWindow->InsertItem( n, pURLFrame->GetDockingWindow(),
						nWidth, nWindowPos, nActSet, nBits );
				nWindowPos++;
			}
		}
		else
		{
			// Den gesuchten Frame gibt es schon, aktuelle
			// Properties "ubernehmen
			if ( pWindow->IsItemValid( n ) )
			{
				// Es gibt schon ein ItemSet mit dieser Id im SplitWindow;
				// allerdings ist das ParentSet ein anderes, oder die
				// Position im Set hat sich ge"andert
				if ( pWindow->GetSet( n ) != nActSet ||
						pWindow->GetItemPos( n, nActSet ) != nWindowPos )
						pWindow->MoveItem( n, nWindowPos, nActSet);
			}

			// Parameter "ubernehmen
			pURLFrame->Update( pFD );
			if ( pURLFrame->GetCurrentViewFrame() )
			{
				// Da ist schon ein Dokument geladen!
				SfxFrameSetViewShell *pFrameSet =
					PTR_CAST( SfxFrameSetViewShell,
					pURLFrame->GetCurrentViewFrame()->GetViewShell() );

				// Der FrameSetDescriptor-Pointer an der FrameSetViewShell mu\s
				// gepflegt werden!
				if ( pFrameSet )
					pFrameSet->pDescriptor = pFD->GetFrameSet();
			}

			if ( pFD->GetFrameSet() && pURLFrame->GetChildFrameCount() )
			{
				// Es ist ein Root-FrameSet, also ein FrameSetDocument,
				// und es ist schon geladen. Also mu\s nur das ItemSet
				// eingef"ugt und mit dem ChildFrameSet weiter gemacht
				// werden.
				if ( !pWindow->IsItemValid( n ) )
				{
//					if ( nWidth )
						pWindow->InsertItem( n, nWidth, nWindowPos++,
							nActSet, nBits );
				}
				else
					nWindowPos++;

				if ( pFD->GetFrameSet()->GetWallpaper() )
					pWindow->SetItemBackground( n, *pFD->GetFrameSet()->GetWallpaper() );
//				if ( nWidth )
					MakeWindows( pFD->GetFrameSet(), pURLFrame, n );
			}
			else
			{
				// Descriptor enth"alt kein FrameSet oder ein noch nicht
				// geladenes FrameSetDocument; erst mal ein neues Item
				// einf"ugem; falls es ein FrameSetDocument ist, baut der
				// URLFrame beim Laden den Rest des FrameSets auf.
				if ( pWindow->IsItemValid( n ) && !pWindow->GetItemWindow( n ) )
					pWindow->RemoveItem( n );

				if ( !pWindow->IsItemValid( n ) )
				{
//					if ( nWidth )
						pWindow->InsertItem( n, pURLFrame->GetDockingWindow(),
							nWidth, nWindowPos++, nActSet, nBits );
				}
				else
					nWindowPos++;
			}
		}
	}
}

//------------------------------------------------------------------

void SfxFrameSetViewShell::SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
					   const SfxHint& rHint, const TypeId& rHintType )
{
}

//------------------------------------------------------------------

SfxFrameSetViewShell::SfxFrameSetViewShell(
	SfxViewFrame *pFrame, const SfxFrameSetViewShell& rWin, sal_uInt16 nFlags ):
	SfxViewShell( pFrame, nFlags ),
	bEditMode( sal_False ),
	pImp( NULL ),
	pDescriptor( NULL )
{
	DBG_CTOR(SfxFrameSetViewShell, 0);
	Construct();
}

//------------------------------------------------------------------

SfxFrameSetViewShell::SfxFrameSetViewShell(
	SfxViewFrame *pFrame, SfxViewShell*, sal_uInt16 nFlags ):
	SfxViewShell( pFrame, nFlags ),
	bEditMode( sal_False ),
	pDescriptor( NULL )
{
	DBG_CTOR(SfxFrameSetViewShell, 0);
	Construct();
}
//------------------------------------------------------------------

SfxFrameSetViewShell::~SfxFrameSetViewShell()
{
	DBG_DTOR(SfxFrameSetViewShell, 0);

	// kein Event mehr empfangen
	pImp->aLink.ClearPendingCall();
	Window *pWindow = GetWindow();
	if ( pWindow )
		pWindow->Hide();

	// Sofern nicht der ViewFrame selbst geclosed wurde, m"ussen noch die
	// ChildFrames abger"aumt werden
	SfxFrame *pFrame = GetViewFrame()->GetFrame();
	pFrame->CloseChildFrames();
	SetWindow( NULL );

	delete pWindow;
	delete pDescriptor;
	delete GetUndoManager();
	delete pImp;
}

//------------------------------------------------------------------

void SfxFrameSetViewShell::OuterResizePixel( const Point &rOfs, const Size &rSize )
{
	// Das FrameSet ist das Fenster
	SetBorderPixel( SvBorder() );
}

//------------------------------------------------------------------------

void SfxFrameSetViewShell::InnerResizePixel( const Point &rOfs, const Size &rSize )
{
	// Das FrameSet ist das Fenster
	SetBorderPixel( SvBorder() );
}

//------------------------------------------------------------------------

void SfxFrameSetViewShell::Activate( sal_Bool bMDI )
{
	SfxViewShell::Activate( bMDI );
}

//------------------------------------------------------------------------

SplitWindow* SfxFrameSetViewShell::GetSplitWindow() const
{
	DBG_CHKTHIS(SfxFrameSetViewShell,0);
	return GetWindow() ? pImp->pWindow : NULL;
}

//-------------------------------------------------------------------------

void SfxFrameSetViewShell::UpdateFrame_Impl( SfxURLFrame *pURLFrame )
/*	[Beschreibung]

	Diese Methode ersetzt ein ItemWindow oder ItemSet durch ein
	anderes ItemWindow oder ItemSet, wenn sich der Inhalt eines URLFrames
	entsprechend ge"andert hat.
 */
{
	DBG_CHKTHIS(SfxFrameSetViewShell,0);

	SfxFrameSetWindow_Impl *pWindow = pImp->pWindow;
	sal_uInt16 nId = pURLFrame->GetFrameId_Impl();
	DockingWindow *pDockWin = (DockingWindow*)pWindow->GetItemWindow( nId );
	SfxFrameDescriptor *pFD = pURLFrame->GetDescriptor();

	// Erst mal das alte Item rausholen; die Id bleibt erhalten
	sal_Bool bUpdateMode = pWindow->IsUpdateMode();
	if ( bUpdateMode )
		pWindow->SetUpdateMode( sal_False );

	// Daten abholen; Width mu\s vom Descriptor kommen, da GetItemSize nur den
	// momentanen absoluten Wert liefert
	DBG_ASSERT( pWindow->IsItemValid ( nId ), "Update auf ungueltiges Item");

	// Attribute
	sal_uInt16 nActSet = pWindow->GetSet( nId );
	sal_uInt16 nPos = pWindow->GetItemPos( nId, nActSet );
	long nWidth = pFD->GetSize();
	sal_uInt16 nBits = pWindow->GetItemBits( nId );
	nBits &= (~SWIB_COLSET);

	// Altes evtl. Item entfernen, Window ( falls vorhanden ) noch nicht hiden
	sal_Bool bWasFrameSet = !pWindow->GetItemWindow( nId );
	sal_Bool bIsFrameSet = pFD->GetFrameSet() != NULL;

	if ( bWasFrameSet != bIsFrameSet )
		pWindow->RemoveItem( nId, sal_False );

	DBG_ASSERT( !pFD->GetItemId() || pFD->GetItemId() == nId, "Falsche Id!" );
	if ( pFD->GetFrameSet() )
	{
		// Das neue Item wird ein Set; es wird sp"ater aufgebaut
		if ( pFD->GetFrameSet()->IsColSet() )
			nBits |= SWIB_COLSET;
		if ( pWindow->IsItemValid( nId ) )
		{
			pWindow->SetItemBits( nId, nBits );
			pWindow->SetItemSize( nId, nWidth );
		}
		else
			pWindow->InsertItem( nId, nWidth, nPos,	nActSet, nBits );

		if ( pFD->GetFrameSet()->GetWallpaper() )
			pWindow->SetItemBackground( nId, *pFD->GetFrameSet()->GetWallpaper() );
	}
	else
	{
		// Das neue Item ist kein Set
		if ( pWindow->IsItemValid( nId ) )
		{
			pWindow->SetItemBits( nId, nBits );
			pWindow->SetItemSize( nId, nWidth );
		}
		else
			pWindow->InsertItem( nId, pURLFrame->GetDockingWindow(), nWidth,
					nPos, nActSet, nBits );
	}

	if ( pDockWin )
	{
		DockingWindow* pDock = (DockingWindow*)pWindow->GetItemWindow( nId );
		if ( pDockWin != pDock )
		{
			// Jetzt ggf. altes ItemWindow hiden
//			if ( bUpdateMode && pDockWin )
//				pDockWin->Hide();
#ifndef MAC
			if ( pDock )
				pDock->Update();
#endif
		}
	}

//	if ( !nWidth )
//		pWindow->RemoveItem( nId );

	if ( bUpdateMode )
		pWindow->SetUpdateMode( sal_True );
}

void SfxFrameSetViewShell::SetActiveFrame( SfxFrame *p )
{
	SfxURLFrame *pFrame = PTR_CAST(SfxURLFrame, p );
	SfxURLFrame*& rpFrame = pImp->pActiveFrame;
	if ( rpFrame != pFrame )
	{
		if ( rpFrame )
			rpFrame->SetActive( sal_False );
		if ( pFrame )
			pFrame->SetActive( sal_True );
		rpFrame = pFrame;
	}

	SfxBindings& rBindings = GetViewFrame()->GetBindings();
	rBindings.Invalidate( SID_FRAME_NAME );
	rBindings.Invalidate( SID_FRAME_CONTENT );
	rBindings.Invalidate( SID_SPLIT_HORIZONTAL );
	rBindings.Invalidate( SID_SPLIT_VERTICAL );
	rBindings.Invalidate( SID_SPLIT_PARENT_HORIZONTAL );
	rBindings.Invalidate( SID_SPLIT_PARENT_VERTICAL );
	rBindings.Invalidate( SID_SOURCEVIEW );
	rBindings.Invalidate( SID_MODIFY_FRAME );
	rBindings.Invalidate( SID_DELETE_FRAME );
}

SfxFrame* SfxFrameSetViewShell::GetActiveFrame() const
{
	return pImp->pActiveFrame;
}

void SfxFrameSetViewShell::SaveUndo( SfxFrameSetDescriptor *pUndo,
	 SfxFrameSetDescriptor *pRedo, const String& aComment, sal_Bool bClose )
{
	GetUndoManager()->AddUndoAction(
		new UndoAction_Impl( this, pUndo, pRedo, aComment, bClose ) );
}

long SfxFrameSetViewShell::GetDefaultSplitSize() const
{
	return pImp->pWindow->nDefaultSplitSize;
}

SfxFrameSetViewShell* SfxFrameSetViewShell::GetParentFrameSet() const
{
	SfxFrame *pFrame = GetViewFrame()->GetFrame()->GetParentFrame();
/*
	while ( pFrame && !( pFrame->GetFrameType() & SFXFRAME_FRAMESET ) )
		pFrame = pFrame->GetParentFrame();
*/
	return pFrame ? PTR_CAST( SfxFrameSetViewShell, pFrame->GetCurrentViewFrame()->GetViewShell() ) : NULL;
}


sal_Bool SfxFrameSetViewShell::StartEditing()
{
	SetEditMode( sal_True );
	SfxViewFrame *pViewFrame = GetViewFrame();
	SplitWindow* pWindow = GetSplitWindow();
	if ( pDescriptor->CheckContent() )
	{
		// Wenn der Inhalt einiger Frames durch Browsen ver"andert
		// worden ist, mu\s durch R"uckfrage beim Benutzer ein
		// Abgleich von urspr"unglichem und aktuellemInhalt in der
		// einen oder anderen Richtung erreicht werden.
		String aMsg( SfxResId(STR_URL_CHANGED) );
		QueryBox aBox( NULL, WinBits( WB_YES_NO_CANCEL | WB_DEF_YES ), aMsg );
		sal_uInt16 nRet = aBox.Execute();
		switch ( nRet )
		{
			case RET_NO:
				// Die aktuell angezeigten Dokumente sollen auch
				// die gespeicherten werden
				pDescriptor->UnifyContent( sal_True );
				break;
			case RET_YES:
			{
				// Vor dem Editieren sollen die urpr"unglichen
				// Inhalte wiedergeholt und angezeigt werden
				pDescriptor->UnifyContent( sal_False );
				pWindow->SetUpdateMode( sal_False );
				pWindow->Clear();
				Fill ( pDescriptor );
				pWindow->SetUpdateMode( sal_True );
				break;
			}
			default:
				// Editieren abbrechen
				SetEditMode( sal_False );
				return sal_False;;
				break;
		}
	}

	// Aktives Child am MDIFrame resetten
    BOOL bSetFocus = pViewFrame->GetWindow().HasChildPathFocus( TRUE );
	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetActiveFrame() );
	pViewFrame->GetFrame()->LockFocus_Impl( sal_True );
	pViewFrame->SetActiveChildFrame_Impl( NULL );

	// Das FrameSet-Dokument aktivieren
    pViewFrame->MakeActive_Impl( bSetFocus );
    if ( bSetFocus )
        GetWindow()->GrabFocus();
    if ( pURL )
        SetActiveFrame( pURL->GetEditFrame_Impl() );
	return sal_True;
}

sal_Bool SfxFrameSetViewShell::EndEditing()
{
	SfxViewFrame *pViewFrame = GetViewFrame();
    BOOL bSetFocus = pViewFrame->GetFrame()->GetWindow().HasChildPathFocus( TRUE );
	if ( GetObjectShell()->IsModified() )
	{
		// A"nderungen sofort speichern
		// Document braucht auf jeden Fall einen Namen, sonst gibt es
		// Probleme beim Browsen
		String aText( SfxResId( STR_QUERY_SAVE_DOCUMENT ) );
		aText.SearchAndReplace( DEFINE_CONST_UNICODE( "$(DOC)" ),
								GetObjectShell()->GetTitle( SFX_TITLE_PICKLIST ) );
		QueryBox aQBox( &pViewFrame->GetWindow(),
						WB_OK_CANCEL | WB_DEF_OK, aText );
		short nRet = aQBox.Execute();
		switch ( nRet )
		{
			case RET_OK :
			{
				pViewFrame->GetDispatcher()->Execute( SID_SAVEDOC, SFX_CALLMODE_SYNCHRON );
				if ( !GetObjectShell()->IsModified() )
				{
					// Nur EditMode beenden, wenn gespeichert
					break;
				}
			}
			case RET_CANCEL:
			{
				// Editieren nicht beenden
				return sal_False;
			}
		}
	}

	SetEditMode( sal_False );

	// Versuchen, einen ChildFrame zu aktivieren
	pViewFrame->GetFrame()->LockFocus_Impl( sal_False );
	SfxViewFrame *pFrm=NULL;
	sal_Bool bReadOnly = pViewFrame->GetObjectShell()->IsReadOnly();

	// Zun"achst an dem gerade selektierten URLFrame
	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetActiveFrame() );
	if ( pURL && pURL->GetCurrentDocument() )
		pFrm = pURL->ActivateChildFrame_Impl();

	// Ansonsten an irgendeinem anderen
	if ( !pFrm )
		pFrm = pViewFrame->GetFrame()->ActivateChildFrame_Impl();

	// Aktives Child am MDIFrame setzen; dabei wird auch das
	// UI wieder entlocked
	if ( pFrm )
        pFrm->MakeActive_Impl( bSetFocus );

	return sal_True;
}

SfxFrame* SfxFrameSetViewShell::Split( sal_uInt16 nItemId, sal_uInt16 nId )
{
	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetViewFrame()->GetFrame()->SearchFrame_Impl( nItemId ) );
	sal_Bool bParent = sal_False;
	// Aus dem "ubergebenen Item sollen zwei werden mit je der halben ::com::sun::star::awt::Size
	if ( pURL )
	{
		SplitWindow* pWindow = pImp->pWindow;

		// Den alten Descriptor f"ur Undo merken
		SfxFrameSetDescriptor *pUndo = pDescriptor->Clone();

		// FrameDescriptor zur ItemId suchen
		SfxFrameDescriptor *pOldFrame = pDescriptor->SearchFrame( nItemId );
		DBG_ASSERT( pOldFrame, "Frame nicht gefunden!" );

		// Parameter aufbereiten
		sal_Bool bParentSplit = sal_False;
		sal_Bool bHorizontalSplit = ( nId == SID_SPLIT_HORIZONTAL );
		if ( nId == SID_SPLIT_PARENT_HORIZONTAL || nId == SID_SPLIT_PARENT_VERTICAL )
		{
			bParentSplit = sal_True;
			bHorizontalSplit = ( nId == SID_SPLIT_PARENT_HORIZONTAL );
		}

		// Split ausf"uhren
		SfxFrameDescriptor *pSplit =
			pOldFrame->Split( bHorizontalSplit, bParentSplit );
		if ( !pSplit )
		{
			pWindow->SetUpdateMode( sal_True );
			delete pUndo;
			return NULL;
		}

//!		SfxFrameSetViewShell *pFrameSet = GetParentFrameSet();
//!		if ( !pFrameSet )
//!			pFrameSet = this;
//!		pFrameSet->ReFill( pFrameSet->pDescriptor );
		ReFill( pDescriptor );

		// "Anderungen an das Dokument weitergeben
		SfxFrameSetObjectShell *pDoc =
			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );

		EndListening( *pDoc );
		pDoc->TakeDescriptor( pDescriptor );
		StartListening( *pDoc );

		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
		SaveUndo( pUndo, pDescriptor->Clone(), SFX_SLOTPOOL().GetSlotName_Impl( nId ) );

		return GetViewFrame()->GetFrame()->SearchFrame_Impl( pSplit->GetItemId() );;
	}

	return NULL;
}

void SfxFrameSetViewShell::SetFrameContent( sal_uInt16 nItemId, const String& rContent )
{
	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetViewFrame()->GetFrame()->SearchFrame_Impl( nItemId ) );
	if ( pURL )
	{
		SplitWindow* pWindow = pImp->pWindow;

		// Den alten Descriptor f"ur Undo merken
		SfxFrameSetDescriptor *pUndo = pDescriptor->Clone();

		// FrameDescriptor zur ItemId suchen
		SfxFrameDescriptor *pD = pDescriptor->SearchFrame( nItemId );
        pD->SetURL( rContent.Len() ? URIHelper::SmartRelToAbs( rContent ) : String() );

		pWindow->SetUpdateMode( sal_False );
		pURL->Update();
		pWindow->SetUpdateMode( sal_True );

		SfxFrameSetObjectShell *pDoc =
			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
		EndListening( *pDoc );
		pDoc->TakeDescriptor( pDescriptor );
		StartListening( *pDoc );

		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
		if ( IsInEditMode() )
			SaveUndo( pUndo, pDescriptor->Clone(), SFX_SLOTPOOL().GetSlotName_Impl( SID_FRAME_CONTENT ) );
		else
			delete pUndo;
	}
}

void SfxFrameSetViewShell::SetFrameName( sal_uInt16 nItemId, const String& rName )
{
	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetViewFrame()->GetFrame()->SearchFrame_Impl( nItemId ) );
	if ( pURL )
	{
		SplitWindow* pWindow = pImp->pWindow;

		// Den alten Descriptor f"ur Undo merken
		SfxFrameSetDescriptor *pUndo = pDescriptor->Clone();

		// FrameDescriptor zur ItemId suchen
		SfxFrameDescriptor *pD = pDescriptor->SearchFrame( nItemId );
		pD->SetName( rName );
		pURL->Update();

		SfxFrameSetObjectShell *pDoc =
			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
		EndListening( *pDoc );
		pDoc->TakeDescriptor( pDescriptor );
		StartListening( *pDoc );

		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
		if ( IsInEditMode() )
			SaveUndo( pUndo, pDescriptor->Clone(), SFX_SLOTPOOL().GetSlotName_Impl( SID_FRAME_NAME ) );
		else
			delete pUndo;
	}
}

void SfxFrameSetViewShell::SetFrameSpacing( long nValue )
{
	if ( pDescriptor->GetFrameSpacing() != nValue )
	{
		SfxFrameSetWindow_Impl* pWindow = pImp->pWindow;

		// Die tats"achlichen Werte berechnen
		long nSpacing = pWindow->GetSplitSize( 0 );
		long nNewSpacing = ( nValue == SPACING_NOT_SET ) ?
			GetDefaultSplitSize() : nValue;

		// Den alten Descriptor f"ur Undo merken
		SfxFrameSetDescriptor *pUndo = pDescriptor->Clone();
		pWindow->SetUpdateMode( sal_False );

		// Es hat sich was ge"andert; ggf. default
		// restaurieren, dann Update
		pDescriptor->SetFrameSpacing( nValue );
		if ( !pDescriptor->IsFrameSpacingSet() )
			pWindow->SetSplitSize( 0, nNewSpacing, sal_True );
		pWindow->UpdateFrameSpacing( pDescriptor );
		UpdateFrameBorder( pDescriptor );

		pWindow->SetUpdateMode( sal_True );

		SfxFrameSetObjectShell *pDoc =
			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
		EndListening( *pDoc );
		pDoc->TakeDescriptor( pDescriptor );
		StartListening( *pDoc );

		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
		SaveUndo( pUndo, pDescriptor->Clone(), SFX_SLOTPOOL().GetSlotName_Impl( SID_FRAMESPACING ) );
	}
}

void SfxFrameSetViewShell::ModifyFrame( sal_uInt16 nItemId, const SfxItemSet& rSet )
{
	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetViewFrame()->GetFrame()->SearchFrame_Impl( nItemId ) );
	if ( pURL )
	{
		SfxFrameSetWindow_Impl* pWindow = pImp->pWindow;

		// Item auswerten
		const SfxPoolItem *pItem;
		SfxItemState eState = rSet.GetItemState( SID_FRAMEDESCRIPTOR, sal_False, &pItem );
		if ( eState != SFX_ITEM_SET )
			// Nichts ver"andert
			return;

		// Den alten Descriptor f"ur Undo merken
		SfxFrameSetDescriptor *pUndo = pDescriptor->Clone();
		pWindow->SetUpdateMode( sal_False );

		// FrameBorder vom Set merken, um "Anderungen mitzubekommen
		SfxFrameDescriptor *pD = pDescriptor->SearchFrame( nItemId );
		SfxFrameSetDescriptor *pSet = pD->GetParent();
		sal_Bool bHasBorder = pSet->HasFrameBorder();

		// "Anderungen vornehmen
		pD->TakeProperties( ((SfxFrameDescriptorItem*)pItem)->GetProperties() );

		// FrameBorder vergleichen
		if ( bHasBorder != pSet->HasFrameBorder() )
			UpdateFrameBorder( pDescriptor );

		// Dann Frame properties updaten
		DBG_ASSERT( pURL->GetDescriptor() == pD, "Falscher Frame!" );
		pURL->Update();

		// Zuletzt FrameSet properties updaten
		sal_uInt16 nSet = pWindow->GetSet( nItemId );
		if ( nSet )
		{
			long nSize = pSet->GetParentFrame()->GetSize();

			// Das ParentSet ist nicht das RootSet, also k"onnen
			// sich ItemSize oder ItemBits ge"andert haben.
//			if ( nSize )
			{
				pWindow->SetItemSize( nSet,
					pSet->GetParentFrame()->GetSize() );

				// ItemBits; im Editmode ist Gr"o\sen"anderung immer erlaubt
				sal_uInt16 nBits = pSet->GetParentFrame()->GetWinBits();
				if ( IsInEditMode() )
					nBits = nBits & ~SWIB_FIXED;
				pWindow->SetItemBits( nSet, nBits );
			}
/*
			else
			{
				// ItemSet ohne ::com::sun::star::awt::Size rausnehmen
				pWindow->RemoveItem( nSet );

				// Alle URLFrames, die nicht mehr im Frameset vertreten sind, k"onnen
				// jetzt abger"aumt werden
				SfxFrameIterator aIter( *GetViewFrame()->GetFrame(), sal_False );
				SfxFrame *pChild = aIter.FirstFrame();
				while ( pChild )
				{
					SfxFrame *pNext = aIter.NextFrame( *pChild );
					if ( !pWindow->IsItemValid( pChild->GetFrameId_Impl() ) )
						pChild->DoClose();
					pChild = pNext;
				}
			}
*/
		}

		pWindow->SetUpdateMode( sal_True );

		SfxFrameSetObjectShell *pDoc =
			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
		EndListening( *pDoc );
		pDoc->TakeDescriptor( pDescriptor );
		StartListening( *pDoc );

		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
		SaveUndo( pUndo, pDescriptor->Clone(), SFX_SLOTPOOL().GetSlotName_Impl( SID_MODIFY_FRAME ) );
	}
}

void SfxFrameSetViewShell::DeleteFrame( sal_uInt16 nItemId )
{
	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetViewFrame()->GetFrame()->SearchFrame_Impl( nItemId ) );
	if ( pURL )
	{
		SfxFrame *pFrame = pURL;
		SplitWindow* pWindow = pImp->pWindow;

		// Den alten Descriptor f"ur Undo merken
		SfxFrameSetDescriptor *pUndo = pDescriptor->Clone();

		// FrameDescriptor und URLFrame f"ur den zu l"oschenden Frame holen
		SfxFrameDescriptor *pD = pDescriptor->SearchFrame( nItemId );

		// Vielleicht soll der letzte Frame eines Sets gel"oscht werden ?
		sal_uInt16 nSet = pWindow->GetSet( nItemId );
		while ( nSet && pWindow->GetItemCount( nSet ) == 1 )
		{
			// Wenn der jeweilige Parent ein FrameSetDocument ist, diesen Frame l"oschen
			SfxFrame *pParent = GetViewFrame()->GetFrame()->GetParentFrame();
			if ( pParent )
				pParent = pParent->SearchFrame_Impl( nSet );
			if ( pParent )
				pFrame = pParent;

			// Auf jeden Fall leere Sets aus dem Descriptor entfernen
			pD = pDescriptor->SearchFrame( nSet );
			nSet = pWindow->GetSet( nSet );
		}

		// Frame closen; dabei werden neben dem ItemWindow auch die leeren Itemsets oberhalb pFrame entfernt
		pFrame->DoClose();
		pD->GetParent()->RemoveFrame( pD );
		delete pD;

		// Einen Frame brauche ich immer zum Editieren...
		if ( !pDescriptor->GetFrameCount() )
		{
			pDescriptor->SetColSet( sal_True );
			pD = new SfxFrameDescriptor( pDescriptor );
			pD->SetWidthPercent( 100 );
			ReFill( pDescriptor );
		}

		SfxFrameSetObjectShell *pDoc =
			PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
		EndListening( *pDoc );
		pDoc->TakeDescriptor( pDescriptor );
		StartListening( *pDoc );

		// F"ur das Redo eine Kopie des neuen Descriptors ziehen
		SaveUndo( pUndo, pDescriptor->Clone(), SFX_SLOTPOOL().GetSlotName_Impl( SID_DELETE_FRAME ) );
	}
}

sal_uInt16 SfxFrameSetViewShell::GetCurItemId()
{
	SfxURLFrame *pURL = PTR_CAST(SfxURLFrame, GetActiveFrame() );
	if ( !pURL )
	{
		SfxFrame *pFrame = GetViewFrame()->GetFrame();
		if ( pFrame->GetChildFrameCount() )
		{
			SetActiveFrame( (SfxURLFrame*) pFrame->GetChildFrame(0) );
			pURL = PTR_CAST(SfxURLFrame, GetActiveFrame() );
		}
	}

	return pURL ? pURL->GetFrameId_Impl() : 0;
}

void SfxFrameSetViewShell::ForceInit( sal_Bool bWithFrames )
{
	if ( !pImp->bInit )
	{
		pImp->bInit = sal_True;
		Fill( pDescriptor );

		if ( bWithFrames )
		{
			SfxFrame *pFrame = GetViewFrame()->GetFrame();
			SfxFrameIterator aIter( *pFrame, sal_False );
			SfxFrame *pChild = aIter.FirstFrame();
			while ( pChild )
			{
				((SfxURLFrame*)pChild)->ForceInit_Impl();
				pChild = aIter.NextFrame( *pChild );
			}

			if ( !pImp->nLoadingFrames )
			{
				GetObjectShell()->FinishedLoading();
				pImp->bLoading = sal_False;
			}
		}
	}
}

void SfxFrameSetViewShell::FrameFinishedLoading_Impl( SfxFrame *pFrame )
{
	// Die Benachrichtigun mu\s unterdr"uckt werden, wenn am "ubergebenen Frame selbst noch
	// Child-Ladevorg"ange laufen
	SfxViewFrame *pView = pFrame->GetCurrentViewFrame();
	if (!pView)
		return;

	SfxFrameSetViewShell *pSet = PTR_CAST( SfxFrameSetViewShell, pView->GetViewShell() );
	if ( pImp->bLoading && ( !pSet || pSet->pImp->bInit && !pSet->pImp->nLoadingFrames ) )
	{
		if ( !--pImp->nLoadingFrames )
		{
			pImp->bLoading = sal_False;
			GetObjectShell()->FinishedLoading();

			// Wenn ich selbst in einem Frameset sitze, wurde dort das LoadFinished bisher
			// unterdr"uckt; also jetzt erneut senden
			SfxURLFrame *pURL = PTR_CAST( SfxURLFrame, pFrame->GetParentFrame() );
			if ( pURL )
				pURL->LoadFinished_Impl();
		}
	}
}


