/*************************************************************************
 *
 *  $RCSfile: fsetview.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: pl $ $Date: 2001/10/25 14:56:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SPLITWIN_HXX //autogen
#include <vcl/splitwin.hxx>
#endif
#ifndef _DOCKWIN_HXX //autogen
#include <vcl/dockwin.hxx>
#endif
#ifndef _MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_MEDIT_HXX
#include <svtools/svmedit.hxx>
#endif
#pragma hdrstop

#include <fsetview.hxx>
#include <sfxresid.hxx>
#include <fsetobsh.hxx>
#include <view.hrc>
#include <mnumgr.hxx>
#include "hintpost.hxx"
#include "request.hxx"
#include "urlframe.hxx"
#include "genlink.hxx"
#include "framedlg.hxx"
#include "dispatch.hxx"
#include "docfile.hxx"
#include "objitem.hxx"
#include "objface.hxx"
#include "app.hxx"
#include "topfrm.hxx"

//=========================================================================

DBG_NAME(SfxFrameSetView_Impl);

#define SfxFrameSetView_Impl
#include <sfxslots.hxx>

//=========================================================================

TYPEINIT1(SfxFrameSetView_Impl, SfxFrameSetViewShell);

SFX_IMPL_INTERFACE( SfxFrameSetView_Impl, SfxFrameSetViewShell, SfxResId( STR_FRAMESETVIEWSHELL ) )
{
	SFX_FEATURED_OBJECTBAR_REGISTRATION(
			SFX_OBJECTBAR_OBJECT |
			SFX_VISIBILITY_DESKTOP | SFX_VISIBILITY_STANDARD | SFX_VISIBILITY_READONLYDOC,
			SfxResId(RID_FRAMESETEDIT_TOOLBOX), SFX_FEATURE_FRAMESET_DESIGNMODE );
}

SFX_IMPL_VIEWFACTORY( SfxFrameSetView_Impl, SfxResId( STR_FRAMESETVIEW ) )
{
	SFX_VIEW_REGISTRATION( SfxFrameSetObjectShell );
}

BOOL SfxFrameSetView_Impl::HasUIFeature( ULONG nFeature )
{
	return ( nFeature == SFX_FEATURE_FRAMESET_DESIGNMODE && IsInEditMode() );
}

//------------------------------------------------------------------

SfxFrameSetView_Impl::SfxFrameSetView_Impl( SfxViewFrame *pFrame, const SfxFrameSetView_Impl& rWin )
	: SfxFrameSetViewShell( pFrame, rWin )
	, pSourceView( NULL )
{
	DBG_CTOR(SfxFrameSetView_Impl, 0);
	SetName( DEFINE_CONST_UNICODE( "FrameSetView" ) );
	StartListening( *pFrame );
	SetHelpId( _GetInterfaceIdImpl() );

	if ( GetWindow() )
		GetWindow()->SetHelpId( _GetInterfaceIdImpl() );
}

//------------------------------------------------------------------

SfxFrameSetView_Impl::SfxFrameSetView_Impl( SfxViewFrame *pFrame, SfxViewShell* pShell)
	: SfxFrameSetViewShell( pFrame, pShell )
	, pSourceView( NULL )
{
	DBG_CTOR(SfxFrameSetView_Impl, 0);
	SetName( DEFINE_CONST_UNICODE( "FrameSetView" ) );
	StartListening( *pFrame );
	SetHelpId( _GetInterfaceIdImpl() );

	if ( GetWindow() )
		GetWindow()->SetHelpId( _GetInterfaceIdImpl() );
}

//------------------------------------------------------------------

SfxFrameSetView_Impl::~SfxFrameSetView_Impl()
{
	DBG_DTOR(SfxFrameSetView_Impl, 0);
	if ( pSourceView )
		EndListening( *pSourceView );
	EndListening( *GetViewFrame() );
}

//------------------------------------------------------------------

void SfxFrameSetView_Impl::SFX_NOTIFY( SfxBroadcaster& rBC,
									const TypeId& rBCType,
									const SfxHint& rHint,
									const TypeId& rHintType )
/* [Beschreibung]
 */
{
	if ( rHint.IsA(TYPE(SfxSimpleHint)) )
	{
		if ( &rBC == GetViewFrame()->GetObjectShell() ||
			&rBC == GetViewFrame() )
		{
			SfxFrameSetObjectShell *pDoc =
				((SfxFrameSetObjectShell*)GetViewFrame()->GetObjectShell());
			switch( ( (SfxSimpleHint&) rHint ).GetId() )
			{
				// Wir horchen nur an FrameSetDocuments
				case SFX_HINT_DOCCHANGED:
				{
					// Da sich der Aufbau auch v"ollig ge"andert haben kann,
					// werfen wir alles von uns
					SfxFrameSetDescriptor *pUndo = GetDescriptor()->Clone();
					GetSplitWindow()->SetUpdateMode( FALSE );
					GetViewFrame()->GetFrame()->CloseChildFrames();
					ReFill( pDoc->GetFrameSetDescriptor() );
					GetSplitWindow()->SetUpdateMode( TRUE );
					SaveUndo( pUndo, pDoc->GetFrameSetDescriptor()->Clone(),
							  DEFINE_CONST_UNICODE( "FrameSetView" ), TRUE );
					break;
				}
				case SFX_HINT_TITLECHANGED:
				case SFX_HINT_MODECHANGED:
				{
					if ( IsInEditMode() )
					{
						PrepareWindows( !GetViewFrame()->GetObjectShell()->IsReadOnly() );
						break;
					}
				}
			}
		}
		else if ( &rBC == pSourceView )
		{
			switch( ( (SfxSimpleHint&) rHint ).GetId() )
			{
				// Wir horchen nur an FrameSetDocuments
				case SFX_HINT_DYING:
				{
					pSourceView = NULL;
					break;
				}
			}
		}
	}
}

void SfxFrameSetView_Impl::Execute_Impl(SfxRequest& rReq)
{
	if ( !GetWindow() && !rReq.IsAPI() )
	{
		// Alle Anfragen gehen an das Top-Frameset
		SfxFrameSetViewShell *pShell = this;
		while ( !pShell->GetWindow() )
			pShell = pShell->GetParentFrameSet();
		SfxFrameSetView_Impl *pView = PTR_CAST( SfxFrameSetView_Impl, pShell );
		if ( pView )
			pView->Execute_Impl( rReq );
		return;
	}

	// Aktuellen Frame merken
	SfxViewFrame *pViewFrame = GetViewFrame();
	SfxFrame* pFrame = pViewFrame->GetFrame();
	BOOL bEditMode = IsInEditMode();
	BOOL bReadOnly = pViewFrame->GetObjectShell()->IsReadOnly();
	const USHORT nId = rReq.GetSlot();
/*
	if ( nId == SID_EDIT_FRAMESET )
	{
		SFX_REQUEST_ARG(rReq, pShowItem, SfxBoolItem, nId, FALSE);
		BOOL bShow = pShowItem ? pShowItem->GetValue() : !bEditMode;
		if ( bShow && bReadOnly )
		{
			// EditMode soll angeschaltet werden, Dokument ist aber ReadOnly.
			// Wenn m"oglich, gleich zum Bearbeiten "offnen, aber nur, wenn
			// das ohne Reload m"oglich ist, sonst wird n"amlich diese
			// ViewShell abgeschossen!
			// Wenn das erfolgreich ist, schaltet das schon den Editmode an.
			SfxBoolItem aItem( SID_EDIT_FRAMESET, TRUE );
			SfxBoolItem aReloadItem( SID_EDITDOC, FALSE );
			pViewFrame->GetDispatcher()->Execute( SID_EDITDOC, SFX_CALLMODE_SYNCHRON,
				&aItem, &aReloadItem, 0L );
			bEditMode = IsInEditMode();
			if ( bEditMode == bShow )
				// SID_EDIT_DOC hat auch gleich den EditMode umgeschaltet
				return;
		}
	}
*/
	// Da Framesets asynchron ihre Frames nachladen, mu\s evtl. noch das
	// Nachladen erzwungen werden
	SplitWindow* pWindow = GetSplitWindow();
	const SfxFrameSetDescriptor *pDescriptor = GetDescriptor();

//	if ( pDescriptor->GetFrame(0) && !pFrame->GetChildFrameCount() )
		//	ForceInit();	Bugfix #55871#: GPF wenn beim Laden Task geclosed wird und Basic ist an

	// Nur im EditMode und wenn das Dokument beschreibbar ist, k"onnen
	// "Anderungen vorgenommen werden; ansonsten ist nur Speichern,
	// Modeumschaltung oder SourceView m"oglich. Wird ein Request ohne EditMode
	// angefordert, wird dieser vorher automatisch angeschaltet.
	if ( nId != SID_EDIT_FRAMESET && nId != SID_SAVEDOC && nId != SID_SAVEASDOC
		&& nId != SID_SOURCEVIEW && nId != SID_EDITDOC )
//		&& !rReq.IsAPI() )
	{
		if ( rReq.IsAPI() )
			bReadOnly = FALSE;
		if ( bReadOnly )
			return;
		else
		{
			// EditMode starten, sonst gibt es Probleme mit Undo etc.
			if ( !bEditMode && ( !rReq.IsAPI() /*|| GetWindow() */ ) )
			{
				SfxRequest aReq( SID_EDIT_FRAMESET, SFX_CALLMODE_SYNCHRON, GetPool() );
				ExecuteSlot( aReq );
				bEditMode = IsInEditMode();
				if ( !bEditMode )
					return;
			}

			// History zur"ucksetzen, da sich die Frames-Struktur "andern kann
			pFrame->GetTopFrame()->ClearHistory();
		}
	}

	// Den Frame ermitteln, der bearbeitet werden soll
	// Ohne entsprechenden Parameter den aktuellen Frame nehmen
	USHORT nItemId = GetCurItemId();
	SfxFrame *pModifiedFrame = GetActiveFrame();
	SFX_REQUEST_ARG( rReq, pNameItem, SfxStringItem, SID_FRAMETITLE, FALSE );
	SFX_REQUEST_ARG( rReq, pIdItem, SfxUInt16Item, SID_MODIFY_FRAME, FALSE);

	if ( pIdItem )
	{
		// SFX kann es auch direkt "uber Nummern
		nItemId = pIdItem->GetValue();
		pModifiedFrame = pFrame->SearchFrame_Impl( nItemId );
	}
	else if ( pNameItem )
	{
		// API spricht die Frames mit ihrem Namen an
		String aName( pNameItem->GetValue() );
		SfxFrame* pF = pFrame->SearchChildrenForName_Impl( pNameItem->GetValue() );
		USHORT nNumeric = (USHORT) aName.ToInt32();
		if ( !pF && nNumeric )
			pF = pFrame->SearchFrame_Impl( nNumeric );

		if ( pF && pF->GetParentFrame() != pFrame )
			pF = NULL;

		// Frame gefunden ?
		if ( pF )
		{
			pModifiedFrame = pF;
			nItemId = pF->GetFrameId_Impl();
		}
		else
		{
			DBG_ERROR( "Framename nicht gefunden!" );
			return;
		}
	}

	switch( nId )
	{
		case SID_EDIT_FRAMESET:
		{
			// Parameter auswerten
			SFX_REQUEST_ARG(rReq, pShowItem, SfxBoolItem, nId, FALSE);
			BOOL bShow = pShowItem ? pShowItem->GetValue() : !IsInEditMode();
			if ( bShow )
			{
				if ( !StartEditing() )
					// Editieren abgebrochen
					return;
			}
			else
			{
				BOOL bEnd = EndEditing();
				if ( !bEnd )
					// Weiter editieren
					return;

				// Die Sourceview nur im EditMode
				if ( pSourceView )
					pSourceView->GetViewFrame()->GetFrame()->DoClose();

				/*
				if ( !bEnd )
				{
					// Dokument verwerfen
					pViewFrame->GetDispatcher()->Execute(
						SID_CLOSEWIN, SFX_CALLMODE_ASYNCHRON, (const SfxPoolItem*) 0L );
					rReq.Done();
					return;
				}
				*/
			}

			// Editmode umschalten; ist das Dokument tats"achlich editierbar ?
			bEditMode = !bEditMode;
			if ( bReadOnly )
				bEditMode = FALSE;

			// Wenn editiert werden kann, sind alle Splitter verschiebbar und
			// die Dockingwindows k"onnen D&D
			PrepareWindows( bEditMode );
			rReq.Done();
			UIFeatureChanged();
			break;
		}

		case SID_SPLIT_HORIZONTAL:
		case SID_SPLIT_VERTICAL:
		case SID_SPLIT_PARENT_HORIZONTAL:
		case SID_SPLIT_PARENT_VERTICAL:
		{
            rReq.AppendItem( SfxStringItem( SID_FRAMETITLE, pModifiedFrame->GetFrameName() ) );
			SfxFrame *pRet = Split( nItemId, nId );
			if ( pRet )
				rReq.SetReturnValue( SfxObjectItem( 0, pRet->GetCurrentViewFrame() ) );
			rReq.Done();
			break;
		}

		case SID_FRAMESPACING:
		{
			SFX_REQUEST_ARG( rReq, pItem, SfxUInt16Item, nId, FALSE);
			if ( pItem )
				SetFrameSpacing( (long) pItem->GetValue() );
			else
				SetFrameSpacing( SPACING_NOT_SET );
			rReq.Done();
			break;
		}

		case SID_FRAME_CONTENT:
		{
            rReq.AppendItem( SfxStringItem( SID_FRAMETITLE, pModifiedFrame->GetFrameName() ) );
			SFX_REQUEST_ARG( rReq, pItem, SfxStringItem, nId, FALSE);
			if ( nItemId && pItem )
			{
				SetFrameContent( nItemId, pItem->GetValue() );
				rReq.Done();
			}
			break;
		}

		case SID_FRAME_NAME:
		{
            rReq.AppendItem( SfxStringItem( SID_FRAMETITLE, pModifiedFrame->GetFrameName() ) );
			SFX_REQUEST_ARG( rReq, pItem, SfxStringItem, nId, FALSE);
			if ( nItemId && pItem )
			{
				SetFrameName( nItemId, pItem->GetValue() );
				rReq.Done();
			}
			break;
		}

		case SID_MODIFY_FRAME:
		{
			DBG_ERRORFILE( "obsolete" );
			break;
		}

		case SID_DELETE_FRAME:
		{
            rReq.AppendItem( SfxStringItem( SID_FRAMETITLE, pModifiedFrame->GetFrameName() ) );
			if ( nItemId )
			{
				DeleteFrame( nItemId );
				rReq.Done();
			}
			break;
		}

		case SID_SOURCEVIEW:
		{
			if ( pSourceView )
			{
				pSourceView->GetViewFrame()->GetDispatcher()->Execute(
					SID_CLOSEWIN,
					SFX_CALLMODE_SYNCHRON );
				rReq.Done();
			}
			else
			{
				{
                    SfxFrame* pFrame = SfxTopFrame::Create( GetViewFrame()->GetObjectShell(), 1 );
                    pSourceView = PTR_CAST( SfxFrameSetSourceView_Impl, pFrame->GetCurrentViewFrame()->GetViewShell() );

					// Wir horchen an der Sourceview, um  mitzubekommen, wenn sie dicht
					// gemacht wird
					StartListening( *pSourceView );
				}
			}
			break;
		}

		case SID_NEWWINDOW:
		{
			break;
		}

		case SID_SAVEDOC:
		case SID_SAVEASDOC:
		{
			// Wenn direkt nach dem Start des EditModes "Save" aufgerufen wird,
			// m"u\sen auch durch Browsen hervorgerufene "Anderungen an das
			// Dokument weitergegeben werden
			SfxFrameSetObjectShell *pDoc =
				PTR_CAST( SfxFrameSetObjectShell, GetViewFrame()->GetObjectShell() );
			EndListening( *pDoc );
			pDoc->TakeDescriptor( (SfxFrameSetDescriptor*)pDescriptor );
			StartListening( *pDoc );
			pDoc->ExecuteSlot( rReq );
			rReq.Done();
			break;
		}
	}
}

//------------------------------------------------------------------

void SfxFrameSetView_Impl::State_Impl(SfxItemSet& rSet)
{
	const USHORT *pRanges = rSet.GetRanges();
	DBG_ASSERT(pRanges, "Set ohne Bereich");

    if ( !GetWindow()  )
	{
		// Alle Anfragen gehen an das Top-Frameset
		SfxFrameSetViewShell *pShell = this;
		while ( !pShell->GetWindow() )
			pShell = pShell->GetParentFrameSet();
		SfxFrameSetView_Impl *pView = PTR_CAST( SfxFrameSetView_Impl, pShell );
		if ( pView )
			pView->State_Impl( rSet );
		return;
	}

	USHORT nItemId = GetCurItemId();
	SfxFrameDescriptor* pD = ((SfxFrameSetDescriptor*)GetDescriptor())->SearchFrame( nItemId );

	BOOL bEditMode = IsInEditMode();
	SfxObjectShell *pDoc = GetViewFrame()->GetObjectShell();
	BOOL bReadOnly = pDoc->IsReadOnly();
	if ( pDoc->IsReadOnly() )
		bEditMode = FALSE;

	while ( *pRanges )
	{
		for ( USHORT nWhich = *pRanges++; nWhich <= *pRanges; ++nWhich )
		{
			switch( nWhich )
			{
				case SID_FRAMESPACING:
				{
					if ( !bReadOnly )
					{
						if ( GetDescriptor()->IsFrameSpacingSet() )
						{
							rSet.Put( SfxUInt16Item( nWhich, (USHORT) GetDescriptor()->GetFrameSpacing() ) );
						}
					}
					else
						rSet.DisableItem( nWhich );
					break;
				}

				case  SID_SOURCEVIEW:
				{
					rSet.Put( SfxBoolItem( nWhich, ( pSourceView != NULL ) ) );
					break;
				}

				case SID_EDIT_FRAMESET:
				{
					SFX_ITEMSET_ARG(
						pDoc->GetMedium()->GetItemSet(), pItem, SfxBoolItem,
						SID_EDITDOC, FALSE );
					if ( pItem && !pItem->GetValue() )
						rSet.DisableItem( SID_EDIT_FRAMESET );
					else
						rSet.Put( SfxBoolItem( nWhich, IsInEditMode() ) );
					break;
				}

				case SID_MODIFY_FRAME:
				case SID_DELETE_FRAME:
				case SID_SPLIT_HORIZONTAL:
				case SID_SPLIT_VERTICAL:
				{
					if ( !nItemId || !pD || bReadOnly )
						rSet.DisableItem( nWhich );
					break;
				}

				case SID_SPLIT_PARENT_HORIZONTAL:
				case SID_SPLIT_PARENT_VERTICAL:
				{
					if ( !nItemId || !pD || bReadOnly )
						rSet.DisableItem( nWhich );
					else
					{
						// Parameter aufbereiten
						BOOL bHorizontalSplit = ( nWhich == SID_SPLIT_PARENT_HORIZONTAL );
						if ( !pD->CanSplit( bHorizontalSplit, TRUE ) )
							rSet.DisableItem( nWhich );
					}

					break;
				}

				case SID_SAVEDOC:
				{
					if ( !pDoc->IsModified() )
						rSet.DisableItem( nWhich );
					else
						rSet.Put(SfxStringItem(SID_SAVEDOC,
							String(SfxResId(STR_SAVE_FRAMESET))));
					break;
				}

				case SID_SAVEASDOC:
				{
					rSet.Put(SfxStringItem(SID_SAVEASDOC,
							String(SfxResId(STR_SAVE_FRAMESETAS))));
					break;
				}

				case SID_FRAME_NAME:
				case SID_FRAME_CONTENT:
				{
					if ( !bReadOnly && pD )
					{
						if ( nWhich == SID_FRAME_NAME )
							rSet.Put( SfxStringItem( nWhich, pD->GetName() ) );
						else
							rSet.Put( SfxStringItem( nWhich,
								pD->GetActualURL().GetMainURL() ) );
					}
					else
						rSet.Put( SfxStringItem( nWhich, String() ) );
					break;
				}
			}
		}
	}
}

DBG_NAME(SfxFrameSetSourceView_Impl);

#define SfxFrameSetSourceView_Impl
#include <sfxslots.hxx>

//=========================================================================

TYPEINIT1(SfxFrameSetSourceView_Impl, SfxViewShell);

SFX_IMPL_INTERFACE( SfxFrameSetSourceView_Impl, SfxViewShell, SfxResId( 0 ) )
{
	SFX_OBJECTBAR_REGISTRATION(
			SFX_OBJECTBAR_OBJECT |
			SFX_VISIBILITY_DESKTOP | SFX_VISIBILITY_STANDARD ,
			SfxResId(RID_FRAMESETEDIT_TOOLBOX) );
}

SFX_IMPL_VIEWFACTORY( SfxFrameSetSourceView_Impl, SfxResId( STR_FRAMESETVIEW ) )
{
	SFX_VIEW_REGISTRATION( SfxFrameSetObjectShell );
}

SfxFrameSetSourceView_Impl::SfxFrameSetSourceView_Impl( SfxViewFrame *pFrame,
		const SfxFrameSetSourceView_Impl& rWin )
	: SfxViewShell( pFrame, SFX_VIEW_MAXIMIZE_FIRST )
	, bEditMode( FALSE )
{
	DBG_CTOR( SfxFrameSetSourceView_Impl, 0 );
	SetName( DEFINE_CONST_UNICODE( "FrameSetSourceView" ) );
	MultiLineEdit *pEdit = new MultiLineEdit( &pFrame->GetWindow(), WB_HSCROLL | WB_VSCROLL );
	SetWindow( pEdit );
	pEdit->SetText( ((SfxFrameSetObjectShell*)pFrame->GetObjectShell())->GetSource() );
	StartListening( *pFrame->GetObjectShell() );
	pEdit->SetModifyHdl( LINK ( this, SfxFrameSetSourceView_Impl, ChangeHdl ) );
	pEdit->SetReadOnly( GetObjectShell()->IsReadOnly() );
	StartListening( *pFrame );
	SetHelpId( _GetInterfaceIdImpl() );
	GetWindow()->SetHelpId( _GetInterfaceIdImpl() );
}

SfxFrameSetSourceView_Impl::SfxFrameSetSourceView_Impl( SfxViewFrame *pFrame,
		SfxViewShell* pShell)
	: SfxViewShell( pFrame, SFX_VIEW_MAXIMIZE_FIRST )
	, bEditMode( FALSE )
{
	DBG_CTOR( SfxFrameSetSourceView_Impl, 0 );
	SetName( DEFINE_CONST_UNICODE( "FrameSetSourceView" ) );
	MultiLineEdit *pEdit = new MultiLineEdit( &pFrame->GetWindow(), WB_HSCROLL | WB_VSCROLL );
	SetWindow( pEdit );
	pEdit->SetText( ((SfxFrameSetObjectShell*)pFrame->GetObjectShell())->GetSource() );
	StartListening( *pFrame->GetObjectShell() );
	pEdit->SetModifyHdl( LINK ( this, SfxFrameSetSourceView_Impl, ChangeHdl ) );
	pEdit->SetReadOnly( GetObjectShell()->IsReadOnly() );
	StartListening( *pFrame );
	SetHelpId( _GetInterfaceIdImpl() );
	GetWindow()->SetHelpId( _GetInterfaceIdImpl() );
}

SfxFrameSetSourceView_Impl::~SfxFrameSetSourceView_Impl()
{
	DBG_DTOR( SfxFrameSetSourceView_Impl, 0 );
	Broadcast( SfxSimpleHint(SFX_HINT_DYING) );
	EndListening( *GetViewFrame() );
	delete GetWindow();
	SetWindow( 0 );
}

void SfxFrameSetSourceView_Impl::Execute_Impl(SfxRequest& rReq)
{
	if ( rReq.GetSlot() == SID_MODIFY_FRAME )
	{
		((SfxFrameSetObjectShell*)GetViewFrame()->GetObjectShell())->
			TakeSource( GetWindow()->GetText() );
		bEditMode = FALSE;
	}
	else if ( rReq.GetSlot() == SID_SOURCEVIEW )
	{
        GetViewFrame()->GetDispatcher()->Execute( SID_CLOSEWIN, SFX_CALLMODE_SYNCHRON );
	}
}

void SfxFrameSetSourceView_Impl::State_Impl(SfxItemSet& rSet)
{
	if ( !bEditMode )
		rSet.DisableItem( SID_MODIFY_FRAME );
	rSet.Put( SfxBoolItem( SID_SOURCEVIEW, TRUE ) );
}

void SfxFrameSetSourceView_Impl::SFX_NOTIFY( SfxBroadcaster& rBC,
									const TypeId& rBCType,
									const SfxHint& rHint,
									const TypeId& rHintType )
/* [Beschreibung]
 */
{
	if ( rHint.IsA(TYPE(SfxSimpleHint)) && (
		&rBC == GetViewFrame()->GetObjectShell() ||
		&rBC == GetViewFrame() ) )
	{
		SfxFrameSetObjectShell *pDoc =
			((SfxFrameSetObjectShell*)GetViewFrame()->GetObjectShell());
		switch( ( (SfxSimpleHint&) rHint ).GetId() )
		{
			// Wir horchen nur an FrameSetDocuments
			case SFX_HINT_DOCCHANGED:
			{
				GetWindow()->SetText( pDoc->GetSource() );
				bEditMode = FALSE;
				break;
			}
			case SFX_HINT_TITLECHANGED:
			case SFX_HINT_MODECHANGED:
			{
				((MultiLineEdit*)GetWindow())->SetReadOnly( pDoc->IsReadOnly() );
				break;
			}
		}
	}
}

IMPL_LINK( SfxFrameSetSourceView_Impl, ChangeHdl, Control*, pC )
{
	bEditMode = TRUE;
	GetViewFrame()->GetBindings().Invalidate( SID_MODIFY_FRAME );
	return 0;
}


USHORT SfxFrameSetSourceView_Impl::PrepareClose( BOOL bUI, BOOL bForBrowsing )
{
	if ( SfxViewShell::PrepareClose( bUI, bForBrowsing ) == TRUE )
	{
		if ( bEditMode )
		{
			USHORT nRet = QueryBox( GetWindow(), WB_YES_NO_CANCEL | WB_DEF_YES,
				String( SfxResId( STR_SOURCEMODIFIED ) ) ).Execute();
			switch ( nRet )
			{
				case RET_YES:
					((SfxFrameSetObjectShell*)GetViewFrame()->GetObjectShell())->
						TakeSource( GetWindow()->GetText() );
					return TRUE;
				case RET_NO:
					return TRUE;
				default:
					return FALSE;
			}
		}
		else
			return TRUE;
	}
	else
		return FALSE;
}

void SfxFrameSetView_Impl::PrepareWindows( BOOL bEditMode, USHORT nSet )
{
	// Den Descriptor f"ur das Frameset holen
	const SfxFrameSetDescriptor *pSet = GetDescriptor();
	if ( nSet )
		pSet = ((SfxFrameSetDescriptor*)pSet)->SearchFrame( nSet )->GetFrameSet();

	// Alle Items darin richtig setzen
	SplitWindow *pWindow = GetSplitWindow();
	for ( USHORT nPos=0; nPos<pWindow->GetItemCount( nSet ); nPos++ )
	{
		// Den FrameDescriptor f"ur das Item holen
		USHORT nId = pWindow->GetItemId( nPos, nSet );
		SfxFrameDescriptor *pD = ((SfxFrameSetDescriptor*)pSet)->SearchFrame( nId );

		// Im EditMode SWIB_FIXED ausschalten
		SplitWindowItemBits nBits = pD->GetWinBits();
		if ( bEditMode )
			nBits = nBits & ~SWIB_FIXED;
		pWindow->SetItemBits( nId, nBits );

		// Im EditMode geht D&D "uber die DockingWindows, nicht "uber die
		// darin liegenden Dokumente
		DockingWindow *pDock = (DockingWindow*)pWindow->GetItemWindow( nId );
		if ( pDock )
		{
			pDock->EnableDrop( bEditMode );
			pDock->Invalidate();
		}
		else if ( !pD->GetFrameSet()->IsRootFrameSet() )
		{
			PrepareWindows( bEditMode, nId );
		}
	}
}


