/*************************************************************************
 *
 *  $RCSfile: tbxconf.cxx,v $
 *
 *  $Revision: 1.11.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 11:08:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
#include <vos/mutex.hxx>

#include <tools/stream.hxx>
#include <svtools/miscopt.hxx>
#include <sot/storage.hxx>

#include "tbxconf.hxx"
#include "app.hxx"
#include "toolbox.hrc"
#include "sfxresid.hxx"
#include "dispatch.hxx"
#include "tbxchild.hxx"
#include "tbxmgr.hxx"
#include "appdata.hxx"
#include "tbxopdlg.hrc"

static const USHORT nVersion = 6;

// two functions that take care for the removed RecordingToolbox
static USHORT IndexToPos_Impl( USHORT nIndex )
{
	if ( nIndex < SFX_OBJECTBAR_RECORDING )
		return nIndex;
	else
		return nIndex + 1;
}

static USHORT PosToIndex_Impl( USHORT nPos )
{
	DBG_ASSERT( nPos != SFX_OBJECTBAR_RECORDING, "Wrong Position!" );
	if ( nPos < SFX_OBJECTBAR_RECORDING )
		return nPos;
	else
		return nPos - 1;
}

// create a descriptor array for all positions
void CreateArray_Impl( ::framework::ToolBoxLayoutDescriptor* pPosArr )
{
	for ( USHORT n=0; n<SFX_OBJECTBAR_MAX-1; n++ )
	{
		::framework::ToolBoxLayoutItemDescriptor* pItem = new ::framework::ToolBoxLayoutItemDescriptor;
		pPosArr->Insert( pItem, n );
	}
}

// convert the SfxAlignment to a VCL alignment
extern WindowAlign ConvertAlign_Impl( SfxChildAlignment eAlign );

SfxChildAlignment ConvertToSfxAlign_Impl( ToolBoxAlign eAlign, USHORT nPos )
{
	switch ( eAlign)
	{
		case WINDOWALIGN_LEFT :
			return SFX_ALIGN_TOOLBOXLEFT;
		case WINDOWALIGN_RIGHT :
			return SFX_ALIGN_TOOLBOXRIGHT;
		case WINDOWALIGN_TOP :
			if ( nPos == 0 )
				return SFX_ALIGN_HIGHESTTOP;
			else
				return SFX_ALIGN_TOOLBOXTOP;
		case WINDOWALIGN_BOTTOM :
			return SFX_ALIGN_TOOLBOXBOTTOM;
	}

	DBG_ERROR("Wrong Alignment!");
	return SFX_ALIGN_TOOLBOXTOP;
}

void MakeDefault_Impl( ::framework::ToolBoxLayoutItemDescriptor* pItem, USHORT nPos )
{
	// only fullscreen and commontask will start floating
	pItem->bFloating = FALSE;
	if ( nPos == SFX_OBJECTBAR_FULLSCREEN || nPos == SFX_OBJECTBAR_COMMONTASK )
		pItem->bFloating = TRUE;

	// get the default value for visibility ( only optionbar is not visible by default )
	if ( nPos == SFX_OBJECTBAR_OPTIONS )
		pItem->bVisible = FALSE;
	else
		pItem->bVisible = TRUE;

	// get the default alignment for the docked state
	SfxChildAlignment eAlign;
	switch ( nPos )
	{
		case SFX_OBJECTBAR_APPLICATION :
			eAlign = SFX_ALIGN_HIGHESTTOP;
			break;

		case SFX_OBJECTBAR_OBJECT :
		case SFX_OBJECTBAR_MACRO :
		case SFX_OBJECTBAR_COMMONTASK:
			eAlign = SFX_ALIGN_TOOLBOXTOP;
			break;

		case SFX_OBJECTBAR_TOOLS :
			eAlign = SFX_ALIGN_TOOLBOXLEFT;
			break;

		case SFX_OBJECTBAR_NAVIGATION:
		case SFX_OBJECTBAR_OPTIONS:
			eAlign = SFX_ALIGN_TOOLBOXBOTTOM;
			break;

		default:
			eAlign = SFX_ALIGN_TOOLBOXTOP;
			break;
	}

	pItem->eAlign = ConvertAlign_Impl( eAlign );

	switch ( nPos )
	{
		case SFX_OBJECTBAR_APPLICATION :
			pItem->aName = String::CreateFromAscii("functionbar"); break;
		case SFX_OBJECTBAR_OBJECT :
			pItem->aName = String::CreateFromAscii("objectbar"); break;
		case SFX_OBJECTBAR_TOOLS :
			pItem->aName = String::CreateFromAscii("toolbar"); break;
		case SFX_OBJECTBAR_MACRO :
			pItem->aName = String::CreateFromAscii("macrobar"); break;
		case SFX_OBJECTBAR_FULLSCREEN :
			pItem->aName = String::CreateFromAscii("fullscreenbar"); break;
		case SFX_OBJECTBAR_OPTIONS :
			pItem->aName = String::CreateFromAscii("optionbar"); break;
		case SFX_OBJECTBAR_NAVIGATION:
			pItem->aName = String::CreateFromAscii("navigationbar"); break;
		case SFX_OBJECTBAR_COMMONTASK:
			pItem->aName = String::CreateFromAscii("commontaskbar"); break;
		case SFX_OBJECTBAR_USERDEF1 :
		case SFX_OBJECTBAR_USERDEF2 :
		case SFX_OBJECTBAR_USERDEF3 :
		case SFX_OBJECTBAR_USERDEF4 :
		{
			USHORT nNr = nPos-SFX_OBJECTBAR_USERDEF1+1;
			pItem->aName = String::CreateFromAscii("userdefbar");
			pItem->aName += String::CreateFromInt32(nNr);
			break;
		}
	}

	// quickstarter -> no top window
    if ( nPos == SFX_OBJECTBAR_COMMONTASK )
	{
		// USHRT_MAX means: number of lines equals number of entries
        pItem->eType = BUTTON_TEXT;
		pItem->nFloatingLines = USHRT_MAX;
        if( SFX_APP()->GetTopWindow() )
            pItem->aFloatingPos = SFX_APP()->GetTopWindow()->OutputToScreenPixel( Point( 60, 100 ) );
	}
    else if ( nPos == SFX_OBJECTBAR_FULLSCREEN )
	{
        pItem->eType = BUTTON_TEXT;
    }
    else
        pItem->eType = BUTTON_SYMBOL;
}

//=========================================================================
SfxToolBoxConfig::SfxToolBoxConfig( SfxConfigManager* pCfgMgr ) :
    SfxConfigItem( SFX_ITEMTYPE_TOOLBOXCONFIG, pCfgMgr ),
    eSymbolSet( SFX_SYMBOLS_SMALL ),
	nOutStyle( TOOLBOX_STYLE_FLAT ),
	bQuiet(FALSE),
	bStatusBarVisible(TRUE),
	pPosArr(0)
{
    Initialize();
}

//-------------------------------------------------------------------------
SfxToolBoxConfig::SfxToolBoxConfig( const SfxToolBoxConfig& rOther, SfxConfigManager* pCfgMgr ) :
    SfxConfigItem( SFX_ITEMTYPE_TOOLBOXCONFIG, pCfgMgr ),
    eSymbolSet( SFX_SYMBOLS_SMALL ),
	nOutStyle( TOOLBOX_STYLE_FLAT ),
	bQuiet(FALSE),
	bStatusBarVisible(TRUE),
	pPosArr(0)
{
    Initialize();
}

//-------------------------------------------------------------------------
SfxToolBoxConfig::~SfxToolBoxConfig()
{
	if ( IsModified() )
		StoreConfig();
	delete pPosArr;
}

//-------------------------------------------------------------------------
String SfxToolBoxConfig::GetStreamName() const
{
    return SfxConfigItem::GetStreamName( GetType() );
}

//-------------------------------------------------------------------------
void SfxToolBoxConfig::UseDefault()
{
	DELETEZ( pPosArr );
	pPosArr = new ::framework::ToolBoxLayoutDescriptor();
	CreateArray_Impl( pPosArr );
	for ( USHORT n=0; n<pPosArr->Count(); n++ )
		MakeDefault_Impl( (*pPosArr)[n], IndexToPos_Impl(n) );

	bStatusBarVisible = TRUE;
    SetDefault( TRUE );
}

//-------------------------------------------------------------------------
BOOL SfxToolBoxConfig::IsToolBoxPositionVisible(USHORT nPos) const
{
	if ( nPos == SFX_OBJECTBAR_RECORDING )
		return FALSE;

	USHORT nIndex = PosToIndex_Impl( nPos );
	if ( nIndex != USHRT_MAX )
		return (*pPosArr)[nIndex]->bVisible;
	DBG_ERROR("Wrong position!");
	return FALSE;
}

//-------------------------------------------------------------------------
void SfxToolBoxConfig::SetToolBoxPositionVisible(USHORT nPos, BOOL bVis)
{
	if ( nPos == SFX_OBJECTBAR_RECORDING )
	{
		DBG_ERROR("Wrong position!");
		return;
	}

	USHORT nIndex = PosToIndex_Impl( nPos );
	DBG_ASSERT( nIndex != USHRT_MAX, "Wrong position!");
	if ( nIndex != USHRT_MAX )
		(*pPosArr)[nIndex]->bVisible = bVis;
	SetDefault(FALSE);
	StoreConfig();
}

//-------------------------------------------------------------------------
void SfxToolBoxConfig::SetButtonType( USHORT nPos, ButtonType eType )
{
	if ( nPos == SFX_OBJECTBAR_RECORDING )
	{
		DBG_ERROR("Wrong position!");
		return;
	}

	USHORT nIndex = PosToIndex_Impl( nPos );
	DBG_ASSERT( nIndex != USHRT_MAX, "Wrong position!");
	if ( nIndex != USHRT_MAX )
        (*pPosArr)[nIndex]->eType = eType;
	SetDefault(FALSE);
}

//-------------------------------------------------------------------------
ButtonType SfxToolBoxConfig::GetButtonType( USHORT nPos ) const
{
	if ( nPos == SFX_OBJECTBAR_RECORDING )
        return BUTTON_SYMBOL;

	USHORT nIndex = PosToIndex_Impl( nPos );
	DBG_ASSERT( nIndex != USHRT_MAX, "Wrong position!");
	if ( nIndex != USHRT_MAX )
        return (*pPosArr)[nIndex]->eType;

	if ( nPos == SFX_OBJECTBAR_COMMONTASK )
		return BUTTON_TEXT;
	return BUTTON_SYMBOL;
}

//-------------------------------------------------------------------------
const ::framework::ToolBoxLayoutItemDescriptor* SfxToolBoxConfig::GetCfgItem_Impl( USHORT nPos ) const
{
	if ( nPos == SFX_OBJECTBAR_RECORDING )
	{
		DBG_ERROR("Wrong position!");
		return NULL;;
	}

	USHORT nIndex = PosToIndex_Impl( nPos );
	if ( nIndex != USHRT_MAX )
		return (*pPosArr)[nIndex];
	DBG_ERROR("Wrong position!");
	return NULL;
}

//-------------------------------------------------------------------------
void SfxToolBoxConfig::Configure_Impl( SfxToolBoxManager *pMgr )
{
	SfxToolbox& rBox = (SfxToolbox&) pMgr->GetToolBox();
	USHORT nPos = rBox.GetPosition_Impl();
	if ( nPos == SFX_OBJECTBAR_RECORDING )
	{
		DBG_ERROR("Wrong position!");
		return;
	}

	USHORT nIndex = PosToIndex_Impl( nPos );
	::framework::ToolBoxLayoutItemDescriptor *pItem = (*pPosArr)[nIndex];

#if SUPD>641
    pItem->aFloatingPos = rBox.GetFloatingPosition();
#else
    pItem->aFloatingPos = rBox.GetFloatingPos();
#endif
	if ( pItem->nFloatingLines < rBox.GetItemCount() )
		pItem->nFloatingLines = rBox.GetFloatingLines();
	else
		pItem->nFloatingLines = USHRT_MAX;
	pItem->nLines = rBox.GetLineCount();
	pItem->eAlign = rBox.GetAlign();
	pItem->bFloating = pMgr->GetToolBox().IsFloatingMode();

	SetDefault(FALSE);
	StoreConfig();
}

//-------------------------------------------------------------------------
WinBits SfxToolBoxConfig::GetWinBits( USHORT nPos )
{
    ULONG nStyles = WB_LINESPACING | WB_BORDER | WB_SCROLL | WB_MOVEABLE | WB_3DLOOK | WB_DOCKABLE | WB_SIZEABLE;
    if ( nPos != SFX_OBJECTBAR_FULLSCREEN )
        nStyles |= WB_CLOSEABLE;
	return nStyles;
}

//-------------------------------------------------------------------------
SfxChildAlignment SfxToolBoxConfig::GetAlignment( USHORT nPos ) const
{
	const ::framework::ToolBoxLayoutItemDescriptor *pItem = GetCfgItem_Impl( nPos );
	if ( pItem->bFloating )
		return SFX_ALIGN_NOALIGNMENT;
	return ConvertToSfxAlign_Impl( pItem->eAlign, nPos );
}

//-------------------------------------------------------------------------
String SfxToolBoxConfig::GetToolBoxPositionName(USHORT nPos)
{
	switch ( nPos )
	{
		case SFX_OBJECTBAR_APPLICATION :
			return String(SfxResId(STR_FUNCTIONBAR));
		case SFX_OBJECTBAR_OBJECT :
			return String(SfxResId(STR_OBJECTBAR));
		case SFX_OBJECTBAR_TOOLS :
			return String(SfxResId(STR_TOOLBAR));
		case SFX_OBJECTBAR_MACRO :
			return String(SfxResId(STR_MACROBAR));
		case SFX_OBJECTBAR_OPTIONS :
			return String(SfxResId(STR_OPTIONBAR));
		case SFX_OBJECTBAR_COMMONTASK:
			return String(SfxResId(STR_COMMONTASK));
		case SFX_OBJECTBAR_NAVIGATION:
			return String(SfxResId(STR_NAVIGATION));
		case SFX_OBJECTBAR_USERDEF1 :
		case SFX_OBJECTBAR_USERDEF2 :
		case SFX_OBJECTBAR_USERDEF3 :
		case SFX_OBJECTBAR_USERDEF4 :
		{
			String aStr( SfxResId(STR_TB_USERDEF_NAME) );
			aStr += String::CreateFromInt32( nPos-SFX_OBJECTBAR_USERDEF1+1 );
			return aStr;
		}
	}

	return String();
}

//-------------------------------------------------------------------------
BOOL SfxToolBoxConfig::Import( SvStream& rStream, SvStream& rOut )
{
	USHORT nFileVersion;
	rStream >> nFileVersion;
	if ( nFileVersion < 4 )
		return FALSE;

	USHORT n, nCount, nPos, nVis, nFloatingLines, nLines, nAlign, nFloating;
	::framework::ToolBoxLayoutDescriptor aDescriptor;
	CreateArray_Impl( &aDescriptor );
	for ( n=0; n<aDescriptor.Count(); n++ )
		MakeDefault_Impl( aDescriptor[n], IndexToPos_Impl(n) );

	String aName;
	Point aFloatingPos;
	USHORT nButtonType = (USHORT) BUTTON_SYMBOL;

	rStream >> nCount;
	for (n=0; n<nCount; n++)
	{
		rStream >> nPos
				>> nVis
				>> nFloating;
		rStream.ReadByteString( aName, ::osl_getThreadTextEncoding() );
		rStream	>> nAlign
				>> aFloatingPos
				>> nFloatingLines
				>> nLines;

		if ( nFileVersion > 4 )
			rStream >> nButtonType;

		if ( nPos == SFX_OBJECTBAR_RECORDING )
			continue;

        if ( nPos == SFX_OBJECTBAR_FULLSCREEN )
            nVis = 1;

		::framework::ToolBoxLayoutItemDescriptor* pItem = aDescriptor[PosToIndex_Impl( nPos )];
		pItem->bVisible = (BOOL) nVis;
		pItem->bFloating = (BOOL) nFloating;
		//pItem->aName = aName;
		if ( nAlign != SFX_ALIGN_NOALIGNMENT )
			pItem->eAlign = ConvertAlign_Impl( (SfxChildAlignment) nAlign );
		else
			pItem->eAlign = WINDOWALIGN_TOP;
		pItem->aFloatingPos = aFloatingPos;
		pItem->nFloatingLines = nFloatingLines;
		pItem->nLines = nLines;
	}

	USHORT nSymbolSet;
	rStream >> nSymbolSet;

    // convert old enums to new ones ( without color/mono )
    nSymbolSet = ( 2 ? 0 : 1 );

	if ( nFileVersion < 5 )
		rStream >> nButtonType;

	USHORT nOutStyle;
	rStream >> nOutStyle;

    BOOL bStatusBarVisible = TRUE;
	if ( nFileVersion > 5 )
		rStream >> bStatusBarVisible;

    // add item for staturbar
    ::framework::ToolBoxLayoutItemDescriptor* pItem = new ::framework::ToolBoxLayoutItemDescriptor;
    pItem->aName = String::CreateFromAscii("statusbar");
    pItem->bVisible = bStatusBarVisible;
    pItem->bFloating = FALSE;
    pItem->eAlign = WINDOWALIGN_BOTTOM;
    pItem->nFloatingLines = 0;
    pItem->nLines = 1;
    pItem->eType = BUTTON_TEXT;
    aDescriptor.Insert( pItem, aDescriptor.Count() );
    return ::framework::ToolBoxConfiguration::StoreToolBoxLayout( rOut, aDescriptor );
}

//-------------------------------------------------------------------------
BOOL SfxToolBoxConfig::Export( SvStream* pIn, SvStream& rStream)
{
	::framework::ToolBoxLayoutDescriptor aDescriptor;
    if ( pIn )
    {
        if ( !::framework::ToolBoxConfiguration::LoadToolBoxLayout( *pIn, aDescriptor ) )
            return FALSE;
    }
    else
    {
        CreateArray_Impl( &aDescriptor );
        for ( USHORT n=0; n<aDescriptor.Count(); n++ )
            MakeDefault_Impl( aDescriptor[n], IndexToPos_Impl(n) );
    }

    // default for statusbar
    BOOL bStatusBarVisible = TRUE;

    // check if item for statusbar is present in configuration (6.0 Beta didn't have any)
    USHORT n;
    for ( n=0; n<aDescriptor.Count(); n++ )
    {
        ::framework::ToolBoxLayoutItemDescriptor* pItem = aDescriptor[n];
        if ( pItem->aName.CompareToAscii("statusbar") == COMPARE_EQUAL )
        {
            // found, get value for visibility flag
            bStatusBarVisible = pItem->bVisible;

            // remove item for export
            aDescriptor.DeleteAndDestroy(n);
            break;
        }
    }

	SvtMiscOptions aOpt;
	rStream << nVersion;
    rStream << (USHORT) aDescriptor.Count();
    for ( n=0; n<aDescriptor.Count(); n++ )
	{
		::framework::ToolBoxLayoutItemDescriptor *pItem = aDescriptor[n];
		USHORT nPos = IndexToPos_Impl(n);

		if ( nPos == SFX_OBJECTBAR_COMMONTASK )
			pItem->nFloatingLines = USHRT_MAX;

		rStream << nPos
				<< (USHORT) pItem->bVisible
				<< (USHORT) pItem->bFloating;
		rStream.WriteByteString( GetToolBoxPositionName( nPos ), ::osl_getThreadTextEncoding() );
		rStream	<< (USHORT) ConvertToSfxAlign_Impl( pItem->eAlign, nPos )
				<< pItem->aFloatingPos
				<< pItem->nFloatingLines
				<< pItem->nLines
                << (USHORT) BUTTON_SYMBOL;
	}

    // convert new enums to old ones ( with color/mono )
    rStream << (USHORT) ( aOpt.GetSymbolSet() == 0 ? 2 : 4 ) << (USHORT) aOpt.GetToolboxStyle();
    rStream << bStatusBarVisible;
	return TRUE;
}

int SfxToolBoxConfig::Load( SotStorage& rStorage )
{
	// array will be filled on load
	DELETEZ( pPosArr );
	pPosArr = new ::framework::ToolBoxLayoutDescriptor();
    SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxToolBoxConfig::GetStreamName(), STREAM_STD_READ );
    if ( xStream->GetError() || !::framework::ToolBoxConfiguration::LoadToolBoxLayout( *xStream, *pPosArr ) )
        return SfxConfigItem::ERR_READ;

    // check if item for statusbar is present in configuration (6.0 Beta didn't have any)
    for ( USHORT n=0; n<pPosArr->Count(); n++ )
    {
        ::framework::ToolBoxLayoutItemDescriptor* pItem = (*pPosArr)[n];
        if ( pItem->aName.CompareToAscii("statusbar") == COMPARE_EQUAL )
        {
            // found, get value for visibility flag
            bStatusBarVisible = pItem->bVisible;

            // remove item, because it's not part of the internal structure
            pPosArr->DeleteAndDestroy(n);
            break;
        }
        else if ( pItem->aName.CompareToAscii("fullscreenbar") == COMPARE_EQUAL )
        {
            // fullscreen toolbar should be always visible
            pItem->bVisible = TRUE;
        }
    }

    if( pPosArr->Count() < SFX_OBJECTBAR_MAX-1 )
    {
        DBG_ERROR("Configuration incomplete, using default!");
        return SfxConfigItem::ERR_READ;
    }

    SetDefault( FALSE );
	return SfxConfigItem::ERR_OK;
}

BOOL SfxToolBoxConfig::Store( SotStorage& rStorage )
{
    SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxToolBoxConfig::GetStreamName(), STREAM_STD_READWRITE|STREAM_TRUNC );
    if ( xStream->GetError() )
        return FALSE;

    // temporarily add an item for the statusbar
    ::framework::ToolBoxLayoutItemDescriptor* pItem = new ::framework::ToolBoxLayoutItemDescriptor;
    pItem->aName = String::CreateFromAscii("statusbar");
    pItem->bVisible = bStatusBarVisible;
    pItem->bFloating = FALSE;
    pItem->eAlign = WINDOWALIGN_BOTTOM;
    pItem->nFloatingLines = 0;
    pItem->nLines = 1;
    pItem->eType = BUTTON_TEXT;
    pPosArr->Insert( pItem, pPosArr->Count() );

    BOOL bRet = ::framework::ToolBoxConfiguration::StoreToolBoxLayout( *xStream, *pPosArr );

    // remove statusbar item
    pPosArr->DeleteAndDestroy(pPosArr->Count()-1);
    return bRet;
}
