/*************************************************************************
 *
 *  $RCSfile: goffline.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:52:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <windows.h>
#include <wininet.h>

//
// the following can be indicated in a state change notification:
//

#define INTERNET_STATE_CONNECTED                0x00000001  // connected state (mutually exclusive with disconnected)
#define INTERNET_STATE_DISCONNECTED             0x00000002  // disconnected from network
#define INTERNET_STATE_DISCONNECTED_BY_USER     0x00000010  // disconnected by user request
#define INTERNET_STATE_IDLE                     0x00000100  // no network requests being made (by Wininet)
#define INTERNET_STATE_BUSY                     0x00000200  // network requests being made (by Wininet)

//
// ISO_FORCE_DISCONNECTED - if set when putting Wininet into disconnected mode,
// all outstanding requests will be aborted with a cancelled error
//

#define ISO_FORCE_DISCONNECTED  0x00000001

//
// options manifests for Internet{Query|Set}Option
//

#define INTERNET_OPTION_CALLBACK                1
#define INTERNET_OPTION_CONNECT_TIMEOUT         2
#define INTERNET_OPTION_CONNECT_RETRIES         3
#define INTERNET_OPTION_CONNECT_BACKOFF         4
#define INTERNET_OPTION_SEND_TIMEOUT            5
#define INTERNET_OPTION_CONTROL_SEND_TIMEOUT    INTERNET_OPTION_SEND_TIMEOUT
#define INTERNET_OPTION_RECEIVE_TIMEOUT         6
#define INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT INTERNET_OPTION_RECEIVE_TIMEOUT
#define INTERNET_OPTION_DATA_SEND_TIMEOUT       7
#define INTERNET_OPTION_DATA_RECEIVE_TIMEOUT    8
#define INTERNET_OPTION_HANDLE_TYPE             9
#define INTERNET_OPTION_LISTEN_TIMEOUT          11
#define INTERNET_OPTION_READ_BUFFER_SIZE        12
#define INTERNET_OPTION_WRITE_BUFFER_SIZE       13

#define INTERNET_OPTION_ASYNC_ID                15
#define INTERNET_OPTION_ASYNC_PRIORITY          16

#define INTERNET_OPTION_PARENT_HANDLE           21
#define INTERNET_OPTION_KEEP_CONNECTION         22
#define INTERNET_OPTION_REQUEST_FLAGS           23
#define INTERNET_OPTION_EXTENDED_ERROR          24

#define INTERNET_OPTION_OFFLINE_MODE            26
#define INTERNET_OPTION_CACHE_STREAM_HANDLE     27
#define INTERNET_OPTION_USERNAME                28
#define INTERNET_OPTION_PASSWORD                29
#define INTERNET_OPTION_ASYNC                   30
#define INTERNET_OPTION_SECURITY_FLAGS          31
#define INTERNET_OPTION_SECURITY_CERTIFICATE_STRUCT 32
#define INTERNET_OPTION_DATAFILE_NAME           33
#define INTERNET_OPTION_URL                     34
#define INTERNET_OPTION_SECURITY_CERTIFICATE    35
#define INTERNET_OPTION_SECURITY_KEY_BITNESS    36
#define INTERNET_OPTION_REFRESH                 37
#define INTERNET_OPTION_PROXY                   38
#define INTERNET_OPTION_SETTINGS_CHANGED        39
#define INTERNET_OPTION_VERSION                 40
#define INTERNET_OPTION_USER_AGENT              41
#define INTERNET_OPTION_END_BROWSER_SESSION     42
#define INTERNET_OPTION_PROXY_USERNAME          43
#define INTERNET_OPTION_PROXY_PASSWORD          44
#define INTERNET_OPTION_CONNECT_LIMIT           46
#define INTERNET_OPTION_SECURITY_SELECT_CLIENT_CERT 47
#define INTERNET_OPTION_POLICY                  48
#define INTERNET_OPTION_DISCONNECTED_TIMEOUT    49
#define INTERNET_OPTION_CONNECTED_STATE         50
#define INTERNET_OPTION_IDLE_STATE              51
#define INTERNET_OPTION_OFFLINE_SEMANTICS       52
#define INTERNET_OPTION_SECONDARY_CACHE_KEY     53
#define INTERNET_OPTION_CALLBACK_FILTER         54
#define INTERNET_OPTION_CONNECT_TIME            55
#define INTERNET_OPTION_SEND_THROUGHPUT         56
#define INTERNET_OPTION_RECEIVE_THROUGHPUT      57
#define INTERNET_OPTION_REQUEST_PRIORITY        58
#define INTERNET_OPTION_HTTP_VERSION            59
#define INTERNET_OPTION_RESET_URLCACHE_SESSION  60
#define INTERNET_OPTION_ERROR_MASK              62

#define INTERNET_FIRST_OPTION                   INTERNET_OPTION_CALLBACK


typedef struct {

	//
	// dwConnectedState - new connected/disconnected state.
	// See INTERNET_STATE_CONNECTED, etc.
	//

	DWORD dwConnectedState;

	//
	// dwFlags - flags controlling connected->disconnected (or disconnected->
	// connected) transition. See below
	//

	DWORD dwFlags;
} SFX_INTERNET_CONNECTED_INFO, * LP_SFX_INTERNET_CONNECTED_INFO;


static HINSTANCE hModule=0;
typedef INTERNETAPI int (WINAPI *INTERNETQUERYOPTION) ( HINTERNET, DWORD, LPVOID, LPDWORD );
typedef INTERNETAPI int (WINAPI *INTERNETSETOPTION) ( HINTERNET, DWORD, LPVOID, DWORD );

#ifdef UNICODE
#define IQE "InternetQueryOptionW"
#define ISE "InternetSetOptionW"
#else
#define IQE "InternetQueryOptionA"
#define ISE "InternetSetOptionA"
#endif // !UNICODE

//--------------------------------------------------------------------------------------------------
int get_GlobalOffline(void)
{
	DWORD dwState = 0, dwSize = sizeof(DWORD);
	if ( !hModule )
		hModule = LoadLibrary ("wininet.dll");

	if ( hModule > (HINSTANCE) HINSTANCE_ERROR )
	{
		INTERNETQUERYOPTION pFunc = (INTERNETQUERYOPTION) GetProcAddress (hModule, IQE );
		if ( pFunc && (*pFunc)( NULL, INTERNET_OPTION_CONNECTED_STATE, &dwState, &dwSize ) )
			return( (dwState & INTERNET_STATE_DISCONNECTED_BY_USER) != 0 );
	}

//	if (::InternetQueryOption( NULL, INTERNET_OPTION_CONNECTED_STATE, &dwState, &dwSize ))
//		return( (dwState & INTERNET_STATE_DISCONNECTED_BY_USER) != 0 );

	return TRUE;
}
//--------------------------------------------------------------------------------------------------
int put_GlobalOffline( int bOffline )
{
	if ( !hModule )
		hModule = LoadLibrary ("wininet.dll");

	if ( hModule > (HINSTANCE) HINSTANCE_ERROR )
	{
		INTERNETSETOPTION pFunc = (INTERNETSETOPTION) GetProcAddress (hModule, ISE );
		if ( pFunc )
		{
			SFX_INTERNET_CONNECTED_INFO ci;
			DWORD dwSize = sizeof(ci);
			::memset( &ci, 0, dwSize );

			if (bOffline)
			{
				ci.dwConnectedState = INTERNET_STATE_DISCONNECTED_BY_USER;
				ci.dwFlags			= ISO_FORCE_DISCONNECTED;
			}
			else
			{
				ci.dwConnectedState = INTERNET_STATE_CONNECTED;
			}

			int nRet = (*pFunc)( NULL, INTERNET_OPTION_CONNECTED_STATE, &ci, dwSize );
			return nRet;
		}
	}

	return FALSE;
/*
	return bRet = ::InternetSetOption( NULL, INTERNET_OPTION_CONNECTED_STATE, &ci, sizeof(ci) );
*/
}
