/*************************************************************************
 *
 *  $RCSfile: pluginacceptthread.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: jbu $ $Date: 2001/06/06 15:24:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <pluginacceptthread.hxx>

#ifndef _COM_SUN_STAR_BRIDGE_XBRIDGEFACTORY_HPP_
#include <com/sun/star/bridge/XBridgeFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_BRIDGE_XBRIDGE_HPP_
#include <com/sun/star/bridge/XBridge.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif


using namespace ::vos;
using namespace ::rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::bridge;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::connection;
//using namespace ::com::sun::star::mozilla;


PluginAcceptThread::PluginAcceptThread( 
	const Reference< XMultiServiceFactory >& aLocalServiceManager,
	const Reference< XInstanceProvider >& rInstanceProvider,
	const OUString& aAcceptString ) :
	m_rLocalServiceManager( aLocalServiceManager ),
	m_rInstanceProvider( rInstanceProvider ),
	m_aAcceptString( aAcceptString ),
	m_bStop( sal_False ),
	m_bInAccept( sal_False ),
	m_bPluginConnected( sal_False )
{
	m_rAcceptor = Reference< XAcceptor >( m_rLocalServiceManager->createInstance( 
											OUString( RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.connection.Acceptor" ))),
										  UNO_QUERY );
}

// XEventListener
void SAL_CALL PluginAcceptThread::disposing( const EventObject& Source )
throw( RuntimeException)
{
	m_bPluginConnected = sal_False;
}

void SAL_CALL PluginAcceptThread::terminate()
{
	m_bStop = sal_True;
	
	if ( m_bInAccept )
		m_rAcceptor->stopAccepting();
}

void SAL_CALL PluginAcceptThread::run()
{
	// plugin mode
	acquire();
	
	Reference< XBridgeFactory >	xBridgeFactory( 
									m_rLocalServiceManager->createInstance( 
										OUString(RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.bridge.BridgeFactory" ))), 
									UNO_QUERY );

	try 
	{
		while ( !m_bStop )
		{
			m_bInAccept = sal_True;
			Reference< XConnection > xConnection = m_rAcceptor->accept( m_aAcceptString );
			m_bInAccept = sal_False;

			if ( xConnection.is() )
			{
				if( m_bPluginConnected )
				{
					static sal_Int32 aConnectionsCounter = 0;
					OUString aDummyBridgeName( RTL_CONSTASCII_USTRINGPARAM( "soffice mozilla plugin dummy bridge N" )); 
					aDummyBridgeName +=	OUString::valueOf( aConnectionsCounter++ );

					Reference< XBridge > xBridge = xBridgeFactory->createBridge(
													aDummyBridgeName,
													OUString( RTL_CONSTASCII_USTRINGPARAM( "urp" )),
													xConnection,
													Reference<XInstanceProvider>() );
				}
				else
				{
					m_bPluginConnected = sal_True;
					Reference< XBridge > xBridge = xBridgeFactory->createBridge(
													OUString(RTL_CONSTASCII_USTRINGPARAM("soffice mozilla plugin bridge")),
													OUString( RTL_CONSTASCII_USTRINGPARAM( "urp" )),
													xConnection,
													m_rInstanceProvider );
	

					Reference< XComponent > xComponent( xBridge, UNO_QUERY );
					if ( xComponent.is() )
						xComponent->addEventListener( this );

				}
			}
			else
			{
				break;
			}
		}
	}
	catch( ConnectionSetupException &e )
	{
		OString o = OUStringToOString( e.Message , RTL_TEXTENCODING_ASCII_US );
		OSL_TRACE( "OOfficeAcceptorThread: Exception during accepting interprocess connection\n%s",
				   o.getStr() );
	}
	catch( com::sun::star::lang::IllegalArgumentException &e )
	{
		OString o = OUStringToOString( e.Message , RTL_TEXTENCODING_ASCII_US );
		OSL_TRACE( "OOfficeAcceptorThread: Exception during accepting interprocess connection\n%s",
				   o.getStr() );
	}
	catch ( Exception & e )
	{
		// we are the last on the stack, so catch any exception !
		OString o = OUStringToOString( e.Message , RTL_TEXTENCODING_ASCII_US );
		OSL_TRACE( "OOfficeAcceptorThread: Exception during accepting interprocess connection\n%s",
				   o.getStr() );
	}
}

void SAL_CALL PluginAcceptThread::onTerminated()
{
	release();
}
