/*************************************************************************
 *
 *  $RCSfile: picklist.cxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: mba $ $Date: 2001/11/28 17:00:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <osl/mutex.hxx>
#ifndef _SYSTEM_HXX //autogen
#include <vcl/system.hxx>
#endif
#ifndef _MENU_HXX //autogen
#include <vcl/menu.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif

#include <svtools/inethist.hxx>
#include <svtools/historyoptions.hxx>
#include <svtools/useroptions.hxx>

#ifndef __FRAMEWORK_CLASSES_MENUCONFIGURATION_HXX_
#include <framework/menuconfiguration.hxx>
#endif

#ifndef _COM_SUN_STAR_LOADER_XIMPLEMENTATIONLOADER_HPP_
#include <com/sun/star/loader/XImplementationLoader.hpp>
#endif
#ifndef _COM_SUN_STAR_LOADER_CANNOTACTIVATEFACTORYEXCEPTION_HPP_
#include <com/sun/star/loader/CannotActivateFactoryException.hpp>
#endif

#pragma hdrstop

#include "fcontnr.hxx"
#include "picklist.hxx"
#include "app.hxx"
#include "bindings.hxx"
#include "objsh.hxx"
#include "docfile.hxx"
#include "docfilt.hxx"
#include "objshimp.hxx"
#include "event.hxx"
#include "request.hxx"
#include "sfxtypes.hxx"
#include "docinf.hxx"
#include "sfxuno.hxx"
#include "sfxsids.hrc"
#include "sfx.hrc"
#include "viewfrm.hxx"
#include "request.hxx"

// class FileBase
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif
using namespace ::osl;
using namespace ::vos;

SfxPickList_Impl* SfxPickList_Impl::pInstance = NULL;

SfxPickList_Impl* SfxPickList_Impl::Get()
{
	::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
	return pInstance;
}

SfxPickList_Impl* SfxPickList_Impl::GetOrCreate( const sal_uInt32 nMenuSize )
{
	::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
	if ( !pInstance )
		pInstance = new SfxPickList_Impl( nMenuSize );
	return pInstance;
}

void SfxPickList_Impl::Delete()
{
	::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
	DELETEZ( pInstance );
}

//=========================================================================

// Hilfsfunktionen fuer Picklist-Eintraege

// ersetzt \\ durch \, \{ durch {, \} durch } sowie schliesst den ganzen String in
// ein {}-Paar ein
String Quote(const String& rSource)
{
	if (!rSource.Len())
		return DEFINE_CONST_UNICODE("{}");

	String sTemp(rSource);
	sTemp.SearchAndReplaceAll(DEFINE_CONST_UNICODE("\\"), DEFINE_CONST_UNICODE("\\\\"));
	sTemp.SearchAndReplaceAll(DEFINE_CONST_UNICODE("{"), DEFINE_CONST_UNICODE("\\{"));
	sTemp.SearchAndReplaceAll(DEFINE_CONST_UNICODE("}"), DEFINE_CONST_UNICODE("\\}"));
		// in dieser Reihenfolge !

	String sReturn(0x007B); // '{' = 7Bh

	sReturn += sTemp;
	sReturn += 0x007D; // '}' = 7Dh
	return sReturn;
}

// Umkehrung von Quote
String UnQuote(const String& rSource)
{
	if (!rSource.Len())
		return String();

	String sReturn(rSource);
	sReturn.SearchAndReplaceAll(DEFINE_CONST_UNICODE("\\{"), DEFINE_CONST_UNICODE("{"));
	sReturn.SearchAndReplaceAll(DEFINE_CONST_UNICODE("\\}"), DEFINE_CONST_UNICODE("}"));
	sReturn.SearchAndReplaceAll(DEFINE_CONST_UNICODE("\\\\"), DEFINE_CONST_UNICODE("\\"));

	if ((sReturn.GetChar(0) == 0x007B) && (sReturn.GetChar(sReturn.Len() - 1) == 0x007D)) // '{' = 7Bh und '}' = 7Dh
		// ist eigentlich nicht korrekt : normalerweise muessten wir testen, ob die oeffnende Klammer am Anfang und
		// die schliessende Klammer am Ende zum selben Paar gehoeren, aber fuer den Kontext, in dem es hier verwendet
		// wird, reicht es
		return sReturn.Copy(1, sReturn.Len() - 2);

	return sReturn;
}

// Hilfsfunktion, die aus einem String Tokens extrahiert, wobei in {}-Paare geklammerte Teilstrings
// uebersprungen werden, also den Token.Trenner enthalten duerfen. Verschachtelte Klammerungen sind
// erlaubt.
// \{ wird dabei als Einheit betrachtet, bei der die Klammer nicht zaehlt, analog \}.
// Um dabei Eindeutigkeit zu gewaehrleisten, zaehlt auch \\ als Einheit, \\{ also wiederum als Begin
// einer Klammerung.
// Wenn bPure == sal_True, wird das gefundene Token ohne Veraenderung geliefert
// Wenn bPure == sal_False und das Token insegesamt in ein {}-Paar eingeschlossen ist (so wie es bei Quote
// entsteht), wird es vor der Rueckgabe noch durch Unquote gejagt.
// Wenn bPure == sal_False und das Token nicht geklammert ist, wird es ebenfalls ohne Veraenderung geliefert.
String GetBrackToken(const String& rSource, sal_uInt16 nToken, char cTok = ';', sal_uInt16 nStart = 0, sal_Bool bPure = sal_False)
{
	static const String aEmptyStr;
	// leerer String oder nStart zu gross ?
	if (nStart >= rSource.Len())
		return aEmptyStr;

	ByteString sTemp(U2S(rSource));
	const char* pStart = sTemp.GetBuffer() + nStart;
	const char* pSearch = pStart;
	sal_uInt16 nBracketLevel = 0;
	sal_uInt16 nCurrentToken = 0;
	sal_uInt16 nCurrentTokenStart = nStart;
	const char* pFirstLevelZeroChar = NULL;

	while (*pSearch)
	{
		switch (*pSearch)
		{
			case '\\':
				switch (*(pSearch + 1))
				{
					case '{':
					case '}':
					case '\\':
						++pSearch;
						break;
					default:
						// andere Faelle sollten zwar nicht auftreten, wenn das Token irgendwann mal durch
						// Quote entstanden ist, aber wenn doch, behandeln wir den Backslash eben wie ein
						// normales Zeichen (ueberlesen ihn also)
						if (!pFirstLevelZeroChar)
							pFirstLevelZeroChar = pSearch;
				}
				break;
			case '{' :
				++nBracketLevel;
				break;

			case '}' :
				if (!nBracketLevel)
					// SO KANN ICH NICHT ARBEITEN !!!!
					// (soll heissen, wenn die Klammern nicht paarig auftreten, knn' wir nix machen ;)
					return aEmptyStr;
				--nBracketLevel;
				break;

			default:
				if (!nBracketLevel)
				{
					if (!pFirstLevelZeroChar)
						pFirstLevelZeroChar = pSearch;
					if (*pSearch == cTok)
					{
						if (nCurrentToken == nToken)
						{
							// wir haben das gewuenschte Token
							String sReturn ( S2U( sTemp.Copy(nCurrentTokenStart, pSearch - pStart - nCurrentTokenStart) ) );
							// eventuell Quotierung entfernen
							if (bPure)
								return sReturn;

							if (pFirstLevelZeroChar == pSearch)
								// der Token-Trenner war das erste nicht-geklammerte Zeichen, also ist das
								// gesamte Token geklammert, also Unquote
								return UnQuote(sReturn);
							return sReturn;
						}

						// nicht das gewuenschte Token -> weiter (was sonst)
						nCurrentTokenStart = pSearch - pStart + 1;
						nBracketLevel = 0;
						pFirstLevelZeroChar = NULL;
						++nCurrentToken;
					}
				}
				// alles andere - auf einer Klammerebene > 0 - wird ueberlesen
		}

		++pSearch;
	}
	if ((nBracketLevel == 0) && (nCurrentToken == nToken))
	{	// hinter dem letzten Token fehlte einfach ein Trenner
		String sReturn ( S2U( sTemp.Copy(nCurrentTokenStart, pSearch - pStart - nCurrentTokenStart)));
		// eventuell Quotierung entfernen (analog oben)
		if (bPure)
			return sReturn;
		if (!pFirstLevelZeroChar)
			return UnQuote(sReturn);
		return sReturn;
	}

	return aEmptyStr;
}

//=========================================================================

void MemCache_Impl::ClearObjects()
{
	ClearToLimit( 0 );
}

//-------------------------------------------------------------------------

MemCache_Impl::~MemCache_Impl()
{
	ClearObjects();
}

//-------------------------------------------------------------------------

sal_Bool MemCache_Impl::IsObjectCached( const SfxObjectShell *pObjSh ) const
{
	sal_uInt16 nCount = (sal_uInt16)Count();
	for ( sal_uInt16 n = 0; n<nCount; n++ )
	{
		SfxObjectShell *pFoundObjSh = *GetObject(n);
		if ( pFoundObjSh == pObjSh )
			return sal_True;
	}

	return sal_False;
}

//-------------------------------------------------------------------------

SfxObjectShell* MemCache_Impl::Find(
	const INetURLObject &rUrlToFind, const String& rPostString ) const
{
	sal_uInt16 nCount =(sal_uInt16) Count();
	for ( sal_uInt16 n = 0; n<nCount; n++ )
	{
		SfxObjectShell *pDoc = *GetObject(n);
        INetURLObject aUrl( pDoc->GetMedium()->GetName() );
		if ( !aUrl.HasError() && (
			aUrl == rUrlToFind || rUrlToFind ==
			pDoc->GetMedium()->GetPreRedirectedURL() ) )
		{
            return pDoc;
		}
	}

	return 0;
}

//-------------------------------------------------------------------------

void MemCache_Impl::ClearToLimit( sal_uInt16 nCount )
{
	for( sal_uInt16 nPos = (sal_uInt16)Count(); nPos-- > nCount;  )
		delete Remove( (sal_uInt32) nPos );
}

sal_Bool MemCache_Impl::RemoveObject( const SfxObjectShell *pObjSh )
{
	sal_uInt16 nCount = (sal_uInt16)Count();
	for ( sal_uInt16 n = 0; n<nCount; n++ )
	{
		if ( *GetObject( n ) == pObjSh )
		{
			delete Remove( n );
			return sal_True;
		}
	}

	return sal_False;
}

//-------------------------------------------------------------------------

void MemCache_Impl::AddObject( SfxObjectShell *pObj )

/*	[Beschreibung]

	Nimmt das Dokument 'pObj' in den Memory-Cache auf, falls es ein
	Remote-Dokument ist, sonst nicht. Der Memory-Cache h"alt eine Referenz
	auf das Dokument, so da\s es nicht gel"oscht werden kann.
*/

{
}

//-------------------------------------------------------------------------

String PickString_Impl
(
	sal_uInt16 nNo						/* ::com::sun::star::sdbcx::Index des nachfolgenden Pick-Entries
									   in der Pick-Liste, beginnend mit 0 */,

	SfxPickEntry_Impl* pPick		/* Pick-Entry, der in einen String
									   umgewandelt werden soll */
)

/*	[Beschreibung]

	Hilfsroutine, mit der vor den Dateinamen eines Pick-Entries eine
	Ziffer als Short-Erase f"ur das Men"u gesetzt wird.
*/

{
#ifdef MAC
	String aPickEntry;
#else
	String aPickEntry( '~' );
	aPickEntry += String::CreateFromInt32( nNo + 1 );
	aPickEntry += DEFINE_CONST_UNICODE(": ");
#endif

	aPickEntry += pPick->aTitle;
	if ( aPickEntry.Len() > 50 )
	{
		aPickEntry.Erase( 48 );
		aPickEntry += DEFINE_CONST_UNICODE("...");
	}
	return aPickEntry;
}

//-------------------------------------------------------------------------

SfxPickEntry_Impl::SfxPickEntry_Impl( const SfxMedium *pMed, const String &rTitle )
:	aName( pMed->GetOrigURL() ),
	aTitle( rTitle )
{
	const SfxFilter* pFilter = pMed->GetOrigFilter();
	if ( pFilter )
	{
		// Filter eintragen
        aFilter = pFilter->GetFilterName();

		// Filter-Optionen eintragen
		SfxItemSet *pSet= pMed->GetItemSet();
		const SfxPoolItem *pItem = 0;
		const SfxStringItem *pStringItem = 0;
		if ( pSet &&
				SFX_ITEM_SET == pSet->GetItemState(SID_FILE_FILTEROPTIONS, sal_False, &pItem ) )
			pStringItem = PTR_CAST( SfxStringItem, pItem );
		if( pStringItem )
		{
			aFilter += '|';
			aFilter += pStringItem->GetValue();
		}
	}
}

//-------------------------------------------------------------------------

SfxPickEntry_Impl::SfxPickEntry_Impl
(
	const String &rName,
	const String &rFilter,
	const String &rTitle
)
:	aName( rName ),
	aFilter( rFilter ),
	aTitle( rTitle )
{
}

//-------------------------------------------------------------------------

SfxPickList_Impl::SfxPickList_Impl( const sal_uInt32 nMenuSize )
:	aHistoryPickList( HISTORY_MAXSIZE , 0 ) ,
	bHistoryInitialized( sal_False )
{
	// auf Broadcasts der App h"oren
//	StartListening( *SFX_APP() );
}

//***************************************************************************

SfxPickList_Impl::~SfxPickList_Impl()
{
	// Zerstoerung der Historypickliste
	int nEntryCount = aHistoryPickList.Count();
	for( int nEntry = 0 ; nEntry < nEntryCount ; nEntry++ )
		delete aHistoryPickList.GetObject( nEntry );
}

//***************************************************************************

void SfxPickList_Impl::LoadHistory()
/*
	[Beschreibung]
	Die Methode laedt die Historydaten aus dem Inifile.
*/
{
	DBG_ASSERT( !bHistoryInitialized, "LoadHistory ist ueberfluessig" );

	bHistoryInitialized = sal_True;

	// Einlesung der Historypickliste
	::com::sun::star::uno::Sequence< ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > > seqPicklist = SvtHistoryOptions().GetList( eHISTORY );
	sal_uInt32 nCount = seqPicklist.getLength();
	for( sal_uInt32 nItem=0; nItem<nCount; ++nItem )
	{
		::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue > seqPropertySet = seqPicklist[nItem];

		INetURLObject	aURL		;
		::rtl::OUString sURL		;
		::rtl::OUString sFilter		;
		::rtl::OUString sTitle		;
		::rtl::OUString sPassword	;
		sal_uInt32 nPropertyCount = seqPropertySet.getLength();
		for( sal_uInt32 nProperty=0; nProperty<nPropertyCount; ++nProperty )
		{
			if( seqPropertySet[nProperty].Name == HISTORY_PROPERTYNAME_URL )
			{
				seqPropertySet[nProperty].Value >>= sURL;
			}
			else
			if( seqPropertySet[nProperty].Name == HISTORY_PROPERTYNAME_FILTER )
			{
				seqPropertySet[nProperty].Value >>= sFilter;
			}
			else
			if( seqPropertySet[nProperty].Name == HISTORY_PROPERTYNAME_TITLE )
			{
				seqPropertySet[nProperty].Value >>= sTitle;
			}
			else
			if( seqPropertySet[nProperty].Name == HISTORY_PROPERTYNAME_PASSWORD )
			{
				seqPropertySet[nProperty].Value >>= sPassword;
			}
		}

		aURL.SetSmartURL( sURL );
		aURL.SetPass( SfxStringDecode( sPassword ) );
		SfxPickEntry_Impl *pPick = new SfxPickEntry_Impl( aURL.GetMainURL(), sFilter, sTitle );
		aHistoryPickList.Insert( pPick, LIST_APPEND );
	}

	// Anfangs zum zuletzt geladenen springen
	aHistoryPickList.Seek( (sal_uInt32) 0L );
}

void SfxPickList_Impl::SavePicklist()
/*
	[Beschreibung]
	Abspeicherung der Daten im Inifile
*/
{
	SvtHistoryOptions aHistoryCFG;
	if( bHistoryInitialized )
	{
		aHistoryCFG.Clear( eHISTORY );
		sal_uInt16 nCount = (sal_uInt16)aHistoryPickList.Count();
		sal_Bool bBreak = sal_False;
		for ( sal_uInt16 nNo = 0; !bBreak && nNo < nCount; nNo++ )
		{
			SfxPickEntry_Impl *pEntry = aHistoryPickList.GetObject( nNo );
			INetURLObject aURL( pEntry->aName );
			if ( pEntry->aName.Len() )
			{
				aHistoryCFG.AppendItem( eHISTORY						,
										aURL.GetURLNoPass()				,
										pEntry->aFilter					,
										pEntry->aTitle					,
										SfxStringEncode( aURL.GetPass() ));
			}
			else
			{
				aHistoryCFG.AppendItem(	eHISTORY								,
										aURL.GetURLNoPass()						,
										::rtl::OUString()						,
										::rtl::OUString()						,
										::rtl::OUString()						);
				bBreak = sal_True;
			}
		}
	}
}

//***************************************************************************

SfxPickEntry_Impl* SfxPickList_Impl::GetHistoryPickEntry( const sal_uInt32 nPos )
/*
	[Beschreibung]
	Die Methode gibt den gegebenen Eintrag aus der History zurueck.
*/
{
	DBG_ASSERT( nPos < aHistoryPickList.Count() ,
			"Invalide Pickentrypos" );

	// Load on demand der Historypickliste
	if ( !bHistoryInitialized )
		LoadHistory();

	return aHistoryPickList.GetObject( nPos );
}


//***************************************************************************

SfxPickEntry_Impl* SfxPickList_Impl::GetHistoryPickEntry( const String& rURL )
/*
	[Beschreibung]
	Die Methode gibt den gegebenen Eintrag aus der History zurueck.
*/
{
	for( sal_uInt16 nPos = (sal_uInt16)aHistoryPickList.Count(); nPos--; )
	{
		INetURLObject aURL( aHistoryPickList.GetObject( nPos )->aName );
		if ( aURL.GetURLNoPass()  == rURL )
			return aHistoryPickList.GetObject( nPos );
	}
	return 0;
}

//***************************************************************************

SfxPickEntry_Impl* SfxPickList_Impl::GetHistoryPickEntryFromTitle(
														const String& rTitle )
/*
	[Beschreibung]
	Die Methode gibt den gegebenen Eintrag aus der History zurueck.
*/
{
	for( sal_uInt16 nPos = (sal_uInt16)aHistoryPickList.Count(); nPos--; )
	{
		SfxPickEntry_Impl* pEntry = aHistoryPickList.GetObject( nPos );
		if ( pEntry->aTitle == rTitle )
			return pEntry;
	}
	return NULL;
}

//***************************************************************************

sal_uInt32 SfxPickList_Impl::HistoryPickEntryCount()
/*
	[Beschreibung]
	Die Methode gibt die Anzahl der Historyeintraege zurueck.
*/
{
	// Load on demand der Historypickliste
	if ( !bHistoryInitialized )
		LoadHistory();

	return aHistoryPickList.Count();
}

//***************************************************************************

sal_uInt32 SfxPickList_Impl::GetCurHistoryPos()
/*
	[Beschreibung]
	Die Methode gibt die aktuelle Position in der History zurueck.
*/
{
	// Load on demand der History
	if( !bHistoryInitialized )
		LoadHistory();

	return aHistoryPickList.GetCurPos();
}

//***************************************************************************

SfxPickEntry_Impl* SfxPickList_Impl::SetCurHistoryPos( const sal_uInt32 nPos )
/*
	[Beschreibung]
	Die Methode "springt" zum gegebenen Eintrag und gibt selbigen zurueck.
*/
{
	DBG_ASSERT( nPos < aHistoryPickList.Count() ,
				"Invalide Pickentrypos" );

	// Load on demand der History
	if( !bHistoryInitialized )
		LoadHistory();

	return aHistoryPickList.Seek( nPos );
}

//***************************************************************************

void SfxPickList_Impl::InsertToHistory( SfxObjectShell* pDocSh )
{
	// soll der ueberhaupt rein?
	SfxMedium *pMed = pDocSh->GetMedium();
	if ( !pMed )
		return;

	// ggf. on-demand laden
	if ( !bHistoryInitialized )
		((SfxPickList_Impl*)this)->LoadHistory();

	// Load der Historydaten aus dem Inifile, falls noch nicht
	// geschehen
	if( !bHistoryInitialized )
		LoadHistory();

	String aName = pMed->GetOrigURL();
	if ( !aName.Len() )
		return;

	INetURLObject aURL( aName );
	if ( aURL.GetProtocol() == INET_PROT_VND_SUN_STAR_HELP )
		// no help in history
		return;

	// already inserted?
	String aStr = aURL.GetURLNoPass();
	SfxPickEntry_Impl* pEntry = GetHistoryPickEntry( aStr );
	if ( pEntry )
		aHistoryPickList.Remove( aHistoryPickList.GetPos( pEntry ) );
	else
        pEntry = new SfxPickEntry_Impl( pMed, aStr );

	// Anzahl beschr"anken
	if ( aHistoryPickList.Count() == HISTORY_MAXSIZE )
		delete aHistoryPickList.Remove( aHistoryPickList.Count() - 1 );

	// den neuen einf"ugen
	aHistoryPickList.Insert( pEntry, PICKLIST_INSERT_POSITION );
	aHistoryPickList.Seek( PICKLIST_INSERT_POSITION );
}

//-------------------------------------------------------------------------

void SfxPickList_Impl::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*
	[Beschreibung]
	BroadCaster(muss):
	class SfxApplication
	class SfxObjectShell
*/
{
	if( rHint.IsA( TYPE( SfxStringHint ) ) )
	{
		SfxStringHint* pStringHint = (SfxStringHint*) &rHint;
		if( pStringHint->GetId() == SID_OPENURL )
			INetURLHistory::GetOrCreate()->PutUrl( INetURLObject( pStringHint->GetObject() ) );
	}

	if( rHint.IsA( TYPE( SfxEventHint ) ) )
	{
		SfxEventHint* pEventHint = PTR_CAST(SfxEventHint,&rHint);
		// nur ObjectShell-bezogene Events mit Medium interessieren
		SfxObjectShell* pDocSh = pEventHint->GetObjShell();
		if( !pDocSh )
			return;

		switch ( pEventHint->GetEventId() )
		{
			case SFX_EVENT_CREATEDOC:
			{
                pDocSh->GetDocInfo().SetCreated( SvtUserOptions().GetFullName() );
				break;
			}
			case SFX_EVENT_CLOSEDOC:
			{
				SfxMedium *pMed = pDocSh->GetMedium();
				if( !pMed )
					return;

				// unbenannt-Docs und embedded-Docs nicht in Pickliste
				if ( !pDocSh->HasName() ||
					 SFX_CREATE_MODE_STANDARD != pDocSh->GetCreateMode() )
					return;
				if(
					!pDocSh->IsModified()				&&
					pDocSh->IsReadOnly()				&&
				 	!pDocSh->IsAbortingImport()			&&
					!pDocSh->Get_Impl()->bForbidCaching	&&
				 	!pMed->IsExpired()
				)
				{
					aMemoryCache.AddObject( pDocSh );
				}

				if( pDocSh->Get_Impl()->bWaitingForPicklist &&
					!pDocSh->Get_Impl()->bIsHelpObjSh )
				{
//					InsertToMenu( pDocSh );
					pDocSh->Get_Impl()->bWaitingForPicklist = sal_False;
				}
				break;
			}
		}
	}
}
