/*************************************************************************
 *
 *  $RCSfile: namecont.cxx,v $
 *
 *  $Revision: 1.29.2.2 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 11:08:45 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
#include <com/sun/star/container/XContainer.hpp>
#endif

#ifndef __RSC //autogen
#include <tools/errinf.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include <cppuhelper/typeprovider.hxx>
#include "namecont.hxx"

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif
#include <svtools/pathoptions.hxx>
#include <svtools/sfxecode.hxx>
#include <svtools/ehdl.hxx>
#include <basic/basmgr.hxx>


#ifndef _COM_SUN_STAR_XML_SAX_XEXTENDEDDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_INPUTSOURCE_HPP_
#include <com/sun/star/xml/sax/InputSource.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif


using namespace com::sun::star::container;
using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::io;
using namespace com::sun::star::ucb;
using namespace com::sun::star::script;
using namespace com::sun::star::xml::sax;
using namespace cppu;
using namespace rtl;
using namespace osl;


//============================================================================
// Implementation class NameContainer_Impl

namespace SfxContainer_Impl
{

// Methods XElementAccess
Type NameContainer_Impl::getElementType()
	throw(RuntimeException)
{
	return mType;
}

sal_Bool NameContainer_Impl::hasElements()
	throw(RuntimeException)
{
	sal_Bool bRet = (mnElementCount > 0);
	return bRet;
}

// Methods XNameAccess
Any NameContainer_Impl::getByName( const OUString& aName )
	throw(NoSuchElementException, WrappedTargetException, RuntimeException)
{
	NameContainerNameMap::iterator aIt = mHashMap.find( aName );
	if( aIt == mHashMap.end() )
	{
		throw NoSuchElementException();
	}
	sal_Int32 iHashResult = (*aIt).second;
	Any aRetAny = mValues.getConstArray()[ iHashResult ];
	return aRetAny;
}

Sequence< OUString > NameContainer_Impl::getElementNames()
	throw(RuntimeException)
{
	return mNames;
}

sal_Bool NameContainer_Impl::hasByName( const OUString& aName )
	throw(RuntimeException)
{
	NameContainerNameMap::iterator aIt = mHashMap.find( aName );
	sal_Bool bRet = ( aIt != mHashMap.end() );
	return bRet;
}


// Methods XNameReplace
void NameContainer_Impl::replaceByName( const OUString& aName, const Any& aElement )
	throw(IllegalArgumentException, NoSuchElementException, WrappedTargetException, RuntimeException)
{
	Type aAnyType = aElement.getValueType();
	if( mType != aAnyType )
		throw IllegalArgumentException();

	NameContainerNameMap::iterator aIt = mHashMap.find( aName );
	if( aIt == mHashMap.end() )
	{
		throw NoSuchElementException();
	}
	sal_Int32 iHashResult = (*aIt).second;
	Any aOldElement = mValues.getConstArray()[ iHashResult ];
	mValues.getArray()[ iHashResult ] = aElement;


	// Fire event
	ContainerEvent aEvent;		
	aEvent.Source = mpxEventSource;
	aEvent.Accessor <<= aName;
	aEvent.Element = aElement;
	aEvent.ReplacedElement = aOldElement;

	OInterfaceIteratorHelper aIterator( maListenerContainer );
	while( aIterator.hasMoreElements() )
	{
		Reference< XInterface > xIface = aIterator.next();
		Reference< XContainerListener > xListener( xIface, UNO_QUERY );
		xListener->elementReplaced( aEvent );
	}
}


// Methods XNameContainer
void NameContainer_Impl::insertByName( const OUString& aName, const Any& aElement )
	throw(IllegalArgumentException, ElementExistException, WrappedTargetException, RuntimeException)
{
	Type aAnyType = aElement.getValueType();
	if( mType != aAnyType )
		throw IllegalArgumentException();

	NameContainerNameMap::iterator aIt = mHashMap.find( aName );
	if( aIt != mHashMap.end() )
	{
		throw ElementExistException();
	}

	sal_Int32 nCount = mNames.getLength();
	mNames.realloc( nCount + 1 );
	mValues.realloc( nCount + 1 );
	mNames.getArray()[ nCount ] = aName;
	mValues.getArray()[ nCount ] = aElement;

	mHashMap[ aName ] = nCount;
	mnElementCount++;


	// Fire event
	ContainerEvent aEvent;		
	aEvent.Source = mpxEventSource;
	aEvent.Accessor <<= aName;
	aEvent.Element = aElement;

	OInterfaceIteratorHelper aIterator( maListenerContainer );
	while( aIterator.hasMoreElements() )
	{
		Reference< XInterface > xIface = aIterator.next();
		Reference< XContainerListener > xListener( xIface, UNO_QUERY );
		xListener->elementInserted( aEvent );
	}

}

void NameContainer_Impl::removeByName( const OUString& Name )
	throw(NoSuchElementException, WrappedTargetException, RuntimeException)
{
	NameContainerNameMap::iterator aIt = mHashMap.find( Name );
	if( aIt == mHashMap.end() )
	{
		throw NoSuchElementException();
	}

	sal_Int32 iHashResult = (*aIt).second;
	Any aOldElement = mValues.getConstArray()[ iHashResult ];
	mHashMap.erase( aIt );
	sal_Int32 iLast = mNames.getLength() - 1;
	if( iLast != iHashResult )
	{
		OUString* pNames = mNames.getArray();
		Any* pValues = mValues.getArray();
		pNames[ iHashResult ] = pNames[ iLast ];
		pValues[ iHashResult ] = pValues[ iLast ];
		mHashMap[ pNames[ iHashResult ] ] = iHashResult;
	}
	mNames.realloc( iLast );
	mValues.realloc( iLast );
	mnElementCount--;

	
	// Fire event
	ContainerEvent aEvent;		
	aEvent.Source = mpxEventSource;
	aEvent.Accessor <<= Name;
	aEvent.Element = aOldElement;

	OInterfaceIteratorHelper aIterator( maListenerContainer );
	while( aIterator.hasMoreElements() )
	{
		Reference< XInterface > xIface = aIterator.next();
		Reference< XContainerListener > xListener( xIface, UNO_QUERY );
		xListener->elementRemoved( aEvent );
	}
}


// Methods XContainer
void SAL_CALL NameContainer_Impl::addContainerListener( const Reference< XContainerListener >& xListener ) 
	throw (RuntimeException)
{
	if( !xListener.is() )
		throw RuntimeException();
	Reference< XInterface > xIface( xListener, UNO_QUERY );
	maListenerContainer.addInterface( xIface );
}

void SAL_CALL NameContainer_Impl::removeContainerListener( const Reference< XContainerListener >& xListener ) 
	throw (RuntimeException)
{
	if( !xListener.is() )
		throw RuntimeException();
	Reference< XInterface > xIface( xListener, UNO_QUERY );
	maListenerContainer.removeInterface( xIface );
}

}	// namespace SfxContainer_Impl


//============================================================================

// Implementation class SfxLibraryContainer_Impl

// Ctor
SfxLibraryContainer_Impl::SfxLibraryContainer_Impl( void )
	: maNameContainer( getCppuType( (Reference< XNameAccess >*) NULL ) )
	, mbModified( sal_False )
    , mbOldInfoFormat( sal_False )
    , mpBasMgr( NULL )
    , mbOwnBasMgr( sal_False )
{
	mxMSF = comphelper::getProcessServiceFactory();
	if( !mxMSF.is() )
	{
		OSL_ENSURE( 0, "### couln't get ProcessServiceFactory\n" );
	}

	mxSFI = Reference< XSimpleFileAccess >( mxMSF->createInstance
		( OUString::createFromAscii( "com.sun.star.ucb.SimpleFileAccess" ) ), UNO_QUERY );
	if( !mxSFI.is() )
	{
		OSL_ENSURE( 0, "### couln't create SimpleFileAccess component\n" );
	}
}

SfxLibraryContainer_Impl::~SfxLibraryContainer_Impl()
{
    if( mbOwnBasMgr )
        delete mpBasMgr;
}


sal_Bool SfxLibraryContainer_Impl::init( 
    const OUString& aInitialisationParam,
    const OUString& aInfoFileName,
    const OUString& aOldInfoFileName,
    const OUString& aLibElementFileExtension,
    const OUString& aLibrariesDir,
    SotStorageRef xStorage )
{
    maInitialisationParam = aInitialisationParam;
	maInfoFileName = aInfoFileName;
	maOldInfoFileName = aOldInfoFileName;
	maLibElementFileExtension = aLibElementFileExtension;
	maLibrariesDir = aLibrariesDir;

    meInitMode = DEFAULT;
    INetURLObject aInitUrlInetObj( maInitialisationParam );
    OUString aInitFileName = aInitUrlInetObj.GetMainURL();
    if( aInitFileName.getLength() )
    {
        // We need a BasicManager to avoid problems
        StarBASIC* pBas = new StarBASIC();
        mpBasMgr = new BasicManager( pBas );
        mbOwnBasMgr = sal_True;

        OUString aExtension = aInitUrlInetObj.getExtension();
        if( aExtension.compareToAscii( "xlc" ) == COMPARE_EQUAL )
        {
            meInitMode = CONTAINER_INIT_FILE;
        }
        else if( aExtension.compareToAscii( "xlb" ) == COMPARE_EQUAL )
        {
            meInitMode = LIBRARY_INIT_FILE;
        	SotStorageRef xDummyStor;
            ::xmlscript::LibDescriptor aLibDesc;
            sal_Bool bReadIndexFile = implLoadLibraryIndexFile( NULL, aLibDesc, xDummyStor, aInitFileName );
           	return bReadIndexFile;
        }
        else
        {
            // Decide between old and new document
            sal_Bool bOldStorage = SotStorage::IsOLEStorage( aInitFileName );
            if( bOldStorage )
            {
                meInitMode = OLD_BASIC_STORAGE;
                importFromOldStorage( aInitFileName );
            	return sal_True;
            }
            else
            {
                meInitMode = OFFICE_DOCUMENT;
                xStorage = new SotStorage( sal_True, aInitFileName );
            }
        }
    }   
    else
    {
        // Default pathes
        maLibraryPath = SvtPathOptions().GetBasicPath();
    }

	Reference< XParser > xParser( mxMSF->createInstance(
		OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.xml.sax.Parser") ) ), UNO_QUERY );
	if( !xParser.is() )
	{
		OSL_ENSURE( 0, "### couln't create sax parser component\n" );
		return sal_False;
	}

	Reference< XInputStream > xInput;

	mxStorage = xStorage;
	sal_Bool bStorage = mxStorage.Is();
	SotStorageRef xLibrariesStor;
	SotStorageStreamRef xStream;
	String aFileName;

	int nPassCount = 1;
	if( !bStorage && meInitMode == DEFAULT )
		nPassCount = 2;
	for( int nPass = 0 ; nPass < nPassCount ; nPass++ )
	{
		if( bStorage )
		{
			OSL_ENSURE( meInitMode == DEFAULT || meInitMode == OFFICE_DOCUMENT, 
				"### Wrong InitMode for document\n" );

			xLibrariesStor = xStorage->OpenSotStorage( maLibrariesDir, STREAM_READ | STREAM_NOCREATE );
			if( xLibrariesStor.Is() && xLibrariesStor->GetError() == ERRCODE_NONE )
			{
				aFileName = maInfoFileName;
				aFileName += String( RTL_CONSTASCII_USTRINGPARAM("-lc.xml") );

				xStream = xLibrariesStor->OpenSotStream( aFileName, STREAM_READ | STREAM_NOCREATE );
				if( xStream->GetError() != ERRCODE_NONE )
				{
					mbOldInfoFormat = true;

					// Check old version
					aFileName = maOldInfoFileName;
					aFileName += String( RTL_CONSTASCII_USTRINGPARAM(".xml") );
					xStream = xLibrariesStor->OpenSotStream( aFileName, STREAM_READ );

					if( xStream->GetError() != ERRCODE_NONE )
					{
						// Check for EA2 document version with wrong extensions
						aFileName = maOldInfoFileName;
						aFileName += String( RTL_CONSTASCII_USTRINGPARAM(".xli") );
						xStream = xLibrariesStor->OpenSotStream( aFileName, STREAM_READ );
					}
				}

				if( xStream->GetError() == ERRCODE_NONE )
				{
					xInput = new utl::OInputStreamWrapper( *xStream );
				}
			}
		}
		else
		{
			INetURLObject* pLibInfoInetObj = NULL;
			if( meInitMode == CONTAINER_INIT_FILE )
			{
				aFileName = aInitFileName;
			}
			else
			{
				if( nPass == 1 )
					pLibInfoInetObj = new INetURLObject( String(maLibraryPath).GetToken(0) );
				else
					pLibInfoInetObj = new INetURLObject( String(maLibraryPath).GetToken(1) );
				OUString aInfoFileName( maInfoFileName );
				pLibInfoInetObj->insertName( aInfoFileName, sal_True, INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
				pLibInfoInetObj->setExtension( OUString( RTL_CONSTASCII_USTRINGPARAM("xlc") ) );
				aFileName = pLibInfoInetObj->GetMainURL();
			}

			try
			{
				xInput = mxSFI->openFileRead( aFileName );
			}
			catch( Exception& )
			//catch( Exception& e )
			{
				xInput.clear();

				// TODO:
				//throw WrappedTargetException( e );
				//throw e;
			}

			// Old variant?
			if( !xInput.is() && nPass == 0 )
			{
				INetURLObject aLibInfoInetObj( String(maLibraryPath).GetToken(1) );
				aLibInfoInetObj.insertName( maOldInfoFileName, sal_True, INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
				aLibInfoInetObj.setExtension( OUString( RTL_CONSTASCII_USTRINGPARAM("xli") ) );
				aFileName = aLibInfoInetObj.GetMainURL();

				try
				{
					xInput = mxSFI->openFileRead( aFileName );
					mbOldInfoFormat = true;
				}
				catch( Exception& )
				{
				}
			}

			delete pLibInfoInetObj;
		}

		if( !xInput.is() )
		{
			// In the second pass it's ok when no index file is found
			if( nPass == 1 )
				return sal_True;

			// TODO: When really error?
			//OSL_ENSURE( 0, "### couln't open input stream\n" );
			return sal_False;
		}	
		InputSource source;
		source.aInputStream = xInput;
		source.sSystemId 	= aFileName;

		// start parsing
		::xmlscript::LibDescriptorArray* pLibArray = new ::xmlscript::LibDescriptorArray();
		xParser->setDocumentHandler( ::xmlscript::importLibraryContainer( pLibArray ) );
		xParser->parseStream( source );

		sal_Int32 nLibCount = pLibArray->mnLibCount;
		for( sal_Int32 i = 0 ; i < nLibCount ; i++ )
		{
			::xmlscript::LibDescriptor& rLib = pLibArray->mpLibs[i];

			// Check storage URL
			OUString aStorageURL = rLib.aStorageURL;
			if( !bStorage && !aStorageURL.getLength() && nPass == 0 )
			{
				INetURLObject aInetObj( String(maLibraryPath).GetToken(1) );
				aInetObj.insertName( rLib.aName, sal_True, INetURLObject::LAST_SEGMENT,
					sal_True, INetURLObject::ENCODE_ALL );
				OUString aLibDirPath = aInetObj.GetMainURL();
				if( mxSFI->isFolder( aLibDirPath ) )
				{
					rLib.aStorageURL = aLibDirPath;
					mbModified = sal_True;
				}
				else if( rLib.bLink )
				{
					// Check "share" path
					INetURLObject aShareInetObj( String(maLibraryPath).GetToken(0) );
					aShareInetObj.insertName( rLib.aName, sal_True, INetURLObject::LAST_SEGMENT,
						sal_True, INetURLObject::ENCODE_ALL );
					OUString aShareLibDirPath = aShareInetObj.GetMainURL();
					if( mxSFI->isFolder( aShareLibDirPath ) )
					{
						rLib.aStorageURL = aShareLibDirPath;
						mbModified = sal_True;
					}
				}
			}

			OUString aLibName = rLib.aName;

			// If the same library name is used by the shared and the 
			// user lib container index files the user file wins
			if( nPass == 1 && hasByName( aLibName ) )
				continue;

			SfxLibrary_Impl* pImplLib;
			if( rLib.bLink )
			{
				Reference< XNameAccess > xLib =
					createLibraryLink( aLibName, rLib.aStorageURL, rLib.bReadOnly );
				pImplLib = static_cast< SfxLibrary_Impl* >( xLib.get() );
			}
			else
			{
				Reference< XNameContainer > xLib = createLibrary( aLibName );
				pImplLib = static_cast< SfxLibrary_Impl* >( xLib.get() );
				pImplLib->mbLoaded = sal_False;
				pImplLib->mbReadOnly = rLib.bReadOnly;
				if( !bStorage )
					checkStorageURL( rLib.aStorageURL, pImplLib->maLibInfoFileURL, pImplLib->maStorageURL );
			}

			// Read library info files
			if( !mbOldInfoFormat )
			{
        		SotStorageRef xLibraryStor;
          		if( bStorage )
				{
					xLibraryStor = xLibrariesStor->OpenSotStorage( rLib.aName, STREAM_READ | STREAM_NOCREATE );
					if( !xLibraryStor.Is() || xLibraryStor->GetError() != ERRCODE_NONE )
					{
						OSL_ENSURE( 0, "### couln't open sub storage for library\n" );
						xLibraryStor = NULL;
					}
				}

				// Link is already initialised in createLibraryLink()
				if( !pImplLib->mbInitialised && (!bStorage || xLibraryStor.Is()) )
				{
					OUString aIndexFileName;
					sal_Bool bLoaded = implLoadLibraryIndexFile( pImplLib, rLib, xLibraryStor, aIndexFileName );
					if( bLoaded && aLibName != rLib.aName ) 
					{
						OSL_ENSURE( 0, "Different library names in library"
							" container and library info files!\n" );
					}
				}
			}
			else if( !bStorage )
			{
				// Write new index file immediately because otherwise
				// the library elements will be lost when storing into
				// the new info format
				SotStorageRef xStorage;
				implStoreLibraryIndexFile( pImplLib, rLib, xStorage );
			}

			implImportLibDescriptor( pImplLib, rLib );

			if( nPass == 1 )
			{
				pImplLib->mbSharedIndexFile = sal_True;
				pImplLib->mbReadOnly = sal_True;
			}
		}

		// Keep flag for documents to force writing the new index files
		if( !bStorage )
			mbOldInfoFormat = sal_False;

		delete pLibArray;
	}

	return sal_True;
}

// Handle maLibInfoFileURL and maStorageURL correctly
void SfxLibraryContainer_Impl::checkStorageURL( const OUString& aSourceURL, 
    OUString& aLibInfoFileURL, OUString& aStorageURL )
{
	INetURLObject aInetObj( aSourceURL );
    OUString aExtension = aInetObj.getExtension();
    if( aExtension.compareToAscii( "xlb" ) == COMPARE_EQUAL )
    {
        // URL to xlb file
		aLibInfoFileURL = aSourceURL;
        aInetObj.removeSegment();
		aStorageURL = aInetObj.GetMainURL();
    }
    else
    {
        // URL to library folder
        aStorageURL = aSourceURL;
		aInetObj.insertName( maInfoFileName, sal_True, INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
		aInetObj.setExtension( OUString( RTL_CONSTASCII_USTRINGPARAM("xlb") ) );
		aLibInfoFileURL = aInetObj.GetMainURL();
    }
}

SfxLibrary_Impl* SfxLibraryContainer_Impl::getImplLib( const String& rLibraryName )
{
	Any aLibAny = maNameContainer.getByName( rLibraryName ) ;
	Reference< XNameAccess > xNameAccess;
	aLibAny >>= xNameAccess;
	SfxLibrary_Impl* pImplLib = static_cast< SfxLibrary_Impl* >( xNameAccess.get() );
    return pImplLib;
}


// Storing with password encryption

// Empty implementation, avoids unneccesary implementation in dlgcont.cxx
sal_Bool SfxLibraryContainer_Impl::implStorePasswordLibrary( SfxLibrary_Impl* pLib, 
    const OUString& aName, SotStorageRef xStorage )
{
    return sal_False;
}

sal_Bool SfxLibraryContainer_Impl::implLoadPasswordLibrary
    ( SfxLibrary_Impl* pLib, const OUString& Name, sal_Bool bVerifyPasswordOnly )
        throw(WrappedTargetException, RuntimeException)
{
    return sal_True;
}



OUString SfxLibraryContainer_Impl::createAppLibraryFolder
    ( SfxLibrary_Impl* pLib, const OUString& aName )
{
	OUString aLibDirPath = pLib->maStorageURL;
	if( !aLibDirPath.getLength() )
    {
		INetURLObject aInetObj( String(maLibraryPath).GetToken(1) );
		aInetObj.insertName( aName, sal_True, INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
        checkStorageURL( aInetObj.GetMainURL(), pLib->maLibInfoFileURL, pLib->maStorageURL );
		aLibDirPath = pLib->maStorageURL;
    }

	if( !mxSFI->isFolder( aLibDirPath ) )
		mxSFI->createFolder( aLibDirPath );

    return aLibDirPath;
}

// Storing
void SfxLibraryContainer_Impl::implStoreLibrary( SfxLibrary_Impl* pLib,
	const OUString& aName, SotStorageRef xStorage )
{
	sal_Bool bLink = pLib->mbLink;
	sal_Bool bStorage = xStorage.Is() && !bLink;

	Sequence< OUString > aElementNames = pLib->getElementNames();
	sal_Int32 nNameCount = aElementNames.getLength();
	const OUString* pNames = aElementNames.getConstArray();
    OUString aLibDirPath;

	if( bStorage )
	{
		for( sal_Int32 i = 0 ; i < nNameCount ; i++ )
		{
			OUString aElementName = pNames[ i ];

			OUString aStreamName = aElementName;
			aStreamName += String( RTL_CONSTASCII_USTRINGPARAM(".xml") );

			Any aElement = pLib->getByName( aElementName );
			if( isLibraryElementValid( aElement ) )
			{
				SotStorageStreamRef xElementStream = xStorage->OpenSotStream
					( aStreamName, STREAM_WRITE | STREAM_SHARE_DENYWRITE );

				if( xElementStream->GetError() == ERRCODE_NONE )
				{
					String aPropName( String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM("MediaType") ) );
					OUString aMime( RTL_CONSTASCII_USTRINGPARAM("text/xml") );
					Any aAny;
					aAny <<= aMime;
					xElementStream->SetProperty( aPropName, aAny );

                    // #87671 Allow encryption
					aPropName = String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM("Encrypted") );
					aAny <<= sal_True;
					xElementStream->SetProperty( aPropName, aAny );

					Reference< XOutputStream > xOutput =
						new utl::OOutputStreamWrapper( *xElementStream );
					writeLibraryElement( aElement, aElementName, xOutput );
					xOutput->closeOutput();

					xElementStream->Commit();
				}
			}
		}
	}
	else
	{
		try
		{
			// Get Output stream
            aLibDirPath = createAppLibraryFolder( pLib, aName );

			for( sal_Int32 i = 0 ; i < nNameCount ; i++ )
			{
				OUString aElementName = pNames[ i ];

				INetURLObject aElementInetObj( aLibDirPath );
				aElementInetObj.insertName( aElementName, sal_False,
					INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
				aElementInetObj.setExtension( maLibElementFileExtension );
				String aElementPath( aElementInetObj.GetMainURL() );

				Any aElement = pLib->getByName( aElementName );
				if( isLibraryElementValid( aElement ) )
				{
					// TODO: Check modified
		            try
		            {
					    if( mxSFI->exists( aElementPath ) )
						    mxSFI->kill( aElementPath );
    					Reference< XOutputStream > xOutput = mxSFI->openFileWrite( aElementPath );
					    writeLibraryElement( aElement, aElementName, xOutput );
					    xOutput->closeOutput();
                    }
            		catch( Exception& )
                    {
			            SfxErrorContext aEc( ERRCTX_SFX_SAVEDOC, aElementPath );
                        ULONG nErrorCode = ERRCODE_IO_GENERAL;
                	    ErrorHandler::HandleError( nErrorCode );
                    }
				}
			}
		}
		catch( Exception& )
		//catch( Exception& e )
		{
			// TODO
			//throw e;
		}
	}
}


void SfxLibraryContainer_Impl::implStoreLibraryIndexFile( SfxLibrary_Impl* pLib,
	const ::xmlscript::LibDescriptor& rLib, SotStorageRef xStorage )
{
	// Create sax writer
	Reference< XExtendedDocumentHandler > xHandler(
		mxMSF->createInstance(
			OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.xml.sax.Writer") ) ), UNO_QUERY );
	if( !xHandler.is() )
	{
		OSL_ENSURE( 0, "### couln't create sax-writer component\n" );
		return;
	}

	sal_Bool bLink = pLib->mbLink;
	sal_Bool bStorage = xStorage.Is() && !bLink;

	// Write info file
	Reference< XOutputStream > xOut;
	SotStorageStreamRef xInfoStream;
	if( bStorage )
	{
		OUString aStreamName( maInfoFileName );
		aStreamName += String( RTL_CONSTASCII_USTRINGPARAM("-lb.xml") );

		xInfoStream = xStorage->OpenSotStream( aStreamName,
			STREAM_WRITE | STREAM_SHARE_DENYWRITE );

		if( xInfoStream->GetError() == ERRCODE_NONE )
		{
			String aPropName( String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM("MediaType") ) );
			OUString aMime( RTL_CONSTASCII_USTRINGPARAM("text/xml") );
			Any aAny;
			aAny <<= aMime;
			xInfoStream->SetProperty( aPropName, aAny );

            // #87671 Allow encryption
			aPropName = String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM("Encrypted") );
			aAny <<= sal_True;
			xInfoStream->SetProperty( aPropName, aAny );

			xOut = new utl::OOutputStreamWrapper( *xInfoStream );
		}
	}
	else
	{
		// Create Output stream
        createAppLibraryFolder( pLib, rLib.aName );
        String aLibInfoPath = pLib->maLibInfoFileURL;

		try
		{
		    if( mxSFI->exists( aLibInfoPath ) )
			    mxSFI->kill( aLibInfoPath );
		    xOut = mxSFI->openFileWrite( aLibInfoPath );
        }
        catch( Exception& )
        {
			SfxErrorContext aEc( ERRCTX_SFX_SAVEDOC, aLibInfoPath );
            ULONG nErrorCode = ERRCODE_IO_GENERAL;
            ErrorHandler::HandleError( nErrorCode );
        }

	}
	if( !xOut.is() )
	{
		OSL_ENSURE( 0, "### couln't open output stream\n" );
		return;
	}

	Reference< XActiveDataSource > xSource( xHandler, UNO_QUERY );
	xSource->setOutputStream( xOut );

    xmlscript::exportLibrary( xHandler, rLib );

	if( xInfoStream.Is() )
		xInfoStream->Commit();
}


sal_Bool SfxLibraryContainer_Impl::implLoadLibraryIndexFile(  SfxLibrary_Impl* pLib, 
    ::xmlscript::LibDescriptor& rLib, SotStorageRef xStorage, const OUString& aIndexFileName )
{
	Reference< XParser > xParser( mxMSF->createInstance(
		OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.xml.sax.Parser") ) ), UNO_QUERY );
	if( !xParser.is() )
	{
		OSL_ENSURE( 0, "### couln't create sax parser component\n" );
		return sal_False;
	}

	sal_Bool bLink = sal_False;
	sal_Bool bStorage = sal_False;
    if( pLib )
    {
	    bLink = pLib->mbLink;
	    bStorage = xStorage.Is() && !bLink;
    }

	// Read info file
	Reference< XInputStream > xInput;
	SotStorageStreamRef xInfoStream;
	String aLibInfoPath;
	if( bStorage )
	{
		aLibInfoPath = maInfoFileName;
		aLibInfoPath += String( RTL_CONSTASCII_USTRINGPARAM("-lb.xml") );

		xInfoStream = xStorage->OpenSotStream( aLibInfoPath, STREAM_READ );
		if( xInfoStream->GetError() == ERRCODE_NONE )
		{
			xInput = new utl::OInputStreamWrapper( *xInfoStream );
		}
	}
	else
	{
		// Create Input stream
        String aLibInfoPath;

        if( pLib )
        {
            createAppLibraryFolder( pLib, rLib.aName );
            aLibInfoPath = pLib->maLibInfoFileURL;
        }
        else
            aLibInfoPath = aIndexFileName;

		try
		{
			xInput = mxSFI->openFileRead( aLibInfoPath );
		}
		catch( Exception& )
		//catch( Exception& e )
		{
			// TODO:
			//throw WrappedTargetException( e );
			//throw e;
		}
	}
	if( !xInput.is() )
	{
		// OSL_ENSURE( 0, "### couln't open input stream\n" );
		return sal_False;
	}


	InputSource source;
	source.aInputStream = xInput;
	source.sSystemId 	= aLibInfoPath;

	// start parsing
	xParser->setDocumentHandler( ::xmlscript::importLibrary( rLib ) );
	xParser->parseStream( source );

    if( !pLib )
    {
		Reference< XNameContainer > xLib = createLibrary( rLib.aName );
		pLib = static_cast< SfxLibrary_Impl* >( xLib.get() );
		pLib->mbLoaded = sal_False;
        rLib.aStorageURL = aIndexFileName;
        checkStorageURL( rLib.aStorageURL, pLib->maLibInfoFileURL, pLib->maStorageURL );

        implImportLibDescriptor( pLib, rLib );
    }

    return sal_True;
}

void SfxLibraryContainer_Impl::implImportLibDescriptor
    ( SfxLibrary_Impl* pLib, ::xmlscript::LibDescriptor& rLib )
{
    if( !pLib->mbInitialised )
    {
	    sal_Int32 nElementCount = rLib.aElementNames.getLength();
	    const OUString* pElementNames = rLib.aElementNames.getConstArray();
	    Any aDummyElement = createEmptyLibraryElement();
	    for( sal_Int32 i = 0 ; i < nElementCount ; i++ )
	    {
		    pLib->maNameContainer.insertByName( pElementNames[i], aDummyElement );
	    }
        pLib->mbPasswordProtected = rLib.bPasswordProtected;
        pLib->mbReadOnly = rLib.bReadOnly;
        pLib->mbModified = sal_False;

        pLib->mbInitialised = sal_True;
    }
}


void SfxLibraryContainer_Impl::storeLibraries( sal_Bool bComplete )
{
	SotStorageRef xStorage;
	storeLibraries_Impl( xStorage, bComplete );
}

void SfxLibraryContainer_Impl::storeLibrariesToStorage( SotStorageRef xStorage )
{
	sal_Bool bComplete = sal_True;
	storeLibraries_Impl( xStorage, bComplete );
}

// Methods of new XLibraryStorage interface?
void SfxLibraryContainer_Impl::storeLibraries_Impl( SotStorageRef xStorage, sal_Bool bComplete )
{
	Sequence< OUString > aNames = maNameContainer.getElementNames();
	const OUString* pNames = aNames.getConstArray();
	sal_Int32 i, nNameCount = aNames.getLength();

	// Don't count libs from shared index file
	sal_Int32 nLibsToSave = nNameCount;
	for( i = 0 ; i < nNameCount ; i++ )
	{
        SfxLibrary_Impl* pImplLib = getImplLib( pNames[ i ] );
		if( pImplLib->mbSharedIndexFile )
			nLibsToSave--;
	}
    if( !nLibsToSave )
        return;

	::xmlscript::LibDescriptorArray* pLibArray = new ::xmlscript::LibDescriptorArray( nLibsToSave );

	// Write to storage?
	sal_Bool bStorage = xStorage.Is();
	SotStorageRef xLibrariesStor;
	SotStorageRef xSourceLibrariesStor;
	if( bStorage )
	{
        // Don't write if only empty standard lib exists
        if( nNameCount == 1 )
        {
            // Must be standard lib
		    Any aLibAny = maNameContainer.getByName( pNames[0] );
		    Reference< XNameAccess > xNameAccess;
		    aLibAny >>= xNameAccess;
            if( !xNameAccess->hasElements() )
                return;
        }

		xLibrariesStor = xStorage->OpenUCBStorage( maLibrariesDir, STREAM_WRITE );
		if( !xLibrariesStor.Is() || xLibrariesStor->GetError() != ERRCODE_NONE )
		{
			OSL_ENSURE( 0, "### couln't create libraries sub storage\n" );
			return;
		}

        xSourceLibrariesStor = mxStorage->OpenSotStorage( maLibrariesDir, STREAM_READ | STREAM_NOCREATE );
		if( !xSourceLibrariesStor.Is() || xSourceLibrariesStor->GetError() != ERRCODE_NONE )
            xSourceLibrariesStor = NULL;
	}

	int iArray = 0;
	for( i = 0 ; i < nNameCount ; i++ )
	{
        SfxLibrary_Impl* pImplLib = getImplLib( pNames[ i ] );
		if( pImplLib->mbSharedIndexFile )
			continue;
		::xmlscript::LibDescriptor& rLib = pLibArray->mpLibs[iArray];
		rLib.aName = pNames[ i ];
		iArray++;

		rLib.bLink = pImplLib->mbLink;
		rLib.aStorageURL = pImplLib->maLibInfoFileURL;
		rLib.bReadOnly = pImplLib->mbReadOnly;
		rLib.bPasswordProtected = pImplLib->mbPasswordProtected;
		rLib.aElementNames = pImplLib->getElementNames();

		if( pImplLib->mbModified || bComplete )
		{
            // Can we copy the storage?
            if( !mbOldInfoFormat && !pImplLib->mbModified && xSourceLibrariesStor.Is() )
            {
                BOOL bRet = xSourceLibrariesStor->CopyTo
                    ( rLib.aName, xLibrariesStor, rLib.aName );
            }
            else
            {
				SotStorageRef xLibraryStor;
				if( bStorage )
				{
					xLibraryStor = xLibrariesStor->OpenUCBStorage( rLib.aName, STREAM_WRITE );
					if( !xLibraryStor.Is() || xLibraryStor->GetError() != ERRCODE_NONE )
					{
						OSL_ENSURE( 0, "### couln't create sub storage for library\n" );
						return;
					}
				}

				// Maybe lib is not loaded?!
				if( bComplete )
					loadLibrary( rLib.aName );

    			if( pImplLib->mbPasswordProtected )
				    implStorePasswordLibrary( pImplLib, rLib.aName, xLibraryStor );
                    // TODO: Check return value
                else
				    implStoreLibrary( pImplLib, rLib.aName, xLibraryStor );

                implStoreLibraryIndexFile( pImplLib, rLib, xLibraryStor );
				if( bStorage )
				{
					xLibraryStor->Commit();
				}
            }

			mbModified = sal_True;
			pImplLib->mbModified = sal_False;
		}

        // For container info ReadOnly refers to mbReadOnlyLink
		rLib.bReadOnly = pImplLib->mbReadOnlyLink;
	}

	if( !mbOldInfoFormat && !mbModified )
		return;
	mbModified = sal_False;
    mbOldInfoFormat = sal_False;

	// Write library container info
	// Create sax writer
	Reference< XExtendedDocumentHandler > xHandler(
		mxMSF->createInstance(
			OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.xml.sax.Writer") ) ), UNO_QUERY );
	if( !xHandler.is() )
	{
		OSL_ENSURE( 0, "### couln't create sax-writer component\n" );
		return;
	}

	// Write info file
	Reference< XOutputStream > xOut;
	SotStorageStreamRef xInfoStream;
	if( bStorage )
	{
		OUString aStreamName( maInfoFileName );
		aStreamName += String( RTL_CONSTASCII_USTRINGPARAM("-lc.xml") );

		xInfoStream = xLibrariesStor->OpenSotStream( aStreamName,
			STREAM_WRITE | STREAM_SHARE_DENYWRITE );

		if( xInfoStream->GetError() == ERRCODE_NONE )
		{
			String aPropName( String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM("MediaType") ) );
			OUString aMime( RTL_CONSTASCII_USTRINGPARAM("text/xml") );
			Any aAny;
			aAny <<= aMime;
			xInfoStream->SetProperty( aPropName, aAny );

            // #87671 Allow encryption
			aPropName = String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM("Encrypted") );
			aAny <<= sal_True;
			xInfoStream->SetProperty( aPropName, aAny );

			xOut = new utl::OOutputStreamWrapper( *xInfoStream );
		}
	}
	else
	{
		// Create Output stream
		INetURLObject aLibInfoInetObj( String(maLibraryPath).GetToken(1) );
		aLibInfoInetObj.insertName( maInfoFileName, sal_True, INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
		aLibInfoInetObj.setExtension( OUString( RTL_CONSTASCII_USTRINGPARAM("xlc") ) );
		String aLibInfoPath( aLibInfoInetObj.GetMainURL() );

		try
		{
		    if( mxSFI->exists( aLibInfoPath ) )
			    mxSFI->kill( aLibInfoPath );
		    xOut = mxSFI->openFileWrite( aLibInfoPath );
        }
        catch( Exception& )
        {
			SfxErrorContext aEc( ERRCTX_SFX_SAVEDOC, aLibInfoPath );
            ULONG nErrorCode = ERRCODE_IO_GENERAL;
            ErrorHandler::HandleError( nErrorCode );
        }

	}
	if( !xOut.is() )
	{
		OSL_ENSURE( 0, "### couln't open output stream\n" );
		return;
	}

	Reference< XActiveDataSource > xSource( xHandler, UNO_QUERY );
	xSource->setOutputStream( xOut );

	xmlscript::exportLibraryContainer( xHandler, pLibArray );
	if( xInfoStream.Is() )
		xInfoStream->Commit();
	if( xLibrariesStor.Is() )
		xLibrariesStor->Commit();

	delete pLibArray;
}


// Methods XElementAccess
Type SfxLibraryContainer_Impl::getElementType()
	throw(RuntimeException)
{
	return maNameContainer.getElementType();
}

sal_Bool SfxLibraryContainer_Impl::hasElements()
	throw(RuntimeException)
{
	sal_Bool bRet = maNameContainer.hasElements();
	return bRet;
}

// Methods XNameAccess
Any SfxLibraryContainer_Impl::getByName( const OUString& aName )
	throw(NoSuchElementException, WrappedTargetException, RuntimeException)
{
	Any aRetAny = maNameContainer.getByName( aName ) ;
	return aRetAny;
}

Sequence< OUString > SfxLibraryContainer_Impl::getElementNames()
	throw(RuntimeException)
{
	return maNameContainer.getElementNames();
}

sal_Bool SfxLibraryContainer_Impl::hasByName( const OUString& aName )
	throw(RuntimeException)
{
	sal_Bool bRet = maNameContainer.hasByName( aName ) ;
	return bRet;
}

// Methods XLibraryContainer
Reference< XNameContainer > SAL_CALL SfxLibraryContainer_Impl::createLibrary( const OUString& Name )
		throw(IllegalArgumentException, ElementExistException, RuntimeException)
{
	SfxLibrary_Impl* pNewLib = implCreateLibrary();
    pNewLib->maLibElementFileExtension = maLibElementFileExtension;
	Reference< XNameAccess > xNameAccess = static_cast< XNameAccess* >( pNewLib );
	Any aElement;
	aElement <<= xNameAccess;
	maNameContainer.insertByName( Name, aElement );
	mbModified = sal_True;
    Reference< XNameContainer > xRet( xNameAccess, UNO_QUERY );
	return xRet;
}

Reference< XNameAccess > SAL_CALL SfxLibraryContainer_Impl::createLibraryLink
	( const OUString& Name, const OUString& StorageURL, sal_Bool ReadOnly )
		throw(IllegalArgumentException, ElementExistException, RuntimeException)
{
	// TODO: Check other reasons to force ReadOnly status
	//if( !ReadOnly )
	//{
	//}

    OUString aLibInfoFileURL;
    OUString aLibDirURL;
    checkStorageURL( StorageURL, aLibInfoFileURL, aLibDirURL );


	SfxLibrary_Impl* pNewLib = implCreateLibraryLink( aLibInfoFileURL, aLibDirURL, ReadOnly );
    pNewLib->maLibElementFileExtension = maLibElementFileExtension;

    OUString aInitFileName;
    SotStorageRef xDummyStor;
    ::xmlscript::LibDescriptor aLibDesc;
    sal_Bool bReadIndexFile = implLoadLibraryIndexFile( pNewLib, aLibDesc, xDummyStor, aInitFileName );
    implImportLibDescriptor( pNewLib, aLibDesc );

	Reference< XNameAccess > xRet = static_cast< XNameAccess* >( pNewLib );
	Any aElement;
	aElement <<= xRet;
	maNameContainer.insertByName( Name, aElement );
	mbModified = sal_True;
	return xRet;
}

void SAL_CALL SfxLibraryContainer_Impl::removeLibrary( const OUString& Name )
	throw(NoSuchElementException, WrappedTargetException, RuntimeException)
{
    // Get and hold library before removing
	Any aLibAny = maNameContainer.getByName( Name ) ;
	Reference< XNameAccess > xNameAccess;
	aLibAny >>= xNameAccess;
	SfxLibrary_Impl* pImplLib = static_cast< SfxLibrary_Impl* >( xNameAccess.get() );
	if( pImplLib->mbReadOnly && !pImplLib->mbLink )
		throw IllegalArgumentException();

    // Remove from container
	maNameContainer.removeByName( Name );
	mbModified = sal_True;

    // Delete library files, but not for linked libraries
    if( !pImplLib->mbLink )
    {
	    if( mxStorage.Is() )
            return;
	    Reference< XNameAccess > xNameAccess;
	    aLibAny >>= xNameAccess;
	    SfxLibrary_Impl* pImplLib = static_cast< SfxLibrary_Impl* >( xNameAccess.get() );
	    if( xNameAccess->hasElements() )
	    {
		    Sequence< OUString > aNames = pImplLib->getElementNames();
		    sal_Int32 nNameCount = aNames.getLength();
		    const OUString* pNames = aNames.getConstArray();
		    for( sal_Int32 i = 0 ; i < nNameCount ; i++ )
		    {
			    OUString aElementName = pNames[ i ];
                pImplLib->removeByName( aElementName );
		    }
	    }

        // Delete index file
        createAppLibraryFolder( pImplLib, Name );
        String aLibInfoPath = pImplLib->maLibInfoFileURL;
		try
		{
		    if( mxSFI->exists( aLibInfoPath ) )
			    mxSFI->kill( aLibInfoPath );
        }
        catch( Exception& ) {}

        // Delete folder if empty
	    INetURLObject aInetObj( String(maLibraryPath).GetToken(1) );
	    aInetObj.insertName( Name, sal_True, INetURLObject::LAST_SEGMENT,
		    sal_True, INetURLObject::ENCODE_ALL );
	    OUString aLibDirPath = aInetObj.GetMainURL();

	    try
	    {
	        if( mxSFI->isFolder( aLibDirPath ) )
	        {
                Sequence< OUString > aContentSeq = mxSFI->getFolderContents( aLibDirPath, true );
    		    sal_Int32 nCount = aContentSeq.getLength();
	            if( !nCount )
		            mxSFI->kill( aLibDirPath );
	        }
        }
        catch( Exception& )
        {
        }
    }
}

sal_Bool SAL_CALL SfxLibraryContainer_Impl::isLibraryLoaded( const OUString& Name )
	throw(NoSuchElementException, RuntimeException)
{
    SfxLibrary_Impl* pImplLib = getImplLib( Name );
	sal_Bool bRet = pImplLib->mbLoaded;
	return bRet;
}


void SAL_CALL SfxLibraryContainer_Impl::loadLibrary( const OUString& Name )
	throw(NoSuchElementException, WrappedTargetException, RuntimeException)
{
	Any aLibAny = maNameContainer.getByName( Name ) ;
	Reference< XNameAccess > xNameAccess;
	aLibAny >>= xNameAccess;
	SfxLibrary_Impl* pImplLib = static_cast< SfxLibrary_Impl* >( xNameAccess.get() );

    sal_Bool bLoaded = pImplLib->mbLoaded;
	pImplLib->mbLoaded = sal_True;
	if( !bLoaded && xNameAccess->hasElements() )
	{
        if( pImplLib->mbPasswordProtected )
        {
            implLoadPasswordLibrary( pImplLib, Name );
            return;
        }

		sal_Bool bLink = pImplLib->mbLink;
		sal_Bool bStorage = mxStorage.Is() && !bLink;

		SotStorageRef xLibrariesStor;
		SotStorageRef xLibraryStor;
		SotStorageStreamRef xElementStream;
		if( bStorage )
		{
            xLibrariesStor = mxStorage->OpenSotStorage( maLibrariesDir, STREAM_READ | STREAM_NOCREATE );
			if( xLibrariesStor.Is() && xLibrariesStor->GetError() == ERRCODE_NONE )
			{
                xLibraryStor = xLibrariesStor->OpenSotStorage( Name, STREAM_READ | STREAM_NOCREATE );
			}
			if( !xLibraryStor.Is() || xLibraryStor->GetError() != ERRCODE_NONE )
			{
				OSL_ENSURE( 0, "### couln't open sub storage for library\n" );
				return;
			}
		}

		Sequence< OUString > aNames = pImplLib->getElementNames();
		sal_Int32 nNameCount = aNames.getLength();
		const OUString* pNames = aNames.getConstArray();
		for( sal_Int32 i = 0 ; i < nNameCount ; i++ )
		{
			OUString aElementName = pNames[ i ];

			OUString aFile;
			if( bStorage )
			{
				aFile = aElementName;
				aFile += String( RTL_CONSTASCII_USTRINGPARAM(".xml") );

				xElementStream = xLibraryStor->OpenSotStream( aFile, STREAM_READ );
				if( xElementStream->GetError() != ERRCODE_NONE )
				{
					// Check for EA2 document version with wrong extensions
					aFile = aElementName;
					aFile += String( RTL_CONSTASCII_USTRINGPARAM(".") );
					aFile += maLibElementFileExtension;
					xElementStream = xLibraryStor->OpenSotStream( aFile, STREAM_READ );
				}

				if( !xElementStream.Is() || xElementStream->GetError() != ERRCODE_NONE )
				{
					OSL_ENSURE( 0, "### couln't open library element stream\n" );
					return;
				}
			}
			else
			{
		        String aLibDirPath = pImplLib->maStorageURL;
				INetURLObject aElementInetObj( aLibDirPath );
				aElementInetObj.insertName( aElementName, sal_False,
					INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
				aElementInetObj.setExtension( maLibElementFileExtension );
				aFile = aElementInetObj.GetMainURL();
			}

			Any aAny = importLibraryElement( aFile, xElementStream );
			if( pImplLib->hasByName( aElementName ) )
            {
                if( aAny.hasValue() )
				    pImplLib->maNameContainer.replaceByName( aElementName, aAny );
            }
			else
            {
				pImplLib->maNameContainer.insertByName( aElementName, aAny );
            }
		}

        pImplLib->mbModified = sal_False;
	}
}

// Methods XLibraryContainer2
sal_Bool SAL_CALL SfxLibraryContainer_Impl::isLibraryLink( const OUString& Name ) 
    throw (NoSuchElementException, RuntimeException)
{
    SfxLibrary_Impl* pImplLib = getImplLib( Name );
	sal_Bool bRet = pImplLib->mbLink;
	return bRet;
}

OUString SAL_CALL SfxLibraryContainer_Impl::getLibraryLinkURL( const OUString& Name ) 
    throw (IllegalArgumentException, NoSuchElementException, RuntimeException)
{
    SfxLibrary_Impl* pImplLib = getImplLib( Name );
	sal_Bool bLink = pImplLib->mbLink;
	if( !bLink )
		throw IllegalArgumentException();
    OUString aRetStr = pImplLib->maLibInfoFileURL;
    return aRetStr;
}

sal_Bool SAL_CALL SfxLibraryContainer_Impl::isLibraryReadOnly( const OUString& Name ) 
    throw (NoSuchElementException, RuntimeException)
{
    SfxLibrary_Impl* pImplLib = getImplLib( Name );
	sal_Bool bRet = pImplLib->mbReadOnly || (pImplLib->mbLink && pImplLib->mbReadOnlyLink);
	return bRet;
}

void SAL_CALL SfxLibraryContainer_Impl::setLibraryReadOnly( const OUString& Name, sal_Bool bReadOnly ) 
    throw (NoSuchElementException, RuntimeException)
{
    SfxLibrary_Impl* pImplLib = getImplLib( Name );
    if( pImplLib->mbLink )
    {
        if( pImplLib->mbReadOnlyLink != bReadOnly )
        {
            pImplLib->mbReadOnlyLink = bReadOnly;
            pImplLib->mbModified = sal_True;
            mbModified = sal_True;
        }
    }
    else
    {
        if( pImplLib->mbReadOnly != bReadOnly )
        {
	        pImplLib->mbReadOnly = bReadOnly;
            pImplLib->mbModified = sal_True;
        }
    }
}

void SAL_CALL SfxLibraryContainer_Impl::renameLibrary( const OUString& Name, const OUString& NewName ) 
    throw (NoSuchElementException, ElementExistException, RuntimeException)
{
	if( maNameContainer.hasByName( NewName ) )
		throw ElementExistException();

    // Get and hold library before removing
	Any aLibAny = maNameContainer.getByName( Name ) ;

    // Remove from container
	maNameContainer.removeByName( Name );
	mbModified = sal_True;

    // Rename library folder, but not for linked libraries
	Reference< XNameAccess > xNameAccess;
	aLibAny >>= xNameAccess;
	SfxLibrary_Impl* pImplLib = static_cast< SfxLibrary_Impl* >( xNameAccess.get() );
    bool bMovedSuccessful = true;

    // Rename files
    sal_Bool bStorage = mxStorage.Is();
    if( !bStorage && !pImplLib->mbLink )
    {
        bMovedSuccessful = false;

	    OUString aLibDirPath = pImplLib->maStorageURL;

	    INetURLObject aDestInetObj( String(maLibraryPath).GetToken(1) );
	    aDestInetObj.insertName( NewName, sal_True, INetURLObject::LAST_SEGMENT,
		    sal_True, INetURLObject::ENCODE_ALL );
	    OUString aDestDirPath = aDestInetObj.GetMainURL();

        // Store new URL
        OUString aLibInfoFileURL = pImplLib->maLibInfoFileURL;
        checkStorageURL( aDestDirPath, pImplLib->maLibInfoFileURL, pImplLib->maStorageURL );

	    try
	    {
	        if( mxSFI->isFolder( aLibDirPath ) )
	        {
			    if( !mxSFI->isFolder( aDestDirPath ) )
				    mxSFI->createFolder( aDestDirPath );

                // Move index file
		        try
		        {
					if( mxSFI->exists( pImplLib->maLibInfoFileURL ) )
						mxSFI->kill( pImplLib->maLibInfoFileURL );
            	    mxSFI->move( aLibInfoFileURL, pImplLib->maLibInfoFileURL );
                }
            	catch( Exception& )
                {
                }

			    Sequence< OUString > aElementNames = xNameAccess->getElementNames();
			    sal_Int32 nNameCount = aElementNames.getLength();
			    const OUString* pNames = aElementNames.getConstArray();
			    for( sal_Int32 i = 0 ; i < nNameCount ; i++ )
			    {
				    OUString aElementName = pNames[ i ];

				    INetURLObject aElementInetObj( aLibDirPath );
				    aElementInetObj.insertName( aElementName, sal_False,
					    INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
				    aElementInetObj.setExtension( maLibElementFileExtension );
				    String aElementPath( aElementInetObj.GetMainURL() );

				    INetURLObject aElementDestInetObj( aDestDirPath );
				    aElementDestInetObj.insertName( aElementName, sal_False,
					    INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
				    aElementDestInetObj.setExtension( maLibElementFileExtension );
				    String aDestElementPath( aElementDestInetObj.GetMainURL() );

		            try
		            {
					    if( mxSFI->exists( aDestElementPath ) )
						    mxSFI->kill( aDestElementPath );
            	        mxSFI->move( aElementPath, aDestElementPath );
                    }
            		catch( Exception& )
                    {
                    }
			    }

                // Delete folder if empty
                Sequence< OUString > aContentSeq = mxSFI->getFolderContents( aLibDirPath, true );
    		    sal_Int32 nCount = aContentSeq.getLength();
	            if( !nCount )
                {
       	            mxSFI->kill( aLibDirPath );
                }

                bMovedSuccessful = true;
				pImplLib->mbModified = true;
	        }
        }
        catch( Exception& )
        {
            // Restore old library
        	maNameContainer.insertByName( Name, aLibAny ) ;
        }
    }

    if( bMovedSuccessful )
       	maNameContainer.insertByName( NewName, aLibAny ) ;

}


// Methods XLibraryContainerPassword
sal_Bool SAL_CALL SfxLibraryContainer_Impl::isLibraryPasswordProtected( const OUString& Name ) 
    throw (NoSuchElementException, RuntimeException)
{
	sal_Bool bRet = sal_False;
	return bRet;
}

sal_Bool SAL_CALL SfxLibraryContainer_Impl::isLibraryPasswordVerified( const OUString& Name ) 
    throw (IllegalArgumentException, NoSuchElementException, RuntimeException)
{
	throw IllegalArgumentException();
}

sal_Bool SAL_CALL SfxLibraryContainer_Impl::verifyLibraryPassword
    ( const OUString& Name, const OUString& Password ) 
        throw (IllegalArgumentException, NoSuchElementException, RuntimeException)
{
	throw IllegalArgumentException();
}

void SAL_CALL SfxLibraryContainer_Impl::changeLibraryPassword( const OUString& Name, 
    const OUString& OldPassword, const OUString& NewPassword ) 
        throw (IllegalArgumentException, NoSuchElementException, RuntimeException)
{
	throw IllegalArgumentException();
}

// Methods XContainer
void SAL_CALL SfxLibraryContainer_Impl::addContainerListener( const Reference< XContainerListener >& xListener ) 
	throw (RuntimeException)
{
	maNameContainer.setEventSource( static_cast< XInterface* >( (OWeakObject*)this ) );
	maNameContainer.addContainerListener( xListener );
}

void SAL_CALL SfxLibraryContainer_Impl::removeContainerListener( const Reference< XContainerListener >& xListener ) 
	throw (RuntimeException)
{
	maNameContainer.removeContainerListener( xListener );
}


//============================================================================

// Implementation class SfxLibrary_Impl

// Ctor
SfxLibrary_Impl::SfxLibrary_Impl( Type aType, 
                                  Reference< XMultiServiceFactory > xMSF, 
                                  Reference< XSimpleFileAccess > xSFI )
	: OComponentHelper( m_mutex )
    , mxMSF( xMSF )
    , mxSFI( xSFI )
	, maNameContainer( aType )
	, mbLoaded( sal_True )
	, mbModified( sal_True )
    , mbInitialised( sal_False )
    , mbLink( sal_False )
	, mbReadOnly( sal_False )
    , mbReadOnlyLink( sal_False )
	, mbPasswordProtected( sal_False )
	, mbPasswordVerified( sal_False )
    , mbDoc50Password( sal_False )
	, mbSharedIndexFile( sal_False )
{
}

SfxLibrary_Impl::SfxLibrary_Impl( Type aType, 
                                  Reference< XMultiServiceFactory > xMSF, 
                                  Reference< XSimpleFileAccess > xSFI ,
                                  const OUString& aLibInfoFileURL, 
                                  const OUString& aStorageURL, sal_Bool ReadOnly )
	: OComponentHelper( m_mutex )
    , mxMSF( xMSF )
    , mxSFI( xSFI )
	, maNameContainer( aType )
	, mbLoaded( sal_False )
	, mbModified( sal_True )
    , mbInitialised( sal_False )
    , maLibInfoFileURL( aLibInfoFileURL )
	, maStorageURL( aStorageURL )
    , mbLink( sal_True )
	, mbReadOnly( sal_False )
    , mbReadOnlyLink( ReadOnly )
	, mbPasswordProtected( sal_False )
	, mbPasswordVerified( sal_False )
    , mbDoc50Password( sal_False )
	, mbSharedIndexFile( sal_False )
{
}


// Methods XInterface
Any SAL_CALL SfxLibrary_Impl::queryInterface( const Type& rType )
	throw( RuntimeException )
{
	Any aRet;

    /*
	if( mbReadOnly )
	{
		aRet = Any( ::cppu::queryInterface( rType,
			static_cast< XContainer * >( this ),
			static_cast< XNameAccess * >( this ) ) );
	}
	else
	{
    */
		aRet = Any( ::cppu::queryInterface( rType,
			static_cast< XContainer * >( this ),
			static_cast< XNameContainer * >( this ),
			static_cast< XNameAccess * >( this ) ) );
	//}
	if( !aRet.hasValue() )
		aRet = OComponentHelper::queryInterface( rType );
	return aRet;
}

// Methods XElementAccess
Type SfxLibrary_Impl::getElementType()
	throw(RuntimeException)
{
	return maNameContainer.getElementType();
}

sal_Bool SfxLibrary_Impl::hasElements()
	throw(RuntimeException)
{
	sal_Bool bRet = maNameContainer.hasElements();
	return bRet;
}

// Methods XNameAccess
Any SfxLibrary_Impl::getByName( const OUString& aName )
	throw(NoSuchElementException, WrappedTargetException, RuntimeException)
{
	Any aRetAny = maNameContainer.getByName( aName ) ;
	return aRetAny;
}

Sequence< OUString > SfxLibrary_Impl::getElementNames()
	throw(RuntimeException)
{
	return maNameContainer.getElementNames();
}

sal_Bool SfxLibrary_Impl::hasByName( const OUString& aName )
	throw(RuntimeException)
{
	sal_Bool bRet = maNameContainer.hasByName( aName );
	return bRet;
}

// Methods XNameReplace
void SfxLibrary_Impl::replaceByName( const OUString& aName, const Any& aElement )
	throw(IllegalArgumentException, NoSuchElementException, WrappedTargetException, RuntimeException)
{
	if( mbReadOnly || (mbLink && mbReadOnlyLink) )
        throw RuntimeException();

	maNameContainer.replaceByName( aName, aElement );
	mbModified = sal_True;
}


// Methods XNameContainer
void SfxLibrary_Impl::insertByName( const OUString& aName, const Any& aElement )
	throw(IllegalArgumentException, ElementExistException, WrappedTargetException, RuntimeException)
{
	if( mbReadOnly || (mbLink && mbReadOnlyLink) )
        throw RuntimeException();

	maNameContainer.insertByName( aName, aElement );
	mbModified = sal_True;
}

void SfxLibrary_Impl::removeByName( const OUString& Name )
	throw(NoSuchElementException, WrappedTargetException, RuntimeException)
{
	if( mbReadOnly || (mbLink && mbReadOnlyLink) )
        throw RuntimeException();

	maNameContainer.removeByName( Name );
	mbModified = sal_True;

    // Remove element file
	if( maStorageURL.getLength() )
	{
		INetURLObject aElementInetObj( maStorageURL );
		aElementInetObj.insertName( Name, sal_False,
			INetURLObject::LAST_SEGMENT, sal_True, INetURLObject::ENCODE_ALL );
		aElementInetObj.setExtension( maLibElementFileExtension );
		OUString aFile = aElementInetObj.GetMainURL();

		try
		{
	        if( mxSFI->exists( aFile ) )
		        mxSFI->kill( aFile );
        }
        catch( Exception& )
        {
        }
	}

}

// XTypeProvider
Sequence< Type > SfxLibrary_Impl::getTypes()
	throw( RuntimeException )
{
	static OTypeCollection * s_pTypes_NameContainer = 0;
	static OTypeCollection * s_pTypes_NameAccess = 0;
    /*
	if( mbReadOnly )
	{
		if( !s_pTypes_NameAccess )
		{
			MutexGuard aGuard( Mutex::getGlobalMutex() );
			if( !s_pTypes_NameAccess )
			{
				static OTypeCollection s_aTypes_NameAccess(
					::getCppuType( (const Reference< XNameAccess > *)0 ),
					::getCppuType( (const Reference< XContainer > *)0 ),
					OComponentHelper::getTypes() );
				s_pTypes_NameAccess = &s_aTypes_NameAccess;
			}
		}
		return s_pTypes_NameAccess->getTypes();
	}
	else
    */
	{
		if( !s_pTypes_NameContainer )
		{
			MutexGuard aGuard( Mutex::getGlobalMutex() );
			if( !s_pTypes_NameContainer )
			{
				static OTypeCollection s_aTypes_NameContainer(
					::getCppuType( (const Reference< XNameContainer > *)0 ),
					::getCppuType( (const Reference< XContainer > *)0 ),
					OComponentHelper::getTypes() );
				s_pTypes_NameContainer = &s_aTypes_NameContainer;
			}
		}
		return s_pTypes_NameContainer->getTypes();
	}
}


Sequence< sal_Int8 > SfxLibrary_Impl::getImplementationId()
	throw( RuntimeException )
{
	static OImplementationId * s_pId_NameContainer = 0;
	static OImplementationId * s_pId_NameAccess = 0;
    /*
	if( mbReadOnly )
	{
		if( !s_pId_NameAccess )
		{
			MutexGuard aGuard( Mutex::getGlobalMutex() );
			if( !s_pId_NameAccess )
			{
				static OImplementationId s_aId_NameAccess;
				s_pId_NameAccess = &s_aId_NameAccess;
			}
		}
		return s_pId_NameAccess->getImplementationId();
	}
	else
    */
	{
		if( !s_pId_NameContainer )
		{
			MutexGuard aGuard( Mutex::getGlobalMutex() );
			if( !s_pId_NameContainer )
			{
				static OImplementationId s_aId_NameContainer;
				s_pId_NameContainer = &s_aId_NameContainer;
			}
		}
		return s_pId_NameContainer->getImplementationId();
	}
}


//============================================================================

// Methods XContainer
void SAL_CALL SfxLibrary_Impl::addContainerListener( const Reference< XContainerListener >& xListener ) 
	throw (RuntimeException)
{
	maNameContainer.setEventSource( static_cast< XInterface* >( (OWeakObject*)this ) );
	maNameContainer.addContainerListener( xListener );
}

void SAL_CALL SfxLibrary_Impl::removeContainerListener( const Reference< XContainerListener >& xListener ) 
	throw (RuntimeException)
{
	maNameContainer.removeContainerListener( xListener );
}

//============================================================================

