/*************************************************************************
 *
 *  $RCSfile: accmgr.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: mba $ $Date: 2001/12/21 13:28:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "accmgr.hxx"
#include <sot/storage.hxx>

#ifndef _EVENT_HXX //autogen
#include <vcl/event.hxx>
#endif

#ifndef _COM_SUN_STAR_AWT_KEYEVENT_HPP_
#include <com/sun/star/awt/KeyEvent.hpp>
#endif

#include <tools/rcid.h>
#include <unotools/streamwrap.hxx>
#include <comphelper/processfactory.hxx>
//#include <unotools/ucbstreamhelper.hxx>
//#include <tools/urlobj.hxx>
#include <svtools/pathoptions.hxx>

//#include "mnumgr.hxx"
//#include "app.hxx"
//#include "sfxtypes.hxx"
#include "bindings.hxx"
//#include "sfxresid.hxx"
#include "macrconf.hxx"
//#include "msgpool.hxx"
#include "dispatch.hxx"
#include "accel.hrc"
#include "viewfrm.hxx"
#include "module.hxx"
#include "objface.hxx"
#include "request.hxx"
#include "accelcfg.hxx"

static const USHORT nVersion = 1;

//--------------------------------------------------------------------

SfxAcceleratorManager::SfxAcceleratorManager( SfxConfigManager* pMgr)
    : SfxConfigItem( SFX_ITEMTYPE_ACCEL, pMgr ),
	nIteratorPos(0),
	pAccel(0),
    pAccelCfg(0),
	pResMgr(0)
{
	DBG_MEMTEST();
    Initialize();
}

SfxAcceleratorManager::SfxAcceleratorManager( const ResId& rResId, SfxConfigManager* pMgr )
    : SfxConfigItem(rResId.GetId() == RID_DEFAULTACCEL ? SFX_ITEMTYPE_ACCEL : rResId.GetId(), pMgr )
    , nIteratorPos(0)
    , pAccel(0)
    , pAccelCfg(0)
    , pResMgr(rResId.GetResMgr())
{
	DBG_MEMTEST();
    Initialize();
}

SfxAcceleratorManager::SfxAcceleratorManager( const SfxAcceleratorManager& rOther, SfxConfigManager* pMgr )
    : SfxConfigItem( rOther.GetType(), pMgr )
    , nIteratorPos(0)
    , pAccel(0)
    , pAccelCfg(0)
    , pResMgr( rOther.pResMgr )
{
	DBG_MEMTEST();
    Initialize();
}

//--------------------------------------------------------------------

SfxAcceleratorManager::~SfxAcceleratorManager()
{
	DBG_MEMTEST();
	Clear();
}

void SfxAcceleratorManager::Clear()
{
	if ( pAccel )
	{
		USHORT nCount = pAccel->GetItemCount();
		for ( USHORT nPos = 0; nPos < nCount; ++nPos )
		{
			USHORT nId = pAccel->GetItemId( nPos );
			if ( SfxMacroConfig::IsMacroSlot( nId ) )
				SFX_APP()->GetMacroConfig()->ReleaseSlotId(nId);
		}

		DELETEZ( pAccel );
	}
	else
	{
        std::vector< SfxAcceleratorConfigItem>::const_iterator p;
        const SfxAcceleratorItemList& rItems = GetItems();
        for ( p = rItems.begin(); p != rItems.end(); p++ )
			if ( SfxMacroConfig::IsMacroSlot( p->nId ) )
				SFX_APP()->GetMacroConfig()->ReleaseSlotId(p->nId);
		DELETEZ( pAccelCfg );
	}
}

//====================================================================

SvStream& operator>>( SvStream &rStream, KeyCode& rVal )
{
	USHORT nCode, nMod;
	rStream >> nCode;
	rStream >> nMod;

	if( nCode == USHRT_MAX )
		// virtuelle Taste
		rVal = KeyCode( (KeyFuncType) nMod );
	else
		// normale Taste
		rVal = KeyCode ( nCode, nMod );

	return rStream;
}


//--------------------------------------------------------------------

// stream out a KeyCode

SvStream& operator<<( SvStream &rStream, const KeyCode& rVal )
{
	DBG_MEMTEST();

	if( rVal.IsFunction() )
    {
		// write virtual key code, marked as USHRT_MAX
		rStream << USHORT(USHRT_MAX) << USHORT( rVal.GetFunction() );
        DBG_ERROR("Error: Function Key detected!");
    }
	else
		// write normal key code
		rStream << USHORT( rVal.GetCode() ) << USHORT( rVal.GetModifier() );
	return rStream;
}


//====================================================================

// stores the configured accelerators to a stream

BOOL SfxAcceleratorManager::Store( SvStream& rStream )
{
	DBG_MEMTEST();
	if ( pAccel )
		Convert();

    const SfxAcceleratorItemList& rItems = GetItems();
	USHORT nCount = rItems.size();
	rStream << nVersion;
	rStream << nCount;
    std::vector< SfxAcceleratorConfigItem>::const_iterator p;
    for ( p = rItems.begin(); p != rItems.end(); p++ )
	{
        if ( p->nCode == 0 )
			rStream << p->nId << KeyCode( p->nModifier );
        else
			rStream << p->nId << KeyCode( p->nCode, p->nModifier );

		if ( SfxMacroConfig::IsMacroSlot( p->nId ) )
			rStream << *(SFX_APP()->GetMacroConfig()->GetMacroInfo(p->nId));
	}

	return TRUE;
}


//--------------------------------------------------------------------
void SfxAcceleratorManager::UseDefault()
{
	DBG_MEMTEST();

    BOOL bReconfigure = ( pAccel || pAccelCfg );
	if ( bReconfigure )
		Clear();

    ResId aId( GetType() == SFX_ITEMTYPE_ACCEL ? RID_DEFAULTACCEL : GetType(), pResMgr );
    aId.SetRT(RSC_ACCEL);

    if ( Resource::GetResManager()->IsAvailable( aId ) )
        pAccel =  new Accelerator( aId );
    else
        pAccelCfg = new SfxAcceleratorConfiguration;

    SetDefault( TRUE );
}


const SfxAcceleratorItemList& SfxAcceleratorManager::GetItems()
{
    if ( pAccel )
        Convert();

    return pAccelCfg->GetItems();
}

//--------------------------------------------------------------------

USHORT SfxAcceleratorManager::GetId( const KeyCode &rKeyCode )
{
    if ( pAccel )
        return pAccel->GetItemId( rKeyCode );
    else
    {
        sal_Int16 nCode, nModifier;
/*
        if( rKeyCode.IsFunction() )
        {
            nCode = 0;
            nModifier = rKeyCode.GetFunction();
        }
        else
*/
        {
            nCode = rKeyCode.GetCode();
            nModifier=rKeyCode.GetModifier();
        }

        const SfxAcceleratorItemList& rItems = GetItems();
        std::vector< SfxAcceleratorConfigItem>::const_iterator p;
        for ( p = rItems.begin(); p != rItems.end(); p++ )
            if ( p->nCode == nCode && p->nModifier == nModifier )
                return p->nId;
        return 0;
    }
}

//--------------------------------------------------------------------

// key code for a func-id

KeyCode SfxAcceleratorManager::GetKeyCode( USHORT nId )
{
    if ( pAccel )
        return pAccel->GetKeyCode( nId );
    else
    {
        const SfxAcceleratorItemList& rItems = GetItems();

        KeyCode aCode;
        std::vector< SfxAcceleratorConfigItem>::const_iterator p;
        for ( p = rItems.begin(); p != rItems.end(); p++ )
		{
            if ( p->nId == nId )
            {
                if ( p->nCode == 0 )
                    return KeyCode( p->nModifier );
                else
                    return KeyCode( p->nCode, p->nModifier );
            }
		}

        return KeyCode();
    }
}

//--------------------------------------------------------------------
// call this before reconfiguring
void SfxAcceleratorManager::Reset( USHORT nCount )
{
	Clear();
	pAccelCfg = new SfxAcceleratorConfiguration;
}

//--------------------------------------------------------------------

// call this after reconfiguring
void SfxAcceleratorManager::Reconfigure()
{
	SetDefault(FALSE);
}

//--------------------------------------------------------------------

// append a new binding
void SfxAcceleratorManager::AppendItem( USHORT nId, const KeyCode& rKeyCode )
{
    SfxAcceleratorConfigItem aItem;
    aItem.nId = nId;
    if ( SfxMacroConfig::IsMacroSlot( nId ) )
        aItem.aCommand = SFX_APP()->GetMacroConfig()->GetMacroInfo(nId)->GetURL();
    else
    {
        aItem.aCommand = String::CreateFromAscii("slot:");
        aItem.aCommand += String::CreateFromInt32( nId );
    }

    aItem.nCode = rKeyCode.GetCode();
    if ( !aItem.nCode )
        aItem.nModifier = rKeyCode.GetFunction();
    else
        aItem.nModifier = rKeyCode.GetModifier();
    pAccelCfg->SetCommand( aItem );
}

// ------------------------------------------------------------------------

String SfxAcceleratorManager::GetStreamName() const
{
    return SfxConfigItem::GetStreamName( GetType() );
}

BOOL SfxAcceleratorManager::Call(const KeyEvent& rEvnt, SfxBindings& rBind, BOOL bGlobal )
{
    USHORT nId = 0;
    if ( pAccel )
    {
        nId = pAccel->GetItemId( rEvnt.GetKeyCode() );
        if ( !nId )
            return FALSE;
    }
    else if ( pAccelCfg )
    {
        const SfxAcceleratorItemList& rItems = GetItems();

        sal_Int16 nCode, nModifier;
        const KeyCode& rKeyCode = rEvnt.GetKeyCode();
/*
        if( rKeyCode.IsFunction() )
        {
            nCode = USHORT(USHRT_MAX);
            nModifier = rKeyCode.GetFunction();
        }
        else
 */
        {
            nCode=rKeyCode.GetCode();
            nModifier=rKeyCode.GetModifier();
        }

        std::vector< SfxAcceleratorConfigItem>::const_iterator p;
        for ( p = rItems.begin(); p != rItems.end(); p++ )
            if ( p->nCode == nCode && p->nModifier == nModifier )
            {
                nId = p->nId;
                if ( p->aCommand.getLength() && ( p->aCommand.compareToAscii( "slot:", 5 ) != 0 ) )
                    return rBind.ExecuteCommand_Impl( p->aCommand );
                break;
            }
    }

    //(mba/task): Hier muss abgefragt werden, ob denn gerade am aktuellen Document der Bindings Modalitt gegeben ist!
	{
		if ( bGlobal )
		{
			SfxApplication *pApp = SFX_APP();
            SfxDispatcher* pDispatcher = rBind.GetDispatcher();
			const SfxSlot *pSlot=0;
			SfxShell* pShell = pApp->GetActiveModule();
            if ( !( pSlot = pShell->GetInterface()->GetSlot( nId ) ) )
            {
                pShell = pDispatcher->GetFrame();
                if ( !( pSlot = pShell->GetInterface()->GetSlot( nId ) ) )
                {
                    pShell = pApp;
                    if ( !( pSlot = pShell->GetInterface()->GetSlot( nId ) ) )
                        return FALSE;
                }
            }

			SfxItemPool &rPool = pShell->GetPool();
			BOOL bAsynchron = ( pSlot->GetMode() & SFX_SLOT_ASYNCHRON ) || !( pSlot->GetMode() & SFX_SLOT_SYNCHRON );
			SfxRequest aReq( nId, SFX_CALLMODE_SLOT, rPool );
			pShell->ExecuteSlot( aReq, bAsynchron );
			return TRUE;
		}
		else
		{
			// wegen OLE-InPlace und Container-KeyInput (SV liefert TRUE!)
            return rBind.Execute( nId );
		}
	}

	return FALSE;
}

int SfxAcceleratorManager::Load( SotStorage& rStorage )
{
    SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxAcceleratorManager::GetStreamName(), STREAM_STD_READ );
    if ( xStream->GetError() )
        return ERR_READ;
    else
    {
    	BOOL bReconfigure = ( pAccel || pAccelCfg );
		if ( bReconfigure )
			Clear();

        pAccelCfg = new SfxAcceleratorConfiguration();
        if ( pAccelCfg->Load( *xStream ) )
        {
            SfxAcceleratorItemList& rItems = (SfxAcceleratorItemList&) GetItems();
            std::vector< SfxAcceleratorConfigItem>::iterator p;
            for ( p = rItems.begin(); p != rItems.end(); )
            {
                if ( p->aCommand.compareToAscii( "slot:", 5 ) == 0 )
                {
                    p->nId = (USHORT) p->aCommand.copy( 5 ).toInt32();
                    if ( SfxMacroConfig::IsMacroSlot( p->nId ) )
                        // wrong configuration
                        rItems.erase(p);
                    else
                        p++;
                }
                else
                {
                    SfxMacroInfo aInfo( p->aCommand );
                    SFX_APP()->GetMacroConfig()->GetSlotId( &aInfo );
                    p->nId = aInfo.GetSlotId();
                    p++;
                }
            }
        }
		else
        	return ERR_READ;
    }

	SetDefault( FALSE );
	return ERR_OK;
}

BOOL SfxAcceleratorManager::Store( SotStorage& rStorage )
{
    if ( pAccel )
        Convert();

    SotStorageStreamRef xStream = rStorage.OpenSotStream( SfxAcceleratorManager::GetStreamName(), STREAM_STD_READWRITE|STREAM_TRUNC );
    if ( xStream->GetError() )
        return FALSE;
    else
        return pAccelCfg->Commit( *xStream );
}

void SfxAcceleratorManager::Convert()
{
    DBG_ASSERT( pAccel && !pAccelCfg, "Wrong state of accelerator manager!" );
    if ( pAccel )
    {
        String aSlot = String::CreateFromAscii("slot:");
        USHORT nCount = pAccel->GetItemCount();
        SfxAcceleratorItemList aList;
        for ( USHORT nPos = 0; nPos < nCount; ++nPos )
        {
            USHORT nId = pAccel->GetItemId( nPos );
            KeyCode aKey = pAccel->GetItemKeyCode( nPos );

            SfxAcceleratorConfigItem aItem;
            aItem.nId = nId;
            if( aKey.IsFunction() )
            {
                DBG_ERROR("Error: Function Key detected!");
                aItem.nCode = 0;
                aItem.nModifier = aKey.GetFunction();
            }
            else
            {
                aItem.nCode = aKey.GetCode();
                aItem.nModifier = aKey.GetModifier();
            }

            if ( SfxMacroConfig::IsMacroSlot( nId ) )
                aItem.aCommand = SFX_APP()->GetMacroConfig()->GetMacroInfo(nId)->GetURL();
            else
            {
                aItem.aCommand = aSlot;
                aItem.aCommand += String::CreateFromInt32( nId );
            }

            aList.push_back( aItem );
        }

        pAccelCfg = new SfxAcceleratorConfiguration;
        pAccelCfg->SetItems( aList, true );
        DELETEZ( pAccel );
    }
}

//--------------------------------------------------------------------
int SfxAcceleratorManager::Load(SvStream& rStream)
{
	DBG_MEMTEST();

	BOOL bReconfigure = ( pAccel || pAccelCfg );
	if ( bReconfigure )
		Clear();

    pAccelCfg = new SfxAcceleratorConfiguration;

	USHORT nCount, nFileVersion;
	rStream >> nFileVersion;
	if(nFileVersion != nVersion)
		return SfxConfigItem::WARNING_VERSION;

	rStream >> nCount;
    SfxAcceleratorItemList aList;
    String aSlot = String::CreateFromAscii("slot:");
	for ( USHORT nPos = 0; nPos<nCount; ++nPos )
	{
        SfxAcceleratorConfigItem aItem;
		KeyCode aKey;
		rStream >> aItem.nId >> aKey;

		if ( SfxMacroConfig::IsMacroSlot( aItem.nId ) )
		{
			SfxMacroInfo aInfo;
			rStream >> aInfo;
//            aItem.nId = aInfo.GetSlotId();
            aItem.nId = 0;
            aItem.aCommand = aInfo.GetURL();
		}
		else
        {
            aItem.aCommand = aSlot;
            aItem.aCommand += String::CreateFromInt32( aItem.nId );
        }

        if( aKey.IsFunction() )
        {
            DBG_ERROR("Error: Function Key detected!");
            aItem.nCode = 0;
            aItem.nModifier = aKey.GetFunction();
        }
        else
        {
            aItem.nCode = aKey.GetCode();
            aItem.nModifier = aKey.GetModifier();
        }

        aList.push_back( aItem );
	}

    pAccelCfg->SetItems( aList, true );
	return SfxConfigItem::ERR_OK;
}

