/*************************************************************************
 *
 *  $RCSfile: winos.cxx,v $
 *
 *  $Revision: 1.24.6.1.2.2 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 11:08:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <tools/prewin.h>
#ifndef _SHOBJ_H
#include <shlobj.h>
#endif
#include <tools/postwin.h>

#ifndef _SV_APP_HXX_
#include <vcl/svapp.hxx>
#endif

#ifndef NOOLDSV
#include <vcl/system.hxx>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _STREAM_HXX
#include <tools/stream.hxx>
#endif

#include <tools/l2txtenc.hxx>

#include <svunzip.h>

#include "os.hxx"

#include <regstr.h>
#include <imagehlp.h>

#include <error.hrc>

#include <systools/win32/shell9x.h>
#include <systools/win32/advapi9x.h>

// --------------------------------------------------------------
// macro that calculates the count of elements of a static array

#define elementsof(buf)	(sizeof(buf) / sizeof((buf)[0]))

// --------------------------------------------------------------

#ifdef __cplusplus
extern "C" {
#endif

DWORD WINAPI SETUP_WIN_SHGetValue(
	HKEY	hKey,
	LPCTSTR	pszSubKey,
	LPCTSTR	pszValue,
	LPDWORD	pdwType,
	LPVOID	pvData,
	LPDWORD	pcbData
	)
{
	HKEY	hSubKey;
	DWORD	dwError;

	dwError = RegOpenKeyA( hKey, pszSubKey, &hSubKey );

	if ( ERROR_SUCCESS == dwError )
	{
		dwError = RegQueryValueExA( hSubKey, pszValue, 0, pdwType, (LPBYTE)pvData, pcbData );
		RegCloseKey( hSubKey );
	}

	return dwError;
}

#ifdef __cplusplus
}
#endif

// --------------------------------------------------------------

USHORT __GetGUIVersion()
{
	WORD  nGUIVersion = (WORD) GetVersion();
	USHORT nVer = ((((USHORT)LOBYTE(nGUIVersion))*100)+HIBYTE(nGUIVersion));
	return nVer;
}

// --------------------------------------------------------------

const char* OS::GetAllFilesWildCard()
{
	return "*";
}

ByteString OS::GetGUIPath()
{
	char s[MAX_PATH];

	GetWindowsDirectory(s,MAX_PATH);
	return s;
}

ByteString OS::GetSystemPath()
{
	char s[MAX_PATH];

	GetSystemDirectory(s,MAX_PATH);
	return s;
}

ByteString OS::GetSystemFontPath()
{
	SiDirEntry aFontDir;
	if( __GetGUIVersion() >= 400 )
	{
		aFontDir  =	GetGUIPath();
		aFontDir += ByteString("Fonts");
	}
	else
		aFontDir = GetSystemPath();
	return aFontDir.GetFull();
}

ULONG OS::GetDriveSize(SiDirEntry const& aSiDirEntry)
{
	ULONG nSize = 0;
	SiDirEntry aTmp( aSiDirEntry );
	aTmp.ToAbs();

	USHORT nDrive = (aTmp.GetFull().ToUpperAscii().GetChar(0)) - 'A';
	nSize = OS::GetFreeDriveSize( nDrive );

	// dec freesize if system drive
	if( tolower(aTmp.GetFull().GetChar(0)) == tolower(OS::GetSystemPath().GetChar(0)) &&
		nSize >= 1024 )
		nSize -= 1024;

	// LLA: security, 512KB more.
	nSize -= 512;

	return nSize;
}

ULONG OS::GetFreeDriveSize(USHORT nDrive)
{
	ULONG nFreeSize = 0;

	// win32
	char cDrive[4];
	cDrive[0] = 'A' + nDrive;
	strcpy( cDrive+1, ":\\" );

	HINSTANCE hModule;
	hModule = LoadLibrary("kernel32.dll");
	if( !(hModule <= (HINSTANCE)HINSTANCE_ERROR) )
	{
		typedef BOOL (WINAPI *WIN_GETDISKFREESPACE_EX) (
				LPCTSTR strDirName,
				PULARGE_INTEGER lpFreeCaller,
				PULARGE_INTEGER lpTotal,
				PULARGE_INTEGER lpTotalFree );

		WIN_GETDISKFREESPACE_EX fnc_GetDiskFreeSpaceEx =
				(WIN_GETDISKFREESPACE_EX) GetProcAddress(hModule, "GetDiskFreeSpaceExA");

		if( fnc_GetDiskFreeSpaceEx )
		{
			ULARGE_INTEGER nFreeCaller;
			ULARGE_INTEGER nTotal;
			ULARGE_INTEGER nTotalFree;

			if( fnc_GetDiskFreeSpaceEx((LPCTSTR)cDrive, &nFreeCaller, &nTotal, &nTotalFree) )
				nFreeSize = (ULONG) (nFreeCaller.QuadPart / 1024);
		}
	}

	if( !nFreeSize )
	{
		DWORD nSectorsPerCluster;
		DWORD nBytesPerSector;
		DWORD nFreeClusters;
		DWORD nClusters;

		GetDiskFreeSpace( (LPCTSTR)cDrive, &nSectorsPerCluster, &nBytesPerSector,
			&nFreeClusters, &nClusters );

		nFreeSize  = nFreeClusters;
		nFreeSize *= nBytesPerSector;
		nFreeSize /= 1024;
		nFreeSize *= nSectorsPerCluster;
	}

	return nFreeSize;
}

ULONG OS::GetClusterSize(SiDirEntry const& aSiDirEntry)
{
	ULONG nSize = 0;
	SiDirEntry aTmp( aSiDirEntry );
	aTmp.ToAbs();

	USHORT nDrive = (aTmp.GetFull().ToUpperAscii().GetChar(0)) - 'A';

	char cDrive[4];
	cDrive[0] = 'A' + nDrive;
	strcpy( cDrive+1, ":\\" );
	DWORD nSectorsPerCluster;
	DWORD nBytesPerSector;
	DWORD nFreeClusters;
	DWORD nClusters;

	GetDiskFreeSpace( (LPCTSTR)cDrive, &nSectorsPerCluster, &nBytesPerSector,
		&nFreeClusters, &nClusters );

	ULONG nReturn = nBytesPerSector * nSectorsPerCluster;
	if( nReturn > 65536 )
		nReturn = 32768;
	
    return nReturn;
}

void OS::SetDateTime
(
	ByteString const& rFilename,
	Date   const& rDate,
	Time   const& rTime
)
{
	unsigned date = 0;
	unsigned time = 0;
	Date     aNewDate = rDate;
	Time     aNewTime = rTime;

	TIME_ZONE_INFORMATION aTZI;
	DWORD                 dwTZI = GetTimeZoneInformation(&aTZI);

	if (dwTZI != DWORD(-1)
	&&  dwTZI != TIME_ZONE_ID_UNKNOWN)
	{
		// 1. Korrektur der Zeitzone
		short nDiff    = short(aTZI.Bias);
		Time  aOldTime = aNewTime; // alte Zeit merken

		// 2. evt. Korrektur Sommer-/Winterzeit
		if (dwTZI == TIME_ZONE_ID_DAYLIGHT)
			nDiff += short(aTZI.DaylightBias);

		Time aDiff(abs(nDiff/60 /* Min -> Std */), 0);

		if (nDiff > 0)
		{
			aNewTime += aDiff;		  // Stundenkorrektur

			// bei Ueberlauf korrigieren
			//
			if (aNewTime >= Time(24,0))
				aNewTime -= Time(24,0);

			// Tagesueberlauf ?
			//
			if (aOldTime == Time(0,0) // 00:00 -> 01:00
			||  aNewTime <  aOldTime) // 23:00 -> 00:00 | 01:00 ...
				aNewDate++;
		}
		else if (nDiff < 0)
		{
			aNewTime -= aDiff;		  // Stundenkorrektur

			// negative Zeit (-1:00) korrigieren: 23:00
			//
			if (aNewTime < Time(0,0))
				aNewTime += Time (24,0);

			// Tagesunterlauf ?
			//
			if (aOldTime == Time(0,0) // 00:00 -> 23:00
			||  aNewTime >  aOldTime) // 01:00 -> 23:00 | 22:00 ...
				aNewDate--;
		}
	}

	date  = (unsigned) aNewDate.GetDay();
	date |= (unsigned)(aNewDate.GetMonth() << 5);
	date |= (unsigned)((aNewDate.GetYear() -  1980) << 9);
	time  = (unsigned)(aNewTime.GetMin() << 5);
	time |= (unsigned)(aNewTime.GetHour() << 11);

	HANDLE hFile = CreateFile( rFilename.GetBuffer(),
		GENERIC_WRITE, 0, 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0 );

	if (hFile != INVALID_HANDLE_VALUE)
	{
		FILETIME aFileTime;
		DosDateTimeToFileTime( date, time, &aFileTime );
		SetFileTime( hFile, &aFileTime, &aFileTime, &aFileTime );
		CloseHandle( hFile );
	}
}

BOOL OS::MakeWritable(ByteString const& rFile)
{
	DWORD nAttr = GetFileAttributes( rFile.GetBuffer() );

	if ( 0xFFFFFFFF != nAttr )
	{
		nAttr &= ~FILE_ATTRIBUTE_READONLY;
		return SetFileAttributes( rFile.GetBuffer(), nAttr );
	}

	return FALSE;
}

BOOL OS::InstallFont( ByteString const& rFontFile, ByteString const& rFontName )
{
	SiDirEntry aTTF_File( GetSystemFontPath() );
	aTTF_File += rFontFile;

	if( !aTTF_File.Exists() )
		return FALSE;

	SiDirEntry aFOT_File( aTTF_File );
    aFOT_File.SetExtension( UniString::CreateFromAscii( "fot" ) );

    if ( aFOT_File.Exists() )
    	aFOT_File.Kill();

    BOOL bRet;

    bRet = AddFontResource( aTTF_File.GetFull().GetBuffer() );

    if ( !bRet )
        return FALSE;

    ByteString aFontRegistryName( rFontName );

    aFontRegistryName.SearchAndReplace( "BoldItalic", "Bold Italic" );
	aFontRegistryName += " (TrueType)";

	ByteString aFontFileName( aTTF_File.GetName() );
	aFontFileName.ToUpperAscii();

	ByteString aRegPath;
	ByteString aOS = WinOS::GetOSVersion();
	if( aOS == "NT35" || aOS == "NT4" || aOS == "NT5" || aOS == "NT51" )
		aRegPath = "Software\\Microsoft\\Windows NT\\CurrentVersion\\Fonts\\";
	else
		aRegPath = "Software\\Microsoft\\Windows\\CurrentVersion\\Fonts\\";

	WinOS::Register("HKEY_LOCAL_MACHINE", aRegPath, aFontRegistryName, aFontFileName, FALSE );

	::PostMessage( HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
	return TRUE;
}

BOOL OS::UnInstallFont(ByteString const& rFontFile, ByteString const& rFontName)
{
	BOOL bSuccess;
    SiDirEntry aTTF_File  = GetSystemFontPath();
		       aTTF_File += rFontFile;
    SiDirEntry aFOT_File( aTTF_File );
    aFOT_File.SetExtension( UniString::CreateFromAscii( "fot" ) );

    bSuccess = RemoveFontResource( aTTF_File.GetFull().GetBuffer() );

    if ( !bSuccess )
        bSuccess = RemoveFontResource( aFOT_File.GetFull().GetBuffer() );

    ::PostMessage( HWND_BROADCAST, WM_FONTCHANGE, 0, 0);

    aTTF_File.Kill();						// *.ttf
	aFOT_File.Kill();						// *.fot

	return bSuccess;
#if 0
	if( __GetGUIVersion() >= 400 )
	{
		SiDirEntry aFontPath  = GetSystemFontPath();
		           aFontPath += rFontFile;

		BOOL bSuccess = RemoveFontResource( aFontPath.GetFull().GetBuffer() );
		::PostMessage(HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
		aFontPath.Kill();

        aFontPath.SetExtension( UniString::CreateFromAscii( "fot" ) );
		aFontPath.Kill();

		return bSuccess;
	}
	else
	{
        ByteString aFontFileName, aFontKey, aTmp;
		SiDirEntry aFontPath;

		aTmp = rFontFile;

		// create font *.fot filename
		aFontFileName  = aTmp.Erase( 0, aTmp.Search( '.' ) + 1 );
		aFontFileName += "FOT";

		// create font *.fot pathname
		aFontPath  = GetSystemFontPath();
		aFontPath += SiDirEntry( aFontFileName );
		ByteString aFontPathName = aFontPath.GetFull();

		// create win.ini profile key
		aFontKey  = rFontName;
		aFontKey += " (TrueType)";

		// remove font
		BOOL bSuccess = RemoveFontResource( aFontPathName.GetBuffer() );
		aFontPath.Kill();						// *.fot
		aFontPath.SetName( UniString::CreateFromAscii(rFontFile.GetBuffer()) );
		aFontPath.Kill();						// *.ttf
		WriteProfileString( "fonts", aFontKey.GetBuffer(), 0 );
		::PostMessage( HWND_BROADCAST, WM_FONTCHANGE, 0, 0);
		return bSuccess;
	}
#endif
}

#if 0
int CALLBACK EnumFontFamProc( CONST ENUMLOGFONT *lpelf,    // logical-font data
                              CONST NEWTEXTMETRIC *lpntm,  // physical-font data
                              DWORD FontType,        // type of font
                              LPARAM lParam          // application-defined data
                             )
{
    *((BOOL*)lParam) = TRUE;
    return 0;
}
#endif

BOOL OS::IsFontInstalled( ByteString const& rFontFile, ByteString const& rFontName )
{
#if 0
    BOOL    bIsInstalled = FALSE;
    HDC     hDC = GetDC( NULL );

    EnumFontFamilies( hDC, rFontName.GetBuffer(), (FONTENUMPROC) EnumFontFamProc, (long) &bIsInstalled );

    ReleaseDC( NULL, hDC );

    return bIsInstalled;
#endif

    SiDirEntry  aFont(GetSystemFontPath());
			  aFont += rFontFile;

	return aFont.Exists();
}

BOOL OS::IsConfigurationValid(Window* pParent)
{
	BOOL b386 = FALSE;
	b386 = TRUE;

	WORD  nGUIVersion = (WORD) GetVersion();
	if( ((((USHORT)LOBYTE(nGUIVersion))*100)+HIBYTE(nGUIVersion)) < 310 )
	{
		UniString aMsg(ResId(ERR_CONFIG_VER));
		WarningBox( pParent, WB_OK, aMsg ).Execute();
	}

	if (b386 && WinOS::GetFreeMemory() < 2500)
		return FALSE;

	return TRUE;
}

ByteString OS::GetIEPluginDir( BOOL bPlugin )
{
	HKEY hKey;
	TCHAR arCurrent[MAX_PATH];
	DWORD dwType, dwCurrentSize = sizeof(arCurrent);
	ByteString aDir;

	if( ::RegOpenKeyEx(HKEY_LOCAL_MACHINE, "Software\\Microsoft\\IE4\\SETUP", 0, KEY_READ, &hKey) == ERROR_SUCCESS )
	{
		if( ::RegQueryValueEx( hKey, "Path", NULL, &dwType, (LPBYTE)arCurrent, &dwCurrentSize ) == ERROR_SUCCESS )
		{
			if( bPlugin )
				strcat( arCurrent, "\\Plugins" );

			if( strncmp(arCurrent, "%programfiles%", 14) == 0 )
			{
				aDir =  getenv( "programfiles" );
				aDir += &(arCurrent[14]);
			}
			else
				aDir = arCurrent;
		}
		::RegCloseKey( hKey );
	}
	return aDir;
}

ByteString OS::GetIEDir()
{
	return GetIEPluginDir( FALSE );
}

ByteString _GetNetscapeDirs( const char* path, const char* dir)
{
	HKEY hKey1, hKey2;
	TCHAR arCurrent[MAX_PATH];
	DWORD dwType, dwCurrentSize = sizeof(arCurrent);
	ByteString aDir;

	if (::RegOpenKeyEx( HKEY_LOCAL_MACHINE, path,
						0, KEY_READ, &hKey1 ) == ERROR_SUCCESS)
	{
		if (::RegQueryValueEx( hKey1, "CurrentVersion", NULL, &dwType,
							   (LPBYTE)arCurrent, &dwCurrentSize ) == ERROR_SUCCESS &&
			(dwType == REG_SZ) &&
			::RegOpenKeyEx( hKey1, strcat( arCurrent, "\\Main" ),
							0, KEY_READ, &hKey2 ) == ERROR_SUCCESS)
		{
			dwCurrentSize = sizeof(arCurrent);
			if (::RegQueryValueEx( hKey2, dir, NULL, &dwType,
								   (LPBYTE)arCurrent, &dwCurrentSize ) == ERROR_SUCCESS &&
				(dwType == REG_SZ))
			{
				aDir = arCurrent;
			}
			::RegCloseKey( hKey2 );
		}
		::RegCloseKey( hKey1 );
	}
	return aDir;
}

ByteString OS::GetNSPluginDir()
{
	ByteString aDir = _GetNetscapeDirs( "Software\\Netscape\\Netscape Navigator", "Plugins Directory" );
	return aDir;
}

ByteString OS::GetNS6PluginDir()
{
	ByteString aDir = _GetNetscapeDirs( "Software\\Netscape\\Netscape 6", "Install Directory" );
	if( aDir.Len() )
		aDir += "Plugins";
	return aDir;
}

// class WinOS -----------------------------------------------------------
//
// Hier stehen alle Funktionen, die es nur in Windows (3.x/95/NT) gibt.

ByteString WinOS::GetOSVersion()
{
	ByteString aOS( "ERROR" );
	WORD  nGUIVersion = (WORD) GetVersion();
	USHORT nVer = ((((USHORT)LOBYTE(nGUIVersion))*100)+HIBYTE(nGUIVersion));

	if( nVer == 351 )
	{
		aOS = "NT35";
		return aOS;		                // die Sache ist klar!
	}
	else
	if( nVer == 400 || nVer == 395 )    // win95 || w16 unter win95
		aOS = "W95";
	else
	if( nVer == 410 )
		aOS = "W98";

	OSVERSIONINFO aVerInfo;
	aVerInfo.dwOSVersionInfoSize = sizeof( aVerInfo );
	if ( GetVersionEx( &aVerInfo ) )
	{
		if ( aVerInfo.dwPlatformId == VER_PLATFORM_WIN32_NT )
			if( aVerInfo.dwBuildNumber >= 2600 )
				aOS = "NT51";
			else if( aVerInfo.dwBuildNumber >= 1382 )
				aOS = "NT5";
			else
				aOS = "NT4";
	}

    return aOS;
}

BOOL WinOS::IsNT()
{
    WORD nGUIVersion = (WORD) GetVersion();
    USHORT nVer = ((((USHORT)LOBYTE(nGUIVersion))*100)+HIBYTE(nGUIVersion));

    if( nVer == 351 )
        return TRUE;

    OSVERSIONINFO aVerInfo;
    aVerInfo.dwOSVersionInfoSize = sizeof( aVerInfo );

    if ( GetVersionEx( &aVerInfo ) &&
         ( aVerInfo.dwPlatformId == VER_PLATFORM_WIN32_NT ) )
         return TRUE;

    return FALSE;
}

UINT32 WinOS::GetFreeMemory()
{
#ifndef WNT
	MEMMANINFO aMemInfo;
	memset( &aMemInfo, 0, sizeof( aMemInfo ) );
	aMemInfo.dwSize = sizeof( aMemInfo );
	MemManInfo( &aMemInfo );
	return ( ( aMemInfo.wPageSize * aMemInfo.dwTotalPages ) / 1024 );
#else
	//! noch ist unbekannt, wie man das machen kann
	return 16000L; /* KB */
#endif
}

HDDEDATA CALLBACK DdeCallback( UINT, UINT, HCONV, HSZ, HSZ, HDDEDATA, DWORD, DWORD )
{
	return (HDDEDATA)0;
}


BOOL WinOS::ExecDDECommand(ByteString const& aReceiver, ByteString const& aCommand)
{
	DWORD   dwInstance = 0;
	FARPROC lpDdeProc  = 0;
	BOOL    bSuccess   = FALSE;

	if (!DdeInitialize((LPDWORD)&dwInstance, (PFNCALLBACK)DdeCallback,
		   APPCMD_CLIENTONLY | CBF_FAIL_ALLSVRXACTIONS | CBF_SKIP_ALLNOTIFICATIONS, 0))
	{
		char* pRBuf = new char[aReceiver.Len()+1];
		memset(pRBuf, 0, aReceiver.Len()+1);
		strcpy(pRBuf, aReceiver.GetBuffer());

		HSZ   hszTopic1 = DdeCreateStringHandle(dwInstance, (const char*)pRBuf, CP_WINANSI);
		HSZ   hszTopic2 = DdeCreateStringHandle(dwInstance, (const char*)pRBuf, CP_WINANSI);

		HCONV hConversation;

		if ( hConversation = DdeConnect( dwInstance, hszTopic1, hszTopic2, 0 ) )
		{
			char* pCBuf = new char[aCommand.Len()+1];
			memset(pCBuf, 0, aCommand.Len()+1);
			strcpy(pCBuf, aCommand.GetBuffer());

			HDDEDATA ddeData = DdeClientTransaction( (LPBYTE)(const char*)pCBuf,
							(DWORD)( aCommand.Len() + 1 ), hConversation,
							0, 0, XTYP_EXECUTE, 3000, 0 );

			// ddeData war manchmal null, obwohl es funktioniert hat ...
			bSuccess = TRUE; // ddeData != NULL;
			DdeDisconnect( hConversation );

			delete pCBuf;
		}

		DdeUninitialize( dwInstance );
		delete pRBuf;
	}

	return bSuccess;
}

//////////////////////////////////////////////////////////////////////////

void WinOS::registerActiveX( const ByteString& rPath, BOOL bregister )
{
	if(FAILED(OleInitialize(NULL)))
		return; //@todo?: report error
	HINSTANCE hModule = LoadLibrary((LPCTSTR)rPath.GetBuffer());
	if( !(hModule <= (HINSTANCE)HINSTANCE_ERROR) )
	{
		FARPROC lpfnDLLProc = GetProcAddress(hModule, bregister
							  ? "DllRegisterServer" : "DllUnregisterServer");
		if(lpfnDLLProc!=NULL)
			(*lpfnDLLProc)();
		//@todo?: else report error
		FreeLibrary(hModule);
	}
	//@todo?: else report error
	OleUninitialize();
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

/*
 *
 *		new Shell Interfaces
 *
 */

void _SHFree( void *pv )
{
	IMalloc	*pMalloc;
	if( NOERROR == SHGetMalloc(&pMalloc) )
	{
		pMalloc->Free( pv );
		pMalloc->Release();
	}
}

#define ALLOC(type, n) ((type *) HeapAlloc(GetProcessHeap(), 0, sizeof(type) * n ))
#define FREE(p) HeapFree(GetProcessHeap(), 0, p)

UniString _SHGetSpecialFolder( int nFolderID )
{

	LPITEMIDLIST	pidl;
	HRESULT			hHdl = SHGetSpecialFolderLocation( NULL, nFolderID, &pidl );
	UniString		aFolder;

	if( hHdl == NOERROR )
	{
		WCHAR *lpFolderA;
		lpFolderA = ALLOC( WCHAR, 16000 );

		SHGetPathFromIDListW( pidl, lpFolderA );
		aFolder = UniString( lpFolderA );

		FREE( lpFolderA );
		_SHFree( pidl );
	}
	return aFolder;
}

#define _CSIDL_PROGRAM_FILES			0x26
#define _CSIDL_PROGRAM_FILES_COMMON		0x2b

UniString WinOS::SHGetUserProgramFilesFolder()
{
	UniString aRet = _SHGetSpecialFolder(_CSIDL_PROGRAM_FILES);
	if( !aRet.Len() )
		aRet = UniString( GetRegValue("HKEY_LOCAL_MACHINE",
						  "SOFTWARE\\Microsoft\\Windows\\CurrentVersion",
						  "ProgramFilesDir"), osl_getThreadTextEncoding() );
	return aRet;
}

UniString WinOS::SHGetUserProgramFolder()
{
	return _SHGetSpecialFolder(CSIDL_PROGRAMS);
}

UniString WinOS::SHGetFavoritesFolderName()
{
	return _SHGetSpecialFolder(CSIDL_FAVORITES);
}

UniString WinOS::SHGetPersonalFolderName()
{
	UniString aRet = _SHGetSpecialFolder(CSIDL_PERSONAL);

    if ( !aRet.Len() )
        aRet = UniString::CreateFromAscii( "C:\\My Documents" );

	DirEntry aEntry( aRet );
	if( !aEntry.Exists() )
        aEntry.MakeDir();

    return aRet;
}

UniString WinOS::SHGetTemplateFolderName()
{
	return _SHGetSpecialFolder(CSIDL_TEMPLATES);
}

UniString WinOS::SHGetSystemDesktopFolderName()
{
	return _SHGetSpecialFolder(CSIDL_DESKTOPDIRECTORY);
}

UniString WinOS::SHGetAutostartFolderName()
{
	return _SHGetSpecialFolder(CSIDL_STARTUP);
}

static HRESULT WINAPI SHCoCreateInstance( LPVOID lpszReserved, REFCLSID clsid, LPUNKNOWN pUnkUnknown, REFIID iid, LPVOID *ppv )
{
	HRESULT	hResult = E_NOTIMPL;
	HMODULE	hModShell = GetModuleHandle( "SHELL32" );

	if ( hModShell != NULL )
	{
		typedef	HRESULT (WINAPI *SHCoCreateInstance_PROC)( LPVOID lpszReserved, REFCLSID clsid, LPUNKNOWN pUnkUnknwon, REFIID iid, LPVOID *ppv );

		SHCoCreateInstance_PROC	lpfnSHCoCreateInstance = (SHCoCreateInstance_PROC)GetProcAddress( hModShell, MAKEINTRESOURCE(102) );

		if ( lpfnSHCoCreateInstance )
			hResult = lpfnSHCoCreateInstance( lpszReserved, clsid, pUnkUnknown, iid, ppv );
	}
	return hResult;
}

BOOL WinOS::CreateShortcut( const UniString& rAbsObject, const UniString& rAbsObjectPath,
	const UniString& rAbsShortcut, const UniString& rDescription, const UniString& rParameter )
{
	HRESULT hres;
	IShellLink* psl;
	CLSID clsid_ShellLink = CLSID_ShellLink;
	CLSID clsid_IShellLink = IID_IShellLink;

	hres = CoCreateInstance( clsid_ShellLink, NULL, CLSCTX_INPROC_SERVER,
							 clsid_IShellLink, (void**)&psl );
	if( FAILED(hres) )
		hres = SHCoCreateInstance( NULL, clsid_ShellLink, NULL, clsid_IShellLink, (void**)&psl );

	if( SUCCEEDED(hres) )
	{
		IPersistFile* ppf;
		psl->SetPath( ByteString(rAbsObject, osl_getThreadTextEncoding()).GetBuffer() );
		psl->SetWorkingDirectory( ByteString(rAbsObjectPath, osl_getThreadTextEncoding()).GetBuffer() );
		psl->SetDescription( ByteString(rDescription, osl_getThreadTextEncoding()).GetBuffer() );
		if( rParameter.Len() )
			psl->SetArguments(ByteString(rParameter, osl_getThreadTextEncoding()).GetBuffer());

		CLSID clsid_IPersistFile = IID_IPersistFile;
		hres = psl->QueryInterface( clsid_IPersistFile, (void**)&ppf );

		if( SUCCEEDED(hres) )
		{
			hres = ppf->Save( rAbsShortcut.GetBuffer(), TRUE );
			ppf->Release();
		} else return FALSE;
		psl->Release();
	} else return FALSE;
	return TRUE;
 }

BOOL WinOS::SHDoShowExtension()
{
	DWORD	dwHideFileExt	= 0;
	DWORD	dwType			= REG_DWORD;
	DWORD	dwSize			= sizeof(DWORD);

	// Win98/NT5; Win95/NT4 with IE4-Shell
	if( ERROR_SUCCESS == SETUP_WIN_SHGetValue( HKEY_CURRENT_USER,
		"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Advanced",
		"HideFileExt", &dwType, (LPVOID)&dwHideFileExt, &dwSize) ||
		REG_DWORD != dwType )
	{
		if( dwHideFileExt == 0 )
			return TRUE;
		else
			return FALSE;
	}

	// native Win95/NT
	BYTE	aShellState[0x10];
	dwType	= REG_BINARY;
	dwSize	= sizeof(aShellState);

	if( ERROR_SUCCESS == SETUP_WIN_SHGetValue( HKEY_CURRENT_USER,
		"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer",
		"ShellState", &dwType, aShellState, &dwSize ) || REG_BINARY != dwType )
	{
		if( aShellState[4] & 0x02 )
			return TRUE;
		else
			return FALSE;
	}

	// bei Fehler immer anzeigen!
	return TRUE;
}


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

HKEY StringToHKEY (ByteString const& rKey)
{
	ByteString aKey( rKey );
	if ( aKey.ToUpperAscii() == "HKEY_CLASSES_ROOT" )
		return HKEY_CLASSES_ROOT;
	else if ( aKey.ToUpperAscii() == "HKEY_CURRENT_USER" )
		return HKEY_CURRENT_USER;
	else if ( aKey.ToUpperAscii() == "HKEY_LOCAL_MACHINE" )
		return HKEY_LOCAL_MACHINE;
	else if ( aKey.ToUpperAscii() == "HKEY_USERS" )
		return HKEY_USERS;
	else
		return HKEY_CLASSES_ROOT;
}

DWORD HexByteStringToDWORD(ByteString const& rValue)
{
	DWORD lValue = 0;

	for (USHORT i=0; i<rValue.Len(); i++)
	{
		char aDigit = toupper( rValue.GetChar(i) );

		if (aDigit >= '0'
		&&  aDigit <= '9')
			lValue += aDigit-'0';
		else
		{
			if (aDigit >= 'A'
			&&  aDigit <= 'F')
				lValue += 10 + (aDigit-'A');
			else
				return 0; // ungueltiges Zeichen
		}

		if (i<rValue.Len()-1)
			lValue *= 16;
	}

	return lValue;
}

long WinOS::Register(ByteString const& rKey, ByteString const& rSubKey,
					 ByteString const& rName, ByteString const& rVal, BOOL bHex, BOOL bExpand_SZ )
{
    UniString aSubKey( rSubKey, osl_getThreadTextEncoding() );
    UniString aName( rName, osl_getThreadTextEncoding() );
    UniString aVal( rVal, osl_getThreadTextEncoding() );

    return WinOS::Register( rKey, aSubKey, aName, aVal, bHex, bExpand_SZ );
}

long WinOS::Register(ByteString const& rKey, UniString const& rSubKey,
					 UniString const& rName, UniString const& rVal, BOOL bHex, BOOL bExpand_SZ )
{
	WCHAR	szDummy[ 2 ];
	memset( szDummy, 0, 2 );

	HKEY hNewKey;
	HKEY hMainKey = StringToHKEY(rKey);
    LONG nErr     = RegCreateKeyExW( hMainKey, rSubKey.GetBuffer(), 0,
                                     szDummy, 0, KEY_WRITE,
                                     NULL, &hNewKey, NULL );
	if (nErr == ERROR_SUCCESS )
	{
        UniString aVal( rVal );

        if ( !bHex )
        {
            // Replace all occurrences of '~' with '&' and all '~~' with '~'
            xub_StrLen  nPos = 0;

            while ( STRING_NOTFOUND != ( nPos = aVal.Search( '~', nPos ) ) )
            {
                xub_StrLen nLastPos = nPos;
                nPos = aVal.Search( '~', nPos+1 );

                if ( nPos == nLastPos + 1 )
                    aVal.Erase( nLastPos, 1 );
                else
                {
                    aVal.SearchAndReplace( '~', '&', nLastPos );
                    nPos = nLastPos + 1;
                }
            }
        }
            
		if (rName.Len() != 0)
		{
			DWORD lHex = bHex ? HexByteStringToDWORD(ByteString(rVal, osl_getThreadTextEncoding())) : 0;

			nErr = RegSetValueExW(hNewKey, rName.GetBuffer(), 0,
						bHex ? REG_DWORD	: bExpand_SZ? REG_EXPAND_SZ : REG_SZ,
						bHex ? (LPBYTE)&lHex: (LPBYTE)aVal.GetBuffer(),
						bHex ? sizeof lHex	: 2 * ( aVal.Len() + 1 ) );
		}
		else if (aVal.Len() != 0)
		{
			DBG_ASSERT(!bHex, "WinOS::Register() does not support hex values");

            nErr = RegSetValueExW(hNewKey, 0, 0, bExpand_SZ? REG_EXPAND_SZ : REG_SZ,
						(LPBYTE)aVal.GetBuffer(), 2 * ( aVal.Len() + 1 ) );
		}

        RegCloseKey( hNewKey );
	}

	return nErr;
}

long WinOS::Deregister
(
	ByteString const&   rKey,
	ByteString const&   rSubKey,
	BOOL                bKeyOnly,
	ByteString const&   rName,
	BOOL                bDeleteAllSubKeys
)
{
    UniString aSubKey( rSubKey, osl_getThreadTextEncoding() );
    UniString aName( rName, osl_getThreadTextEncoding() );

    return WinOS::Deregister( rKey, aSubKey, bKeyOnly, aName, bDeleteAllSubKeys );
}

#define MAX_SUB_KEY_SIZE 100

long WinOS::Deregister
(
	ByteString const& rKey,
	UniString  const& rSubKey,
	BOOL		      bKeyOnly,
	UniString  const& rName,
	BOOL		      bDeleteAllSubKeys
)
{
	if ( rSubKey.Len() == 0 )
		return -2;

	HKEY hKey;
	HKEY hMainKey = StringToHKEY( rKey );

	DWORD	 dwDummy = MAX_SUB_KEY_SIZE;
	WCHAR	 szDummy[ MAX_SUB_KEY_SIZE ];
	FILETIME ftDummy;

	DWORD	 dwSubKeys=0;
	DWORD	 dwValues=0;
    LONG     lErr;

	memset( szDummy, 0, 2*dwDummy );
		
	if ( !bKeyOnly && !bDeleteAllSubKeys )
	{
		UniString aSubKey = rSubKey;
        lErr = RegOpenKeyExW( hMainKey, aSubKey.GetBuffer(), 0, KEY_ALL_ACCESS, &hKey);

		if (lErr != ERROR_SUCCESS)
			return lErr;

		lErr = RegDeleteValueW( hKey, rName.GetBuffer() );

        if (lErr == ERROR_SUCCESS )
            lErr = RegQueryInfoKeyW( hKey, szDummy, &dwDummy, NULL,
                                     &dwSubKeys,
                                     &dwDummy, &dwDummy,
                                     &dwValues,
                                     &dwDummy, &dwDummy, &dwDummy, &ftDummy );
		RegCloseKey(hKey);

        // remove all parents, if they are empty
        BOOL bContinue = TRUE;

        while ( lErr == ERROR_SUCCESS && dwSubKeys == 0 &&
             dwValues == 0 && bContinue )
		{
			lErr = RegDeleteKeyW( hMainKey, aSubKey.GetBuffer() );
            
            xub_StrLen nPos = aSubKey.SearchBackward( '\\' );
            
            if ( nPos == STRING_NOTFOUND )
                bContinue = FALSE;
            else
            {
                aSubKey.Erase( nPos );
                lErr = RegOpenKeyExW( hMainKey, aSubKey.GetBuffer(), 0, KEY_ALL_ACCESS, &hKey);

                if (lErr == ERROR_SUCCESS )
                {
                  	memset( szDummy, 0, 2*MAX_SUB_KEY_SIZE );
                    dwDummy = MAX_SUB_KEY_SIZE;
                    lErr = RegQueryInfoKeyW( hKey, szDummy, &dwDummy, NULL,
                                             &dwSubKeys,
                                             &dwDummy, &dwDummy,
                                             &dwValues,
                                             &dwDummy, &dwDummy, &dwDummy, &ftDummy );
                }
		        RegCloseKey(hKey);
            }
		}

		return lErr;
	}
	else
	{
		lErr = RegOpenKeyExW( hMainKey, rSubKey.GetBuffer(), 0,
			                       KEY_QUERY_VALUE | KEY_ENUMERATE_SUB_KEYS, &hKey );

		if (lErr != ERROR_SUCCESS)
			return lErr;

        lErr = RegQueryInfoKeyW( hKey, szDummy, &dwDummy, NULL,
                                 &dwSubKeys,
                                 &dwDummy, &dwDummy,
                                 &dwValues,
                                 &dwDummy, &dwDummy, &dwDummy, &ftDummy );

		if (lErr != ERROR_SUCCESS)
		{
			RegCloseKey( hKey );
			return lErr;
		}

		if ( dwSubKeys == 0 && dwValues == 0 )
		{
			RegCloseKey(hKey);
			return RegDeleteKeyW( hMainKey, rSubKey.GetBuffer() );
		}
		else if (bDeleteAllSubKeys)
		{
			LONG      lErr = ERROR_SUCCESS;
			UniString aSubKey;

			// Alle Subkeys loeschen
			for (DWORD i=0; i<dwSubKeys && lErr == ERROR_SUCCESS; i++)
			{
				WCHAR szSubKey[ MAX_SUB_KEY_SIZE ];
				DWORD dwSubKey = MAX_SUB_KEY_SIZE;
				FILETIME ftLastWrite;

				memset( szSubKey, 0, 2*dwSubKey );
				lErr = RegEnumKeyExW( hKey, 0, szSubKey, &dwSubKey,
                                      NULL, NULL, NULL, &ftLastWrite );

                if (lErr == ERROR_SUCCESS)
				{
					aSubKey  = rSubKey;
					aSubKey += '\\';
					aSubKey += szSubKey;

					lErr = Deregister( rKey, aSubKey, bKeyOnly, rName, bDeleteAllSubKeys );
				}
			}

			RegCloseKey( hKey );

			// Wurzel loeschen
			//
			if (lErr == ERROR_SUCCESS)
				return RegDeleteKeyW( hMainKey, rSubKey.GetBuffer());
			else
				return lErr;
		}
		else
			return -1;
	}
}


BOOL WinOS::IsRegistered
(
	ByteString const& rKey,
	ByteString const& rSubKey,
	ByteString const& rName,
	BOOL		      bHasValue
)
{
	HKEY hKey;
	LONG lErr    = RegOpenKeyEx(StringToHKEY(rKey),rSubKey.GetBuffer(),0,KEY_QUERY_VALUE,&hKey);
	BOOL bExists = FALSE;

	if (lErr != ERROR_SUCCESS)
		return FALSE;

	if (bHasValue)
	{
		DWORD dwType  = 0;
		DWORD dwSize  = 0;

		if (RegQueryValueEx(hKey,rName.GetBuffer(),0,&dwType,0,&dwSize) == ERROR_SUCCESS)
		{
			if (dwType == REG_SZ)
				dwSize--; // '\0' abziehen

			bExists = dwSize != 0;
		}
	}
	else
		bExists = TRUE; // weil Key geoeffnet werden konnte

	RegCloseKey(hKey);
	return bExists;
}


long WinOS::ClearRegEdit(ByteString const& rSubKey, ByteString const& rStart, ByteString const& rEnd)
{
/*
 *	no longer supported
 *
  	if (rSubKey.Len() == 0)
		return -2;

	SvGlobalName aStartGlob;
	aStartGlob.MakeId( UniString::CreateFromAscii(rStart.GetBuffer()) );
	SvGlobalName aEndGlob;
	aEndGlob.MakeId( UniString::CreateFromAscii(rEnd.GetBuffer()) );

	HKEY hkey;
	char szBuff[80], szValue[80];
	static DWORD dwIndex;
	LONG cb;

	LONG lErr = RegOpenKey( HKEY_CLASSES_ROOT, rSubKey.GetBuffer(), &hkey );


	if (lErr != ERROR_SUCCESS )
		return lErr;

	for ( dwIndex = 0;
			RegEnumKey( hkey, dwIndex, szBuff, sizeof(szBuff) )
			== ERROR_SUCCESS; ++dwIndex )
	{
		if ( *szBuff == '.' )
			continue;
		cb = sizeof(szValue);

		if ( RegQueryValue( hkey, (LPSTR)szBuff, szValue, &cb )
				== ERROR_SUCCESS )
		{
			ByteString sId( szBuff );
			sId.EraseAllChars( '}' );
			sId.EraseAllChars( '{' );
			SvGlobalName aCmp;
			aCmp.MakeId( UniString::CreateFromAscii(sId.GetBuffer()) );

			if (((aStartGlob < aCmp)	 || (aStartGlob == aCmp))
			&& ((aCmp		 < aEndGlob) || (aCmp == aEndGlob)))
				RegDeleteKey( hkey, sId.GetBuffer() );
		}
	}

	RegCloseKey( hkey );
 *
 *
 */
	return 0;
}

ByteString WinOS::GetRegValue
(
	ByteString const& rKey,
	ByteString const& rSubKey,
	ByteString const& rName
)
{
	ByteString	aValue;
	HKEY	    hKey;
	LONG	    lErr    = RegOpenKeyEx(StringToHKEY(rKey),rSubKey.GetBuffer(),0,KEY_QUERY_VALUE,&hKey);
	BOOL	    bExists = FALSE;

	if (lErr == ERROR_SUCCESS)
	{
		DWORD dwType  = 0;
		char  szBuffer[256];
		DWORD dwSize  = sizeof szBuffer;

		if (RegQueryValueEx(hKey,rName.GetBuffer(),0,&dwType,(LPBYTE)szBuffer,&dwSize) == ERROR_SUCCESS)
		{
			if( dwType == REG_SZ || dwType == REG_EXPAND_SZ )
            {
				aValue = szBuffer;
                aValue.SearchAndReplaceAll( ByteString( '~' ), ByteString( "~~" ) );
                aValue.SearchAndReplaceAll( '&', '~' );
            }
		}
	}
	if( hKey )
		RegCloseKey(hKey);
	return aValue;
}

struct FileVerInfo
{
	short	nFVMS_Low;
	short	nFVMS_High;
	short	nFVLS_Low;
	short	nFVLS_High;

	FileVerInfo() :
		nFVMS_Low(0), nFVMS_High(0), nFVLS_Low(0), nFVLS_High(0) {}

	BOOL	IsEqual( const FileVerInfo& rInf );
	BOOL	IsNewer( const FileVerInfo& rInf );
};

// -----------------------------------------------------------------------

/*
 * Ist die Versionsinfo der zu installierende Datei (this) neuer als die
 * Versionsinfo der aktuellen Datei (rInf)?
 *
 * Beispiel:	this 			= 2.03.3016.01
 *					nFVMS_High 	= 2
 *					nFVMS_Low	= 3
 *					nFVLS_High 	= 3016
 *					nFVLS_Low 	= 1
 *				rInf 			= 2.01.100.13
 *					nFVMS_High 	= 2
 *					nFVMS_Low	= 1
 *					nFVLS_High 	= 100
 *					nFVLS_Low 	= 13
 *
 *				return TRUE;
 */

BOOL FileVerInfo::IsEqual( const FileVerInfo& rInf )
{
	return nFVMS_High == rInf.nFVMS_High
		&& nFVMS_Low  == rInf.nFVMS_Low
		&& nFVLS_High == rInf.nFVLS_High
		&& nFVLS_Low  == rInf.nFVLS_Low;
}

BOOL FileVerInfo::IsNewer( const FileVerInfo& rInf )
{
	if (IsEqual(rInf))
		return FALSE;

	if (nFVMS_High > rInf.nFVMS_High)		// im Beispiel ==
		return TRUE;
	else if (nFVMS_High < rInf.nFVMS_High)	// im Beispiel ==
		return FALSE;

	if (nFVMS_Low > rInf.nFVMS_Low)			// im Beispiel <
		return TRUE;
	else if (nFVMS_Low < rInf.nFVMS_Low)	// im Beispiel <; -> TRUE
		return FALSE;

	if (nFVLS_High > rInf.nFVLS_High)
		return TRUE;
	else if (nFVLS_High < rInf.nFVLS_High)
		return FALSE;

	if (nFVLS_Low > rInf.nFVLS_Low)
		return TRUE;
	else if (nFVLS_Low < rInf.nFVLS_Low)
		return FALSE;

	return TRUE;
}

BOOL GetFileVersion(const char* cpFile, FileVerInfo& rInfo)
{
	HGLOBAL hglbData = NULL;
	DWORD	ulInfo;
	DWORD	cbLength;
	BOOL	bFound = FALSE;

	cbLength = GetFileVersionInfoSize( (char*)cpFile, &ulInfo );

	if ( cbLength != 0 )
	{
		// Datei hat Versionsinformation, also auslesen
		hglbData = GlobalAlloc( GMEM_MOVEABLE, cbLength );
		BYTE FAR *pbBuf = (BYTE FAR*)GlobalLock( hglbData );
		GetFileVersionInfo( (char*)cpFile, ulInfo, cbLength, pbBuf );

		char *ptr, *pVer;
		int i = 0;
		ptr = (char*)pbBuf;

		while ( i < (int)cbLength )
		{
			// suchen nach der Sektion "VS_VERSION_INFO"
			ptr++;
			i++;
			pVer = strstr( ptr, "VS_VERSION_INFO" );

			if ( pVer )
			{
				// gefunden, dann bis zur naechsten NULL weiter
				while( i < (int)cbLength )
				{
					ptr++;
					i++;

					if ( *ptr == '\0' )
						break;
				}
				ptr++;

				// auf den struct casten und die wichtigen Infos auslesen
				VS_FIXEDFILEINFO* pInfo = (VS_FIXEDFILEINFO*)(BYTE FAR*)ptr;
				rInfo.nFVMS_Low  = LOWORD( pInfo->dwFileVersionMS );
				rInfo.nFVMS_High = HIWORD( pInfo->dwFileVersionMS );
				rInfo.nFVLS_Low  = LOWORD( pInfo->dwFileVersionLS );
				rInfo.nFVLS_High = HIWORD( pInfo->dwFileVersionLS );
				bFound = TRUE;
				break;
			}
		}
		GlobalUnlock( hglbData );
	}
	return bFound;
}


BOOL WinOS::IsSourceFileNewerVersion
(
	ByteString const& aSourceFile,
	BOOL		  bPacked,
	ByteString const& aDestFile
)
{
	SiDirEntry 		aRoot;
	FileVerInfo 	aTmpInfo;
	FileVerInfo 	aInfo;
	BOOL			bDestInfo;
	BOOL			bSrcInfo;

	bDestInfo = GetFileVersion(aDestFile.GetBuffer(), aInfo);

	if (bPacked)
	{
		// File temporaer auspacken
		aRoot = Application::GetAppFileName();
		aRoot.SetName( UniString::CreateFromAscii(SiDirEntry(aDestFile).GetName().GetBuffer()) );

		if (aRoot.SetCWD(TRUE))
		{
			USHORT nErr = (USHORT)SVUnzip(aSourceFile.GetBuffer(), "*.*", "qqo", 0);
			if (nErr == 0)
				bSrcInfo = GetFileVersion(aRoot.GetFull().GetBuffer(), aTmpInfo);
		}
	}
	else
		bSrcInfo = GetFileVersion(aSourceFile.GetBuffer(), aTmpInfo);

	BOOL bReturn;
	if( !bDestInfo && !bSrcInfo )
	{	// Dateien haben keine Versionresource; also Datum vergleichen
		SiDirEntry aDestEntry;
		SiDirEntry aSrcEntry;

		if( bPacked )
			aSrcEntry = aRoot;
		else
			aSrcEntry = aSourceFile;
		aDestEntry = aDestFile;

		FileStat aDestStat( aDestEntry );
		FileStat aSrcStat( aSrcEntry );

		if( aSrcStat.IsYounger(aDestStat) )
			bReturn = TRUE;
		else
			bReturn = FALSE;
	}
	else
		if( !bDestInfo && bSrcInfo )
			bReturn = TRUE;
		else
			bReturn = aTmpInfo.IsNewer(aInfo);

	if( bPacked )
		aRoot.Kill();
	return bReturn;
}

ByteString FindShare( const SiDirEntry& rEntry )
{
	ByteString aStr;
	SiDirEntry aOld, aTmp( rEntry );
	aOld.ToAbs();
	aTmp.SetCWD();

	Dir aFiles( SiDirEntry( "*" ), FSYS_KIND_FILE );

	for ( USHORT i = 0; i < aFiles.Count(); ++i )
	{
		SiDirEntry aEntry( aFiles[i] );
		ByteString aTst( aEntry.GetName() );
		aTst.ToLowerAscii();
		if ( aTst == "share.exe" )
		{
			aStr = aEntry.GetFull();
			break;
		}
	}

	if ( !aStr.Len() )
	{
		Dir aDir( SiDirEntry( "*" ), FSYS_KIND_DIR );

		for ( USHORT i = 0; i < aDir.Count(); ++i )
		{
 			SiDirEntry aEntry( aDir[i] );
			ByteString aFull( aEntry.GetFull() );

			if ( aFull != "." && aFull != ".." )
			{
				aStr = FindShare( aDir[i] );

				if ( aStr.Len() )
				{
					ByteString aParent( aFull );
					aParent += '\\';
					aStr.Insert( aParent, 0 );
					break;
				}
			}
		}
	}
	aOld.SetCWD();
	return aStr;
}

void WinOS::InstallShare()
// post: In der Autoexec.bat befindet sich der Eintrag zum Laden von Share
{
#ifdef WIN
	SiDirEntry aC( "c:\\" );
	ByteString aShareStr = FindShare( aC );

	if (aShareStr.Len() > 0)
		aShareStr.Insert( "c:\\", 0);
	else
		aShareStr = "share.exe"; // dann ohne Pfad

	BOOL			bFound;
	SvByteStringsDtor	aList;
	ByteString		   *psLine = 0;
	ByteString			sLine;
	SvFileStream	aStrm( "c:\\autoexec.bat", STREAM_READWRITE );
	SvFileStream	aBakStrm( "c:\\autoexec.set", STREAM_WRITE );

	while (aStrm.ReadLine(sLine))
	{
		aBakStrm.WriteLine(sLine);
		ByteString sTmp( sLine );
		sTmp.ToLower();

		if ( sTmp.Search( "share" ) != STRING_NOTFOUND &&
			 sTmp.Search( "rem" ) == STRING_NOTFOUND 		)
		{
			// Share vorhanden und nicht ausge'rem't, also aus'rem'men
			bFound = TRUE;
			sLine.Insert( "rem  <Star Division Setup> ", 0 );
		}
		psLine = new ByteString( sLine );
		aList.Insert( psLine, aList.Count() );
	}
	aStrm.Seek( 0 );
	aStrm.WriteLine( "rem insert by StarDivision Setup" );
	aShareStr += " /l:500 /f:5100";
	aStrm.WriteLine( aShareStr );

	for ( USHORT i = 0; i < aList.Count(); ++i )
		aStrm.WriteLine( *aList[i] );
#endif
}

BOOL WinOS::BindBinary( ByteString aBinName )
{
//#ifdef WNT
//	char* pName = (char*) (aBinName.GetBuffer());
//	BOOL bRet = BindImage( pName, NULL, NULL );
//	return bRet;
//#else
	return FALSE;
//#endif
}

void WinOS::Shutdown( BOOL bLogoutOnly )
{
	ByteString aOS = GetOSVersion();
	if( aOS == "NT35" || aOS == "NT4" || aOS == "NT5" || aOS == "NT51" )
	{
		HANDLE hToken;
		if( OpenProcessToken(GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES, &hToken) )
		{
			TOKEN_PRIVILEGES tp;
			tp.PrivilegeCount = 1;
			LookupPrivilegeValue( NULL, SE_SHUTDOWN_NAME, &tp.Privileges[0].Luid );
			tp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
			AdjustTokenPrivileges( hToken, FALSE, &tp, sizeof(tp), NULL, NULL );
			if( bLogoutOnly )
				ExitWindowsEx( EWX_LOGOFF, 0 );
			else
				ExitWindowsEx( EWX_REBOOT, 0 );
			CloseHandle( hToken );
		}
	}
	else
		ExitWindowsEx( EWX_REBOOT, 0 );
}

void WinOS::PropagateEnvironmentChange()
{
	DWORD dwReturnValue;
	SendMessageTimeout( HWND_BROADCAST, WM_SETTINGCHANGE, 0, (LPARAM)"Environment",
		SMTO_ABORTIFHUNG, 5000, &dwReturnValue );
}

BOOL WinOS::Shell_FlushIconCache()
{
	if( GetOSVersion() == "NT51" ) return TRUE;

	HKEY	hKey;
	DWORD	dwDispostion;
	LONG	lError = RegCreateKeyExA( HKEY_CURRENT_USER, "Control Panel\\Desktop\\WindowMetrics", 0, NULL, REG_OPTION_VOLATILE, KEY_SET_VALUE | KEY_QUERY_VALUE, NULL, &hKey, &dwDispostion );
	BOOL	fSuccess = FALSE;

	if ( ERROR_SUCCESS == lError )
	{
		TCHAR	szValue[256];
		TCHAR	szTempValue[256];
		DWORD	cbValue = sizeof(szValue);
		DWORD	dwType;
		int		iSize = 0;

		lError = RegQueryValueExA( hKey, "Shell Icon Size", 0, &dwType, (LPBYTE)szValue, &cbValue );

		if ( ERROR_SUCCESS == lError )
			iSize = atoi( szValue );

		if ( !iSize )
		{
			iSize = GetSystemMetrics( SM_CXICON );
			itoa( iSize, szValue, 10 );
			cbValue = strlen( szValue ) + 1;
			dwType = REG_SZ;
		}

		itoa( iSize + 1, szTempValue, 10 );
		lError = RegSetValueExA( hKey, "Shell Icon Size", 0, dwType, (LPBYTE)szTempValue, strlen( szTempValue ) + 1 );

		LRESULT	lResult = SendMessageTimeoutA(
			 HWND_BROADCAST,
			 WM_SETTINGCHANGE,
			 SPI_SETNONCLIENTMETRICS,
			 (LPARAM)"WindowMetrics",
			 SMTO_NORMAL|SMTO_ABORTIFHUNG,
			 0, NULL);

		lError = RegSetValueExA( hKey, "Shell Icon Size", 0, dwType, (LPBYTE)szValue, cbValue );

		lResult = SendMessageTimeoutA(
			 HWND_BROADCAST,
			 WM_SETTINGCHANGE,
			 SPI_SETNONCLIENTMETRICS,
			 (LPARAM)"WindowMetrics",
			 SMTO_NORMAL|SMTO_ABORTIFHUNG,
			 0, NULL);

		lError = RegCloseKey( hKey );
	}

	return fSuccess;
}

BOOL WinOS::DeregisterFont( const ByteString &rFontFile )
{
	BOOL bSuccess, bRet;
    SiDirEntry aTTF_File  = OS::GetSystemFontPath();
		       aTTF_File += rFontFile;
    SiDirEntry aFOT_File( aTTF_File );
    aFOT_File.SetExtension( UniString::CreateFromAscii( "fot" ) );

    bSuccess = RemoveFontResource( aTTF_File.GetFull().GetBuffer() );

    if ( !bSuccess )
        bSuccess = RemoveFontResource( aFOT_File.GetFull().GetBuffer() );

    if ( aTTF_File.Kill() != ERRCODE_NONE )
    {
        // When we can't delete the font file, we will register the font
        // again and return false so the caller will initiate a MoveFileAfterBoot
        bRet = FALSE;
        bSuccess = FALSE;
        AddFontResource( aTTF_File.GetFull().GetBuffer() );
/*        SiDirEntry aMoveTo( aTTF_File );
		ByteString aFilename( "~" );
		aFilename += rFontFile;
		aMoveTo.SetName( UniString( aFilename, osl_getThreadTextEncoding() ) );
		aTTF_File.MoveTo( aMoveTo );
		MoveFileEx( aMoveTo.GetFull().GetBuffer(), NULL, MOVEFILE_DELAY_UNTIL_REBOOT | MOVEFILE_REPLACE_EXISTING );
        bSuccess = AddFontResource( aMoveTo.GetFull().GetBuffer() );
        */
	}
    else
        bRet = TRUE;

    aFOT_File.Kill();

    if ( bSuccess )
        ::PostMessage( HWND_BROADCAST, WM_FONTCHANGE, 0, 0);

    return bRet;
}

// -----------------------------------------------------------------------
// Modus pruefen
// -----------------------------------------------------------------------
#define X_COUNT 80
#define PLACEHOLDER 'x'

BOOL WinOS::PatchProductName( const SiDirEntry& rToPatch, const ByteString& rName )
{
    SiDirEntry aSource( rToPatch );
    SiDirEntry aTarget( rToPatch );

    aSource.SetExtension( UniString::CreateFromAscii( "org" ) );
	if ( aTarget.MoveTo( aSource ) != ERRCODE_NONE )
        return FALSE;

	SvFileStream aSrcStrm( aSource.GetFullUni(), STREAM_READ );
	SvFileStream aDstStrm( aTarget.GetFullUni(), STREAM_WRITE | STREAM_TRUNC );

	if( !aSrcStrm.IsOpen() || !aDstStrm.IsOpen() )
    {
		aSource.MoveTo( aTarget );
        return FALSE;
    }

	aSrcStrm.Seek( STREAM_SEEK_TO_END );
    ULONG nSize = aSrcStrm.Tell();
    aSrcStrm.Seek( 0L );

    char *cBuf = new char[ nSize ];
    ULONG nRead = aSrcStrm.Read( cBuf, nSize );

	if ( nRead != nSize )
    {
		aSource.MoveTo( aTarget );
        delete [] cBuf;
        return FALSE;
    }

    for( ULONG i = 0; i < nRead; i++ )
    {
        if ( ( cBuf[i] == PLACEHOLDER ) && ( i + ( X_COUNT * 2 ) - 1 <= nRead ) )
        {
            ULONG k = 1;
            while ( k < X_COUNT )
            {
                if ( cBuf[i+(2*k)] == PLACEHOLDER )
                    k++;
                else
                    break;
            }
            if ( k == X_COUNT )
            {
                UniString aReplace( rName, osl_getThreadTextEncoding() );
                const sal_Unicode *pBuffer = aReplace.GetBuffer();

                USHORT nLen = Min( (USHORT) aReplace.Len(), (USHORT) X_COUNT );
                USHORT l;
                for ( l=0; l<nLen; l++ )
                {
                    cBuf[ i + ( 2*l ) ] = (char) ( pBuffer[l] & 0xFF );
                    cBuf[ i + ( 2*l ) + 1 ] = (char ) ( pBuffer[l] >> 8 );
                }
                while ( l < X_COUNT )
                {
                    cBuf[ i + ( 2*l ) ] = '\0';
                    cBuf[ i + ( 2*l ) + 1 ] = '\0';
                    l++;
                }
                i += X_COUNT * 2 - 1;
            }
        }
    }

	aDstStrm.Write( cBuf, nRead );

    aDstStrm.Close();
	aSrcStrm.Close();
	aSource.Kill();

    delete [] cBuf;

    return TRUE;
}

// --------------------------------------------------------------
BOOL WinOS::IsOfficeRunning( const ByteString& rInstalledPath )
{
    // There is no way to detect, whether another user uses the office
    // so we try to move the office binary up one directory. If we are
    // successful, probably no other user uses the office.

    BOOL        bRet = FALSE;
    ByteString  aExePath( rInstalledPath );
    
    aExePath += ByteString( "\\program\\soffice.exe" );

    DWORD nAttr;
    DWORD nOldAttr = GetFileAttributes( aExePath.GetBuffer() );

    if ( 0xFFFFFFFF != nOldAttr )
    {
        nAttr = nOldAttr & ~FILE_ATTRIBUTE_READONLY;
        SetFileAttributes( aExePath.GetBuffer(), nAttr );
    }

    HANDLE hFile = CreateFile( aExePath.GetBuffer(),
                               GENERIC_WRITE,
                               NULL, NULL,
                               OPEN_EXISTING,
                               FILE_ATTRIBUTE_NORMAL,
                               NULL );
    
	long nLastErr = GetLastError();

    if ( hFile == INVALID_HANDLE_VALUE )
    {
        // When we got an sharing violation, the file is probably locked
        // by an running office
        if ( nLastErr == ERROR_SHARING_VIOLATION )
            bRet = TRUE;
        else if ( nLastErr == ERROR_FILE_NOT_FOUND )
            bRet = FALSE;
    }

    if ( hFile != INVALID_HANDLE_VALUE )
        CloseHandle( hFile );

    if ( 0xFFFFFFFF != nOldAttr )
        SetFileAttributes( aExePath.GetBuffer(), nOldAttr );

    return bRet;
}
