/*************************************************************************
 *
 *  $RCSfile: fader2.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ok $ $Date: 2001/07/23 08:51:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#pragma hdrstop

#include <stdlib.h>
#include <string.h>

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#include <vcl/poly.hxx>
#include "fader.hxx"


using namespace ::com::sun::star;

#define RESCHEDULE_AND_WAIT() if( FADER_MAGIC != nMagic ) return; WaitInEffect( WAIT_IN_EFFECT_MS )

/*************************************************************************
|*
|* Zellenweise einblenden: von oben nach unten in Schlangenlinie
|*
\************************************************************************/

void Fader::CellsWavyLineFromTop()
{
	ULONG nNoOfSteps = GetEffectSteps(eSpeed);

	CalcCellParams(100);         // etwa 100 Zellen

	USHORT nCellCount = nColCount * nRowCount;
	USHORT nHits      = 0;
	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
	nPause = Max(nPause, (USHORT)1);

	USHORT nDir = 0;            // rechts = 0, links = 1


	USHORT nCurX = 0;
	USHORT nCurY = 0;

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while (nHits < nCellCount)
	{
		Rectangle aRect(GetCell(nCurX, nCurY));
		pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
						 aRect.GetSize(),
						 aSource.TopLeft() + aRect.TopLeft(),
						 aRect.GetSize(),
						 *pVDev);
		nHits++;

		// naechste Zelle berechnen
		if (nDir == 0)      // rechts
		{
			if (nCurX == nColCount - 1)
			{
				nCurY++;
				nDir++;
			}
			else
			{
				nCurX++;
			}
		}
		else
		{
			if (nCurX == 0)
			{
				nCurY++;
				nDir--;
			}
			else
			{
				nCurX--;
			}
		}

		// warten
		if( !( nHits % nPause ) )
		{
			RESCHEDULE_AND_WAIT();
		}
	}
}

/*************************************************************************
|*
|* Zellenweise einblenden: von unten nach oben in Schlangenlinie
|*
\************************************************************************/

void Fader::CellsWavyLineFromBottom()
{
	ULONG nNoOfSteps = GetEffectSteps(eSpeed);

	CalcCellParams(100);         // etwa 100 Zellen

	USHORT nCellCount = nColCount * nRowCount;
	USHORT nHits      = 0;
	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
	nPause = Max(nPause, (USHORT)1);

	USHORT nDir = 0;            // links = 0, rechts = 1


	USHORT nCurX = nColCount - 1;
	USHORT nCurY = nRowCount - 1;

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while (nHits < nCellCount)
	{
		Rectangle aRect(GetCell(nCurX, nCurY));
		pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
						 aRect.GetSize(),
						 aSource.TopLeft() + aRect.TopLeft(),
						 aRect.GetSize(),
						 *pVDev);
		nHits++;

		// naechste Zelle berechnen
		if (nDir == 0)      // links
		{
			if (nCurX == 0)
			{
				nCurY--;
				nDir++;
			}
			else
			{
				nCurX--;
			}
		}
		else
		{
			if (nCurX == nColCount - 1)
			{
				nCurY--;
				nDir--;
			}
			else
			{
				nCurX++;
			}
		}

		// warten
		if( !( nHits % nPause ) )
		{
			RESCHEDULE_AND_WAIT();
		}
	}
}

/*************************************************************************
|*
|* Zellenweise einblenden: von links nach rechts in Schlangenlinie
|*
\************************************************************************/

void Fader::CellsWavyLineFromLeft()
{
	ULONG nNoOfSteps = GetEffectSteps(eSpeed);

	CalcCellParams(100);         // etwa 100 Zellen

	USHORT nCellCount = nColCount * nRowCount;
	USHORT nHits      = 0;
	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
	nPause = Max(nPause, (USHORT)1);

	USHORT nDir = 0;            // oben = 0, unten = 1


	USHORT nCurX = 0;
	USHORT nCurY = nRowCount - 1;

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while (nHits < nCellCount)
	{
		Rectangle aRect(GetCell(nCurX, nCurY));
		pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
						 aRect.GetSize(),
						 aSource.TopLeft() + aRect.TopLeft(),
						 aRect.GetSize(),
						 *pVDev);
		nHits++;

		// naechste Zelle berechnen
		if (nDir == 0)      // oben
		{
			if (nCurY == 0)
			{
				nCurX++;
				nDir++;
			}
			else
			{
				nCurY--;
			}
		}
		else
		{
			if (nCurY == nRowCount - 1)
			{
				nCurX++;
				nDir--;
			}
			else
			{
				nCurY++;
			}
		}

		// warten
		if( !( nHits % nPause ) )
		{
			RESCHEDULE_AND_WAIT();
		}
	}
}

/*************************************************************************
|*
|* Zellenweise einblenden: von rechts nach links in Schlangenlinie
|*
\************************************************************************/

void Fader::CellsWavyLineFromRight()
{
	ULONG nNoOfSteps = GetEffectSteps(eSpeed);

	CalcCellParams(100);         // etwa 100 Zellen

	USHORT nCellCount = nColCount * nRowCount;
	USHORT nHits      = 0;
	USHORT nPause     = (USHORT)(nCellCount / nNoOfSteps);
	nPause = Max(nPause, (USHORT)1);

	USHORT nDir = 0;            // unten = 0, oben = 1


	USHORT nCurX = nColCount - 1;
	USHORT nCurY = 0;

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	while (nHits < nCellCount)
	{
		Rectangle aRect(GetCell(nCurX, nCurY));
		pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
						 aRect.GetSize(),
						 aSource.TopLeft() + aRect.TopLeft(),
						 aRect.GetSize(),
						 *pVDev);
		nHits++;

		// naechste Zelle berechnen
		if (nDir == 0)      // unten
		{
			if (nCurY == nRowCount - 1)
			{
				nCurX--;
				nDir++;
			}
			else
			{
				nCurY++;
			}
		}
		else
		{
			if (nCurY == 0)
			{
				nCurX--;
				nDir--;
			}
			else
			{
				nCurY--;
			}
		}

		// warten
		if( !( nHits % nPause ) )
		{
			RESCHEDULE_AND_WAIT();
		}
	}
}

/*************************************************************************
|*
|* Test
|*
\************************************************************************/

/*
void Fader::Test()
{
	ULONG nNoOfSteps = GetEffectSteps(eSpeed);

	Color aBlack(COL_BLACK);

	XOutputDevice aOut(pWin);

	Polygon aPolygon(aTarget);

	// Phase 1: abblenden
	aOut.DrawTransparentFill(aPolygon, aBlack, 75);
	WaitInEffect(WAIT_IN_EFFECT_MS);

	aOut.DrawTransparentFill(aPolygon, aBlack, 50);
	WaitInEffect(WAIT_IN_EFFECT_MS);

	aOut.DrawTransparentFill(aPolygon, aBlack, 25);
	WaitInEffect(WAIT_IN_EFFECT_MS);

	aOut.DrawTransparentFill(aPolygon, aBlack, 0);
	WaitInEffect(WAIT_IN_EFFECT_MS);
}
*/
/*************************************************************************
|*
|* zufaelliger Effekt
|*
\************************************************************************/

void Fader::RandomEffect()
{
	do
	{
		Time aTime;
		eEffect = (presentation::FadeEffect)(aTime.GetTime() % FADE_EFFECT_COUNT);
	}
	while (eEffect == presentation::FadeEffect_RANDOM);

	// wird von Fade() gerufen, also muss erstmal wieder auf LOGIC geschaltet
	// werden
	SwitchToLogic();
	Fade();
	SwitchToPixel();
}

/*************************************************************************
|*
|* von oben 'hineindehnen'
|*
\************************************************************************/

void Fader::StretchFromTop()
{
	ULONG nHeight;
	switch (eSpeed)
	{
		case FADE_SPEED_SLOW:   nHeight = 4; break;
		case FADE_SPEED_MEDIUM: nHeight = 6; break;
		case FADE_SPEED_FAST:   nHeight = 8; break;
	}

	ULONG nNoOfSteps = aTarget.GetHeight() / nHeight;
	ULONG nLastHeight = aTarget.GetHeight() % nNoOfSteps;
	if (nLastHeight)
		nNoOfSteps++;

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	for (ULONG nStep = 0; nStep < nNoOfSteps; nStep++)
	{
		Point aSrcPnt(aSource.BottomLeft());
		aSrcPnt.Y() -= (nStep + 1) * nHeight - 1;
		aSrcPnt.Y()  = Max(aSrcPnt.Y(), aSource.Top());

		Size aSize(aTarget.GetWidth(), nHeight);
		if (nLastHeight && nStep == nNoOfSteps - 1)
			aSize.Height() = nLastHeight;

		// die Weglaenge ist nicht immer ein Vielfaches der Streifenbreite,
		// darum nur n-1 mal in der Schleife zeichnen und das n-te mal genau
		// positionieren
		Point aTgtPnt(aTarget.TopLeft());
		ULONG nStop = nNoOfSteps - nStep - 1;
		for (ULONG nCount = 0; nCount < nStop; nCount++)
		{
			pWin->DrawOutDev(aTgtPnt, aSize, aSrcPnt, aSize, *pVDev);
			aTgtPnt.Y() += nHeight;
		}

		aTgtPnt.Y() = aSrcPnt.Y() - aSource.Top() + aTarget.Top();
		pWin->DrawOutDev(aTgtPnt, aSize, aSrcPnt, aSize, *pVDev);
		RESCHEDULE_AND_WAIT();
	}
}

/*************************************************************************
|*
|* von links 'hineindehnen'
|*
\************************************************************************/

void Fader::StretchFromLeft()
{
	ULONG nWidth;
	switch (eSpeed)
	{
		case FADE_SPEED_SLOW:   nWidth = 4; break;
		case FADE_SPEED_MEDIUM: nWidth = 6; break;
		case FADE_SPEED_FAST:   nWidth = 8; break;
	}

	ULONG nNoOfSteps = aTarget.GetWidth() / nWidth;
	ULONG nLastWidth = aTarget.GetWidth() % nNoOfSteps;
	if (nLastWidth)
		nNoOfSteps++;

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	for (ULONG nStep = 0; nStep < nNoOfSteps; nStep++)
	{
		Point aSrcPnt(aSource.TopRight());
		aSrcPnt.X() -= (nStep + 1) * nWidth - 1;
		aSrcPnt.X()  = Max(aSrcPnt.X(), aSource.Left());

		Size aSize(nWidth, aTarget.GetHeight());
		if (nLastWidth && nStep == nNoOfSteps - 1)
			aSize.Width() = nLastWidth;

		// die Weglaenge ist nicht immer ein Vielfaches der Streifenbreite,
		// darum nur n-1 mal in der Schleife zeichnen und das n-te mal genau
		// positionieren
		Point aTgtPnt(aTarget.TopLeft());
		ULONG nStop = nNoOfSteps - nStep - 1;
		for (ULONG nCount = 0; nCount < nStop; nCount++)
		{
			pWin->DrawOutDev(aTgtPnt, aSize, aSrcPnt, aSize, *pVDev);
			aTgtPnt.X() += nWidth;
		}

		aTgtPnt.X() = aSrcPnt.X() - aSource.Left() + aTarget.Left();
		pWin->DrawOutDev(aTgtPnt, aSize, aSrcPnt, aSize, *pVDev);
		RESCHEDULE_AND_WAIT();
	}
}

/*************************************************************************
|*
|* von unten 'hineindehnen'
|*
\************************************************************************/

void Fader::StretchFromBottom()
{
	ULONG nHeight;
	switch (eSpeed)
	{
		case FADE_SPEED_SLOW:   nHeight = 4; break;
		case FADE_SPEED_MEDIUM: nHeight = 6; break;
		case FADE_SPEED_FAST:   nHeight = 8; break;
	}

	ULONG nNoOfSteps = aTarget.GetHeight() / nHeight;
	ULONG nLastHeight = aTarget.GetHeight() % nNoOfSteps;
	if (nLastHeight)
		nNoOfSteps++;

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	for (ULONG nStep = 0; nStep < nNoOfSteps; nStep++)
	{
		Point aSrcPnt(aSource.TopLeft());
		aSrcPnt.Y() += nStep * nHeight;

		Size aSize(aTarget.GetWidth(), nHeight);
		if (nLastHeight && nStep == nNoOfSteps - 1)
			aSize.Height() = nLastHeight;

		// die Weglaenge ist nicht immer ein Vielfaches der Streifenbreite,
		// darum nur n-1 mal in der Schleife zeichnen und das n-te mal genau
		// positionieren
		Point aTgtPnt(aTarget.BottomLeft());
		aTgtPnt.Y() -= nHeight - 1;
		ULONG nStop = nNoOfSteps - nStep - 1;
		for (ULONG nCount = 0; nCount < nStop; nCount++)
		{
			pWin->DrawOutDev(aTgtPnt, aSize, aSrcPnt, aSize, *pVDev);
			aTgtPnt.Y() -= nHeight;
		}

		aTgtPnt.Y() = aSrcPnt.Y() - aSource.Top() + aTarget.Top();
		pWin->DrawOutDev(aTgtPnt, aSize, aSrcPnt, aSize, *pVDev);
		RESCHEDULE_AND_WAIT();
	}
}

/*************************************************************************
|*
|* von rechts 'hineindehnen'
|*
\************************************************************************/

void Fader::StretchFromRight()
{
	ULONG nWidth;
	switch (eSpeed)
	{
		case FADE_SPEED_SLOW:   nWidth = 4; break;
		case FADE_SPEED_MEDIUM: nWidth = 6; break;
		case FADE_SPEED_FAST:   nWidth = 8; break;
	}

	ULONG nNoOfSteps = aTarget.GetWidth() / nWidth;
	ULONG nLastWidth = aTarget.GetWidth() % nNoOfSteps;
	if (nLastWidth)
		nNoOfSteps++;

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	for (ULONG nStep = 0; nStep < nNoOfSteps; nStep++)
	{
		Point aSrcPnt(aSource.TopLeft());
		aSrcPnt.X() += nStep * nWidth;

		Size aSize(nWidth, aTarget.GetHeight());
		if (nLastWidth && nStep == nNoOfSteps - 1)
			aSize.Width() = nLastWidth;

		// die Weglaenge ist nicht immer ein Vielfaches der Streifenbreite,
		// darum nur n-1 mal in der Schleife zeichnen und das n-te mal genau
		// positionieren
		Point aTgtPnt(aTarget.TopRight());
		aTgtPnt.X() -= nWidth - 1;
		ULONG nStop = nNoOfSteps - nStep - 1;
		for (ULONG nCount = 0; nCount < nStop; nCount++)
		{
			pWin->DrawOutDev(aTgtPnt, aSize, aSrcPnt, aSize, *pVDev);
			aTgtPnt.X() -= nWidth;
		}

		aTgtPnt.X() = aSrcPnt.X() - aSource.Left() + aTarget.Left();
		pWin->DrawOutDev(aTgtPnt, aSize, aSrcPnt, aSize, *pVDev);
		RESCHEDULE_AND_WAIT();
	}
}

/*************************************************************************
|*
|* Vertikale Pixel-Linien nach Zufallssequenz
|*
\************************************************************************/

void Fader::VerticalLines()
{
	ULONG nNoOfSteps = GetEffectSteps(eSpeed);

	USHORT nPause     = (USHORT)(aTarget.GetWidth() / nNoOfSteps / 2);
	nPause = Max(nPause, (USHORT)1);

	char* pFlags = new char[aTarget.GetWidth()];
	memset(pFlags, 0, aTarget.GetWidth());

	srand(1);

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	USHORT nHits = 0;
	while( nHits < aTarget.GetWidth() )
	{
		USHORT nIndex = rand();
		if (nIndex < aTarget.GetWidth() && !pFlags[nIndex])
		{
			nHits++;
			pFlags[nIndex] = 1;
			Rectangle aRect(nIndex, 0, nIndex + 1, aTarget.GetHeight());

			pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 aSource.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 *pVDev);

			if( !( nHits % nPause ) )
			{
				RESCHEDULE_AND_WAIT();
			}
		}
	}

	delete[] pFlags;
}

/*************************************************************************
|*
|* Horizontale Pixel-Linien nach Zufallssequenz
|*
\************************************************************************/
void Fader::HorizontalLines()
{
	ULONG nNoOfSteps = GetEffectSteps(eSpeed);

	USHORT nPause     = (USHORT)(aTarget.GetHeight() / nNoOfSteps / 2);
	nPause = Max(nPause, (USHORT)1);

	char* pFlags = new char[aTarget.GetHeight()];
	memset(pFlags, 0, aTarget.GetHeight());

	srand(1);

	if (pVDevOld)
	{
		pWin->DrawOutDev(aTarget.TopLeft(), aTarget.GetSize(),
						 aSource.TopLeft(), aSource.GetSize(), *pVDevOld);
	}

	USHORT nHits = 0;
	while (nHits < aTarget.GetHeight())
	{
		USHORT nIndex = rand();
		if (nIndex < aTarget.GetHeight() && !pFlags[nIndex])
		{
			nHits++;
			pFlags[nIndex] = 1;
			Rectangle aRect(0, nIndex, aTarget.GetWidth(), nIndex + 1);

			pWin->DrawOutDev(aTarget.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 aSource.TopLeft() + aRect.TopLeft(),
							 aRect.GetSize(),
							 *pVDev);

			if( !( nHits % nPause ) )
			{
				// GetpApp()->Reschedule();
				if( FADER_MAGIC != nMagic )
					break;
				WaitInEffect(WAIT_IN_EFFECT_MS);
			}
		}
	}

	delete[] pFlags;
}


