/*************************************************************************
 *
 *  $RCSfile: pmodules.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: dv $ $Date: 2001/11/05 12:13:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _HEADBAR_HXX //autogen
#include <svtools/headbar.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SV_SOUND_HXX
#include <vcl/sound.hxx>
#endif

#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _L2TXTENC_HXX
#include <tools/l2txtenc.hxx>
#endif

#include "maindlg.hxx"
#include "environ.hxx"
#include "decltor.hxx"
#include "script.hxx"
#include "sibasic.hxx"
#include "sihelp.hxx"

#include "pmodules.hxx"
#include "pmodules.hrc"

///////////////////////////////////////////////////////////////////////////////
//
PageModules::PageModules( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	maFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	maFTInfo2		( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	maFTInfo3		( this, ResId(FT_INFO3, rResId.GetResMgr()) ),
	maRBUseOwn		( this, ResId(RB_USE_OWN, rResId.GetResMgr()) ),
	maRBUseSet		( this, ResId(RB_USE_SET, rResId.GetResMgr()) ),
	maGBox			( this, ResId(GB_MODINFO, rResId.GetResMgr()) ),
	maModuleList    ( this, ResId(LB_MODULES, rResId.GetResMgr()) ),
	maStrSelect		( ResId(STR_SELECT, rResId.GetResMgr()) ),
	maStrSelectErr	( ResId(STR_SELECTERR, rResId.GetResMgr()) )
{
	String aTitle( ResId( STR_TITLE, rResId.GetResMgr() ) );
	pParent->SetTitleStr( aTitle );
	FreeResource();

    SiCompiledScript*   pCS = GETDLG()->GetCScript();
    const SiModSetList& rModSetList = pCS->GetModuleSetList();

	maModuleList.InsertEntry( maStrSelect );
	for ( ULONG i=0; i<rModSetList.Count(); i++ )
    {
        SiModulesSet* pSet = rModSetList.GetObject( i );

        UniString aName;
        SiModulesSet* pLangRef = NULL;

        USHORT nLang = GETDLG()->GetLanguage();

        if( pSet->HasLangRef() )
        {
            pLangRef = (SiModulesSet*) pSet->GetLangRef( nLang );
            if( pLangRef )
                pLangRef->JoinWithParent();
        }

        aName = pLangRef ?
            UniString( pLangRef->GetName(), Langcode2TextEncoding( nLang ) ) :
            UniString( pSet->GetName(),  Langcode2TextEncoding( nLang ) );

        USHORT nPos = maModuleList.InsertEntry( aName );
		maModuleList.SetEntryData( nPos, (void*)pSet );
    }

	maRBUseOwn.SetClickHdl		( LINK(this, PageModules, ClickHdl) );
	maRBUseSet.SetClickHdl		( LINK(this, PageModules, ClickHdl) );
	maModuleList.SetSelectHdl	( LINK(this, PageModules, SelectHdl) );
	maModuleList.SetDropDownLineCount( 5 );
}

///////////////////////////////////////////////////////////////////////////////
//
PageModules::~PageModules()
{
}

///////////////////////////////////////////////////////////////////////////////
//
SvAgentPage* PageModules::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageModules( pParent, rResId );
}

///////////////////////////////////////////////////////////////////////////////
//	virtual's
BOOL PageModules::AllowNext()
{
	USHORT nIdx = maModuleList.GetSelectEntryPos();
	if( maRBUseSet.IsChecked() && nIdx != LISTBOX_ENTRY_NOTFOUND && !nIdx )
	{
		ErrorBox( this, WB_OK, maStrSelectErr ).Execute();
		return FALSE;
	}

	if( maRBUseSet.IsChecked() )
	{
        SiCompiledScript*   pCS = GETDLG()->GetCScript();
		SiEnvironment*      pEnv = GETDLG()->GetEnv();
		SiModulesSet* pSet = (SiModulesSet*)maModuleList.GetEntryData( nIdx );
		const SiModuleIdsList& rMIDLst = pSet->GetModuleIdsList();

        for( USHORT i = 0; i < rMIDLst.Count(); i++ )
		{
			SiModuleIds* pIDs = rMIDLst.GetObject(i);
			const SiModuleList& rMLst = pIDs->GetModuleList();
    		SiModuleSet* pNewSet = new SiModuleSet( pIDs->GetName() );
	
			for( USHORT x = 0; x < rMLst.Count(); x++ )
            {
				if ( pIDs->IsRecursive() )
                {
                    SiModule *pMod = SiHelp::FindModuleByID( pCS->GetRootModule(),
                                                             rMLst.GetObject(x)->GetID() );
                    if ( pMod )
                        AddRecursive( pNewSet, pMod );
                }
                else
                    pNewSet->Add( rMLst.GetObject(x) );
            }
            
            // Add new ModuleSet only when there are any modules in it
            if ( rMLst.Count() )
                pEnv->AddModuleSet( pNewSet );
            else
                delete pNewSet;
		}
	}
    else
    {
        // delete all predefined module sets from the environment
        SiCompiledScript*   pCS = GETDLG()->GetCScript();
	    SiEnvironment*      pEnv = GETDLG()->GetEnv();
        const SiModSetList& rModSetList = pCS->GetModuleSetList();
        ULONG i = 0;
        ULONG j = 0;

        while ( i < pEnv->GetModuleSetList().Count() )
        {
		    BOOL bFound = FALSE;
            SiModuleSet *pSet = pEnv->GetModuleSetList().GetObject(i);
            ByteString aName = pSet->Name();

            for ( USHORT j = 0; j < rModSetList.Count(); j++ )
            {
                SiModulesSet*   pSet = rModSetList.GetObject( j );
                const SiModuleIdsList& rMIDLst = pSet->GetModuleIdsList();

                for( USHORT k = 0; k < rMIDLst.Count(); k++ )
                {
                    SiModuleIds* pIDs = rMIDLst.GetObject( k );
                    ByteString   aModName = pIDs->GetName();

                    if ( aName == aModName )
                    {
                        bFound = TRUE;
                        break;
                    }
                }

                if ( bFound )
                    break;
            }

            if ( bFound )
            {
                delete pSet;
                pEnv->GetModuleSetList().Remove( i );
            }
            else
                i++;
        }
    }

	return TRUE;
}

USHORT PageModules::GetReturnVal()
{
	if ( maRBUseOwn.IsChecked() )
        return RETURN_OWN;
    else
        return RETURN_PREDEFINED;
}

ULONG PageModules::GetProperty()
{
	ULONG nRet = maModuleList.GetSelectEntryPos();
    
    if ( maRBUseOwn.IsChecked() )
        nRet |= PROP_USE_OWN;

    return nRet;
}

void PageModules::InitProperty( ULONG nProp )
{
    BOOL    bFound, bUseOwn;
    USHORT  nPos;

    if ( nProp == PROP_NOTSET )
    {
        bFound = FALSE;
        bUseOwn = FALSE;
        nPos = 0;
    }
    else
    {
        bFound = TRUE;
        bUseOwn = ( nProp & PROP_USE_OWN ) ? TRUE : FALSE;
        nPos = (USHORT) ( nProp & ~PROP_USE_OWN );
    }

    // when we reopen an old responsefile, we have to check, wether
    // the user selected a predefined or an own module set
    
    if ( !bFound )
    {
        SiCompiledScript*   pCS = GETDLG()->GetCScript();
	    SiEnvironment*      pEnv = GETDLG()->GetEnv();
        const SiModSetList& rModSetList = pCS->GetModuleSetList();

        BOOL bFoundOne;

        for ( USHORT i = 0; i < rModSetList.Count(); i++ )
        {
            SiModulesSet*          pSet = rModSetList.GetObject( i );
            const SiModuleIdsList& rMIDLst = pSet->GetModuleIdsList();

            if ( rMIDLst.Count() )
                bFound = TRUE;
            
            for( USHORT j = 0; j < rMIDLst.Count(); j++ )
            {
                SiModuleIds* pIDs = rMIDLst.GetObject( j );
                ByteString   aModName = pIDs->GetName();
                bFoundOne = FALSE;

                for ( ULONG k = 0; k < pEnv->GetModuleSetList().Count(); k++ )
                {
		            SiModuleSet *pSet = pEnv->GetModuleSetList().GetObject(k);
                    ByteString aName = pSet->Name();
    
                    if ( aName == aModName )
                    {
                        bFoundOne = TRUE;
                        break;
                    }
                }
                if ( !bFoundOne )
                {
                    bFound = FALSE;
                    break;
                }
            }

            if ( bFound )
            {
                nPos = i+1;
                break;
            }
        }
    }

    maModuleList.SelectEntryPos( nPos );

	if( !bFound || bUseOwn )
	{
		maRBUseOwn.Check( TRUE );
		maModuleList.Enable( FALSE );
	}
	else
		maRBUseSet.Check( TRUE );

    ShowDesc();
}

///////////////////////////////////////////////////////////////////////////////

void PageModules::AddRecursive( SiModuleSet* pSet, SiModule* pMod )
{
    if ( !pMod )
        return;
    
    pSet->Add( pMod );

    const SiModuleList *pList = pMod->GetModuleList();

    for ( ULONG i=0; i<pList->Count(); i++ )
    {
        SiModule *pChild = pList->GetObject( i );
        AddRecursive( pSet, pChild );
    }
}


///////////////////////////////////////////////////////////////////////////////
// control handler
void PageModules::ShowDesc()
{
	USHORT nIdx = maModuleList.GetSelectEntryPos();
	if( maRBUseSet.IsChecked() && nIdx != LISTBOX_ENTRY_NOTFOUND )
	{
        SiModulesSet* pSet = (SiModulesSet*)maModuleList.GetEntryData( nIdx );
		if( pSet )
        {
            UniString aText;
            SiModulesSet* pLangRef = NULL;

            USHORT nLang = GETDLG()->GetLanguage();

            if( pSet->HasLangRef() )
            {
                pLangRef = (SiModulesSet*) pSet->GetLangRef( nLang );
                if( pLangRef )
                    pLangRef->JoinWithParent();
            }

            aText = pLangRef ?
                UniString( pLangRef->GetDescription(), Langcode2TextEncoding( nLang ) ) :
                UniString( pSet->GetDescription(),  Langcode2TextEncoding( nLang ) );

            maFTInfo3.SetText( aText );
        }
		else
			maFTInfo3.SetText( UniString() );
	}
	else
		maFTInfo3.SetText( UniString() );
}

IMPL_LINK( PageModules, ClickHdl, RadioButton*, pRadio )
{
	if( pRadio == &maRBUseSet )
		maModuleList.Enable( TRUE );
	else
		maModuleList.Enable( FALSE );
	ShowDesc();
	return 1;
}

IMPL_LINK( PageModules, SelectHdl, ListBox*, pLBox )
{
	ShowDesc();
	return 1;
}

