/*************************************************************************
 *
 *  $RCSfile: passtart.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:51:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "maindlg.hxx"
#include "environ.hxx"

#include "passtart.hxx"
#include "passtart.hrc"

#define PROP_USERCFG	1
#define PROP_NOUSERCFG	0

PageASrvStart::PageASrvStart( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aCBInstNow		( this, ResId(CB_INSTUSER, rResId.GetResMgr()) )
{
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	pParent->SetTitleStr( aTitle );

	FreeResource();

	aCBInstNow.SetClickHdl( LINK(this, PageASrvStart, ClickHdl) );
}

PageASrvStart::~PageASrvStart()
{
}

SvAgentPage* PageASrvStart::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageASrvStart( pParent, rResId );
}

USHORT PageASrvStart::GetReturnVal()
{
	if( !aCBInstNow.IsChecked() )
	{
		SiClientList& rList = GETDLG()->GetEnv()->GetClientNameList();
		for( USHORT i = 0; i < rList.Count(); ++ i )
		{
			AppServerClient* pUser = rList.GetObject( i );
			delete pUser;
		}
		rList.Clear();
		return RETURN_LATER;
	}
	return RETURN_NOW;
}

ULONG PageASrvStart::GetProperty()
{
	SiEnvironment* pEnv = GETDLG()->GetEnv();
	if( aCBInstNow.IsChecked() )
	{
		pEnv->SetKeepOldAppServer( FALSE );
		return PROP_USERCFG;
	}

	return PROP_NOUSERCFG;
}

void PageASrvStart::InitProperty(ULONG nProp)
{
	if( nProp != PROP_NOTSET )
		if( nProp == PROP_USERCFG )
			aCBInstNow.Check(TRUE);
		else
			aCBInstNow.Check(FALSE);
}

IMPL_LINK(PageASrvStart, ClickHdl, Control*, pCtrl)
{
	return 1;
}

