/*************************************************************************
 *
 *  $RCSfile: regmimetypes.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: tra $ $Date: 2001/12/05 14:35:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
 
#ifndef _REGMIMETYPES_HXX_
#include "regmimetypes.hxx"
#endif

#include <tools/config.hxx>
#include <osl/thread.h>
#include <osl/diagnose.h>
#include <osl/security.hxx>
#include <rtl/byteseq.h>
#include <algorithm>
#include "listinitializer.hxx"
#include <algorithm>

//---------------------------------------
// namespace directives 
//---------------------------------------

using namespace osl;
using namespace rtl;

//---------------------------------------
// extern declarations
//---------------------------------------

extern "C" BOOL _SV_CALL CustomInit( SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc );

//--------------------------------------------
// constants
//--------------------------------------------

const OUString FILE_NAME_MIME_TYPES    = OUString::createFromAscii( ".mime.types" );
const OUString FILE_NAME_MAILCAP       = OUString::createFromAscii( ".mailcap" );
const OString  SOFFICE_EXECUTABLE_NAME = "soffice";

const sal_Char SLASH                   = '/';

//---------------------------------------
// globals 
//---------------------------------------

SiSetupFnc aSetupFnc;

//--------------------------------------------
//
//--------------------------------------------

bool SAL_CALL installQueryIncludeModule( BOOL bIsSelected, BOOL bIsInstalled )
{
    return ( bIsSelected );
}

//--------------------------------------------
//
//--------------------------------------------

bool SAL_CALL deinstallQueryIncludeModule( BOOL bIsSelected, BOOL bIsInstalled )
{
    return ( bIsInstalled );
}

//--------------------------------------------
//
//--------------------------------------------

bool SAL_CALL modifyInstallQueryIncludeModule( BOOL bIsSelected, BOOL bIsInstalled )
{
    return ( bIsSelected && !bIsInstalled );
}

//--------------------------------------------
//
//--------------------------------------------

bool SAL_CALL modifyDeinstallQueryIncludeModule( BOOL bIsSelected, BOOL bIsInstalled )
{
    return ( bIsSelected && bIsInstalled );
}

//--------------------------------------------
//
//--------------------------------------------

void SAL_CALL setupModuleList( SiCustomModuleList* pModList, const QueryIncludeModuleFnc_t pfncQryIncMod, OStringList_t& aInstModList )
{
    OSL_PRECOND( pModList, "invalid module list" );
    OSL_PRECOND( pfncQryIncMod, "invalid function pointer" );
    
    aInstModList.clear();
    
    sal_Int32 nModules = pModList->Count();
    SiCustomModuleInfo* pModInf;
    
    for ( sal_Int32 i = 0; i < nModules; i++ )
    {
        pModInf = pModList->GetObject(i);
        
        if ( pfncQryIncMod( pModInf->IsSelected(), pModInf->IsInstalled() ) )
            aInstModList.push_back( pModInf->GetModuleID() );
    }    
}

//--------------------------------------------
//
//--------------------------------------------

void setupMimeTypeList( const ByteString& aCodeFileName, const OStringList_t& aModList, OStringList_t& aList )
{
    Config aConfig(XubString( aCodeFileName, osl_getThreadTextEncoding()));
    MimeTypeListInitializer aMTLI( aConfig, aList ); 
    std::for_each( aModList.begin(), aModList.end(), aMTLI );
}

//--------------------------------------------
//
//--------------------------------------------

void setupMailcapList( const ByteString& aCodeFileName, const OStringList_t& aModList, const OString& aInstPath, OStringList_t& aList )
{
    Config aConfig(XubString(aCodeFileName, osl_getThreadTextEncoding()));
    MailcapListInitializer aMCLI( aConfig, aList, aInstPath );
    std::for_each( aModList.begin(), aModList.end(), aMCLI );
}

//--------------------------------------------
//
//--------------------------------------------

OUString makeAbsPathInHomeDir( const OUString& aFilename )
{
    osl::Security security;
    OUString homeDir;

    security.getHomeDir( homeDir );

    OUString fileUrl;
    FileBase::getAbsoluteFileURL( homeDir, aFilename, fileUrl );

    return fileUrl;
}

//--------------------------------------------
//
//--------------------------------------------

OString SAL_CALL makeAbsPath( const OString& aBasePath, const OString& aRelPath )
{
    OString absPath = aBasePath;

    if ( absPath.lastIndexOf( SLASH ) != (absPath.getLength( ) - 1) )
        absPath += OString( SLASH );

    absPath += aRelPath;
    return absPath;
}

//--------------------------------------------
// we could improve the algorithm if we would
// read the complete file content, add our
// entries and remove duplicates before writing
// the new file content, so we would avoid
// duplicates because entries may remain in
// case of a dirty deinstallation ect.
//--------------------------------------------

void SAL_CALL fileAddEntries( const OUString& aFileName, OStringList_t& aEntryList )
{
    if ( 0 == aEntryList.size() )
        return;
    
    OUString absFilename = makeAbsPathInHomeDir( aFileName );
    
    File file( absFilename );

    FileBase::RC rc = fileEnsureOpen( file, OpenFlag_Read | OpenFlag_Write );
        
    if ( FileBase::E_None == rc )
    {
        OStringList_t aFileContent;
        fileReadAllLines( file, aFileContent );

        // add file content to new entry list
        std::copy( 
            aFileContent.begin(), 
            aFileContent.end(), 
            std::back_inserter(aEntryList) );
        
        fileReplaceContent( file, aEntryList );           
    }
}

//--------------------------------------------
//
//--------------------------------------------

void SAL_CALL fileRemoveEntries( const OUString& aFileName, const OStringList_t& aListOfRemoveableLines )
{
    if ( 0 == aListOfRemoveableLines.size() )
        return;

    OUString absFilename = makeAbsPathInHomeDir( aFileName );
    
    File file( absFilename );

    FileBase::RC rc = file.open( OpenFlag_Read | OpenFlag_Write );
        
    if ( FileBase::E_None == rc )
    {
        OStringList_t aFileContent;
        fileReadAllLines( file, aFileContent );

        OStringList_t::iterator pos = std::remove_if( 
            aFileContent.begin(), 
            aFileContent.end(), 
            FileRemoveEntryHelper(aListOfRemoveableLines));
        
        aFileContent.erase(pos, aFileContent.end());
        
        if ( aFileContent.size() > 0 )
        {
            fileReplaceContent( file, aFileContent );
        }
        else
        {
            rc = file.close( );
            
            if ( FileBase::E_None == rc )
                File::remove( absFilename );
        }
    }
}

//---------------------------------------
// EntryPoint for setup plug-ins
// called by the setup
//---------------------------------------

BOOL _SV_CALL CustomInit(SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc)
{
	// inkompatibel oder nicht vorhanden ?
	if( !pSetupFnc || pSetupFnc->nVersion > SICUSTOM_VERSION )
		return FALSE;

	pCustomFnc->fncMain = (FncPtrCustomMain)CustomMain;

	aSetupFnc.nVersion 		     = pSetupFnc->nVersion;
	aSetupFnc.fncHideSetup	     = pSetupFnc->fncHideSetup;
	aSetupFnc.fncShowSetup	     = pSetupFnc->fncShowSetup;
    aSetupFnc.fncGetCodeFilename = pSetupFnc->fncGetCodeFilename;

	return TRUE;
}

//---------------------------------------
// CustomMain of setup plug-in
// called by the setup
//---------------------------------------

BOOL _SV_CALL CustomMain(SiCustomEnvironment* pEnv, SiCustomModuleList* pList)
{
    OStringList_t aMimeTypeList;
    OStringList_t aMailcapList;
    OStringList_t aModuleList;
    
    ByteString strCodeFilename = aSetupFnc.fncGetCodeFilename();
    
    if ( IsInstallation( pEnv ) )
    {
        setupModuleList( pList, installQueryIncludeModule, aModuleList );
        
        setupMimeTypeList( strCodeFilename, aModuleList, aMimeTypeList );
        
        setupMailcapList( 
            strCodeFilename, 
            aModuleList, 
            makeAbsPath( pEnv->GetDestPath( ), SOFFICE_EXECUTABLE_NAME ),
            aMailcapList ); 
            
        fileAddEntries( FILE_NAME_MIME_TYPES, aMimeTypeList );
        fileAddEntries( FILE_NAME_MAILCAP, aMailcapList );
    }    
    else if ( IsSetupModification( pEnv ) )
    {
        // handle possible installation 
        
        setupModuleList( pList, modifyInstallQueryIncludeModule, aModuleList );

        setupMimeTypeList( strCodeFilename, aModuleList, aMimeTypeList );
        
        setupMailcapList( 
            strCodeFilename, 
            aModuleList, 
            makeAbsPath( pEnv->GetDestPath( ), SOFFICE_EXECUTABLE_NAME ),
            aMailcapList ); 
                    
        fileAddEntries( FILE_NAME_MIME_TYPES, aMimeTypeList );
        fileAddEntries( FILE_NAME_MAILCAP, aMailcapList );

        // handle possible deinstallation 
        
        setupModuleList( pList, modifyDeinstallQueryIncludeModule, aModuleList );

        setupMimeTypeList( 
            strCodeFilename, 
            aModuleList, 
            aMimeTypeList );    
        
        setupMailcapList(
            strCodeFilename,
            aModuleList,
            makeAbsPath( pEnv->GetDestPath( ), SOFFICE_EXECUTABLE_NAME ),
            aMailcapList );
        
        fileRemoveEntries( FILE_NAME_MIME_TYPES, aMimeTypeList );
        fileRemoveEntries( FILE_NAME_MAILCAP, aMailcapList ); 
    }
    else if ( IsDeinstallation( pEnv ) ) 
    {
        setupModuleList( pList, deinstallQueryIncludeModule, aModuleList );
        
        setupMimeTypeList( 
            strCodeFilename, 
            aModuleList, 
            aMimeTypeList );    
        
        setupMailcapList(
            strCodeFilename,
            aModuleList,
            makeAbsPath( pEnv->GetDestPath( ), SOFFICE_EXECUTABLE_NAME ),
            aMailcapList );
        
        fileRemoveEntries( FILE_NAME_MIME_TYPES, aMimeTypeList );
        fileRemoveEntries( FILE_NAME_MAILCAP, aMailcapList );
    }
    
    return TRUE;
}
