/*************************************************************************
 *
 *  $RCSfile: moffice.cxx,v $
 *
 *  $Revision: 1.14.4.2 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 10:05:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMEREPLACE_HPP_
#include <com/sun/star/container/XNameReplace.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XCHANGESBATCH_HPP_
#include <com/sun/star/util/XChangesBatch.hpp>
#endif
#ifndef _CPPUHELPER_SERVICEFACTORY_HXX_
#include <cppuhelper/servicefactory.hxx>
#endif

#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif

#ifndef _SV_CONFIG_HXX
#include <tools/config.hxx>
#endif

#include "os.hxx"
#include "moffice.hxx"
#include "environ.hxx"

#ifdef UNX
#define OFFICE_INI		"sofficerc"
//#define ADRBKMAP_INI    "addrconvrc"
#include <string.h>
#else
#define OFFICE_INI		"soffice.ini"
//#define ADRBKMAP_INI    "addrconv.ini"
#endif

using namespace com::sun::star;

/////////////////////////////////////////////////////////////////////////////
//
// class MigrationTask_OfficeIniSettings
//
// - designed for data migration from 5.2 to 6.0
// - reads values from soffice.ini of existing installation and writes the
//   accoding entries into configuration database of new installation.
//
/////////////////////////////////////////////////////////////////////////////

class MigrationTask_OfficeIniSettings : public SetupMigrationTask
{
    uno::Reference< lang::XMultiServiceFactory > m_xSMgr;

private:
    void copyUserSettings( const SiDirEntry & rOfficeIni,
                           const uno::Reference<
                                lang::XMultiServiceFactory > & xCfgProvider );
    void copyINetSettings( const SiDirEntry & rOfficeIni,
                           const uno::Reference<
                                lang::XMultiServiceFactory > & xCfgProvider );
public:
    MigrationTask_OfficeIniSettings( SetupMigrationPlugin* pPlugin );
    virtual ULONG Execute( MigrationExecType eTyp, SiEnvironment* pEnv );
};

/////////////////////////////////////////////////////////////////////////////
//
// class MigrationTask_MessageConvertSupport
//
// - designed for data migration from 5.2 to 6.0
// - copies files to 5.2 installation(!)
// - 5.2 can be used afterwards to convert any sdm/smd files (MIME messages
//   saved in proprietary format) to MBX format, that can be imported by
//   Netscape 4 or Mozilla, for example.
//
/////////////////////////////////////////////////////////////////////////////

class MigrationTask_MessageConvertSupport : public SetupMigrationTask
{
public:
    MigrationTask_MessageConvertSupport( SetupMigrationPlugin* pPlugin );
    virtual ULONG Execute( MigrationExecType eTyp, SiEnvironment* pEnv );
};

/////////////////////////////////////////////////////////////////////////////
//	StarOffice migration plugin base class
// initialise static instance

SetupMigrationPlugin* pPlugin = new OfficeMigrationDaisy;

OfficeMigrationDaisy::OfficeMigrationDaisy()
{
    AddTask( new MigrationTask_OfficeIniSettings( this ) );
    AddTask( new MigrationTask_MessageConvertSupport( this ) );
    AddTask( new MigrationTask_CopyFiles( this ) );
}

BOOL OfficeMigrationDaisy::SupportMigrationFor( const ByteString& rKey )
{
	if( rKey.CompareIgnoreCaseToAscii("StarOffice 5.2") == COMPARE_EQUAL )
		return TRUE;
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//	copy file task
MigrationTask_CopyFiles::MigrationTask_CopyFiles( SetupMigrationPlugin* pPlugin ) :
	SetupMigrationTask( pPlugin )
{
}

ULONG MigrationTask_CopyFiles::ExecuteAction( const SiDirEntry& rPath )
{
	ULONG nSize = 0;

	if( m_bDoRecursiveDir )
	{
		Dir aSubDir( rPath, FSYS_KIND_DIR | FSYS_KIND_DIR );
		for( USHORT i = 0; i < aSubDir.Count(); ++i )
		{
			UniString aFileName = aSubDir[i].GetName();
			ByteString aFull( aFileName, osl_getThreadTextEncoding() );
			if( aFull != "." && aFull != ".." )
				nSize += ExecuteAction( aSubDir[i] );
		}
	}

	Dir aDir( rPath, FSYS_KIND_FILE | FSYS_KIND_DIR );
	for( USHORT nDirIdx = 0; nDirIdx < aDir.Count(); ++nDirIdx )
	{
		UniString aFileName = aDir[nDirIdx].GetName();
		ByteString aFile( aFileName, osl_getThreadTextEncoding() );
		FileStat stat( aDir[nDirIdx] );

		if( !rPath.IsCaseSensitive() ) {
			m_aSrcMask.ToLowerAscii();
			aFile.ToLowerAscii();
		}

		SiDirEntry aAbsDestination( m_aDestinationPath );

		ByteString aRelPath( rPath.GetFull() );
		if( aRelPath.Len() > m_aSourcePath.GetFull().Len() )
		{
			aRelPath.Erase( 0,m_aSourcePath.GetFull().Len() + 1 );
			aAbsDestination += aRelPath;
		}

		if( m_bDoRecursiveDir && m_bDoEmptyDir && m_eTyp == EXECUTE )
			aAbsDestination.MakeDir();

		if( aFile.CompareIgnoreCaseToAscii(".") == COMPARE_EQUAL || aFile.CompareIgnoreCaseToAscii("..") == COMPARE_EQUAL ||
			stat.GetKind() == FSYS_KIND_DIR )
			continue;

		WildCard aMatch( UniString::CreateFromAscii(m_aSrcMask.GetBuffer()) );
		if( aMatch == UniString::CreateFromAscii(aFile.GetBuffer()) )
		{
			BOOL bDoAction = TRUE;
			SiDirEntry aAbsSource( rPath );
			aAbsSource += aFile;

			// neagation
			for( USHORT xx = 0; xx < m_aNegList.Count(); ++xx )
			{
				WildCard aNegationMatch( UniString::CreateFromAscii((*(m_aNegList.GetObject(xx))).GetBuffer()) );
				if( aNegationMatch == UniString::CreateFromAscii(aFile.GetBuffer()) )
				{
					bDoAction = FALSE;
					break;
				}
			}

			// timestamp
			if( bDoAction )
                for( USHORT xxx = 0; xxx < m_aDateTimeList.Count(); ++xxx )
                {
                    DateTime aDt( *(m_aDateTimeList.GetObject(xxx)) );
                    FileStat aFileStat( aAbsSource );
                    DateTime aFileDt( aFileStat.DateModified(), aFileStat.TimeModified() );

                    #ifdef UNX
                    aFileDt.ConvertToUTC();
                    #endif

                    if( aDt.GetDate() == aFileDt.GetDate() )
                    {
                        bDoAction = FALSE;
                        break;
                    }
                }

			if( bDoAction )
				switch( m_eTyp )
				{
					case CALCULATE_SIZE : {
						FileStat aFileStat( aAbsSource );
						nSize += aFileStat.GetSize();
						} break;
					case EXECUTE : {
						DirEntry aDestinationBase = aAbsDestination;
						if( m_bDoRecursiveDir || m_bDestIsPath )
							aAbsDestination += aFile;

						if( aAbsDestination.Exists() )
							for( USHORT i = 1; i < 32000; ++i )
							{
								SiDirEntry aTmp( aFile );
								ByteString aNew;
								aNew =  ByteString(aTmp.GetBase(), osl_getThreadTextEncoding());
								aNew += ByteString("[");
								aNew += ByteString::CreateFromInt32( i );
								aNew += ByteString("].");
								aNew += ByteString(aTmp.GetExtension(), osl_getThreadTextEncoding());

								aAbsDestination = aDestinationBase;
								aAbsDestination += aNew;
								if( !aAbsDestination.Exists() )
									break;
							}

						if( !aAbsDestination.GetPath().Exists() )
							aAbsDestination.GetPath().MakeDir();
#ifdef UNX
						char cDST[4096];
						char cSRC[4096];
						realpath( aAbsDestination.GetFull().GetBuffer(), cDST );
						realpath( aAbsSource.GetFull().GetBuffer(), cSRC );
						if( strcmp(cDST, cSRC) != 0 )
#endif
						{
							FileCopier aCpy( aAbsSource, aAbsDestination );
							aCpy.Execute();
						}
						} break;
				}
		}
	}

	return nSize;
}

ULONG MigrationTask_CopyFiles::Execute( MigrationExecType eTyp, SiEnvironment* pEnv )
{
	m_eTyp = eTyp;

	ULONG nSize = 0;
	Config aConfig( UniString::CreateFromAscii(m_pPlugin->GetCodeFileName().GetBuffer()) );
	aConfig.SetGroup( "CopyFileTask" );

	for( USHORT i = 0; i < aConfig.GetKeyCount(); ++i )
	{
		m_aSourcePath = pEnv->GetMigrationPath();
		m_aDestinationPath = pEnv->GetDestPath();

		ByteString aDestKey( aConfig.ReadKey(i) );
		aDestKey.EraseLeadingChars( '"' ); aDestKey.EraseTrailingChars( '"' );

		USHORT nTokenCount = aDestKey.GetTokenCount('|');

		ByteString aDestPath, aNegation, aDateTime, aRecursive;

		aDestPath	= aDestKey.GetToken( 0, '|' );
		aNegation	= aDestKey.GetToken( 1, '|' );
		aDateTime	= aDestKey.GetToken( 2, '|' );
		aRecursive	= aDestKey.GetToken( 3, '|' );

		aDestPath.EraseLeadingChars(); aDestPath.EraseTrailingChars();
		aNegation.EraseLeadingChars(); aNegation.EraseTrailingChars();
		aDateTime.EraseLeadingChars(); aDateTime.EraseTrailingChars();
		aRecursive.EraseLeadingChars(); aRecursive.EraseTrailingChars();

		if( aNegation.Len() )
		{
			USHORT nNegTokenCount = aNegation.GetTokenCount(' ');
			for( USHORT x = 0; x < nNegTokenCount; ++x )
			{
				ByteString* pStr = new ByteString( aNegation.GetToken(x, ' ') );
				pStr->EraseLeadingChars(); pStr->EraseTrailingChars();
				m_aNegList.Insert( pStr, LIST_APPEND );
			}
		}
		if( aDateTime.Len() )
		{
			USHORT nDateTimeCount = aDateTime.GetTokenCount(' ');
			for( USHORT x = 0; x < nDateTimeCount; ++x )
			{
				ByteString aTmp( aDateTime.GetToken(x) );
				aTmp.EraseLeadingChars(); aTmp.EraseTrailingChars();

				DateTime* pDateTime = new DateTime;

				pDateTime->SetDay( aTmp.Copy(0,2).ToInt32() );
				pDateTime->SetMonth( aTmp.Copy(2,2).ToInt32() );
				pDateTime->SetYear( aTmp.Copy(4,4).ToInt32() );

				m_aDateTimeList.Insert( pDateTime, LIST_APPEND );
			}
		}

		m_bDoRecursiveDir = FALSE;
		m_bDestIsPath = FALSE;
		m_bDoEmptyDir = ((USHORT)aRecursive.ToInt32() == 0)? FALSE : TRUE;

		ByteString aKey( aConfig.GetKeyName(i) );
		aKey.EraseLeadingChars( '"' ); aKey.EraseTrailingChars( '"' );

		if( aKey.GetChar(aKey.Len()-1) == '/' )
			m_bDoRecursiveDir = TRUE;
		if( aDestPath.GetChar(aDestPath.Len()-1) == '/' )
			m_bDestIsPath = TRUE;

		m_aSourcePath += aKey;
#ifdef WNT
		if( aDestPath.Search("<") != STRING_NOTFOUND )
			aDestPath.SearchAndReplace( "<mydocuments>", ByteString(WinOS::SHGetPersonalFolderName(), osl_getThreadTextEncoding()) );
#endif
#ifdef UNX
		if( aDestPath.Search("<") != STRING_NOTFOUND )
			aDestPath.SearchAndReplace( "<mydocuments>", UnixOS::GetHomeDir().GetFull() );
#endif
		m_aDestinationPath += aDestPath;

		m_aSourcePath.ToAbs();
		m_aDestinationPath.ToAbs();

		if( m_bDoRecursiveDir && m_aSourcePath.Exists() ||
			!m_bDoRecursiveDir && m_aSourcePath.GetPath().Exists() )
		{
			if( m_bDoRecursiveDir )
				m_aSrcMask = "*";
			else
				m_aSrcMask = ByteString(m_aSourcePath.CutName(), osl_getThreadTextEncoding());

			nSize += ExecuteAction( m_aSourcePath );
		}

		for( USHORT x = 0; x < m_aDateTimeList.Count(); ++x )
			delete m_aDateTimeList.GetObject(x);
		m_aDateTimeList.Clear();

		for( USHORT xx = 0; xx < m_aNegList.Count(); ++xx )
			delete m_aNegList.GetObject(xx);
		m_aNegList.Clear();
	}
	return nSize;
}

/////////////////////////////////////////////////////////////////////////////
//
// MigrationTask_OfficeIniSettings Implementation
//
/////////////////////////////////////////////////////////////////////////////

MigrationTask_OfficeIniSettings::MigrationTask_OfficeIniSettings(
                                            SetupMigrationPlugin* pPlugin )
: SetupMigrationTask( pPlugin )
{
}

/////////////////////////////////////////////////////////////////////////////
ULONG MigrationTask_OfficeIniSettings::Execute(
                        MigrationExecType eTyp, SiEnvironment* pEnv )
{
    switch ( eTyp )
	{
        case CALCULATE_SIZE:
            // No files to copy...
            return 0;

        case EXECUTE:
        {
            SiDirEntry aOfficeIni( pEnv->GetMigrationPath() );
            aOfficeIni += ByteString( "user" );
            aOfficeIni += ByteString( OFFICE_INI );

            if ( !aOfficeIni.Exists() )
                break;

            SiDirEntry aApplicat( pEnv->GetInstallType() == IT_WORKSTATION
                                  /*|| m_eInstallMode == IM_WORKSTATION */
                                  ? pEnv->GetSourcePath()
                                  : pEnv->GetDestPath() );

            aApplicat += ByteString( "program" );
            aApplicat += ByteString( "applicat.rdb" );
			aApplicat.ToAbs();

            m_xSMgr = cppu::createRegistryServiceFactory(
                        aApplicat.GetFullUni(), sal_True /* read-only */ );

            if ( !m_xSMgr.is() )
                break;

            uno::Reference< lang::XMultiServiceFactory > xCfgProvider;

            try
            {
                uno::Sequence< uno::Any > aCPArgs( 3 );

                beans::PropertyValue aPropertyUser(
                            rtl::OUString::createFromAscii( "servertype" ),
                            -1,
                            uno::makeAny(
                                rtl::OUString::createFromAscii( "local" ) ),
                            beans::PropertyState_DIRECT_VALUE );
                aCPArgs[ 0 ] <<= aPropertyUser;

                SiDirEntry aSourcePath( pEnv->GetInstallType() == IT_WORKSTATION
                                        /*|| m_eInstallMode == IM_WORKSTATION */
                                        ? pEnv->GetSourcePath()
                                        : pEnv->GetDestPath() );
                aSourcePath += ByteString( "share" );
                aSourcePath += ByteString( "config" );
                aSourcePath += ByteString( "registry" );
                aSourcePath.ToAbs();

                aPropertyUser = beans::PropertyValue(
                            rtl::OUString::createFromAscii( "sourcepath" ),
                            -1,
                            uno::makeAny(
                                rtl::OUString::createFromAscii(
                                    aSourcePath.GetFull().GetBuffer() ) ),
                            beans::PropertyState_DIRECT_VALUE );
                aCPArgs[ 1 ] <<= aPropertyUser;

                if ( pEnv->GetInstallType() == IT_WORKSTATION
                     /* || m_eInstallMode == IM_WORKSTATION */ )
                {
                    SiDirEntry aUpdatePath = pEnv->GetDestPath();
                    aUpdatePath += ByteString( "user" );
                    aUpdatePath += ByteString( "config" );
                    aUpdatePath += ByteString( "registry" );
                    aUpdatePath.ToAbs();

                    aPropertyUser = beans::PropertyValue(
                            rtl::OUString::createFromAscii( "updatepath" ),
                            -1,
                            uno::makeAny(
                                rtl::OUString::createFromAscii(
                                    aUpdatePath.GetFull().GetBuffer() ) ),
                            beans::PropertyState_DIRECT_VALUE );
                    aCPArgs[ 2 ] <<= aPropertyUser;

                    xCfgProvider = uno::Reference< lang::XMultiServiceFactory >(
                                        m_xSMgr->createInstanceWithArguments(
                                            rtl::OUString::createFromAscii(
                                                "com.sun.star.configuration"
                                                ".ConfigurationProvider" ),
                                            aCPArgs ),
                                        uno::UNO_QUERY );
                }
                else
                {
                    aPropertyUser = beans::PropertyValue(
                            rtl::OUString::createFromAscii( "reinitialize" ),
                            -1,
                            uno::makeAny( sal_Bool( sal_True ) ),
                            beans::PropertyState_DIRECT_VALUE );
                    aCPArgs[ 2 ] <<= aPropertyUser;

                    xCfgProvider = uno::Reference< lang::XMultiServiceFactory >(
                                        m_xSMgr->createInstanceWithArguments(
                                            rtl::OUString::createFromAscii(
                                                "com.sun.star.configuration"
                                                ".AdministrationProvider" ),
                                            aCPArgs ),
                                        uno::UNO_QUERY );
                }
            }
            catch ( uno::RuntimeException const & )
            {
            }
            catch ( uno::Exception const & )
            {
            }

            if ( !xCfgProvider.is() )
                break;

            copyUserSettings( aOfficeIni, xCfgProvider );
            copyINetSettings( aOfficeIni, xCfgProvider );

			break;
        }
	}
    return 0;
}

/////////////////////////////////////////////////////////////////////////////
void MigrationTask_OfficeIniSettings::copyUserSettings(
        const SiDirEntry & rOfficeIni,
        const uno::Reference< lang::XMultiServiceFactory > & xCfgProvider )
{
    // Open data source...
    Config aSrcCfg( rOfficeIni.GetFullUni() );
	aSrcCfg.SetGroup( "User" );

    // Open data sink...
    uno::Reference< uno::XInterface > xConfigAccess;
    try
    {
        uno::Sequence< uno::Any > aArgs( 1 );
        beans::PropertyValue aProperty(
                    rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "nodepath" ) ),
                    -1,
                    uno::makeAny(
                        rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
                            "org.openoffice.UserProfile/Data" ) ) ),
                    beans::PropertyState_DIRECT_VALUE );
        aArgs[ 0 ] <<= aProperty;

        // Create configuration read-write access object.
        xConfigAccess = xCfgProvider->createInstanceWithArguments(
                                rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
                                        "com.sun.star.configuration"
                                        ".ConfigurationUpdateAccess" ) ),
                                aArgs );
    }
    catch ( uno::RuntimeException const & )
    {
    }
    catch ( uno::Exception const & )
    {
    }

    if ( xConfigAccess.is() )
    {
        uno::Reference< util::XChangesBatch > xBatch(
                                    xConfigAccess, uno::UNO_QUERY );
        uno::Reference< container::XNameReplace > xNameReplace(
                                    xConfigAccess, uno::UNO_QUERY );

        if ( xBatch.is() && xNameReplace.is() )
        {
            try
            {
                //////////////////////////////////////////////////////////
                // Set values.
                //////////////////////////////////////////////////////////

                // Initials
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "initials" ) ),
                    uno::makeAny(
                        rtl::OUString( aSrcCfg.ReadKey( "User-Id",
                                         osl_getThreadTextEncoding() ) ) ) );

                // Last Name
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "sn" ) ),
                    uno::makeAny(
                        rtl::OUString( aSrcCfg.ReadKey( "User-Name",
                                         osl_getThreadTextEncoding() ) ) ) );

                // First Name
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "givenname" ) ),
                    uno::makeAny(
                        rtl::OUString( aSrcCfg.ReadKey( "User-FirstName",
                                         osl_getThreadTextEncoding() ) ) ) );

                UniString aAddress( aSrcCfg.ReadKey( "User-Adress",
                                        osl_getThreadTextEncoding() ) );
                USHORT nDelimTok = 0;

                // Company
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "o" ) ),
                    uno::makeAny(
                        rtl::OUString(
                            aAddress.GetToken( 0, '#', nDelimTok ) ) ) );

                // Street
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "street" ) ),
                    uno::makeAny(
                        rtl::OUString(
                            aAddress.GetToken( 0, '#', nDelimTok ) ) ) );

                // Country
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "c" ) ),
                    uno::makeAny(
                        rtl::OUString(
                            aAddress.GetToken( 0, '#', nDelimTok ) ) ) );

                // Zip code
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "postalcode" ) ),
                    uno::makeAny(
                        rtl::OUString(
                            aAddress.GetToken( 0, '#', nDelimTok ) ) ) );

                // City
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "l" ) ),
                    uno::makeAny(
                        rtl::OUString(
                            aAddress.GetToken( 0, '#', nDelimTok ) ) ) );

                // Title
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "title" ) ),
                    uno::makeAny(
                        rtl::OUString(
                            aAddress.GetToken( 0, '#', nDelimTok ) ) ) );

                // Position
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "position" ) ),
                    uno::makeAny(
                        rtl::OUString(
                            aAddress.GetToken( 0, '#', nDelimTok ) ) ) );

                // Phone (Home)
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "homephone" ) ),
                    uno::makeAny(
                        rtl::OUString(
                            aAddress.GetToken( 0, '#', nDelimTok ) ) ) );

                // Phone (Work)
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "telephonenumber" ) ),
                    uno::makeAny(
                        rtl::OUString(
                            aAddress.GetToken( 0, '#', nDelimTok ) ) ) );

                // Fax
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "facsimiletelephonenumber" ) ),
                    uno::makeAny(
                        rtl::OUString(
                            aAddress.GetToken( 0, '#', nDelimTok ) ) ) );

                // Email
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "mail" ) ),
                    uno::makeAny(
                        rtl::OUString(
                            aAddress.GetToken( 0, '#', nDelimTok ) ) ) );

                // State
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "st" ) ),
                    uno::makeAny(
                        rtl::OUString(
                            aAddress.GetToken( 0, '#', nDelimTok ) ) ) );

                //////////////////////////////////////////////////////////
                // Commit changes.
                //////////////////////////////////////////////////////////

                xBatch->commitChanges();
            }
            catch ( lang::IllegalArgumentException const & )
            {
                // replaceByName
            }
            catch ( container::NoSuchElementException const & )
            {
                // replaceByName
            }
            catch ( lang::WrappedTargetException const & )
            {
                // commitChanges, replaceByName
            }
            catch ( uno::RuntimeException const & )
            {
                // commitChanges, replaceByName
            }
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
void MigrationTask_OfficeIniSettings::copyINetSettings(
        const SiDirEntry & rOfficeIni,
        const uno::Reference< lang::XMultiServiceFactory > & xCfgProvider )
{
    // #86943# - We do not migrate, if system proxy settings are available.
    bool bCopyProxySettings = true;
    try
    {
        uno::Reference< uno::XInterface > xProxySettings
            = m_xSMgr->createInstance(
                        rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
                            "com.sun.star.system.SystemProxySettings" ) ) );
        bCopyProxySettings = !xProxySettings.is();
    }
    catch ( uno::Exception const & )
    {
    }

    // Open data source...
    Config aSrcCfg( rOfficeIni.GetFullUni() );
    aSrcCfg.SetGroup( "INet" );

    // Open data sink...
    uno::Reference< uno::XInterface > xConfigAccess;
    try
    {
        uno::Sequence< uno::Any > aArgs( 1 );
        beans::PropertyValue aProperty(
                    rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "nodepath" ) ),
                    -1,
                    uno::makeAny(
                        rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
                            "org.openoffice.Inet/Settings" ) ) ),
                    beans::PropertyState_DIRECT_VALUE );
        aArgs[ 0 ] <<= aProperty;

        // Create configuration read-write access object.
        xConfigAccess = xCfgProvider->createInstanceWithArguments(
                                rtl::OUString( RTL_CONSTASCII_USTRINGPARAM(
                                        "com.sun.star.configuration"
                                        ".ConfigurationUpdateAccess" ) ),
                                aArgs );
    }
    catch ( uno::RuntimeException const & )
    {
    }
    catch ( uno::Exception const & )
    {
    }

    if ( xConfigAccess.is() )
    {
        uno::Reference< util::XChangesBatch > xBatch(
                                    xConfigAccess, uno::UNO_QUERY );
        uno::Reference< container::XNameReplace > xNameReplace(
                                    xConfigAccess, uno::UNO_QUERY );

        if ( xBatch.is() && xNameReplace.is() )
        {
            try
            {
                //////////////////////////////////////////////////////////
                // Set values.
                //////////////////////////////////////////////////////////

                uno::Any aValue;

                // DNS Server
                aValue <<= rtl::OUString(
                            aSrcCfg.ReadKey( "DNS",
                                             osl_getThreadTextEncoding() ) );

                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "ooInetDNSServer" ) ),
                    aValue );

                // #86943# - We do not migrate, if system proxy settings
                // are available.
                if ( !bCopyProxySettings )
                    return;

                // Proxy Type ( 0 - None, 1 - Auto, 2 - Manual )
                sal_Int32 nType
                    = rtl::OUString(
                            aSrcCfg.ReadKey( "ProxyType",
                                             osl_getThreadTextEncoding() ) )
                        .toInt32();

                // Note: 1 not available in 6.0 : Convert to 2
                if ( nType > 0 )
                    nType = 2;

                aValue <<= nType;

                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "ooInetProxyType" ) ),
                    aValue );

                // HTTP Proxy Name
                aValue <<= rtl::OUString(
                            aSrcCfg.ReadKey( "HTTPProxyName",
                                             osl_getThreadTextEncoding() ) );
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "ooInetHTTPProxyName" ) ),
                        aValue );

                // HTTP Proxy Port
                aValue <<= rtl::OUString(
                            aSrcCfg.ReadKey( "HTTPProxyPort",
                                             osl_getThreadTextEncoding() ) )
                            .toInt32();

                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "ooInetHTTPProxyPort" ) ),
                    aValue );

                // FTP Proxy Name
                aValue <<= rtl::OUString(
                            aSrcCfg.ReadKey( "FTPProxyName",
                                             osl_getThreadTextEncoding() ) );
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "ooInetFTPProxyName" ) ),
                    aValue );

                // FTP Proxy Port
                aValue <<= rtl::OUString(
                            aSrcCfg.ReadKey( "FTPProxyPort",
                                             osl_getThreadTextEncoding() ) )
                            .toInt32();

                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "ooInetFTPProxyPort" ) ),
                    aValue );

                // SOCKS Proxy Name
                aValue <<= rtl::OUString(
                            aSrcCfg.ReadKey( "SOCKSProxyName",
                                             osl_getThreadTextEncoding() ) );
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "ooInetSOCKSProxyName" ) ),
                    aValue );

                // SOCKS Proxy Port
                aValue <<= rtl::OUString(
                            aSrcCfg.ReadKey( "SOCKSProxyPort",
                                             osl_getThreadTextEncoding() ) )
                            .toInt32();

                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "ooInetSOCKSProxyPort" ) ),
                    aValue );

                // No Proxy List
                aValue <<= rtl::OUString(
                            aSrcCfg.ReadKey( "NoProxy",
                                             osl_getThreadTextEncoding() ) );
                xNameReplace->replaceByName(
                    rtl::OUString(
                        RTL_CONSTASCII_USTRINGPARAM( "ooInetNoProxy" ) ),
                    aValue );

                //////////////////////////////////////////////////////////
                // Commit changes.
                //////////////////////////////////////////////////////////

                xBatch->commitChanges();
            }
            catch ( lang::IllegalArgumentException const & )
            {
                // replaceByName
            }
            catch ( container::NoSuchElementException const & )
            {
                // replaceByName
            }
            catch ( lang::WrappedTargetException const & )
            {
                // commitChanges, replaceByName
            }
            catch ( uno::RuntimeException const & )
            {
                // commitChanges, replaceByName
            }
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// MigrationTask_MessageConvertSupport Implementation
//
/////////////////////////////////////////////////////////////////////////////

MigrationTask_MessageConvertSupport::MigrationTask_MessageConvertSupport(
                                            SetupMigrationPlugin* pPlugin )
: SetupMigrationTask( pPlugin )
{
}

/////////////////////////////////////////////////////////////////////////////
ULONG MigrationTask_MessageConvertSupport::Execute(
                        MigrationExecType eTyp, SiEnvironment* pEnv )
{
    switch ( eTyp )
	{
        case CALCULATE_SIZE:
        {
            // @@@ Does not work, because this code will be executed
            //     very erly during setup. The files are not yet
            //     unpacked, even destination directory is not set.
/*
            SiDirEntry aSourceDir( pEnv->GetDestPath() );
            aSourceDir += ByteString( "share" );
            aSourceDir += ByteString( "migration" );

            if ( !aSourceDir.Exists() )
                break;

            ULONG nSize = 0;

            Dir aDir( aSourceDir, FSYS_KIND_FILE );
            for( USHORT nDirIdx = 0; nDirIdx < aDir.Count(); ++nDirIdx )
            {
                FileStat aFileStat( aDir[ nDirIdx ] );
                nSize += aFileStat.GetSize();
            }
            return nSize;
*/
            break;
        }

        case EXECUTE:
        {
            SiDirEntry aSourceDir( pEnv->GetDestPath() );
            aSourceDir += ByteString( "share" );
            aSourceDir += ByteString( "migration" );

            if ( !aSourceDir.Exists() )
                break;

            SiDirEntry aDestDir( pEnv->GetMigrationPath() );

            //------------------------------------------------------------
            // libmbx569??.so ( unix only )
            // mbx569??.dll ( win & co only )
            SiDirEntry aSource( aSourceDir );

            SiDirEntry aDest  ( aDestDir );
            aDest += ByteString( "program" );

            // Note: FileCopier does not support wild cards.
            WildCard aPattern( String::CreateFromAscii( "*mbx569*" ) );
            Dir aDir( aSource, FSYS_KIND_FILE );
            for ( USHORT nDirIdx = 0; nDirIdx < aDir.Count(); ++nDirIdx )
            {
                String aFileName = aDir[ nDirIdx ].GetName();
                if ( aPattern.Matches( aFileName ) )
                {
                    FileCopier aCpy1( aDir[ nDirIdx ], aDest );
                    aCpy1.Execute();
                }
            }

            //------------------------------------------------------------
            // MailConvert.sdw
            aSource = aSourceDir;
            aSource += ByteString( "MailConvert.sdw" );

            aDest   = aDestDir;
            aDest   += ByteString( "share" );
            aDest   += ByteString( "config" );

            FileCopier aCpy2( aSource, aDest );
            aCpy2.Execute();

            //------------------------------------------------------------
            // _90_conv.url.
            aSource = aSourceDir;
            aSource += ByteString( "_90_conv.url" );

            aDest   = aDestDir;
            aDest   += ByteString( "share" );
            aDest   += ByteString( "config" );
            aDest   += ByteString( "wizard" );

            FileCopier aCpy3( aSource, aDest );
            aCpy3.Execute();

            break;
        }
	}
    return 0;
}


/*

/////////////////////////////////////////////////////////////////////////////
//	userdata task
MigrationTask_UserData::MigrationTask_UserData( SetupMigrationPlugin* pPlugin ) :
	SetupMigrationTask( pPlugin )
{
}

ULONG MigrationTask_UserData::Execute( MigrationExecType eTyp, SiEnvironment* pEnv )
{
	SiDirEntry aSource( pEnv->GetMigrationPath() );
	SiDirEntry aDest	( pEnv->GetDestPath() );

	aSource += ByteString(OFFICE_INI);
	aDest 	+= ByteString("user/");
	aDest	+= ByteString(OFFICE_INI);

	Config aSrcCfg( aSource.GetFullUni() );
	Config aDstCfg( aDest.GetFullUni() );

	aSrcCfg.SetGroup( "User" );
	aDstCfg.SetGroup( "User" );

	if( eTyp == EXECUTE )
	{
		ByteString aValue = aSrcCfg.ReadKey( "User-Id" );
		// aValue.Convert( CHARSET_IBMPC, CHARSET_SYSTEM );
		aDstCfg.WriteKey( "User-Id", aValue );

		aValue = aSrcCfg.ReadKey( "User-Name" );
		// aValue.Convert( CHARSET_IBMPC, CHARSET_SYSTEM );
		aDstCfg.WriteKey( "User-Name", aValue );

		aValue = aSrcCfg.ReadKey( "User-FirstName" );
		// aValue.Convert( CHARSET_IBMPC, CHARSET_SYSTEM );
		aDstCfg.WriteKey( "User-FirstName", aValue );

		aValue = aSrcCfg.ReadKey( "User-Adress" );
		// aValue.Convert( CHARSET_IBMPC, CHARSET_SYSTEM );
		aDstCfg.WriteKey( "User-Adress", aValue );
	}
	return 0L;
}


/////////////////////////////////////////////////////////////////////////////
//	address book task
MigrationTask_AddressBook::MigrationTask_AddressBook( SetupMigrationPlugin* pPlugin ) :
	SetupMigrationTask( pPlugin )
{
}


void MigrationTask_AddressBook::SetSourceAddressBookFilePath(
	SiEnvironment* pEnv )
{
	const ByteString	aDBasePath( "/database/" );
	const ByteString	aSOfficeFilename( OFFICE_INI );
	SiDirEntry		aSource( pEnv->GetMigrationPath() );

	m_aSOfficeIni = aSource + aSOfficeFilename;
	Config aConfig( m_aSOfficeIni.GetFullUni() );

	aConfig.SetGroup( "Database" );
	int	nToken = 1;
	ByteString aAddressBookKey	= aConfig.ReadKey( "Addressbook" );
	ByteString aSdbFilePath		= aAddressBookKey.GetToken( 0, ';' );
	ByteString aDBaseFileName	= aAddressBookKey.GetToken( 1, ';' );

	// substitute a possible macro path definition
	aSdbFilePath.SearchAndReplace( "$(inst)", pEnv->GetMigrationPath() );

	if ( aDBaseFileName.Len() )
	{
		ByteString aDBFileName = aSource.GetFull();
		aDBFileName += aDBasePath;
		aDBFileName += aDBaseFileName;
		aDBFileName += ".dbf";
		m_aDbfSourceFilePath = aDBFileName;

		aDBFileName = aSource.GetFull();
		aDBFileName += aDBasePath;
		aDBFileName += aDBaseFileName;
		aDBFileName += ".dbt";
		m_aDbtSourceFilePath = aDBFileName;
	}

	if ( aSdbFilePath.Len() )
	{
		m_aSdbSourceFilePath = aSdbFilePath;
	}
}

ULONG MigrationTask_AddressBook::GetOldAddressBookFilesSize() const
{
	ULONG	 nSize = 0;
	FileStat aFileStat;
	SiDirEntry aAbsSource;

	aAbsSource = SiDirEntry( m_aDbfSourceFilePath );
	aFileStat = FileStat( aAbsSource );
	nSize += aFileStat.GetSize();

	aAbsSource = SiDirEntry( m_aDbtSourceFilePath );
	aFileStat = FileStat( aAbsSource );
	nSize += aFileStat.GetSize();

	aAbsSource = SiDirEntry( m_aSdbSourceFilePath );
	aFileStat = FileStat( aAbsSource );
	nSize += aFileStat.GetSize();
	return nSize;
}

BOOL MigrationTask_AddressBook::CopyFiles( const SiDirEntry& aDest )
{
	BOOL			bReturn = FALSE;
	const ByteString aSO52DBFFileName( "/user/database/address/address.dbf" );
	const ByteString aSO52DBTFileName( "/user/database/address/address.dbt" );
	const ByteString aSO51SDBFileName( "/user/database/_address.sdb" );

	if ( m_aDbfSourceFilePath.Len() && m_aDbtSourceFilePath.Len() )
	{
		SiDirEntry	aAbsDest1( aDest.GetFull() );
		SiDirEntry	aAbsDest2( aDest.GetFull() );
		SiDirEntry	aAbsSource;
		FileCopier	aCpy;

		aAbsDest1 += aSO52DBFFileName;
		aAbsDest2 += aSO52DBTFileName;

		if( FileStat::HasReadOnlyFlag() )
		{
			if ( FileStat::GetReadOnlyFlag( aAbsDest1 ) )
				 FileStat::SetReadOnlyFlag( aAbsDest1, FALSE );

			if ( FileStat::GetReadOnlyFlag( aAbsDest2 ) )
				 FileStat::SetReadOnlyFlag( aAbsDest2, FALSE );
		}

		aAbsSource	= m_aDbfSourceFilePath;
		aAbsDest1	= SiDirEntry( aDest.GetFull() );
		aAbsDest1 += aSO52DBFFileName;

		if( !aAbsDest1.GetPath().Exists() )
			aAbsDest1.GetPath().MakeDir();
		else
			aAbsDest1.Kill();
		aCpy = FileCopier( aAbsSource, aAbsDest1 );
		aCpy.Execute();

		aAbsSource	= m_aDbtSourceFilePath;
		aAbsDest2	= SiDirEntry( aDest.GetFull() );
		aAbsDest2 += aSO52DBTFileName;

		aAbsDest2.Kill();
		aCpy = FileCopier( aAbsSource, aAbsDest2 );
		aCpy.Execute();
		bReturn = TRUE;
	}

	if ( m_aSdbSourceFilePath.Len() )
	{
		SiDirEntry	aAbsDest( aDest.GetFull() );
		aAbsDest += aSO51SDBFileName;

		SiDirEntry	aAbsSource;
		FileCopier	aCpy;

		if ( FileStat::HasReadOnlyFlag() )
		{
			if ( FileStat::GetReadOnlyFlag( aAbsDest ) )
				 FileStat::SetReadOnlyFlag( aAbsDest, FALSE );
		}

		aAbsSource	= m_aSdbSourceFilePath;
		if ( !aAbsDest.GetPath().Exists() )
			aAbsDest.GetPath().MakeDir();
		else
			aAbsDest.Kill();
		aCpy = FileCopier( aAbsSource, aAbsDest );
		aCpy.Execute();
		bReturn &= TRUE;
	}

	return bReturn;
}

BOOL MigrationTask_AddressBook::CreateAddressBookMapConfigFile( SiEnvironment* pEnv )
{
	ByteString	aConfigFile( ADRBKMAP_INI );
	ByteString	aDestMapConfig( "/user/database/" );
	ByteString	aSOfficeFilename( OFFICE_INI );

	aDestMapConfig += aConfigFile;

	SiDirEntry		aSource( pEnv->GetMigrationPath() );
	SiDirEntry		aDest( pEnv->GetDestPath() );

	m_aSOfficeIni = aSource + aSOfficeFilename;
	Config aConfig( m_aSOfficeIni.GetFullUni() );

	aConfig.SetGroup( "Common" );
	ByteString aLogicToColumnByteString( aConfig.ReadKey( "AddressBookFields" ));

	if ( aLogicToColumnByteString.Len() )
	{
		ByteString aDestFileName( aDest.GetFull() );
		aDestFileName += aDestMapConfig;

		Config aDestConfig( UniString::CreateFromAscii(aDestFileName.GetBuffer()) );

		aDestConfig.SetGroup( "AddressBookConvert" );
		aDestConfig.WriteKey( "LogicColumnToLangColumn", aLogicToColumnByteString );
		return TRUE;
	}
	else
		return FALSE;
}


ULONG MigrationTask_AddressBook::Execute( MigrationExecType eTyp, SiEnvironment* pEnv )
{
	ULONG nSize = 0;

	SetSourceAddressBookFilePath( pEnv );
	switch( eTyp )
	{
		case CALCULATE_SIZE :
			nSize = GetOldAddressBookFilesSize();
			break;
		case EXECUTE :
		{
			if ( CreateAddressBookMapConfigFile( pEnv ))
				CopyFiles( pEnv->GetDestPath() );
			break;
		}
	}
	return nSize;
}

*/
