/*************************************************************************
 *
 *  $RCSfile: jvmscan.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:51:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define INCL_WINWORKPLACE
#define INCL_DOSMISC
#define INCL_DOSERRORS
#define INCL_DOSNMPIPES
#define INCL_DOSPROCESS
#define INCL_DOS
#define INCL_DOSFILEMGR

#include <tools/svpm.h>
#ifndef _SISYS_HXX
#include <sifsys.hxx>
#endif


#include <stdio.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>

#include "../jvmscan.hxx"

#define PIPESIZE 256
#define HF_STDOUT 1      /* Standard output handle */
#define HF_STDERR 2      /* Standard error handle */


#define VERIFIED_VERSIONS	"1.1.6, 1.1.7, 1.1.7a" // only lower case
#define VALID_SINCE_VERSION	"1.1.6"

USHORT GetJavaVirtualMachine( JVMEntry * pJVM )
{
	USHORT nEntries	= 0;

	for (char driveLetter = 'C'; driveLetter <= 'Z'; driveLetter++)
	{
		pJVM[nEntries].mHome = driveLetter;
		pJVM[nEntries].mHome += ":\\java11";

		if ( CheckJava(pJVM[nEntries]) )
			nEntries ++;
	}

	return nEntries;
}


BOOL GetInstalledVM( JVMEntry& entry, const ByteString destPath )
{
	return FALSE; //keine Installation z.Zt. moeglich
}

BOOL GetVersion(ByteString exec, ByteString& version)
{
	CHAR        uchLoadError[CCHMAXPATH]= {0};                  /* Error info from DosExecPgm */
	RESULTCODES ChildRC                 = {0};                  /* Results from child process  */
	PID         pidChild                = 0;                    /* pid for child process       */
	APIRET      rc                      = NO_ERROR;             /* Return code                 */
	PCSZ        uchEnvByteString            = NULL;                 /* Environment string */
	CHAR*       uchArgByteString;                                   /* Argument string    */
	CHAR        uchJDKArgByteString[25]     = "java\0 -version\0\0";
	CHAR        uchJREArgByteString[25]     = "jre\0 \0\0";
	HPIPE       hpR, hpW;
	RESULTCODES resc;
	ULONG       ulRead, ulWritten;
	CHAR        achBuf[PIPESIZE];
	CHAR        szFailName[CCHMAXPATH];
	char        szExecutable[1024];

	HFILE hfOutSave     = -1,
	hfOutNew            = HF_STDOUT;

	HFILE hfErrSave     = -1,
	hfErrNew            = HF_STDERR;

	if ( !SiDirEntry(exec).Exists() )
		return FALSE;

	if (exec.Search("\\java.exe", exec.Len() - ByteString("\\java.exe").Len()) != STRING_NOTFOUND)
		uchArgByteString = uchJDKArgByteString;
	else
		uchArgByteString = uchJREArgByteString;

	strcpy( szExecutable, exec.GetBuffer() );

	DosDupHandle(HF_STDERR, &hfErrSave);        /* Saves standard error handle */
	DosDupHandle(HF_STDOUT, &hfOutSave);        /* Saves standard output handle */
	DosCreatePipe(&hpR, &hpW, PIPESIZE);        /* Creates pipe                      */
	DosDupHandle(hpW, &hfOutNew);               /* Duplicates standard output handle */
	DosDupHandle(hpW, &hfErrNew);               /* Duplicates standard error handle */

	rc = DosExecPgm(uchLoadError,               /* Object name buffer           */
					sizeof(uchLoadError),       /* Length of object name buffer */
					EXEC_ASYNC,                 /* Asynchronous/Trace flags     */
					uchArgByteString,               /* Argument string              */
					uchEnvByteString,               /* Environment string           */
					&ChildRC,                   /* Returns pid of process on an asynchronous request         */
					szExecutable);              /* Program file name            */

	DosClose(hpW);                              /* Closes write handle to ensure     */
												/* Notification at child termination */
	DosDupHandle(hfOutSave, &hfOutNew);         /* Brings stdout back                */
	DosDupHandle(hfErrSave, &hfErrNew);         /* Brings stderr back                */

	/*
	 * Read from the pipe and write to the screen
	 * as long as there are bytes to read.
	 */
	if ( (rc & DosRead (hpR, achBuf, sizeof(achBuf), &ulRead)) == NO_ERROR )
	{
		USHORT nIndex;
		ByteString aOutLine( achBuf );
		aOutLine.ToLower();

		if ( (nIndex = aOutLine.Search( "version" )) != STRING_NOTFOUND )
		{
			aOutLine.Erase(0, nIndex + ByteString("version").Len() );
			USHORT nLen = aOutLine.Search('\n') == STRING_NOTFOUND? aOutLine.Len() : aOutLine.Search('\n');
			aOutLine.Erase( nLen, aOutLine.Len() );
			aOutLine.EraseAllChars( );          // remove all spaces
			aOutLine.EraseAllChars('\"' );      // remove all "
			aOutLine.EraseAllChars('\r' );
			aOutLine.EraseAllChars('\n' );

			version = aOutLine;
		}

		return !(version < VALID_SINCE_VERSION);
	}
	else
		return FALSE;

	return TRUE;
}

BOOL GetRuntimeLib(ByteString home, ByteString version, ByteString& runtime)
{
	if ( !(version < "1.2") )
		return FALSE; // version 1.2.x is not supported yet

	runtime = home;
	runtime += "\\dll\\javai.dll";

	return SiDirEntry(runtime).Exists();
}

BOOL GetClasspath(ByteString home, ByteString version, ByteString& classpath)
{
	if ( !(version < "1.2") )
		return FALSE; // version 1.2.x is not supported yet

	classpath = home;
	classpath += "//lib//classes.zip";

	if ( !SiDirEntry(classpath).Exists() )
		return FALSE;

	classpath += ";";
	classpath += home;
	classpath += "\\lib";

	return TRUE;
}

BOOL CheckJava(JVMEntry& entry)
{
	BOOL bResult = FALSE;

	if (entry.mHome.Len() == 0 )
		return FALSE;

	ByteString exec = entry.mHome;
	exec        += "\\bin\\java.exe";

	if ( GetVersion(exec, entry.mVersion) )
		entry.mName = "Java Development Kit";
	else
	{
		exec = entry.mHome;
		exec += "\\bin\\jre.exe";

		if ( GetVersion(exec, entry.mVersion) )
			entry.mName = "Java Runtime Environment";
		else
			return FALSE; // no JRE or JDK found
	}

	bResult = GetRuntimeLib( entry.mHome, entry.mVersion, entry.mRuntimeLib );

	if ( bResult )
		bResult = GetClasspath (entry.mHome, entry.mVersion, entry.mClasspath );

	if ( bResult )
		entry.bIsVerified = ByteString(VERIFIED_VERSIONS).Search(entry.mVersion) != STRING_NOTFOUND;

	return bResult;
}
