/*************************************************************************
 *
 *  $RCSfile: aservdlg2.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:51:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif
#pragma hdrstop

#include "aserdlg2.hrc"
#include "aservdlg2.hxx"



ServerSetupDialog::ServerSetupDialog( Window* pParent, ResMgr* pResMgr ):
	ModalDialog			(pParent,	ResId( DLG_APPSERV, pResMgr )),
	maOK				(this,		ResId(BT_OK, pResMgr) ),
	maCancel			(this,		ResId(BT_CANCEL, pResMgr) ),
	maHttpBox			(this,		ResId(ED_HTTP, pResMgr)),
	maAdminBox			(this,		ResId(ED_ADMIN, pResMgr)),
	maHttpLabel			(this,		ResId(FT_HTTP, pResMgr)),
	maAdminLabel		(this,		ResId(FT_ADMIN, pResMgr)),
	maStart				(this,		ResId(CB_START, pResMgr))
{

}

// -----------------------------------------------------------------------

ServerSetupDialog::~ServerSetupDialog()
{
	FreeResource();
}
//------------------------------------------------------------------------
void		ServerSetupDialog::SetHttpPort( ByteString aPort )
{
	maHttpBox.SetText( aPort );
}

//------------------------------------------------------------------------
ByteString		ServerSetupDialog::GetHttpPort()
{
	return maHttpBox.GetText();
}
//------------------------------------------------------------------------

void		ServerSetupDialog::SetAdminPort( ByteString  aPort )
{
	maAdminBox.SetText( aPort );
}

//------------------------------------------------------------------------
ByteString		ServerSetupDialog::GetAdminPort()
{
	return maAdminBox.GetText();
}
//------------------------------------------------------------------------
void		ServerSetupDialog::EnableStartService( BOOL bEnable)
{
	maStart.Check( bEnable );
}
//------------------------------------------------------------------------
BOOL		ServerSetupDialog::isEnabledStartService()
{
	return maStart.IsChecked();
}


//------------------------------------------------------------------------

LoginDialog::LoginDialog( Window* pParent, ResMgr* pResMgr ):
	ModalDialog			(pParent,	ResId( DLG_LOGIN, pResMgr )),
	maOK				(this,		ResId(BT_OK2, pResMgr) ),
	maCancel			(this,		ResId(BT_CANCEL2, pResMgr) ),
	maDescription		(this,		ResId(FT_DESC, pResMgr)),
	maNameBox			(this,		ResId(ED_NAME, pResMgr)),
	maPasswordBox		(this,		ResId(ED_PASSWORD, pResMgr)),
	maNameLabel			(this,		ResId(FT_NAME, pResMgr)),
	maPasswordLabel		(this,		ResId(FT_PASSWORD, pResMgr))
{

}

// -----------------------------------------------------------------------

LoginDialog::~LoginDialog()
{
	FreeResource();
}
//------------------------------------------------------------------------
short		LoginDialog::Execute()
{
	maNameBox.GrabFocus();

	return ModalDialog::Execute();
}
//------------------------------------------------------------------------
ByteString		LoginDialog::GetName()
{
	return maNameBox.GetText();
}
//------------------------------------------------------------------------
ByteString		LoginDialog::GetPassword()
{
	return maPasswordBox.GetText();
}
//------------------------------------------------------------------------
void		LoginDialog::ClearPassword()
{
	maPasswordBox.SetText("");
}
//------------------------------------------------------------------------

