/*************************************************************************
 *
 *  $RCSfile: appserv2.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:51:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include <vos/process.hxx>
#include <sifsys.hxx>
#include <vos/profile.hxx>
#include <vos/socket.hxx>

#include "sicustom.hxx"
#include "appserv2.hxx"
#include "aserdlg2.hrc"

#include <vcl/svapp.hxx>
#include <vos/thread.hxx>
#ifdef _USE_NAMESPACE
using namespace vos;
#endif

/************************************************************************/

#ifdef _USE_NAMESPACE
using namespace vos;
#endif

/************************************************************************/

static SiSetupFnc  setupFunction;

static BOOL bWorkAroundWin32SecurityBug = FALSE;

/************************************************************************/

extern "C"
{
	BOOL _SV_CALL CustomInit
	(
		SiSetupFnc*		pSetupFunction,
		SiCustomFnc*	pCustomFunction
	)
	{
		BOOL	bResult = FALSE;

		// auf Kompatibilitaet achten

		if( pSetupFunction != 0 && pSetupFunction -> nVersion <= SICUSTOM_VERSION )
		{
			pCustomFunction -> fncMain = ( FncPtrCustomMain ) CustomMain;

			setupFunction.nVersion	   = pSetupFunction -> nVersion;
			setupFunction.fncHideSetup = pSetupFunction -> fncHideSetup;
			setupFunction.fncShowSetup = pSetupFunction -> fncShowSetup;

			bResult = TRUE;
		}

		return bResult;
	}

/************************************************************************/

	BOOL _SV_CALL CustomMain
	(
		SiCustomEnvironment*	pEnvironment,
		SiCustomModuleList*		pListOfModules
	)
	{
		BOOL					bResult = FALSE;
		char					string[255+1];
		OStartupInfo			startUpInfo;
		ByteString					sPathToSetUpExec;
		ByteString					sPathToInstRoot( pEnvironment -> GetDestPath( ) );
		BOOL					bIsInstallation = pEnvironment -> IsInstallation( );

		//	get path to exec. for buildung the name of the resource file

		startUpInfo.getExecutableFile( string, 255 );

		SiDirEntry	entryForExecutable( string );
		SiDirEntry	entryForExecDir( entryForExecutable.GetPath( ) );

		//	get path to exec for finding rsc- and script-file

		entryForExecDir.ToAbs( );
		sPathToSetUpExec = entryForExecDir.GetFull( FSYS_STYLE_HOST, FALSE );

		//	check, if setup passed the path for installation

		if( sPathToInstRoot.Len( ) == 0 )
		{
			//	if the path has not been passed, try to get it
			//	through the path to this executable

			ByteString		sShortNameOfExecDir( entryForExecDir.GetName( ) );

			sShortNameOfExecDir.ToLower( );

			//	if this executable is located in one of the well defined places
			//	we are sure that this is the right installation

			if( sShortNameOfExecDir == ByteString( "service" ) ||
				sShortNameOfExecDir == ByteString( "bin" ) )
			{
				SiDirEntry	entryForInstDir( entryForExecDir.GetPath( ) );

				entryForInstDir.ToAbs( );
				sPathToInstRoot = entryForInstDir.GetFull( FSYS_STYLE_HOST, FALSE );
			}
			else
			{
				sPathToInstRoot = ByteString( sPathToSetUpExec );
			}

			bIsInstallation = TRUE;
		}

		if( sPathToInstRoot.Len( ) > 0 )
		{
			BOOL				bBatchMode = pEnvironment -> IsResponseFileMode( );
			ByteString			sNameOfBatchFile( pEnvironment -> GetResponseFileName( ) );
			PlugInServerSetUp	plugIn( bBatchMode, sNameOfBatchFile );

			if( pEnvironment -> IsPre( ) )
			{
				bResult = plugIn.mainPreInstallation( sPathToSetUpExec, sPathToInstRoot, bIsInstallation );
			}
			else
			{
				bResult = plugIn.mainPostInstallation( sPathToSetUpExec, sPathToInstRoot, bIsInstallation );
			}
		}

		return bResult;
	}
};

/************************************************************************/

PlugInServerSetUp :: PlugInServerSetUp
(
	BOOL			bBatchMode,
	const char*		sNameOfIniFile
)
{
	m_bBatchMode = bBatchMode;
	m_sNameOfIniFile = sNameOfIniFile;

#if defined UNX

	m_bPlatformIsUnix = TRUE;
	m_bPlatformIsWin32 = FALSE;
	m_bPlatformIsOS2 = FALSE;

#elif defined WIN32

	m_bPlatformIsUnix = FALSE;
	m_bPlatformIsWin32 = TRUE;
	m_bPlatformIsOS2 = FALSE;

#elif defined OS2

	m_bPlatformIsUnix = FALSE;
	m_bPlatformIsWin32 = FALSE;
	m_bPlatformIsOS2 = TRUE;

#endif

	m_pRscMgr = 0;

	m_bSetUpIsForScheduleServer = FALSE;
	m_bScriptHasBeenFound = FALSE;

	m_pDialog = 0;
}

/************************************************************************/

PlugInServerSetUp :: ~PlugInServerSetUp( )
{
	delete m_pDialog;
}

/************************************************************************/

BOOL PlugInServerSetUp :: mainPreInstallation
(
	const char*		sPathToSetUpExec,
	const char*		sPathToInstRoot,
	BOOL			bIsInstallation
)
{
	BOOL			bResult = FALSE;
	BOOL			bFatalError = FALSE;
	ByteString		sErrorMessage( "" );

	if( !bFatalError )
	{
		// read ressources for this setup-plugin

		readResourceFile( sPathToSetUpExec );

		bFatalError = !couldReadRscFile( );
		sErrorMessage = ByteString( "Could not open resource file!" );
	}

	if( !bFatalError )
	{
		// check if the user is Admin or is able to become Admin

		if( !userIsAdministrator( ) )
		{
			if( userIsAbleToBecomeAdministrator( ) )
			{
				becomeAdministrator( );

				bFatalError = !userIsAdministrator( );
			}
			else
			{
				bFatalError = TRUE;
			}

			sErrorMessage = ByteString( ResId( STR_LOGINASADMIN, m_pRscMgr ) );
		}
	}

	if( !bFatalError )
	{
		// find the script that will control the deinstallation

		findScript( sPathToSetUpExec );
		bFatalError = !scriptHasBeenFound( );
		sErrorMessage = ByteString( ResId( STR_SCRIPTNOTFOUND, m_pRscMgr ) );
	}

	if( !bFatalError )
	{
		if( bIsInstallation )
		{
			bResult = TRUE;
		}
		else
		{
			// uninstall the components of the server

			openScript( );

			bResult = uninstallServer( sPathToInstRoot );
		}
	}

	if( bFatalError && !batchModeEnabled( ) )
	{
		InfoBox( 0, sErrorMessage ).Execute( );
	}

	return bResult;
}

/************************************************************************/

BOOL PlugInServerSetUp :: mainPostInstallation
(
	const char*		sPathToSetUpExec,
	const char*		sPathToInstRoot,
	BOOL			bIsInstallation
)
{
	BOOL			bResult = FALSE;
	BOOL			bFatalError = FALSE;
	ByteString		sErrorMessage( "" );

	if( !bFatalError )
	{
		// read ressources for this setup-plugin

		readResourceFile( sPathToSetUpExec );

		bFatalError = !couldReadRscFile( );
		sErrorMessage = ByteString( "Could not open resource file!" );
	}

	if( !bFatalError )
	{
		// find the script that will control the installation

		findScript( sPathToSetUpExec );
		bFatalError = !scriptHasBeenFound( );
		sErrorMessage = ByteString( ResId( STR_SCRIPTNOTFOUND, m_pRscMgr ) );
	}

	if( !bFatalError )
	{
		if( bIsInstallation )
		{
			if( batchModeEnabled( ) )
			{
				OProfile	profile( m_sNameOfIniFile );
				char		sAdminPort[31+1] = "";
				char		sHttpPort[31+1] = "";
				BOOL		bStartDaemons = FALSE;

				profile.readByteString( "Server", "AdminPort", sAdminPort, 31, "8120" );
				profile.readByteString( "Server", "HttpPort", sHttpPort, 31, "80" );

				bStartDaemons = profile.readBool( "Server", "StartServices", FALSE );

				if( atoi( sAdminPort ) > 0 && atoi( sHttpPort ) > 0 && !portIsInUse( atoi( sHttpPort ) ) )
				{
					openScript( );

					bResult = installServer( sPathToInstRoot, sAdminPort, sHttpPort, bStartDaemons );
				}
			}
			else
			{
				// display and execute the dialog for starting the services

				short		nResultOfExecute = 1;

				openDialog( );

				while( nResultOfExecute == 1 && !bResult )
				{
					nResultOfExecute = executeDialog( );

					if( nResultOfExecute == 1 )
					{
						// user wants to install the components of the server

						ByteString		sAdminPort( m_pDialog -> GetAdminPort( ) );
						ByteString		sHttpPort( m_pDialog -> GetHttpPort( ) );
						BOOL		bStartDaemons = m_pDialog -> isEnabledStartService( );

						if( sAdminPort.IsNumeric( ) && sHttpPort.IsNumeric( ) )
						{
							// Check, if the port for the shttpd is in use

							BOOL	bHttpPortIsInUse = portIsInUse( atoi( sHttpPort ) );

							if( bHttpPortIsInUse )
							{
								// Ask user if (s)he wants to change the port for the HTTP-Server

								WarningBox	wb( 0, WB_YES_NO, ByteString( ResId( STR_HTTPPORTINUSE, m_pRscMgr ) ) );

								bHttpPortIsInUse = ( wb.Execute( ) == BUTTONID_YES );
							}

							// If the port is not in use (or the user will ignore this)
							// install the server now

							if( !bHttpPortIsInUse )
							{
								openScript( );

								bResult = installServer( sPathToInstRoot, sAdminPort, sHttpPort, bStartDaemons );
							}
						}
						else
						{
							// inform the user that only numeric
							// values are allowed to specify a port

							InfoBox( 0, ByteString( ResId( STR_NUMERICVALUES, m_pRscMgr ) ) ).Execute( );
						}
					}
				}

				closeDialog( );
			}
		}
	}

	if( bFatalError && !batchModeEnabled( ) )
	{
		InfoBox( 0, sErrorMessage ).Execute( );
	}

	return bResult;
}

/************************************************************************/

BOOL PlugInServerSetUp :: batchModeEnabled( )
{
	return m_bBatchMode;
}

/************************************************************************/

void PlugInServerSetUp :: readResourceFile
(
	const char*		sPathToSetUpExec
)
{
	if( m_pRscMgr == 0 )
	{
		ByteString			sNameOfResFile( "ass" );
		SiDirEntry		entryForResFile( sPathToSetUpExec );

		sNameOfResFile += MAKE_NUMSTR( SUPD );

		entryForResFile += SiDirEntry( sNameOfResFile );
		entryForResFile.ToAbs( );

		m_pRscMgr = ResMgr :: CreateResMgr( entryForResFile.GetFull( ) );
	}
}

/************************************************************************/

BOOL PlugInServerSetUp :: couldReadRscFile( )
{
	return m_pRscMgr != 0;
}

/************************************************************************/

void PlugInServerSetUp :: findScript
(
	const char*		sPathToSetUpExec
)
{
	if( !m_bScriptHasBeenFound )
	{
		SiDirEntry	entryForPathToSetUpExec( sPathToSetUpExec );
		SiDirEntry	entryForScript( entryForPathToSetUpExec );

		entryForScript += SiDirEntry( "installd.scr" );

		if( !entryForScript.Exists( ) )
		{
			entryForScript = entryForPathToSetUpExec + SiDirEntry( "installs.scr" );

			if( entryForScript.Exists( ) )
			{
				m_bSetUpIsForScheduleServer = TRUE;
			}
		}

		if( entryForScript.Exists( ) )
		{
			m_bScriptHasBeenFound = TRUE;

			entryForScript.ToAbs( );
			m_sNameOfScriptFile = entryForScript.GetFull( );
		}
	}
}

/************************************************************************/

BOOL PlugInServerSetUp :: scriptHasBeenFound( )
{
	return m_bScriptHasBeenFound;
}

/************************************************************************/

void PlugInServerSetUp :: openScript( )
{
	if( scriptHasBeenFound( ) )
	{
		m_script.open( m_sNameOfScriptFile );
	}
}

/************************************************************************/

BOOL PlugInServerSetUp :: userIsAdministrator( )
{
	return m_security.isAdministrator( );
}

/************************************************************************/

BOOL PlugInServerSetUp :: userIsAbleToBecomeAdministrator( )
{
	return m_bPlatformIsWin32 && !batchModeEnabled( );
}

/************************************************************************/

void PlugInServerSetUp :: becomeAdministrator( )
{
	if( !userIsAdministrator( ) && userIsAbleToBecomeAdministrator( ) )
	{
		LoginDialog		dialog( 0, m_pRscMgr );
		BOOL			bAbortLogin = FALSE;

		if( setUpIsForScheduleServer( ) )
		{
			dialog.SetText( ByteString( ResId( STR_SSCHDLEDSETUP, m_pRscMgr ) ) );
		}

		for( int i = 0; i < 3 && !userIsAdministrator( ) && !bAbortLogin; i++ )
		{
			short	nResultOfExecute = dialog.Execute( );

			if( nResultOfExecute == 1 )
			{
				m_security.logonUser( dialog.GetName( ), dialog.GetPassword( ) );

				if( !userIsAdministrator( ) )
				{
					if( i < 2 )
					{
						WarningBox	wb( 0, WB_RETRY_CANCEL, ByteString( ResId( STR_LOGINERROR, m_pRscMgr ) ) );

						if( wb.Execute( ) == BUTTONID_CANCEL )
						{
							bAbortLogin = TRUE;
						}
					}
					else
					{
						InfoBox( 0, ByteString( ResId( STR_LOGINERROR, m_pRscMgr ) ) ).Execute( );
					}

					dialog.ClearPassword( );
				}
			}
		}
	}
}

/************************************************************************/

void PlugInServerSetUp :: openDialog( )
{
	if( !batchModeEnabled( ) )
	{
		if( m_pRscMgr != 0  && !batchModeEnabled( ) )
		{
			m_pDialog = new ServerSetupDialog( 0, m_pRscMgr );

			if( setUpIsForScheduleServer( ) )
			{
				m_pDialog -> SetText( ByteString( ResId( STR_SSCHDLEDSETUP, m_pRscMgr ) ) );
			}

			m_pDialog -> SetAdminPort( "8120" );
			m_pDialog -> SetHttpPort( "80" );
			m_pDialog -> EnableStartService( TRUE );
		}
	}
}

/************************************************************************/

short PlugInServerSetUp :: executeDialog( )
{
	short	nResult = 0;

	if( !batchModeEnabled( ) )
	{
		if( m_pRscMgr != 0 && m_pDialog != 0 )
		{
			nResult = m_pDialog -> Execute( );
		}
	}

	return nResult;
}

/************************************************************************/

void PlugInServerSetUp :: closeDialog( )
{
	if( !batchModeEnabled( ) )
	{
		delete m_pDialog;

		m_pDialog = 0;
	}
}

/************************************************************************/

BOOL PlugInServerSetUp :: setUpIsForScheduleServer( )
{
	return m_bSetUpIsForScheduleServer;
}

/************************************************************************/

BOOL PlugInServerSetUp :: portIsInUse
(
	short	nPort
)
{
	BOOL	bResult = FALSE;
	char	sNameOfLocalHost[255+1];

	OSocketAddr :: getLocalHostname( sNameOfLocalHost, sizeof( sNameOfLocalHost ) );

	OInetSocketAddr  localAddress( sNameOfLocalHost, nPort );

	if( ( oslSocketAddr ) localAddress != 0 )
	{
		OConnectorSocket			connector;
		ISocketTypes :: TResult		eResultOfConnect = ISocketTypes :: TResult_Error;

		// connect to acceptor socket and set return value

		eResultOfConnect = connector.connect( localAddress );

		bResult = ( eResultOfConnect == ISocketTypes :: TResult_Ok );
	}

	return bResult;
}

/************************************************************************/

BOOL PlugInServerSetUp :: installServer
(
	const char*		sPathToInstRoot,
	const char*		sAdminPort,
	const char*		sHttpPort,
	BOOL			bStartDaemons
)
{
	char			sByteString[127+1];

	evaluateNameOfSection( sByteString, "install" );
	executeSectionOfScript( sByteString, sPathToInstRoot );

	if( strlen( sByteString ) > 0 )
	{
		char		sNameOfExec[255+1];
		const char*	sArgsForScript[2] = { "script", "" };
		ByteString		sArgsForAdminPort( "set sadmind Port " );
		ByteString		sArgsForHttpPort( "set shttpd Port " );

		//	Take contents of sByteString as keyword and
		//	read the name of the proptool-binary
		//	Store result in sByteString!

		m_script.readByteString( sByteString, "proptool", sByteString, 127, "" );

		sprintf( sNameOfExec, sByteString, sPathToInstRoot );

#if defined WIN32
		sprintf( sByteString, "\"%s\"", sPathToInstRoot );
#else
		sprintf( sByteString, "%s", sPathToInstRoot );
#endif
		sArgsForScript[1] = sByteString;
		sArgsForAdminPort += sAdminPort;
		sArgsForHttpPort += sHttpPort;

		executeProcess( sNameOfExec, 2, sArgsForScript );
		executeProcess( sNameOfExec, sArgsForAdminPort );
		executeProcess( sNameOfExec, sArgsForHttpPort );
	}

	if( bStartDaemons )
	{
		evaluateNameOfSection( sByteString, "start" );
		executeSectionOfScript( sByteString, sPathToInstRoot );
	}

	return TRUE;
}

/************************************************************************/

BOOL PlugInServerSetUp :: uninstallServer
(
	const char*		sPathToInstRoot
)
{
	char	sByteString[255+1];

	evaluateNameOfSection( sByteString, "stop" );
	executeSectionOfScript( sByteString, sPathToInstRoot );

	evaluateNameOfSection( sByteString, "uninstall" );
	executeSectionOfScript( sByteString, sPathToInstRoot );

	return TRUE;
}

/************************************************************************/

void PlugInServerSetUp :: evaluateNameOfSection
(
	char*			sByteString,
	const char*		sGenericName
)
{
	if( m_bPlatformIsUnix )
	{
		sprintf( sByteString, "unix-%s", sGenericName );
	}
	else if( m_bPlatformIsWin32 )
	{
		sprintf( sByteString, "win32-%s", sGenericName );
	}
	else if( m_bPlatformIsOS2 )
	{
		sprintf( sByteString, "os/2-%s", sGenericName );
	}
}

/************************************************************************/

void PlugInServerSetUp :: executeSectionOfScript
(
	const char*		sNameOfSection,
	const char*		sPathToInstRoot
)
{
	const size_t	SIZE_OF_BUFFER = 8192;
	char*			sBuffer = new char[SIZE_OF_BUFFER];

	if( m_script.getSectionEntries( sNameOfSection, sBuffer, SIZE_OF_BUFFER ) > 0 )
	{
		char*	sKey = sBuffer;
		char	sByteString[511+1];

		while( *sKey )
		{
			if( strncmp( sKey, "cmd", 3 ) == 0 )
			{
				char	sNameOfExec[255+1];

				m_script.readByteString( sNameOfSection, sKey, sByteString, 127, "" );
				sprintf( sNameOfExec, sByteString, sPathToInstRoot );

				sKey += strlen( sKey ) + 1;

				if( *sKey && strncmp( sKey, "arg", 3 ) == 0 )
				{
					short			nNoOfArgs = 0;
					char			sBuffer1[4][127+1];
					char			sBuffer2[4][255+1];
					const char*		sArgV[4] = { sBuffer2[0], sBuffer2[1], sBuffer2[2], sBuffer2[3] };

					m_script.readByteString( sNameOfSection, sKey, sByteString, 511, "" );

					nNoOfArgs = sscanf( sByteString, "%127s%127s%127s%127s", sBuffer1[0], sBuffer1[1], sBuffer1[2], sBuffer1[3] );

					for( short i = 0; i < nNoOfArgs; i++ )
					{
						sprintf( sBuffer2[i], sBuffer1[i], sPathToInstRoot );
					}

					executeProcess( sNameOfExec, nNoOfArgs, sArgV );

					sKey += strlen( sKey ) + 1;
				}
			}
			else
			{
				sKey += strlen( sKey ) + 1;
			}
		}
	}

	delete[] sBuffer;
}

/************************************************************************/

void PlugInServerSetUp :: executeProcess
(
	const char*		sNameOfExecutable,
	const char*		sArguments
)
{
	BOOL			bWaitForCompletion = TRUE;
	char			sBuffer[4][127+1];
	const char*		sArgs[4] = { sBuffer[0], sBuffer[1], sBuffer[2], sBuffer[3] };
	short			nNoOfArgs = sscanf( sArguments, "%127s%127s%127s%127s", sBuffer[0], sBuffer[1], sBuffer[2], sBuffer[3] );
	executeProcess( sNameOfExecutable, nNoOfArgs, sArgs );
};

/************************************************************************/

class ProcessExecutor : public OThread
{
	char*           m_sExecutable;
	int				m_nArgC;
	char**		    m_sArgV;
	BOOL            m_bDone;
	virtual void run();
public:
	ProcessExecutor( const char* pName, int nArgC, const char* sArgV[] );
	~ProcessExecutor();
	BOOL isRunning() const { return !m_bDone; }
};


ProcessExecutor::ProcessExecutor(
	const char* pName, int nArgC, const char* sArgV[] )
	: m_nArgC( nArgC ), m_sExecutable( strdup( pName ) ), m_bDone( FALSE )
{
	m_sArgV = new char*[ nArgC ];
	for( int n = nArgC; n--; )
		m_sArgV[ n ] = strdup( sArgV[ n ] );
}

ProcessExecutor::~ProcessExecutor()
{
	free( m_sExecutable );
	for( int n = m_nArgC; n--; ) free( m_sArgV[ n ] );
	delete[] m_sArgV;
}

void ProcessExecutor::run()
{
	OProcess		process( m_sExecutable, (const char**)m_sArgV, m_nArgC );
	process.execute( (OProcess::TProcessOption)(
		OProcess::TOption_Hidden | OProcess::TOption_Wait ));
	m_bDone = TRUE;
}

void PlugInServerSetUp :: executeProcess
(
	const char*		sNameOfExecutable,
	int				nArgC,
	const char*		sArgV[]
)
{
	ProcessExecutor* pProcess = new ProcessExecutor(
		sNameOfExecutable, nArgC, sArgV );
	pProcess->create();
	// Unter OS/2 darf auf einen Prozess, der per "start xxx" aus einer
	// cmd.exe als PM App gestartet wird, nicht aus dem Solarthread
	// gewartet werden, da OS/2 sonst deadlocked.
#ifdef OS2
	while( pProcess->isRunning() ) Application::Yield();
#else
	pProcess->join();
#endif
	delete pProcess;
};

