/*************************************************************************
 *
 *  $RCSfile: sicfg.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: dv $ $Date: 2001/11/20 11:30:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "decltor.hxx"
#include "compiler.hxx"
#include "fields.hxx"
#include "instdb.hxx"

TYPEINIT1(SiConfigurationItem,SiDeclarator)

///////////////////////////////////////////////////////////////////////////////
//
//		SiStarRegistry
//

SiConfigurationItem::SiConfigurationItem(SiIdentifier const& ID, SiCompiler *pCompiler) :
	SiDeclarator(ID,pCompiler)
{
	INIT_MULTI_LANG_MEMBER( pModule );
	INIT_MULTI_LANG_MEMBER( aUserName );
	INIT_MULTI_LANG_MEMBER( aPath );
	INIT_MULTI_LANG_MEMBER( aKey );
	INIT_MULTI_LANG_MEMBER( aValue );
	INIT_MULTI_LANG_MEMBER( aWorkstationValue );
	INIT_MULTI_LANG_MEMBER( bWorkstation );
	INIT_MULTI_LANG_MEMBER( bNetwork );
	INIT_MULTI_LANG_MEMBER( eCfgType );
	INIT_MULTI_LANG_MEMBER( bCreate );

	m_pModule		= NULL;
	m_bWorkstation	= FALSE;
	m_bNetwork		= FALSE;
	m_bCreate		= FALSE;
}

// ----------------------------------------------------------------------------

void SiConfigurationItem::JoinWithParent()
{
	if( !IsLangRef() )
		return ;

	SiConfigurationItem* pParent = (SiConfigurationItem*) m_pLangParent;

	JOIN_MULTI_LANG_MEMBER( pModule );
	JOIN_MULTI_LANG_MEMBER( aUserName );
	JOIN_MULTI_LANG_MEMBER( aPath );
	JOIN_MULTI_LANG_MEMBER( aKey );
	JOIN_MULTI_LANG_MEMBER( aValue );
	JOIN_MULTI_LANG_MEMBER( aWorkstationValue );
	JOIN_MULTI_LANG_MEMBER( bWorkstation );
	JOIN_MULTI_LANG_MEMBER( bNetwork );
	JOIN_MULTI_LANG_MEMBER( eCfgType );
	JOIN_MULTI_LANG_MEMBER( bCreate );
}

// ----------------------------------------------------------------------------

BOOL SiConfigurationItem::SetProperty(const ByteString& aProperty, const ByteString& aValue)
{
	if( aProperty == PROPERTY_USERNAME )
	{
		SET_MULTI_LANG_MEMBER( aUserName, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_PATH )
	{
		SET_MULTI_LANG_MEMBER( aPath, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_KEY )
	{
		SET_MULTI_LANG_MEMBER( aKey, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_VALUE )
	{
		SET_MULTI_LANG_MEMBER( aValue, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_WORKSTATIONVALUE )
	{
		SET_MULTI_LANG_MEMBER( aWorkstationValue, aValue );
		return TRUE;
	}
	if( aProperty == PROPERTY_FLAGS )
	{
		if( aValue == VALUE_CREATE )
		{
			SET_MULTI_LANG_MEMBER( bCreate, TRUE );
			return TRUE;
		}
		if( aValue == VALUE_STRING )
		{
			SET_MULTI_LANG_MEMBER( eCfgType, STRING );
			return TRUE;
		}
		else if( aValue == VALUE_NUMERIC )
		{
			SET_MULTI_LANG_MEMBER( eCfgType, NUMERIC );
			return TRUE;
		}
		else if( aValue == VALUE_BOOLEAN )
		{
			SET_MULTI_LANG_MEMBER( eCfgType, BOOLEAN );
			return TRUE;
		}
		else if( aValue == VALUE_STRINGLIST )
		{
			SET_MULTI_LANG_MEMBER( eCfgType, STRINGLIST );
			return TRUE;
		}
		else if( aValue == VALUE_BINARY )
		{
			SET_MULTI_LANG_MEMBER( eCfgType, BINARY );
			return TRUE;
		}
		else if( aValue == VALUE_WORKSTATION )
		{
			SET_MULTI_LANG_MEMBER( bWorkstation, TRUE );
			return TRUE;
		}
		else if( aValue == VALUE_NETWORK )
		{
			SET_MULTI_LANG_MEMBER( bNetwork, TRUE );
			return TRUE;
		}
	}
	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiConfigurationItem::SetProperty(const ByteString& aProperty, SiDeclarator* aValue)
{
	if( aProperty == PROPERTY_MODULEID )
	{
		m_pModule = PTR_CAST( SiModule, aValue );
		if( m_pModule != NULL )
		{
			m_pModule->Add( this );
			m_IspModule = TRUE;
			return TRUE;
		}
		return FALSE;
	}

	return SiDeclarator::SetProperty(aProperty,aValue);
}

// ----------------------------------------------------------------------------

BOOL SiConfigurationItem::Check()
{
	BOOL bOk = TRUE;
	bOk = bOk && CheckField( m_aPath, PROPERTY_PATH );
//	bOk = bOk && CheckField( m_aKey, PROPERTY_KEY );
//	bOk = bOk && CheckField( m_aValue, PROPERTY_VALUE );

	return bOk? SiDeclarator::Check() : FALSE;
}

// ----------------------------------------------------------------------------

BOOL SiConfigurationItem::WriteTo(SiDatabase& aStream) const
{
	if( !IsLangRef() )
		aStream.BeginDeclaration("ConfigurationItem", this);

	WRITE_MULTI_LANG_MEMBER( PROPERTY_MODULEID, pModule );
	WRITE_MULTI_LANG_MEMBER( PROPERTY_PATH, aPath );

	if( m_aUserName.Len() )
		WRITE_MULTI_LANG_MEMBER( PROPERTY_USERNAME, aUserName );

	WRITE_MULTI_LANG_MEMBER( PROPERTY_KEY, aKey );
	WRITE_MULTI_LANG_MEMBER( PROPERTY_VALUE, aValue );

	if( m_aWorkstationValue.Len() )
		WRITE_MULTI_LANG_MEMBER( PROPERTY_WORKSTATIONVALUE, aWorkstationValue );

	if( m_IseCfgType || m_IsbWorkstation || m_bCreate || m_IsbNetwork)
	{
		aStream.BeginProperty( PROPERTY_FLAGS, m_nLanguage );
		aStream.BeginList();

		if( m_eCfgType == STRING )
			aStream.AddListValue( SiIdentifier(VALUE_STRING) );
		else if( m_eCfgType == BOOLEAN )
			aStream.AddListValue( SiIdentifier(VALUE_BOOLEAN) );
		else if( m_eCfgType == NUMERIC )
			aStream.AddListValue( SiIdentifier(VALUE_NUMERIC) );
		else if( m_eCfgType == STRINGLIST )
			aStream.AddListValue( SiIdentifier(VALUE_STRINGLIST) );
		else if( m_eCfgType == BINARY )
			aStream.AddListValue( SiIdentifier(VALUE_BINARY) );

		if( m_bWorkstation )
			aStream.AddListValue( SiIdentifier(VALUE_WORKSTATION) );
		if( m_bNetwork )
			aStream.AddListValue( SiIdentifier(VALUE_NETWORK) );
		if( m_bCreate )
			aStream.AddListValue( SiIdentifier(VALUE_CREATE) );

		aStream.EndList();
		aStream.EndProperty();
	}

	for( USHORT nIdx = 0; nIdx < m_aLangRefs.Count(); ++nIdx )
	{
		SiConfigurationItem* pCfg = (SiConfigurationItem*) m_aLangRefs.GetObject(nIdx);
		pCfg->WriteTo( aStream );
	}

	if( !IsLangRef() )
		aStream.EndDeclaration();
	return TRUE;
}

// ----------------------------------------------------------------------------
BOOL SiConfigurationItem::IsNetwork() const
{
	if ( m_bNetwork )
		return TRUE;
	else if ( !m_IsbNetwork && !m_IsbWorkstation )
		return TRUE;
	else
		return FALSE;
}

// ----------------------------------------------------------------------------

ByteString SiConfigurationItem::GetNaturalID() const
{
	ByteString aNatID( m_aPath );
	aNatID += "_";
	aNatID += m_aKey;
	if( IsLangRef() ) {
		aNatID += "_";
		aNatID += m_nLanguage;
	}
	return aNatID;
}

