/*************************************************************************
 *
 *  $RCSfile: mowos.cxx,v $
 *
 *  $Revision: 1.6.4.1 $
 *
 *  last change: $Author: svesik $ $Date: 2002/03/11 19:30:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define ENABLE_BYTESTRING_STREAM_OPERATORS	1
#include <stdlib.h>
#ifdef SOLARIS
#include <netdb.h>
#endif
#if defined(LINUX) || defined(IRIX)
#include <sys/param.h>
#endif

#include "os.hxx"
#include "sifsys.hxx"

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _SV_CONFIG_HXX //autogen
#include <tools/config.hxx>
#endif
#include <sys/types.h>

#ifdef LINUX
#include <sys/vfs.h>
#define statvfs statfs
#elif (defined(NETBSD) || defined(FREEBSD) || defined(MACOSX))
#include <sys/param.h>
#include <sys/mount.h>
#define statvfs statfs
#else
#include <sys/statvfs.h>
#endif
#define KBYTE 1024

#include <sys/stat.h>		// chmod
#include <pwd.h>
#include <time.h>
#include <utime.h>
#include <unistd.h>
#include <string.h>

#if defined(USE_DTACTION)
#undef USE_DTACTION
#endif

// class OS --------------------------------------------------------------
//
// Hier stehen die Funktionen, die auf allen Plattformen vorhanden sind,
// aber unterschiedlich implementiert werden.
// Here are the methods availble on all platforms but might be implemented
// differently

const char* OS::GetAllFilesWildCard()
{
	return "*";
}

ByteString OS::GetGUIPath()
{
	return ByteString(Config::GetDefDirectory(),osl_getThreadTextEncoding());
}

ByteString OS::GetSystemPath()
{
	return ByteString(Config::GetDefDirectory(), osl_getThreadTextEncoding());
}

ByteString OS::GetSystemFontPath()
{
	return ByteString(Config::GetDefDirectory(), osl_getThreadTextEncoding()); // ?
}

DateTime UnixOS::GetDateTime
(
	ByteString const& rFilename
)
{
	DateTime aReturn;
        struct stat aStat;
        tm* pTime;

        stat( rFilename.GetBuffer(), &aStat );
        pTime = gmtime( &aStat.st_mtime );

	if( pTime )
	{
		aReturn.SetYear( pTime->tm_year + 1900 );	
		aReturn.SetMonth( pTime->tm_mon + 1);	
		aReturn.SetDay( pTime->tm_mday  );	
		aReturn.SetHour( pTime->tm_hour + 1 );	
		aReturn.SetMin( pTime->tm_min );	
		aReturn.SetSec( pTime->tm_sec );	
	}
	return aReturn;
}

void OS::SetDateTime
(
	ByteString const& rFilename,
	Date   const& rNewDate,
	Time   const& rNewTime
)
{
	tm times;
	DateTime aDt( rNewDate, rNewTime );
//	aDt.ConvertToLocalTime();

	times.tm_year = aDt.GetYear()  - 1900;  	// 1997 -> 97
	times.tm_mon  = aDt.GetMonth() - 1;		// 0=Januar!
	times.tm_mday = aDt.GetDay();

	times.tm_hour = aDt.GetHour();
	times.tm_min  = aDt.GetMin();
	times.tm_sec  = 0;

	times.tm_wday  = 0;
	times.tm_yday  = 0;
	times.tm_isdst = 0;

	time_t time = mktime (&times);
	if (time != (time_t) -1)
	{
		struct utimbuf u_time;
		u_time.actime = time;
		u_time.modtime = time;
		utime (rFilename.GetBuffer(), &u_time);
	}
}

BOOL OS::MakeWritable(ByteString const& rFile)
{
	struct stat buf;

	return ( stat(rFile.GetBuffer(), &buf)
			? FALSE
			: ! chmod( rFile.GetBuffer(),
					buf.st_mode | S_IRUSR | S_IRGRP | S_IROTH
								| S_IWUSR | S_IWGRP | S_IWOTH ));
}

// -----------------------------------------------------------------------

ULONG OS::GetDriveSize(SiDirEntry const& rVol)
{
	struct statvfs buf;
	SiDirEntry aPath( rVol );

	for (aPath.ToAbs()
	;	(statvfs (aPath.GetFull().GetBuffer(), &buf) == -1)
	;	aPath = aPath [1])
	{
		if (SiDirEntry (aPath [1]) == SiDirEntry())
			return 0;
	}

//! warum? erstmal fuer alle Plattformen den selben CODE
//! why? first we use the same CODE for all platforms
#if defined(LINUX) || defined(NETBSD) || defined(FREEBSD) || defined(MACOSX)
	const ULONG nSize = buf.f_bsize;
//#elif defined AIX || defined SCO
//	// immer 512 Byte Bloecke ???
//	const ULONG nSize = 512;
#else
	const ULONG nSize = (buf.f_frsize ? buf.f_frsize : buf.f_bsize);
#endif

	return (nSize < KBYTE ? buf.f_bavail / (KBYTE / nSize)
		: nSize > KBYTE ? buf.f_bavail * (nSize / KBYTE)
		: buf.f_bavail);
}

ULONG OS::GetClusterSize(SiDirEntry const& rVol)
{
	struct statvfs buf;
	SiDirEntry aPath( rVol );

	for (aPath.ToAbs()
	;	(statvfs (aPath.GetFull().GetBuffer(), &buf) == -1)
	;	aPath = aPath [1])
	{
		if (SiDirEntry (aPath [1]) == SiDirEntry())
			return 512;
	}

#if defined(LINUX) || defined(NETBSD) || defined(FREEBSD) || defined(MACOSX)
	return buf.f_bsize;
#else
	return (buf.f_frsize ? buf.f_frsize : buf.f_bsize);
#endif
}

BOOL OS::InstallFont (ByteString const& /*rFontFile*/, ByteString const& /*rFontName*/)
// Dummy bei Unix
{
	return TRUE;
}

BOOL OS::IsFontInstalled (ByteString const& /*rFontFile*/, ByteString const& /*rFont Name*/)
// Dummy bei Unix
{
	return TRUE;
}

BOOL OS::IsConfigurationValid(Window*)
{
	return TRUE;
}

ByteString OS::GetIEPluginDir( BOOL bPlugin )
{
	ByteString aDir;
	return aDir;
}

ByteString OS::GetIEDir()
{
	ByteString aDir;
	return aDir;
}

ByteString OS::GetNSPluginDir()
{
	const char* pEnv;
	char  cBuf[16*1024];

	pEnv = getenv( "NPX_PLUGIN_PATH" );
	if( pEnv )
	{
		SiDirEntry a( pEnv );
		if( a.Exists() ) return a.GetFull();
	}

	pEnv = getenv( "HOME" );
	if( pEnv )
	{
		strcpy( cBuf, pEnv );
		strcat( cBuf, "/.netscape/plugins" );
		SiDirEntry a( cBuf );
		if( !a.Exists() ) a.MakeDir();
		return a.GetFull();
	}

	SiDirEntry a( "/usr/lib/netscape/plugins" );
	if( a.Exists() ) return a.GetFull();

	return ByteString("");
}

ByteString OS::GetNS6PluginDir()
{
	const char* pEnv;
	char  cBuf[16*1024];

	pEnv = getenv( "NPX_PLUGIN_PATH" );
	if( pEnv )
	{
		SiDirEntry a( pEnv );
		if( a.Exists() ) return a.GetFull();
	}

	pEnv = getenv( "HOME" );
	if( pEnv )
	{
		strcpy( cBuf, pEnv );
		strcat( cBuf, "/.netscape6/plugins" );
		SiDirEntry a( cBuf );
		if( !a.Exists() ) a.MakeDir();
		return a.GetFull();
	}

	SiDirEntry a( "/usr/lib/netscape6/plugins" );
	if( a.Exists() ) return a.GetFull();

	return ByteString("");
}

// ---------------------------------------------------------------------------
// Unix-spezifische Methoden -------------------------------------------------
// ---------------------------------------------------------------------------

void UnixOS::SetRights(ByteString const& aFile, int nRights)
// pre:  nRights ist eine dezimal codierte Oktalzahl
// post: Rechte der Datei aFile wurden gesetzt
{
	int nOctal = 0;

	// nRights z.B. 644
	nOctal 	 = nRights / 100; 	// nOctal = 110
	nRights %= 100;

	// nRights jetzt 44
	nOctal  *= 8;			  	// nOctal = 110000
	nOctal  += nRights / 10;	// nOctal = 110100
	nRights %= 10;

	// nRights jetzt 4
	nOctal  *= 8;				// nOctal = 110100000
	nOctal  += nRights;			// nOctal = 110100100 = -rw-r--r--

	// Rechte setzen
	chmod(aFile.GetBuffer(), nOctal);
}


BOOL UnixOS::CreateSoftLink
(
	ByteString const& aSource,
	ByteString const& aDest
)
{
	return symlink(aSource.GetBuffer(),aDest.GetBuffer()) == 0;
}

BOOL UnixOS::CreateHardLink
(
	ByteString const& aSource,
	ByteString const& aDest
)
{
	return link(aSource.GetBuffer(),aDest.GetBuffer()) == 0;
}

BOOL UnixOS::ConvertShellScript(
	SiDirEntry const& aDest,
	SiDirEntry const& aSource,
	ByteString   const& rWorkPath,
	ByteString	 const& rProgPath
)
{
	SvFileStream aDestStream( aDest.GetFullUni(), STREAM_READWRITE | STREAM_TRUNC );
	SvFileStream aSourceStream( aSource.GetFullUni(), STREAM_READ );
	ByteString aLine;

	while ( aSourceStream.ReadLine( aLine ))
	{
		aLine.SearchAndReplace("<workpath>", rWorkPath);
		aLine.SearchAndReplace("<progpath>", rProgPath);
		if (! aDestStream.WriteLine( aLine ))
			return FALSE;
	}
	return TRUE;
}

BOOL UnixOS::IsRoot()
{
	return getuid() == (uid_t)0;
}

passwd* UnixOS::GetPasswdEntry( const ByteString& rUserName )
{
	struct passwd* pwd = getpwnam( rUserName.GetBuffer() );
	return pwd;
}

void UnixOS::ChangeOwnerRecursive( const ByteString aPath, const ByteString& rUserName )
{
	Dir	aDir( aPath, FSYS_KIND_DIR | FSYS_KIND_FILE );
	for( USHORT i = 0; i < aDir.Count(); ++i )
	{
		SiDirEntry& rEntry = (SiDirEntry&) aDir[i];

		if( rEntry.GetFlag() != FSYS_FLAG_CURRENT &&
			rEntry.GetFlag() != FSYS_FLAG_PARENT )
		{
			FileStat aStat( rEntry, FALSE );
			if( aStat.IsKind(FSYS_KIND_DIR) )
				ChangeOwnerRecursive( rEntry.GetFull(), rUserName );

			passwd* pwd = GetPasswdEntry( rUserName );
			if( pwd )
				chown( rEntry.GetFull().GetBuffer(), pwd->pw_uid, pwd->pw_gid );
		}
	}

	SiDirEntry	aMaster( aPath );
	passwd*		pwd = GetPasswdEntry( rUserName );

	if( pwd )
		chown( aMaster.GetFull().GetBuffer(), pwd->pw_uid, pwd->pw_gid );
}

BOOL UnixOS::GetUserHomeDir( const ByteString& rUserName, SiDirEntry& rEntry )
{
	passwd* pwd = GetPasswdEntry( rUserName );

	if( !pwd )
		return FALSE;

	rEntry = ByteString(pwd->pw_dir);
	return TRUE;
}

SiDirEntry UnixOS::GetHomeDir(void)
{
	ByteString aHome (getenv("HOME"));
	if( !aHome.Len() )
		return SiDirEntry();
	return SiDirEntry( aHome );
}

SiDirEntry UnixOS::GetProfile (void)
{
	ULONG nLen;
	ByteString aHome (getenv("HOME"));
	if (!aHome.Len())
		return SiDirEntry();
	SiDirEntry aProfile (aHome);
	char *pShell = getenv ("SHELL");
	if (!pShell)
	{
		struct passwd *passwdent = getpwuid( getuid() );
		if ( ! passwdent )
			return SiDirEntry();
		pShell = passwdent->pw_shell;
	}
	aProfile += ByteString( (pShell && ((nLen = strlen( pShell )) >= 3)
		&& !strcmp( pShell + nLen - 3, "csh" ))
		? ".cshrc" : ".profile" );
	return access( aProfile.GetFull().GetBuffer(), F_OK | R_OK | W_OK )
		? SiDirEntry() : aProfile;
}

ByteString UnixOS::InsertLine
(
	SiDirEntry const& aNewProfile,
	ByteString const& aLine
)
{
	SiDirEntry aOldProfile( aNewProfile );
	ByteString aName( aOldProfile.GetName() );
	aName += ".bak";
	aOldProfile.SetName( UniString::CreateFromAscii(aName.GetBuffer()) );
	aName += '.';
	for (USHORT i = 1; aOldProfile.Exists(); i++)
	{
		UniString aStr( aName, osl_getThreadTextEncoding() );
		aStr += UniString::CreateFromInt32( i );
		aOldProfile.SetName( aStr );
	}


	aNewProfile.MoveTo( aOldProfile );

	SvFileStream aNewStream( aNewProfile.GetFullUni(), STREAM_READWRITE | STREAM_TRUNC );
	SvFileStream aOldStream( aOldProfile.GetFullUni(), STREAM_READ );
	ByteString aTmp, aTrim;
	do {
		aOldStream.ReadLine( aTmp );
		aTrim = aTmp;
		aTrim.EraseLeadingChars();
	} while (( aTrim.GetChar(0) == '#' ) && aNewStream.WriteLine( aTmp ));

	while ( aOldStream.ReadLine( aTmp ))
		aNewStream.WriteLine( aTmp );

	aNewStream.WriteLine( aLine );
	aNewStream.WriteLine( aTmp );

	return aOldProfile.GetName();
}

// ============================================================================
// ============================================================================

char* UnixOS::p_get_localhost()
{
	char p_local_host[ MAXHOSTNAMELEN ];

	if ( gethostname(p_local_host, MAXHOSTNAMELEN) == 0 )
		return strdup( p_local_host );
	else
		return "localhost" ;
}

char* UnixOS::p_get_exechost()
{
	static char* p_exec_host;
	static BOOL  b_done     = FALSE;

	if ( !b_done )
	{
		char *p_host_env = getenv("SO_REMOTE_SERVER");

		if ( (p_host_env != (char*)NULL) && (p_host_env[0] != '\0') )
			p_exec_host = strdup( p_host_env );
		else
		if ( (p_host_env != (char*)NULL) /* (p_host_env[0] == '\0') */ )
			p_exec_host = p_get_localhost();
		else
		/* ( (pHostEnv == (char*)NULL) ) */
			p_exec_host = NULL;

		b_done = TRUE;
	}

	return p_exec_host;
}

BOOL UnixOS::bSOfficeRemoteApplication()
{
	return p_get_exechost() != (char*)NULL ;
}

ByteString& UnixOS::rGetExecHostAction()
{
#if defined(USE_DTACTION)
	static ByteString aExecByteString =   ByteString("EXEC_HOST ")
								+ ByteString(p_get_exechost())
								+ ByteString(",${SOFFICE_EXEC_HOST}") ;
#else
	static ByteString aExecByteString =  ByteString("rsh ");
	aExecByteString += ByteString(p_get_exechost());
#endif
	return aExecByteString;
}

