/*************************************************************************
 *
 *  $RCSfile: jsnative.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: iha $ $Date: 2001/06/21 13:11:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _JSNATIVE_HXX
#define _JSNATIVE_HXX

#ifndef BOOL
#define BOOL	unsigned char
#endif

#ifndef TRUE
#define FALSE	0
#define TRUE	!FALSE
#endif

// --- defines & prototypes ---------------------------------------------------
#define JSNATIVE_VERSION 			"1"
#define MAX_ARGS					50

extern void Submit(int Error, const char* pFormat, ...);

// --- error codes ------------------------------------------------------------

#define RETURN_ERROR_NONE				0
#define RETURN_ERROR_GENERIC			1
#define RETURN_ERROR_NOTSUPPORTED		2
#define RETURN_ERROR_INVALIDCOMMAND		3
#define RETURN_ERROR_INVALIDPARAMETERS	4
#define RETURN_ERROR_MAKEDIR			5
#define RETURN_ERROR_REMOVEDIR			6
#define RETURN_ERROR_UNZIP				7
#define RETURN_ERROR_REBOOT_DELFILE		8
#define RETURN_ERROR_REBOOT_MOVELFILE	9

static const char* Errors[] =
{
	"0000",		// RETURN_ERROR_NONE
	"0001",		// RETURN_ERROR_GENERIC
	"0002",		// RETURN_ERROR_NOTSUPPORTED
	"0003",		// RETURN_ERROR_INVALIDCOMMAND
	"0004"		// RETURN_ERROR_INVALIDPARAMETERS
	"0005",		// RETURN_ERROR_MAKEDIR
	"0006",		// RETURN_ERROR_REMOVEDIR
	"0007",		// RETURN_ERROR_UNZIP
	"0008",		// RETURN_ERROR_REBOOT_DELFILE
	"0009"		// RETURN_ERROR_REBOOT_MOVELFILE
};

extern nLastError;

// --- class OS ---------------------------------------------------------------
class OS
{
protected:
		unsigned long			nLastPing;
public:
		virtual int 			Startup(int argc, char* argv[]) = 0;
		virtual void			Terminate() = 0;

		virtual void			ping() = 0;
		unsigned long			GetLastPing() const { return nLastPing; }

		// installation
		virtual void			GetSVersion( char* buf, int len ) = 0;
		virtual BOOL			makeDir( char* path, int rights ) = 0;
		virtual BOOL			removeDir( char* path ) = 0;

		virtual void			setDateTime( char* filename, int hour, int min, int sec, int day, int month, int year ) = 0;
		virtual void			setRights( char* filename, int rights ) = 0;

		virtual unsigned long 	GetFreeDriveSize( char* _cDrive ) = 0;
		virtual unsigned long 	GetClusterSize( char* _cDrive ) = 0;

		virtual void			getOSDir(char* buf) = 0;
		virtual void  			getOSSystemDir(char* buf) = 0;
		virtual void  			getOSsystemFontDir(char* buf) = 0;
		virtual void			getHomeDir(char* buf) = 0;
		virtual void			getConfigDir(char* buf) = 0;
		virtual void			getServiceDir(char* buf) = 0;
		virtual void			getOSShellnewDir(char* buf) = 0;
		virtual void			getAutoStart(char* buf) = 0;
		virtual void			getOSDesktopDir(char* buf) = 0;
		virtual void			getBookmarkDir(char* buf) = 0;
		virtual void			getPersonalDir(char* buf) = 0;
		virtual void			getIEPluginDir(char* buf, BOOL bPlugin = TRUE) = 0;
		virtual void			getIEDir(char* buf) = 0;
		virtual void			getNSPluginDir(char* buf) = 0;
		virtual void			getNS6PluginDir(char* buf) = 0;

		virtual void			setProfileString(char* filename, char* section, char* key, char* value);
		virtual void			getProfileString(char* filename, char* section, char* key, char* buf);
		virtual void			removeProfileString(char* filename, char* section, char* key);

		virtual void			createShortcut(char* source, char* destination, char* path, char* description, char* parameters) = 0;
		virtual void			createProgramFolder(char* name, BOOL user) = 0;
		virtual void			createProgramFolderItem(char* foldername, char* itemname, char* destpath,
									char* destexec, char* param, BOOL user ) = 0;
		virtual void			removeProgramFolder(char* name, BOOL user) = 0;
		virtual void			removeProgramFolderItem(char* foldername, char* itemname, BOOL user) = 0;

		virtual void			winRegistry(char* key, char* subkey, char* name, char* value,
									BOOL create, BOOL hex, BOOL deleteall, BOOL expand, BOOL bKeyOnly = FALSE ) = 0;

		virtual void			addFont(char* fontfile, char* fontname ) = 0;
		virtual void			removeFont(char* fontfile, char* fontname ) = 0;
		virtual BOOL			deleteFile(char* path, char* pattern, BOOL testdate,
									int hour, int min, int sec, int day, int month, int year ) = 0;
		virtual BOOL			copyFile(char* source, char* destination) = 0;
		virtual BOOL			unzipFile(char* source, char* pattern, char* destination) = 0;
		virtual void			getDriveList(char* buf) = 0;
		virtual void			moveFileAfterReboot(char* source, char* destination) = 0;
};


#endif
