/*************************************************************************
 *
 *  $RCSfile: sicustom.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: lla $ $Date: 2001/12/17 12:33:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SICUSTOM_HXX
#define _SICUSTOM_HXX

#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif

////////////////////////////////////////////////////////////////////////////////
//
//	Types
//
#define SICUSTOM_VERSION	1

#ifndef _SV_CALL
#if defined(WIN) || defined(WNT) || ( defined(OS2) && !defined( ICC ))
#define _SV_CALL	_cdecl
#elif (defined(OS2) && defined(ICC))
#define _SV_CALL 	__cdecl
#else
#define _SV_CALL
#endif
#endif

////////////////////////////////////////////////////////////////////////////////
//
//	SiCustomEnvironment
//
class SiEnvironment;
class SiCompiledScript;

struct EnvironmentImpl;


class SiCustomEnvironment
{
		EnvironmentImpl*	pImpl;
protected:
	friend class SiCustomAction;

	void				SetPreFlag(BOOL bPre);
	void 				SetInstallContext(BOOL bInst);
	void 				SetModifyContext(BOOL bModify);
	void 				SetRepairContext(BOOL bRepair);
	void				SetFirstInstallation(BOOL bNew = TRUE);
	void				SetResponse(BOOL bNew = TRUE);
	void 				SetResponseFileName(const ByteString& rStr);
	void				SetStartPath(const ByteString& rStr);
	void				SetSourcePath(const ByteString& rStr);
	void				SetDestPath(const ByteString& rStr);
	void				SetInstalledPath(const ByteString& rStr);
	void				SetEnvPtr(SiEnvironment* pPtr);
	void				SetCompiledScript( SiCompiledScript* pCScript );

public:
			SiCustomEnvironment();
			~SiCustomEnvironment();

	SiEnvironment*			GetBigEnv()				const;
    SiCompiledScript*       GetCompiledScript()     const;

	BOOL					IsResponseFileMode()  	const;
	ByteString				GetResponseFileName()	const;

	BOOL					IsFirstInstallation()	const;

	BOOL 					IsPre()					const;
	BOOL 					IsPost()				const;

	BOOL 					IsInstallation()		const;
	BOOL 					IsDeinstallation()		const;
	BOOL 					IsModify()              const;
	BOOL 					IsRepair()              const;

	const ByteString&		GetStartPath() 			const;
	const ByteString&		GetSourcePath() 		const;
	const ByteString&		GetDestPath() 			const;
	const ByteString&		GetInstalledPath()		const;

	virtual UniString       getProductName() const;
};

////////////////////////////////////////////////////////////////////////////////
//
//	SiCustomModuleInfo
//
struct ModuleInfoImpl;
class SiCustomAction;

class SiCustomModuleInfo
{
private:
	ModuleInfoImpl*		pImpl;
protected:
	friend class SiCustomAction;
	void				SetModuleID(const ByteString& rStr);
	void				SetModuleName(const ByteString& rStr);
public:
		SiCustomModuleInfo();
		~SiCustomModuleInfo();

	const ByteString&	GetModuleID()			const;
	const ByteString&	GetModuleName()			const;
	BOOL				IsSelected()			const;
	BOOL				IsInstalled()			const;

	void				SelectModule();
	void				DeselectModule();
	void				SetInstalled( BOOL bIsInstalled );
};

DECLARE_LIST(SiCustomModuleList, SiCustomModuleInfo*);

////////////////////////////////////////////////////////////////////////////////
//
//	FunctionPointer CustomDLL 	(Funktionen, die das Setup ruft)
//
typedef BOOL (_SV_CALL *FncPtrCustomMain)(SiCustomEnvironment*, SiCustomModuleList*);
extern "C" BOOL _SV_CALL CustomMain(SiCustomEnvironment*, SiCustomModuleList*);

typedef void (_SV_CALL *FncPtrKill)();
extern "C" void _SV_CALL Kill();

typedef BOOL (_SV_CALL *FncPtrSupportVersion)(const ByteString& rVersionKey);
extern "C" BOOL _SV_CALL SupportVersion(const ByteString& rVersionKey);

typedef void (_SV_CALL *FncPtrExecute)();
extern "C" void _SV_CALL Execute();

typedef ULONG (_SV_CALL *FncPtrExecuteCalc)();
extern "C" ULONG _SV_CALL ExecuteCalc();

////////////////////////////////////////////////////////////////////////////////
//
//	FunctionPointer Setup		(Funktionen, die die DLL am Setup rufen kann)
//
typedef void		(_SV_CALL *FncPtrHideSetup)();
typedef void		(_SV_CALL *FncPtrShowSetup)();
typedef ByteString	(_SV_CALL *FncPtrGetCodeFilename)();

////////////////////////////////////////////////////////////////////////////////
//
//	FunctionPointer Structures
//
struct SiCustomFnc
{
	USHORT						nVersion;
	FncPtrCustomMain			fncMain;
	FncPtrKill	 				fncKill;
	FncPtrSupportVersion		fncSupportVersion;
	FncPtrExecute				fncPtrExecute;
	FncPtrExecuteCalc			fncPtrExecuteCalc;
};

struct SiSetupFnc
{
	USHORT						nVersion;
	FncPtrHideSetup				fncHideSetup;
	FncPtrShowSetup				fncShowSetup;
	FncPtrGetCodeFilename		fncGetCodeFilename;
};

////////////////////////////////////////////////////////////////////////////////
//
//	MainEntryPoint CustomDLL (export)
//
extern "C" {
typedef BOOL (_SV_CALL *FncPtrCustomInit)(SiSetupFnc*, SiCustomFnc*);
BOOL _SV_CALL CustomInit(SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc);
};

#endif	// _SICUSTOM_HXX

