/*************************************************************************
 *
 *  $RCSfile: unoiview.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: vg $ $Date: 2001/10/19 08:48:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_DRAWING_XDRAWPAGE_HPP_
#include <com/sun/star/drawing/XDrawPage.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XSHAPEBINDER_HPP_
#include <com/sun/star/drawing/XShapeBinder.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XSHAPES_HPP_
#include <com/sun/star/drawing/XShapes.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XSHAPEGROUPER_HPP_
#include <com/sun/star/drawing/XShapeGrouper.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XSHAPECOMBINER_HPP_
#include <com/sun/star/drawing/XShapeCombiner.hpp>
#endif

#include <comphelper/extract.hxx>

#ifndef _VOS_MUTEX_HXX_ //autogen
#include <vos/mutex.hxx>
#endif

#include <svx/svdobj.hxx>
#include <svx/svdpagv.hxx>
#include <svx/unoshape.hxx>
#include <svx/unoshcol.hxx>

#include "unohelp.hxx"
#include "unopage.hxx"
#include "unomodel.hxx"
#include "sdview.hxx"
#include "drviewsh.hxx"
#include "drawdoc.hxx"
#include "unoiview.hxx"

#include "docshell.hxx"

using namespace ::vos;
using namespace ::rtl;
using namespace ::com::sun::star;

#define WID_VIEW_MASTERMODE	1
#define WID_VIEW_LAYERMODE	2

const SfxItemPropertyMap* ImplGetSdViewPropertyMap()
{
	static const SfxItemPropertyMap aSdViewPropertyMap_Impl[] =
	{
		{ MAP_CHAR_LEN("IsMasterPageMode"),		WID_VIEW_MASTERMODE,		&::getBooleanCppuType(),						0, 0},
		{ MAP_CHAR_LEN("IsLayerMode"),			WID_VIEW_LAYERMODE,			&::getBooleanCppuType(),						0, 0},
		{0,0,0,0,0}
	};

	return aSdViewPropertyMap_Impl;
}

extern text::XTextViewCursor* CreateSdXTextViewCursor( SdView* pView );

SdXImpressView::SdXImpressView(SdView* pSdView, SdDrawViewShell* pSdViewSh) throw()
:	SfxBaseController((SfxViewShell*)pSdViewSh),
	mpView(pSdView),
	mpViewSh(pSdViewSh),
	maPropSet(ImplGetSdViewPropertyMap())
{
}

SdXImpressView::~SdXImpressView() throw()
{
}


// XInterface
uno::Any SAL_CALL SdXImpressView::queryInterface( const uno::Type & rType )
	throw(uno::RuntimeException)
{
	uno::Any aAny;

	QUERYINT( view::XSelectionSupplier );
	else QUERYINT( drawing::XDrawView );
	else QUERYINT( lang::XServiceInfo );
	else QUERYINT( beans::XPropertySet );
	else QUERYINT( lang::XComponent );
	else
		return SfxBaseController::queryInterface(rType);

	return aAny;
}

void SAL_CALL SdXImpressView::acquire()
	throw ( )
{
	SfxBaseController::acquire();
}

void SAL_CALL SdXImpressView::release()
	throw ( )
{
	SfxBaseController::release();
}

// XTypeProvider
uno::Sequence< uno::Type > SAL_CALL SdXImpressView::getTypes() throw(uno::RuntimeException)
{
	if( maTypeSequence.getLength() == 0 )
	{
		const uno::Sequence< uno::Type > aBaseTypes( SfxBaseController::getTypes() );
		const sal_Int32 nBaseTypes = aBaseTypes.getLength();
		const uno::Type* pBaseTypes = aBaseTypes.getConstArray();

		const sal_Int32 nOwnTypes = 5;		// !DANGER! Keep this updated!

		maTypeSequence.realloc(  nBaseTypes + nOwnTypes );
		uno::Type* pTypes = maTypeSequence.getArray();

		*pTypes++ = ITYPE(view::XSelectionSupplier);
		*pTypes++ = ITYPE(drawing::XDrawView);
		*pTypes++ = ITYPE(lang::XServiceInfo);
		*pTypes++ = ITYPE(beans::XPropertySet);
		*pTypes++ = ITYPE(lang::XComponent);

		for( sal_Int32 nType = 0; nType < nBaseTypes; nType++ )
			*pTypes++ = *pBaseTypes++;
	}

	return maTypeSequence;
}

uno::Sequence< sal_Int8 > SAL_CALL SdXImpressView::getImplementationId() throw(uno::RuntimeException)
{
	static uno::Sequence< sal_Int8 > aId;
	if( aId.getLength() == 0 )
	{
		aId.realloc( 16 );
		rtl_createUuid( (sal_uInt8 *)aId.getArray(), 0, sal_True );
	}
	return aId;
}

// XServiceInfo
sal_Char pSdXImpressViewService[sizeof("com.sun.star.drawing.DrawingDocumentDrawView")] = "com.sun.star.drawing.DrawingDocumentDrawView";

OUString SAL_CALL SdXImpressView::getImplementationName(  ) throw(uno::RuntimeException)
{
	return OUString( RTL_CONSTASCII_USTRINGPARAM( "SdXImpressView" ) );
}

sal_Bool SAL_CALL SdXImpressView::supportsService( const OUString& ServiceName ) throw(uno::RuntimeException)
{
	return ServiceName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM( pSdXImpressViewService ) );
}

uno::Sequence< OUString > SAL_CALL SdXImpressView::getSupportedServiceNames(  ) throw(uno::RuntimeException)
{
	OUString aService( RTL_CONSTASCII_USTRINGPARAM( pSdXImpressViewService ) );
	uno::Sequence< OUString > aSeq( &aService, 1 );
	return aSeq;
}

// XSelectionSupplier
sal_Bool SAL_CALL SdXImpressView::select( const uno::Any& aSelection )
	throw(lang::IllegalArgumentException, uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	SdrPageView *pPV = mpView->GetPageViewPvNum(0);

	if(pPV == NULL)
		return sal_False;

	// first deselect all
	mpView->UnmarkAllObj( pPV );

	// if the any is empty, just deselect all
	if( !aSelection.hasValue() )
		return sal_True;

	uno::Reference< drawing::XShape > xShape;
	aSelection >>= xShape;

	// if the any is a shape, select it
	if(xShape.is())
	{
		SvxShape* pShape = SvxShape::getImplementation( xShape );
		if( pShape && pShape->GetSdrObject() )
		{
			SdrObject *pObj = pShape->GetSdrObject();
			if(pObj && pObj->GetPage() == pPV->GetPage())
			{
				mpView->MarkObj( pObj, pPV );
				return sal_True;
			}
		}
	}
	// else it must be a XShapes collection
	else
	{
		uno::Reference< drawing::XShapes > xShapes;
		aSelection >>= xShapes;
		if( xShapes.is() )
		{
			const sal_uInt32 nCount = xShapes->getCount();
			for( sal_uInt32 i = 0; i < nCount; i++ )
			{
				uno::Any aAny( xShapes->getByIndex(i) );
				if(::cppu::extractInterface( xShape, aAny ))
				{
					SvxShape* pShape = SvxShape::getImplementation(xShape);
					if( pShape )
					{
						SdrObject *pObj = pShape->GetSdrObject();
						if(pObj && pObj->GetPage() == pPV->GetPage())
						{
							mpView->MarkObj( pObj, pPV );
							return sal_True;
						}
					}
				}
			}
		}
	}

	// todo: add selections for text ranges
	return sal_False;
}

uno::Any SAL_CALL SdXImpressView::getSelection()
	throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	SdXImpressDocument* pModel = GetModel();

	uno::Reference< drawing::XShapes > xShapes( SvxShapeCollection_NewInstance(), uno::UNO_QUERY );

	if(mpView)
	{
		const SdrMarkList& rMarkList = mpView->GetMarkList();
		sal_uInt32 nCount = rMarkList.GetMarkCount();
		for( sal_uInt32 nNum = 0; nNum < nCount; nNum++)
		{
			SdrMark *pMark = rMarkList.GetMark(nNum);
			if(pMark==NULL)
				continue;

			SdrObject *pObj = pMark->GetObj();
			if(pObj==NULL || pObj->GetPage() == NULL)
				continue;

			uno::Reference< drawing::XDrawPage > xPage( pObj->GetPage()->getUnoPage(), uno::UNO_QUERY);

			if(!xPage.is())
				continue;

			SvxDrawPage* pDrawPage = SvxDrawPage::getImplementation( xPage );

			if(pDrawPage==NULL)
				continue;

			uno::Reference< drawing::XShape > xShape( pObj->getUnoShape(), uno::UNO_QUERY );

			if(xShape.is())
				xShapes->add(xShape);
		}
	}

	return uno::Any( &xShapes, ITYPE(drawing::XShapes) );
}

void SAL_CALL SdXImpressView::addSelectionChangeListener( const uno::Reference< view::XSelectionChangeListener >& xListener )
	throw(uno::RuntimeException)
{
}

void SAL_CALL SdXImpressView::removeSelectionChangeListener( const uno::Reference< view::XSelectionChangeListener >& xListener ) throw(uno::RuntimeException)
{
}

// XDrawView
void SAL_CALL SdXImpressView::setCurrentPage( const uno::Reference< drawing::XDrawPage >& xPage )
	throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if(mpView && xPage.is())
	{
		SvxDrawPage* pDrawPage = SvxDrawPage::getImplementation( xPage );

		if(!pDrawPage)
			return;

		SdrPage *pSdrPage = pDrawPage->GetSdrPage();
		if(!pSdrPage)
			return;

//		setMasterPageMode( pSdrPage->IsMasterPage() );
		if(mpViewSh && mpViewSh->GetEditMode() != EM_MASTERPAGE )
			mpViewSh->ChangeEditMode(pSdrPage->IsMasterPage()?EM_MASTERPAGE:EM_PAGE,mpViewSh->GetLayerMode());

		sal_uInt16 nSdPgNum = (pSdrPage->GetPageNum() - 1) / 2;
		mpViewSh->SwitchPage(nSdPgNum);
	}
}

uno::Reference< drawing::XDrawPage > SAL_CALL SdXImpressView::getCurrentPage(  )
	throw(uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	if(mpView)
	{
		SdXImpressDocument* pModel = GetModel();
		SdrPageView *pPV = mpView->GetPageViewPvNum(0);

		if(pPV && pModel)
		{
			SdrPage* pPage = pPV->GetPage();

			if(pPage)
			{
				uno::Reference< drawing::XDrawPage >  xPage( pPage->getUnoPage(), uno::UNO_QUERY );
				return xPage;
			}
		}
	}

	uno::Reference< drawing::XDrawPage >  xPage;
	return xPage;
}

// intern

sal_Bool SdXImpressView::getMasterPageMode(void) const throw()
{
	OGuard aGuard( Application::GetSolarMutex() );

	return mpViewSh && mpViewSh->GetEditMode() == EM_MASTERPAGE;
}

void SdXImpressView::setMasterPageMode(sal_Bool MasterPageMode_) throw()
{
	OGuard aGuard( Application::GetSolarMutex() );

	if(mpViewSh && getMasterPageMode() != MasterPageMode_)
		mpViewSh->ChangeEditMode(MasterPageMode_?EM_MASTERPAGE:EM_PAGE,mpViewSh->GetLayerMode());
}

sal_Bool SdXImpressView::getLayerMode(void) const throw()
{
	OGuard aGuard( Application::GetSolarMutex() );

	return mpViewSh && mpViewSh->GetLayerMode();
}

void SdXImpressView::setLayerMode(sal_Bool LayerMode_) throw()
{
	OGuard aGuard( Application::GetSolarMutex() );

	if(mpViewSh && getLayerMode() != LayerMode_)
		mpViewSh->ChangeEditMode(mpViewSh->GetEditMode(),LayerMode_);
}

/******************************************************************************
* Trennt diesen SdXImpressView vom eigentlichen sdbcx::View setzen des mpView Zeigers *
* auf Null. Dieser Zustand *muss* von jeder Methode beachtet werden.          *
*******************************************************************************/
void SdXImpressView::Invalidate() throw()
{
	mpView = NULL;
}

/******************************************************************************
* Ermittelt das Model fuer diesen View.										  *
*******************************************************************************/
SdXImpressDocument* SdXImpressView::GetModel() const throw()
{
	if(mpView && mpView->GetDocSh())
	{
		uno::Reference< frame::XModel > xModel( mpView->GetDocSh()->GetModel() );
		return SdXImpressDocument::getImplementation( xModel );
	}
	else
		return NULL;
}

//XTextViewCursorSupplier
uno::Reference< text::XTextViewCursor > SAL_CALL SdXImpressView::getViewCursor()
	throw( uno::RuntimeException )
{
	NAMESPACE_VOS(OGuard) aGuard(Application::GetSolarMutex());

	if(mpView == NULL)
		throw uno::RuntimeException();

	if(!mxTextViewCursor.is())
		mxTextViewCursor = CreateSdXTextViewCursor(mpView);

	return mxTextViewCursor;
}

//XPropertySet
::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > SAL_CALL SdXImpressView::getPropertySetInfo()
	throw(::com::sun::star::uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );
	return maPropSet.getPropertySetInfo();
}

void SAL_CALL SdXImpressView::setPropertyValue( const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Any& aValue )
	throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::beans::PropertyVetoException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	const SfxItemPropertyMap* pMap = maPropSet.getPropertyMapEntry(aPropertyName);

	if( pMap && pMap->nWID )
	{
		switch(pMap->nWID)
		{
		case WID_VIEW_MASTERMODE:
			setMasterPageMode( ::cppu::any2bool(aValue) );
			break;
		case WID_VIEW_LAYERMODE:
			setLayerMode( ::cppu::any2bool(aValue) );
			break;
		}
	}
	else
	{
		throw beans::UnknownPropertyException(); 
	}
}

::com::sun::star::uno::Any SAL_CALL SdXImpressView::getPropertyValue( const ::rtl::OUString& PropertyName )
	throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{
	OGuard aGuard( Application::GetSolarMutex() );

	uno::Any aRet;

	const SfxItemPropertyMap* pMap = maPropSet.getPropertyMapEntry(PropertyName);

	if( pMap && pMap->nWID )
	{
		switch(pMap->nWID)
		{
		case WID_VIEW_MASTERMODE:
			aRet = ::cppu::bool2any( getMasterPageMode() );
			break;
		case WID_VIEW_LAYERMODE:
			aRet = ::cppu::bool2any( getLayerMode() );
			break;
		}
	}
	else
	{
		throw beans::UnknownPropertyException(); 
	}

	return aRet;
}

void SAL_CALL SdXImpressView::addPropertyChangeListener( const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener >& xListener )
	throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{
}

void SAL_CALL SdXImpressView::removePropertyChangeListener( const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener >& aListener )
	throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{
}

void SAL_CALL SdXImpressView::addVetoableChangeListener( const ::rtl::OUString& PropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XVetoableChangeListener >& aListener )
	throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{
}

void SAL_CALL SdXImpressView::removeVetoableChangeListener( const ::rtl::OUString& PropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XVetoableChangeListener >& aListener )
	throw(::com::sun::star::beans::UnknownPropertyException, ::com::sun::star::lang::WrappedTargetException, ::com::sun::star::uno::RuntimeException)
{
}



