/*************************************************************************
 *
 *  $RCSfile: basemodel.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2001/12/07 16:08:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_VIEW_XSELECTIONSUPPLIER_HPP_ 
#include <com/sun/star/view/XSelectionSupplier.hpp>
#endif

#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX
#include <cppuhelper/interfacecontainer.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_ 
#include <com/sun/star/lang/DisposedException.hpp>
#endif

#ifndef _COM_SUN_STAR_AWT_SIZE_HPP_ 
#include <com/sun/star/awt/Size.hpp>
#endif

#ifndef _SV_GEN_HXX
#include <vcl/gen.hxx>
#endif

#ifndef _SD_BASEMODEL_HXX_
#include "basemodel.hxx"
#endif

// defines
#define	SfxIOException_Impl( nErr )				::com::sun::star::io::IOException()

#define	XFRAME									::com::sun::star::frame::XFrame
#define	XINTERFACE								::com::sun::star::uno::XInterface
#define	OMULTITYPEINTERFACECONTAINERHELPER		::cppu::OMultiTypeInterfaceContainerHelper
#define	UNO_QUERY								::com::sun::star::uno::UNO_QUERY
#define	DISPOSEDEXCEPTION						::com::sun::star::lang::DisposedException
#define	MAPPING									::com::sun::star::uno::Mapping
#define	XSELECTIONSUPPLIER						::com::sun::star::view::XSelectionSupplier
#define	ANY										::com::sun::star::uno::Any
#define	ILLEGALARGUMENTEXCEPTION				::com::sun::star::lang::IllegalArgumentException
#define	OINTERFACECONTAINERHELPER               ::cppu::OInterfaceContainerHelper
#define	OINTERFACEITERATORHELPER				::cppu::OInterfaceIteratorHelper
#define	SIZE									::com::sun::star::awt::Size
#define	PAPERFORMAT								::com::sun::star::view::PaperFormat
#define	PAPERORIENTATION						::com::sun::star::view::PaperOrientation
#define OTYPECOLLECTION							::cppu::OTypeCollection
#define OIMPLEMENTATIONID						::cppu::OImplementationId
#define	MUTEXGUARD								::osl::MutexGuard

struct IMPL_SdBaseModel_DataContainer
{
	SdDrawDocShell*									m_pObjectShell			;
	OUSTRING										m_sURL					;
	sal_uInt16										m_nControllerLockCount	;
	OMULTITYPEINTERFACECONTAINERHELPER				m_aInterfaceContainer	;
	REFERENCE< XINTERFACE >							m_xParent				;
	REFERENCE< XCONTROLLER >						m_xCurrent				;
	REFERENCE< XDOCUMENTINFO >						m_xDocumentInfo			;
	REFERENCE< XSTARBASICACCESS >					m_xStarBasicAccess		;
	REFERENCE< XNAMEREPLACE >						m_xEvents				;
	SEQUENCE< PROPERTYVALUE>						m_seqArguments			;
	SEQUENCE< REFERENCE< XCONTROLLER > >			m_seqControllers		;

	IMPL_SdBaseModel_DataContainer::IMPL_SdBaseModel_DataContainer(	MUTEX&			aMutex			,
																		SdDrawDocShell*	pObjectShell	)
			:	m_pObjectShell			( pObjectShell	)
			,	m_nControllerLockCount	( 0				)
			,	m_aInterfaceContainer	( aMutex		)
	{
	}

} ;

SIZE impl_Size_Object2Struct( const Size& aSize )
{
	SIZE aReturnValue;

	aReturnValue.Width  = aSize.Width()  ;
	aReturnValue.Height = aSize.Height() ;

	return aReturnValue ;
}

Size impl_Size_Struct2Object( const SIZE& aSize )
{
	Size aReturnValue;

	aReturnValue.Width()  = aSize.Width  ;
	aReturnValue.Height() = aSize.Height ;

	return aReturnValue ;
}

// constructor
SdBaseModel::SdBaseModel( SdDrawDocShell *pObjectShell )
:	IMPL_SdBaseModel_MutexContainer(),
	m_pData( new IMPL_SdBaseModel_DataContainer( m_aMutex, pObjectShell )	)
{
}

// destructor
SdBaseModel::~SdBaseModel()
{
	delete m_pData ;
}

// XInterface
//________________________________________________________________________________________________________

ANY SAL_CALL SdBaseModel::queryInterface( const UNOTYPE& rType ) throw( RUNTIMEEXCEPTION )
{
	// Ask for my own supported interfaces ...
	ANY aReturn( ::cppu::queryInterface(	rType											,
									   		static_cast< XTYPEPROVIDER*			> ( this )	,
									   		static_cast< XCHILD*				> ( this )	,
									   		static_cast< XDOCUMENTINFOSUPPLIER*	> ( this )	,
									   		static_cast< XEVENTLISTENER*		> ( this )	,
									   		static_cast< XMODEL*				> ( this )	,
									   		static_cast< XMODIFIABLE*			> ( this )	,
                                            static_cast< XMODIFYBROADCASTER*    > ( this )  ,
                                            static_cast< XCOMPONENT*            > ( this )  ,
									   		static_cast< XSTARBASICACCESS*		> ( this )	,
									   		static_cast< XEVENTBROADCASTER*		> ( this )	,
									   		static_cast< XEVENTSSUPPLIER*		> ( this )	) ) ;

	if ( aReturn.hasValue() == sal_True )
	{
		return aReturn ;
	}
	else
	{
		return OWeakObject::queryInterface( rType ) ;
	}
}

void SAL_CALL SdBaseModel::acquire() throw()
{
	OWeakObject::acquire() ;
}

void SAL_CALL SdBaseModel::release() throw()
{
	OWeakObject::release() ;
}

// XTypeProvider
SEQUENCE< UNOTYPE > SAL_CALL SdBaseModel::getTypes() throw( RUNTIMEEXCEPTION )
{
	// Optimize this method !
	// We initialize a static variable only one time. And we don't must use a mutex at every call!
	// For the first call; pTypeCollection is NULL - for the second call pTypeCollection is different from NULL!
	static OTYPECOLLECTION* pTypeCollection = NULL ;

	if ( pTypeCollection == NULL )
	{
		// Ready for multithreading; get global mutex for first call of this method only! see before
		MUTEXGUARD aGuard( MUTEX::getGlobalMutex() ) ;

		// Control these pointer again ... it can be, that another instance will be faster then these!
		if ( pTypeCollection == NULL )
		{
			// Create a static typecollection ...
			static OTYPECOLLECTION aTypeCollection(	::getCppuType(( const REFERENCE< XTYPEPROVIDER			>*)NULL ) ,
												  	::getCppuType(( const REFERENCE< XCHILD					>*)NULL ) ,
												  	::getCppuType(( const REFERENCE< XDOCUMENTINFOSUPPLIER	>*)NULL ) ,
												  	::getCppuType(( const REFERENCE< XEVENTLISTENER			>*)NULL ) ,
												  	::getCppuType(( const REFERENCE< XMODEL					>*)NULL ) ,
												  	::getCppuType(( const REFERENCE< XMODIFIABLE			>*)NULL ) ,
												  	::getCppuType(( const REFERENCE< XSTARBASICACCESS		>*)NULL ) ,
												  	::getCppuType(( const REFERENCE< XEVENTBROADCASTER		>*)NULL ) ,
												  	::getCppuType(( const REFERENCE< XEVENTSSUPPLIER		>*)NULL ) ) ;

			// ... and set his address to static pointer!
			pTypeCollection = &aTypeCollection ;
		}
	}

	return pTypeCollection->getTypes() ;
}

SEQUENCE< sal_Int8 > SAL_CALL SdBaseModel::getImplementationId() throw( RUNTIMEEXCEPTION )
{
	static OIMPLEMENTATIONID* pID = NULL ;

	if ( pID == NULL )
	{
		// Ready for multithreading; get global mutex for first call of this method only! see before
		MUTEXGUARD aGuard( MUTEX::getGlobalMutex() ) ;

		// Control these pointer again ... it can be, that another instance will be faster then these!
		if ( pID == NULL )
		{
			// Create a new static ID ...
			static OIMPLEMENTATIONID aID( sal_False ) ;
			// ... and set his address to static pointer!
			pID = &aID ;
		}
	}

	return pID->getImplementationId() ;
}

/*
// XStarBasicAccess
REFERENCE< XSTARBASICACCESS > implGetStarBasicAccess( SfxObjectShell* pObjectShell )
{
	REFERENCE< XSTARBASICACCESS > xRet;
	if( pObjectShell )
	{
		BasicManager* pMgr = pObjectShell->GetBasicManager();
		xRet = getStarBasicAccess( pMgr );
	}
	return xRet;
}
*/

REFERENCE< XNAMECONTAINER > SAL_CALL SdBaseModel::getLibraryContainer() throw( RUNTIMEEXCEPTION )
{
	REFERENCE< XNAMECONTAINER > xRet;
#if 0
	REFERENCE< XSTARBASICACCESS >& rxAccess = m_pData->m_xStarBasicAccess;
	if( !rxAccess.is() )
		rxAccess = implGetStarBasicAccess( m_pData->m_pObjectShell );

	if( rxAccess.is() )
		xRet = rxAccess->getLibraryContainer();
#endif
	return xRet;
}

void SAL_CALL SdBaseModel::createLibrary( const OUSTRING& LibName, const OUSTRING& Password,
	const OUSTRING& ExternalSourceURL, const OUSTRING& LinkTargetURL )
		throw(ELEMENTEXISTEXCEPTION, RUNTIMEEXCEPTION)
{
#if 0
	REFERENCE< XSTARBASICACCESS >& rxAccess = m_pData->m_xStarBasicAccess;
	if( !rxAccess.is() )
		rxAccess = implGetStarBasicAccess( m_pData->m_pObjectShell );

	if( rxAccess.is() )
		rxAccess->createLibrary( LibName, Password, ExternalSourceURL, LinkTargetURL );
#endif
}

void SAL_CALL SdBaseModel::addModule( const OUSTRING& LibraryName, const OUSTRING& ModuleName,
	const OUSTRING& Language, const OUSTRING& Source )
		throw( NOSUCHELEMENTEXCEPTION, RUNTIMEEXCEPTION)
{
#if 0
	REFERENCE< XSTARBASICACCESS >& rxAccess = m_pData->m_xStarBasicAccess;
	if( !rxAccess.is() )
		rxAccess = implGetStarBasicAccess( m_pData->m_pObjectShell );

	if( rxAccess.is() )
		rxAccess->addModule( LibraryName, ModuleName, Language, Source );
#endif
}

void SAL_CALL SdBaseModel::addDialog( const OUSTRING& LibraryName, const OUSTRING& DialogName,
	const ::com::sun::star::uno::Sequence< sal_Int8 >& Data )
		throw(NOSUCHELEMENTEXCEPTION, RUNTIMEEXCEPTION)
{
#if 0
	REFERENCE< XSTARBASICACCESS >& rxAccess = m_pData->m_xStarBasicAccess;
	if( !rxAccess.is() )
		rxAccess = implGetStarBasicAccess( m_pData->m_pObjectShell );

	if( rxAccess.is() )
		rxAccess->addDialog( LibraryName, DialogName, Data );
#endif
}


// XChild
REFERENCE< XINTERFACE > SAL_CALL SdBaseModel::getParent() throw( RUNTIMEEXCEPTION )
{
	return m_pData->m_xParent;
}

void SAL_CALL SdBaseModel::setParent(const REFERENCE< XINTERFACE >& Parent) throw(NOSUPPORTEXCEPTION, RUNTIMEEXCEPTION)
{
	if ( Parent.is() && getParent().is() )
		// only set parent when no parent is available
		throw NOSUPPORTEXCEPTION();

	m_pData->m_xParent = Parent;
}

void SAL_CALL SdBaseModel::dispose() throw (RUNTIMEEXCEPTION)
{
	// object already disposed?
	if ( IsDisposed() )
		throw DISPOSEDEXCEPTION();

	EVENTOBJECT aEvent( (XMODEL *)this );
	m_pData->m_aInterfaceContainer.disposeAndClear( aEvent );

#if 0
	// is an object shell assigned?
	if ( m_pData->m_pObjectShell )
	{
		// Rekursion vermeiden
        SfxObjectShell *pShell;
        ::vos::OGuard aGuard( Application::GetSolarMutex() );
        {
            ::osl::MutexGuard aGuard( m_aMutex );
            pShell = m_pData->m_pObjectShell;
            EndListening( *pShell );
            m_pData->m_pObjectShell = NULL;
        }

		// Bei dispose keine Speichern-R"uckfrage
		if ( pShell->IsEnableSetModified() && !pShell->Get_Impl()->bClosing )
			pShell->SetModified( sal_False );
		SfxObjectShellClose_Impl( 0, (void*) pShell );
	}
#endif

    ::osl::MutexGuard aGuard( m_aMutex );
	m_pData->m_xCurrent = REFERENCE< XCONTROLLER > ();
	m_pData->m_seqControllers = SEQUENCE< REFERENCE< XCONTROLLER > > () ;
}

void SAL_CALL SdBaseModel::addEventListener( const REFERENCE< XEVENTLISTENER >& aListener ) throw (RUNTIMEEXCEPTION)
{
	// object already disposed?
	if ( IsDisposed() )
		return;

	m_pData->m_aInterfaceContainer.addInterface( ::getCppuType((const REFERENCE< XEVENTLISTENER >*)0), aListener );
}

void SAL_CALL SdBaseModel::removeEventListener( const REFERENCE< XEVENTLISTENER >& aListener ) throw (RUNTIMEEXCEPTION)
{
	// object already disposed?
	if ( IsDisposed() )
		return;

	m_pData->m_aInterfaceContainer.removeInterface( ::getCppuType((const REFERENCE< XEVENTLISTENER >*)0), aListener );
}

// XDOCUMENTINFOSupplier
REFERENCE< XDOCUMENTINFO > SAL_CALL SdBaseModel::getDocumentInfo() throw (RUNTIMEEXCEPTION)
{
#if 0
	// object already disposed?
	if ( IsDisposed() )
		throw DISPOSEDEXCEPTION();

    ::osl::MutexGuard aGuard( m_aMutex );
	if ( !m_pData->m_xDocumentInfo.is() && m_pData->m_pObjectShell )
    {
        ::vos::OGuard aGuard( Application::GetSolarMutex() );
		((SdBaseModel*)this)->m_pData->m_xDocumentInfo = new SfxDocumentInfoObject( m_pData->m_pObjectShell ) ;
    }

	return m_pData->m_xDocumentInfo;
#endif
	REFERENCE< XDOCUMENTINFO > xInfo;
	return xInfo;
}

// XEVENTLISTENER
void SAL_CALL SdBaseModel::disposing( const EVENTOBJECT& aObject ) throw (RUNTIMEEXCEPTION)
{
    REFERENCE< XMODIFYLISTENER >  xMod( aObject.Source, UNO_QUERY );
    REFERENCE< XEVENTLISTENER >  xListener( aObject.Source, UNO_QUERY );
    REFERENCE< XDOCEVENTLISTENER >  xDocListener( aObject.Source, UNO_QUERY );

    if ( xMod.is() )
        m_pData->m_aInterfaceContainer.removeInterface( ::getCppuType((const REFERENCE< XMODIFYLISTENER >*)0), xMod );
    else if ( xListener.is() )
        m_pData->m_aInterfaceContainer.removeInterface( ::getCppuType((const REFERENCE< XEVENTLISTENER >*)0), xListener );
    else if ( xDocListener.is() )
        m_pData->m_aInterfaceContainer.removeInterface( ::getCppuType((const REFERENCE< XDOCEVENTLISTENER >*)0), xListener );

    ::osl::MutexGuard aGuard( m_aMutex );
	sal_uInt32 nCount = m_pData->m_seqControllers.getLength();
	for ( sal_uInt32 n = 0; n < nCount; n++ )
	{
		if( m_pData->m_seqControllers.getConstArray()[n] == aObject.Source )
		{
			m_pData->m_seqControllers.getArray()[n] = REFERENCE< XCONTROLLER > () ;
			break;
		}
	}

	if ( m_pData->m_xCurrent.is() && m_pData->m_xCurrent == aObject.Source )
		m_pData->m_xCurrent = REFERENCE< XCONTROLLER > ();
}

// XMODEL
sal_Bool SAL_CALL SdBaseModel::attachResource( const OUSTRING& rURL, const SEQUENCE< PROPERTYVALUE >& rArgs ) throw (::com::sun::star::uno::RuntimeException)
{
    ::osl::MutexGuard aGuard( m_aMutex );
	m_pData->m_sURL			=	rURL	;
	m_pData->m_seqArguments	=	rArgs	;
	return sal_True ;
}

OUSTRING SAL_CALL SdBaseModel::getURL() throw (RUNTIMEEXCEPTION)
{
    ::osl::MutexGuard aGuard( m_aMutex );
	return m_pData->m_sURL ;
}

SEQUENCE< PROPERTYVALUE > SAL_CALL SdBaseModel::getArgs() throw (RUNTIMEEXCEPTION)
{
    ::osl::MutexGuard aGuard( m_aMutex );
	return m_pData->m_seqArguments ;
}

void SAL_CALL SdBaseModel::connectController( const REFERENCE< XCONTROLLER >& xController ) throw (RUNTIMEEXCEPTION)
{
    ::osl::MutexGuard aGuard( m_aMutex );
	sal_uInt32 nOldCount = m_pData->m_seqControllers.getLength();
	SEQUENCE< REFERENCE< XCONTROLLER > > aNewSeq( nOldCount + 1 );
	for ( sal_uInt32 n = 0; n < nOldCount; n++ )
		aNewSeq.getArray()[n] = m_pData->m_seqControllers.getConstArray()[n];
	aNewSeq.getArray()[nOldCount] = xController;
	m_pData->m_seqControllers = aNewSeq;
}

void SAL_CALL SdBaseModel::disconnectController( const REFERENCE< XCONTROLLER >& xController ) throw (RUNTIMEEXCEPTION)
{
    ::osl::MutexGuard aGuard( m_aMutex );
	sal_uInt32 nOldCount = m_pData->m_seqControllers.getLength();
	SEQUENCE< REFERENCE< XCONTROLLER > > aNewSeq( nOldCount - 1 );
	for ( sal_uInt32 nOld = 0, nNew = 0; nOld < nOldCount; ++nOld )
		if ( xController != m_pData->m_seqControllers.getConstArray()[nOld] )
		{
			aNewSeq.getArray()[nNew] = m_pData->m_seqControllers.getConstArray()[nOld];
			++nNew;
		}
	m_pData->m_seqControllers = aNewSeq;

	if ( xController == m_pData->m_xCurrent )
		m_pData->m_xCurrent = REFERENCE< XCONTROLLER > ();
}

void SAL_CALL SdBaseModel::lockControllers() throw (RUNTIMEEXCEPTION)
{
	++m_pData->m_nControllerLockCount ;
}

void SAL_CALL SdBaseModel::unlockControllers() throw (RUNTIMEEXCEPTION)
{
	--m_pData->m_nControllerLockCount ;
}

sal_Bool SAL_CALL SdBaseModel::hasControllersLocked() throw (RUNTIMEEXCEPTION)
{
	return ( m_pData->m_nControllerLockCount != 0 ) ;
}

REFERENCE< XCONTROLLER > SAL_CALL SdBaseModel::getCurrentController() throw (RUNTIMEEXCEPTION)
{
	// object already disposed?
	if ( IsDisposed() )
		throw DISPOSEDEXCEPTION();

    // get the last active controller of this model
    ::osl::MutexGuard aGuard( m_aMutex );
	if ( m_pData->m_xCurrent.is() )
		return m_pData->m_xCurrent;

	// get the first controller of this model
	return m_pData->m_seqControllers.getLength() ? m_pData->m_seqControllers.getConstArray()[0] : m_pData->m_xCurrent;
}

void SAL_CALL SdBaseModel::setCurrentController( const REFERENCE< XCONTROLLER >& xCurrentController ) throw (NOSUCHELEMENTEXCEPTION, RUNTIMEEXCEPTION)
{
	// object already disposed?
	if ( IsDisposed() )
		throw DISPOSEDEXCEPTION();

    ::osl::MutexGuard aGuard( m_aMutex );
	m_pData->m_xCurrent = xCurrentController;
}

REFERENCE< XINTERFACE > SAL_CALL SdBaseModel::getCurrentSelection() throw (RUNTIMEEXCEPTION)
{
	// object already disposed?
	if ( IsDisposed() )
		throw DISPOSEDEXCEPTION();

    REFERENCE< XINTERFACE > xReturn;
	REFERENCE< XCONTROLLER > xController( getCurrentController() );

	if ( xController.is() )
	{
		REFERENCE< XSELECTIONSUPPLIER >  xDocView( xController, UNO_QUERY );
		if ( xDocView.is() )
			xDocView->getSelection() >>= xReturn;
	}

	return xReturn ;
}

sal_Bool SAL_CALL SdBaseModel::isModified() throw (RUNTIMEEXCEPTION)
{
	return sal_False;
}

void SAL_CALL SdBaseModel::setModified( sal_Bool bModified ) throw (PROPERTYVETOEXCEPTION, RUNTIMEEXCEPTION)
{
}

void SAL_CALL SdBaseModel::addModifyListener(const REFERENCE< XMODIFYLISTENER >& xListener) throw( RUNTIMEEXCEPTION )
{
}

void SAL_CALL SdBaseModel::removeModifyListener(const REFERENCE< XMODIFYLISTENER >& xListener) throw( RUNTIMEEXCEPTION )
{
}

// XEventsSupplier
REFERENCE< XNAMEREPLACE > SAL_CALL SdBaseModel::getEvents() throw( RUNTIMEEXCEPTION )
{
#if 0
	// object already disposed?
	if ( IsDisposed() )
		return NULL;

	if ( ! m_pData->m_xEvents.is() )
	{
		m_pData->m_xEvents = new SfxEvents_Impl( m_pData->m_pObjectShell, this );
	}
#endif
	return m_pData->m_xEvents;
}

void SAL_CALL SdBaseModel::addEventListener( const REFERENCE< XDOCEVENTLISTENER >& aListener ) throw( RUNTIMEEXCEPTION )
{
}

// XEventBroadcaster
void SAL_CALL SdBaseModel::removeEventListener( const REFERENCE< XDOCEVENTLISTENER >& aListener ) throw( RUNTIMEEXCEPTION )
{
}

// SfxListener
void SdBaseModel::Notify(			SfxBroadcaster&	rBC		,
	 						const	SfxHint&		rHint	)
{
#if 0
	if ( &rBC == m_pData->m_pObjectShell )
	{
		SfxSimpleHint* pSimpleHint = PTR_CAST( SfxSimpleHint, &rHint );
		if ( pSimpleHint && pSimpleHint->GetId() == SFX_HINT_DOCCHANGED )
			changing();
		SfxEventHint* pNamedHint = PTR_CAST( SfxEventHint, &rHint );
		if ( pNamedHint )
			postEvent_Impl( *pNamedHint );
	}
#endif
}

// public impl.

void SdBaseModel::changing()
{
	// object already disposed?
	if ( IsDisposed() )
		return;

	OINTERFACECONTAINERHELPER* pIC = m_pData->m_aInterfaceContainer.getContainer( ::getCppuType((const REFERENCE< XMODIFYLISTENER >*)0) );
	if( pIC )

	{
		EVENTOBJECT aEvent( (XMODEL *)this );
		OINTERFACEITERATORHELPER aIt( *pIC );
		while( aIt.hasMoreElements() )
			((XMODIFYLISTENER *)aIt.next())->modified( aEvent );
	}
}

void SdBaseModel::impl_change()
{
	// object already disposed?
	if ( IsDisposed() )
		return;

	OINTERFACECONTAINERHELPER* pIC = m_pData->m_aInterfaceContainer.getContainer( ::getCppuType((const REFERENCE< XMODIFYLISTENER >*)0) );
	if( pIC )

	{
		EVENTOBJECT aEvent( (XMODEL *)this );
		OINTERFACEITERATORHELPER aIt( *pIC );
		while( aIt.hasMoreElements() )
			((XMODIFYLISTENER *)aIt.next())->modified( aEvent );
	}
}

SdDrawDocShell* SdBaseModel::GetObjectShell() const
{
	return m_pData ? m_pData->m_pObjectShell : 0;
}

sal_Bool SdBaseModel::IsDisposed() const
{
	return ( m_pData == NULL ) ;
}

