/*************************************************************************
 *
 *  $RCSfile: docshell.hxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: ka $ $Date: 2002/01/09 16:42:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SD_DOCSHELL_HXX
#define _SD_DOCSHELL_HXX

#ifndef _SFX_OBJFAC_HXX //autogen
#include <sfx2/docfac.hxx>
#endif
#ifndef _SFX_INTERNO_HXX //autogen
#include <sfx2/interno.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif
#ifndef _SVX_SVXIFACT_HXX //autogen
#include <svx/svxifact.hxx>
#endif

#include <sot/factory.hxx>
#include <so3/factory.hxx>
#include <so3/factory.hxx>


#ifndef _SD_GLOB_HXX
#include "glob.hxx"
#endif
#ifndef _SDMOD_HXX
#include "sdmod.hxx"
#endif
#ifndef _PRESENTATION_HXX
#include "pres.hxx"
#endif

#ifndef SO2_DECL_SVSTORAGESTREAM_DEFINED
#define SO2_DECL_SVSTORAGESTREAM_DEFINED
SO2_DECL_REF(SvStorageStream)
#endif

class SfxStyleSheetBasePool;
class SfxStatusBarManager;
class SdStyleSheetPool;
class FontList;
class FrameView;
class SdDrawDocument;
class SdViewShell;
class SdView;
class FuPoor;
class SvxItemFactory;
class SdPage;
class SfxPrinter;
struct SdrDocumentStreamInfo;

// #91457#
struct SpellCallbackInfo;

/*************************************************************************
|*
|* Document-Shell fuer Draw-Dokumente
|*
\************************************************************************/

class SdDrawDocShell : public SfxObjectShell, public SfxInPlaceObject
{
 protected:
	SfxProgress*		   	pProgress;

	SdDrawDocument* 		pDoc;
	SfxUndoManager* 		pUndoManager;
	SfxPrinter* 			pPrinter;
	SdViewShell*			pViewShell;
	FontList*				pFontList;
	FuPoor* 				pFuActual;
	DocumentType            eDocType;

	void					Construct();
	BOOL					bUIActive;
	BOOL					bSdDataObj;
//	SfxStatusBarManager*	pStbMgr;
	BOOL                    bInDestruction;
	const USHORT*           pFilterSIDs;    // die SlotIDs des Filters
	USHORT                  nFilterCount;   // Anzahl der SlotIDs im Filter
	BOOL                    bFilterEnable;  // SlotIDs erlauben oder verbieten
	BOOL 					bOwnPrinter;
	UINT16					nStyleFamily;

	static SfxProgress*		mpSpecialProgress;
	static Link*			mpSpecialProgressHdl;

 public:
	TYPEINFO();

	SFX_DECL_INTERFACE(SD_IF_SDDRAWDOCSHELL);


	SFX_DECL_OBJECTFACTORY_DLL(SdDrawDocShell, SD_MOD());

	SdDrawDocShell(SfxObjectCreateMode eMode = SFX_CREATE_MODE_EMBEDDED,
				   BOOL bSdDataObj=FALSE, DocumentType=DOCUMENT_TYPE_IMPRESS);
	SdDrawDocShell(SdDrawDocument* pDoc, SfxObjectCreateMode eMode = SFX_CREATE_MODE_EMBEDDED,
				   BOOL bSdDataObj=FALSE, DocumentType=DOCUMENT_TYPE_IMPRESS);
	~SdDrawDocShell();

	virtual void	Activate( BOOL bMDI );
	virtual void	Deactivate( BOOL bMDI );

	virtual BOOL	InitNew( SvStorage * );
	virtual BOOL	Load( SvStorage * );
	virtual BOOL	LoadFrom(SvStorage* pStor);
	virtual BOOL	ConvertFrom( SfxMedium &rMedium );
	virtual void	HandsOff();
	virtual BOOL	Save();
	virtual BOOL	SaveAs( SvStorage * pNewStor );
	virtual BOOL    SaveAsOwnFormat( SfxMedium& rMedium );
	virtual BOOL    ConvertTo( SfxMedium &rMedium );
	virtual BOOL	SaveCompleted( SvStorage * pNewStor );

	virtual void	  UIActivate( BOOL bActive );
	BOOL					  IsUIActive() { return bUIActive; }
	virtual void	  SetVisArea(const Rectangle& rRect);
	virtual Rectangle GetVisArea(USHORT nAspect) const;

	virtual void	Draw(OutputDevice*, const JobSetup& rSetup,
						 USHORT nAspect = ASPECT_CONTENT);

	virtual SfxUndoManager* GetUndoManager();

	FuPoor* 		GetActualFunction() const { return pFuActual; }

	void			CancelSearching();

	SfxPrinter*     GetPrinter(BOOL bCreate);
	void			SetPrinter(SfxPrinter *pNewPrinter);

	virtual Printer* GetDocumentPrinter();
	virtual void     OnDocumentPrinterChanged(Printer* pNewPrinter);

	void			Execute( SfxRequest& rReq );
	void			GetState(SfxItemSet&);

	SdDrawDocument* GetDoc();
	DocumentType    GetDocumentType() const { return eDocType; }

	virtual SfxStyleSheetBasePool* GetStyleSheetPool();

	virtual void	 SetOrganizerSearchMask(SfxStyleSheetBasePool* pBasePool) const;

	void			 Connect(SdViewShell* pViewSh);
	void			 Disconnect(SdViewShell* pViewSh);
	SdViewShell*	 GetViewShell() { return pViewShell; }
	FrameView*		 GetFrameView();
	void			 UpdateTablePointers();

	BOOL			 GotoBookmark(const String& rBookmark);

	virtual Size	 GetFirstPageSize();

	virtual void     FillClass(SvGlobalName* pClassName,
							   ULONG*  pFormat,
							   String* pAppName,
							   String* pFullTypeName,
							   String* pShortTypeName,
							   long    nFileFormat = SOFFICE_FILEFORMAT_CURRENT) const;

	Bitmap           GetPagePreviewBitmap(SdPage* pPage, USHORT nMaxEdgePixel);

	BOOL    IsInDestruction() const { return bInDestruction; }

	BOOL	CheckPageName( Window* pWin, String& rName );
	BOOL	CheckObjectName( Window* pWin, String& rName );

	void    SetSlotFilter(BOOL bEnable = FALSE, USHORT nCount = 0,
						  const USHORT* pSIDs = NULL)
			{ bFilterEnable = bEnable; nFilterCount = nCount; pFilterSIDs = pSIDs; }
	void    ApplySlotFilter() const;

	UINT16	GetStyleFamily() const { return nStyleFamily; }
	void	SetStyleFamily( UINT16 nSF ) { nStyleFamily = nSF; }

	virtual void    SetModified( BOOL = TRUE );

	Window*	GetWindow() const;

	BOOL HasSpecialProgress() const { return ( mpSpecialProgress != NULL && mpSpecialProgressHdl != NULL ); }
	void ReleaseSpecialProgress() { mpSpecialProgress = NULL; mpSpecialProgressHdl = NULL; }
	void SetSpecialProgress( SfxProgress* pProgress, Link* pLink ) { mpSpecialProgress = pProgress; mpSpecialProgressHdl = pLink; }
	SfxProgress* GetSpecialProgress() { return( HasSpecialProgress() ? mpSpecialProgress : NULL ); }

// #91457#
#ifndef SVX_LIGHT
	// #91457# ExecuteSpellPopup now handled by SdDrawDocShell
	DECL_LINK(OnlineSpellCallback, SpellCallbackInfo*);
#endif
};

#ifndef SV_DECL_SDDRAWDOCSHELL_DEFINED
#define SV_DECL_SDDRAWDOCSHELL_DEFINED
SV_DECL_REF(SdDrawDocShell)
#endif

SV_IMPL_REF (SdDrawDocShell)



#endif			// _SD_DOCSHELL_HXX

