/*************************************************************************
 *
 *  $RCSfile: fuexp1.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: thb $ $Date: 2001/09/04 16:36:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

class SfxMenuBarManager;

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#include <svx/impgrf.hxx>
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <svx/svdograf.hxx>
#endif
#ifndef _XOUTBMP_HXX //autogen
#include <svx/xoutbmp.hxx>
#endif
#ifndef _SV_METAACT_HXX //autogen
#include <vcl/metaact.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <sfx2/docfile.hxx>
#endif
#ifndef _FILTER_CONFIG_ITEM_HXX_
#include <svtools/FilterConfigItem.hxx>
#endif

#include "sdresid.hxx"
#include "drawdoc.hxx"
#include "clview.hxx"
#include "frmview.hxx"
#include "sdpage.hxx"
#include "drviewsh.hxx"
#include "docshell.hxx"
#include "strings.hrc"
#include "filedlg.hxx"
#include "graphpro.hxx"
#include "fuexport.hxx"
#include "sdwindow.hxx"
#include "sdgrffilter.hxx"
#ifndef _SFXSTBMGR_HXX //autogen
#include <sfx2/stbmgr.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

TYPEINIT1( FuExport, FuPoor );

// ------------
// - FuExport -
// ------------

FuExport::FuExport( SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,
					SdDrawDocument* pDoc, SfxRequest& rReq ) :
			FuPoor( pViewSh, pWin, pView, pDoc, rReq )
{
	// Falls Objekte selektiert sind, muessen wir
	// im Dialog eine Selection-CheckBox anbieten
	SdExportFileDialog	aDlg( pView->GetMarkList().GetMarkCount() ? TRUE : FALSE );

	if ( aDlg.Execute() == ERRCODE_NONE )
	{
		// OnlineSpelling ausschalten
		BOOL bSetOnlineSpelling = pDoc->GetOnlineSpell();
		pDoc->SetOnlineSpell(FALSE);

		const String	aPath( aDlg.GetPath() );
		const String	aFilter( aDlg.ReqCurrentFilter() );

		if ( aFilter == String( SdResId( STR_EXPORT_HTML_NAME ) ) )
			ExportHTML( rReq.GetArgs(), aPath, sal_False );
		else
			ExportGraphic( aPath, aFilter, sal_False, aDlg.IsExportSelection() );

		pDoc->SetOnlineSpell(bSetOnlineSpelling);
	}
}

// -----------------------------------------------------------------------------


#ifdef WNT
#pragma optimize ( "", off )
#endif

// -----------------------------------------------------------------------------

void FuExport::ExportGraphic( const String& rPath, const String& rFilter, const BOOL bAutoExtension, const BOOL bSelected ) const
{
	Graphic 			aGraphic;
	VirtualDevice		aVDev;
	const Fraction		aFrac( pDoc->GetScaleFraction() );
	const MapMode 		aMap( pDoc->GetScaleUnit(), Point(), aFrac, aFrac );
	GraphicFilter*		pFilter = GetGrfFilter();
	SdPage*				pPage = (SdPage*) pDoc->GetSdPage( 0, PK_STANDARD );
	const USHORT		nFilter = pFilter->GetExportFormatNumber( rFilter );
	USHORT				nPage;
	PageKind			ePageKind = PK_STANDARD;
	BOOL				bStatus = TRUE;
	BOOL				bVectorType = !pFilter->IsExportPixelFormat( nFilter );
	BOOL				bTranslucent = pFilter->GetExportFormatShortName( nFilter ).ToLowerAscii().EqualsAscii( "gif" );

	// Zeiger auf die bearbeitete Seite
	if ( pViewShell && pViewShell->ISA( SdDrawViewShell ) )
	{
		ePageKind = ( (SdDrawViewShell*) pViewShell )->GetPageKind();

		if ( ePageKind == PK_HANDOUT )
			pPage = (SdPage*) pDoc->GetSdPage( 0, PK_HANDOUT );
		else
			pPage = ( (SdDrawViewShell*) pViewShell )->GetActualPage();
	}

	DBG_ASSERT( pPage, "Seite nicht gefunden" );

	// ggf. Filterdialog ausfuehren
	if ( pFilter->HasExportDialog( nFilter ) )
	{
		FieldUnit eFieldUnit( pView->GetDoc()->GetUIUnit() );
		if ( !pFilter->DoExportDialog( pWindow, nFilter, eFieldUnit ) )
			bStatus = FALSE;
	}
	if( bStatus )
	{
		FilterProgress aProgress( pFilter, pViewShell->GetDocSh() );

		pDocSh->SetWaitCursor( TRUE );
		aProgress.SetState( 10 );

		// translucent speichern?
		if ( bTranslucent )
		{
			FilterConfigItem aConfigItem( String( RTL_CONSTASCII_USTRINGPARAM( "Office.Common/Filter/Graphic/Export/GIF" ) ) );
			bTranslucent = aConfigItem.ReadInt32( String( RTL_CONSTASCII_USTRINGPARAM( "Translucent" ) ), 1 ) != 0;
		}
		else
			bTranslucent = FALSE;

		// 'richtige' Zeichenseitennummer ermitteln
		if( pPage->GetPageNum() )
			nPage = ( pPage->GetPageNum() - 1 ) >> 1;
		else
			nPage = 0;

		// 'richtige' Seite besorgen
		pPage = pDoc->GetSdPage( nPage, ePageKind );

		// Alle Obj's exportieren
		if ( !bSelected )
		{
			const Size aSize( pPage->GetSize() );

			// Bitmap besorgen, um in Pixelformat zu exportieren;
			// beim GIF-Filter kann auch ein Vektorformat exportiert
			// werden (Translucent)
			if ( !bVectorType && !bTranslucent )
			{
				const Size		aSizePix( pWindow->LogicToPixel( aSize, aMap ) );
				const long		nWidthPix = ( aSizePix.Width() > 2048 || aSizePix.Height() > 2048 ) ? 2048 : 0;
				SdView*			pView = new SdView( pDoc, &aVDev );
				VirtualDevice*	pVDev = pView->CreatePageVDev( nPage, ePageKind, nWidthPix );

				if( pVDev )
				{
					aGraphic = pVDev->GetBitmap( Point(), pVDev->GetOutputSize() );
					aGraphic.SetPrefMapMode( aMap );
					aGraphic.SetPrefSize( aSize );
					delete pVDev;
				}

				delete pView;
			}
			// MetaFile besorgen um in Vektorformat zu exportieren
			else
			{
				GDIMetaFile aMtf;

				aVDev.SetMapMode( aMap );
				aMtf.Record( &aVDev );

				SdClientView* pView = new SdClientView( pDoc->GetDocSh(), &aVDev, NULL );

				if ( pView && pPage )
				{
					pView->SetBordVisible( FALSE );
					pView->SetPageVisible( FALSE );
					pView->ShowPage( pPage, Point() );

					const Point	aNewOrg( pPage->GetLftBorder(), pPage->GetUppBorder() );
					const Size	aNewSize( aSize.Width() - pPage->GetLftBorder() - pPage->GetRgtBorder(),
										  aSize.Height() - pPage->GetUppBorder() - pPage->GetLwrBorder() );
					const Rectangle aClipRect( aNewOrg, aNewSize );
					MapMode			aVMap( aMap );

					SdrPageView* pPageView	= pView->GetPageView( pPage );
					FrameView*	 pFrameView = pViewShell->GetFrameView();

					pPageView->SetVisibleLayers( pFrameView->GetVisibleLayers() );
					pPageView->SetLockedLayers( pFrameView->GetLockedLayers() );
					pPageView->SetPrintableLayers( pFrameView->GetPrintableLayers() );

					aVDev.Push();
					aVMap.SetOrigin( Point( -aNewOrg.X(), -aNewOrg.Y() ) );
					aVDev.SetRelativeMapMode( aVMap );
					aVDev.IntersectClipRegion( aClipRect );
					pView->InitRedraw( &aVDev, Region( Rectangle( Point(), aNewSize ) ) );
					aVDev.Pop();

					aMtf.Stop();
					aMtf.WindStart();
					aMtf.SetPrefMapMode( aMap );
					aMtf.SetPrefSize( aNewSize );

					aGraphic = Graphic( RemoveClipRegionActions( aMtf ) );
				}

				if( bTranslucent )
					aGraphic = GetBitmapFromMetaFile( aGraphic.GetGDIMetaFile(), TRUE );

				if ( pView )
					delete pView;
			}
		}
		// nur die markierten Objekte exportieren
		else
		{
			SdView* pView = pViewShell->GetView();

			if ( pView )
			{
				if( !bVectorType )
				{
					const SdrMarkList&	rMarkList = pView->GetMarkList();
					BOOL				bGraf = FALSE;

					if( rMarkList.GetMarkCount() == 1 )
					{
						SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();

						if( pObj && pObj->ISA( SdrGrafObj ) && !( (SdrGrafObj*) pObj )->HasText() )
						{
							aGraphic = ( (SdrGrafObj*) pObj )->GetTransformedGraphic();
							bGraf = TRUE;
						}
					}

					if( !bGraf )
						aGraphic = GetBitmapFromMetaFile( pView->GetAllMarkedMetaFile(), bTranslucent );
				}
				else
					aGraphic = pView->GetAllMarkedMetaFile();
			}
		}

		const Size aGraphSize( aGraphic.GetPrefSize() );

		// Grafik speichern
		if ( ( aGraphSize.Width() > 1 ) && ( aGraphSize.Height() > 1 ) )
		{
			INetURLObject aURL;
			aURL.SetURL( rPath );

			DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );

			if( bAutoExtension && !aURL.getExtension().Len() )
				aURL.setExtension( pFilter->GetExportFormatShortName( nFilter ).ToLowerAscii() );

			USHORT nRet = XOutBitmap::ExportGraphic( aGraphic, aURL, *pFilter, nFilter, FALSE );
			pDocSh->SetWaitCursor( FALSE );

			if ( nRet )
				SdGRFFilter::HandleGraphicFilterError( nRet, GetGrfFilter()->GetLastError().nStreamError );
		}
		else
		{
			pDocSh->SetWaitCursor( FALSE );
			ErrorBox aErrBox( pWindow, WB_OK, String( SdResId( STR_EXPORT_EMPTYGRAPHIC ) ) );
			aErrBox.Execute();
		}
	}
}

#ifdef WNT
#pragma optimize ( "", on )
#endif

// -----------------------------------------------------------------------------

GDIMetaFile FuExport::RemoveClipRegionActions( const GDIMetaFile& rMtf )
{
	GDIMetaFile 	aMtf;
	const ULONG 	nActionCount = rMtf.GetActionCount();

	aMtf.SetPrefSize( rMtf.GetPrefSize() );
	aMtf.SetPrefMapMode( rMtf.GetPrefMapMode() );

	// Actions untersuchen und ClipRegion-Action herausnehmen
	for ( ULONG nAction = 0; nAction < nActionCount; nAction++ )
	{
		MetaAction* pCopyAction = ( (GDIMetaFile&) rMtf ).CopyAction( nAction );

		if( pCopyAction )
		{
			switch( pCopyAction->GetType() )
			{
				case( META_CLIPREGION_ACTION ) :
					delete pCopyAction;
				break;

				default:
					aMtf.AddAction( pCopyAction );
				break;
			}
		}
	}

	return aMtf;
}

// -----------------------------------------------------------------------------

BitmapEx FuExport::GetBitmapFromMetaFile( const GDIMetaFile& rMtf, BOOL bTransparent, const Size* pSizePixel )
{
	Graphic     aGraphic( rMtf );
    BitmapEx	aBmpEx;

    if( bTransparent )
    {
        Graphic aMaskGraphic( rMtf.GetMonochromeMtf( COL_BLACK ) );
        Bitmap  aMaskBmp( aMaskGraphic.GetBitmap( pSizePixel) );
        
        aMaskBmp.Convert( BMP_CONVERSION_1BIT_THRESHOLD );
        aBmpEx = BitmapEx( aGraphic.GetBitmap( pSizePixel ), aMaskBmp );
    }
    else
        aBmpEx = BitmapEx( aGraphic.GetBitmap( pSizePixel ) );

	aBmpEx.SetPrefMapMode( rMtf.GetPrefMapMode() );
	aBmpEx.SetPrefSize( rMtf.GetPrefSize() );

    return aBmpEx;
}
