/*************************************************************************
 *
 *  $RCSfile: slidechg.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: ka $ $Date: 2001/10/22 13:36:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <svx/gallery.hxx>
#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "sdattr.hxx"
#include "slidechg.hxx"
#include "slidechg.hrc"
#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "sdresid.hxx"
#include "sdview.hxx"
#include "drawdoc.hxx"

#define VALUESET_BACKGROUND	Color( 255, 255, 255 )

using namespace ::com::sun::star;

SFX_IMPL_DOCKINGWINDOW( SdSlideChangeChildWindow, SID_SLIDE_CHANGE_WIN)

/*************************************************************************
|*	SdSlideChangeWin - FloatingWindow
\************************************************************************/

SdSlideChangeWin::SdSlideChangeWin( SfxBindings* pInBindings,
				SfxChildWindow *pCW, Window* pParent, const SdResId& rSdResId ) :
		SfxDockingWindow    ( pInBindings, pCW, pParent, rSdResId ),

		//aBtnViewType	( this, SdResId( BTN_VIEWTYPE ) ),
		aBtnVTEffect	( this, SdResId( BTN_VT_EFFECT ) ),
		aBtnVTExtras	( this, SdResId( BTN_VT_EXTRAS ) ),
		aBtnUpdate		( this, SdResId( BTN_UPDATE ) ),
		aBtnAssign		( this, SdResId( BTN_ASSIGN ) ),
		aBtnPreview		( this, SdResId( BTN_PREVIEW ) ),

		aLbEffect		( this, SdResId( LB_EFFECT ) ),
		aCtlEffect		( this, SdResId( CTL_EFFECT ) ),
		aLbSpeed		( this, SdResId( LB_SPEED ) ),
		aGrpEffect		( this, SdResId( GRP_EFFECT ) ),

		aBtnAuto		( this, SdResId( BTN_AUTO ) ),
		aBtnSemi		( this, SdResId( BTN_SEMI ) ),
		aBtnManual		( this, SdResId( BTN_MANUAL ) ),
		aFldTime		( this, *pInBindings, SdResId( FLD_TIME ) ),

		aBtnSound   	( this, SdResId( BTN_SOUND ) ),
		aBtnSearch    	( this, SdResId( BTN_SEARCH ) ),
		//aEdtSound     	( this, SdResId( EDT_SOUND ) ),
		aLbSound     	( this, SdResId( LB_SOUND ) ),

		bBreakEven		( FALSE ),
		bUpdate			( FALSE ),
		eViewType		( VIEWTYPE_SC_EFFECT ),

		pBindings		( pInBindings ),
		ppStringIdList	( NULL ),
		ppBitmapIdList	( NULL ),
		pSoundList    	( NULL )
{
	FreeResource();

	pSlideChangePrevCtrlItem = new SdSlideChangePrevCtrlItem( SID_PREVIEW_WIN, this, pBindings );

	//aBtnViewType.SetClickHdl( LINK( this, SdSlideChangeWin, ClickViewTypeHdl ) );
	aBtnVTEffect.SetClickHdl( LINK( this, SdSlideChangeWin, ClickViewTypeHdl ) );
	aBtnVTExtras.SetClickHdl( LINK( this, SdSlideChangeWin, ClickViewTypeHdl ) );
	aBtnPreview.SetClickHdl( LINK( this, SdSlideChangeWin, ClickPreviewHdl ) );
	aBtnAssign.SetClickHdl( LINK( this, SdSlideChangeWin, ClickAssignHdl ) );
	aBtnUpdate.SetClickHdl( LINK( this, SdSlideChangeWin, ClickUpdateHdl ) );

	// Effekte
	aLbEffect.SetSelectHdl( LINK( this, SdSlideChangeWin, SelectEffectHdl ) );
	aCtlEffect.SetSelectHdl( LINK( this, SdSlideChangeWin, SelectEffectHdl ) );
	aCtlEffect.SetDoubleClickHdl( LINK( this, SdSlideChangeWin, ClickAssignHdl ) );

	// Extras
	aBtnAuto.SetClickHdl( LINK( this, SdSlideChangeWin, ClickAutoHdl ) );
	aBtnSemi.SetClickHdl( LINK( this, SdSlideChangeWin, ClickSemiHdl ) );
	aBtnManual.SetClickHdl( LINK( this, SdSlideChangeWin, ClickManualHdl ) );
	aBtnSound.SetClickHdl( LINK( this, SdSlideChangeWin, ClickSoundHdl ) );
	aBtnSearch.SetClickHdl( LINK( this, SdSlideChangeWin, ClickSearchHdl ) );
	aLbSound.SetSelectHdl( LINK( this, SdSlideChangeWin, SelectSoundHdl ) );

	aSize = GetOutputSizePixel();
	SetMinOutputSizePixel( aSize );

	aValueSetHeight = (USHORT) aCtlEffect.GetOutputSizePixel().Height();
	// Hoehe der Extras-Gruppe berechnen
	aExtrasHeight = ( aLbSound.GetPosPixel().Y() -
							 aBtnAuto.GetPosPixel().Y() ) +
							 18 + //aEdtSound.GetSizePixel().Height() +
							 20;
	aBreakEvenHeight = aSize.Height() + aExtrasHeight;

	// Y-Position der Extras-Controls
	aBtnAutoPosY = (USHORT) aBtnAuto.GetPosPixel().Y();
	aBtnSemiPosY = (USHORT) aBtnSemi.GetPosPixel().Y();
	aBtnManualPosY = (USHORT) aBtnManual.GetPosPixel().Y();
	aFldTimePosY = (USHORT) aFldTime.GetPosPixel().Y();

	aBtnSoundPosY = (USHORT) aBtnSound.GetPosPixel().Y();
	aBtnSearchPosY = (USHORT) aBtnSearch.GetPosPixel().Y();
	aLbSoundPosY = (USHORT) aLbSound.GetPosPixel().Y();

	Construct();

	// ViewType-Button initialisieren
	ClickViewTypeHdl( NULL );

	Reset();
}

// -----------------------------------------------------------------------

SdSlideChangeWin::~SdSlideChangeWin()
{
	delete pSlideChangePrevCtrlItem;

	// Listen bereinigen
	List* pList;

	for( pList = (List*) ppStringIdList->First();
		 pList;
		 pList = (List*) ppStringIdList->Next() )
	{
		pList->Clear();
		delete pList;
	}
	ppStringIdList->Clear();

	for( pList = (List*) ppBitmapIdList->First();
		 pList;
		 pList = (List*) ppBitmapIdList->Next() )
	{
		pList->Clear();
		delete pList;
	}
	ppBitmapIdList->Clear();

	// Soundliste
	ClearSoundList();

	delete ppStringIdList;
	delete ppBitmapIdList;
	delete pSoundList;
}

// -----------------------------------------------------------------------

void SdSlideChangeWin::Construct()
{
	// Listen aufbauen
	ppStringIdList = new List();
	ppBitmapIdList = new List();

	// Kein Effekt (Jetzt Favoriten)
	List* pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );

	List* pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FAVOURITES), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_NONE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_NONE), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_L), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_ROLL_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_ROLL_FROM_L), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRETCH_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRETCH_FROM_T), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_T), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_ROLL_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_ROLL_FROM_T), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISSOLVE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISSOLVE), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_CENTER), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_CENTER), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_CLOCKWISE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_CLOCKWISE), LIST_APPEND );

	// Ueberblenden
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADEFROM), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_UL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_UL), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_T), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_UR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_UR), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_L), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_R), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_LL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_LL), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_B), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_B), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_LR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_LR), LIST_APPEND );

	// Aufdecken
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_UL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_UL), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_T), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_UR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_UR), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_L), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_R), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_LL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_LL), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_B), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_B), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISCARD_FROM_LR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISCARD_FROM_LR), LIST_APPEND );

	// Move
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_UNCOVER), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_UNCOVER_TO_UL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_UNCOVER_TO_UL), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_UNCOVER_TO_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_UNCOVER_TO_T), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_UNCOVER_TO_UR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_UNCOVER_TO_UR), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_UNCOVER_TO_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_UNCOVER_TO_L), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_UNCOVER_TO_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_UNCOVER_TO_R), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_UNCOVER_TO_LL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_UNCOVER_TO_LL), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_UNCOVER_TO_B), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_UNCOVER_TO_B), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_UNCOVER_TO_LR), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_UNCOVER_TO_LR), LIST_APPEND );

	// Blenden
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );
	
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_TO_CENTER), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_TO_CENTER), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_FADE_FROM_CENTER), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_FADE_FROM_CENTER), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_VERTICAL_STRIPES), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_VERTICAL_STRIPES), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_HORIZONTAL_STRIPES), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_HORIZONTAL_STRIPES), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_CLOCKWISE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_CLOCKWISE), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_COUNTERCLOCKWISE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_COUNTERCLOCKWISE), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	// Oeffnen / Schliessen
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_OPEN_CLOSE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_OPEN_VERTICAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_OPEN_VERTICAL), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_OPEN_HORIZONTAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_OPEN_HORIZONTAL), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_CLOSE_VERTICAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_CLOSE_VERTICAL), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_CLOSE_HORIZONTAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_CLOSE_HORIZONTAL), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	// Schlangenlinie
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_WAVYLINE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_WAVYLINE_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_WAVYLINE_FROM_T), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_WAVYLINE_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_WAVYLINE_FROM_L), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_WAVYLINE_FROM_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_WAVYLINE_FROM_R), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_WAVYLINE_FROM_B), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_WAVYLINE_FROM_B), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	// Spirale
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_SPIRAL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_SPIRALIN_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_SPIRALIN_L), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_SPIRALIN_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_SPIRALIN_R), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_SPIRALOUT_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_SPIRALOUT_L), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_SPIRALOUT_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_SPIRALOUT_R), LIST_APPEND );

	// Rollen
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_ROLL), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_ROLL_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_ROLL_FROM_T), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_ROLL_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_ROLL_FROM_L), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_ROLL_FROM_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_ROLL_FROM_R), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_ROLL_FROM_B), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_ROLL_FROM_B), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	// Stretchen
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );

	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRETCH), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRETCH_FROM_T), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRETCH_FROM_T), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRETCH_FROM_L), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRETCH_FROM_L), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRETCH_FROM_R), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRETCH_FROM_R), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_STRETCH_FROM_B), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_STRETCH_FROM_B), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );

	// Extras
	pStringList = new List();
	ppStringIdList->Insert( pStringList, LIST_APPEND );
	pBitmapList = new List();
	ppBitmapIdList->Insert( pBitmapList, LIST_APPEND );

	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_EXTRA), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_VERTICAL_LINES), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_VERTICAL_LINES), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_HORIZONTAL_LINES), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_HORIZONTAL_LINES), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_DISSOLVE), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_DISSOLVE), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) 0), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_VERTICAL_CHECKERBOARD), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_VERTICAL_CHECKERBOARD), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_HORIZONTAL_CHECKERBOARD), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_HORIZONTAL_CHECKERBOARD), LIST_APPEND );
	pStringList->Insert( (void*) ((ULONG) STR_EFFECT_RANDOM), LIST_APPEND );
	pBitmapList->Insert( (void*) ((ULONG) BMP_EFFECT_RANDOM), LIST_APPEND );

	const Color aValueSetColor( VALUESET_BACKGROUND ); 

	// ValueSet Effect
	aCtlEffect.SetStyle( aCtlEffect.GetStyle() | WB_3DLOOK | WB_ITEMBORDER | WB_DOUBLEBORDER | WB_FLATVALUESET | WB_NAMEFIELD );
	aCtlEffect.SetBackground( Wallpaper( aValueSetColor ) );
	aCtlEffect.SetControlBackground( aValueSetColor );
	aCtlEffect.SetColor( aValueSetColor );
	aCtlEffect.SetColCount( 3 );
	aCtlEffect.SetLineCount( 3 );
	aCtlEffect.SetExtraSpacing( 2 );
	aCtlEffect.Show();

	// Listbox Effect
	for( USHORT i = 0; i < ppStringIdList->Count(); i++ )
		aLbEffect.InsertEntry( String( SdResId( GetStringId( 0, i ) ) ) );

	// Sound-Namenliste aufbauen
	pSoundList = new List();
	FillSoundListAndBox();
}

// -----------------------------------------------------------------------

void SdSlideChangeWin::Reset()
{
	ClickUpdateHdl( NULL );

	aLbSpeed.SelectEntryPos( 1 );
	aLbEffect.SelectEntryPos( 0 );

	SelectEffectHdl( NULL );

	ClickAutoHdl( NULL );
	ClickSemiHdl( NULL );
	ClickManualHdl( NULL );
	ClickSoundHdl( NULL );
}

// -----------------------------------------------------------------------

void SdSlideChangeWin::Update( SfxItemSet& rAttrs )
{
	// Effekt
	if( rAttrs.GetItemState( ATTR_DIA_EFFECT ) != SFX_ITEM_DONTCARE )
	{
		presentation::FadeEffect eFE = (presentation::FadeEffect) ( ( const SfxAllEnumItem& ) rAttrs.
					Get( ATTR_DIA_EFFECT ) ).GetValue();
		SetFadeEffect( eFE );
	}
	else
	{
		aLbEffect.SetNoSelection();
		aCtlEffect.Hide();
	}

	// Animation Speed
	if( rAttrs.GetItemState( ATTR_DIA_SPEED ) != SFX_ITEM_DONTCARE )
	{
		FadeSpeed eFS = (FadeSpeed) ( ( const SfxAllEnumItem& ) rAttrs.
					Get( ATTR_DIA_SPEED ) ).GetValue();

		aLbSpeed.SelectEntryPos( eFS );
	}
	else
		aLbSpeed.SetNoSelection();

	/*** Extras ***/

	// Automatisch/Manuell
	if( rAttrs.GetItemState( ATTR_DIA_AUTO ) != SFX_ITEM_DONTCARE )
	{
		const PresChange ePresChange = (PresChange) ( ( const DiaAutoItem& ) rAttrs.Get( ATTR_DIA_AUTO ) ).GetValue();
		BOOL			 bMan = FALSE;
		BOOL			 bSemi = FALSE;
		BOOL			 bAuto = FALSE;

		switch( ePresChange )
		{
			case( PRESCHANGE_MANUAL ): bMan = TRUE; break;
			case( PRESCHANGE_SEMIAUTO ): bSemi = TRUE; break;
			case( PRESCHANGE_AUTO ): bAuto = TRUE; break;

			default:
			break;
		}

		aBtnAuto.Check( bAuto );
		aBtnSemi.Check( bSemi );
		aBtnManual.Check( bMan );
	}
	else
	{
		aBtnAuto.Check( FALSE );
		aBtnSemi.Check( FALSE );
		aBtnManual.Check( FALSE );
	}

	// Zeit
	if( rAttrs.GetItemState( ATTR_DIA_TIME ) != SFX_ITEM_DONTCARE )
	{
		ULONG lTime = ( ( const DiaTimeItem& ) rAttrs.Get( ATTR_DIA_TIME ) ).GetValue();
		USHORT  nHour = (USHORT) ( lTime / 3600 );
		USHORT  nMin  = (USHORT) ( ( lTime % 3600 ) / 60 );
		USHORT  nSec  = (USHORT) ( ( lTime % 3600 ) % 60 );
		Time aTime( nHour, nMin, nSec);

		aFldTime.SetTime( aTime );
	}
	else
		aFldTime.SetEmptyTime();


	// Klang (ja/nein)
	if( rAttrs.GetItemState( ATTR_DIA_SOUND ) != SFX_ITEM_DONTCARE )
		aBtnSound.Check( ( ( const SfxBoolItem& ) rAttrs.Get( ATTR_DIA_SOUND ) ).GetValue() );
	else
		aBtnSound.SetState( STATE_DONTKNOW );

	// Klang Name
	/*
	if( rAttrs.GetItemState( ATTR_DIA_SOUNDFILE ) != SFX_ITEM_DONTCARE )
		aEdtSound.SetText( ( ( const SfxStringItem& ) rAttrs.Get( ATTR_DIA_SOUNDFILE ) ).GetValue() );
	else
		aEdtSound.SetText( String( "" ) );
	*/
	if( rAttrs.GetItemState( ATTR_DIA_SOUNDFILE ) != SFX_ITEM_DONTCARE )
	{
		String aStr( ( ( const SfxStringItem& ) rAttrs.Get( ATTR_DIA_SOUNDFILE ) ).GetValue() );
		if( aStr.Len() )
		{
			long nPos = GetSoundObject( aStr );
			if( nPos < 0 )
			{
				ClearSoundList();
				aLbSound.Clear();

				GalleryExplorer::InsertURL( GALLERY_THEME_USERSOUNDS, aStr );
				FillSoundListAndBox();
				nPos = GetSoundObject( aStr );
				DBG_ASSERT( nPos >= 0, "Sound nicht in Liste!" );
			}
			if( nPos >= 0 )
				aLbSound.SelectEntryPos( (USHORT) nPos );
		}
		else
			aLbSound.SetNoSelection();
	}
	else
		aLbSound.SetNoSelection();

	ClickAutoHdl( NULL );
	ClickSemiHdl( NULL );
	ClickManualHdl( NULL );
	ClickSoundHdl( NULL );
	SelectSoundHdl( NULL );
}

// -----------------------------------------------------------------------

void SdSlideChangeWin::GetAttr( SfxItemSet& rAttrs )
{
	// Effekt
	// Favorit ?
	USHORT nPos = aLbEffect.GetSelectEntryPos();
	USHORT nId  = aCtlEffect.GetSelectItemId();
	if( nPos == 0 )
	{
		rAttrs.Put( SfxAllEnumItem( ATTR_DIA_EFFECT, GetFadeEffect() ) );
		//aBtnSound.SetState( STATE_CHECK );
	}
	else
	{
		if( nPos != LISTBOX_ENTRY_NOTFOUND )
			rAttrs.Put( SfxAllEnumItem( ATTR_DIA_EFFECT, GetFadeEffect() ) );
		else
			rAttrs.InvalidateItem( ATTR_DIA_EFFECT );
	}
	// EffektSpeed
	nPos = aLbSpeed.GetSelectEntryPos();
	if( nPos == LISTBOX_ENTRY_NOTFOUND )
		rAttrs.InvalidateItem( ATTR_DIA_SPEED );
	else
		rAttrs.Put( SfxAllEnumItem( ATTR_DIA_SPEED, (FadeSpeed) nPos ) );

	// Automatisch/Manuell
	if( aBtnAuto.IsChecked() )
		rAttrs.Put( DiaAutoItem( PRESCHANGE_AUTO ) );
	else if( aBtnSemi.IsChecked() )
		rAttrs.Put( DiaAutoItem( PRESCHANGE_SEMIAUTO ) );
	else if( aBtnManual.IsChecked() )
		rAttrs.Put( DiaAutoItem( PRESCHANGE_MANUAL ) );
	else
		rAttrs.InvalidateItem( ATTR_DIA_AUTO );

	// Zeit
	if( aFldTime.IsEnabled() )
	{
		Time aTime = aFldTime.GetTime();
		ULONG lTime = aTime.GetSec() + aTime.GetMin() * 60 + aTime.GetHour() * 3600;
		rAttrs.Put( DiaTimeItem( lTime ) );
	}
	else
		rAttrs.InvalidateItem( ATTR_DIA_TIME );


	// Klang (ja/nein)
	if( aBtnSound.GetState() == STATE_DONTKNOW )
		rAttrs.InvalidateItem( ATTR_DIA_SOUND );
	else
		rAttrs.Put( SfxBoolItem( ATTR_DIA_SOUND, aBtnSound.IsChecked() ) );

	// Klang Name
	/*
	String aName( aEdtSound.GetText() );
	if( aName.Len() )
		rAttrs.Put( SfxStringItem( ATTR_DIA_SOUNDFILE, aName ) );
	else
		rAttrs.InvalidateItem( ATTR_DIA_SOUNDFILE );
	*/
	nPos = aLbSound.GetSelectEntryPos();
	if( nPos != LISTBOX_ENTRY_NOTFOUND )
	{
		String aName( *(String*)pSoundList->GetObject( (long)nPos ) );
		rAttrs.Put( SfxStringItem( ATTR_DIA_SOUNDFILE, aName ) );
	}
	else
		rAttrs.InvalidateItem( ATTR_DIA_SOUNDFILE );

}

// -----------------------------------------------------------------------

void SdSlideChangeWin::Resize()
{
	if ( !IsFloatingMode() ||
		 !GetFloatingWindow()->IsRollUp() )
	{
		Size aWinSize( GetOutputSizePixel() );

		if( aWinSize.Height() >= GetMinOutputSizePixel().Height() &&
			aWinSize.Width() >= GetMinOutputSizePixel().Width() )
		{
			BOOL bShowAll = aWinSize.Height() > aBreakEvenHeight;

			Size aDiffSize;
			aDiffSize.Width() = aWinSize.Width() - aSize.Width();
			aDiffSize.Height() = aWinSize.Height() - aSize.Height();

			Point aXPt;
			Point aYPt;
			aXPt.X() = aDiffSize.Width();
			aYPt.Y() = aDiffSize.Height();

			// Verschieben der anderen Controls
			Size aObjSize;

			//aBtnViewType.Hide();
			aBtnVTEffect.Hide();
			aBtnVTExtras.Hide();
			aBtnPreview.Hide();
			aBtnUpdate.Hide();
			aBtnAssign.Hide();
			aLbEffect.Hide();
			aCtlEffect.Hide();
			aLbSpeed.Hide();
			aGrpEffect.Hide();

			aBtnAuto.Hide();
			aBtnSemi.Hide();
			aBtnManual.Hide();
			aFldTime.Hide();
			aBtnSound.Hide();
			aBtnSearch.Hide();
			aLbSound.Hide();

			aBtnPreview.SetPosPixel( aBtnPreview.GetPosPixel() + aXPt );
			aBtnUpdate.SetPosPixel( aBtnUpdate.GetPosPixel() + aXPt );
			aBtnAssign.SetPosPixel( aBtnAssign.GetPosPixel() + aXPt );
			aBtnSearch.SetPosPixel( aBtnSearch.GetPosPixel() + aXPt );

			/*** Effekte ***/
			// LB Effect
			aObjSize = aLbEffect.GetOutputSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aLbEffect.SetOutputSizePixel( aObjSize );
			// ValueSet Effect
			aObjSize = aCtlEffect.GetOutputSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aObjSize.Height() += aDiffSize.Height();
			if( bBreakEven != bShowAll )
			{
				if( bShowAll )
				{
					aObjSize.Height() -= aExtrasHeight;
					aYPt.Y() -= aExtrasHeight;
				}
				else
				{
					aObjSize.Height() += aExtrasHeight;
					aYPt.Y() += aExtrasHeight;
				}
			}
			// Um die minimale Groesse nicht zu unterschreiten
			if( aObjSize.Height() < aValueSetHeight )
			{
				long nTmp = aValueSetHeight - aObjSize.Height();
				aObjSize.Height() = aValueSetHeight;
				aDiffSize.Height() += nTmp;
				aYPt.Y() = aDiffSize.Height();
			}
			aCtlEffect.SetOutputSizePixel( aObjSize );

			// LB Speed
			aObjSize = aLbSpeed.GetOutputSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aLbSpeed.SetPosPixel( aLbSpeed.GetPosPixel() + aYPt );
			aLbSpeed.SetOutputSizePixel( aObjSize );


			// GroupBox Effect
			aObjSize = aGrpEffect.GetOutputSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aGrpEffect.SetOutputSizePixel( aObjSize );


			if( bShowAll )
			{
				// Hoehe der Effekte-Gruppe berechnen
				long aEffectsHeight = ( aLbSpeed.GetPosPixel().Y() -
								aLbEffect.GetPosPixel().Y() ) +
								aLbSpeed.GetSizePixel().Height() +
								20;
				aYPt.Y() = aEffectsHeight;
			}
			else
			{
				aYPt.Y() = 0;
			}

			/*** Extras ***/
			// FldTime
			aObjSize = aFldTime.GetOutputSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aFldTime.SetOutputSizePixel( aObjSize );
			// Edit Sound
			aObjSize = aLbSound.GetSizePixel();
			aObjSize.Width() += aDiffSize.Width();
			aLbSound.SetSizePixel( aObjSize );

			// Y-Position der Extras Controls
			aBtnAuto.SetPosPixel( Point(
				aBtnAuto.GetPosPixel().X(), aBtnAutoPosY + aYPt.Y() ) );
			aBtnSemi.SetPosPixel( Point(
				aBtnSemi.GetPosPixel().X(), aBtnSemiPosY + aYPt.Y() ) );
			aBtnManual.SetPosPixel( Point(
				aBtnManual.GetPosPixel().X(), aBtnManualPosY + aYPt.Y() ) );
			aFldTime.SetPosPixel( Point(
				aFldTime.GetPosPixel().X(), aFldTimePosY + aYPt.Y() ) );
			aBtnSound.SetPosPixel( Point(
				aBtnSound.GetPosPixel().X(), aBtnSoundPosY + aYPt.Y() ) );
			aLbSound.SetPosPixel( Point(
				aLbSound.GetPosPixel().X(), aLbSoundPosY + aYPt.Y() ) );
			aBtnSearch.SetPosPixel( Point(
				aBtnSearch.GetPosPixel().X(), aBtnSearchPosY + aYPt.Y() ) );


			if( eViewType == VIEWTYPE_SC_EFFECT || bShowAll )
			{
				aLbEffect.Show();
				aCtlEffect.Show();
				aLbSpeed.Show();
			}
			if( eViewType == VIEWTYPE_SC_EXTRAS || bShowAll )
			{
				aBtnAuto.Show();
				aBtnSemi.Show();
				aBtnManual.Show();
				aFldTime.Show();
				aBtnSound.Show();
				aBtnSearch.Show();
				aLbSound.Show();
			}

			//if( !bShowAll )
			//	aBtnViewType.Show();
			aBtnVTEffect.Show();
			aBtnVTExtras.Show();

			aBtnPreview.Show();
			aBtnUpdate.Show();
			aBtnAssign.Show();
			aGrpEffect.Show();

			// Wurde der Zustand der Sichten geaendert
			if( bBreakEven != bShowAll )
			{
				String aStr;
				if( bShowAll )
				{
					aStr  = String( SdResId( GetViewTypeResId( VIEWTYPE_SC_EFFECT ) ) );
					aStr.AppendAscii( " + " );
					aStr.Append( String( SdResId( GetViewTypeResId( VIEWTYPE_SC_EXTRAS ) ) ) );
				}
				else
					aStr  = String( SdResId( GetViewTypeResId( eViewType ) ) );

				aGrpEffect.SetText( aStr );
			}

			bBreakEven = bShowAll;

			aSize = aWinSize;

			ClickViewTypeHdl( NULL );
		}
	}
	SfxDockingWindow::Resize();
}

// -----------------------------------------------------------------------

BOOL SdSlideChangeWin::Close()
{
	return( SfxDockingWindow::Close() );
}

/*************************************************************************
|*
|* Ableitung vom SfxChildWindow als "Behaelter" fuer Effekte
|*
\************************************************************************/

SdSlideChangeChildWindow::SdSlideChangeChildWindow( Window* pParent,
												 USHORT nId,
												 SfxBindings* pBindings,
												 SfxChildWinInfo* pInfo ) :
	SfxChildWindow( pParent, nId )
{
	SdSlideChangeWin* pWin = new SdSlideChangeWin( pBindings, this, pParent,
										SdResId( FLT_WIN_SLIDE_CHANGE ) );
	pWindow = pWin;

	eChildAlignment = SFX_ALIGN_NOALIGNMENT;

	pWin->Initialize( pInfo );
}

/*************************************************************************
|*
|* ControllerItem fuer Preview
|*
\************************************************************************/

SdSlideChangePrevCtrlItem::SdSlideChangePrevCtrlItem( USHORT nId,
								SdSlideChangeWin*  pInWin,
								SfxBindings*	   pBindings) :
	SfxControllerItem	( nId, *pBindings ),
	pWin				( pInWin )
{
}

// -----------------------------------------------------------------------

void SdSlideChangePrevCtrlItem::StateChanged( USHORT nSId,
						SfxItemState eState, const SfxPoolItem* pItem )
{
	if( eState >= SFX_ITEM_AVAILABLE && nSId == SID_PREVIEW_WIN )
	{
		const SfxBoolItem* pStateItem = PTR_CAST( SfxBoolItem, pItem );
		DBG_ASSERT( pStateItem, "SfxBoolItem erwartet");
		BOOL bState = pStateItem->GetValue();

		pWin->aBtnPreview.Check( bState );
	}
}


