/*************************************************************************
 *
 *  $RCSfile: effcthlp.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: thb $ $Date: 2001/06/19 12:42:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_PRESENTATION_ANIMATIONEFFECT_HPP_
#include <com/sun/star/presentation/AnimationEffect.hpp>
#endif

#include <time.h>			// fuer clock_t, clock(), CLOCKS_PER_SEC

#include <svx/gallery.hxx>
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif

#ifndef _XTABLE_HXX //autogen
#include <svx/xtable.hxx>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#include <svtools/pathoptions.hxx>

#include "effect.hxx"
#include "effect.hrc"
#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "sdattr.hxx"
#include "sdresid.hxx"
#include "sdview.hxx"
#include "drawdoc.hxx"
#include "filedlg.hxx"


using namespace ::com::sun::star;

// -----------------------------------------------------------------------

void SdEffectWin::SetAnimationEffect( presentation::AnimationEffect eAE, ValueSet* pValueSet )
{
	USHORT nLB = 0, nVS = 0;
	String aStr( aLbSound.GetSelectEntry() );
	USHORT nSoundId = GetIdBySound( aStr );

	switch( eAE )
	{
		// Kein Effekt
		case presentation::AnimationEffect_NONE:						nLB = 0; nVS = 1; break;

		// Ueberblenden
		case presentation::AnimationEffect_FADE_FROM_LEFT:				nLB = 1; nVS = 4; break;
		case presentation::AnimationEffect_FADE_FROM_UPPERLEFT:			nLB = 1; nVS = 1; break;
		case presentation::AnimationEffect_FADE_FROM_TOP:				nLB = 1; nVS = 2; break;
		case presentation::AnimationEffect_FADE_FROM_UPPERRIGHT:		nLB = 1; nVS = 3; break;
		case presentation::AnimationEffect_FADE_FROM_RIGHT:				nLB = 1; nVS = 6; break;
		case presentation::AnimationEffect_FADE_FROM_LOWERRIGHT:		nLB = 1; nVS = 9; break;
		case presentation::AnimationEffect_FADE_FROM_BOTTOM:			nLB = 1; nVS = 8; break;
		case presentation::AnimationEffect_FADE_FROM_LOWERLEFT:			nLB = 1; nVS = 7; break;

		// Aufdecken
		case presentation::AnimationEffect_MOVE_FROM_LEFT:
			if( nSoundId == 2 && pValueSet == &aCtlEffect ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else
				{ nLB = 2; nVS = 4; }
			break;
		case presentation::AnimationEffect_MOVE_FROM_TOP:
			if( nSoundId == 5 && pValueSet == &aCtlEffect ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else if( nSoundId == 6 && pValueSet == &aCtlTextEffect ) // Favorit (Text)
				{ nLB = 0; nVS = nSoundId; pValueSet = &aCtlEffect; }
			else
				{ nLB = 2; nVS = 2; }
			break;
		case presentation::AnimationEffect_MOVE_FROM_RIGHT:				nLB = 2; nVS = 6; break;
		case presentation::AnimationEffect_MOVE_FROM_BOTTOM:			nLB = 2; nVS = 8; break;
		case presentation::AnimationEffect_MOVE_FROM_UPPERLEFT:			nLB = 2; nVS = 1; break;
		case presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT:		nLB = 2; nVS = 3; break;
		case presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT:		nLB = 2; nVS = 9; break;
		case presentation::AnimationEffect_MOVE_FROM_LOWERLEFT:			nLB = 2; nVS = 7; break;

		// verkuerzt aufdecken
		case presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT:		nLB = 3; nVS = 4; break;
		case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT:	nLB = 3; nVS = 1; break;
		case presentation::AnimationEffect_MOVE_SHORT_FROM_TOP:			nLB = 3; nVS = 2; break;
		case presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT:	nLB = 3; nVS = 3; break;
		case presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT:		nLB = 3; nVS = 6; break;
		case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT:	nLB = 3; nVS = 9; break;
		case presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM:		nLB = 3; nVS = 8; break;
		case presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT:	nLB = 3; nVS = 7; break;

		// Dehnen
		case presentation::AnimationEffect_STRETCH_FROM_LEFT:			nLB = 4; nVS = 4; break;
		case presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT:		nLB = 4; nVS = 1; break;
		case presentation::AnimationEffect_STRETCH_FROM_TOP:			nLB = 4; nVS = 2; break;
		case presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT:		nLB = 4; nVS = 3; break;
		case presentation::AnimationEffect_STRETCH_FROM_RIGHT:			nLB = 4; nVS = 6; break;
		case presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT:		nLB = 4; nVS = 9; break;
		case presentation::AnimationEffect_STRETCH_FROM_BOTTOM:			nLB = 4; nVS = 8; break;
		case presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT:		nLB = 4; nVS = 7; break;

		// Dehnen und Rotieren
		case presentation::AnimationEffect_HORIZONTAL_STRETCH:			nLB = 5; nVS = 1; break;
		case presentation::AnimationEffect_VERTICAL_STRETCH:			nLB = 5; nVS = 2; break;
		case presentation::AnimationEffect_HORIZONTAL_ROTATE:			nLB = 5; nVS = 4; break;
		case presentation::AnimationEffect_VERTICAL_ROTATE:				nLB = 5; nVS = 5; break;

		// Blenden
		case presentation::AnimationEffect_FADE_TO_CENTER:				nLB = 6; nVS = 1; break;
		case presentation::AnimationEffect_FADE_FROM_CENTER:
			if( nSoundId == 8 && pValueSet == &aCtlEffect ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else if( nSoundId == 9 && pValueSet == &aCtlTextEffect ) // Favorit (Text)
				{ nLB = 0; nVS = nSoundId; pValueSet = &aCtlEffect; }
			else
				{ nLB = 6; nVS = 2; }
			break;
		case presentation::AnimationEffect_VERTICAL_STRIPES:			nLB = 6; nVS = 4; break;
		case presentation::AnimationEffect_HORIZONTAL_STRIPES:			nLB = 6; nVS = 5; break;
		case presentation::AnimationEffect_CLOCKWISE:					nLB = 6; nVS = 7; break;
		case presentation::AnimationEffect_COUNTERCLOCKWISE:			nLB = 6; nVS = 8; break;

		// Oeffnen / Schliessen
		case presentation::AnimationEffect_OPEN_VERTICAL:				nLB = 7; nVS = 1; break;
		case presentation::AnimationEffect_OPEN_HORIZONTAL:				nLB = 7; nVS = 2; break;
		case presentation::AnimationEffect_CLOSE_VERTICAL:				nLB = 7; nVS = 4; break;
		case presentation::AnimationEffect_CLOSE_HORIZONTAL:			nLB = 7; nVS = 5; break;

		// Schlangenlinien
		case presentation::AnimationEffect_WAVYLINE_FROM_LEFT:			nLB = 8; nVS = 4; break;
		case presentation::AnimationEffect_WAVYLINE_FROM_RIGHT:			nLB = 8; nVS = 6; break;
		case presentation::AnimationEffect_WAVYLINE_FROM_TOP:			nLB = 8; nVS = 2; break;
		case presentation::AnimationEffect_WAVYLINE_FROM_BOTTOM:		nLB = 8; nVS = 8; break;

		// Spirale
		case presentation::AnimationEffect_SPIRALIN_LEFT:				nLB = 9; nVS = 1; break;
		case presentation::AnimationEffect_SPIRALIN_RIGHT:				nLB = 9; nVS = 3; break;
		case presentation::AnimationEffect_SPIRALOUT_LEFT:				nLB = 9; nVS = 4; break;
		case presentation::AnimationEffect_SPIRALOUT_RIGHT:				nLB = 9; nVS = 6; break;

		// Laser
		case presentation::AnimationEffect_LASER_FROM_LEFT:				nLB = 10; nVS = 4; break;
		case presentation::AnimationEffect_LASER_FROM_TOP:				nLB = 10; nVS = 2; break;
		case presentation::AnimationEffect_LASER_FROM_RIGHT:			nLB = 10; nVS = 6; break;
		case presentation::AnimationEffect_LASER_FROM_BOTTOM:			nLB = 10; nVS = 8; break;
		case presentation::AnimationEffect_LASER_FROM_UPPERLEFT:		nLB = 10; nVS = 1; break;
		case presentation::AnimationEffect_LASER_FROM_UPPERRIGHT:
			if( nSoundId == 3 && pValueSet == &aCtlTextEffect ) // Favorit (Text)
				{ nLB = 0; nVS = nSoundId; pValueSet = &aCtlEffect; }
			else
				{ nLB = 10; nVS = 3; }
			break;
		case presentation::AnimationEffect_LASER_FROM_LOWERLEFT:		nLB = 10; nVS = 7; break;
		case presentation::AnimationEffect_LASER_FROM_LOWERRIGHT:		nLB = 10; nVS = 9; break;

		// Sonstige
		case presentation::AnimationEffect_VERTICAL_LINES:				nLB = 11; nVS = 1; break;
		case presentation::AnimationEffect_HORIZONTAL_LINES:			nLB = 11; nVS = 2; break;
		case presentation::AnimationEffect_DISSOLVE:
			if( nSoundId == 7 && pValueSet == &aCtlEffect ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else
				{ nLB = 11; nVS = 3; }
			break;
		case presentation::AnimationEffect_VERTICAL_CHECKERBOARD:		nLB = 11; nVS = 4; break;
		case presentation::AnimationEffect_HORIZONTAL_CHECKERBOARD:		nLB = 11; nVS = 5; break;
		case presentation::AnimationEffect_APPEAR:						nLB = 11; nVS = 6; break;
		case presentation::AnimationEffect_HIDE:						nLB = 11; nVS = 7; break;
		case presentation::AnimationEffect_PATH:
			if( nSoundId == 4 && pValueSet == &aCtlEffect ) // Favorit
				{ nLB = 0; nVS = nSoundId; }
			else
				{ nLB = 11; nVS = 8; }
			break;
		case presentation::AnimationEffect_RANDOM:						nLB = 11; nVS = 9; break;
	}

	if( pValueSet == &aCtlEffect )
	{
		// Korrektur fuer nicht vorhandene Effekte (LASER)
		if( nLB > 10 )
			nLB--;
		aLbEffect.SelectEntryPos( nLB );
		FillValueSet( pValueSet );
		aCtlEffect.SelectItem( nVS );
		if( aLbEffect.IsVisible() && !aCtlEffect.IsVisible() )
			aCtlEffect.Show();
	}
	else if( pValueSet == &aCtlTextEffect )
	{
		aLbTextEffect.SelectEntryPos( nLB );
		FillValueSet( pValueSet );
		aCtlTextEffect.SelectItem( nVS );
		if( aLbTextEffect.IsVisible() && !aCtlTextEffect.IsVisible() )
			aCtlTextEffect.Show();
	}
}

// -----------------------------------------------------------------------

presentation::AnimationEffect SdEffectWin::GetAnimationEffect( ValueSet* pValueSet )
{
	presentation::AnimationEffect eAE = presentation::AnimationEffect_HIDE; // statt DontKnow

	USHORT nLB;
	USHORT nVS;

	if( pValueSet == &aCtlEffect )
	{
		nLB = aLbEffect.GetSelectEntryPos();
		nVS = aCtlEffect.GetSelectItemId();
		// Korrektur fuer nicht vorhandene Effekte (LASER)
		if( nLB >= 10 )
			nLB++;
	}
	else if( pValueSet == &aCtlTextEffect )
	{
		nLB = aLbTextEffect.GetSelectEntryPos();
		nVS = aCtlTextEffect.GetSelectItemId();
	}

	switch( nLB )
	{
		// Kein Effekt (Jetzt Favoriten)
		case 0:
		{
			if( pValueSet == &aCtlEffect )
			{
				if( nVS == 1 )		eAE = presentation::AnimationEffect_NONE;
				else if( nVS == 2 ) eAE = presentation::AnimationEffect_MOVE_FROM_LEFT;
				else if( nVS == 3 ) eAE = presentation::AnimationEffect_LASER_FROM_UPPERRIGHT; // Text
				else if( nVS == 4 ) eAE = presentation::AnimationEffect_PATH;
				else if( nVS == 5 ) eAE = presentation::AnimationEffect_MOVE_FROM_TOP;
				else if( nVS == 6 ) eAE = presentation::AnimationEffect_MOVE_FROM_TOP; // Text
				else if( nVS == 7 ) eAE = presentation::AnimationEffect_DISSOLVE;
				else if( nVS == 8 ) eAE = presentation::AnimationEffect_FADE_FROM_CENTER;
				else if( nVS == 9 ) eAE = presentation::AnimationEffect_FADE_FROM_CENTER; // Text
			}
			else
				eAE = presentation::AnimationEffect_NONE;
		}
		break;

		// Ueberblenden
		case 1:
		{
			if( nVS == 4 )		eAE = presentation::AnimationEffect_FADE_FROM_LEFT;
			else if( nVS == 2 ) eAE = presentation::AnimationEffect_FADE_FROM_TOP;
			else if( nVS == 6 ) eAE = presentation::AnimationEffect_FADE_FROM_RIGHT;
			else if( nVS == 8 ) eAE = presentation::AnimationEffect_FADE_FROM_BOTTOM;
			else if( nVS == 1 ) eAE = presentation::AnimationEffect_FADE_FROM_UPPERLEFT;
			else if( nVS == 3 ) eAE = presentation::AnimationEffect_FADE_FROM_UPPERRIGHT;
			else if( nVS == 7 ) eAE = presentation::AnimationEffect_FADE_FROM_LOWERLEFT;
			else if( nVS == 9 ) eAE = presentation::AnimationEffect_FADE_FROM_LOWERRIGHT;
		}
		break;

		// Aufdecken
		case 2:
		{
			if( nVS == 4 )		eAE = presentation::AnimationEffect_MOVE_FROM_LEFT;
			else if( nVS == 2 ) eAE = presentation::AnimationEffect_MOVE_FROM_TOP;
			else if( nVS == 6 ) eAE = presentation::AnimationEffect_MOVE_FROM_RIGHT;
			else if( nVS == 8 ) eAE = presentation::AnimationEffect_MOVE_FROM_BOTTOM;
			else if( nVS == 1 ) eAE = presentation::AnimationEffect_MOVE_FROM_UPPERLEFT;
			else if( nVS == 3 ) eAE = presentation::AnimationEffect_MOVE_FROM_UPPERRIGHT;
			else if( nVS == 7 ) eAE = presentation::AnimationEffect_MOVE_FROM_LOWERLEFT;
			else if( nVS == 9 ) eAE = presentation::AnimationEffect_MOVE_FROM_LOWERRIGHT;
		}
		break;

		// verkuerzt Aufdecken
		case 3:
		{
			if( nVS == 4 )		eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_LEFT;
			else if( nVS == 2 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_TOP;
			else if( nVS == 6 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_RIGHT;
			else if( nVS == 8 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_BOTTOM;
			else if( nVS == 1 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERLEFT;
			else if( nVS == 3 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_UPPERRIGHT;
			else if( nVS == 7 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERLEFT;
			else if( nVS == 9 ) eAE = presentation::AnimationEffect_MOVE_SHORT_FROM_LOWERRIGHT;
		}
		break;

		// Dehnen
		case 4:
		{
			if( nVS == 4 )		eAE = presentation::AnimationEffect_STRETCH_FROM_LEFT;
			else if( nVS == 2 ) eAE = presentation::AnimationEffect_STRETCH_FROM_TOP;
			else if( nVS == 6 ) eAE = presentation::AnimationEffect_STRETCH_FROM_RIGHT;
			else if( nVS == 8 ) eAE = presentation::AnimationEffect_STRETCH_FROM_BOTTOM;
			else if( nVS == 1 ) eAE = presentation::AnimationEffect_STRETCH_FROM_UPPERLEFT;
			else if( nVS == 3 ) eAE = presentation::AnimationEffect_STRETCH_FROM_UPPERRIGHT;
			else if( nVS == 7 ) eAE = presentation::AnimationEffect_STRETCH_FROM_LOWERLEFT;
			else if( nVS == 9 ) eAE = presentation::AnimationEffect_STRETCH_FROM_LOWERRIGHT;
		}
		break;

		// Dehnen und Rotieren
		case 5:
		{
			if( nVS == 1 )		eAE = presentation::AnimationEffect_HORIZONTAL_STRETCH;
			else if( nVS == 2 ) eAE = presentation::AnimationEffect_VERTICAL_STRETCH;
			else if( nVS == 4 ) eAE = presentation::AnimationEffect_HORIZONTAL_ROTATE;
			else if( nVS == 5 ) eAE = presentation::AnimationEffect_VERTICAL_ROTATE;
		}
		break;

		// Blenden
		case 6:
		{
			if( nVS == 1 )		eAE = presentation::AnimationEffect_FADE_TO_CENTER;
			else if( nVS == 2 ) eAE = presentation::AnimationEffect_FADE_FROM_CENTER;
			else if( nVS == 4 ) eAE = presentation::AnimationEffect_VERTICAL_STRIPES;
			else if( nVS == 5 ) eAE = presentation::AnimationEffect_HORIZONTAL_STRIPES;
			else if( nVS == 7 ) eAE = presentation::AnimationEffect_CLOCKWISE;
			else if( nVS == 8 ) eAE = presentation::AnimationEffect_COUNTERCLOCKWISE;
		}
		break;

		// Oeffnen / Schliessen
		case 7:
		{
			if( nVS == 1 )		eAE = presentation::AnimationEffect_OPEN_VERTICAL;
			else if( nVS == 2 ) eAE = presentation::AnimationEffect_OPEN_HORIZONTAL;
			else if( nVS == 4 ) eAE = presentation::AnimationEffect_CLOSE_VERTICAL;
			else if( nVS == 5 ) eAE = presentation::AnimationEffect_CLOSE_HORIZONTAL;
		}
		break;

		// Schlangenlinien
		case 8:
		{
			if( nVS == 4 )		eAE = presentation::AnimationEffect_WAVYLINE_FROM_LEFT;
			else if( nVS == 6 ) eAE = presentation::AnimationEffect_WAVYLINE_FROM_RIGHT;
			else if( nVS == 2 ) eAE = presentation::AnimationEffect_WAVYLINE_FROM_TOP;
			else if( nVS == 8 ) eAE = presentation::AnimationEffect_WAVYLINE_FROM_BOTTOM;
		}
		break;

		// Spirale
		case 9:
		{
			if( nVS == 1 )		eAE = presentation::AnimationEffect_SPIRALIN_LEFT;
			else if( nVS == 3 ) eAE = presentation::AnimationEffect_SPIRALIN_RIGHT;
			else if( nVS == 4 ) eAE = presentation::AnimationEffect_SPIRALOUT_LEFT;
			else if( nVS == 6 ) eAE = presentation::AnimationEffect_SPIRALOUT_RIGHT;
		}
		break;

		// Laser
		case 10:
		{
			if( nVS == 4 )		eAE = presentation::AnimationEffect_LASER_FROM_LEFT;
			else if( nVS == 2 ) eAE = presentation::AnimationEffect_LASER_FROM_TOP;
			else if( nVS == 6 ) eAE = presentation::AnimationEffect_LASER_FROM_RIGHT;
			else if( nVS == 8 ) eAE = presentation::AnimationEffect_LASER_FROM_BOTTOM;
			else if( nVS == 1 ) eAE = presentation::AnimationEffect_LASER_FROM_UPPERLEFT;
			else if( nVS == 3 ) eAE = presentation::AnimationEffect_LASER_FROM_UPPERRIGHT;
			else if( nVS == 7 ) eAE = presentation::AnimationEffect_LASER_FROM_LOWERLEFT;
			else if( nVS == 9 ) eAE = presentation::AnimationEffect_LASER_FROM_LOWERRIGHT;
		}
		break;

		// Sonstige
		case 11:
		{
			if( nVS == 1 )		eAE = presentation::AnimationEffect_VERTICAL_LINES;
			else if( nVS == 2 ) eAE = presentation::AnimationEffect_HORIZONTAL_LINES;
			else if( nVS == 3 ) eAE = presentation::AnimationEffect_DISSOLVE;
			else if( nVS == 4 ) eAE = presentation::AnimationEffect_VERTICAL_CHECKERBOARD;
			else if( nVS == 5 ) eAE = presentation::AnimationEffect_HORIZONTAL_CHECKERBOARD;
			else if( nVS == 6 ) eAE = presentation::AnimationEffect_APPEAR;
			else if( nVS == 7 ) eAE = presentation::AnimationEffect_HIDE;
			else if( nVS == 8 ) eAE = presentation::AnimationEffect_PATH;
			else if( nVS == 9 ) eAE = presentation::AnimationEffect_RANDOM;
		}
		break;
	}
	return( eAE );
}

// -----------------------------------------------------------------------

void SdEffectWin::InitColorLB( const SdDrawDocument* pDoc )
{
	XColorTable* pColorTab = pDoc->GetColorTable();

	aLbFadeOutColor.Fill( pColorTab );
}


// -----------------------------------------------------------------------

void SdEffectWin::FillValueSet( ValueSet* pValueSet )
{
	USHORT 		nFirstItem = 0;
	USHORT 		nPos;
	ListBox*	pLb;

	if( pValueSet == &aCtlEffect )
	{
		pLb = &aLbEffect;
	}
	else
	{
		pLb = &aLbTextEffect;
	}
	nPos = pLb->GetSelectEntryPos();

	pValueSet->SetUpdateMode( FALSE );
	//pValueSet->Hide();
	pValueSet->Clear();

	if( nPos != LISTBOX_ENTRY_NOTFOUND )
	{
		for( int i = 1; i <= 11; i++ )
		{
			USHORT nStrId = GetStringId( i, nPos, pValueSet );
			USHORT nBmpId = GetBitmapId( i, nPos, pValueSet );
			if( nStrId != 0 && nBmpId != 0 )
			{
				pValueSet->InsertItem( i, Bitmap( SdResId( nBmpId ) ), String( SdResId( nStrId ) ) );

				if( nFirstItem == 0 )
					nFirstItem = i;
			}
			else
				pValueSet->InsertSpace( i );
		}
		if( !pValueSet->IsVisible() && pLb->IsVisible() )
			pValueSet->Show();

		if( nFirstItem > 0 )
			pValueSet->SelectItem( nFirstItem );
	}
	else
		pValueSet->Hide();
	pValueSet->SetUpdateMode( TRUE );
}

// -----------------------------------------------------------------------

USHORT SdEffectWin::GetBitmapId( USHORT i, USHORT nPos, ValueSet* pValueSet )
{
	List* pList;
	if( pValueSet == &aCtlEffect )
		pList = (List*) ppBitmapIdList->GetObject( nPos );
	else
		pList = (List*) ppBitmapIdListTE->GetObject( nPos );
	ULONG nId = (ULONG) pList->GetObject( i );
	return( (USHORT) nId );
}

// -----------------------------------------------------------------------

USHORT SdEffectWin::GetStringId( USHORT i, USHORT nPos, ValueSet* pValueSet )
{
	List* pList;
	if( pValueSet == &aCtlEffect )
		pList = (List*) ppStringIdList->GetObject( nPos );
	else
		pList = (List*) ppStringIdListTE->GetObject( nPos );
	ULONG nId = (ULONG) pList->GetObject( i );
	return( (USHORT) nId );
}

// -----------------------------------------------------------------------

void SdEffectWin::WaitInEffect( ULONG nMilliSeconds ) const
{
	long aEnd = Time::GetSystemTicks() + nMilliSeconds;
	clock_t aCurrent = Time::GetSystemTicks();
	while (aCurrent < aEnd)
	{
		aCurrent = Time::GetSystemTicks();
	}
}

// -----------------------------------------------------------------------

USHORT SdEffectWin::GetViewTypeResId( ViewType eVT, BOOL bImage )
{
	switch( eVT )
	{
		case VIEWTYPE_EFFECT:
				return( bImage ? IMG_EFFECT : STR_VIEWTYPE_EFFECT );
		case VIEWTYPE_EXTRAS:
				return( bImage ? IMG_EXTRAS : STR_VIEWTYPE_EXTRAS );
		case VIEWTYPE_TEXT:
				return( bImage ? IMG_TEXT : STR_VIEWTYPE_TEXT );
		case VIEWTYPE_ORDER:
				return( bImage ? IMG_ORDER : STR_VIEWTYPE_ORDER );
		default: DBG_ERROR( "Keine Resource fuer ViewType vorhanden!" );
	}
	return( 0 );
}

// -----------------------------------------------------------------------

void SdEffectWin::OpenFileDialog()
{
	SdOpenSoundFileDialog	aFileDialog;

	String aFile;
	USHORT nPos = aLbSound.GetSelectEntryPos();
	if( nPos != LISTBOX_ENTRY_NOTFOUND )
		aFile = *(String*)pSoundList->GetObject( (long)nPos );
	else
		aFile = SvtPathOptions().GetGraphicPath();

	aFileDialog.SetPath( aFile );

	BOOL bValidSoundFile(TRUE);
	BOOL bQuitLoop(FALSE);	

	while( bQuitLoop == FALSE &&
		   aFileDialog.Execute() == ERRCODE_NONE )
	{
		aFile = aFileDialog.GetPath();
		//aLbSound.SelectEntry( aFile );
		// Ist jetzt nicht mehr so einfach, da Gallery, die Liste und
		// die ListBox auf den neusten Stand gebracht werden muessen
		long nPos = GetSoundObject( aFile );

		if( nPos < 0 ) // not in Soundliste
		{
			// try to insert in Gallery
			if( GalleryExplorer::InsertURL( GALLERY_THEME_USERSOUNDS, aFile, SGA_FORMAT_SOUND ) )
			{
				ClearSoundList();
				aLbSound.Clear();
			
				FillSoundListAndBox();
				nPos = GetSoundObject( aFile );
				DBG_ASSERT( nPos >= 0, "Sound nicht in Liste!" );

				bValidSoundFile=TRUE;
				bQuitLoop=TRUE;
			}
			else
			{
				String aStrWarning(SdResId(STR_WARNING_NOSOUNDFILE));
				String aStr; aStr += sal_Unicode('%');
				aStrWarning.SearchAndReplace( aStr , aFile );
				WarningBox aWarningBox( NULL, WB_3DLOOK | WB_RETRY_CANCEL, aStrWarning );
				aWarningBox.SetModalInputMode (TRUE);
				bQuitLoop = aWarningBox.Execute()==RET_RETRY ? FALSE : TRUE;
				
				bValidSoundFile=FALSE;
			}
		}
		else
		{
			bValidSoundFile=TRUE;
			bQuitLoop=TRUE;
		}		  
		
		if( bValidSoundFile )
			aLbSound.SelectEntryPos( (USHORT) nPos );
	}
}

// -----------------------------------------------------------------------

void SdEffectWin::FillSoundListAndBox()
{
	GalleryExplorer::FillObjList( GALLERY_THEME_SOUNDS, *pSoundList );
	GalleryExplorer::FillObjList( GALLERY_THEME_USERSOUNDS, *pSoundList );

	for( ULONG i = 0; i < pSoundList->Count(); i++ )
	{
		INetURLObject aURL( *(String*) pSoundList->GetObject( i ) );
		aLbSound.InsertEntry( aURL.getBase() );
	}
}

// -----------------------------------------------------------------------

void SdEffectWin::ClearSoundList()
{
	ULONG nCount = pSoundList->Count();
	for( ULONG i = 0; i < nCount; i++ )
		delete (String*)pSoundList->GetObject( i );
	pSoundList->Clear();
}

// -----------------------------------------------------------------------

long SdEffectWin::GetSoundObject( const String& rStr )
{
	String aStrIn( rStr );

	aStrIn.ToLowerAscii();

	for( ULONG i = 0, nCount = pSoundList->Count(); i < nCount; i++ )
	{
		String aTmpStr( *(String*)pSoundList->GetObject( i ) );

		aTmpStr.ToLowerAscii();

		if( aTmpStr == aStrIn )
			return( i );
	}

	return( -1L );
}

// -----------------------------------------------------------------------

String SdEffectWin::GetSoundById( USHORT nId )
{
	String aStr;
	switch( nId )
	{
		case 2: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "left" ) );   break;
		case 4: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "curve" ) );  break;
		case 5: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "falling" ) );break;
		case 7: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "untie" ) );  break;
		case 8: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "apert2" ) ); break;

		case 3: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "laser" ) );  break;
		case 6: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "top" ) );    break;
		case 9: aStr = UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "apert" ) );  break;
	}
	return( aStr );
}

// -----------------------------------------------------------------------

USHORT SdEffectWin::GetIdBySound( const String& rStr )
{
	USHORT nId = 1;
	String aStr( rStr );
	aStr.ToLowerAscii();

	if( aStr.EqualsAscii( "left" ) )
		nId = 2;
	else if( aStr.EqualsAscii( "curve" ) )
		nId = 4;
	else if( aStr.EqualsAscii( "falling" ) )
		nId = 5;
	else if( aStr.EqualsAscii( "untie" ) )
		nId = 7;
	else if( aStr.EqualsAscii( "apert2" ) )
		nId = 8;
	else if( aStr.EqualsAscii( "laser" ) )
		nId = 3;
	else if( aStr.EqualsAscii( "top" ) )
		nId = 6;
	else if( aStr.EqualsAscii( "apert" ) )
		nId = 9;

	return( nId );
}


