/*************************************************************************
 *
 *  $RCSfile: TemplateThread.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: aw $ $Date: 2001/07/12 13:26:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include	"TemplateThread.hxx"

#ifndef _OSL_TIME_H_
#include <osl/time.h>
#endif

#ifndef _VOS_MUTEX_HXX
#include <vos/mutex.hxx>
#endif

#ifndef _SFXAPP_HXX
#include <sfx2/app.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

using namespace ::rtl;
using namespace ::ucb;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::ucb;
 
const OUString TITLE			= OUString::createFromAscii ("Title");
const OUString TARGET_DIR_URL	= OUString::createFromAscii ("TargetDirURL");
const OUString DESCRIPTION		= OUString::createFromAscii ("TypeDescription");
const OUString TARGET_URL		= OUString::createFromAscii ("TargetURL");

const OUString DOCTEMPLATES		= OUString::createFromAscii ("com.sun.star.frame.DocumentTemplates");

//	These strings are used to find impress templates in the tree of 
//	template files.  Should probably be determined dynamically.
const OUString IMPRESS_BIN_TEMPLATE	= OUString::createFromAscii ("application/vnd.stardivision.impress");
const OUString IMPRESS_XML_TEMPLATE	= OUString::createFromAscii ("application/vnd.sun.xml.impress");


TemplateThread::TemplateThread	(
		std::vector<TemplateDir*>	& aFolderList,
		void						(*pCallback)	(void * pData),
		void						* pData)
	:	maFolderList (aFolderList),
		mpCallback (pCallback),
		mpData (pData),
        mbIsTerminated (FALSE),
        mbIsDetached (FALSE)
{
	//	empty;
}




TemplateThread::~TemplateThread	(void)
{
	//	empty;
}




void	TemplateThread::GetTemplateRoot	(void)
{
	Reference<lang::XMultiServiceFactory> xFactory = 
		::comphelper::getProcessServiceFactory ();

	Reference<frame::XDocumentTemplates> xTemplates (
		xFactory->createInstance (DOCTEMPLATES), UNO_QUERY);

	if (xTemplates.is())
		mxTemplateRoot = xTemplates->getContent();
}




void	TemplateThread::ScanEntries	(Content & rRoot, TemplateDir * pDir)
{
	Reference<XCommandEnvironment> aCmdEnv;

	//	We are interested only in three properties: the entry's name, 
	//	its URL, and its content type.
	Sequence<OUString> aProps (3);
	aProps[0] = TITLE;
	aProps[1] = TARGET_URL;
	aProps[2] = DESCRIPTION;

	//	Create a cursor to iterate over the templates in this folders.
	ResultSetInclude eInclude =	INCLUDE_DOCUMENTS_ONLY;
	Reference<XResultSet> xResultSet (rRoot.createCursor (aProps, eInclude));

	if (xResultSet.is())
	{
		Reference<XContentAccess> xContentAccess (xResultSet, UNO_QUERY);
		Reference<XRow> xRow (xResultSet, UNO_QUERY);

		//	Iterate over the template folder.
		while (xResultSet->next())
		{
			OUString aTitle (xRow->getString (1));
			OUString aTargetURL (xRow->getString (2));
			OUString aContentType (xRow->getString (3));

			OUString aId = xContentAccess->queryContentIdentifierString();
			Content	 aContent = Content (aId, aCmdEnv);
			if ( ! aContent.isDocument ())
				continue;
				
			//	Check wether the entry is an impress template.  If so add a new 
			//	entry to the resulting list (which is created first if necessary).
			if (	(aContentType == IMPRESS_BIN_TEMPLATE) 
				||	(aContentType == IMPRESS_XML_TEMPLATE))
				pDir->m_aEntries.push_back (
					new TemplateEntry (aTitle, aTargetURL));
		}
	}
}




void TemplateThread::ScanFolders	(void)
{
	try
	{
		//	Create content for template folders.
		Reference<XCommandEnvironment> aCmdEnv;
		Content aTemplateDir (mxTemplateRoot, aCmdEnv);

		//	Define the list of properties we are interested in.
		Sequence<OUString> aProps (2);
		aProps[0] = TITLE;
		aProps[1] = TARGET_DIR_URL;
		
		//	Create an cursor to iterate over the template folders.
		ResultSetInclude eInclude =	INCLUDE_FOLDERS_ONLY;
		Reference<XResultSet> xResultSet (aTemplateDir.createCursor (
			aProps, eInclude));

		if (xResultSet.is())
		{
			Reference<XContentAccess> xContentAccess (xResultSet, UNO_QUERY);
			Reference<XRow> xRow (xResultSet, UNO_QUERY);

			while (xResultSet->next())
			{
				OUString aTitle (xRow->getString (1));
				OUString aTargetDir (xRow->getString (2));
				
				OUString aId = xContentAccess->queryContentIdentifierString();
				Content	 aContent = Content (aId, aCmdEnv);
				if (aContent.isFolder())
				{
					//	Scan the folder and insert it into the list of 
					//	template folders.
					TemplateDir * pDir = new TemplateDir (aTitle, aTargetDir);
					ScanEntries (aContent, pDir);
					if (pDir->m_aEntries.empty())
						delete pDir;
					else
                    {
                    	//	Insert the directory into the folder list.  Take
                        //	care of the fact that maFolderList is a reference
                        //	to an object outside this thread.
                   		::vos::OGuard aGuard (Application::GetSolarMutex());

						// #89432#
						if(!mbIsTerminated && !mbIsDetached)
						{
							// add something to the list
							maFolderList.push_back(pDir);
						}
                    }
				}
					
			}
		}
	}
	catch(::com::sun::star::uno::Exception&)
	{
		//	Ignore all exceptions.
	}
}



// virtual
void SAL_CALL	TemplateThread::run	(void)
{
	GetTemplateRoot	();
	ScanFolders ();
	
	//	Call the callback to indicate that the impress templates have been
    //	read.  Do that only if the thread is not alone (after a detach) or 
    //	about to die (after a terminate).
    if ( ! (mbIsDetached || mbIsTerminated))
		(*mpCallback) (mpData);
}




/*
	This callback method is called when the thread gets terminated.  If it has
	also been detached, then it deletes itself.  Otherwise it remembers the
	termination in a flag.
	The deletion of the thread is done outside the area guarded by the mutex.
*/
//virtual
void SAL_CALL	TemplateThread::onTerminated	(void)
{
	{
		osl::Guard<osl::Mutex> aGuard (maMutex);
    
		if ( ! mbIsDetached)
		{
		    mbIsTerminated = TRUE;
			return;
		}
	}	
	delete this;
}




/*
	This method signifies the thread that it's creator does not keep track of
	it anymore.  It therefore does delete itself if it has been already 
	terminated.  Otherwise it remembers the detachment in a flag.
	The deletion of the thread is done outside the area guarded by the mutex.
*/
void SAL_CALL	TemplateThread::detach	(void)
{
	{
		osl::Guard<osl::Mutex> aGuard (maMutex);
    
		if ( ! mbIsTerminated)
		{
			mbIsDetached = TRUE;
			return;
		}
	}
   	delete this;
}
