/*************************************************************************
 *
 *  $RCSfile: chwindow.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: bm $ $Date: 2001/07/05 13:11:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <svx/flstitem.hxx>

#pragma hdrstop

#ifndef _SV_HELP_HXX //autogen wg. Help
#include <vcl/help.hxx>
#endif

#ifndef _SVDPAGV_HXX //autogen wg. SdrPageView
#include <svx/svdpagv.hxx>
#endif

#ifndef _ZFORLIST_HXX //autogen wg. SvNumberFormatter
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif

#include "chwindow.hxx"
#include "viewshel.hxx"
#include "schview.hxx"
#include "schhids.h"
#include "objid.hxx"

#include "strings.hrc"		// for QuickHelp Strings
#include "glob.hrc"
#include "schresid.hxx"
#include "datarow.hxx"
#include "datapoin.hxx"
#include "schattr.hxx"
#include "chaxis.hxx"


#define QUICK_HELP_TOLERANCE	  2		// in pixels

/************************************************************************/

#define MIN_ZOOM	10
#define MAX_ZOOM	650


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchWindow::SchWindow( Window* pParent ) :
		DropTargetHelper( pParent ),
		Window( pParent, WinBits( WB_CLIPCHILDREN )),
		pViewShell( NULL ),
		aWinPos( 0, 0 ),
		aViewOrigin( 0,  0),
		aViewSize( 1000, 1000 )
{
	MapMode aMap(GetMapMode());
	aMap.SetMapUnit(MAP_100TH_MM);
	SetMapMode(aMap);

	Color aWhiteColor( COL_WHITE );
	SetBackground ( aWhiteColor );

	// Hilfe-ID setzen
	SetHelpId( HID_SCH_WIN_DOCUMENT );
	SetUniqueId( HID_SCH_WIN_DOCUMENT );
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchWindow::~SchWindow()
{
}

/*************************************************************************
|*
|* Die Haelfte des Sichtbaren Bereich eines anderen Fensters darstellen
|*
\************************************************************************/

void SchWindow::ShareViewArea(const SchWindow* pOtherWin)
{
	aViewOrigin	= pOtherWin->aViewOrigin;
	aViewSize  	= pOtherWin->aViewSize;

	long nZoom = pOtherWin->GetZoom();
	MapMode aMap(GetMapMode());
	aMap.SetScaleX(Fraction(nZoom, 100));
	aMap.SetScaleY(Fraction(nZoom, 100));
	aMap.SetOrigin(pOtherWin->GetMapMode().GetOrigin());
	SetMapMode(aMap);
}

/*************************************************************************
|*
|* Paint event
|*
\************************************************************************/

void SchWindow::Paint(const Rectangle& rRect)
{
	if (pViewShell)
		pViewShell->Paint(rRect);
}

/*************************************************************************
|*
|* Keyboard event
|*
\************************************************************************/

void SchWindow::KeyInput(const KeyEvent& rKEvt)
{
	if (!pViewShell || !pViewShell->KeyInput(rKEvt))
		Window::KeyInput(rKEvt);
}

/*************************************************************************
|*
|* MouseButtonDown event
|*
\************************************************************************/

void SchWindow::MouseButtonDown(const MouseEvent& rMEvt)
{
	if (!pViewShell || !pViewShell->MouseButtonDown(rMEvt))
		Window::MouseButtonDown(rMEvt);
}

/*************************************************************************
|*
|* MouseMove event
|*
\************************************************************************/

void SchWindow::MouseMove(const MouseEvent& rMEvt)
{
	if (!pViewShell || !pViewShell->MouseMove(rMEvt))
		Window::MouseMove(rMEvt);
}

/*************************************************************************
|*
|* MouseButtonUp event
|*
\************************************************************************/

void SchWindow::MouseButtonUp(const MouseEvent& rMEvt)
{
	if (!pViewShell || !pViewShell->MouseButtonUp(rMEvt))
		Window::MouseButtonUp(rMEvt);
}

/*************************************************************************
|*
|* Command event
|*
\************************************************************************/

void SchWindow::Command(const CommandEvent& rCEvt)
{
	if (!pViewShell || !pViewShell->Command(rCEvt))
		Window::Command(rCEvt);
}

/*************************************************************************
|*
|* den eigentlichen Zoomfaktor in Prozent setzen; protected, wird
|* nur intern benutzt
|*
\************************************************************************/

long SchWindow::SetZoomFactor(long nZoom)
{
	if (nZoom > MAX_ZOOM)
		nZoom = MAX_ZOOM;
	if (nZoom < MIN_ZOOM)
		nZoom = MIN_ZOOM;

	MapMode aMap(GetMapMode());
	aMap.SetScaleX(Fraction(nZoom, 100));
	aMap.SetScaleY(Fraction(nZoom, 100));
	SetMapMode(aMap);
	return nZoom;
}

/*************************************************************************
|*
|* Zoomfaktor in Prozent setzen und Darstellungsbereich um den
|* Zoom-Mittelpunkt zentrieren
|*
\************************************************************************/

void SchWindow::SetZoom(long nZoom)
{
	if (nZoom > MAX_ZOOM)
		nZoom = MAX_ZOOM;
	if (nZoom < MIN_ZOOM)
		nZoom = MIN_ZOOM;

	Size aSize = PixelToLogic(GetSizePixel());
	long nW = aSize.Width()  * GetZoom() / nZoom;
	long nH = aSize.Height() * GetZoom() / nZoom;
	aWinPos.X() += (aSize.Width()  - nW) / 2;
	aWinPos.Y() += (aSize.Height() - nH) / 2;
	SetZoomFactor(nZoom);
}

/*************************************************************************
|*
|* Fensterposition und Zoomfaktor nach uebergebenem Rechteck setzen
|* obere linke Ecke des Rechtecks muss relativ zur linken oberen
|* Ecke des Fensters angegeben werden; gibt den berechneten Zoom-
|* faktor zurueck
|*
\************************************************************************/

long SchWindow::SetZoomRect(const Rectangle& rZoomRect)
{
	Size aWinSize = PixelToLogic(GetSizePixel());
	DBG_ASSERT(rZoomRect.GetWidth(), "ZoomRect-Breite = 0!");
	DBG_ASSERT(rZoomRect.GetHeight(), "ZoomRect-Hoehe = 0!");
	long nX = aWinSize.Width()	* 100 / rZoomRect.GetWidth();
	long nY = aWinSize.Height() * 100 / rZoomRect.GetHeight();
	long nZoom = Min(nX, nY) * GetZoom() / 100;

	aWinPos.X() = aViewOrigin.X() + rZoomRect.Left();
	aWinPos.Y() = aViewOrigin.Y() + rZoomRect.Top();

	if (nX < nY)
	{
		aWinSize.Height() = aWinSize.Height() * 100 / nX;
		aWinPos.Y() += rZoomRect.GetHeight() / 2 - aWinSize.Height() / 2;
	}

	if (nY < nX)
	{
		aWinSize.Width()  = aWinSize.Width() * 100 / nY;
		aWinPos.X() += rZoomRect.GetWidth() / 2 - aWinSize.Width() / 2;
	}

	return SetZoomFactor(nZoom);
}

/*************************************************************************
|*
|* Neuen MapMode-Origin berechnen und setzen
|*
\************************************************************************/

void SchWindow::UpdateMapOrigin()
{
	MapMode aMap(GetMapMode());

	Point aNewOrigin(-aWinPos.X() + aViewOrigin.X(),
					 -aWinPos.Y() + aViewOrigin.Y());

	if (aMap.GetOrigin() != aNewOrigin)
	{
		aMap.SetOrigin(aNewOrigin);
		SetMapMode(aMap);
		Invalidate();
	}
}


/*************************************************************************
|*
|* DataChanged
|*
\************************************************************************/

void SchWindow::DataChanged( const DataChangedEvent& rDCEvt )
{
	Window::DataChanged( rDCEvt );

	// PRINTER bei allen Dokumenten weglassen, die keinen Printer benutzen.
	// FONTS und FONTSUBSTITUTION weglassen, wenn keine Textausgaben
	// vorhanden sind, bzw. wenn das Dokument keinen Text zulaesst.

	if ( (rDCEvt.GetType() == DATACHANGED_PRINTER) ||
		 (rDCEvt.GetType() == DATACHANGED_DISPLAY) ||
		 (rDCEvt.GetType() == DATACHANGED_FONTS) ||
		 (rDCEvt.GetType() == DATACHANGED_FONTSUBSTITUTION) ||
		 ((rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
		  (rDCEvt.GetFlags() & SETTINGS_STYLE)) )
	{
		if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
			 (rDCEvt.GetFlags() & SETTINGS_STYLE) )
		{
			// ScrollBars neu anordnen bzw. Resize ausloesen, da sich
			// ScrollBar-Groesse geaendert haben kann. Dazu muss dann im
			// Resize-Handler aber auch die Groesse der ScrollBars aus
			// den Settings abgefragt werden.
			Resize();

			// Daten neu Setzen, die aus den Systemeinstellungen bzw. aus
			// den Settings uebernommen werden. Evtl. weitere Daten neu
			// berechnen, da sich auch die Aufloesung hierdurch geaendert
			// haben kann.
		}

		if ( (rDCEvt.GetType() == DATACHANGED_DISPLAY) ||
			 ((rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
			  (rDCEvt.GetFlags() & SETTINGS_STYLE)) )
		{
			// Virtuelle Device die auch von der Aufloesung oder von
			// Systemeinstellungen abhaengen, sollten geupdatet werden.
			// Ansonsten sollte zumindest bei DATACHANGED_DISPLAY
			// die virtuellen Devices geupdatet werden, da es einige
			// Systeme erlauben die Aufloesung und Farbtiefe waehrend
			// der Laufzeit zu aendern oder eben bei Palettenaenderungen
			// die virtuellen Device geupdatet werden muessen, da bei
			// Ausgaben ein anderes Farbmatching stattfinden kann.
		}

		if ( rDCEvt.GetType() == DATACHANGED_FONTS )
		{
			// Wenn das Dokument Font-AuswahlBoxen anbietet, muessen
			// diese geupdatet werden. Wie dies genau aussehen muss,
			// weiss ich leider auch nicht. Aber evtl. kann man das
			// ja global handeln. Dies muessten wir evtl. mal
			// mit PB absprechen, aber der ist derzeit leider Krank.
			// Also bevor dies hier gehandelt wird, vorher mit
			// PB und mir absprechen.
		}

		if ( (rDCEvt.GetType() == DATACHANGED_FONTS) ||
			 (rDCEvt.GetType() == DATACHANGED_FONTSUBSTITUTION) )
		{
			// Formatierung neu durchfuehren, da Fonts die im Dokument
			// vorkommen, nicht mehr vorhanden sein muessen oder
			// jetzt vorhanden sind oder durch andere ersetzt wurden
			// sind.
			if( pViewShell )
			{
				SchChartDocShell* pDocSh = pViewShell->GetDocSh();
				if( pDocSh )
					pDocSh->SetPrinter( pDocSh->GetPrinter() );
			}
		}

		if ( rDCEvt.GetType() == DATACHANGED_PRINTER )
		{
			// Wie hier die Behandlung aussehen soll, weiss ich leider
			// selbst noch nicht. Evtl. mal einen Printer loeschen und
			// schauen was gemacht werden muss. Evtl. muesste ich in
			// VCL dafuer noch etwas einbauen, wenn der benutze Printer
			// geloescht wird. Ansonsten wuerde ich hier evtl. die
			// Formatierung neu berechnen, wenn der aktuelle Drucker
			// zerstoert wurde.
			if( pViewShell )
			{
				SchChartDocShell* pDocSh = pViewShell->GetDocSh();
				if( pDocSh )
					pDocSh->SetPrinter( pDocSh->GetPrinter() );
			}
		}

		// Alles neu ausgeben
		Invalidate();
	}
}


// for quick help
void SchWindow::RequestHelp( const HelpEvent& rHEvt )
{
	if ( rHEvt.GetMode() & HELPMODE_QUICK )
	{
		if( pViewShell ) {
			SdrView* pView = pViewShell->GetView();
			if( pView && ! pView->IsDragObj() )
			{
				SdrPage* pPage = pView->GetPageViewPvNum(0)->GetPage();

				if( pPage )
				{
					// find object under cursor
					Point aPointerPos = PixelToLogic( GetPointerPosPixel() );
					SdrObject *pHitObj = GetHitObject( (SdrObjList*)pPage, aPointerPos );

					if( pHitObj )
					{	
						if( Help::IsBalloonHelpEnabled())
                        {
                            String aHelpText = GetQuickHelpText( pHitObj, (ChartModel*)pPage->GetModel(), TRUE ).ConvertLineEnd();
                            Help::ShowBalloon( this, rHEvt.GetMousePosPixel(), pHitObj->GetBoundRect(), aHelpText );
                        }
                        else
                        {
                            String aHelpText = GetQuickHelpText( pHitObj, (ChartModel*)pPage->GetModel(), FALSE);
                            Help::ShowQuickHelp( this, pHitObj->GetBoundRect(), aHelpText );
                        }
					}
				}
			}
		}
	}
	else
		Window::RequestHelp( rHEvt );
}


SdrObject *SchWindow::GetHitObject( SdrObjList *pObjList, Point &aPos )
{
	USHORT nTolerance = (USHORT)PixelToLogic( Size( QUICK_HELP_TOLERANCE, 0 ) ).Width();

	SdrObject *pHitObj;

	// simple depth first search
	if( pObjList )
	{
		SdrObjListIter aIterator( *pObjList, IM_FLAT, TRUE ); // iterate backward
		while (aIterator.IsMore())
		{
			pHitObj = aIterator.Next();

			if( pHitObj->IsHit( aPos, nTolerance ) )
			{
				SchObjectId* pId = GetObjectId( *pHitObj );
				if( pHitObj->IsGroupObject() )
				{
					if( pId )
					{
						switch( pId->GetObjId() )
						{
							case CHOBJID_DIAGRAM_FLOOR:
							case CHOBJID_DIAGRAM_WALL:
  							case CHOBJID_DIAGRAM_DATA:
								return pHitObj;

							case CHOBJID_TEXT:
							case CHOBJID_LINE:
							case CHOBJID_AREA:
								return pObjList->GetOwnerObj();	// return parent object
								
							default:							// recurse with SubList
								{
									SdrObject *pResult = GetHitObject( pHitObj->GetSubList(), aPos );
									if( pResult )
										return pResult;
									break;
								}
						}
					}
				}
				else	// non-group object
				{
					if( pId )
					{
						switch( pId->GetObjId() )
						{
							case CHOBJID_TEXT:
							case CHOBJID_LINE:
							case CHOBJID_AREA:
								return pObjList->GetOwnerObj();		// return parent object

							default:
								break;
						}
					}
					return pHitObj;
				}
			}
		}
	}
	
	return NULL;
}

String SchWindow::GetQuickHelpText( SdrObject *pObj, ChartModel* pModel, BOOL bVerbose )
{
	SchObjectId* pId = GetObjectId( *pObj );

	if( pId )
	{
		const sal_Unicode aQuote( '\"' );
		switch( pId->GetObjId() )
		{
			case CHOBJID_DIAGRAM_AREA:
				return String(SchResId( STR_DIAGRAM_AREA ));

			case CHOBJID_DIAGRAM_ROWGROUP:
			case CHOBJID_DIAGRAM_ROWS:
			case CHOBJID_DIAGRAM_ROWSLINE:
			case CHOBJID_DIAGRAM_SPECIAL_GROUP:
			case CHOBJID_DIAGRAM_STACKEDGROUP:
			case CHOBJID_LEGEND_SYMBOL_ROW:
				{
					SchDataRow *pDataRow = GetDataRow(*pObj);
					String aResult( SchResId( STR_DIAGRAM_ROW ) );

					if( pDataRow )
					{
						if( pModel )
						{
							String aName( aQuote );
							aName.Append( pModel->RowText( pDataRow->GetRow()) );
							aName.Append( aQuote );
							aResult.SearchAndReplaceAscii( "$(ROW)",  aName );
						}
					}
					return aResult;
				}
				break;

			case CHOBJID_LEGEND_SYMBOL_COL:
				return String(SchResId( STR_LEGEND_SYMBOL_COL ));

			case CHOBJID_LEGEND:
			case CHOBJID_LEGEND_BACK:
				return String(SchResId( STR_LEGEND ));

			case CHOBJID_DIAGRAM_DATA:
				{
					SchDataPoint *pDataPoint = GetDataPoint(*pObj);
					if( pDataPoint )
					{
						long nCol = pDataPoint->GetCol();
						long nRow = pDataPoint->GetRow();

						String aText;
						long nUId = ( (const SfxInt32Item&)pModel->GetDataRowAttr( nRow ).Get( SCHATTR_AXIS ) ).GetValue();
						ChartAxis *pAxis = pModel->GetAxisByUID( nUId );
						long nNumf = pAxis->GetNumFormat( FALSE );

						Color* pTextColor = NULL;
						pModel->GetNumFormatter()->GetOutputString(
							pModel->GetData(nCol, nRow), nNumf, aText, &pTextColor);

						String aResult( SchResId( bVerbose? STR_BALLOONHELP_DATAPOINT: STR_QUICKHELP_DATAPOINT ) );

						aResult.SearchAndReplaceAscii( "$(VALUE)", aText );

						if( bVerbose )
						{
							String aStrQuoted( aQuote );
							aStrQuoted.Append( pModel->ColText( nCol ));
							aStrQuoted.Append( aQuote );
							aResult.SearchAndReplaceAll( String( RTL_CONSTASCII_USTRINGPARAM( "$(NEWLINE)" )),
														 String( RTL_CONSTASCII_USTRINGPARAM( "\n" )));
							aResult.SearchAndReplaceAscii( "$(PT_STR)",  aStrQuoted );
							aStrQuoted = aQuote;
							aStrQuoted.Append( pModel->RowText( nRow ));
							aStrQuoted.Append( aQuote );
							aResult.SearchAndReplaceAscii( "$(ROW_STR)", aStrQuoted );
						}
						else
						{
							aResult.SearchAndReplaceAscii( "$(PT_NUM)",  String::CreateFromInt32( nCol + 1 ));
							aResult.SearchAndReplaceAscii( "$(ROW_NUM)", String::CreateFromInt32( nRow + 1 ));
						}
					
						return aResult;
					}
				}
				break;

			case CHOBJID_TITLE_MAIN:
				return String(SchResId( STR_TITLE_MAIN ));

			case CHOBJID_TITLE_SUB:
				return String(SchResId( STR_TITLE_SUB ));

			case CHOBJID_DIAGRAM_TITLE_X_AXIS:
				return String(SchResId( STR_DIAGRAM_TITLE_X_AXIS ));

			case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
				return String(SchResId( STR_DIAGRAM_TITLE_Y_AXIS ));

			case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
				return String(SchResId( STR_DIAGRAM_TITLE_Z_AXIS ));

			case CHOBJID_DIAGRAM_X_AXIS:
			case CHOBJID_DIAGRAM_A_AXIS:
				return String(SchResId( STR_DIAGRAM_X_AXIS ));

			case CHOBJID_DIAGRAM_Y_AXIS:
			case CHOBJID_DIAGRAM_B_AXIS:
				return String(SchResId( STR_DIAGRAM_Y_AXIS ));

			case CHOBJID_DIAGRAM_Z_AXIS:
			case CHOBJID_DIAGRAM_C_AXIS:
				return String(SchResId( STR_DIAGRAM_Z_AXIS ));

				// attention: x and y grids are interchanged
			case CHOBJID_DIAGRAM_X_GRID_MAIN:
				return String(SchResId( STR_DIAGRAM_Y_GRID_MAIN ));

			case CHOBJID_DIAGRAM_Y_GRID_MAIN:
				return String(SchResId( STR_DIAGRAM_X_GRID_MAIN ));

			case CHOBJID_DIAGRAM_Z_GRID_MAIN:
				return String(SchResId( STR_DIAGRAM_Z_GRID_MAIN ));

				// attention: x and y grids are interchanged
			case CHOBJID_DIAGRAM_X_GRID_HELP:
				return String(SchResId( STR_DIAGRAM_Y_GRID_HELP ));

			case CHOBJID_DIAGRAM_Y_GRID_HELP:
				return String(SchResId( STR_DIAGRAM_X_GRID_HELP ));

			case CHOBJID_DIAGRAM_Z_GRID_HELP:
				return String(SchResId( STR_DIAGRAM_Z_GRID_HELP ));

			case CHOBJID_DIAGRAM_DESCR_ROW:
				return String(SchResId( STR_DIAGRAM_DESCR_ROW ));

			case CHOBJID_DIAGRAM_DESCR_COL:
				return String(SchResId( STR_DIAGRAM_DESCR_COL ));

			case CHOBJID_DIAGRAM_DESCR_SYMBOL:
				return String(SchResId( STR_LEGEND_SYMBOL_ROW ));

			case CHOBJID_DIAGRAM_STOCKLINE:
				return String(SchResId( STR_LINE ));

			case CHOBJID_DIAGRAM_WALL:
				return String(SchResId( STR_DIAGRAM_WALL ));

			case CHOBJID_DIAGRAM_FLOOR:
				return String(SchResId( STR_DIAGRAM_FLOOR ));

			case CHOBJID_DIAGRAM_AVERAGEVALUE:
				return String(SchResId( STR_AVERAGEVALUE ));
				
			case CHOBJID_DIAGRAM_ERROR:
				return String(SchResId( STR_DIAGRAM_ERROR ));
				
			case CHOBJID_DIAGRAM_REGRESSION:
				return String(SchResId( STR_DIAGRAM_REGRESSION ));

			case CHOBJID_DIAGRAM_NET:
				return String(SchResId( STR_NET ));

			default:
#ifdef DBG_UTIL
				String aResult = String::CreateFromAscii( GetCHOBJIDName( pId->GetObjId()));
				aResult.Append( String::CreateFromAscii( " -> ", 4 ));
				aResult.Append( String::CreateFromInt32( pId->GetObjId()));
				return aResult;
#else
				break;
#endif
		}
	}

#ifdef DBG_UTIL
	return String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "Invalid Id" ));
#else
	return String();
#endif
}


// ========================================
// DropTargetHelper for drag and drop
// ========================================

sal_Int8 SchWindow::AcceptDrop( const AcceptDropEvent& rEvt )
{
	sal_Int8 nRet = DND_ACTION_NONE;

	if( pViewShell && !pViewShell->GetDocSh()->IsReadOnly() )
	{
		if( pViewShell )
			nRet = pViewShell->AcceptDrop( rEvt, this );
	}

	return nRet;
}

// ----------------------------------------

sal_Int8 SchWindow::ExecuteDrop( const ExecuteDropEvent& rEvt )
{
	sal_Int8 nRet = DND_ACTION_NONE;

	if( pViewShell )
	{
		nRet = pViewShell->ExecuteDrop( rEvt, this );
	}

	return nRet;
}
