/*************************************************************************
 *
 *  $RCSfile: AccessibleBase.hxx,v $
 *
 *  $Revision: 1.7.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 14:39:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SCH_ACCESSIBLEBASE_HXX_
#define _SCH_ACCESSIBLEBASE_HXX_

#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _DRAFTS_COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLE_HPP_
#include <drafts/com/sun/star/accessibility/XAccessible.hpp>
#endif
#ifndef _DRAFTS_COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLECONTEXT_HPP_
#include <drafts/com/sun/star/accessibility/XAccessibleContext.hpp>
#endif
#ifndef _DRAFTS_COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLECOMPONENT_HPP_
#include <drafts/com/sun/star/accessibility/XAccessibleComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XEVENTLISTENER_HPP_
#include <com/sun/star/document/XEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#ifndef _DRAFTS_COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLEEVENTBROADCASTER_HPP_
#include <drafts/com/sun/star/accessibility/XAccessibleEventBroadcaster.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE7_HXX_
#include <cppuhelper/implbase7.hxx>
#endif
#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif
#ifndef _UTL_ACCESSIBLESTATESETHELPER_HXX_
#include <unotools/accessiblestatesethelper.hxx>
#endif

#include "AccessibleUniqueId.hxx"

#include <vector>
#include <hash_map>

class ChartModel;
class SchWindow;
class SfxHint;

namespace accessibility
{

/** Base class for chart accessibility objects.  This class contains a pointer
    to a ChartModel, thus, components can easily access all core functionality

    Usage Instructions:

    <ul>
     <li>define the getAccessibleName() method of XAccessibleContext</li>
     <li>set the ChartModel using SetChartModel() for the first node before
         creating any children</li>
     <li>overload UpdateChildren()</li>
    </ul>
 */
class AccessibleBase : public ::cppu::WeakImplHelper7<
    ::com::sun::star::lang::XComponent,
    ::drafts::com::sun::star::accessibility::XAccessible,
    ::drafts::com::sun::star::accessibility::XAccessibleContext,
    ::drafts::com::sun::star::accessibility::XAccessibleComponent,
    ::drafts::com::sun::star::accessibility::XAccessibleEventBroadcaster,
    ::com::sun::star::lang::XServiceInfo,
    ::com::sun::star::lang::XEventListener >
{
public:
    enum EventType
    {
        OBJECT_CHANGE,
        GOT_SELECTION,
        LOST_SELECTION,
        PROPERTY_CHANGE
    };

    AccessibleBase( const AccessibleUniqueId & rId, AccessibleBase * pParent, bool bMayHaveChildren );
	virtual ~AccessibleBase();

    /** @param bThrowException if true, a DisposedException is thrown if the
               object is already disposed
        @return true, if the component is already disposed and bThrowException is false,
                false otherwise
     */
    bool             CheckDisposeState( bool bThrowException = true ) const throw (::com::sun::star::lang::DisposedException);
    /** Always use the mutex returned here to monitor member access in derived
        classes.

        @return a mutex for protecting concurrent access
     */
    ::osl::Mutex &   GetMutex() const;

    /** Get the ChartModel, which is the core object for charts (you can do
        almost everything using this monolithic class).
     */
    ChartModel * GetChartModel() const;

    /** Get the window, that initiated the building of the accessibility tree
        that includes this element as node.
     */
    SchWindow *     GetWindow() const;

    /** @return a unique id with which you can easily find a child object
        without having an index.  This may be uninitialized (default
        constructed) for elements which themselves are no children.
     */
    const AccessibleUniqueId &  GetId() const;

    /** @return a child that can be identified by the given id.  If no according
                child could be found, a NULL pointer is returned
     */
    ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessible >
                     GetChild( const AccessibleUniqueId & rId ) const;
    /// @return true if the accessible object with the given id is a child of this object
    bool             HasChild( const AccessibleUniqueId & rId ) const;

    /** Events coming from the core have to be processed in this methods.  The
        default implementation returns false, which indicates that the object is
        not interested in the event.  To react on events you have to implement
        this method in derived classes.

        The default implementation iterates over all children and forwards the
        event until the first child returns true.

        @param rHint is the core hint.  This Hint usually is a derived class.
                You can check its type be using the ISA() method on this object.
                Hints concerning changed drawing objects are of type SdrHint
                (see svx/svdmodel.hxx).
        @param nObjId contains the object id of chart objects.  If the object is
                no chart object, the event is not broadcast.
        @return If an object is the addressee of the event it should return
                true, false otherwise.
     */
    virtual bool     NotifyEvent( EventType eType,
                                  const AccessibleUniqueId & rId,
                                  const SfxHint * pHint = 0 );

	/** Adds a state to the set.
	*/
	void             AddState( sal_Int16 aState ) throw (::com::sun::star::uno::RuntimeException);

	/** Removes a state from the set if the set contains the state, otherwise
        nothing is done.
	*/
	void             RemoveState( sal_Int16 aState ) throw (::com::sun::star::uno::RuntimeException);

    // ________ XComponent ________
    virtual void SAL_CALL dispose() throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL addEventListener( const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XEventListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL removeEventListener( const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XEventListener >& aListener ) throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessible ________
    virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessibleContext > SAL_CALL getAccessibleContext() throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessibleContext ________
    virtual sal_Int32 SAL_CALL getAccessibleChildCount() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleChild( sal_Int32 i ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleParent() throw (::com::sun::star::uno::RuntimeException);
    virtual sal_Int32 SAL_CALL getAccessibleIndexInParent() throw (::com::sun::star::uno::RuntimeException);
    /// @return AccessibleRole.SHAPE
    virtual sal_Int16 SAL_CALL getAccessibleRole() throw (::com::sun::star::uno::RuntimeException);
    /// @return the implementation-name (see XTypeProvider) plus the index in parent
    virtual ::rtl::OUString SAL_CALL getAccessibleName() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessibleRelationSet > SAL_CALL getAccessibleRelationSet() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessibleStateSet > SAL_CALL getAccessibleStateSet() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::lang::Locale SAL_CALL getLocale() throw (::drafts::com::sun::star::accessibility::IllegalAccessibleComponentStateException, ::com::sun::star::uno::RuntimeException);

    // has to be defined in derived classes

    // virtual ::rtl::OUString SAL_CALL getAccessibleDescription() throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessibleComponent ________
    virtual sal_Bool SAL_CALL contains( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessible > SAL_CALL getAccessibleAt( const ::com::sun::star::awt::Point& aPoint ) throw (::com::sun::star::uno::RuntimeException);
    // has to be defined in derived classes    
    // virtual ::com::sun::star::awt::Rectangle SAL_CALL getBounds() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::awt::Point SAL_CALL getLocation() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::awt::Point SAL_CALL getLocationOnScreen() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::awt::Size SAL_CALL getSize() throw (::com::sun::star::uno::RuntimeException);
    virtual sal_Bool SAL_CALL isShowing() throw (::com::sun::star::uno::RuntimeException);
    virtual sal_Bool SAL_CALL isVisible() throw (::com::sun::star::uno::RuntimeException);
    virtual sal_Bool SAL_CALL isFocusTraversable() throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL addFocusListener( const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XFocusListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL removeFocusListener( const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XFocusListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL grabFocus() throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Any SAL_CALL getAccessibleKeyBinding() throw (::com::sun::star::uno::RuntimeException);

    // ________ XServiceInfo ________
    virtual ::rtl::OUString SAL_CALL getImplementationName() throw (::com::sun::star::uno::RuntimeException);
    virtual sal_Bool SAL_CALL supportsService( const ::rtl::OUString& ServiceName ) throw (::com::sun::star::uno::RuntimeException);
    virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames() throw (::com::sun::star::uno::RuntimeException);

    // ________ XEventListener ________
    virtual void SAL_CALL disposing( const ::com::sun::star::lang::EventObject& Source ) throw (::com::sun::star::uno::RuntimeException);

    // ________ XAccessibleEventBroadcaster ________
    virtual void SAL_CALL addEventListener( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessibleEventListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL removeEventListener( const ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessibleEventListener >& xListener ) throw (::com::sun::star::uno::RuntimeException);

protected:
    // for all calls to protected methods it is assumed that the mutex is locked
    // beforehand.

    /** has to be overloaded by derived classes that support child elements.
        With this method a rescan is initiated that should result in a correct
        list of children.

        This method is called when access to any methods concerning children is
        invoked for the first time.
     */
    virtual bool UpdateChildren();

    /** Retrieve the pixel coordinates of logical coordinates (0,0) of the
        current logic coordinate system.  This can be used for
        getLocationOnScreen, if the coordinates of an object are not relative to
        its direct parent, but a parent higher up in hierarchy.

        @return the (x,y) pixel coordinates of the upper left corner
     */
    virtual ::com::sun::star::awt::Point   GetUpperLeftOnScreen() const;

    /** adds a child to the end of the internal vector of children.  As a
        result, the child-count increases by one, but all existing children keep
        their indices.

        Important: as the implementation is needed, this should remain the only
        method for adding children (i.e. there mustn't be an AddChild( Reference<
        XAccessible > ) or the like).
     */
    void         AddChild( AccessibleBase * pChild );

    /** removes a child from the internal vector.  All children with index
        greater than the index of the removed element get an index one less than
        before.
     */
    void         RemoveChildById( const AccessibleUniqueId & rId );

    /** returns the index of a given child.

        This is especially useful if and object has a parent.  In this case you
        can ask your parent for your own index there (see getIndexInParent())
     */
    sal_Int32    GetChildIndex(
        const ::com::sun::star::uno::Reference<
        ::drafts::com::sun::star::accessibility::XAccessible > & rChild ) const;

    /** With this method you can easily update the child-list by just providing two
        states and an id.

        If the old state and the new state are equal, nothing happens.  If the
        new state is true (and the old one false) a new child of type rId is
        created using the ChartElementFactory and is added to the internal child
        list.  If the new state is false (and the old one true) the child is
        removed.

        @return bNewState
     */
    bool         UpdateChild( const AccessibleUniqueId & rId,
                              bool bOldState, bool bNewState );

    /** This method should be called before any children are created.  This is
        because if the model was not set explicitly by this method, it will be
        taken from the parent (if available) in the constructor.

        This method should not be called more than once.  For a new model you
        should create a completely new instance of this class.
     */
    void         SetChartModel( ChartModel * );

    /** This method should be called before any children are created.  This is
        because if the window was not set explicitly by this method, it will be
        taken from the parent (if available) in the constructor.

        This method should not be called more than once.  For a new model you
        should create a completely new instance of this class.
     */
    void         SetWindow( SchWindow * );

    /** This method creates an AccessibleEventObject and sends it to all
        listeners that are currently listening to this object
     */
    void         BroadcastAccEvent( sal_Int16 nId,
                                    const ::com::sun::star::uno::Any & rNew,
                                    const ::com::sun::star::uno::Any & rOld ) const;

    /** Removes all children from the internal lists and broadcasts child remove
        events.

        This method cares about mutex locking, and thus should be called without
        the mutex locked.
     */
    virtual void KillAllChildren();

private:
    /** type of the vector containing the accessible children
     */
    typedef ::std::vector< ::com::sun::star::uno::Reference<
        ::drafts::com::sun::star::accessibility::XAccessible > >
        ChildListVectorType;
    /** index type of the random access iterator of the ChildListVectorType
     */
    typedef ::std::vector< ::com::sun::star::uno::Reference<
        ::drafts::com::sun::star::accessibility::XAccessible > >::size_type
        VectorIndexType;
    /** type of the hash containing a vector index for every AccessibleUniqueId
        of the object in the child list
     */
    typedef ::std::hash_map< AccessibleUniqueId, VectorIndexType, AccessibleUniqueIdHash >
        ChildIndexHashType;

    mutable ::osl::Mutex                  m_aAccBaseMutex;
    bool                                  m_bIsDisposed;
	::cppu::OInterfaceContainerHelper     m_aDisposeListenerList;

    const bool                            m_bMayHaveChildren;
    bool                                  m_bChildrenInitialized;
    ChildListVectorType                   m_aChildList;

    /** stores the index in the vector associated with a unique id that can be
        constructed using the object id and an index.
     */
    ChildIndexHashType                   m_aChildIndexAccess;

    AccessibleBase *                      m_pParent;

    ChartModel *                          m_pModel;
    SchWindow *                           m_pWindow;

    const AccessibleUniqueId              m_aId;

    ::cppu::OBroadcastHelper              m_aAccEventBroadcaster;

    /** Implementation helper for getAccessibleStateSet()

        Note: This member must come before m_aStateSet!
     */
    ::utl::AccessibleStateSetHelper *     m_pStateSetHelper;
    /** this is returned in getAccessibleStateSet().

        The implementation is an ::utl::AccessibleStateSetHelper.  To access
        implementation methods use m_pStateSetHelper.

        Note: Keeping this reference ensures, that the helper object is only
              destroyed after this object has been disposed().
     */
    ::com::sun::star::uno::Reference< ::drafts::com::sun::star::accessibility::XAccessibleStateSet >
        m_aStateSet;

    /** This method removed the child the iterator points to.
     */
    void RemoveChild( const ChildListVectorType::iterator& rIter );
};
 
}       // namespace accessibility

// _SCH_ACCESSIBLEBASE_HXX_
#endif
