/*************************************************************************
 *
 *  $RCSfile: chtscene.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: bm $ $Date: 2001/08/16 11:46:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop


#ifndef _XPOLY_HXX //autogen
#include <svx/xpoly.hxx>
#endif

#include "axisid.hxx"
#include "chtscene.hxx"
#include "chtmodel.hxx"

#pragma optimize ("",off)


TYPEINIT1(ChartScene, E3dPolyScene);

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

ChartScene::ChartScene(ChartModel* pDocument) :
	E3dPolyScene(),
	pDoc(pDocument),
	bAskForLogicRect(TRUE)
{
	nSortingMode = E3D_SORT_LOOKUP_FIELD | E3D_SORT_NON_POLYOBJ | E3D_SORT_TEST_LENGTH;
    Initialize();
    SetModel( pDocument );
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

ChartScene::~ChartScene ()
{
}

/*************************************************************************
|*
|* Einpassen der Projektion aller Szenenobjekte in das
|* umschliessende Rechteck
|*
\************************************************************************/

Volume3D ChartScene::FitInSnapRect()
{
	// untransformiertes BoundVolume holen und parent rufen
	Volume3D aNewVol = E3dScene::FitInSnapRect();

	// Groesse etwas anpassen, umPlatz am Rand des Charts fu schaffen
	aNewVol.MinVec () = Vector3D (
		aNewVol.MinVec ().X () * 1.2,
		aNewVol.MinVec ().Y () * 1.2,
		aNewVol.MinVec ().Z ());
	aNewVol.MaxVec () = Vector3D (
		aNewVol.MaxVec ().X () * 1.2,
		aNewVol.MaxVec ().Y () * 1.2,
		aNewVol.MaxVec ().Z ());

	//pDoc->Position3DAxisTitles(GetLogicRect());

	SetRectsDirty(FALSE);
	return aNewVol;
}

/*************************************************************************
|*
|* Zuweisungsoperator
|*
\************************************************************************/

void ChartScene::operator=(const SdrObject& rObj)
{
	E3dScene::operator=(rObj);

	pDoc = ((const ChartScene&) rObj).pDoc;
}



/*************************************************************************
|*
|* Speichern
|*
\************************************************************************/

void ChartScene::WriteData(SvStream& rOut) const
{
	if (rOut.GetVersion() > 3780 && pSub && pSub->GetPage())
	{
		// FileFormat 5.0
		// Die SubList der ChartScene wird nun nicht mehr geschrieben

		//pSub->GetPage()->SetObjectsNotPersistent(TRUE);

		// Scene schreiben
		E3dPolyScene::WriteData(rOut);

		//pSub->GetPage()->SetObjectsNotPersistent(FALSE);
	}
	else
	{
		// FileFormat 4.0 und aelter
		E3dPolyScene::WriteData(rOut);
	}
}

/*************************************************************************
|*
|* Laden
|*
\************************************************************************/

void ChartScene::ReadData(const SdrObjIOHeader& rHead, SvStream& rIn)
{
	E3dPolyScene::ReadData(rHead, rIn);
}

/*************************************************************************
|*
|* Erstelle die 3D-Achsenbeschriftung  //war mal in globfunc.cxx
|*
\************************************************************************/

void ChartScene::InsertAllTitleText (DescrList         &rList,
									 E3dObject *pGroup,
									 long              nAxisId)
{
	Rectangle aOldRect;

	for (E3dLabelObj *pLabel = rList.First (); pLabel; pLabel = rList.Next ())
	{
		Insert3DObj(pLabel);
		pLabel->InsertUserData (new SchAxisId (nAxisId));
	}
}
Rectangle ChartScene::Get3DDescrRect(E3dLabelObj *p3DObj,B3dCamera& rCamSet )
{
	const SdrObject* pObj = p3DObj->Get2DLabelObj();
	// View- Abmessungen des Labels holen
	Rectangle  aRect = pObj->GetLogicRect();

	// Position des Objektes in Weltkoordinaten ermitteln
	Vector3D aObjPos = p3DObj->GetFullTransform() * p3DObj->GetPosition();
	aObjPos = rCamSet.WorldToViewCoor(aObjPos);
	Point aPoint((long)(aObjPos.X() + 0.5), (long)(aObjPos.Y() + 0.5));

	// Relative Position des Labels in View-Koordinaten
	Point aRelPosOne = pObj->GetRelativePos();
	aRelPosOne += aPoint;

	aRect.SetPos(aRelPosOne);
	return aRect;
}

void ChartScene::ReduceDescrList(DescrList & aList)
{

	Rectangle aIntersect(0,0,0,0);
	Rectangle aPrevRect(0,0,0,0);
	Rectangle aNextRect(0,0,0,0);

	//Transformation berechnen, die spter im Paint ausgefhrt wird,
	//(Derzeit sind die Labelobject-Positionen unbekannt)
	Rectangle aBound(GetSnapRect());
	Volume3D aVolume = FitInSnapRect();
	B3dCamera& rSet = GetCameraSet();
	rSet.SetDeviceRectangle(aVolume.MinVec().X(), aVolume.MaxVec().X(),
	aVolume.MinVec().Y(), aVolume.MaxVec().Y(), FALSE);
	rSet.SetFrontClippingPlane(aVolume.MinVec().Z());
	rSet.SetBackClippingPlane(aVolume.MaxVec().Z());
	rSet.SetViewportRectangle(aBound);


	E3dLabelObj *p3DObj=aList.First();
	E3dLabelObj *pOld3DObj=p3DObj;
	BOOL bGetCurrent=FALSE;

	if(p3DObj)
	{
		const SdrTextObj* pObj = (const SdrTextObj*)p3DObj->Get2DLabelObj();

		//Es reicht, die Rotation des ersten Elements zu ermitteln,
		//alle in der Liste sind gleichermaen gedreht
		//GetRotateAngle() gibt 100tel, gebraucht werden 10tel Grad.
		long nAngle = pObj->GetRotateAngle()/10;

		aPrevRect=Get3DDescrRect(p3DObj,rSet);
		if(nAngle!=0)
		{
			//Um TopLeft drehen, so wie es spter gezeichnet wird
			XPolygon aPoly(aPrevRect);
			aPoly.Rotate(aPrevRect.TopLeft(),(USHORT)nAngle);
			//und um den Koordinaten-Ursprung herum zurckdrehen
			//um wieder Rectangles zu erhalten (fr Intersect)
			aPoly.Rotate(Point(0,0),(USHORT)(3600 - nAngle));
			aPrevRect=aPoly.GetBoundRect();
		}

		while(p3DObj)
		{
			//nchstes Objekt holen, abhngig davon, ob das zuletzt behandelte
			//entfernt wurde oder nicht (bGetCurrent)
			if(bGetCurrent)
			{
				p3DObj=aList.GetCurObject();
			}
			else
			{
				p3DObj=aList.Next();
			}
			bGetCurrent=FALSE;

			//Da insbesondere bei Remove() des letzten Objects sowohl Next()
			//als auch GetCurObject() den alten Pointer zurckgeben,
			//wird getestet, ob tatschlich verschiedene Objekte vorliegen
			DBG_ASSERT(p3DObj!=pOld3DObj,"Chart: pointers equal in Scene:reduce...");
			if(p3DObj && p3DObj!=pOld3DObj)
			{
				pOld3DObj=p3DObj;

				aNextRect=Get3DDescrRect(p3DObj,rSet);

				if(nAngle!=0)
				{
					//Um TopLeft drehen (wie oben):
					XPolygon aPoly(aNextRect);
					aPoly.Rotate(aNextRect.TopLeft(),(USHORT)nAngle);
					//und um den Ursprung herum zurckdrehen
					aPoly.Rotate(Point(0,0),(USHORT)(3600 - nAngle));
					aNextRect=aPoly.GetBoundRect();
				}

				aIntersect=aNextRect.GetIntersection(aPrevRect);
				if( !  (aIntersect.IsEmpty())
					&& (   (aIntersect.GetHeight()>aNextRect.GetHeight()/100)
						 ||(aIntersect.GetWidth() >aNextRect.GetHeight()/100)//2% Deckung maximal bezogen auf die Fonthhe
						)
				  )
				{
					E3dObject* pParent=p3DObj->GetParentObj();
					if(pParent)
					{
						//aus der Page streichen
						pParent->Remove3DObj(p3DObj);


						//Die Objekte koennen ruhig in der Liste verbleiben, lschen fhrt
						//nur zu Problemen

						//Da das Object entfernt wurde, darf nicht Next gerufen werden.
						//bGetCurrent=TRUE;
						//und aus der Liste streichen
						//aList.Remove();
						//delete p3DObj; (st offenbar bei Remove() schon geschehen ???)
					}
					else
					{
						DBG_TRACE("Chart:: Object has no parent (Scene)");
					}
				}
				else
				{
					aPrevRect=aNextRect;
				}
			}
		}
	}

}

void ChartScene::Initialize()
{
	// #66930# BM  activate second light source and deactivate first one
    // reason: the first light source is in contrast to the other seven
    //         lightsources specular by default

    // Note: Use items at the scene instead of methods at the subobjects
    //       otherwise settings get overwritten later
    
    // copy lightsource 1 (Base3DLight0) to lightsource 2
    // color
	SetItem( Svx3DLightcolor2Item( GetLightGroup().GetIntensity( Base3DMaterialDiffuse, Base3DLight0 )));
    // direction
	SetItem( Svx3DLightDirection2Item( GetLightGroup().GetDirection( Base3DLight0 )));

    // enable light source 2
    SetItem( Svx3DLightOnOff2Item( TRUE ));
    // disable light source 1
    SetItem( Svx3DLightOnOff1Item( FALSE ));
}
