/*************************************************************************
 *
 *  $RCSfile: chtmode3.cxx,v $
 *
 *  $Revision: 1.22.2.2 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 13:10:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _XOUTX_HXX //autogen
#include <svx/xoutx.hxx>
#endif
#ifndef _SVX_TAB_LINE_HXX
#include <svx/tabline.hxx>
#endif
#ifndef _SVDOGRAF_HXX //autogen
#include <svx/svdograf.hxx>
#endif
#ifndef _E3D_POLYGON3D_HXX //autogen
#include <svx/polygn3d.hxx>
#endif
#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SVX_XLNWTIT_HXX //autogen
#include <svx/xlnwtit.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif
#ifndef _SVX_XBTMPIT_HXX //autogen
#include <svx/xbtmpit.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <svx/svdorect.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif

#ifndef _EEITEM_HXX //autogen
#include <svx/eeitem.hxx>
#endif
#ifndef _SVX_COLRITEM_HXX //autogen
#define ITEMID_COLOR       EE_CHAR_COLOR
#include <svx/colritem.hxx>
#endif
#ifndef _SVX_XFLGRIT_HXX
#include <svx/xflgrit.hxx>
#endif
#ifndef _SVX_XFLFTRIT_HXX
#include <svx/xflftrit.hxx>
#endif
#ifndef _SVX_XFLHTIT_HXX
#include <svx/xflhtit.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef _XTABLE_HXX
#include <svx/xtable.hxx>
#endif
#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#ifndef _SCH_MEMCHRT_HXX
#include "memchrt.hxx"
#endif

// header for SvxChartTextOrientItem
#ifndef _SVX_CHRTITEM_HXX
#define ITEMID_DOUBLE	        0
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#include <svx/chrtitem.hxx>
#endif
#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif
#define ITEMID_FONTHEIGHT  EE_CHAR_FONTHEIGHT
#include <svx/fhgtitem.hxx>
#ifndef _CHTMODEL_HXX
#include <chtmodel.hxx>
#include <globfunc.hxx>
#endif
#ifndef _SCH_OBJID_HXX
#include "objid.hxx"
#endif
#ifndef _SVX_SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _SCH_SCHRESID_HXX
#include "schresid.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif

#ifndef _SVX_XLNCLIT_HXX //autogen
#include <svx/xlnclit.hxx>
#endif

#ifndef _SVX_XFLCLIT_HXX //autogen
#include <svx/xflclit.hxx>
#endif

#include "schattr.hxx"
#ifndef _SVX_BRSHITEM_HXX //autogen
#define ITEMID_BRUSH SCHATTR_SYMBOL_BRUSH
#include <svx/brshitem.hxx>
#endif
#ifndef _SVX_SIZEITEM_HXX //autogen
#define ITEMID_SIZE 0
#include <svx/sizeitem.hxx>
#endif
// header for SAL_STATIC_CAST
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef	_OUTLOBJ_HXX
#include "svx/outlobj.hxx"
#endif

#include "glob.hrc"

#include "chtscene.hxx"
#include "pairs.hxx"

#include "chaxis.hxx"

/*************************************************************************
|*
|* Entscheidung, ob BuildChart notwendig
|*
\************************************************************************/
BOOL ChartModel::IsAttrChangeNeedsBuildChart(const SfxItemSet& rAttr)
{
	// BM #60999# rebuild for all EE_CHAR attributes because of possibly red color for negative numbers. sorry :-(
	return TRUE;

 /*
	BOOL bNeedBuild=FALSE;

	SfxWhichIter aWhichIter(rAttr);
	USHORT nWhich = aWhichIter.FirstWhich();
	while (nWhich != 0)
	{
	   if (rAttr.GetItemState(nWhich) == SFX_ITEM_SET)
	   {
		   if(nWhich < XATTR_LINE_FIRST  || nWhich > XATTR_FILL_LAST)
		   {

			   switch(nWhich)
			   {

			   case EE_CHAR_COLOR:
			   case EE_CHAR_UNDERLINE:
			   case EE_CHAR_STRIKEOUT:
				   break;

			   default:

				   bNeedBuild=TRUE;
				   break;
			   }
		   }
	   }
	   nWhich = aWhichIter.NextWhich();
	}
	return bNeedBuild;
*/
}

/*
	Set axis attributes.
	The attributes given by rAttr are set unconditionally to all axis,
	regardless of wether they are visible or not.
*/
void ChartModel::PutAxisAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
//	if( pChartXAxis->IsVisible() )
	{
		if( !bMerge )
			pChartXAxis->GetItemSet()->ClearItem();
		pChartXAxis->SetAttributes( rAttr );
	}
//	if( CanAxis( CHART_AXIS_SECONDARY_X ) && pChartAAxis->IsVisible() )
	{
		if( !bMerge )
			pChartAAxis->GetItemSet()->ClearItem();
		pChartAAxis->SetAttributes( rAttr );
	}

//	if( pChartYAxis->IsVisible() )
	{
		if( !bMerge )
			pChartYAxis->GetItemSet()->ClearItem();
		pChartYAxis->SetAttributes( rAttr );
	}
//	if( CanAxis( CHART_AXIS_SECONDARY_Y ) && pChartBAxis->IsVisible() )
	{
		if( !bMerge )
			pChartBAxis->GetItemSet()->ClearItem();
		pChartBAxis->SetAttributes( rAttr );
	}

//	if( Is3DChart() && pChartZAxis->IsVisible() )
	{
		if( !bMerge )
			pChartZAxis->GetItemSet()->ClearItem();
		pChartZAxis->SetAttributes( rAttr );
	}
}

/*************************************************************************
|*
|* Achsen-Attribute ermitteln
|*
\************************************************************************/

const SfxItemSet& ChartModel::GetAxisAttr(const SdrObjGroup* pAxisObj) const
{
	if (pAxisObj)
	{
		SchObjectId* pObjId = GetObjectId(*pAxisObj);

		if (pObjId)
		{
			long nId=GetObjectId(*pAxisObj)->GetObjId();
			switch (nId)
			{
				case CHOBJID_DIAGRAM_X_AXIS:
				case CHOBJID_DIAGRAM_Y_AXIS:
				case CHOBJID_DIAGRAM_Z_AXIS:
				case CHOBJID_DIAGRAM_A_AXIS:
				case CHOBJID_DIAGRAM_B_AXIS:
				case CHOBJID_DIAGRAM_C_AXIS:
					return GetAttr(nId);
/*				    return *pXAxisAttr;
					return *pYAxisAttr;
					return *pZAxisAttr;
*/
			}
		}
	}

	return *pAxisAttr;
}

/*************************************************************************
|*
|* Achsen-Attribute ermitteln
|*
\************************************************************************/
ChartAxis* ChartModel::GetAxis(long nId)
{
	switch(nId)
	{
		case CHOBJID_DIAGRAM_X_AXIS:
			return pChartXAxis;
		case CHOBJID_DIAGRAM_Y_AXIS:
			return pChartYAxis;
		case CHOBJID_DIAGRAM_Z_AXIS:
			return pChartZAxis;
		case CHOBJID_DIAGRAM_B_AXIS:
			return pChartBAxis;
		case CHOBJID_DIAGRAM_A_AXIS:
			return pChartAAxis;
	}
	DBG_ERROR("ChartModel::GetAxis() illegal argument (nId=CHOBJID_)");
	return pChartYAxis;
}



/*
	Get axis attributes.
	If pAxisObj is NULL then the intersection of the attributes of all five
	axes is taken, regardless of wether the axes are visible or not.
*/
SfxItemSet ChartModel::GetFullAxisAttr( const SdrObjGroup* pAxisObj, bool bOnlyInserted ) const
{
	if (pAxisObj)
	{
		SchObjectId* pObjId = GetObjectId(*pAxisObj);

		if (pObjId)
		{
			long nId=pObjId->GetObjId();

			SfxItemSet aAttr(*pItemPool,nAxisWhichPairs);
			aAttr.Put(GetAttr(nId));
			((ChartModel*)this)->GetAxis(nId)->GetMembersAsAttr(aAttr);
			return aAttr;
		}
	}
	else
	{
        // clear member item set for all axes
		pAxisAttr->ClearItem();
        bool bIsFirst = true;

        if( ! bOnlyInserted || HasAxis( CHOBJID_DIAGRAM_X_AXIS ))
            if( bIsFirst )
            {
                pAxisAttr->Set( GetAttr( CHOBJID_DIAGRAM_X_AXIS ));
                bIsFirst = false;
            }
            else
                IntersectSets( GetAttr( CHOBJID_DIAGRAM_X_AXIS ), *pAxisAttr );

        if( ! bOnlyInserted || HasAxis( CHOBJID_DIAGRAM_Y_AXIS ))
            if( bIsFirst )
            {
                pAxisAttr->Set( GetAttr( CHOBJID_DIAGRAM_Y_AXIS ));
                bIsFirst = false;
            }
            else
                IntersectSets( GetAttr( CHOBJID_DIAGRAM_Y_AXIS ), *pAxisAttr );

        if( ! bOnlyInserted || (Is3DChart() && HasAxis( CHOBJID_DIAGRAM_Z_AXIS )))
            if( bIsFirst )
            {
                pAxisAttr->Set( GetAttr( CHOBJID_DIAGRAM_Z_AXIS ));
                bIsFirst = false;
            }
            else
                IntersectSets( GetAttr( CHOBJID_DIAGRAM_Z_AXIS ), *pAxisAttr );

        if( ! bOnlyInserted || HasAxis( CHOBJID_DIAGRAM_A_AXIS ))
            if( bIsFirst )
            {
                pAxisAttr->Set( GetAttr( CHOBJID_DIAGRAM_A_AXIS ));
                bIsFirst = false;
            }
            else
                IntersectSets( GetAttr( CHOBJID_DIAGRAM_A_AXIS ), *pAxisAttr );

        if( ! bOnlyInserted || HasAxis( CHOBJID_DIAGRAM_B_AXIS ))
            if( bIsFirst )
            {
                pAxisAttr->Set( GetAttr( CHOBJID_DIAGRAM_B_AXIS ));
                bIsFirst = false;
            }
            else
                IntersectSets( GetAttr( CHOBJID_DIAGRAM_B_AXIS ), *pAxisAttr );
	}

    if( bOnlyInserted )
        pAxisAttr->ClearItem( SCHATTR_AXIS_SHOWDESCR );

	return *pAxisAttr;
}

/*************************************************************************
|*
|* Achsen-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

BOOL ChartModel::ChangeAxisAttr(const SfxItemSet &rAttr,SdrObjGroup *pAxisObj,BOOL bMerge)
{
	if (pAxisObj)
	{
		SchObjectId *pObjId = GetObjectId(*pAxisObj);

		if (! pObjId) return FALSE;
		else
		{
			SfxItemSet aSet(*pItemPool,nAxisWhichPairs);
			aSet.Put(rAttr);

			const SfxPoolItem *pPoolItem  = NULL;

			if(rAttr.GetItemState(SID_ATTR_NUMBERFORMAT_VALUE,TRUE,&pPoolItem)==SFX_ITEM_SET)
			{
				UINT32 nTmp=((const SfxUInt32Item*)pPoolItem)->GetValue();
				aSet.Put(SfxUInt32Item(IsPercentChart()
					? SCHATTR_AXIS_NUMFMTPERCENT : SCHATTR_AXIS_NUMFMT , nTmp));
			}

			long nId=pObjId->GetObjId();
			SetAttributes( nId, aSet, bMerge );             // at the model
			SetAxisAttributes( &GetAttr( nId ), pAxisObj ); // at the drawing object

            // at the axis itself!
            long nAxisUId = ChartAxis::GetUniqueIdByObjectId( nId );
            if( nAxisUId != CHAXIS_AXIS_UNKNOWN )
            {
                // this method always returns a valid pointer
                GetAxisByUID( nAxisUId )->SetAttributes( rAttr );
            }
            else
                DBG_ERROR( "ChartAxis not found for Object" );

			if(IsAttrChangeNeedsBuildChart(aSet))
			   BuildChart(FALSE,nId); //z.B. auch Texte skalieren!
			return TRUE;
		}
	}
	else
	{
		PutAxisAttr(rAttr,bMerge);
		return SetAllAxisAttributes ();
	}
}

/*************************************************************************
|*
|* Achsen-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

BOOL ChartModel::ChangeAxisAttr(const SfxItemSet& rXAxisAttr,
								const SfxItemSet& rYAxisAttr,
								const SfxItemSet& rZAxisAttr,
								BOOL              bMerge)
{
	SetAttributes(CHOBJID_DIAGRAM_X_AXIS,rXAxisAttr,bMerge);
	SetAttributes(CHOBJID_DIAGRAM_Y_AXIS,rYAxisAttr,bMerge);
	SetAttributes(CHOBJID_DIAGRAM_Z_AXIS,rZAxisAttr,bMerge);
	return SetAllAxisAttributes ();
}
/*************************************************************************
|*
|* Gitter-Attribute setzen
|*
\************************************************************************/

void ChartModel::PutGridAttr(const SfxItemSet& rAttr,BOOL bMerge)
{
	if(!bMerge)
	{
		pGridAttr->ClearItem();
		pXGridMainAttr->ClearItem();
		pYGridMainAttr->ClearItem();
		pZGridMainAttr->ClearItem();
		pXGridHelpAttr->ClearItem();
		pYGridHelpAttr->ClearItem();
		pZGridHelpAttr->ClearItem();
	}
	pGridAttr->Put(rAttr);
	pXGridMainAttr->Put(rAttr);
	pYGridMainAttr->Put(rAttr);
	pZGridMainAttr->Put(rAttr);
	pXGridHelpAttr->Put(rAttr);
	pYGridHelpAttr->Put(rAttr);
	pZGridHelpAttr->Put(rAttr);
}

/*************************************************************************
|*
|* Gitter-Attribute ermitteln
|*
\************************************************************************/

const SfxItemSet& ChartModel::GetGridAttr(const SdrObject* pGridObj) const
{
	if (pGridObj)
	{
		SchObjectId* pObjId = GetObjectId(*pGridObj);

		if (pObjId)
			switch (pObjId->GetObjId())
			{
				case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP:
					return *pXGridMainAttr;

				case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP:
					return *pYGridMainAttr;

				case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP:
					return *pZGridMainAttr;

				case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP:
					return *pXGridHelpAttr;

				case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP:
					return *pYGridHelpAttr;

				case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP:
					return *pZGridHelpAttr;
			}
	}
	else
	{
		pGridAttr->ClearItem();
		pGridAttr->Put(*pXGridMainAttr);

		CompareSets(*pYGridMainAttr, *pGridAttr);
		CompareSets(*pZGridMainAttr, *pGridAttr);
		CompareSets(*pXGridHelpAttr, *pGridAttr);
		CompareSets(*pYGridHelpAttr, *pGridAttr);
		CompareSets(*pZGridHelpAttr, *pGridAttr);
	}

	return *pGridAttr;
}

/*************************************************************************
|*
|* Diagramm-Gitter-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

BOOL ChartModel::ChangeGridAttr(const SfxItemSet& rAttr,
								SdrObject* pGridObj, BOOL bMerge)
{
	if (pGridObj)
	{
		SchObjectId* pObjId = GetObjectId(*pGridObj);

		if (pObjId)	switch (pObjId->GetObjId())
					{
						case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP:
							PutXGridMainAttr(rAttr,bMerge);

//-/							pGridObj->SetAttributes(*pXGridMainAttr, FALSE);
							pGridObj->SetItemSetAndBroadcast(*pXGridMainAttr);
							break;

						case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP:
							PutYGridMainAttr(rAttr,bMerge);

//-/							pGridObj->SetAttributes(*pYGridMainAttr, FALSE);
							pGridObj->SetItemSetAndBroadcast(*pYGridMainAttr);
							break;

						case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP:
							PutZGridMainAttr(rAttr,bMerge);

//-/							pGridObj->SetAttributes(*pZGridMainAttr, FALSE);
							pGridObj->SetItemSetAndBroadcast(*pZGridMainAttr);
							break;

						case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP:
							PutXGridHelpAttr(rAttr,bMerge);

//-/							pGridObj->SetAttributes(*pXGridHelpAttr, FALSE);
							pGridObj->SetItemSetAndBroadcast(*pXGridHelpAttr);
							break;

						case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP:
							PutYGridHelpAttr(rAttr,bMerge);

//-/							pGridObj->SetAttributes(*pYGridHelpAttr, FALSE);
							pGridObj->SetItemSetAndBroadcast(*pYGridHelpAttr);
							break;

						case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP:
							PutZGridHelpAttr(rAttr,bMerge);

//-/							pGridObj->SetAttributes(*pZGridHelpAttr, FALSE);
							pGridObj->SetItemSetAndBroadcast(*pZGridHelpAttr);
							break;
					}
	}
	else
	{
		PutGridAttr(rAttr,bMerge);

		SdrPage* pPage = GetPage(0);

		if (pPage)
		{
			SdrObjGroup* pGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *pPage);
			DBG_ASSERT(pGroup, "ChartModel::ChangeGridAttr: diagram group not found");

			SdrObjGroup* pGridGroup;

			if (bShowXGridMain)
			{
				pGridGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP,
														*pGroup->GetSubList());

				if (pGridGroup)
				{
					SdrObjListIter aIterator(*pGridGroup->GetSubList(), IM_FLAT);
					while (aIterator.IsMore())
//-/						aIterator.Next()->SetAttributes(*pXGridMainAttr, FALSE);
						aIterator.Next()->SetItemSetAndBroadcast(*pXGridMainAttr);
				}
			}

			if (bShowYGridMain)
			{
				pGridGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP,
														*pGroup->GetSubList());

				if (pGridGroup)
				{
					SdrObjListIter aIterator(*pGridGroup->GetSubList(), IM_FLAT);
					while (aIterator.IsMore())
//-/						aIterator.Next()->SetAttributes(*pYGridMainAttr, FALSE);
						aIterator.Next()->SetItemSetAndBroadcast(*pYGridMainAttr);
				}
			}

			if (bShowXGridHelp)
			{
				pGridGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM_X_GRID_HELP_GROUP,
														*pGroup->GetSubList());

				if (pGridGroup)
				{
					SdrObjListIter aIterator(*pGridGroup->GetSubList(), IM_FLAT);
					while (aIterator.IsMore())
//-/						aIterator.Next()->SetAttributes(*pXGridHelpAttr, FALSE);
						aIterator.Next()->SetItemSetAndBroadcast(*pXGridHelpAttr);
				}
			}

			if (bShowYGridHelp)
			{
				pGridGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP,
														*pGroup->GetSubList());
				if (pGridGroup)
				{
					SdrObjListIter aIterator(*pGridGroup->GetSubList(), IM_FLAT);
					while (aIterator.IsMore())
//-/						aIterator.Next()->SetAttributes(*pYGridHelpAttr, FALSE);
						aIterator.Next()->SetItemSetAndBroadcast(*pYGridHelpAttr);
				}
			}

			if (Is3DChart())
			{
				if (bShowZGridMain)
				{
					pGridGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP,
															*pGroup->GetSubList());

					if (pGridGroup)
					{
						SdrObjListIter aIterator(*pGridGroup->GetSubList(), IM_FLAT);
						while (aIterator.IsMore())
//-/							aIterator.Next()->SetAttributes(*pZGridMainAttr, FALSE);
							aIterator.Next()->SetItemSetAndBroadcast(*pZGridMainAttr);
					}
				}

				if (bShowZGridHelp)
				{
					pGridGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP,
															*pGroup->GetSubList());
					if (pGridGroup)
					{
						SdrObjListIter aIterator(*pGridGroup->GetSubList(), IM_FLAT);
						while (aIterator.IsMore())
//-/							aIterator.Next()->SetAttributes(*pZGridHelpAttr, FALSE);
							aIterator.Next()->SetItemSetAndBroadcast(*pZGridHelpAttr);
					}
				}
			}
		}
	}

	if(IsAttrChangeNeedsBuildChart(rAttr))
		BuildChart (FALSE);

	return TRUE;
}

/*************************************************************************
|*
|* Diagrammflaechen-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

void ChartModel::ChangeDiagramAreaAttr(const SfxItemSet& rAttr,
									   SdrRectObj* pDiagramAreaObj,
									   BOOL bMerge)
{
	if (!pDiagramAreaObj)
	{
		SdrPage* pPage = GetPage(0);
		DBG_ASSERT( pPage, "ChartModel::ChangeDiagramAreaAttr: page obj is NULL" );

		pDiagramAreaObj = (SdrRectObj*)GetObjWithId(CHOBJID_DIAGRAM_AREA, *pPage);
		DBG_ASSERT( pDiagramAreaObj, "ChartModel::ChangeDiagramAreaAttr: empty diagram obj");
	}

	PutDiagramAreaAttr(rAttr,bMerge);

//-/	pDiagramAreaObj->SetAttributes(rAttr, FALSE);
	pDiagramAreaObj->SetItemSetAndBroadcast(rAttr);

	if(IsDonutChart())
	   if(IsAttrChangeNeedsBuildChart(rAttr))
			BuildChart (FALSE);
}

/*************************************************************************
|*
|* Diagrammwaende-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

void ChartModel::ChangeDiagramWallAttr(const SfxItemSet& rAttr,
									   SdrObject* pDiagramWallObj,
									   BOOL bMerge)
{
	if (!pDiagramWallObj)
	{
		SdrPage* pPage = GetPage(0);
		DBG_ASSERT( pPage, "ChartModel::ChangeDiagramWallAttr: page obj is NULL" );

		SdrObjGroup* pGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *pPage);
		DBG_ASSERT( pGroup, "ChartModel::ChangeDiagramAreaAttr: empty diagram group obj");

		pDiagramWallObj = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM_WALL,
													 *pGroup->GetSubList());
		DBG_ASSERT( pDiagramWallObj, "ChartModel::ChangeDiagramWallAttr: diagram wall obj is NULL" );
	}

	PutDiagramWallAttr(rAttr,bMerge);

	if (pDiagramWallObj->ISA(SdrObjGroup))
	{
		if (((SdrObjGroup*)pDiagramWallObj)->GetSubList())
		{
			SdrObjListIter aIterator(*((SdrObjGroup*)pDiagramWallObj)->GetSubList(), IM_FLAT);
			while (aIterator.IsMore())
//-/				aIterator.Next()->SetAttributes(*pDiagramWallAttr, FALSE);
				aIterator.Next()->SetItemSetAndBroadcast(*pDiagramWallAttr);
		}
//-/		else pDiagramWallObj->SetAttributes(*pDiagramWallAttr, FALSE);
		else pDiagramWallObj->SetItemSetAndBroadcast(*pDiagramWallAttr);
	}
//-/	else pDiagramWallObj->SetAttributes(*pDiagramWallAttr, FALSE);
	else pDiagramWallObj->SetItemSetAndBroadcast(*pDiagramWallAttr);

	if(IsAttrChangeNeedsBuildChart(rAttr))
		BuildChart (FALSE);
	else if(Is3DChart())
	{
		SdrPage* pPage = GetPage(0);
		DBG_ASSERT(pPage, "ChartModel::ChangeDiagramWallAttr: No page available");
		SdrObjGroup* pGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *pPage);
		DBG_ASSERT(pGroup, "ChartModel::ChangeDiagramWallAttr: diagram group not found");
		SetAttrWithId(CHOBJID_DIAGRAM_WALL,*pGroup->GetSubList(),rAttr);
	}
}

/*************************************************************************
|*
|* Diagrammboden-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/

void ChartModel::ChangeDiagramFloorAttr(const SfxItemSet& rAttr,
										E3dExtrudeObj* pDiagramFloorObj,
										BOOL bMerge)
{
	if (!pDiagramFloorObj)
	{
		SdrPage* pPage = GetPage(0);
		DBG_ASSERT(pPage, "ChartModel::ChangeDiagramFloorAttr: No page available");

		SdrObjGroup* pGroup = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *pPage);
		DBG_ASSERT(pGroup, "ChartModel::ChangeDiagramFloorAttr: diagram group not found");

		pDiagramFloorObj = SAL_STATIC_CAST( E3dExtrudeObj*, GetObjWithId( CHOBJID_DIAGRAM_FLOOR,
																		 *pGroup->GetSubList()) );
		DBG_ASSERT(pDiagramFloorObj, "ChartModel::ChangeDiagramFloorAttr: floor not found");
		if(!pDiagramFloorObj)
			return;
	}

	PutDiagramFloorAttr(rAttr,bMerge);

//-/	pDiagramFloorObj->SetAttributes(*pDiagramFloorAttr, FALSE);
	pDiagramFloorObj->SetItemSetAndBroadcast(*pDiagramFloorAttr);

	if(IsAttrChangeNeedsBuildChart(rAttr))
		BuildChart (FALSE);
}

/*************************************************************************
|*
|* Datenreihen-Attribute setzen
|*
\************************************************************************/
void ChartModel::PutDataRowAttrAll(const SfxItemSet& rAttr,BOOL bMerge,BOOL bClearPoints)
{
	long nCnt=aDataRowAttrList.Count();
	while(nCnt--)
		PutDataRowAttr(nCnt,rAttr,bMerge,bClearPoints);
}

void ChartModel::PutDataRowAttr(long nRow, const SfxItemSet& rAttr,BOOL bMerge,BOOL bClearPoints)
{

	CHART_TRACE1( "ChartModel::PutDataRowAttr %smerge", bMerge? "": "NO " );
//	DBG_ITEMS((SfxItemSet&)rAttr,this);

    if( aDataRowAttrList.Count() <= (unsigned long)nRow )
    {
        DBG_ERROR( "Invalid index to array requested" );
        return;
    }

    if(!bMerge)
		aDataRowAttrList.GetObject(nRow)->ClearItem();

	PutItemSetWithNameCreation( *aDataRowAttrList.GetObject( nRow ), rAttr );

	if(bClearPoints && (nRow < GetRowCount()))
	{
		long nCol,nColCnt=GetColCount();
		for(nCol=0;nCol<nColCnt;nCol++)
		{
			ClearDataPointAttr(nCol,nRow,rAttr);
		}
	}
}
/*************************************************************************
|*
|* Datenreihen-Attribute ermitteln
|*
\************************************************************************/

const SfxItemSet& ChartModel::GetDataRowAttr( long nRow ) const
{
	if( nRow < (long)aDataRowAttrList.Count() )
	{
		SfxItemSet* pSet = aDataRowAttrList.GetObject( nRow );
		DBG_ASSERT( pSet, "Invalid ItemSet" );
		return *pSet;
	}
	else
	{
		DBG_ERROR( "Requested data row attribute is unavailable" );

		// return something
		DBG_ASSERT( pChartAttr, "Invalid Chart-ItemSet" );
		return *pChartAttr;
	}
}

/*************************************************************************
|*
|* SubRoutinen ChangeDataPointAttr, Legendenattributierung
|*
\************************************************************************/
void ChartModel::ChangeLegendPointAttr(const long nDataCol,const SfxItemSet& rDataPointAttr)
{
	CHART_TRACE( "ChartModel::ChangeLegendPointAttr" );

	SfxItemSet aSymbolAttr(rDataPointAttr); //#54870#
	GenerateSymbolAttr(aSymbolAttr,0,SYMBOLMODE_LEGEND); //Achtung! 0 ist die Datenreihe (immer=0 bei Datenpunkt-Legende=Pie), das kann sich aber mal ndern!

	const SdrPage* pPage=GetPage(0);
	SdrObjGroup* pLegendObj = (SdrObjGroup*)GetObjWithId(CHOBJID_LEGEND, *pPage);
	DBG_ASSERT(pLegendObj, "ChartModel::ChangeLegendPointAttr:Legenden-Objekt nicht gefunden!");

	SdrObjListIter aIterator(*pLegendObj->GetSubList(), IM_FLAT);
	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchObjectId* pId = GetObjectId(*pObj);

		if (pId && (pId->GetObjId() == CHOBJID_LEGEND_SYMBOL_COL))
		{
			SchDataPoint* pSymPoint = GetDataPoint(*pObj);
			DBG_ASSERT(pSymPoint, "ChartModel::ChangeLegendPointAttr:Legenden-Symbol hat keine Datenpunkt-Information!")
			if (pSymPoint->GetCol() == nDataCol && pSymPoint->GetRow() == 0)
			{
//-/				pObj->SetAttributes(aSymbolAttr, FALSE);
				pObj->SetItemSetAndBroadcast(aSymbolAttr);

				DBG_ITEMS(aSymbolAttr,this);
				break;
			}
		}
	}
}
/*************************************************************************
|*
|* SubRoutine ChangeDataRowAttr, Legendenattributierung
|*
\************************************************************************/
void ChartModel::ChangeLegendRowAttr(const long nDataRow,const SfxItemSet& rDataRowAttr)
{
	CHART_TRACE( "ChartModel::ChangeLegendRowAttr" );

	//Attributsets fr die Symbole fllen:
	SfxItemSet aSymbolAttr(rDataRowAttr); //#54870#
	GenerateSymbolAttr(aSymbolAttr,nDataRow,SYMBOLMODE_LEGEND);

	SdrPage* pPage=GetPage(0);
	SdrObjGroup* pLegendObj =(SdrObjGroup*)GetObjWithId(CHOBJID_LEGEND, *pPage);
	DBG_ASSERT(pLegendObj, "ChartModel::ChangeLegendRowAttr:Legenden-Objekt nicht gefunden!");

	SdrObjListIter aIterator(*pLegendObj->GetSubList(), IM_FLAT);
	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchObjectId* pId = GetObjectId(*pObj);

		if (pId && (pId->GetObjId() == CHOBJID_LEGEND_SYMBOL_ROW))
		{
			SchDataRow* pSymRow = GetDataRow(*pObj);
			if (pSymRow && pSymRow->GetRow() == nDataRow)
			{
//-/				pObj->SetAttributes(aSymbolAttr, FALSE);
				pObj->SetItemSetAndBroadcast(aSymbolAttr);

				DBG_ITEMS(aSymbolAttr,this);
				break;
			}
		}
	}
}

/*************************************************************************
|*
|* ChangeDataRow-Submethode: Attributiere CHOBJID_DIAGRAM_DESCR_SYMBOL
|*
\************************************************************************/

void ChartModel::ChangeRowDescrSymbolAttr(const long nDataRow,const SfxItemSet& rDataRowAttr)
{
	CHART_TRACE( "ChartModel::ChangeRowDescrSymbolAttr" );

	//Attributsets fr die Symbole fllen:
	SfxItemSet aSymbolAttr(rDataRowAttr); //#54870#
	GenerateSymbolAttr(aSymbolAttr,nDataRow,SYMBOLMODE_DESCRIPTION);

	SdrObjGroup* pDiagramObj
					= (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *GetPage(0));
	DBG_ASSERT(pDiagramObj, "ChartModel::ChangeRowDescrSymbolAttr:Diagramm-Objekt nicht gefunden!");

	BOOL bBreak = FALSE;

	SdrObjListIter aIter1(*pDiagramObj->GetSubList(), IM_FLAT);
	while (!bBreak && aIter1.IsMore())
	{
		SdrObject* pObj1 = aIter1.Next();

		if (pObj1)
		{
			SchObjectId* pId1 = GetObjectId(*pObj1);

			if (pId1)
				if (pId1->GetObjId() == CHOBJID_DIAGRAM_DESCRGROUP)
				{
					SdrObjListIter aIter2(*((SdrObjGroup*)pObj1)->GetSubList(),
										  IM_FLAT);
					while (aIter2.IsMore())
					{
						SdrObject* pObj2 = aIter2.Next();
						SchObjectId* pId2 = GetObjectId(*pObj2);

						//#54870# auch _COL attributiert werden, BuildChart tut es schliesslich auch!
						if (pId2
							&& ((pId2->GetObjId() == CHOBJID_DIAGRAM_DESCR_ROW)
							 || (pId2->GetObjId() == CHOBJID_DIAGRAM_DESCR_COL) )
							&& pObj2->ISA(SdrObjGroup))
						{
							SchDataRow*   pSymRow  = GetDataRow(*pObj2);
							SchDataPoint* pSymPoint= GetDataPoint(*pObj2);
							if( pSymRow || pSymPoint )
							{
								long nRow;
								if(pSymRow)
									nRow=pSymRow->GetRow();
								else
									nRow=pSymPoint->GetRow();

								if (nRow == nDataRow)
								{
									SdrObjListIter aIter3
										(*((SdrObjGroup*)pObj2)->GetSubList(),
										 IM_FLAT);
									while (aIter3.IsMore())
									{
										SdrObject* pObj3 = aIter3.Next();
										SchObjectId* pId3 = GetObjectId(*pObj3);

										if (pId3 &&
											(pId3->GetObjId() == CHOBJID_DIAGRAM_DESCR_SYMBOL))
										{
//-/											pObj3->SetAttributes(aSymbolAttr,FALSE);
											pObj3->SetItemSetAndBroadcast(aSymbolAttr);
											break;
										}
									}
									bBreak = TRUE;
								}
							}
						}
					}
				}
		}
	}
}

/*************************************************************************
|*
|* ChangeDataRow-Submethode: GetDataRowObj
|*
\************************************************************************/
SdrObject* ChartModel::CDRAGetDataRowObj(const long nDataRow)
{
	SdrObject* pRetObj = NULL;
	SdrObjGroup* pDiagramObj = (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *GetPage(0));
	DBG_ASSERT(pDiagramObj, "ChartModel::CDRAGetDataRowObj:Diagramm-Objekt nicht gefunden!");

	SdrObjListIter aIterator(*pDiagramObj->GetSubList(), IM_FLAT);
	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchObjectId* pId = GetObjectId(*pObj);

		if (pId)
		{
			UINT16 nId = pId->GetObjId();
			if (nId == CHOBJID_DIAGRAM_ROWGROUP || nId == CHOBJID_DIAGRAM_ROWS)
			{
				if (GetDataRow(*pObj)->GetRow() == nDataRow)
				{
					pRetObj = pObj;
					break;
				}
			}
			else if(nId==CHOBJID_DIAGRAM_STACKEDGROUP)
			{
				SdrObjListIter aIterator(*pObj->GetSubList(), IM_FLAT);
				while (aIterator.IsMore())
				{
					SdrObject* pObj = aIterator.Next();
					SchObjectId* pId = GetObjectId(*pObj);

					if (pId)
					{
						UINT16 nId = pId->GetObjId();
						if (nId == CHOBJID_DIAGRAM_SPECIAL_GROUP)
							if (GetDataRow(*pObj)->GetRow() == nDataRow)
							{
								pRetObj = pObj;
								break;
							}
					}
				}
			}
		}
	}

	return pRetObj;
}

/*************************************************************************
|*
|* SubRoutine ChangeDataRowAttr, Attributiere Elemente
|*
\************************************************************************/
void ChartModel::CDRAAttrGroup(SdrObject* pDataRowObj,const long nDataRow
							   ,const SfxItemSet& rDataRowAttr)
{

	BOOL bRepaint=FALSE;

	SdrObjListIter aIterator(*((SdrObjGroup*)pDataRowObj)->
								GetSubList(), IM_FLAT);
	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchObjectId* pId = GetObjectId(*pObj);

		if (pId)
		{

			switch (pId->GetObjId())
			{
			case CHOBJID_DIAGRAM_DATA:
				{
					bRepaint=TRUE;
					if( HasSymbols(nDataRow) )
					{
						SfxItemSet aSymbolAttr(rDataRowAttr);
						GenerateSymbolAttr(aSymbolAttr,nDataRow,SYMBOLMODE_ROW);
//-/						pObj->SetAttributes(aSymbolAttr, FALSE);
						pObj->SetItemSetAndBroadcast(aSymbolAttr);
					}
					else
					{
//-/						pObj->SetAttributes(rDataRowAttr, FALSE);
						pObj->SetItemSetAndBroadcast(rDataRowAttr);
					}
				}
				break;


			case CHOBJID_LINE:
			case CHOBJID_AREA:
			case CHOBJID_DIAGRAM_ROWSLINE:
			case CHOBJID_DIAGRAM_ROWS:
				bRepaint=TRUE;
//-/				pObj->SetAttributes(rDataRowAttr,FALSE);
				pObj->SetItemSetAndBroadcast(rDataRowAttr);
				break;


			}
		}
	}
//	if(bRepaint)
//		pScene->SendRepaintBroadcast();

}
/*************************************************************************
|*
|* Erstelle Symbole fuer Diagrammtypen mit Symbolen
|*
\************************************************************************/

SdrObject* ChartModel::CreateSymbol (Point      aPoint,
									 int        nRow,
									 int        nColumn,
									 SfxItemSet &aDataAttr,
									 long       nSymbolSize,
									 BOOL       bInsert)
{
	long nWhatSymbol=SVX_SYMBOLTYPE_AUTO;
	SdrObject* pObj=NULL;
	long nHalfSymbolSizeX = nSymbolSize / 4;
	long nHalfSymbolSizeY = nSymbolSize / 4;
	Size aSize(1,1);
	long n1Pixel=pRefOutDev ? pRefOutDev->PixelToLogic(aSize).Width() : nHalfSymbolSizeY/2;

	if(!bInsert)
		n1Pixel=nHalfSymbolSizeY/2; //fr Legende vergrern

	const SfxPoolItem* pPoolItem;
	if(aDataAttr.GetItemState(SCHATTR_STYLE_SYMBOL, TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		nWhatSymbol = ((const SfxInt32Item*) pPoolItem)->GetValue();
	}
	if(nWhatSymbol<0)
	{
		BOOL bStock=FALSE;
		switch(nWhatSymbol)
		{
			case SVX_SYMBOLTYPE_NONE:
			{
				//	Create a square as symbol.  Its fill and line style is 
				//	later to invisible.  This does not show the symbol but 
				//	leaves the data point selectable.
				XPolygon aPolygon (5);
				aPolygon[0].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[0].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[1].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[1].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[2].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[2].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[3].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[3].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[4].X() = aPolygon[0].X();
				aPolygon[4].Y() = aPolygon[0].Y();
				pObj = new SdrPathObj(OBJ_POLY, XPolyPolygon(aPolygon));
				break;
			}
			case SVX_SYMBOLTYPE_UNKNOWN:
			case SVX_SYMBOLTYPE_AUTO:
				CHART_TRACE( "creating SVX_SYMBOLTYPE_AUTO" );


				switch(eChartStyle)
				{
						default:
						break;
						case CHSTYLE_2D_STOCK_2:
						case CHSTYLE_2D_STOCK_4:
							bStock=TRUE;
							nHalfSymbolSizeX=n1Pixel;
							break;
						case CHSTYLE_2D_STOCK_1:
							bStock=TRUE;
							if(nRow!=2)
								nHalfSymbolSizeX=n1Pixel;
							break;
						case CHSTYLE_2D_STOCK_3:
							bStock=TRUE;
							if(nRow!=3)
								nHalfSymbolSizeX=n1Pixel;
							break;
				}
				if(bStock)
				{
					XPolygon aPolygon(2);

					aPolygon[0].X() = aPoint.X();
					aPolygon[0].Y() = aPoint.Y();
					aPolygon[1].X() = aPoint.X() + nHalfSymbolSizeX;
					aPolygon[1].Y() = aPoint.Y();
					pObj = new SdrPathObj(OBJ_POLY, XPolyPolygon(aPolygon));
					break;
				}
				nWhatSymbol=nRow;
				aDataAttr.ClearItem(SCHATTR_SYMBOL_BRUSH);//Gre gegebenenfalls lschen
				aDataAttr.ClearItem(SCHATTR_SYMBOL_SIZE);//Gre gegebenenfalls lschen
				break;

			case SVX_SYMBOLTYPE_BRUSHITEM:
			{
				if(aDataAttr.GetItemState(SCHATTR_SYMBOL_BRUSH,TRUE,&pPoolItem)==SFX_ITEM_SET)
				{
					CHART_TRACE( "creating SVX_SYMBOLTYPE_BRUSHITEM" );
					const Graphic*  pGraphic = ((const SvxBrushItem *)pPoolItem)->GetGraphic();
					Size	    	aSize;

					if( pGraphic )
					{
						if(!pObj && aDataAttr.GetItemState(SCHATTR_SYMBOL_SIZE,TRUE,&pPoolItem)==SFX_ITEM_SET)
						{
							CHART_TRACE( "Size by Item" );
							aSize=((const SvxSizeItem*)pPoolItem)->GetSize();
						}
						else
						{
							CHART_TRACE( "Size by Graphic" );
							if( pGraphic )
								aSize = ( OutputDevice::LogicToLogic( pGraphic->GetPrefSize(),
																	  pGraphic->GetPrefMapMode(),
																	  MAP_100TH_MM ));
						}

						Rectangle	aRect(aPoint.X()-aSize.Width()/2,aPoint.Y()-aSize.Height()/2
										  ,aPoint.X()+aSize.Width()/2,aPoint.Y()+aSize.Height()/2);
						pObj	  = new SdrGrafObj(*pGraphic);
						GetPage(0)->NbcInsertObject(pObj,0);
						pObj->NbcSetSnapRect(aRect);
						GetPage(0)->RemoveObject(0);
					}
				}
				else
				{
					CHART_TRACE( "failed in SVX_SYMBOLTYPE_BRUSHITEM" );
					nWhatSymbol=nRow;
				}
			}
			break;
		}
	}
	else
	{
		CHART_TRACE1( "creating SVX_SYMBOLTYPE = %d", nWhatSymbol );
	}


	if(!pObj && aDataAttr.GetItemState(SCHATTR_SYMBOL_SIZE,TRUE,&pPoolItem)==SFX_ITEM_SET)
	{
		Size aSize=((const SvxSizeItem*)pPoolItem)->GetSize();
		nHalfSymbolSizeX = aSize.Width() / 2;
		nHalfSymbolSizeY = aSize.Height() / 2;
		CHART_TRACE2( "reading SCHATTR_SYMBOL_SIZE -> Size = (%ld, %ld)", aSize.Width(), aSize.Height() );
	}

	if(!pObj) //dann default generieren
	{
		switch (nWhatSymbol % 8)
		{
			case 0 :
			{
				XPolygon aPolygon (5);

				aPolygon[0].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[0].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[1].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[1].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[2].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[2].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[3].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[3].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[4].X() = aPolygon[0].X();
				aPolygon[4].Y() = aPolygon[0].Y();

				pObj = new SdrPathObj(OBJ_POLY, XPolyPolygon(aPolygon));
				break;
			}

			case 1 :
			{
				XPolygon aPolygon (5);

				aPolygon[0].X() = aPoint.X();
				aPolygon[0].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[1].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[1].Y() = aPoint.Y();
				aPolygon[2].X() = aPoint.X();
				aPolygon[2].Y() = aPoint.Y() + nHalfSymbolSizeY;;
				aPolygon[3].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[3].Y() = aPoint.Y();
				aPolygon[4].X() = aPolygon[0].X();
				aPolygon[4].Y() = aPolygon[0].Y();

				pObj = new SdrPathObj(OBJ_POLY, XPolyPolygon(aPolygon));
				break;
			}

			case 2 :
			{
				XPolygon aPolygon (4);

				aPolygon[0].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[0].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[1].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[1].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[2].X() = aPoint.X();
				aPolygon[2].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[3].X() = aPolygon[0].X();
				aPolygon[3].Y() = aPolygon[0].Y();

				pObj = new SdrPathObj(OBJ_POLY, XPolyPolygon(aPolygon));
				break;
			}

			case 3 :
			{
				XPolygon aPolygon (4);

				aPolygon[0].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[0].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[1].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[1].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[2].X() = aPoint.X();
				aPolygon[2].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[3].X() = aPolygon[0].X();
				aPolygon[3].Y() = aPolygon[0].Y();

				pObj = new SdrPathObj(OBJ_POLY, XPolyPolygon(aPolygon));
				break;
			}

			case 4 :
			{
				XPolygon aPolygon (4);

				aPolygon[0].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[0].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[1].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[1].Y() = aPoint.Y();
				aPolygon[2].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[2].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[3].X() = aPolygon[0].X();
				aPolygon[3].Y() = aPolygon[0].Y();

				pObj = new SdrPathObj(OBJ_POLY, XPolyPolygon(aPolygon));
				break;
			}

			case 5 :
			{
				XPolygon aPolygon (4);

				aPolygon[0].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[0].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[1].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[1].Y() = aPoint.Y();
				aPolygon[2].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[2].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[3].X() = aPolygon[0].X();
				aPolygon[3].Y() = aPolygon[0].Y();

				pObj = new SdrPathObj(OBJ_POLY, XPolyPolygon(aPolygon));
				break;
			}

			case 6 :
			{
				XPolygon aPolygon (5);

				aPolygon[0].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[0].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[1].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[1].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[2].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[2].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[3].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[3].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[4].X() = aPolygon[0].X();
				aPolygon[4].Y() = aPolygon[0].Y();

				pObj = new SdrPathObj(OBJ_POLY, XPolyPolygon(aPolygon));
				break;
			}

			case 7 :
			{
				XPolygon aPolygon (5);

				aPolygon[0].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[0].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[1].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[1].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[2].X() = aPoint.X() - nHalfSymbolSizeX;
				aPolygon[2].Y() = aPoint.Y() + nHalfSymbolSizeY;
				aPolygon[3].X() = aPoint.X() + nHalfSymbolSizeX;
				aPolygon[3].Y() = aPoint.Y() - nHalfSymbolSizeY;
				aPolygon[4].X() = aPolygon[0].X();
				aPolygon[4].Y() = aPolygon[0].Y();

				pObj = new SdrPathObj(OBJ_POLY, XPolyPolygon(aPolygon));
				break;
			}

		}
	}

	if (bInsert)  //nur in CreateLegend FALSE!
	{
		SfxItemSet aSymbolAttr(aDataAttr);
		GenerateSymbolAttr(aSymbolAttr,nRow,SYMBOLMODE_ROW);
		if (nWhatSymbol == SVX_SYMBOLTYPE_NONE)
		{
			//	Dont show the symbol.  It is only needed for selection of the
			//	data point.
			aSymbolAttr.Put(XFillStyleItem (XFILL_NONE));
			aSymbolAttr.Put(XLineStyleItem (XLINE_NONE));
		}
		pObj->SetModel( this );
		pObj = SetObjectAttr (pObj, CHOBJID_DIAGRAM_DATA, TRUE, TRUE, &aSymbolAttr);
		pObj->InsertUserData(new SchDataPoint(nColumn, nRow));
		
	}

	return pObj;
}

void ChartModel::GenerateSymbolAttr(/*const SfxItemSet& rAttr,*/SfxItemSet& rSymbolAttr,const long nRow,const long nMode)
{
	// Symbole immer gleiche Umrandung und Fllfarbe = Linienfarbe, wenn es sich um ein "echtes"
	// Symbol handelt (d.h. nicht ein Symbol fr Bars/Sulen,Pies etc.)

	switch(nMode)
	{
		case SYMBOLMODE_LEGEND:
		case SYMBOLMODE_ROW:

			if(HasSymbols(nRow) && IsLine(nRow)) //Symbol und Linie => ein echtes Symbol wird angezeigt :)
			{
				rSymbolAttr.Put(XFillColorItem(String(),
											   ((XLineColorItem &)rSymbolAttr.Get(XATTR_LINECOLOR)).GetValue()));

				rSymbolAttr.Put(XLineStyleItem(XLINE_SOLID));
				rSymbolAttr.Put(XLineColorItem(String(),RGBColor(COL_BLACK)));
				rSymbolAttr.Put(XLineWidthItem (0));

			}
			break;

		case SYMBOLMODE_DESCRIPTION:
			if(IsLine(nRow))
			{
				rSymbolAttr.Put(XFillColorItem(String(),
											   ((XLineColorItem &)rSymbolAttr.Get(XATTR_LINECOLOR)).GetValue()));

				rSymbolAttr.Put(XLineStyleItem(XLINE_SOLID));
				rSymbolAttr.Put(XLineColorItem(String(),RGBColor(COL_BLACK)));
				rSymbolAttr.Put(XLineWidthItem (0));
			}
			else		// rectangle with border, if linesytle is NONE
			{
				XLineStyle eLineStyle =
					SAL_STATIC_CAST( const XLineStyleItem *, &(rSymbolAttr.Get( XATTR_LINESTYLE )) )->GetValue(); // bug in Win-C++ compiler: casting to pointer

				if( eLineStyle == XLINE_NONE )			  // clear items for defaults to take effect
				{
					rSymbolAttr.ClearItem( XATTR_LINESTYLE );
					rSymbolAttr.ClearItem( XATTR_LINEWIDTH );
					rSymbolAttr.ClearItem( XATTR_LINECOLOR );
				}
			}

			break;
		case SYMBOLMODE_LINE:
			break;
	}

}

/*************************************************************************
|*
|* Datenreihen-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/
//#54870# gravierende nderung, notfalls mit BuildChart abschliessen!
BOOL ChartModel::ChangeDataRowAttr(const SfxItemSet& rAttr, long nRow,BOOL bMerge)
{
	if(nRow>=GetRowCount()) //Vermutlich unntig, nur falls Undo schiefluft
		return FALSE;

	PutDataRowAttr(nRow, rAttr,bMerge);

	const SfxPoolItem* pPoolItem=NULL;
	if(rAttr.GetItemState(SCHATTR_AXIS,TRUE, &pPoolItem) == SFX_ITEM_SET)
	{
		if(((const SfxInt32Item*)pPoolItem)->GetValue()==CHART_AXIS_SECONDARY_Y)
		{
			pChartBAxis->ShowDescr(TRUE);
			pChartBAxis->ShowAxis(TRUE);

		}
		CheckForNewAxisNumFormat();		// #71678#
	}

	if( (eChartStyle==CHSTYLE_3D_PIE) || IsAttrChangeNeedsBuildChart(rAttr))
	{
		BuildChart(FALSE);
		return TRUE;             //Dann kann man sich den ganzen Rest sparen!
	}

	const SfxItemSet& rDataRowAttr = GetDataRowAttr(nRow);

	//Legende attributieren
	if (GetShowLegend())
	   ChangeLegendRowAttr(nRow,rDataRowAttr);//#54870# Legendensymbole attr.

	//Beschriftungen attributieren
	if( (eDataDescr != CHDESCR_NONE) && bShowDataDescr) //alle anderen Symbole attr.
		ChangeRowDescrSymbolAttr(nRow,rDataRowAttr);

	//Datenreihenobjekt(gruppe) holen
	SchObjectId* pObjId=NULL;
	SdrObject*   pDataRowObj = CDRAGetDataRowObj(nRow);
	if (pDataRowObj)
		pObjId = GetObjectId(*pDataRowObj);
	else
	{
		DBG_ERROR("ChartModel::ChangeDataRowAttr: no DataRowGroup! - calling BuildChart()");
		BuildChart(FALSE); //die BruteForce-Methode wirkt immer
		return TRUE;
	}

	//ToDo: ab hier kann noch viel optimiert werden!!! z.B. Pies drften nie betroffen sein
	if(pObjId)
	{
		BOOL bAuto=SetAttrAutoStorage(FALSE);

		switch (pObjId->GetObjId())
		{
			case CHOBJID_DIAGRAM_ROWGROUP:
			case CHOBJID_DIAGRAM_SPECIAL_GROUP:
				CDRAAttrGroup(pDataRowObj,nRow,rDataRowAttr);
				break;
			case CHOBJID_DIAGRAM_ROWS:
			case CHOBJID_DIAGRAM_ROWSLINE:
//-/				pDataRowObj->SetAttributes(rDataRowAttr, FALSE);
				pDataRowObj->SetItemSetAndBroadcast(rDataRowAttr);
				break;
		}

/*		if(   eChartStyle==CHSTYLE_3D_STRIPE
		   || eChartStyle==CHSTYLE_2D_AREA
		   || eChartStyle==CHSTYLE_2D_PERCENTAREA
		   || eChartStyle==CHSTYLE_2D_STACKEDAREA
		   )
			pDataRowObj->SetAttributes(rDataRowAttr, FALSE);	  */

		if(!IsLine(nRow) && !IsArea(nRow))
			if(Is3DChart())
				CopySpecialPointAttrToPage(nRow);
			else
				CopyPointAttrToPage(nRow);

		SetAttrAutoStorage(bAuto);
		return TRUE;
	}
	else return FALSE;
}

/*************************************************************************
|*
|* Datenpunkt-Attribute loeschen, die im Itemset (Argument) vorhanden sind
|*
\************************************************************************/

void ChartModel::ClearDataPointAttr( long nCol, long nRow, const SfxItemSet& rAttr )
{

	CHART_TRACE( "ChartModel::ClearDataPointAttr" );

	ItemSetList* pAttrList = IsDataSwitched()   //abhaengig vom Charttyp - statt bSwitchData
								 ? &aSwitchDataPointAttrList
								 : &aDataPointAttrList;

	SfxItemSet* pItemSet = pAttrList->GetObject(nCol * GetRowCount() + nRow);
	if (pItemSet != NULL)
		ClearDblItems(rAttr,*pItemSet);
}
/*************************************************************************
|*
|* Datenpunkt-Attribute setzen
|*
\************************************************************************/

void ChartModel::PutDataPointAttr( long nCol, long nRow,const SfxItemSet& rAttr, BOOL bMerge /*=TRUE*/)
{
	CHART_TRACE( "ChartModel::PutDataPointAttr" );
	DBG_ITEMS((SfxItemSet&)rAttr,this);

	ItemSetList* pAttrList = IsDataSwitched()   //abhaengig vom Charttyp - statt bSwitchData
						   ? &aSwitchDataPointAttrList
						   : &aDataPointAttrList;

	SfxItemSet* pItemSet = pAttrList->GetObject(nCol * GetRowCount() + nRow);
	if (pItemSet == NULL)
	{
		pItemSet = new SfxItemSet(*pItemPool, nRowWhichPairs);
		pAttrList->Replace (pItemSet, nCol * GetRowCount() + nRow);
	}
	if(!bMerge)
		pItemSet->ClearItem();
    PutItemSetWithNameCreation( *pItemSet, rAttr );
}

// this method exists in analogy to GetFullDataPointAttr
// it is necessary for API (=>XML) and pie charts
void ChartModel::PutFullDataPointAttr(
	long nCol, long nRow,
	const SfxItemSet& rAttr )
{
	PutDataPointAttr( nCol, nRow, rAttr );

	if( IsPieChart())
	{
		// get only fill attribute
		SfxItemSet aColSet( *pItemPool, XATTR_FILLCOLOR, XATTR_FILLCOLOR );
		aColSet.Put( rAttr );

		// set at series (only for pie charts)
		PutDataRowAttr( nCol % GetColCount(), rAttr, TRUE, FALSE );
	}
}

/*************************************************************************
|*
|* Datenpunkt-Attribute ermitteln
|*
\************************************************************************/

const SfxItemSet& ChartModel::GetDataPointAttr( long nCol, long nRow) const
{
	long nIdx = nCol * GetRowCount() + nRow;
	ItemSetList& aAttrList = IsDataSwitched()
		? (class ItemSetList &) aSwitchDataPointAttrList
		: (class ItemSetList &) aDataPointAttrList;

	if( nIdx < (long)aAttrList.Count() )
	{
		SfxItemSet* pSet = aAttrList.GetObject( nIdx );
		if (pSet == NULL)
			return (GetDataRowAttr(nRow));
		else
			return *pSet;
	}
	else
	{
		DBG_ERROR( "Requested data point attribute is unavailable" );

		// return something
		DBG_ASSERT( pChartAttr, "Invalid Chart-ItemSet" );
		return *pChartAttr;
	}
}


const SfxItemSet * ChartModel::GetRawDataPointAttr	(long nCol,long nRow) const
{
	long nIndex = nCol * GetRowCount() + nRow;
	ItemSetList & aAttrList = IsDataSwitched()
		? (class ItemSetList &) aSwitchDataPointAttrList
		: (class ItemSetList &) aDataPointAttrList;

	if (nIndex < (long)aAttrList.Count())
		return aAttrList.GetObject (nIndex);
	else
		return NULL;
}

/*************************************************************************
|*
|* Datenpunkt-Attribute ermitteln
|*
\************************************************************************/

SfxItemSet ChartModel::GetFullDataPointAttr( long nCol, long nRow ) const
{
	ItemSetList* pAttrList = IsDataSwitched()
        ? (class ItemSetList *) & aSwitchDataPointAttrList
        : (class ItemSetList *) & aDataPointAttrList;

	if( ! IsPieChart())
	{
        // get series' attributes and merge with data-point attributes if available
		SfxItemSet aAttr( GetDataRowAttr( nRow ));
		SfxItemSet *pObj=pAttrList->GetObject( nCol * GetRowCount() + nRow );
		if( pObj )
            aAttr.Put( *pObj );
		return aAttr;
	}

	/* the following code is for pie charts only

       data description attributes (SCHATTR_DATADESCR_DESCR and
       SCHATTR_DATADESCR_SHOW_SYM) are contained in data point item set while
       all other (graphical) attributes are contained in data series (data row)
       item set */

    // get data description attributes
    SfxItemSet aDescrAttrib( *pItemPool, SCHATTR_DATADESCR_START, SCHATTR_DATADESCR_END );
    aDescrAttrib.Put( GetDataRowAttr( 0 )); // a pie chart always has only one series

    // the different pies use series attributes rather than data-point attributes
    long nPieCount        = GetColCount();
    long nSecondDimension = GetRowCount(); // pie has only one series, but the data may contain more

	SfxItemSet aAttr( GetDataRowAttr( nCol % nPieCount ));

    if( ( nCol >= nPieCount ) &&
        pDefaultColors )
    {
        XColorEntry* pColEntry = SAL_STATIC_CAST( XColorEntry*, pDefaultColors->GetObject( nCol % pDefaultColors->Count()));
        aAttr.Put( XFillColorItem( pColEntry->GetName(), pColEntry->GetColor()));
    }

    // add description attributes of series
    aAttr.ClearItem( SCHATTR_DATADESCR_DESCR );
    aAttr.ClearItem( SCHATTR_DATADESCR_SHOW_SYM );
    aAttr.Put( aDescrAttrib );

    SfxItemSet* pAttr = pAttrList->GetObject( nCol * nSecondDimension );
    if( ( pAttr != NULL ) && pAttr->Count())
        aAttr.Put( *pAttr );

    return aAttr;
}

/*************************************************************************
|*
|* Datenpunkt-Attribute ermitteln
|*
\************************************************************************/

SfxItemSet& ChartModel::MergeDataPointAttr( SfxItemSet& rAttr, long nCol, long nRow ) const
{
	CHART_TRACE2( "ChartModel::MergeDataPointAttr nCol=%ld, nRow=%ld", nCol, nRow );
	ItemSetList* pAttrList = IsDataSwitched()   //abhaengig vom Charttyp - statt bSwitchData
								 ? (class ItemSetList *) &aSwitchDataPointAttrList
								 : (class ItemSetList *) &aDataPointAttrList;

	SfxItemSet *pObj=pAttrList->GetObject(nCol * GetRowCount() + nRow);
	if(pObj)
		rAttr.Put(*pObj);
	return rAttr;
}



BOOL	ChartModel::IsDataPointAttrSet	(long nCol, long nRow)	const
{
	UINT32 nIndex = nCol * GetRowCount() + nRow;
	ItemSetList& aAttrList = IsDataSwitched()
		? (class ItemSetList &) aSwitchDataPointAttrList
		: (class ItemSetList &) aDataPointAttrList;

	if (nIndex < static_cast<UINT32>(aAttrList.Count()))
		return aAttrList.GetObject (nIndex) != NULL;
	else
		//	Specified data point does not exist.  Therefore an item set does not exist also.
		return false;
}


/*************************************************************************
|*
|* ChangeDataPoint-Submethode: GetDataPointObj
|*
\************************************************************************/
SdrObject* ChartModel::CDPAGetDataPointObj(const long nDataCol,const long nDataRow)
{

	SdrObject* pRetObj=NULL;

	SdrObjGroup* pDiagramObj =
		(SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *GetPage(0));
	DBG_ASSERT(pDiagramObj, "ChartModel::CDPAGetDataPointObj:Diagramm-Objekt nicht gefunden!");

	SdrObjListIter aIterator(*pDiagramObj->GetSubList(), IM_FLAT);
	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchObjectId* pId = GetObjectId(*pObj);

		if (pId)
		{
			UINT16 nId = pId->GetObjId();

			if (nId == CHOBJID_DIAGRAM_ROWGROUP)
			{
				SchDataRow* pRow = GetDataRow(*pObj);
				DBG_ASSERT(pRow, "ChartModel::CDPAGetDataPointObj:Objekt hat keine Datenreihen-Information!");
				if (pRow->GetRow() == nDataRow)
				{
					SdrObjListIter aSubIter(*pObj->GetSubList(), IM_FLAT);
					while (aSubIter.IsMore())
					{
						SdrObject* pSubObj = aSubIter.Next();
						SchObjectId* pSubId = GetObjectId(*pSubObj);

						if (pSubId && (pSubId->GetObjId() == CHOBJID_DIAGRAM_DATA))
						{
							SchDataPoint* pPoint = GetDataPoint(*pSubObj);
							DBG_ASSERT(pPoint, "ChartModel::CDPAGetDataPointObj:Objekt hat keine Datenpunkt-"
											   "Information!");
							if (pPoint->GetCol() == nDataCol &&
								pPoint->GetRow() == 0)
							{
								pRetObj = pSubObj;
								break;
							}
						}
					}
				}
			}
			else if (nId == CHOBJID_DIAGRAM_DATA)
			{
				SchDataPoint* pPoint = GetDataPoint(*pObj);
				DBG_ASSERT(pPoint, "ChartModel::CDPAGetDataPointObj:Objekt hat keine Datenpunkt-"
								   "Information!");
				if (pPoint->GetCol() == nDataCol &&
					pPoint->GetRow() == 0)
				{
					pRetObj = pObj;
					break;
				}
			}
		}
	}
	return pRetObj;
}


/*************************************************************************
|*
|* ChangeDataPoint-Submethode: Attributiere CHOBJID_DIAGRAM_DESCR_SYMBOL
|*
\************************************************************************/

void ChartModel::ChangePointDescrSymbolAttr(const long nCol,const long nRow,const SfxItemSet& rDataPointAttr)
{
	CHART_TRACE( "ChartModel::ChangePointDescrSymbolAttr" );

	//Attributsets fr die Symbole fllen:
	SfxItemSet aSymbolAttr(rDataPointAttr); //#54870#
	GenerateSymbolAttr(aSymbolAttr,nRow,SYMBOLMODE_DESCRIPTION);

	SdrObjGroup* pDiagramObj =
		(SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM, *GetPage(0));
	DBG_ASSERT(pDiagramObj, "ChartModel::ChangePointDescrSymbolAttr:Diagramm-Objekt nicht gefunden!");

	SdrObjListIter aIter1(*pDiagramObj->GetSubList(), IM_FLAT);
	while (aIter1.IsMore())
	{
		SdrObject* pObj1 = aIter1.Next();
		SchObjectId* pId1 = GetObjectId(*pObj1);

		if (pId1 && (pId1->GetObjId() == CHOBJID_DIAGRAM_DESCR_COL) && pObj1->ISA(SdrObjGroup))
		{
			SchDataPoint* pSymPoint = GetDataPoint(*pObj1);
			if (pSymPoint &&
				pSymPoint->GetCol() == nCol &&
				pSymPoint->GetRow() == nRow)
				//#54870# Aus absolut unverstndlichen Grnden stand oben statt nRow immer 0
			{
				SdrObjListIter aIter2
					(*((SdrObjGroup*)pObj1)->GetSubList(), IM_FLAT);
				while (aIter2.IsMore())
				{
					SdrObject* pObj2 = aIter2.Next();
					SchObjectId* pId2 = GetObjectId(*pObj2);

					if (pId2 && (pId2->GetObjId() == CHOBJID_DIAGRAM_DESCR_SYMBOL))
					{
//-/						pObj2->SetAttributes(aSymbolAttr, FALSE);
						pObj2->SetItemSetAndBroadcast(aSymbolAttr);
						break;
					}
				}

				break;
			}
		}
	}
}
/*************************************************************************
|*
|* Datenpunkt-Attribute aendern;
|* Liefert bei geaenderten Attributen TRUE.
|*
\************************************************************************/
//ToDo: der ganzen Quatsch da unten aufrumen
BOOL ChartModel::ChangeDataPointAttr(const SfxItemSet& rAttr,
									 SdrObject& rObj, BOOL bMerge,
									 BOOL bBuildChart)
{
	SchObjectId* pObjId = GetObjectId(rObj);


	if (pObjId)
	{
		SchDataPoint* pDataPoint = GetDataPoint(rObj);
		DBG_ASSERT(pDataPoint, "ChartModel::ChangeDataPointAttr:Objekt hat keine Datenpunkt-Information!");

		short nDataCol = pDataPoint->GetCol();
		short nDataRow = pDataPoint->GetRow();

		PutDataPointAttr(nDataCol, nDataRow, rAttr,bMerge);

		SfxItemSet aDataPointAttr(GetFullDataPointAttr(nDataCol, nDataRow));

		SdrObject* pDataPointObj;
		SdrPage* pPage = GetPage(0);
		DBG_ASSERT(pPage, "ChartModel::ChangeDataPointAttr:Keine Seite vorhanden!");

		if (pObjId->GetObjId() == CHOBJID_LEGEND_SYMBOL_COL)
		{
//-/			rObj.SetAttributes(aDataPointAttr, FALSE);
			rObj.SetItemSetAndBroadcast(aDataPointAttr);
			pDataPointObj = CDPAGetDataPointObj(nDataCol,nDataRow);
			if (!pDataPointObj)
				return TRUE;
			pObjId = GetObjectId(*pDataPointObj);
		}
		else
		{
			if (GetShowLegend())
				ChangeLegendPointAttr(nDataCol,aDataPointAttr);

			pDataPointObj = &rObj;
		}

		if( (eDataDescr != CHDESCR_NONE) && bShowDataDescr) //#54870#
		   ChangePointDescrSymbolAttr(nDataCol,nDataRow,aDataPointAttr);

		BOOL bOld=bAttrAutoStorage;
		SetAttrAutoStorage(FALSE);

//-/		pDataPointObj->SetAttributes(aDataPointAttr, FALSE);
		pDataPointObj->SetItemSetAndBroadcast(aDataPointAttr);

		if(bBuildChart)
		{
			if(IsAttrChangeNeedsBuildChart(rAttr))
				BuildChart(FALSE);
			else
				if(Is3DChart())
//-/					rObj.SetAttributes(rAttr,FALSE);
					rObj.SetItemSetAndBroadcast(rAttr);
		}
		SetAttrAutoStorage(bOld);
		return TRUE;
	}
	else return FALSE;
}

/*************************************************************************
|*
|* Aendere die Attribute einer Achse
|*
\************************************************************************/

void ChartModel::SetAxisAttributes (const SfxItemSet* pAttr,const SdrObjGroup* pAxisObj)
{
	if (pAttr && pAxisObj)
	{
		SfxItemSet aTextAttr(*pItemPool, nTextWhichPairs);

		aTextAttr.Put(*pAttr);

		SdrObjListIter aIterator(*pAxisObj->GetSubList(), IM_FLAT);
		while (aIterator.IsMore())
		{
			SdrObject   *pObj   = aIterator.Next();
			SchObjectId *pObjId = GetObjectId(*pObj);

			if (pObjId)
				switch (pObjId->GetObjId())
				{
					case CHOBJID_LINE :
//-/						pObj->SetAttributes(*pAttr, FALSE);
						pObj->SetItemSetAndBroadcast(*pAttr);
						break;

					case CHOBJID_TEXT :
						SetTextAttr(*(SdrTextObj*)pObj, aTextAttr);

					default :
						;
				}
		}
	}
}

/*************************************************************************
|*
|* Aendere die Attribute einer Achse
|*
\************************************************************************/

BOOL ChartModel::SetAllAxisAttributes ()
{
	SdrPage *pPage=GetPage(0);
	if (!pPage) return FALSE;
	else
	{
		if (pChartXAxis->IsVisible())
			SetAxisAttributes(&GetAttr(CHOBJID_DIAGRAM_X_AXIS),
			 (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM_X_AXIS,*pPage,0,IM_DEEPWITHGROUPS));

		if (CanAxis(CHART_AXIS_SECONDARY_X) && pChartAAxis->IsVisible() )
			SetAxisAttributes(&GetAttr(CHOBJID_DIAGRAM_A_AXIS),
			 (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM_A_AXIS,*pPage,0,IM_DEEPWITHGROUPS));

		if (CanAxis(CHART_AXIS_SECONDARY_Y) && pChartBAxis->IsVisible() )
			SetAxisAttributes(&GetAttr(CHOBJID_DIAGRAM_B_AXIS),
			 (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM_B_AXIS,*pPage,0,IM_DEEPWITHGROUPS));

		if (pChartYAxis->IsVisible())
			SetAxisAttributes(&GetAttr(CHOBJID_DIAGRAM_Y_AXIS),
			 (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM_Y_AXIS,*pPage,0,IM_DEEPWITHGROUPS));

		if (Is3DChart () && pChartZAxis->IsVisible())
			SetAxisAttributes(&GetAttr(CHOBJID_DIAGRAM_Z_AXIS),
			 (SdrObjGroup*)GetObjWithId(CHOBJID_DIAGRAM_Z_AXIS,*pPage,0,IM_DEEPWITHGROUPS));

		BuildChart(FALSE);
		return TRUE;
   }
}

void ChartModel::SetTextFromObject( SdrTextObj* pObj,OutlinerParaObject* pTextObject )
{
	DBG_ASSERT( pObj, "ChartModel::SetTextFromObject: Object is NULL" );
	if( !bAttrAutoStorage && pTextObject // not during BuildChart
		|| !pObj )
		return;

	CHART_TRACE( "ChartModel::SetTextFromObject" );

	SchObjectId* pObjId = GetObjectId( *pObj );

	SfxItemSet *pItemSet = NULL;
	String* pStrToChange = NULL;

	if( pTextObject )
	{
		if( pObjId )
		{
			pOutliner->SetText( *pTextObject );
			String aTitle = pOutliner->GetText( pOutliner->GetParagraph( 0 ), pOutliner->GetParagraphCount() );
			pOutliner->Clear();

			long nId = pObjId->GetObjId();
			switch( nId )
			{
				case CHOBJID_DIAGRAM_TITLE_X_AXIS:
					pItemSet = pXAxisTitleAttr;
					pStrToChange = &aXAxisTitle;
					break;
				case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
					pItemSet = pYAxisTitleAttr;
					pStrToChange = &aYAxisTitle;
					break;
				case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
					pItemSet = pZAxisTitleAttr;
					pStrToChange = &aZAxisTitle;
					break;
				case CHOBJID_TITLE_MAIN:
					pItemSet = pMainTitleAttr;
					pStrToChange = &aMainTitle;
					break;
				case CHOBJID_TITLE_SUB:
					pItemSet = pSubTitleAttr;
					pStrToChange = &aSubTitle;
					break;
			}

			// if stacked is set the string contains linefeeds which have to be removed
			const SfxPoolItem* pPoolItem = NULL;
			if( pItemSet &&
				pItemSet->GetItemState( SCHATTR_TEXT_ORIENT, FALSE, &pPoolItem ) == SFX_ITEM_SET &&
				SAL_STATIC_CAST( const SvxChartTextOrientItem*, pPoolItem )->GetValue() == CHTXTORIENT_STACKED )
			{
				aTitle = UnstackString( aTitle );
			}

			if( pStrToChange )
				*(pStrToChange) = aTitle;
		}
	}
}

//Achtung! diese Funktion sollte nur fr 3-D-Objekte ausgefhrt werden,
//bei z.B. Legendensymbolen fhrt der Aufruf zu einer Endlos-Schleife !!!!!!!!!!!!!
//Im BuildChart wird ueber bAttrAutoStorage=FALSE doppelte Ausfuehrung unterbunden
void ChartModel::StoreObjectsAttributes(SdrObject* pObj,const SfxItemSet& rAttr, FASTBOOL bReplaceAll)
{//#52277#
	if(!bAttrAutoStorage)
		return;
	bAttrAutoStorage=FALSE; //Rekursionen verhindern

	//Eventuell 3D-Materialfarbe in 2D-Fllfarbe konvertieren:
/*	const SfxPoolItem *pPoolItem;
	if( SFX_ITEM_SET == rAttr.GetItemState( SID_ATTR_3D_MAT_COLOR, TRUE, &pPoolItem ) )
	{
		Color aNew = ( ( const SvxColorItem* ) pPoolItem )->GetValue();
		((SfxItemSet&)rAttr).Put(XFillColorItem(String(),aNew));
	}
*/
	DBG_ITEMS(((SfxItemSet&)rAttr),this);

	SchObjectId* pObjId = GetObjectId(*pObj);
	if(!pObjId)
	{
		DBG_ERROR("ChartModel::StoreObjectsAttributes failed, no ObjId");
	}
	long nId=pObjId->GetObjId();

	CHART_TRACE2( "ChartModel::StoreObjectsAttributes Id=%s %s", GetCHOBJIDName( nId ), bReplaceAll? "ReplaceAll" : "Merge" );

	switch(nId)
	{

	case CHOBJID_DIAGRAM_SPECIAL_GROUP:
	case CHOBJID_DIAGRAM_ROWGROUP:
	case CHOBJID_LEGEND_SYMBOL_ROW:
		{
			 SchDataRow* pDataRow =  GetDataRow(*pObj);
			 if(pDataRow)
			 {
				  long nDataRow=pDataRow->GetRow();

				  PutDataRowAttr(nDataRow, rAttr,!bReplaceAll);

				  if (GetShowLegend())
						ChangeLegendRowAttr(nDataRow,rAttr);

				  if( (eDataDescr != CHDESCR_NONE) && bShowDataDescr)
						  ChangeRowDescrSymbolAttr(nDataRow,rAttr);
			 }
		}
		break;

	case CHOBJID_DIAGRAM_DATA:
	case CHOBJID_LEGEND_SYMBOL_COL:
		{
			SchDataPoint* pDataPoint = GetDataPoint(*pObj);
			if(pDataPoint)
			{
				PutDataPointAttr(pDataPoint->GetCol(), pDataPoint->GetRow(), rAttr,!bReplaceAll);

				if (GetShowLegend())
					ChangeLegendPointAttr(pDataPoint->GetCol(),rAttr);

				if( (eDataDescr != CHDESCR_NONE) && bShowDataDescr)
					 ChangePointDescrSymbolAttr(pDataPoint->GetCol(),pDataPoint->GetRow(),rAttr);
			}
		}
		break;

	case CHOBJID_DIAGRAM_STATISTICS_GROUP :
	case CHOBJID_DIAGRAM_AVERAGEVALUE :
	case CHOBJID_DIAGRAM_REGRESSION :

		if(bReplaceAll)
			GetAttr(pObj).ClearItem();
		GetAttr(pObj).Put(rAttr,TRUE);
		break;

	case CHOBJID_DIAGRAM_WALL:
		{
			//Spezialfall, 2.Wand suchen
			ChartScene* pScene=GetScene();
			if(pScene)
			{
				SdrObjListIter aIterator(*pScene->GetSubList(), IM_FLAT);
				while (aIterator.IsMore())
				{
					SdrObject   *pO   = aIterator.Next();
					SchObjectId *pI   = GetObjectId(*pO);
					if(pI && pI->GetObjId()==CHOBJID_DIAGRAM_WALL && pO!=pObj)
//-/						pO->SetAttributes(rAttr,FALSE);
						pO->SetItemSetAndBroadcast(rAttr);
				}
			}
		}
		if(bReplaceAll)
			GetAttr(nId).ClearItem();
		GetAttr(nId).Put(rAttr,TRUE);
		break;
	default:
		if(bReplaceAll)
			GetAttr(nId).ClearItem();
		GetAttr(nId).Put(rAttr,TRUE);
		break;
	}

	bAttrAutoStorage=TRUE;
}

/*************************************************************************
|*
|* Aendere die Attribute bestimmter Objekte in der Page und im Model, bzw.
|* lokalisiere bestimmte Objekte anhand der Id.
|* Wird derzeit nur fuer UNO verwendet, koennte aber allgemeiner und sollte vor
|* allem vollstndiger werden
|*
|* ACHTUNG: es gibt weitere Methoden gleichen/hnlichen Namens und anderen Argumenten,
|* die hnlich wie diese Funktionen arbeiten!
|*
\************************************************************************/

void ChartModel::SetTitle(const long nId, const String& rTitle)
{
	switch(nId)
	{

		case CHOBJID_TITLE_MAIN:
			MainTitle()=rTitle;
			//	Replace the current text object with a new one with the given text.
			{
				SdrObject * pGroupObject = GetObjWithId( CHOBJID_TITLE_MAIN, *GetPage(0) );
				if (pGroupObject != NULL)
				{
					aTitleTopCenter = pGroupObject->GetBoundRect().TopCenter();
					DeleteObject(pGroupObject);
				}
				SdrTextObj * pObj = CreateTextObj(CHOBJID_TITLE_MAIN, aTitleTopCenter,
					aMainTitle, *pMainTitleAttr, TRUE, CHADJUST_TOP_CENTER);
				pObj->SetResizeProtect(TRUE);
				GetPage(0)->NbcInsertObject(pObj);
			}
			break;
		case CHOBJID_TITLE_SUB:
			SubTitle()=rTitle;
			//	Replace the current text object with a new one with the given text.
			{

				SdrObject * pGroupObject = GetObjWithId( CHOBJID_TITLE_SUB, *GetPage(0) );
				if (pGroupObject != NULL)
				{
					aSubTitleTopCenter = pGroupObject->GetBoundRect().TopCenter();
					DeleteObject(pGroupObject);
				}
				SdrTextObj * pObj = CreateTextObj(CHOBJID_TITLE_SUB, aSubTitleTopCenter,
					aSubTitle, *pSubTitleAttr, TRUE, CHADJUST_TOP_CENTER);
				pObj->SetResizeProtect(TRUE);
				GetPage(0)->NbcInsertObject(pObj);
			}
			break;
		case CHOBJID_DIAGRAM_TITLE_X_AXIS:
			XAxisTitle()=rTitle;
			break;
		case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
			YAxisTitle()=rTitle;
			break;
		case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
			ZAxisTitle()=rTitle;
			break;
		default:
			CHART_TRACE2( "SetTitle: Title not found by id %ld (%s) ", nId, GetCHOBJIDName( nId ));
			break;
	}
}

String ChartModel::GetTitle( const long nId )
{
	switch(nId)
	{
	  case CHOBJID_TITLE_MAIN:
		  return MainTitle();
	  case CHOBJID_TITLE_SUB:
		  return SubTitle();
	  case CHOBJID_DIAGRAM_TITLE_X_AXIS:
		  return XAxisTitle();
	  case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
		  return YAxisTitle();
	  case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
		  return ZAxisTitle();
	  default:
		  CHART_TRACE2( "GetTitle: Title not found by id %ld (%s) ", nId, GetCHOBJIDName( nId ));
		  return String();
	}
}

void ChartModel::SetHasBeenMoved(const long nId,BOOL bMoved)
{
	switch(nId)
	{

		case CHOBJID_TITLE_MAIN:
			SetMainTitleHasBeenMoved(bMoved);
			break;
		case CHOBJID_TITLE_SUB:
			SetSubTitleHasBeenMoved(bMoved);
			break;
		case CHOBJID_DIAGRAM_TITLE_X_AXIS:
			SetXAxisTitleHasBeenMoved(bMoved);
			break;
		case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
			SetYAxisTitleHasBeenMoved(bMoved);
			break;
		case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
			SetZAxisTitleHasBeenMoved(bMoved);
			break;
		case CHOBJID_LEGEND:
			SetLegendHasBeenMoved(bMoved);
			break;
		default:
			CHART_TRACE2( "SetHasBeenMoved: Object not found by id %ld (%s) ", nId, GetCHOBJIDName( nId ));
			break;
	}
}
SdrObject* ChartModel::GetObjectWithId(const long nId,const long nCol,const long nRow)
{
	//ToDo: Das hier knnte man auch schner machen (kein DEEP!)
	SdrObject* pObj=(GetObjWithId ((USHORT)nId,*GetPage(0),0,IM_DEEPWITHGROUPS));
#ifdef DBG_UTIL
	// there is no DBG_ASSERT2
	if( !pObj )
		DBG_ERROR2( "GetObjWithId: Object not found (id=%ld => %s)", nId, GetCHOBJIDName( nId ) );
#endif
	return pObj;
}

// GetAttr-Methoden:
//GetAttr(id) Diese Methode sucht anhand der Id den passenden Model-eigenen AttrSet
//Achtung! Wenn zu einer ID kein Set existiert, wird *pDummyAttr returned!
//(ungefhrlich, geringer Overhead, wirft daher nur DBG__TRACE)
//Nicht-Singulre Objekte knnen nicht an der ID alleine identifiziert werden,
//in diesem Fall muss GetAttr(SdrObject*) statt GetAttr(long id) gerufen werden
// GetAttr(long id, SfxItemSet&) besorgt alle fr ein Objekt verfgbaren und
// gltigen Attribute
SfxItemSet& ChartModel::GetAttr(const SdrObject *pObj)
{
	CHART_TRACE( "ChartModel::GetAttr" );
	SchObjectId* pObjId = GetObjectId(*pObj);
	long nId=pObjId->GetObjId();

	switch(nId)
	{
	case CHOBJID_DIAGRAM_SPECIAL_GROUP:
	case CHOBJID_DIAGRAM_ROWGROUP:
	case CHOBJID_LEGEND_SYMBOL_ROW:
		{
			 SchDataRow* pDataRow =  GetDataRow(*pObj);
			 if(pDataRow)
			 {
				 return (SfxItemSet&)GetDataRowAttr(pDataRow->GetRow());
			 }
		}
		break;

	case CHOBJID_DIAGRAM_DATA :
	case CHOBJID_LEGEND_SYMBOL_COL:
		{
			SchDataPoint* pDataPoint = GetDataPoint(*pObj);
			if(pDataPoint)
			{
				return (SfxItemSet&)GetDataPointAttr(pDataPoint->GetCol(),pDataPoint->GetRow());
			}
		}
		break;
	case SID_DIAGRAM_ERROR :
		{
			 SchDataRow* pDataRow =  GetDataRow(*pObj);
			 if(pDataRow)
			 {
				 return (SfxItemSet&)GetErrorAttr(pDataRow->GetRow());
			 }
		}
		break;

	case SID_DIAGRAM_AVERAGEVALUE :
		{
			 SchDataRow* pDataRow =  GetDataRow(*pObj);
			 if(pDataRow)
			 {
				 return (SfxItemSet&)GetAverageAttr(pDataRow->GetRow());
			 }
		}
		break;

	case SID_DIAGRAM_REGRESSION :
		{
			 SchDataRow* pDataRow =  GetDataRow(*pObj);
			 if(pDataRow)
			 {
				 return (SfxItemSet&)GetRegressAttr(pDataRow->GetRow());
			 }
		}
		break;

	default:
		return 	GetAttr(nId);
		break;
	}
	CHART_TRACE1( "GetAttr illegal Object Id (%ld), returning dummy", nId );
	return *pDummyAttr;
}

/*
Fehlen evtl. noch in GetAttr(ID):

#define        CHOBJID_DIAGRAM                   13
#define        CHOBJID_DIAGRAM_X_GRID_MAIN       22
#define        CHOBJID_DIAGRAM_Y_GRID_MAIN       23
#define        CHOBJID_DIAGRAM_Z_GRID_MAIN       24
#define        CHOBJID_DIAGRAM_X_GRID_HELP       25
#define        CHOBJID_DIAGRAM_Y_GRID_HELP       26
#define        CHOBJID_DIAGRAM_Z_GRID_HELP       27
#define        CHOBJID_DIAGRAM_ROWS              29
#define        CHOBJID_DIAGRAM_ROWSLINE          30
#define        CHOBJID_DIAGRAM_DESCRGROUP        32
#define        CHOBJID_DIAGRAM_DESCR_ROW         33
#define        CHOBJID_DIAGRAM_DESCR_COL         38
#define        CHOBJID_DIAGRAM_DESCR_SYMBOL      39
#define        CHOBJID_DIAGRAM_NET               41
#define        CHOBJID_DIAGRAM_STACKEDGROUP      46
#define        CHOBJID_DIAGRAM_STATISTICS_GROUP  48


  nur GetAttr(pObj):
#define        CHOBJID_DIAGRAM_AVERAGEVALUE      42
#define        CHOBJID_DIAGRAM_REGRESSION        45
#define        CHOBJID_DIAGRAM_ERROR             43

#define        CHOBJID_LEGEND_SYMBOL_ROW         36
#define        CHOBJID_LEGEND_SYMBOL_COL         37
#define        CHOBJID_DIAGRAM_DATA              31
#define        CHOBJID_DIAGRAM_SPECIAL_GROUP     55
#define        CHOBJID_DIAGRAM_ROWGROUP          28

  */

void ChartModel::SetAttributes(const long nId,const SfxItemSet& rAttr,BOOL bMerge)
{
	CHART_TRACE( "ChartModel::SetAttributes" );
	SfxItemSet& rItemSet=GetAttr(nId);

	if(!bMerge)
		rItemSet.ClearItem();


	//sobald die member bShow*Descr endlich entfallen, kann das hier alles weg
/*	if(nId==CHOBJID_DIAGRAM_X_AXIS || nId==CHOBJID_DIAGRAM_Y_AXIS || nId==CHOBJID_DIAGRAM_Z_AXIS)
	{
		const SfxPoolItem *pPoolItem=NULL;
		if( rAttr.GetItemState( SCHATTR_AXIS_SHOWDESCR, FALSE, &pPoolItem ) == SFX_ITEM_SET )
		{
			BOOL bShow = ( (const SfxBoolItem*) pPoolItem)->GetValue();
			switch(nId)
			{
				case CHOBJID_DIAGRAM_X_AXIS:
					bShowXDescr=bShow;
					break;
				case CHOBJID_DIAGRAM_Y_AXIS:
					bShowYDescr=bShow;
					break;
				case CHOBJID_DIAGRAM_Z_AXIS:
					bShowZDescr=bShow;
					break;
			}
		}
	}*/


	rItemSet.Put(rAttr);
}
SfxItemSet& ChartModel::GetAttr(const long nObjId,const long nIndex1/*=-1*/) const
{
	CHART_TRACE( "ChartModel::GetAttr(const long nObjId)" );

	switch(nObjId)
	{
		case CHOBJID_DIAGRAM_STOCKLINE_GROUP:
			return *pStockLineAttr;

		case CHOBJID_DIAGRAM_STOCKPLUS_GROUP:
			return *pStockPlusAttr;

		case CHOBJID_DIAGRAM_STOCKLOSS_GROUP:
			return *pStockLossAttr;

		case CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP:
			return *pXGridMainAttr;

		case CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP:
			return *pYGridMainAttr;

		case CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP:
			return *pZGridMainAttr;

		case CHOBJID_DIAGRAM_X_GRID_HELP_GROUP:
			return *pXGridHelpAttr;

		case CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP:
			return *pYGridHelpAttr;

		case CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP:
			return *pZGridHelpAttr;

		case CHOBJID_DIAGRAM_AREA:
			return *pDiagramAreaAttr;

		case CHOBJID_DIAGRAM:          //Leider mmehrfache bedeutung, im 2D ist das wohl das selbe
		case CHOBJID_DIAGRAM_WALL:
			return *pDiagramWallAttr;

		case CHOBJID_DIAGRAM_FLOOR:
			return *pDiagramFloorAttr;

		case CHOBJID_DIAGRAM_TITLE_X_AXIS:
			return *pXAxisTitleAttr;
		case CHOBJID_DIAGRAM_TITLE_Y_AXIS:
			return *pYAxisTitleAttr;
		case CHOBJID_DIAGRAM_TITLE_Z_AXIS:
			return *pZAxisTitleAttr;

		case CHOBJID_TITLE_MAIN:
			return *pMainTitleAttr;
		case CHOBJID_TITLE_SUB:
			return *pSubTitleAttr;

		case CHOBJID_DIAGRAM_X_AXIS:
			return *pChartXAxis->GetItemSet();
		case CHOBJID_DIAGRAM_Y_AXIS:
			return *pChartYAxis->GetItemSet();
		case CHOBJID_DIAGRAM_Z_AXIS:
			return *pChartZAxis->GetItemSet();
		case CHOBJID_DIAGRAM_B_AXIS:
			return *pChartBAxis->GetItemSet();
		case CHOBJID_DIAGRAM_A_AXIS:
			return *pChartAAxis->GetItemSet();

		case CHOBJID_LEGEND_BACK: //Achtung, dies ist nur das Drawing-Objekt, normalerweise erhlt man die andere ID fr das Gruppenobjekt
		case CHOBJID_LEGEND:
			return *pLegendAttr;

			/*return *pTitleAttr;
			return *pAxisAttr;
			return *pGridAttr;
			return *pChartAttr;*/

		case CHOBJID_DIAGRAM_REGRESSION:
			return *aRegressAttrList.GetObject(nIndex1);
		case CHOBJID_DIAGRAM_ERROR:
			return *aErrorAttrList.GetObject(nIndex1);
		case CHOBJID_DIAGRAM_AVERAGEVALUE:
			return *aAverageAttrList.GetObject(nIndex1);

		default:
			CHART_TRACE1( "GetAttr illegal Object Id (%ld), returning dummy", nObjId );
			return *pDummyAttr;
	}
}


//	This method fills rAttr with the items stored at the object specified
//	by nObjId.  Effectively calls GetAttr(long,long) but handles diagram
//	axes as special case.
//	The item set of the graphical object representation is not merged in
//	anymore.
void ChartModel::GetAttr( const long nObjId, SfxItemSet& rAttr, const long nIndex1 /*=-1*/ )
{
	CHART_TRACE( "ChartModel::GetAttr( long nObjId, SfxItemSet& rAttr)" );

#if 0
	SdrObject* pObj=NULL;

	//Objektattribute aus der Seite holen
	//aber keine indizierten Objekte auf diese Weise suchen !
	if(nIndex1==-1)
	{
		pObj=(GetObjWithId ((USHORT)nObjId,*GetPage(0),0,IM_DEEPWITHGROUPS));
		if(pObj)
			rAttr.Put(pObj->GetItemSet());
	}
#endif

	// items at model (and axis object)
	switch( nObjId )
	{
		case CHOBJID_DIAGRAM_X_AXIS:
		case CHOBJID_DIAGRAM_Y_AXIS:
		case CHOBJID_DIAGRAM_A_AXIS:
		case CHOBJID_DIAGRAM_B_AXIS:
		case CHOBJID_DIAGRAM_Z_AXIS:
			{
				// general item set
				rAttr.Put( *pAxisAttr );

				// specialized item set and members
				ChartAxis* pAxis = GetAxis( nObjId );
				if( pAxis )
				{
					rAttr.Put( *(pAxis->GetItemSet()));
					pAxis->GetMembersAsAttr( rAttr );
				}
				// ChartModel members for axes
				GetTextRotation( rAttr );
				switch( nObjId )
				{
					case CHOBJID_DIAGRAM_X_AXIS:
					case CHOBJID_DIAGRAM_A_AXIS:
						rAttr.Put( SfxBoolItem( SID_TEXTBREAK, GetFormatXAxisTextInMultipleLinesIfNecessary() ) );
						break;
					case CHOBJID_DIAGRAM_Y_AXIS:
					case CHOBJID_DIAGRAM_B_AXIS:
						rAttr.Put( SfxBoolItem( SID_TEXTBREAK, GetFormatYAxisTextInMultipleLinesIfNecessary() ) );
						break;
					case CHOBJID_DIAGRAM_Z_AXIS:
						rAttr.Put( SfxBoolItem( SID_TEXTBREAK, GetFormatZAxisTextInMultipleLinesIfNecessary() ) );
						break;
				}
			}
			break;

		default:
			rAttr.Put( GetAttr( nObjId, nIndex1 ));
			break;
	}
}

BOOL ChartModel::ChangeAttr(const SfxItemSet& rAttr,const long nId,const long nIndex1/*=-1*/)
{
	BOOL bNeedChanges=TRUE; //noch ungenutzt, zur evtl. Optimierung


	//ToDo: optimieren! klappt wegen XChartView so nicht:
	//BOOL bForceBuild=FALSE;
	BOOL bForceBuild=TRUE;


	SdrObject* pObj=NULL;
	//Objektattribute am Objekt setzen, falls nicht indiziert
	if(nIndex1==-1)
	{
		pObj=(GetObjWithId ((USHORT)nId,*GetPage(0),0,IM_DEEPWITHGROUPS));
	   if(pObj)
//-/			pObj->SetAttributes(rAttr,FALSE);
			pObj->SetItemSetAndBroadcast(rAttr);
	}


	//und auch am Model
	switch(nId)
	{
		case CHOBJID_DIAGRAM_X_AXIS:
		case CHOBJID_DIAGRAM_Y_AXIS:
		case CHOBJID_DIAGRAM_A_AXIS:
		case CHOBJID_DIAGRAM_B_AXIS:
		case CHOBJID_DIAGRAM_Z_AXIS:
			{
				const SfxPoolItem *pPoolItem;
				if(pObj)
				{
					ChangeAxisAttr(rAttr,(SdrObjGroup*)pObj);
				}
				else
				{
					const SfxPoolItem* pPoolItem=NULL;
					if(rAttr.GetItemState(SID_ATTR_NUMBERFORMAT_VALUE,TRUE,&pPoolItem)==SFX_ITEM_SET)
					{
						SfxItemSet aSet(rAttr);
						UINT32 nTmp=((const SfxUInt32Item*)pPoolItem)->GetValue();
						aSet.Put(SfxUInt32Item(IsPercentChart()
							? SCHATTR_AXIS_NUMFMTPERCENT : SCHATTR_AXIS_NUMFMT , nTmp));
						SetAttributes(nId,aSet); //im Model
					}
					else
					{
						SetAttributes(nId,rAttr); //im Model
					}

				}

				if( SFX_ITEM_SET == rAttr.GetItemState( SID_TEXTBREAK, TRUE, &pPoolItem ) )
				{
					switch(nId)
					{
						case CHOBJID_DIAGRAM_X_AXIS:
						case CHOBJID_DIAGRAM_A_AXIS:
							SetFormatXAxisTextInMultipleLinesIfNecessary(((const SfxBoolItem*)pPoolItem)->GetValue());
							break;
						case CHOBJID_DIAGRAM_Y_AXIS:
						case CHOBJID_DIAGRAM_B_AXIS:
							SetFormatYAxisTextInMultipleLinesIfNecessary(((const SfxBoolItem*)pPoolItem)->GetValue());
							break;
						case CHOBJID_DIAGRAM_Z_AXIS:
							SetFormatZAxisTextInMultipleLinesIfNecessary(((const SfxBoolItem*)pPoolItem)->GetValue());
							break;
					}
				}
			}
			break;
		default:
			GetAttr(nId,nIndex1).Put(rAttr,TRUE);
			break;
	}

    // calculate result here because BuildChart will delete pObj (dangling pointer)
    BOOL bResult = ( pObj != NULL || nIndex1 != -1 );
    
	if(bForceBuild || nIndex1!=-1)
		BuildChart(FALSE);
	else if(bNeedChanges && IsAttrChangeNeedsBuildChart(rAttr))
		BuildChart(FALSE);

	return bResult;
}
/* Anmerkungen zu GetObjectAttr,SetObjectAttr:

-  das koennte bei get(????) fehlen:
		CompareSets (*pYGridMainAttr, *pGridAttr);
		CompareSets (*pZGridMainAttr, *pGridAttr);
		CompareSets (*pXGridHelpAttr, *pGridAttr);
		CompareSets (*pYGridHelpAttr, *pGridAttr);
		CompareSets (*pZGridHelpAttr, *pGridAttr);

-  evtl. sollten default-itemwerte erkannt und wieder entfert werden (SET)

- erweitern auf DataRowPoint!

- Das koennte man mal alles oben hineintun....

#define        CHOBJID_TEXT                       1
#define        CHOBJID_AREA                       2
#define        CHOBJID_LINE                       3



#define        CHOBJID_TITLE_MAIN                11
#define        CHOBJID_TITLE_SUB                 12
#define        CHOBJID_DIAGRAM                   13

#define        CHOBJID_DIAGRAM_TITLE_X_AXIS      16
#define        CHOBJID_DIAGRAM_TITLE_Y_AXIS      17
#define        CHOBJID_DIAGRAM_TITLE_Z_AXIS      18


#define        CHOBJID_DIAGRAM_ROWGROUP          28
#define        CHOBJID_DIAGRAM_ROWS              29
#define        CHOBJID_DIAGRAM_ROWSLINE          30
#define        CHOBJID_DIAGRAM_DATA              31
#define        CHOBJID_DIAGRAM_DESCRGROUP        32
#define        CHOBJID_DIAGRAM_DESCR_ROW         33
#define        CHOBJID_DIAGRAM_DESCR_COL         38
#define        CHOBJID_DIAGRAM_DESCR_SYMBOL      39
#define        CHOBJID_LEGEND                    34
#define        CHOBJID_LEGEND_BACK               35
#define        CHOBJID_LEGEND_SYMBOL_ROW         36
#define        CHOBJID_LEGEND_SYMBOL_COL         37
#define        CHOBJID_DIAGRAM_NET               41
#define        CHOBJID_DIAGRAM_AVERAGEVALUE      42
#define        CHOBJID_DIAGRAM_ERROR             43
#define        CHOBJID_DIAGRAM_REGRESSION        45
#define        CHOBJID_DIAGRAM_STACKEDGROUP      46
#define        CHOBJID_DIAGRAM_STATISTICS_GROUP  48
#define        CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP 49
#define        CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP 50
#define        CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP 51
#define        CHOBJID_DIAGRAM_X_GRID_HELP_GROUP 52
#define        CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP 53
#define        CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP 54
#define        CHOBJID_DIAGRAM_SPECIAL_GROUP     55

pYGridMainAttr->Put(rAttr);
*/

BOOL ChartModel::MoveRow(long nRow,BOOL bUp)
{
	BOOL bOK;

	if(bUp)
		nRow--;
	if(!bSwitchData)
		bOK=pChartData->SwapRowTranslation(nRow,nRow+1);
	else
		bOK=pChartData->SwapColTranslation(nRow,nRow+1);

	if(bOK)
	{
		SetAttrAutoStorage(FALSE);//sonst gehen Datenpunktattr verloren
		SwapRowAttr(nRow,nRow+1);
	}

	return bOK;
}
void ChartModel::SwapRowAttr(long nRow1,long nRow2)
{
	SfxItemSet aSet(*pItemPool,nRowWhichPairs);
	long nCol,nColCnt=GetColCount();

	for(nCol=0;nCol<nColCnt;nCol++)
	{
		aSet.Put(GetDataPointAttr(nCol,nRow2));
		PutDataPointAttr(nCol,nRow2,GetDataPointAttr(nCol,nRow1),FALSE);
		PutDataPointAttr(nCol,nRow1,aSet,FALSE);
		aSet.ClearItem();
	}
	aSet.Put(GetDataRowAttr(nRow2));
	PutDataRowAttr(nRow2,GetDataRowAttr(nRow1),FALSE,FALSE);
	PutDataRowAttr(nRow1,aSet,FALSE,FALSE);
}



UINT32 ChartModel::GetNumFmt(long nObjId,BOOL bPercent)
{
	return ((const SfxUInt32Item&)GetAttr(nObjId).Get(bPercent
			? SCHATTR_AXIS_NUMFMTPERCENT:SCHATTR_AXIS_NUMFMT)).GetValue();
}
void ChartModel::SetNumFmt(long nObjId,UINT32 nFmt,BOOL bPercent)
{
	SfxItemSet aSet(*pItemPool,SCHATTR_AXIS_NUMFMT,SCHATTR_AXIS_NUMFMTPERCENT);
	aSet.Put(SfxUInt32Item(bPercent? SCHATTR_AXIS_NUMFMTPERCENT:SCHATTR_AXIS_NUMFMT,nFmt));
	SetAttributes(nObjId,aSet);
}


// Prerequisite: rOutAttributes is empty but can hold all interesting attributes
// Result:       All Items that are contained in all data row item sets are set
//               (using the Intersect method of the SfxItemSet)
void ChartModel::GetDataRowAttrAll( SfxItemSet& rOutAttributes )
{
    long nListSize = aDataRowAttrList.Count();

    // no itemsets => result stays empty
    if( nListSize == 0 )
        return;

    // set items of first data row and then intersect with all remaining
    rOutAttributes.Put( *aDataRowAttrList.GetObject( 0 ));
	for( long nRow = 1; nRow < nListSize; nRow++ )
        rOutAttributes.Intersect( *aDataRowAttrList.GetObject( nRow ));
}

void ChartModel::SetItemWithNameCreation( SfxItemSet& rDestItemSet, const SfxPoolItem* pNewItem )
{
    if( pNewItem == NULL )
        return;

    const SfxPoolItem* pItemToSet = pNewItem;

    // this code comes from svx/source/svdraw/svdoattr.cxx: SdrAttrObj::ItemChange()
    switch( pItemToSet->Which())
    {
		case XATTR_FILLBITMAP:
			pItemToSet = ((XFillBitmapItem*)pItemToSet)->checkForUniqueItem( this );
			break;
		case XATTR_LINEDASH:
			pItemToSet = ((XLineDashItem*)pItemToSet)->checkForUniqueItem( this );
			break;
		case XATTR_LINESTART:
			pItemToSet = ((XLineStartItem*)pItemToSet)->checkForUniqueItem( this );
			break;
		case XATTR_LINEEND:
			pItemToSet = ((XLineEndItem*)pItemToSet)->checkForUniqueItem( this );
			break;
		case XATTR_FILLGRADIENT:
			pItemToSet = ((XFillGradientItem*)pItemToSet)->checkForUniqueItem( this );
			break;
		case XATTR_FILLFLOATTRANSPARENCE:
			pItemToSet = ((XFillFloatTransparenceItem*)pItemToSet)->checkForUniqueItem( this );
			break;
		case XATTR_FILLHATCH:
			pItemToSet = ((XFillHatchItem*)pItemToSet)->checkForUniqueItem( this );
			break;
    }

    if( pItemToSet )
        rDestItemSet.Put( *pItemToSet );

    // delete item if it was a generated one
    if( pNewItem != pItemToSet )
        delete pItemToSet;
}

void ChartModel::PutItemSetWithNameCreation( SfxItemSet& rDestItemSet, const SfxItemSet& rNewItemSet )
{
    // copy all attributes
    rDestItemSet.Put( rNewItemSet );

    // check for items that need name creation
    SfxWhichIter        aIter( rNewItemSet );
    sal_uInt16          nWhich = aIter.FirstWhich();
    const SfxPoolItem*  pPoolItem = NULL;

    while( nWhich )
    {
        switch( nWhich )
        {
            case XATTR_FILLBITMAP:
            case XATTR_LINEDASH:
            case XATTR_LINESTART:
            case XATTR_LINEEND:
            case XATTR_FILLGRADIENT:
            case XATTR_FILLFLOATTRANSPARENCE:
            case XATTR_FILLHATCH:
                if( SFX_ITEM_SET == rNewItemSet.GetItemState( nWhich, TRUE, &pPoolItem ))
                    SetItemWithNameCreation( rDestItemSet, pPoolItem );
        }
        nWhich = aIter.NextWhich();
    }
}
