/*************************************************************************
 *
 *  $RCSfile: chtmod3d.cxx,v $
 *
 *  $Revision: 1.14.2.2 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 07:39:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define RAD2CDEG(fAngle) ( (long)(((fAngle)*18000.0/F_PI)+36000.0)%36000 )

#ifndef _E3D_LIGHT3D_HXX //autogen
#include <svx/light3d.hxx>
#endif
#ifndef _SVDVIEW_HXX //autogen
#include <svx/svdview.hxx>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif

#include <svx/obj3d.hxx>

#ifndef _SCHATTR_HXX
#include "schattr.hxx"
#endif
#define ITEMID_ADJUST EE_PARA_JUST
#include <svx/adjitem.hxx>

#ifndef _SVX_CHRTITEM_HXX //autogen
#define ITEMID_CHARTDATADESCR	SCHATTR_DATADESCR_DESCR
#define ITEMID_CHARTTEXTORIENT	SCHATTR_TEXT_ORIENT
#include <svx/chrtitem.hxx>
#endif

#ifndef _SCH_OBJADJ_HXX
#include  "objadj.hxx"
#endif
#ifndef _CHTMODEL_HXX
#include <chtmodel.hxx>
#include <globfunc.hxx>
#endif
#ifndef _SCH_SCHRESID_HXX
#include "schresid.hxx"
#endif
#ifndef _SCH_DATAROW_HXX
#include "datarow.hxx"
#endif
#ifndef _SCH_DATAPOIN_HXX
#include "datapoin.hxx"
#endif
#ifndef _SCH_SCHGROUP_HXX
#include "schgroup.hxx"
#endif
#ifndef _SCH_AXISID_HXX
#include "axisid.hxx"
#endif
#ifndef _CHTSCENE_HXX
#include "chtscene.hxx"
#endif
#ifndef _E3D_LIGHT3D_HXX //autogen
#include <svx/light3d.hxx>
#endif

#undef	ITEMID_COLOR		//	Defined in svx3ditems.hxx
#define ITEMID_COLOR       EE_CHAR_COLOR
#ifndef _SVX_COLRITEM_HXX //autogen wg. SvxColorItem	// #60999#
#include <svx/colritem.hxx>
#endif

#ifndef _E3D_POLYGON3D_HXX
#include <svx/polygn3d.hxx>
#endif
#ifndef _SVDOCIRC_HXX //autogen
#include <svx/svdocirc.hxx>
#endif
#include "math.h"
#include "glob.hrc"
#include "float.h"

#ifndef _ZFORLIST_HXX //autogen
#ifndef _ZFORLIST_DECLARE_TABLE
#define _ZFORLIST_DECLARE_TABLE
#endif
#include <svtools/zforlist.hxx>
#endif
#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif
#ifndef _SVX_XLNWTIT_HXX //autogen
#include <svx/xlnwtit.hxx>
#endif

#include "pairs.hxx"
#include "chmod3d.hxx"
#include "chaxis.hxx"
#include "chdescr.hxx"
#define FIXED_SIZE_FOR_3D_CHART_VOLUME			(10000)

#ifndef _SVX3DITEMS_HXX
#include <svx/svx3ditems.hxx>
#endif

/*************************************************************************
|*
|* Erzeugt alle 3d-Achsentitel und setzt sie sofort ins Diagramm
|* Positioniert werden sie von der Chartszene
|*
\************************************************************************/

void ChartModel::CreateAndInsert3DAxesTitles (Rectangle &rRect, BOOL bSwitchColRow)
{
	SdrTextObj *pXAxisTitleObj = NULL;
	SdrTextObj *pYAxisTitleObj = NULL;
	SdrTextObj *pZAxisTitleObj = NULL;

	if (bShowXAxisTitle)
	{
		pXAxisTitleObj = CreateTitle (pXAxisTitleAttr, CHOBJID_DIAGRAM_TITLE_X_AXIS,
												   bSwitchColRow,aXAxisTitle,
												   FALSE, &eAdjustXAxesTitle);
		if (GetAdjustMarginsForXAxisTitle())
		{
			if (bSwitchColRow)
				rRect.Left() += GetOutputSize(*pXAxisTitleObj).Width() + 200;
			else
				rRect.Bottom() -= GetOutputSize(*pXAxisTitleObj).Height() + 200;
		}
	}
	if (bShowYAxisTitle)
	{
		pYAxisTitleObj = CreateTitle (pYAxisTitleAttr, CHOBJID_DIAGRAM_TITLE_Y_AXIS,
												   bSwitchColRow, aYAxisTitle,
												   TRUE, &eAdjustYAxesTitle);
		if (GetAdjustMarginsForYAxisTitle())
		{
			if (bSwitchColRow)
				rRect.Bottom() -= GetOutputSize(*pYAxisTitleObj).Height() + 200;
			else
				rRect.Left() += GetOutputSize(*pYAxisTitleObj).Width() + 200;
		}
	}
	if (bShowZAxisTitle)
	{
		pZAxisTitleObj = CreateTitle (pZAxisTitleAttr, CHOBJID_DIAGRAM_TITLE_Z_AXIS,
			bSwitchColRow,aZAxisTitle, FALSE, &eAdjustZAxesTitle);
		if( GetAdjustMarginsForZAxisTitle())
        {
            rRect.Right() -= GetOutputSize(*pZAxisTitleObj).Width() + 200;
        }
	}

	SdrPage* pPage=GetPage(0);
	if (pXAxisTitleObj) pPage->NbcInsertObject( pXAxisTitleObj );
	if (pYAxisTitleObj) pPage->NbcInsertObject( pYAxisTitleObj );
	if (pZAxisTitleObj) pPage->NbcInsertObject( pZAxisTitleObj );

    // this should resize the scene according to the space needed
    // by the titles. However this results in strange effects like
    // constant resizing until the scene has 0 size and also the title
    // objects disappear when being moved (?).
//     GetScene()->NbcSetSnapRect( rRect );
}

/*************************************************************************
|*
|* 3D-Rueckwaende mit Unterteilung und Beschriftung erzeugen
|*
\************************************************************************/
void ChartModel::Create3DBackplanes (Rectangle		&rRect,
									 Vector3D       aPos,
									 Vector3D       aSizeVec,
									 ChartScene     &rScene,
									 BOOL           bPartDescr,
									 BOOL           bXLogarithm,
									 BOOL           bYLogarithm,
									 BOOL           bZLogarithm,
									 USHORT         eStackMode,
									 BOOL           bPercent,
									 BOOL           bFlatChart,
									 BOOL           bSwitchColRow)
{
	//vorlaeufiger Hack, bis logarithmus-Ueberpruefung eingebaut (autokorrektur):
	pChartXAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_LOGARITHM,bXLogarithm));
	pChartYAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_LOGARITHM,bYLogarithm));
	pChartZAxis->GetItemSet()->Put(SfxBoolItem(SCHATTR_AXIS_LOGARITHM,bZLogarithm));

	String     aNumStr;

	E3dObject* pXGridMainGroup = bShowXGridMain
											 ? Create3DObject (CHOBJID_DIAGRAM_X_GRID_MAIN_GROUP)
											 : 0;
	E3dObject* pYGridMainGroup = bShowYGridMain
											 ? Create3DObject (CHOBJID_DIAGRAM_Y_GRID_MAIN_GROUP)
											 : 0;
	E3dObject* pZGridMainGroup = bShowZGridMain
											 ? Create3DObject (CHOBJID_DIAGRAM_Z_GRID_MAIN_GROUP)
											 : 0;
	E3dObject* pXGridHelpGroup = bShowXGridHelp
											 ? Create3DObject (CHOBJID_DIAGRAM_X_GRID_HELP_GROUP)
											 : 0;
	E3dObject* pYGridHelpGroup = bShowYGridHelp
											 ? Create3DObject (CHOBJID_DIAGRAM_Y_GRID_HELP_GROUP)
											 : 0;
	E3dObject* pZGridHelpGroup = bShowZGridHelp
											 ? Create3DObject (CHOBJID_DIAGRAM_Z_GRID_HELP_GROUP)
											 : 0;
	E3dObject* pXAxisGroup     = pChartXAxis->IsVisible()|| pChartXAxis->HasDescription()  //#47500#
											 ? Create3DAxisObj( CHOBJID_DIAGRAM_X_AXIS )
											 : 0;
	E3dObject* pYAxisGroup     = pChartYAxis->IsVisible() || pChartYAxis->HasDescription() //#47500#
											 ? Create3DAxisObj( CHOBJID_DIAGRAM_Y_AXIS )
											 : 0;
	E3dObject* pZAxisGroup     = pChartZAxis->IsVisible() || pChartZAxis->HasDescription() //#47500#
											 ? Create3DAxisObj( CHOBJID_DIAGRAM_Z_AXIS )
											 : 0;
	Polygon3D    aRect3D;
	
	pChartXAxis->Initialise(rRect,bSwitchColRow,eStackMode,bPercent,FALSE);
	pChartYAxis->Initialise(rRect,bSwitchColRow,eStackMode,bPercent,FALSE);
	pChartZAxis->Initialise(rRect,bSwitchColRow,eStackMode,bPercent,FALSE);

	pChartXAxis->CalcValueSteps();
	pChartYAxis->CalcValueSteps();
	pChartZAxis->CalcValueSteps();

//Vorlaeufige Notloesung, entsprechende Stellen sollen noch geaendert werden, daher bitte kein Search&Repleace statt der #defs!
#define	fOriginY		pChartYAxis->GetOrigin()
#define fMinValueY		pChartYAxis->GetMin()
#define fMaxValueY		pChartYAxis->GetMax()
#define fValueStepMainY pChartYAxis->GetStep()
#define fValueStepHelpY pChartYAxis->GetHelpStep()

	//ToDo: vorlaeufig
	SfxItemSet* pXAxisAttr=&GetAttr(CHOBJID_DIAGRAM_X_AXIS);
	SfxItemSet* pYAxisAttr=&GetAttr(CHOBJID_DIAGRAM_Y_AXIS);
	SfxItemSet* pZAxisAttr=&GetAttr(CHOBJID_DIAGRAM_Z_AXIS);

	SvxChartTextOrient eDescrOrient = ((const SvxChartTextOrientItem&)pXAxisAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue();
	SvxChartTextOrient eValueOrient = ((const SvxChartTextOrientItem&)pYAxisAttr->Get(SCHATTR_TEXT_ORIENT)).GetValue();

	Size aMaxValueSizeY = pChartYAxis->CalcMaxTextSize(eValueOrient);
	Size aMaxValueSizeX = pChartXAxis->CalcMaxTextSize(eDescrOrient);

	Size aMaxDescrSizeY = CalcMaxDescrSize( TRUE,  eValueOrient, bPercent, CHAXIS_AXIS_Y );
	Size aMaxDescrSizeX = CalcMaxDescrSize( FALSE, eDescrOrient, bPercent, CHAXIS_AXIS_X );

	short   nV, i;

	long   nRowCnt     = bFlatChart
							  ? 1
							  : GetRowCount();
	long   nBackColCnt = (bPartDescr || GetColCount() > 1)
							  ? GetColCount()
							  : GetColCount() + 1;
	long   nColumnCnt  = bPartDescr
							  ? nBackColCnt
							  : nBackColCnt - 1;


	// FG: Diese Variable ist ein reiner Zwischenspeicher damit in der Chartscene bei FitInSnapRect
	//     die Achsentitel gemaess dieses Parameters gesetzt werden koennen.
	bSwitch3DColRow = bSwitchColRow;

	long nMaxTextWidth = 0;

	aXDescrList.Clear();
	aYDescrList.Clear();
	aZDescrList.Clear();

	E3dDefaultAttributes aDefltAttr3D;

	Matrix4D aShift;
	aShift.Translate(-(aSizeVec/500.0));//Wnde etwas verschieben...

	const double fFloorWidth = 100.0;
	const double fWallWith	 = 50.0;	// BM: unused for now
	
	for (nV = 0; nV < 3; nV++)
	{
		switch (nV)
		{
			case 0:         // X-Achse , XY-Ebene (WALL hinten)
			case 1:         // Y-Achse , YZ-Ebene (WALL seitlich)
			{
				aRect3D[0]    = aPos;
				aPos[nV]     += aSizeVec[nV];     //nV=0: X(), sonst Y()
				aRect3D[1]    = aPos;
				aPos[nV + 1] += aSizeVec[nV + 1]; //nV=0: Y(), sonst Z()
				aRect3D[2]    = aPos;
				aPos[nV]     -= aSizeVec[nV];
				aRect3D[3]    = aPos;
				aPos[nV + 1] -= aSizeVec[nV + 1];

				E3dPolygonObj *pWallObj = new SchE3dPolygonObj(aDefltAttr3D, aRect3D);

				pWallObj->SetModel (this);
				pWallObj->InsertUserData(new SchObjectId(CHOBJID_DIAGRAM_WALL));
				rScene.Insert3DObj(pWallObj);

//-/				pWallObj->NbcSetAttributes(*pDiagramWallAttr, FALSE);
				pWallObj->SetItemSet(*pDiagramWallAttr);

				pWallObj->NbcSetTransform(aShift);

				if (!nV)
				{
					// X-Achse zeichnen
					Vector3D aLine3D [2] = { aRect3D [0], aRect3D [1] };

					//#47500#
					if (pXAxisGroup && pChartXAxis->IsVisible())
					{
						Create3DPolyObject (pXAxisAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
							CHOBJID_LINE, pXAxisGroup);
					}

					if( pYGridMainGroup || pYGridHelpGroup )
						// Y-Anteile
						if (bSwitchColRow)
						{
							Vector3D aLine3D [2] = { aRect3D [0], aRect3D [1] };
							long     nStepMainY  = (long) aSizeVec.Y () / nColumnCnt;
							long     nStepHelpY  = nStepMainY / 2;

							// hauptgitter auf der X-Ebene, parallel zur X-Achse
							for (i = 0; i <= nColumnCnt; i++)
							{
								aLine3D[0].Y() =
								aLine3D[1].Y() = aPos.Y() + nStepMainY * i;
								if( pYGridMainGroup )
									Create3DPolyObject (pYGridMainAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
														CHOBJID_DIAGRAM_Y_GRID_MAIN, pYGridMainGroup);

								// hilfsgitter auf der X-Ebene, parallel zur X-Achse
								if (pYGridHelpGroup && (i < nColumnCnt))
								{
									aLine3D [0].Y () += nStepHelpY;
									aLine3D [1].Y () += nStepHelpY;
									Create3DPolyObject (pYGridHelpAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
														CHOBJID_DIAGRAM_Y_GRID_HELP, pYGridHelpGroup);
								}
							}
						}
						else
						{
							aLine3D [0] = aRect3D[0];
							aLine3D [1] = aRect3D[3];

							long nStepMainX  = (long) aSizeVec.X () / nColumnCnt;
							long nStepHelpX  = nStepMainX / 2;

							// hauptgitter auf der X-Ebene, parallel zur Y-Achse
							for (i = 0; i <= nColumnCnt; i++)
							{
								aLine3D[0].X() =
								aLine3D[1].X() = aPos.X() + nStepMainX * i;
								if( pYGridMainGroup )
									Create3DPolyObject (pYGridMainAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
														CHOBJID_DIAGRAM_Y_GRID_MAIN, pYGridMainGroup);

								// hilfsgitter auf der X-Ebene, parallel zur Y-Achse
								if (pYGridHelpGroup && (i < nColumnCnt))
								{
									aLine3D [0].X () += nStepHelpX;
									aLine3D [1].X () += nStepHelpX;
									Create3DPolyObject (pYGridHelpAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
														CHOBJID_DIAGRAM_Y_GRID_HELP, pYGridHelpGroup);
								}
							}
						}
				}
				else
				{
					// Y-Achse zeichnen
					Vector3D aLine3D [2] = { aRect3D [0], aRect3D [1] };

					// Z-Anteile
					//#47500#
					if (pYAxisGroup && pChartYAxis->IsVisible()) Create3DPolyObject (pYAxisAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
														 CHOBJID_LINE, pYAxisGroup);

					// hauptgitter auf der Z-Ebene, parallel zur Z-Achse
					if( pZGridMainGroup || pZGridHelpGroup )
					{
						Vector3D aLine3D [2] = { aRect3D[2], aRect3D[3] };
						long     nStepMainZ  = (long) aSizeVec.Z () / nRowCnt;
						long     nStepHelpZ  = nStepMainZ / 2;

						BOOL bCreateGridLine = ( (aLine3D[ 0 ].X() != aLine3D[ 1 ].X()) ||
												 (aLine3D[ 0 ].Y() != aLine3D[ 1 ].Y()) );
						// Z() values become equal in the for loop
						// => start and end points would be equal if !bCreateGridLine

						for (i = 0; i <= nRowCnt; i++)
						{
							aLine3D[0].Z() =
							aLine3D[1].Z() = aPos.Z() + nStepMainZ * i;
							if( pZGridMainGroup && bCreateGridLine )
								Create3DPolyObject( pZGridMainAttr, new SchE3dPolygonObj( aDefltAttr3D, aLine3D[0], aLine3D[1] ),
													CHOBJID_DIAGRAM_Z_GRID_MAIN, pZGridMainGroup );

							// hilfsgitter auf der Z-Ebene, parallel zur Z-Achse
							if (pZGridHelpGroup && (i < nRowCnt))
							{
								aLine3D[0].Z() += nStepHelpZ;
								aLine3D[1].Z() += nStepHelpZ;
								if( bCreateGridLine )
									Create3DPolyObject( pZGridHelpAttr, new SchE3dPolygonObj( aDefltAttr3D, aLine3D[0], aLine3D[1] ),
														CHOBJID_DIAGRAM_Z_GRID_HELP, pZGridHelpGroup );
							}
						}
					}
				}

				Vector3D   aLine3D [2] = { aRect3D[0], aRect3D[(nV || !nV && bSwitchColRow)
																   ? 3
																   : 1] };
				double     fAct        = fMinValueY;

				SfxItemSet aYTextAttr ((const SfxItemSet &) *pYAxisAttr);
				aYTextAttr.Put(XLineStyleItem (XLINE_NONE));
				aYTextAttr.Put(XLineWidthItem (0));

				// create Y grid. Attention: Some variables are called XGrid...
				if (fMinValueY != fMaxValueY)
					while (fAct <= fMaxValueY)
					{
						double fFact = pChartYAxis->CalcFact(fAct);

						if (bSwitchColRow)
						{
							// create major gridline
							aLine3D[0].X() = aLine3D[1].X() = fFact * aSizeVec.X();

							if (pXGridMainGroup)
								Create3DPolyObject(pXGridMainAttr, new SchE3dPolygonObj(aDefltAttr3D,
								aLine3D[0], aLine3D[1]),CHOBJID_DIAGRAM_X_GRID_MAIN,pXGridMainGroup);

							if (pYAxisGroup && pChartYAxis->HasDescription() && nV)
							{
								Color *pTextColor = NULL;
								SvxColorItem *pOldTextColor = NULL;

								pNumFormatter->GetOutputString((bPercent)?fAct/100.0:fAct,
									GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,bPercent), aNumStr, &pTextColor);

								if( pTextColor )			// BM #60999#
								{
									pOldTextColor = (SvxColorItem*)(aYTextAttr.GetItem( EE_CHAR_COLOR ));
									aYTextAttr.Put(SvxColorItem( *pTextColor ));
								}

								SdrTextObj *pTextObj = CreateTextObj(CHOBJID_TEXT, Point (),aNumStr,
									aYTextAttr, FALSE,CHADJUST_TOP_RIGHT);
								
								if( pOldTextColor )
								{
									aYTextAttr.Put( *pOldTextColor );
								}

								E3dLabelObj *pE3DLabel = new E3dLabelObj(aLine3D[1],pTextObj);
								aYDescrList.Insert(pE3DLabel,LIST_APPEND);
							}
						}
						else
						{
							// create major gridline
							aLine3D[0].Y() = aLine3D[1].Y() = fFact * aSizeVec.Y();

							if(pXGridMainGroup)
								Create3DPolyObject(pXGridMainAttr,new SchE3dPolygonObj(aDefltAttr3D,
								aLine3D[0],aLine3D[1]),CHOBJID_DIAGRAM_X_GRID_MAIN, pXGridMainGroup);
							// Y-Achsenwerte
							if (pYAxisGroup && pChartYAxis->HasDescription() && nV)
							{
								Color *pTextColor = NULL;
								SvxColorItem *pOldTextColor = NULL;

								pNumFormatter->GetOutputString((bPercent)?fAct/100.0:fAct,
									GetNumFmt(CHOBJID_DIAGRAM_Y_AXIS,bPercent), aNumStr, &pTextColor);

								if( pTextColor )			// BM #60999#
								{
									pOldTextColor = (SvxColorItem*)(aYTextAttr.GetItem( EE_CHAR_COLOR ));
									aYTextAttr.Put(SvxColorItem( *pTextColor ));
								}

								// erzeuge das 3D-textobjekt
								SdrTextObj *pTextObj = CreateTextObj(CHOBJID_TEXT, Point (),
									aNumStr,
									aYTextAttr, FALSE,CHADJUST_CENTER_RIGHT);

								if( pOldTextColor )
								{
									aYTextAttr.Put( *pOldTextColor );
								}

								E3dLabelObj *pE3DLabel = new E3dLabelObj(aLine3D [1],pTextObj);
								aYDescrList.Insert(pE3DLabel,LIST_APPEND);
							}

						}

						IncValue(fAct, fValueStepMainY, bYLogarithm);
					}

				fAct = fMinValueY;
				double	fActMain = fAct;	//	This is used for calculating the positions of main grid lines.
				
				if (pXGridHelpGroup && (fMinValueY != fMaxValueY))
				{
					IncValue(fAct, fValueStepHelpY, FALSE);
					if (bSwitchColRow)
					{
						for (;;)
						{
							double fPos = pChartYAxis->CalcFact(fAct ) * aSizeVec.X();
							if (fPos > aSizeVec.X()) break;

							//	If there is a main grid then ommit creating help grid lines coinciding with main grid lines.
							if (pXGridMainGroup)
							{
								//	Advance main raw y position to at least the raw help position.
								while (fActMain < fAct-EPSILON)
									IncValue(fActMain, fValueStepMainY, bYLogarithm);
								//	If both positions fall together, then do not create the help line and try the next position.
								if (fabs(fAct - fActMain) < EPSILON)
								{
									IncValue(fAct, fValueStepHelpY, FALSE);
									continue;
								}
							}

							aLine3D[0].X() =
							aLine3D[1].X() = fPos;
							Create3DPolyObject (pXGridHelpAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
												CHOBJID_DIAGRAM_X_GRID_HELP, pXGridHelpGroup);

							//	In case of a help grid with a main grid, draw only every other line.
							IncValue(fAct, fValueStepHelpY, FALSE);
						}
					}
					else
					{
						for (;;)
						{
							double fPos = pChartYAxis->CalcFact(fAct ) * aSizeVec.Y();
							if (fPos > aSizeVec.Y()) break;

							//	If there is a main grid then ommit creating help grid lines coinciding with main grid lines.
							if (pXGridMainGroup)
							{
								//	Advance main raw y position to at least the raw help position.
								while (fActMain < fAct-EPSILON)
									IncValue(fActMain, fValueStepMainY, bYLogarithm);
								//	If both positions fall together, then do not create the help line and try the next position.
								if (fabs(fAct - fActMain) < EPSILON)
								{
									IncValue(fAct, fValueStepHelpY, FALSE);
									continue;
								}
							}

							aLine3D[0].Y() =
							aLine3D[1].Y() = fPos;
							Create3DPolyObject (pXGridHelpAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
												CHOBJID_DIAGRAM_X_GRID_HELP, pXGridHelpGroup);

							//	In case of a help grid with a main grid, draw only every other line.
							IncValue(fAct, fValueStepHelpY, FALSE);
						}
					}
				}
				break;
			}

			case 2:		// floor
			{
				// BM: create 'thick' floor
				Rectangle aRect( 0, 0, (long)aSizeVec.X(), (long)aSizeVec.Z() );
				PolyPolygon aPolyPolygon;
				Polygon aPoly( aRect );
				aPolyPolygon.Insert( aPoly );

				E3dExtrudeObj* pFloorObj = new SchE3dExtrudeObj( aDefltAttr3D, aPolyPolygon, fFloorWidth );
				Matrix4D aMatrix;
				aMatrix.RotateX( 90.0 * F_PI180 );
				aMatrix.TranslateZ( aSizeVec.Z() );
				aMatrix.Translate( aPos );

				pFloorObj->SetModel( this );
				pFloorObj->InsertUserData( new SchObjectId( CHOBJID_DIAGRAM_FLOOR ) );
				rScene.Insert3DObj( pFloorObj );

//-/				pFloorObj->NbcSetAttributes( *pDiagramFloorAttr, FALSE );
				pFloorObj->SetItemSet(*pDiagramFloorAttr);

				pFloorObj->NbcSetTransform( aMatrix * aShift );

				Vector3D aEndPos( aPos );
				aEndPos.Z() += aSizeVec.Z();

				Vector3D aLine3D [2] = { aPos, aEndPos };

				SfxItemSet aXTextAttr ((const SfxItemSet &) *pXAxisAttr);
				aXTextAttr.Put(XLineStyleItem (XLINE_NONE));
				aXTextAttr.Put(XLineWidthItem (0));

				//#47500#
				if (pZAxisGroup && pChartZAxis->IsVisible()) Create3DPolyObject( pZAxisAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
																				 CHOBJID_LINE, pZAxisGroup );

				if (bSwitchColRow)
				{
					long nStepMainY  = (long) aSizeVec.Y () / nColumnCnt;
					long nStepHelpY  = nStepMainY / 2;

					for (i = 0; i <= nColumnCnt; i++)
					{
						// erzeuge hilfslinie
						aLine3D[0].Y() =
						aLine3D[1].Y() = aPos.Y() + nStepMainY * i;

						if (pYGridMainGroup) Create3DPolyObject (pYGridMainAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
																 CHOBJID_DIAGRAM_Y_GRID_MAIN, pYGridMainGroup);

						if ((i < nColumnCnt) && pXAxisGroup && pChartXAxis->HasDescription())
						{
							// bei tiefen diagrammtypen muessen die beschriftungen auf halbem abstand
							// untergebracht sein
							Vector3D aTextPos = aLine3D[1];

							if (bPartDescr) aTextPos.Y() += nStepHelpY / 2;


							SdrTextObj *pTextObj = CreateTextObj(CHOBJID_TEXT,
								Point (),ColText(i),
								aXTextAttr, FALSE,CHADJUST_CENTER_RIGHT);
							E3dLabelObj *pE3DLabel = new E3dLabelObj
								(aTextPos,pTextObj );
							pE3DLabel->SetMarkProtect(TRUE);
							aXDescrList.Insert(pE3DLabel,LIST_APPEND);
						}

						// hilfslinien koennen mit erzeugt werden
						if (pYGridHelpGroup && (i < nColumnCnt))
						{
							aLine3D[0].Y() += nStepHelpY;
							aLine3D[1].Y() += nStepHelpY;
							Create3DPolyObject (pYGridHelpAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
												CHOBJID_DIAGRAM_Y_GRID_HELP, pYGridHelpGroup);
						}
					}
				}
				else
				{
					long nStepMainX  = (long) aSizeVec.X () / nColumnCnt;
					long nStepHelpX  = nStepMainX / 2;

					for (i = 0; i <= nColumnCnt; i++)
					{
						// erzeuge hilfslinie
						aLine3D[0].X() =
						aLine3D[1].X() = aPos.X() + nStepMainX * i;

						if (pYGridMainGroup) Create3DPolyObject (pYGridMainAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
																 CHOBJID_DIAGRAM_Y_GRID_MAIN, pYGridMainGroup);

						if ((i < nColumnCnt) && pXAxisGroup && pChartXAxis->HasDescription())
						{
							// bei tiefen diagrammtypen muessen die beschriftungen auf halbem abstand
							// untergebracht sein
							Vector3D aTextPos = aLine3D[1];

							if (bPartDescr) aTextPos.X() += nStepHelpX;


							SdrTextObj *pTextObj = CreateTextObj(CHOBJID_TEXT,
								Point (),ColText(i),
								aXTextAttr, FALSE,CHADJUST_TOP_RIGHT);
							E3dLabelObj *pE3DLabel = new E3dLabelObj (aTextPos,pTextObj );
							pE3DLabel->SetMarkProtect(TRUE);
							aXDescrList.Insert(pE3DLabel,LIST_APPEND);
						}

						// hilfslinien koennen mit erzeugt werden
						if (pYGridHelpGroup && (i < nColumnCnt))
						{
							aLine3D[0].X() += nStepHelpX;
							aLine3D[1].X() += nStepHelpX;
							Create3DPolyObject (pYGridHelpAttr, new SchE3dPolygonObj (aDefltAttr3D, aLine3D[0], aLine3D[1]),
												CHOBJID_DIAGRAM_Y_GRID_HELP, pYGridHelpGroup);
						}
					}
				}

				aLine3D[ 0 ] =
				aLine3D[ 1 ] = aEndPos;
				aLine3D[ 1 ].X() += aSizeVec.X();
				
				SfxItemSet aZTextAttr ((const SfxItemSet &) *pZAxisAttr);
				aZTextAttr.Put(XLineStyleItem (XLINE_NONE));
				aZTextAttr.Put(XLineWidthItem (0));

				long nStepMainZ = (long) aSizeVec.Z () / nRowCnt;
				long nStepHelpZ = nStepMainZ / 2;

				BOOL bCreateGridLine = ( (aLine3D[ 0 ].X() != aLine3D[ 1 ].X()) ||
										 (aLine3D[ 0 ].Y() != aLine3D[ 1 ].Y()) );
				// Z() values become equal in the for loop
				// => start and end points would be equal

				for (i = 0; i <= nRowCnt; i++)
				{
					// create main gridline
					aLine3D[0].Z() =
					aLine3D[1].Z() = aPos.Z() + nStepMainZ * i;

					if( pZGridMainGroup && bCreateGridLine )
						Create3DPolyObject( pZGridMainAttr, new SchE3dPolygonObj( aDefltAttr3D, aLine3D[ 0 ], aLine3D[ 1 ] ),
											CHOBJID_DIAGRAM_Z_GRID_MAIN, pZGridMainGroup );

					// bei tiefen diagrammtypen muessen die beschriftungen auf halbem abstand
					// untergebracht sein
					Vector3D aTextPos = aLine3D[1];

					if (bPartDescr) aTextPos.Z () += nStepHelpZ;

					if ((i < nRowCnt) && (nRowCnt > 1) && pZAxisGroup && pChartZAxis->HasDescription())
					{

						SdrTextObj *pTextObj=CreateTextObj(CHOBJID_TEXT, Point (),
							RowText(nRowCnt - 1 - i), aZTextAttr,
							FALSE, CHADJUST_TOP_LEFT) ;

						E3dLabelObj *pE3DLabel = new E3dLabelObj(aTextPos,pTextObj);
						pE3DLabel->SetMarkProtect(TRUE);
						aZDescrList.Insert(pE3DLabel,(ULONG)0);//ZListe umgekehrt fllen
					}

					if (pZGridHelpGroup && (i < nRowCnt))
					{
						aLine3D[0].Z() += nStepHelpZ;
						aLine3D[1].Z() += nStepHelpZ;
						if( pZGridHelpGroup && bCreateGridLine )
							Create3DPolyObject( pZGridHelpAttr, new SchE3dPolygonObj( aDefltAttr3D, aLine3D[0], aLine3D[1] ),
												CHOBJID_DIAGRAM_Z_GRID_HELP, pZGridHelpGroup );
					}
				}

				break;
			}
		}
	}

	pScene->InsertAllTitleText (aXDescrList, pXAxisGroup,SCH_AXIS_ID_X);
	pScene->InsertAllTitleText (aYDescrList, pYAxisGroup,SCH_AXIS_ID_Y);
	pScene->InsertAllTitleText (aZDescrList, pZAxisGroup,SCH_AXIS_ID_Z);

	if (pXGridHelpGroup) rScene.Insert3DObj(pXGridHelpGroup);
	if (pYGridHelpGroup) rScene.Insert3DObj(pYGridHelpGroup);
	if (pZGridHelpGroup) rScene.Insert3DObj(pZGridHelpGroup);
	if (pXGridMainGroup) rScene.Insert3DObj(pXGridMainGroup);
	if (pYGridMainGroup) rScene.Insert3DObj(pYGridMainGroup);
	if (pZGridMainGroup) rScene.Insert3DObj(pZGridMainGroup);
	if (pXAxisGroup) rScene.Insert3DObj(pXAxisGroup);
	if (pYAxisGroup) rScene.Insert3DObj(pYAxisGroup);
	if (pZAxisGroup) rScene.Insert3DObj(pZAxisGroup);

	//TVM: aus FitInSnapRect
	//TVM: Bound statt Logic
	Position3DAxisTitles(rScene.GetBoundRect());
}

/*************************************************************************
|*
|* tiefes 3D-Diagramme erzeugen
|*
\************************************************************************/

SdrObjGroup* ChartModel::Create3DDeepChart(Rectangle &rRect)
{
	const long nGapWidth = 10;

	pScene = CreateScene (rRect, *aLightVec, fSpotIntensity, aSpotColor,
						  fAmbientIntensity, aAmbientColor);

	Vector3D	aTextPos3D;
	Polygon3D   aRect3D(4);
	Polygon3D   aTriangle3D(3);
	Polygon3D	aFrontSide;
	Polygon3D	aBackSide;
	BOOL        bSwitchColRow  = IsBar();
	E3dDefaultAttributes aDefltAttr3D;

	CreateAndInsert3DAxesTitles (rRect, bSwitchColRow);

	long	nX      = 0;
	long	nY      = 0;
	long	nW      = FIXED_SIZE_FOR_3D_CHART_VOLUME;
	long	nH      = FIXED_SIZE_FOR_3D_CHART_VOLUME;
	long    nZ      = (FIXED_SIZE_FOR_3D_CHART_VOLUME * 4) / 6;
	long	nColCnt = GetColCount();
	long	nRowCnt = GetRowCount();
	short	nCol, nRow;

	Polygon     aFrontExtrude(1+nColCnt*2);

	long nGapX      = nW * nGapWidth / 1000;
	long nGapY      = nH * nGapWidth / 1000;
	long nGapZ      = nZ * nGapWidth / 1000;
	long nPartDepth = nZ / nRowCnt;
	long nPartWidth;
	long nBarWidthX;
	long nBarWidthZ = nPartDepth - nGapZ * 2;

	BOOL bLogarithm = ((const SfxBoolItem&) pChartYAxis->GetItemSet()->Get(SCHATTR_AXIS_LOGARITHM)).GetValue();

	BOOL bPartDescr;
	long nDepth = ((eChartStyle == CHSTYLE_3D_BAR) ||
				   (eChartStyle == CHSTYLE_3D_COLUMN) ||
				   (eChartStyle == CHSTYLE_3D_STRIPE) ||
				   (eChartStyle == CHSTYLE_3D_AREA))
					  ? -nZ
					  : nPartDepth;

	nPartWidth	= (eChartStyle == CHSTYLE_3D_BAR)
					  ? nH / nColCnt
					  : ((eChartStyle == CHSTYLE_3D_COLUMN)
							 ? nW / nColCnt
							 : ((nColCnt > 1)
									? nW / (nColCnt - 1)
									: nW / nColCnt));
	nBarWidthX	= (eChartStyle == CHSTYLE_3D_BAR)
					  ? nPartWidth - nGapY * 2
					  : nPartWidth - nGapX * 2;
	bPartDescr	= TRUE;

	Camera3D aCam(pScene->GetCamera());
	Vector3D aCamPos(nX + nW/2, nH/2, nW/2);
	Vector3D aLookAt(nX + nW/2, nH/2, nDepth/2);
	aCam.SetViewWindow(-nW/2, -nH/2, nW, nH);
	aCam.SetDefaults(aCamPos, aLookAt, 80, DEG2RAD(-(double)nZAngle / 10.0));
	aCam.Reset();
	aCam.SetProjection(eProjection);
	aCam.RotateAroundLookAt(DEG2RAD((double)nYAngle / 10.0), DEG2RAD((double)nXAngle / 10.0));
	aCam.SetAspectMapping(AS_HOLD_SIZE);
	pScene->SetCamera(aCam);

	nY = 0;

	Vector3D a3DPos(nX, nY, nDepth);
	Vector3D a3DSize(nW, nH, -nDepth);

	Create3DBackplanes(rRect, a3DPos, a3DSize, *pScene,
					   bPartDescr, FALSE, bLogarithm, FALSE, CHSTACK_NONE, FALSE, FALSE,
					   bSwitchColRow);

	nY     = (long)(pChartYAxis->CalcFactOrigin() * nH);
	a3DPos = Vector3D(0, nY, nDepth - nBarWidthZ + nPartDepth - nGapZ);

	DataDescription aDescription;

	for (nRow = nRowCnt-1; nRow >= 0; nRow--)
	{
		E3dScene* pStripe   = NULL;
		E3dScene* pRowGroup = Create3DScene (CHOBJID_DIAGRAM_ROWGROUP);
        // #102789# some unset attributes may be propagated to the
        // top-level scene
        pRowGroup->SetItemSet( pScene->GetItemSet() );

		pRowGroup->InsertUserData(new SchDataRow(nRow));
		pScene->Insert3DObj(pRowGroup);

		if ( eChartStyle == CHSTYLE_3D_STRIPE )
			pStripe = pRowGroup;

		a3DPos.X() = nX;
		a3DPos.Y() = nY;

		switch(eChartStyle)
		{
			case  CHSTYLE_3D_COLUMN:

				a3DPos.X() += nGapX;
				break;

			case CHSTYLE_3D_BAR:

				// #67333# the y axis of bar charts is not interrested in negative values
				a3DPos.Y() = nGapY; // += nGapY;
				break;

			default:

				aBackSide[0]       = a3DPos;
				aFrontSide[0]      = a3DPos;
				aFrontSide[0].Z() += nBarWidthZ;

				aFrontExtrude[0]   =Point((long)a3DPos.X(),(long)-a3DPos.Y());
				break;
		}

		Vector3D aLastValue;
		short     nPoints = 0;

		for (nCol = 0; nCol < nColCnt; nCol++)
		{
			double fData = GetData(nCol, nRow);

			SfxItemSet aDataPointAttr(GetFullDataPointAttr(nCol, nRow));

			SvxChartDataDescr eDescr = ((const SvxChartDataDescrItem&)aDataPointAttr.
										  Get(SCHATTR_DATADESCR_DESCR)).GetValue();

			BOOL bShowDataDescrLocal = (eDescr != CHDESCR_NONE) && bShowDataDescr && // bShowDataDescr is class member
                fData != DBL_MIN;
			if( bShowDataDescrLocal )
			{
				/**************************************************************
				* DataDescription erforderlich
				**************************************************************/
				
				aDescription.eDescr = eDescr;
				aDescription.bSymbol = ((const SfxBoolItem&)aDataPointAttr.
											  Get(SCHATTR_DATADESCR_SHOW_SYM)).GetValue();
			}

			if (eChartStyle == CHSTYLE_3D_COLUMN)
			{
				double fTop, fBottom;
				if (fData < fOriginY)
				{
					fTop	= fOriginY;
					fBottom = fData;
				}
				else
				{
					fTop	= fData;
					fBottom	= fOriginY;
				}

				long nTop =	Min((long)(pChartYAxis->CalcFact(fTop) * nH), nH);
				long nBottom = Max((long)(pChartYAxis->CalcFact(fBottom) * nH), 0L);

				if( fData != DBL_MIN )
				{
					long nBarHeight = nTop - nBottom + 1;
					a3DPos.Y() = nBottom;

                    if( nTop > nBottom )
                        pRowGroup->Insert3DObj(Create3DBar(a3DPos, Vector3D(nBarWidthX, nBarHeight, nBarWidthZ), nCol, nRow,
                                                           aDataPointAttr, FALSE,0,pChartYAxis->CalcFactOrigin()*(double)nH,0));

					if( bShowDataDescrLocal )
					{
						aDescription.aTextPos3D      = a3DPos;
						aDescription.aTextPos3D.X() += nBarWidthX / 2;
						aDescription.aTextPos3D.Y() += (fData<0)? 0: nBarHeight;
						aDescription.aTextPos3D.Z() += nBarWidthZ / 2;
						aDescription.fValue          = GetData(nCol, nRow,		// #67378#
							((aDescription.eDescr == CHDESCR_PERCENT) ||
							 (aDescription.eDescr == CHDESCR_TEXTANDPERCENT)) );
						aDescription.eAdjust         = CHADJUST_CENTER_CENTER;
					}
				}
				else if (bShowDataDescrLocal)
				{
					aDescription.fValue = DBL_MIN;
				}
			}
			else if (eChartStyle == CHSTYLE_3D_BAR)
			{
				double fRight, fLeft;
				if (fData < fOriginY)
				{
					fRight	= fOriginY;
					fLeft  = fData;
				}
				else
				{
					fRight = fData;
					fLeft	= fOriginY;
				}

				long nRight = Min((long)(pChartYAxis->CalcFact(fRight) * nW), nW);
				long nLeft  = Max((long)(pChartYAxis->CalcFact(fLeft) * nW), 0L);

                if( fData != DBL_MIN )
                {
					long nBarWidth = nRight - nLeft + 1;
					a3DPos.X() = nLeft;

                    if( nRight > nLeft )
                        pRowGroup->Insert3DObj(Create3DBar(a3DPos, Vector3D(nBarWidth, nBarWidthX, nBarWidthZ), nCol, nRow,
                                                           aDataPointAttr,FALSE,0,pChartYAxis->CalcFactOrigin()*(double)nW,0));

					if (bShowDataDescrLocal)
					{
						aDescription.aTextPos3D      = a3DPos;

						// #67379# corrected orientation of description
						aDescription.aTextPos3D.X() += (fData<0)? 0: nBarWidth;
						aDescription.aTextPos3D.Y() += nBarWidthX / 2;
						aDescription.aTextPos3D.Z() += nBarWidthZ / 2;
	
						aDescription.fValue          = GetData(nCol, nRow,		// #67378#
															   ((aDescription.eDescr == CHDESCR_PERCENT) ||
																(aDescription.eDescr == CHDESCR_TEXTANDPERCENT)) );
						aDescription.eAdjust         = CHADJUST_CENTER_CENTER;
					}
				}
				else if (bShowDataDescrLocal)
				{
					aDescription.fValue = DBL_MIN;
				}
			}
			else
			{
				long nPos = (long)(pChartYAxis->CalcFact(fData ) * nH);
				if (nPos < 0L) nPos = 0L;
				else if (nPos > nH) nPos = nH;

				const SfxItemSet& rDataRowAttr = GetDataRowAttr(nRow);

				a3DPos.Y() = nPos;

				switch (eChartStyle)
				{
					case CHSTYLE_3D_STRIPE:
					case CHSTYLE_3D_AREA:
						{
							UINT16 nRev       = nColCnt + 1 - nPoints;
							BOOL  bValidData = TRUE;

							if ((eChartStyle == CHSTYLE_3D_AREA) && (fData == DBL_MIN))
							{
								fData      = 0.0;
								bValidData = FALSE;
							}

							if (fData != DBL_MIN)
							{
								//Stripes:
								aFrontSide[nRev]      = a3DPos;
								aFrontSide[nRev].Z() += nBarWidthZ;
								aBackSide[nPoints]    = a3DPos;
								//Area:
								aFrontExtrude[nRev]  = Point((long)a3DPos.X(),(long)-a3DPos.Y());

								if (!nPoints)
								{
									//Stripes:
									aFrontSide[0]          = a3DPos;
									aFrontSide[0].Y()      = 0;
									aFrontSide[0].Z()     += nBarWidthZ;
									aBackSide[nColCnt + 1] = aFrontSide[0];
									//Area:
									aFrontExtrude[0].X() =  (long)a3DPos.X();
									aFrontExtrude[0].Y() =  0;
								}
								else if(eChartStyle == CHSTYLE_3D_STRIPE)
								{
									if (nColCnt > 1)
									{
										// deckel
										aRect3D[0] = aBackSide[nPoints - 1];
										aRect3D[1] = aFrontSide[nRev + 1];
										aRect3D[2] = aFrontSide[nRev];
										aRect3D[3] = aBackSide[nPoints];
										E3dPolygonObj *pPolyObj=new SchE3dPolygonObj (aDefltAttr3D, aRect3D);

//-/										pPolyObj->SetDoubleSided(TRUE); //Neu 18.5.98
										pPolyObj->SetItem(Svx3DDoubleSidedItem(TRUE)); //Neu 18.5.98
										
										Create3DPolyObject (&rDataRowAttr,pPolyObj,CHOBJID_AREA, pStripe);
									}
								}
								nPoints ++;
							}
							else bValidData = FALSE;

							if (nPoints && (eChartStyle==CHSTYLE_3D_AREA) && (nCol==nColCnt-1))
							{
								Vector3D aFill = (fData == DBL_MIN) ? aLastValue : a3DPos;
								for (short nFill = nPoints;nFill <= nColCnt;nFill ++)
								{
									//aFrontSide wird noch fr die Beschriftung gebraucht
									aFrontSide[nColCnt+1-nFill]=aFill;
									aFrontSide[nColCnt+1-nFill].Y()=0;
									aFrontSide[nColCnt+1-nFill].Z() += nBarWidthZ;
									aFrontExtrude[nColCnt+1-nFill]=Point((long)aFill.X(),0);
								}

								if (nColCnt > 1)
								{
									PolyPolygon aPolyPoly;
									aFrontExtrude[nColCnt*2]=aFrontExtrude[0];
									aPolyPoly.Insert(aFrontExtrude);
									E3dExtrudeObj* pExtrudeObj= new SchE3dExtrudeObj(aDefltAttr3D, aPolyPoly, nBarWidthZ);
									Matrix4D aMatrix;
									aMatrix.Translate(Vector3D(0,0,a3DPos.Z() ));   //nDepth - nBarWidthZ + nPartDepth - nGapZ
									pExtrudeObj->NbcSetTransform(aMatrix);
									Create3DExtrudePolyObj(&rDataRowAttr,pExtrudeObj,CHOBJID_AREA,pRowGroup);
								}
							}    //Area

							if (fData == DBL_MIN) nPoints = 0;

							if (bShowDataDescrLocal)
							{
								aDescription.aTextPos3D = aFrontSide[nRev];

								if (bValidData)
								{
									if ((aDescription.eDescr == CHDESCR_PERCENT) ||
										(aDescription.eDescr == CHDESCR_TEXTANDPERCENT))
									{
										aDescription.fValue = GetData (nCol, nRow, TRUE, TRUE);
									}
									else
									{
										aDescription.fValue = GetData (nCol, nRow);
									}
								}
								else
								{
									aDescription.fValue = DBL_MIN;
								}

								aDescription.eAdjust = CHADJUST_CENTER_CENTER;
							}

							break;
						}

					case CHSTYLE_3D_SURFACE:
						if (nColCnt > 1)
						{
							aTriangle3D[0] = a3DPos;
							aTriangle3D[1] = a3DPos;
							aTriangle3D[1].Z() += nPartDepth;
							aTriangle3D[1].Y() =
								(long)(pChartYAxis->CalcFact(GetData(nCol, nRow-1)) * nH);
							aTriangle3D[2] = aTriangle3D[1];
							aTriangle3D[2].X() += nPartWidth;
							aTriangle3D[2].Y() =
								(long)(pChartYAxis->CalcFact(GetData(nCol+1, nRow-1)) * nH);
							aTriangle3D[3] = aTriangle3D[2];
							aTriangle3D[3].Z() -= nPartDepth;
							aTriangle3D[3].Y() =
								(long)(pChartYAxis->CalcFact(GetData(nCol+1, nRow)) * nH);

							Create3DPolyObject (&rDataRowAttr, new SchE3dPolygonObj (aDefltAttr3D, aTriangle3D, TRUE, TRUE),
												CHOBJID_AREA, pRowGroup);

							aTriangle3D[0] = aTriangle3D[1];
							aTriangle3D[1] = aTriangle3D[2];
							aTriangle3D[2] = a3DPos;
							Create3DPolyObject (&rDataRowAttr, new SchE3dPolygonObj (aDefltAttr3D, aTriangle3D, TRUE, TRUE),
												CHOBJID_AREA, pRowGroup);
						}
						break;
				}
			}

			aLastValue = a3DPos;
			if (eChartStyle == CHSTYLE_3D_BAR) a3DPos.Y() += nPartWidth;
			else a3DPos.X() += nPartWidth;

			if( pScene && bShowDataDescrLocal )
			{
				CreateDataDescr( aDescription, nCol, nRow, NULL, FALSE, TRUE );
				aDescription.pLabelObj->SetMarkProtect( TRUE );
				E3dLabelObj* pLabel = new E3dLabelObj( aDescription.aTextPos3D,
													   aDescription.pLabelObj );
				pLabel->SetMarkProtect(TRUE);
				pScene->Insert3DObj(pLabel);
			}

		}// end for nCol

		/*Dirty3D (nColCnt, nRow, TRUE, pDescription, (eDataDescr != CHDESCR_NONE) && bShowDataDescr
																			 ? pScene
																			 : NULL);
		*/
		a3DPos.Z() += nPartDepth;
	}//end for nRow

	return (SdrObjGroup*) pScene;
}

/*************************************************************************
|*
|* flache 3D-Diagramme erzeugen
|*
\************************************************************************/

SdrObjGroup* ChartModel::Create3DFlatChart(Rectangle &rRect)
{
	const long nGapWidth = 10;

	pScene = CreateScene (rRect, *aLightVec, fSpotIntensity, aSpotColor,
						  fAmbientIntensity, aAmbientColor);

	Vector3D	aTextPos3D;

	Polygon3D	aFrontSide;

	BOOL       bSwitchColRow   = IsBar();
	E3dDefaultAttributes aDefltAttr3D;

	CreateAndInsert3DAxesTitles (rRect, bSwitchColRow);

	BOOL bPercent = IsPercent();


	USHORT eStackMode;
	switch (eChartStyle)
	{
		case CHSTYLE_3D_STACKEDFLATCOLUMN:
		case CHSTYLE_3D_PERCENTFLATCOLUMN:
		case CHSTYLE_3D_STACKEDFLATBAR:
		case CHSTYLE_3D_PERCENTFLATBAR:
			eStackMode = CHSTACK_MINMAX;
			break;

		case CHSTYLE_3D_STACKEDAREA:
		case CHSTYLE_3D_PERCENTAREA:
			eStackMode = CHSTACK_OVERLAP;
			break;

		default:
			eStackMode = CHSTACK_NONE;
			break;
	}

	long	nX = 0;
	long	nY = 0;
	long	nW = FIXED_SIZE_FOR_3D_CHART_VOLUME;
	long	nH = FIXED_SIZE_FOR_3D_CHART_VOLUME;
	long	nColCnt = GetColCount();
	long	nRowCnt = GetRowCount();
	long	nCol, nRow;

	long nGapX      = nW * nGapWidth / 1000;
	long nGapY      = nH * nGapWidth / 1000;
	long nGapZ      = nW * nGapWidth / 1000;
	long nPartDepth = nW / nRowCnt;
	long nPartWidth;
	long nColWidthX;
	long nBarWidthX;
	long nBarWidthZ = nPartDepth - nGapZ * 2;
	long nDepth     = -nPartDepth;

	SfxItemSet* pYAxisAttr = pChartYAxis->GetItemSet();
//	BOOL bLogarithm = ((const SfxBoolItem&) pYAxisAttr->Get(SCHATTR_Y_AXIS_LOGARITHM)).GetValue();
	BOOL bLogarithm = ((const SfxBoolItem&) pYAxisAttr->Get(SCHATTR_AXIS_LOGARITHM)).GetValue();
	BOOL bPartDescr;

	Polygon     aFrontExtrude(1+nColCnt*2);

	switch (eChartStyle)
	{
		case CHSTYLE_3D_STACKEDAREA:
		case CHSTYLE_3D_PERCENTAREA:
		{
			aFrontSide.SetPointCount(nColCnt*2);
			nPartWidth	= nW / ((nColCnt > 1) ? nColCnt - 1 : nColCnt);
			nColWidthX	= 0;
			nBarWidthX	= 0;
			bPartDescr	= FALSE;
			break;
		}
		default:
		{
			nPartWidth	= bSwitchColRow
							  ? nH / nColCnt
							  : nW / nColCnt;
			nColWidthX	= bSwitchColRow
							  ? nPartWidth - nGapY * 2
							  : nPartWidth - nGapX * 2;
			nBarWidthX	= ((eChartStyle == CHSTYLE_3D_FLATCOLUMN) || (eChartStyle == CHSTYLE_3D_FLATBAR))
							  ? nColWidthX / nRowCnt
							  : 0;
			bPartDescr	= TRUE;
			break;
		}
	}

	Camera3D aCam(pScene->GetCamera());
	Vector3D aCamPos(nX + nW/2, nH/2, nW/2);
	Vector3D aLookAt(nX + nW/2, nH/2, nDepth/2);
	aCam.SetViewWindow(-nW/2, -nH/2, nW, nH);
	aCam.SetDefaults(aCamPos, aLookAt, 80, DEG2RAD(-(double)nZAngle / 10.0));
	aCam.Reset();
	aCam.SetProjection(eProjection);
	aCam.RotateAroundLookAt(DEG2RAD((double)nYAngle / 10.0), DEG2RAD((double)nXAngle / 10.0));
	aCam.SetAspectMapping(AS_HOLD_SIZE);
	pScene->SetCamera(aCam);

	nY = 0;
	Vector3D a3DPos(nX, nY, nDepth);
	Vector3D a3DSize(nW, nH, -nDepth);

	Create3DBackplanes(rRect, a3DPos, a3DSize, *pScene,
					   bPartDescr, FALSE, bLogarithm, FALSE, eStackMode, bPercent, TRUE,
					   bSwitchColRow);

	a3DPos = Vector3D(nX, nY, nDepth - nBarWidthZ + nPartDepth - nGapZ);

	switch (eChartStyle)
	{
		case CHSTYLE_3D_STACKEDAREA:
		case CHSTYLE_3D_PERCENTAREA:
		{
			DataDescription* pDescription = NULL;

			double* fOldData = new double[nColCnt];
			a3DPos.Z() += nBarWidthZ;

			for (nRow = 0; nRow < nRowCnt; nRow++)
			{
				E3dScene* pRowGroup = Create3DScene (CHOBJID_DIAGRAM_ROWGROUP);
				pScene->Insert3DObj(pRowGroup);

				pRowGroup->InsertUserData(new SchDataRow((short)nRow));

				const SfxItemSet& rDataRowAttr = GetDataRowAttr(nRow);

				for (nCol = 0; nCol < nColCnt; nCol++)
				{
					double     fData          = fabs(GetData(nCol, nRow, bPercent));
					SfxItemSet aDataPointAttr (GetFullDataPointAttr(nCol, nRow));
					BOOL       bValidData;

					if (fData == DBL_MIN)
					{
						fData      = 0.0;
						bValidData = FALSE;
					}
					else bValidData = TRUE;

					SvxChartDataDescr eDescr = ((const SvxChartDataDescrItem&)aDataPointAttr.
												  Get(SCHATTR_DATADESCR_DESCR)).GetValue();

					if( (eDescr != CHDESCR_NONE) && bShowDataDescr)
					{
						/******************************************************
						* DataDescription erforderlich
						******************************************************/
						if (!pDescription)
						{
							// DataDescription noch nicht vorhanden -> erzeugen
							pDescription = new DataDescription [nColCnt];
							ClearDataDescription(pDescription,nColCnt);
						}

						pDescription [nCol].eDescr = eDescr;
						pDescription [nCol].bSymbol = ((const SfxBoolItem&)aDataPointAttr.
													   Get(SCHATTR_DATADESCR_SHOW_SYM)).GetValue();
					}

					long nRev = nColCnt * 2 - 1 - nCol;

					if (!nRow)
					{
						a3DPos.Y()           = Min((long)(pChartYAxis->CalcFact(fData) * nH), nH);
						aFrontSide[(UINT16)nRev]     = a3DPos;
						aFrontSide[(UINT16)nCol]     = a3DPos;
						aFrontSide[(UINT16)nCol].Y() = 0;
						aFrontExtrude[(UINT16)nRev]  = Point((long)a3DPos.X(),(long)-a3DPos.Y());
						aFrontExtrude[(UINT16)nCol]  = Point((long)a3DPos.X(),(long)-a3DPos.Y());
						aFrontExtrude[(UINT16)nCol].Y()= 0;
					}
					else
					{
						fData = fOldData[nCol] + fData;
						a3DPos.Y() = Min((long)(pChartYAxis->CalcFact(fData) * nH), nH);
						aFrontSide[(UINT16)nCol] = aFrontSide[(UINT16)nRev];
						aFrontSide[(UINT16)nRev] = a3DPos;
						aFrontExtrude[(UINT16)nCol] = aFrontExtrude[(UINT16)nRev];
						aFrontExtrude[(UINT16)nRev]=Point((long)a3DPos.X(),(long)-a3DPos.Y());
					}

					fOldData[nCol] = fData;

					if (pDescription)
					{
						pDescription [nCol].aTextPos3D      = aFrontSide[(UINT16)nRev];
						pDescription [nCol].aTextPos3D.Y() -= (aFrontSide[(UINT16)nRev].Y() - aFrontSide[(UINT16)nCol].Y()) / 2;

						if (bValidData)
						{
							if ((pDescription [nCol].eDescr == CHDESCR_PERCENT) ||
								(pDescription [nCol].eDescr == CHDESCR_TEXTANDPERCENT))
							{
								pDescription [nCol].fValue = GetData (nCol, nRow, TRUE, TRUE);
							}
							else
							{
								pDescription [nCol].fValue = GetData(nCol,nRow,FALSE);//#55586# fData;
							}
						}
						else
						{
							pDescription [nCol].fValue = DBL_MIN;
						}

						pDescription [nCol].eAdjust = CHADJUST_CENTER_CENTER;

						if( eDescr != CHDESCR_NONE && bValidData )
						{
							CreateDataDescr( pDescription[ nCol ], nCol, nRow, NULL, FALSE, TRUE );
							pDescription[ nCol ].pLabelObj->SetMarkProtect( TRUE );
							E3dLabelObj* pLabel=new E3dLabelObj( pDescription[nCol].aTextPos3D,
																 pDescription[nCol].pLabelObj );
							pLabel->SetMarkProtect(TRUE);
							pScene->Insert3DObj(pLabel);
						}
					}

					a3DPos.X() += nPartWidth;
				} //end for nCol

				if (nColCnt > 1)
				{

					PolyPolygon aPolyPoly;
					aFrontExtrude[nColCnt*2]=aFrontExtrude[0];//.SetClosed(TRUE);
					aPolyPoly.Insert(aFrontExtrude);

					E3dExtrudeObj* pExtrudeObj= new SchE3dExtrudeObj(aDefltAttr3D, aPolyPoly,nBarWidthZ);
					Matrix4D aMatrix;
					aMatrix.Translate(Vector3D(0,0,nDepth - nBarWidthZ + nPartDepth - nGapZ ));   //-(double)nBarWidthZ
					pExtrudeObj->NbcSetTransform(aMatrix);
					//#54870# falsche ID:CHOBJID_DIAGRAM_AREA
					Create3DExtrudePolyObj(&rDataRowAttr,pExtrudeObj,CHOBJID_AREA,pRowGroup);
				}
				a3DPos.X() = nX;
			}//end for nRow

			delete[] fOldData;
			delete[] pDescription;
			break;
		}  // end case Area's

		default:
		{
			DataDescription* pDescription = NULL;

			if (bSwitchColRow) a3DPos.Y() += nGapY;
			else a3DPos.X() += nGapX;

			E3dObject *pColGroup = Create3DObject (CHOBJID_DIAGRAM_STACKEDGROUP);

			pScene->Insert3DObj(pColGroup);

			for (nCol = 0; nCol < nColCnt; nCol++)
			{
				double fDataTop		= fOriginY;
				double fDataBottom	= fOriginY;

				//Vor-Berechnung des Maximalen/Minimalen Zeichenpunktes
				double fPreBottom=fOriginY;
				double fPreTop   =fOriginY;
				double fPreTopPos,fPreBottomPos,fPreOriPos;
				double fTop,fBottom,fMin,fMax,fMin2,fMax2;
				fMin2=fMax2=fOriginY;
				for (nRow = 0; nRow < nRowCnt; nRow++)
				{
					double fData=GetData(nCol, nRow, bPercent);
					if (fData != DBL_MIN)
					{
						if (fData < fOriginY)
						{
							fTop = fPreBottom;
							if (fTop == fOriginY)
								fPreBottom = fData;
							else
								fPreBottom += fData;
							fBottom = fPreBottom;
						}
						else
						{
							fBottom = fPreTop;
							if (fBottom == fOriginY)
								fPreTop = fData;
							else
								fPreTop += fData;
							fTop = fPreTop;
						}
					}
					if(nRow)
					{
						if(fTop<fMin)
							fMin=fTop;
						if(fBottom>fMax)
							fMax=fBottom;
					}
					else
					{
						fMin=fTop;
						fMax=fBottom;
					}
					if(fData<fOriginY)
						fMin2-=fData;  //top,left
					else
						fMax2+=fData; //right,bottom
				}

				double fR = (double)( IsBar()? nW: nH );
				fPreTopPos = pChartYAxis->CalcFact( fMin2 ) * fR;
				if( fR < fPreTopPos )
					fPreTopPos = fR;
				fPreBottomPos = pChartYAxis->CalcFact( fMax2 ) * fR;
				if( fPreBottomPos < 0.0 )
					fPreBottomPos = 0.0;
				fPreOriPos = pChartYAxis->CalcFactOrigin() * fR;

				for (nRow = 0; nRow < nRowCnt; nRow++)
				{
					double     fData     = GetData(nCol, nRow, bPercent);
					SfxItemSet aDataPointAttr(GetFullDataPointAttr(nCol, nRow));

					SvxChartDataDescr eDescr = ((const SvxChartDataDescrItem&)aDataPointAttr.
												  Get(SCHATTR_DATADESCR_DESCR)).GetValue();

					if( (eDescr != CHDESCR_NONE) && bShowDataDescr)
					{
						/******************************************************
						* DataDescription erforderlich
						******************************************************/
						if (!pDescription)
						{
							// DataDescription noch nicht vorhanden -> erzeugen
							pDescription = new DataDescription [nRowCnt];
							ClearDataDescription(pDescription,nRowCnt);
						}

						pDescription [nRow].eDescr = eDescr;
						pDescription [nRow].bSymbol = ((const SfxBoolItem&)aDataPointAttr.
													   Get(SCHATTR_DATADESCR_SHOW_SYM)).GetValue();
					}

					E3dScene* pDataGroup = Create3DScene (CHOBJID_DIAGRAM_SPECIAL_GROUP);
					pDataGroup->InsertUserData(new SchDataRow((short)nRow));
					pColGroup->Insert3DObj (pDataGroup);

					switch (eChartStyle)
					{
						case CHSTYLE_3D_FLATCOLUMN:
							if (fData != DBL_MIN)
							{
								double fTop;
								double fBottom;

								if (fData < fOriginY)
								{
									fTop	= fOriginY;
									fBottom = fData;
								}
								else
								{
									fTop	= fData;
									fBottom	= fOriginY;
								}

								long nBottom = Max ((long) (pChartYAxis->CalcFact(fBottom) * nH),0L);
								long nTop =	Min ((long) (pChartYAxis->CalcFact(fTop) * nH),nH);

								{
									long nBarHeight = nTop - nBottom + 1;
									a3DPos.Y() = nBottom;

                                    if (nTop > nBottom)
                                        pDataGroup->Insert3DObj(Create3DBar(a3DPos, Vector3D(nBarWidthX, nBarHeight, nBarWidthZ), nCol, nRow,
                                                                            aDataPointAttr,TRUE,0,fPreOriPos,0));

									if (pDescription)
									{
										pDescription [nRow].aTextPos3D      = a3DPos;
										pDescription [nRow].aTextPos3D.X() += nBarWidthX / 2;
										pDescription [nRow].aTextPos3D.Y() += (fData<0)? 0: nBarHeight;
										pDescription [nRow].aTextPos3D.Z() += nBarWidthZ;

										if ((pDescription [nRow].eDescr == CHDESCR_PERCENT) ||
											(pDescription [nRow].eDescr == CHDESCR_TEXTANDPERCENT))
										{
											pDescription [nRow].fValue = GetData (nCol, nRow, TRUE, TRUE);
										}
										else
										{
											pDescription [nRow].fValue = GetData(nCol,nRow,FALSE);//#55586# fData;
										}

										pDescription [nRow].eAdjust = CHADJUST_CENTER_CENTER;
									}
								}
							}
							else if (pDescription)
							{
								pDescription [nRow].fValue = DBL_MIN;
							}

							a3DPos.X() += nBarWidthX;
							break;

						case CHSTYLE_3D_FLATBAR:
							if (fData != DBL_MIN)
							{
								double fRight;
								double fLeft;

								if (fData < fOriginY)
								{
									fRight	= fOriginY;
									fLeft   = fData;
								}
								else
								{
									fLeft	= fOriginY;
									fRight	= fData;
								}

								long nLeft = Max ((long) (pChartYAxis->CalcFact(fLeft) * nW),0L);
								long nRight = Min ((long)(pChartYAxis->CalcFact(fRight) * nW),nW);

								{
									long nBarWidth = nRight - nLeft + 1;
									a3DPos.X() = nLeft;

                                    if (nRight > nLeft)
                                        pDataGroup->Insert3DObj(Create3DBar(a3DPos, Vector3D(nBarWidth, nBarWidthX, nBarWidthZ), nCol, nRow,
                                                                            aDataPointAttr,TRUE,0,fPreOriPos,0));

									if (pDescription)
									{
										pDescription [nRow].aTextPos3D      = a3DPos;
										pDescription [nRow].aTextPos3D.X() += (fData<0)? 0: nBarWidth;
										pDescription [nRow].aTextPos3D.Y() += nBarWidthX / 2;
										pDescription [nRow].aTextPos3D.Z() += nBarWidthZ;

										if ((pDescription [nRow].eDescr == CHDESCR_PERCENT) ||
											(pDescription [nRow].eDescr == CHDESCR_TEXTANDPERCENT))
										{
											pDescription [nRow].fValue = GetData (nCol, nRow, TRUE, TRUE);
										}
										else
										{
											pDescription [nRow].fValue = GetData(nCol,nRow,FALSE);//#55586# fData;
										}

										pDescription [nRow].eAdjust = CHADJUST_CENTER_CENTER;
									}
								}
							}
							else if (pDescription)
							{
								pDescription [nRow].fValue = DBL_MIN;
							}

							a3DPos.Y() += nBarWidthX;
							break;

						case CHSTYLE_3D_STACKEDFLATCOLUMN:
						case CHSTYLE_3D_PERCENTFLATCOLUMN:
							if (fData != DBL_MIN)
							{
								double fTop;
								double fBottom;

								if (fData < fOriginY)
								{
									fTop = fDataBottom;
									if (fTop == fOriginY) fDataBottom = fData;
									else fDataBottom += fData;
									fBottom = fDataBottom;
								}
								else
								{
									fBottom = fDataTop;
									if (fBottom == fOriginY) fDataTop = fData;
									else fDataTop += fData;
									fTop = fDataTop;
								}

								long nTop =	Min((long)(pChartYAxis->CalcFact(fTop) * nH), nH);
								long nBottom = Max((long)(pChartYAxis->CalcFact(fBottom) * nH),0L);

								{
									long nBarHeight = nTop - nBottom + 1;
									a3DPos.Y() = nBottom;

                                    if (nTop > nBottom)
                                        pDataGroup->Insert3DObj(Create3DBar(a3DPos, Vector3D(nColWidthX, nBarHeight, nBarWidthZ), nCol, nRow,
                                                                            aDataPointAttr,TRUE,fPreBottomPos,fPreOriPos,fPreTopPos));

									if (pDescription)
									{
										pDescription [nRow].aTextPos3D      = a3DPos;
										pDescription [nRow].aTextPos3D.X() += nColWidthX / 2;
										pDescription [nRow].aTextPos3D.Y() += nBarHeight / 2;
										pDescription [nRow].aTextPos3D.Z() += nBarWidthZ;

										if ((pDescription [nRow].eDescr == CHDESCR_PERCENT) ||
											(pDescription [nRow].eDescr == CHDESCR_TEXTANDPERCENT))
										{
											pDescription [nRow].fValue = GetData (nCol, nRow, TRUE, TRUE);
										}
										else
										{
											pDescription [nRow].fValue = GetData(nCol,nRow,FALSE);//#55586# fData;
										}

										pDescription [nRow].eAdjust = CHADJUST_CENTER_CENTER;
									}
								}
							}
							else if (pDescription)
							{
								pDescription [nRow].fValue = DBL_MIN;
							}
							break;

						case CHSTYLE_3D_STACKEDFLATBAR:
						case CHSTYLE_3D_PERCENTFLATBAR:
							if (fData != DBL_MIN)
							{
								double fRight;
								double fLeft;

								if (fData < fOriginY)
								{
									fRight = fDataBottom;
									if (fRight == fOriginY)	fDataBottom = fData;
									else fDataBottom += fData;
									fLeft = fDataBottom;
								}
								else
								{
									fLeft = fDataTop;
									if (fLeft == fOriginY) fDataTop = fData;
									else fDataTop += fData;
									fRight = fDataTop;
								}

								long nRight = Min((long)(pChartYAxis->CalcFact(fRight) * nW), nW);
								long nLeft = Max((long) (pChartYAxis->CalcFact(fLeft ) * nW), 0L);

								{
									long nBarWidth = nRight - nLeft + 1;
									a3DPos.X() = nLeft;

                                    if (nRight > nLeft)
                                        pDataGroup->Insert3DObj(Create3DBar(a3DPos, Vector3D(nBarWidth, nColWidthX, nBarWidthZ), nCol, nRow,
                                                                            aDataPointAttr,TRUE,fPreBottomPos,fPreOriPos,fPreTopPos));

									if (pDescription)
									{
										pDescription [nRow].aTextPos3D      = a3DPos;
										pDescription [nRow].aTextPos3D.X() += nBarWidth / 2;
										pDescription [nRow].aTextPos3D.Y() += nColWidthX  / 2;
										pDescription [nRow].aTextPos3D.Z() += nBarWidthZ;

										if ((pDescription [nRow].eDescr == CHDESCR_PERCENT) ||
											(pDescription [nRow].eDescr == CHDESCR_TEXTANDPERCENT))
										{
											pDescription [nRow].fValue = GetData (nCol, nRow, TRUE, TRUE);
										}
										else
										{
											pDescription [nRow].fValue = GetData(nCol,nRow,FALSE);//#55586# fData;
										}

										pDescription [nRow].eAdjust = CHADJUST_CENTER_CENTER;
									}
								}
							}
							else if (pDescription)
							{
								pDescription [nRow].fValue = DBL_MIN;
							}
							break;
					}
				}

				//Dirty3D (nRowCnt, nCol, TRUE, pDescription, (eDataDescr != CHDESCR_NONE)&& bShowDataDescr
				//																	 ? pScene
				//																	 : NULL);

				// BM: moved here from Dirty3D.
				if( pDescription )
				{
					for (nRow = 0; nRow < nRowCnt; nRow ++)
					{
						if (pScene && pDescription[nRow].fValue != DBL_MIN)
						{
							CreateDataDescr(pDescription[nRow], nCol, nRow, NULL, TRUE, TRUE);
							pDescription[nRow].pLabelObj->SetMarkProtect(TRUE);
							E3dLabelObj* pLabel=new E3dLabelObj( pDescription[nRow].aTextPos3D,
																 pDescription[nRow].pLabelObj );
							pLabel->SetMarkProtect(TRUE);
							pScene->Insert3DObj(pLabel);
						}
					}
				}

				if (bSwitchColRow)
				{
					a3DPos.Y() += nBarWidthX ? nGapY * 2 : nPartWidth;
					a3DPos.X() = 0;
				}
				else
				{
					a3DPos.X() += nBarWidthX ? nGapX * 2 : nPartWidth;
					a3DPos.Y() = 0;
				}
			}

			delete[] pDescription;

			break;
		}
	}

	return (SdrObjGroup*) pScene;
}

/*************************************************************************
|*
|* 3D-Kreisdiagramm erzeugen
|*
\************************************************************************/
void ChartModel::Segment3DDescr (DataDescription &rDescr,
				   const Rectangle &rRect,
				   long            nStartAng,
				   long            nEndAng,
				   long            nHeight,
				   double          a,
				   double          b,
				   double		   fZ)
{
	long nAngleDiff;
	long nAngleHook;

	// bestimme die Winkelhalbierenden des Segments
	nAngleDiff = (nEndAng - nStartAng) / 2;
	nAngleHook = nStartAng + nAngleDiff;
	double fFullAngle = ((double)nAngleHook / 18000.0) * F_PI;

	Vector3D aPnt1(cos(fFullAngle) * (a * 1.1), sin(fFullAngle) * (a * 1.1), fZ);
	Vector3D aPnt2(aPnt1);
	aPnt2.Z() = -aPnt1.Z();
	Vector3D aCenter;

	B3dTransformationSet& rSet = pScene->GetCameraSet();
	Volume3D aVolume = pScene->FitInSnapRect();
	rSet.SetDeviceVolume(aVolume, FALSE);
	Matrix4D mTransform = pScene->GetFullTransform();
	rSet.SetObjectTrans(mTransform);

	Vector3D a2DCenter = rSet.ObjectToViewCoor(aCenter);
	a2DCenter.Z() = 0.0;
	Vector3D a2DPos1 = rSet.ObjectToViewCoor(aPnt1);
	a2DPos1.Z() = 0.0;
	Vector3D a2DPos2 = rSet.ObjectToViewCoor(aPnt2);
	a2DPos2.Z() = 0.0;
	Point a2DPos;

	a2DPos1 -= a2DCenter;
	a2DPos2 -= a2DCenter;

	if(a2DPos1.GetLength() > a2DPos2.GetLength())
	{
		rDescr.aTextPos3D = aPnt1;
		a2DPos=Point((long)a2DPos1.X(),(long)a2DPos1.Y());
	}
	else
	{
		rDescr.aTextPos3D = aPnt2;
		a2DPos=Point((long)a2DPos2.X(),(long)a2DPos2.Y());
	}
	long nRealHookAngle = (36000-9000+(long)RAD2CDEG(atan2((double)a2DPos.X(),(double)a2DPos.Y())))%36000;
	const long nSectorSize=(36000/8);
	long nSector=((nRealHookAngle+nSectorSize/2)/nSectorSize);///In 8 Sektoren aufteilen

	switch(nSector)
	{
		default:
		case 0:
			rDescr.eAdjust=CHADJUST_CENTER_LEFT;
			CHART_TRACE( "Segment3DDescr CHADJUST_CENTER_LEFT");
			break;
		case 1:
			rDescr.eAdjust=CHADJUST_BOTTOM_LEFT;
			CHART_TRACE( "Segment3DDescr CHADJUST_BOTTOM_LEFT");
			break;
		case 2:
			rDescr.eAdjust=CHADJUST_BOTTOM_CENTER;
			CHART_TRACE( "Segment3DDescr CHADJUST_BOTTOM_CENTER");
			break;
		case 3:
			rDescr.eAdjust=CHADJUST_BOTTOM_RIGHT;
			CHART_TRACE( "Segment3DDescr CHADJUST_BOTTOM_RIGHT");
			break;
		case 4:
			rDescr.eAdjust=CHADJUST_CENTER_RIGHT;
			CHART_TRACE( "Segment3DDescr CHADJUST_CENTER_RIGHT");
			break;
		case 5:
			rDescr.eAdjust=CHADJUST_TOP_RIGHT;
			CHART_TRACE( "Segment3DDescr CHADJUST_TOP_RIGHT");
			break;
		case 6:
			rDescr.eAdjust=CHADJUST_TOP_CENTER;
			CHART_TRACE( "Segment3DDescr CHADJUST_TOP_CENTER");
			break;
		case 7:
			rDescr.eAdjust=CHADJUST_TOP_LEFT;
			CHART_TRACE( "Segment3DDescr CHADJUST_TOP_LEFT");
			break;
	}
	a2DPos+=Point((long)a2DCenter.X(),(long)a2DCenter.Y());
	rDescr.aTextPos2D = a2DPos;
	Rectangle aObjRect = rDescr.pLabelObj->GetLogicRect();
	aObjRect.SetPos(a2DPos);
	AdjustRect(aObjRect, rDescr.eAdjust);
	rDescr.pLabelObj->NbcSetAnchorPos(a2DPos);
	rDescr.pLabelObj->NbcSetRelativePos(aObjRect.TopLeft());
	rDescr.pLabelObj->NbcSetLogicRect(aObjRect);
}

SdrObjGroup* ChartModel::Create3DNewPieChart(Rectangle &rRect)
{
	SdrObjList  *pList=NULL;

	pChartYAxis->SetPercentMode( FALSE );	// percent is calculated using the row rather than the column

	pScene = CreateScene (rRect, *aLightVec, fSpotIntensity, aSpotColor,
						  fAmbientIntensity, aAmbientColor);
	const long nSize=FIXED_SIZE_FOR_3D_CHART_VOLUME;

	long	nW      = nSize;
	long	nH      = nSize;
	long    nZ      = nSize;//(nSize * 4) / 6;

	//erweiterung auf Donuts  emglichen!
	long nColCnt = GetColCount();
	const short nRowCnt=1;//	long	nRowCnt = GetRowCount();
	const short nRow=0;
	short	nCol;//, nRow;

	long nZExtrude=nZ/3;

	Camera3D aCam(pScene->GetCamera());
	const long nDepth=-nZ;

	Vector3D aCamPos(0,0,nW/2);
	Vector3D aLookAt(0,0,nDepth/2);
	aCam.SetViewWindow(-nW/2, -nH/2, nW, nH);
	aCam.SetDefaults(aCamPos, aLookAt, 80, DEG2RAD(-(double)nZAngle / 10.0));
	aCam.Reset();
	aCam.SetProjection(eProjection);

	aCam.SetAspectMapping(AS_HOLD_SIZE);
	pScene->SetCamera(aCam);
	pScene->SetTransform(aSceneMatrix);

	//	Pie charts may not have titles of axes.
	bShowXAxisTitle = FALSE;
	bShowYAxisTitle = FALSE;
	bShowZAxisTitle = FALSE;

	// Max. bestimmen
	double fTotal=0.0;
	long nSegments=0;
	for (nCol = 0; nCol < nColCnt; nCol++)
	{
		double fTemp = fabs(GetData(nCol,nRow));
		if (fTemp != DBL_MIN && fTemp>0)
		{
			fTotal += fTemp;
			nSegments++;
		}
	}
	if(!nSegments || fTotal == 0.0)
		return (SdrObjGroup*) pScene;

	Rectangle aPieRect;
	aPieRect=Rectangle(Point(-nW/2,-nH/2),Size(nW,nH)); // rect in which the pie is drawn

	const long nMaxAngle=36000;
	long nPos=0;
	E3dDefaultAttributes aDefltAttr3D;

	long nEndAngle=0;
	long nStartAngle=0;

	ChartDataDescription aDescr(nColCnt,nRowCnt,pList,this,bShowDataDescr);

	Point aCenter = aPieRect.Center();
	Size aPieRectSize = aPieRect.GetSize();

	for (nCol = 0; nCol < nColCnt; nCol++)
	{
		double fValue = fabs(GetData( nCol,nRow));
		if(fValue!=DBL_MIN && fValue>0.0)
		{
			nPos++;
			SfxItemSet aDataPointAttr(GetFullDataPointAttr(nCol,nRow));
			nStartAngle=nEndAngle;
			nEndAngle+=(long)((fValue/fTotal)*nMaxAngle);

			// for last segment use exact value to avoid accumulated errors
			if( nPos == nSegments )
				nEndAngle = 36000;

			if(nEndAngle>nMaxAngle)
				nEndAngle-=nMaxAngle;

			XPolyPolygon aPolyPolygon;

			// if the angle of the sector is too small the conversion method produces an error
			// especially as angles are rounded to integers / 10
			if( nEndAngle - nStartAngle < 10 )	// approximate as triangle
			{
				XPolygon aPoly( 4 );
				double fAngleStart = (double)(nStartAngle) * F_PI / 18000.0,
					fAngleEnd = (double)(nEndAngle) * F_PI / 18000.0,
					fRadiusX = (double)(aPieRectSize.Width()) / 2.0,
					fRadiusY = (double)(aPieRectSize.Height()) / 2.0;

				aPoly[ 0 ] = aCenter;
				aPoly[ 1 ] = Point( (long)(aCenter.X() + fRadiusX * cos( fAngleStart )), (long)(aCenter.Y() - fRadiusY * sin( fAngleStart )) );
				aPoly[ 2 ] = Point( (long)(aCenter.X() + fRadiusX * cos( fAngleEnd )), (long)(aCenter.Y() - fRadiusY * sin( fAngleEnd )) );
				aPoly[ 3 ] = aCenter;

				aPolyPolygon.Insert( aPoly );
			}
			else		// create a polygon
			{
				SdrCircObj aSegment( OBJ_SECT, aPieRect, nStartAngle, nEndAngle);
				GetPage(0)->NbcInsertObject( &aSegment, 0 );
				SdrPathObj* pTmp = (SdrPathObj*)aSegment.ConvertToPolyObj( FALSE, FALSE );

				// Add two extra points near the end of the arc so that
				// the lighting of the 3d object is smoothed
				XPolygon aPoly( pTmp->GetPathPoly().GetObject(0) );

				long nEnd = aPoly.GetPointCount();
				if( nEnd > 3 )
				{
					Point aP2b( aPoly[ nEnd-3 ] );
					Point aP1b( aPoly[ 2 ] );
					Point aP2(  aPoly[ nEnd-2] ) ;
					Point aP1(  aPoly[ 1 ] );
					aP1 += (aP1b-aP1) / 100;
					aP2 += (aP2b-aP2) / 100;
					aPoly.Insert( nEnd - 2, aP2, XPOLY_NORMAL);
					aPoly.Insert( 2, aP1, XPOLY_NORMAL );
				}
				aPolyPolygon.Insert( aPoly );

				GetPage( 0 )->RemoveObject( 0 );
			}

			SchE3dExtrudeObj* pObj=new SchE3dExtrudeObj(aDefltAttr3D,
				aPolyPolygon,nZExtrude);

			DBG_ASSERT( pObj, "couldn't create extrude object" );

			// default attributes reset the texture projection items so set them explicitly
			// use object specific projection in y direction
//-/			pObj->SetUseStdTextureY( FALSE );
			pObj->SetItem( Svx3DTextureProjectionYItem( 0 ));
			pObj->SetItem( Svx3DDoubleSidedItem( TRUE ));
 
			pScene->Insert3DObj(pObj);
			pObj->InsertUserData(new SchDataPoint(nCol, nRow));
			pObj->InsertUserData (new SchObjectId (CHOBJID_DIAGRAM_DATA));
			pObj->SetMoveProtect(TRUE);
			pObj->SetResizeProtect(TRUE);
			pObj->SetModel(this);

//-/			pObj->NbcSetAttributes(aDataPointAttr,FALSE);
			pObj->SetItemSet(aDataPointAttr);


			Matrix4D aMatrix;
			aMatrix.TranslateZ(-nZExtrude/2);
			pObj->NbcSetTransform(aMatrix);


			if(aDescr.Enabled())
			{
				double fZPos = (double)nZExtrude / 2.0;
				DataDescription* pDescr=aDescr.Insert(nCol,nRow,aDataPointAttr,Point(0,0),FALSE,CHADJUST_BOTTOM_CENTER,pChartYAxis);
				if(pDescr)
					Segment3DDescr(*pDescr,aPieRect,nStartAngle,nEndAngle,0,aPieRect.GetWidth()/2,aPieRect.GetWidth()/2,fZPos);
			}
		}
	}
	aDescr.Build3D(pScene);

	return (SdrObjGroup*) pScene;
}

/*************************************************************************
|*
|* Positioniere die Achsentitel um das Rectangle der Scene
|*
\************************************************************************/

void ChartModel::Position3DAxisTitles(const Rectangle& rSceneRect)
{
	SdrPage *pPage = GetPage (0);
	Size aPageSize = pPage->GetSize();

	if (bShowXAxisTitle)
	{
		SdrObject *pXAxisTitleObj = GetObjWithId(CHOBJID_DIAGRAM_TITLE_X_AXIS, *pPage);
		if (pXAxisTitleObj != NULL)
		{
			Rectangle aXAxisOutRect = pXAxisTitleObj->GetBoundRect();

			Point aXAxesTitlePosition (rSceneRect.Left () + (int) (rSceneRect.GetWidth () / 2),
									   Min ((long) aChartRect.Bottom(),
											(long) (rSceneRect.Bottom () + aXAxisOutRect.GetHeight()) ));

			if (GetXAxisTitleHasBeenMoved() && GetUseRelativePositions() &&
				(aXAxesTitlePosition.X() > 0) && (aXAxesTitlePosition.Y() > 0))
			{
				// FG: Das ist eine Variable die in BuildChart gesetzt wird, kutz bevor
				//     das Objekt zerstoert wird.
				double fRelativeXPosition = ((double) aTitleXAxisPosition.X()) / aInitialSizefor3d.Width();
				double fRelativeYPosition = ((double) aTitleXAxisPosition.Y()) / aInitialSizefor3d.Height();
				aXAxesTitlePosition.X() = (long)(aPageSize.Width() * fRelativeXPosition);
				aXAxesTitlePosition.Y() = (long)(aPageSize.Height() * fRelativeYPosition);
			}
			else
			{
				if (bSwitch3DColRow)
				{
					aXAxesTitlePosition.X() = Max (0l, (long) (rSceneRect.Left () - 2 * aXAxisOutRect.GetWidth ()));
					aXAxesTitlePosition.Y() = Max (0l, (long) (rSceneRect.Top () + rSceneRect.GetHeight () / 2));
				}
			}
			SetTextPos((SdrTextObj &) *pXAxisTitleObj, aXAxesTitlePosition,pXAxisTitleAttr);
		}
	}

	if (bShowYAxisTitle)
	{
		SdrObject *pYAxisTitleObj = GetObjWithId(CHOBJID_DIAGRAM_TITLE_Y_AXIS, *pPage);
		if (pYAxisTitleObj != NULL)
		{
			Rectangle aYAxisOutRect = pYAxisTitleObj->GetBoundRect();

			Point aYAxesTitlePosition (Max (0l, (long) (rSceneRect.Left () - 2 * aYAxisOutRect.GetWidth ())),
									   Max (0l, (long) (rSceneRect.Top () + rSceneRect.GetHeight () / 2)));

			if (GetYAxisTitleHasBeenMoved() && GetUseRelativePositions() &&
				(aYAxesTitlePosition.X() >= 0) && (aYAxesTitlePosition.Y() > 0))
			{
				// FG: Das ist eine Variable die in BuildChart gesetzt wird, kutz bevor
				//     das Objekt zerstoert wird.
				double fRelativeXPosition = ((double) aTitleYAxisPosition.X()) / aInitialSizefor3d.Width();
				double fRelativeYPosition = ((double) aTitleYAxisPosition.Y()) / aInitialSizefor3d.Height();
				aYAxesTitlePosition.X() = (long)(aPageSize.Width() * fRelativeXPosition);
				aYAxesTitlePosition.Y() = (long)(aPageSize.Height() * fRelativeYPosition);
			}
			else
			{
				if (bSwitch3DColRow)
				{
					aYAxesTitlePosition.X() = rSceneRect.Left () + (int) (rSceneRect.GetWidth () / 2 + 0.5);
					aYAxesTitlePosition.Y() = Min ((long) aChartRect.Bottom(),
												   (long) (rSceneRect.Bottom () + aYAxisOutRect.GetHeight()) );
				}
			}
			SetTextPos((SdrTextObj &) *pYAxisTitleObj, aYAxesTitlePosition,pYAxisTitleAttr);
		}

	}

	if (bShowZAxisTitle)
	{
		SdrObject *pZAxisTitleObj = GetObjWithId(CHOBJID_DIAGRAM_TITLE_Z_AXIS, *pPage);
		if (pZAxisTitleObj != NULL)
		{
			Rectangle aZAxisOutRect = pZAxisTitleObj->GetBoundRect();


			Point aZAxesTitlePosition( (long)(0.95 * rSceneRect.Right()),
                                       (long)Min ((long) aChartRect.Bottom(),
                                                  (long) (rSceneRect.Bottom () - aZAxisOutRect.GetHeight())));


			if (GetZAxisTitleHasBeenMoved() && GetUseRelativePositions() &&
				(aZAxesTitlePosition.X() > 0) && (aZAxesTitlePosition.Y() > 0))
			{
				// FG: Das ist eine Variable die in BuildChart gesetzt wird, kutz bevor
				//     das Objekt zerstoert wird.
				double fRelativeXPosition = ((double) aTitleZAxisPosition.X()) / aInitialSizefor3d.Width();
				double fRelativeYPosition = ((double) aTitleZAxisPosition.Y()) / aInitialSizefor3d.Height();
				aZAxesTitlePosition.X() = (long)(aPageSize.Width() * fRelativeXPosition);
				aZAxesTitlePosition.Y() = (long)(aPageSize.Height() * fRelativeYPosition);
			}
			else if(aZAxesTitlePosition.Y()<aZAxisOutRect.GetHeight()/2)
			{
				aZAxesTitlePosition.Y()=aZAxisOutRect.GetHeight();
			}
			SetTextPos((SdrTextObj &) *pZAxisTitleObj, aZAxesTitlePosition,pZAxisTitleAttr);
		}

	}

	aInitialSizefor3d = aInitialSize;
}

void ChartModel::CopySpecialPointAttrToPage( long nRow )
{
	//ToDo: Kann das hier nicht mittlerweile durch CopyPointAttrToPage esetzt werden?
	SdrObjListIter aIterator(*GetPage(0), IM_DEEPWITHGROUPS);
	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchObjectId* pObjId = GetObjectId(*pObj);

		if (pObjId && (pObjId->GetObjId() == CHOBJID_DIAGRAM_SPECIAL_GROUP))
		{
			if (nRow == GetDataRow(*pObj)->GetRow())
			{
				SchDataPoint* pDataPoint = GetDataPoint(*pObj);

				if(pDataPoint)

//-/					pObj->NbcSetAttributes(GetFullDataPointAttr(pDataPoint->GetCol(),nRow),FALSE);
					pObj->SetItemSet(GetFullDataPointAttr(pDataPoint->GetCol(),nRow));

				else

//-/					pObj->NbcSetAttributes(GetDataRowAttr(nRow),FALSE);
					pObj->SetItemSet(GetDataRowAttr(nRow));

			}
		}
	}
}


