/*************************************************************************
 *
 *  $RCSfile: chaxis.hxx,v $
 *
 *  $Revision: 1.7.6.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 13:10:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef SCH_CHART_AXIS_HXX
#define SCH_CHART_AXIS_HXX

class ChartModel;
class SvNumberFormatter;
class SvULONGTable;
class SdrObject;
class SdrObjList;
class XPolygon;
class SdrTextObj;
class SchAxisObj;

#ifndef _SVX_CHRTITEM_HXX //autogen
#include <svx/chrtitem.hxx>
#endif
#ifndef _SV_GEN_HXX //autogen
#include <tools/gen.hxx>
#endif
#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif
#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif

#ifndef _COM_SUN_STAR_DRAWING_XSHAPE_HPP_
#include <com/sun/star/drawing/XShape.hpp>
#endif

#include "defines.hxx"
#include "schattr.hxx"
#include "float.h"
#include <math.h>

#define CHAXIS_POS_A -1   //Top or Right    (normale Position)
#define CHAXIS_POS_B -2	  //Bottom or Left  (Position der 2.Achse)

#define CHAXIS_MARK_BOTH   3   //eigentlich sind es flags....
#define CHAXIS_MARK_OUTER  2
#define CHAXIS_MARK_INNER  1
#define CHAXIS_MARK_NONE   0
#define CHAXIS_MARK_ASMAIN 4  //Flag indiziert, da Helpticks wie mainticks ausgerichtete werden sollen

#define CHAXIS_AXIS_UNKNOWN 0
#define CHAXIS_AXIS_X	1
#define CHAXIS_AXIS_Y	2
#define CHAXIS_AXIS_Z	3
#define CHAXIS_AXIS_B	4	// secondary Y axis
#define CHAXIS_AXIS_A	5	// secondary X axis

class ChartAxis
{
protected:

	BOOL mbInnerPos;
	long mnInnerPos;
	BOOL mbColText;    // Texte aus Datenspalte statt per Numberformatter generieren
	BOOL mbCenterText; // mbCenterText: FALSE -> Beschriftung wie z.B. Barchart, d.h. unter
					   // der ganzen Spalte, TRUE: wie z.B. Area, zentriert unter Datenpunkt

	long mnMaxTextWidth;

	long mnAlternateId;
	long mbAlternativIdUsed;

	//Statistik bzw. Daten in Prozent: Summe je Spalte der Elemente, die an der Achse skalieren
	BOOL			   mbPercentCol;
	BOOL	           mbTextOverlap;
	double			   *mpTotal;
	long 			   mnTotalSize;
	BOOL			   mbTotalActual;
	BOOL			   mbTotalAlloc;
	void			   ResizeTotal(long nSize);
	void			   CreateTotal();

	double	 		   *mpColStack;
	BOOL			   mbColStackOK;

	long			   mnUId;
	BOOL			   mbShowDescr;
	SfxItemSet*		   mpAllAxisAttr;
	SvNumberFormatter* mpNumFormatter;

	SdrObjList* mpAxisList;
	SchAxisObj* mpAxisObj;
	
	SdrObjList* mpMainGridList;
	SdrObjList* mpHelpGridList;
	SfxItemSet* mpMainGridAttr;
	SfxItemSet* mpHelpGridAttr;

	long mnIdMainGrid;
	long mnIdHelpGrid;

	SfxItemSet* mpGridAttr;
	SfxItemSet* mpTextAttr;

	Rectangle maRectA,maRectB;

	long mnTicks;
	long mnHelpTicks;
	long mnTickLen;
	long mnHelpTickLen;
	long mnPos;
	long mnTextPos;
	BOOL mbSecondary;

	BOOL				mbStepValue;
	BOOL				mbValueDown;

	void RecalcTextPos();

	Size maMaxTextSize;
	long meStackMode;

	long mnId;        //X,Y oder Z, (CHOBJID)
	BOOL mbFlippedXY; //TRUE: X vertikal, Y horizontal; (entspricht in etwa bSwitchColRow...)
	long mnPosition;  //links/rechts bzw. oben/unten

	BOOL mbRadial;    //NetChart, evtl. einmal auch fr PolarPlots
	Rectangle maArea; //Dieser Bereich wird von den Achsen umschlossen
	Rectangle maRefArea;

	BOOL mbPercent;

	SfxItemSet* mpAxisAttr;
	ChartModel* mpModel;

	//Elementare Groessen: Min,Max,Markierung,Ursprung
	double  mfMin;
	double  mfMax;
	double  mfStep;
	double  mfStepHelp;
	double  mfOrigin;


	double mfDataBottom; //stacked Charts
	double mfDataTop;


	BOOL mbAutoMin;
	BOOL mbAutoMax;
	BOOL mbAutoOrigin;

	BOOL mbAutoStep;
	BOOL mbAutoStepHelp;

	BOOL mbLogarithm;

	SvxChartTextOrient meTextOrient;

	void CalcMinMaxValue();
	void SetDefaults();
	void UpdateRowMinMax(const long nRow,const long nColCnt,const BOOL bPercent);
	long GetLength() const;

	inline double GetRowError(long nRow);
	inline BOOL IsDataOnAxis(long nRow);

	void CreateTextAttr();
	void   InitColStacking(long nColCnt);

public:


	long GetDescrWidth();
	void SetColTextMode(BOOL bColText,BOOL bCenterText)
	{
		mbColText    = bColText;
		mbCenterText = bCenterText;
	}
	//Hilfsfunktion fr X-Achse, nur in Create2DBackplane
	void InsertHelpTick(long nPos) {InsertMark(nPos,mnHelpTickLen,mnHelpTicks);}
	BOOL HasHelpTicks() {return mnHelpTicks!=0;}

	BOOL AttachIfNoOwnData(const ChartAxis* pAxis);

	void SetPercentMode(BOOL bPercentCol=TRUE)
	{
		if(mbPercentCol!=bPercentCol)
			mbTotalActual=FALSE;
		mbPercentCol=bPercentCol;
	}

	void IfNoDataLookAt(long nAlternateAxisId)		{ mnAlternateId = nAlternateAxisId; }

	const Rectangle& GetArea()						{ return maRefArea; }
	double StackColData(double fData,long nCol,long nColCnt);

	inline double	   GetData(long nCol,long nRow);
	double			   Data2Percent(double fData,long nCol,long nRow);
	double			   GetTotal(long n);

	void Update()									{ ReadAutoAttr(); ReadAttr(); }
	void FillItemSet()								{ GetMembersAsAttr(*mpAxisAttr); }

	BOOL IsVertical();
	BOOL IsNegative()								{ return (mfMax <= 0.0 && mfMin < 0.0 ); }

	// Stack stapelt den Wert an der entsprechenden Achse
	// und gibt die Position (Start und Ende) relativ zum Koordinatensystem zurck
	// Pair::A() fr Top/Left, B() fr Bottom/Right
	Pair Stack(double fData,BOOL bConstrained=TRUE);//stacked Charts
	void InitStacking()								{ mfDataBottom=mfDataTop=0.0; }
	//void Create();
	//void PreDestruct();

	// Top/Right Position
	long GetUpper(double fData,BOOL bConstrained=TRUE);
	// Bottom/Left Position
	long GetLower(double fData,BOOL bConstrained=TRUE);

	long GetPos(double fData);
	long GetPosConstrained(double fData);
	long GetPosOrigin()								{ return GetPos(mfOrigin); }
	BOOL SetArea(const Rectangle& rRect);
	void ReadMembers(const ChartAxis& other);
	void LoadMemberCompat(SvStream& rIn);
	void StoreMemberCompat(SvStream& rOut) const;

	ChartAxis(ChartModel* pModel,long nId,long nUid);
	virtual ~ChartAxis();

	void AdjustOrigin();
	BOOL IsOriginInRange() const;

	BOOL IsValueInRange( double fValue ) const;

	double NumStepsMain();

	void SetAttributes(const SfxItemSet &rAttr);
	void SetAttributes(SfxItemSet *pSet);
	SfxItemSet* GetItemSet() const	{ return mpAxisAttr; }
	double GetMax()		 const		{ return mfMax; }
	double GetMin()		 const		{ return mfMin; }
	double GetStep()	 const		{ return mfStep; }
	double GetOrigin()   const		{ return mfOrigin; }
	double GetHelpStep() const		{ return mfStepHelp; }
	void SetMax(double f)			{ mfMax = f; }
	void SetMin(double f)			{ mfMin = f; }
	BOOL IsLogarithm() const		{ return mbLogarithm; }
	/* Freischalten, wenn bentigt:

	BOOL IsAutoMin()   const {return mbAutoMin;}
	BOOL IsAutoMax()   const {return mbAutoMax;}
	BOOL IsAutoOrigin()const {return mbAutoOrigin;}

	void SetOrigin(double f);	{mfOrigin=f;}
	void SetStep(double f);		{mfStep=f;}
	void SetHelpStep(double f);	{mfStepHelp=f;}
	void SetLogarithmic(BOOL b) {mbLogarithm=b;}
	void SetAutoMin(BOOL b)		{mbAutoMin=b;}
	void SetAutoMax(BOOL b)		{mbAutoMax=b;}
	void SetAutoOrigin(BOOL b)  {mbAutoOrigin=b;}
	*/
	void Initialise(const Rectangle &rRect,BOOL bFlippedXY=FALSE,long eStackmode=CHSTACK_NONE,BOOL bPercent=FALSE,BOOL bRadial=FALSE,BOOL bPercentCol=TRUE);

	void VerifySteps();
	void CalcValueSteps();
	BOOL GetMinMaxFromData();

	inline double CalcFact(const double fValue) const
	{
		if (fValue == DBL_MIN)
		{
			return DBL_MIN;
		}
		else if (mfMin == mfMax)
		{
			return 0.0;
		}
		else if (mbLogarithm)
		{
			double fVal = (fValue > 0.0) ? log10(fValue) : log10(mfMin);
			return (fVal - log10(mfMin)) / (log10(mfMax) - log10(mfMin));
		}
		else
		{
			return (fValue - mfMin) / (mfMax - mfMin);
		}
	}

	double CalcFactOrigin()		{ return CalcFact(mfOrigin); }

	//ToDo: Zusammenfassen:
	void ReadAutoAttr();
	void ReadAttr();

	inline BOOL IsVisible() const
	{
		return static_cast< const SfxBoolItem& >( mpAxisAttr->Get( SCHATTR_AXIS_SHOWAXIS ) ).GetValue();
	}
	inline BOOL HasDescription() const
	{
        // meaning should description be displayed, so necessary is IsVisible()
		return static_cast< const SfxBoolItem& >( mpAxisAttr->Get( SCHATTR_AXIS_SHOWDESCR ) ).GetValue() &&
               IsVisible();
	}

	void GetMembersAsAttr(SfxItemSet& rSet) const;

	void InsertMark(long nPos,long nLen,long nWhichTicks);
	UINT32 GetNumFormat()							{ return GetNumFormat( mbPercent ); }
	UINT32 GetNumFormat(BOOL bPercent);
	void SetNumFormat(long nId)						{ SetNumFormat( mbPercent, nId ); }
	void SetNumFormat(BOOL bPercent,long nId);
	
	void GridLine(XPolygon& aLine,long nPos);

	void ShowDescr(BOOL b);
	void ShowAxis(BOOL b);

	void DrawGrids();
	void SetMainGrid(SdrObjList* pList,SfxItemSet*pAttr);
	void SetHelpGrid(SdrObjList* pList,SfxItemSet*pAttr);

	long CreateAxis();
	void CreateAxis(const long nPos,BOOL bBorderAxis,BOOL bInnerAxis);
	void CreateAxis(SdrObjList& rList,long nChObjId);
	void SetAllAxisAttr(SfxItemSet *pSet)						{ mpAllAxisAttr = pSet; }
	void SetNumberFormatter( SvNumberFormatter* pFormatter )	{ mpNumFormatter = pFormatter; }
	void SubtractDescrSize(Rectangle& rRect);
	void SubtractDescrSize_X(Rectangle& rRect,const Rectangle& rOldRect); //X-Richtung ist leider etwas anders
	void InitDescr_X();
	void InitDescr(SvxChartTextOrient &rValueOrient,long nMaxTextWidth=-1);
	void InitDescr();

	Size CalcMaxTextSize(SvxChartTextOrient eOrient);
	Size CalcMaxTextSize();

	void CreateMarkDescr(const String& rString, long nPosition, Color *); // #60999# BM
	void CreateMarkDescr(double fData,long nPosition);
	void CreateMarkDescr(SdrTextObj *pTextObj,long nPosition);
	void SetAxisList( SdrObjList *pList );
	void SetGridAttrList(SfxItemSet* pList)	{ mpGridAttr = pList; }
	void SetTextAttrList(SfxItemSet* pList)	{ mpTextAttr = pList; }

	//nach Initialise und SetRefArea (ChartAxis) setzen!!!!!
	//nPos ist entweder eine echte Position (bei Y-Achse der X Wert u.U.)
	//oder ein define fr Standardposition (CHAXIS_POS_A) bzw. sekundre
	//(CHAXIS_POS_B) Achse (= oben bzw. Rechts)
	void SetPosition(long nPos);
	//nDir ist Flag, kann sein CHAXIS_MARK_INNER und CHAXIS_MARK_OUTER (oder beides)
	SdrObject *CreateMarks(long nPosition,long nLen,long nWhichTicks);

	BOOL TranslateMergedNumFormat( SvULONGTable* pTransTable );
    long GetUniqueId() const    { return mnUId; }

    /** Converts a CHOBJID into an axis UId.

        @return CHAXIS_AXIS_X, CHAXIS_AXIS_Y, CHAXIS_AXIS_Z, CHAXIS_AXIS_A or
                CHAXIS_AXIS_B or CHAXIS_AXIS_UNKNOWN if nObjectId does not refer
                to any valid axis object.
     */
    static long GetUniqueIdByObjectId( long nObjectId );

private:
	/**
		@descr	Calculate the size of the bounding box of a text string.  The 
				size is measured with respect to the coordinate axes.
	
		@param	rAttr	Attributes of the font to use.
		@param	aString	The "typical" description.
	
		@return	Returns the size of the bounding box of the text.
	*/
	Size	CalcDescriptionSize	(const SfxItemSet * rAttr,
								const String & aString);

	/**
		@descr	Calculate the expected size of a "typical" description.  The 
				size is measured along the axis.  The axis orientation is taken
				into account.
		@precond CalcMinMaxValue() has to have been called already.
	
		@param	rAttr	Attributes of the font to use.
	
		@return	Returns the size of the text projected onto the axis.
	*/
	long int	CalcTypicalDescriptionSize	(const SfxItemSet * rAttr);
};

#endif
