/*************************************************************************
 *
 *  $RCSfile: ruler.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:45:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SC_RULER_HXX
#define _SC_RULER_HXX

#ifndef _WINDOW_HXX
#include <vcl/window.hxx>
#endif

#ifndef _COLOR_HXX
#include <vcl/color.hxx>
#endif

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif

#ifndef _SV_CTRL_HXX //autogen
#include <vcl/ctrl.hxx>
#endif

#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif

#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>

#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif

#define SC_BOTTOM_DISTANCE 6

class ScRuler : public Control
{
private:

	Link				aMouseUpLink;
	Link				aMouseMoveLink;
	Link				aMouseDownLink;
	short				nAktiveSep;
	short				nActiveSepPos;
	USHORT				nScaleFactor;
	USHORT				nSmallScaleFactor;
	USHORT				nDistance;
	USHORT				nMaxRulerPos;
	USHORT				nOffset;
	USHORT				nViewOffsetX;
	SvUShorts			aSeparators;
	VirtualDevice		aVDev;
	BOOL				bMouseAktiv;
	BOOL				bSepAktiv;
	Point				aMousePos;

	void		CtrMouseUp();
	void		CtrMouseMove();
	void		CtrMouseDown();
	void		ImplInitSettings( BOOL bFont, BOOL bForeground, BOOL bBackground );


protected:

	virtual	void Paint( const Rectangle& rRect );
	virtual void MouseButtonUp( const MouseEvent& rMEvt);
	virtual void MouseMove( const MouseEvent& rMEvt);
	virtual void MouseButtonDown( const MouseEvent& rMEvt);
	virtual void MouseDblClick( const MouseEvent& rMEvt);

	void		DrawDivisionScale();
	void		DrawScaleText(Point aPoint, String aString);
	void		DrawMyPoint(Point aPos,short PoiSize,ColorData col);


public:

	ScRuler( Window* pParent, const ResId& rResId );
	ScRuler( Window* pParent, WinBits nWinStyle  = 0 );
	~ScRuler();

	void		InitScRuler();
	void		InsertSeparator(USHORT Pos);
	void		RemoveSeparator(USHORT Pos);
	void		ClearSeparators();

	void		SetStartPos(short nY);
	short		GetStartPos();
	short		GetMaxRulerPos();
	void		SetMaxRulerPos(short);
	void		SetDistance(short);
	void		SetScaleFactor(USHORT);
	void		SetXViewPosOffset(USHORT);
	short		GetActiveSepPos();
	USHORT		GetActiveSep();
	BOOL		IsActiveNew();
	Point		GetMousePos();
	void		SetActivSep(BOOL bFlag=TRUE) { bSepAktiv=bFlag;}

	short		GetMinHeight();

	void            SetMouseUpHdl( const Link& rLink ) { aMouseUpLink = rLink; }
	const Link&     GetMouseUpLink() const { return aMouseUpLink; }
	void            SetMouseMoveHdl( const Link& rLink ) { aMouseMoveLink= rLink; }
	const Link&     GetMouseMoveLink() const { return aMouseMoveLink; }
	void            SetMouseDownHdl( const Link& rLink ) { aMouseDownLink= rLink; }
	const Link&     GetMouseDownLink() const { return aMouseDownLink; }

	virtual	void StateChanged( StateChangedType nType );
	virtual	void DataChanged( const DataChangedEvent& rDCEvt );
};

#endif


