/*************************************************************************
 *
 *  $RCSfile: tabrul.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: dr $ $Date: 2001/05/30 13:49:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

#include "tabrul.hxx"



/*************************************************************************
#*	Member:		ScTableWithRuler							Datum:10.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Konstruktor der Klasse ScTableWithRuler
#*
#*  Input:		Fenster, Resource
#*
#*	Output:		---
#*
#************************************************************************/

ScTableWithRuler::ScTableWithRuler( Window* pParent, const ResId& rResId )
:Control(pParent,rResId),
		aPrivatDataGrid(this),
		aPrivatRuler(this),
		aPButton(this)
{
	UpdateOutput();
	nDelCol=-1;
	aPrivatDataGrid.InsertCol(0,1);
	aPrivatDataGrid.InsertRow(0,1);
	aPButton.SetText(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("][")));
	aPButton.Show();
	aPrivatRuler.Show();
	aPrivatDataGrid.Show();
	Link aLink=LINK( this, ScTableWithRuler, SepRulerHdl );
	Link a2Link=LINK( this, ScTableWithRuler, SepRulerMovHdl);
	Link a3Link=LINK( this, ScTableWithRuler, SepRulerDownHdl);
	Link a4Link=LINK( this, ScTableWithRuler, ContextMenuHdl);
	Link a5Link=LINK( this, ScTableWithRuler, ButtonHdl);
	// Mit Handler verbinden
	aPrivatRuler.SetMouseUpHdl(aLink);
	aPrivatRuler.SetMouseMoveHdl(a2Link);
	aPrivatRuler.SetMouseDownHdl(a3Link);
	aPrivatDataGrid.SetMouseDownHdl(a3Link);
	aPrivatDataGrid.SetContextMenuHdl(a4Link);
	aPButton.SetClickHdl(a5Link);
	nMousePos=0;
	SepRulerHdl(NULL);
	SepRulerMovHdl(NULL);
	SepRulerDownHdl(NULL);
}


/*************************************************************************
#*	Member:	~ScTableWithRuler								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Destruktor
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
ScTableWithRuler::~ScTableWithRuler()
{
}

/*************************************************************************
#*	Member:		UpdateOutput								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Falls irgendwelche Groessen geaendert worden sind,
#*				so wird mittels dieser Funktion, die Ausgabe an-
#*				gepasst.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::UpdateOutput()
{
	Font aFont=GetFont();
	String aSizeString = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("999"));
	Size aSize( aPrivatDataGrid.GetTextWidth(aSizeString), aPrivatDataGrid.GetTextHeight() );
	Size aOutputSize=GetOutputSizePixel();
	Point aPos(0,0);
	Point a2Pos=aPos;
	aPButton.SetPosPixel(aPos);
	aPrivatDataGrid.SetStdWidth((USHORT)aSize.Width());
	aPrivatDataGrid.SetStdHeight((USHORT)aSize.Height());

	aPrivatRuler.SetFont(aFont);
	Size aRulerSize=aOutputSize;
	aRulerSize.Height()=aPrivatRuler.GetMinHeight();
	aRulerSize.Width()-=aSize.Width()-1;
	a2Pos.X()=aSize.Width()-1;
	aPrivatRuler.SetPosPixel(a2Pos);
	aPrivatRuler.SetOutputSizePixel(aRulerSize);
	aRulerSize.Width()=aSize.Width()-1;
	aPButton.SetOutputSizePixel(aRulerSize);

	//aPrivatRuler.SetXViewPosOffset((USHORT)aSize.Width()-1);
	aPrivatRuler.InitScRuler();

	aPos.Y()+=aRulerSize.Height();
	aOutputSize.Height()-=aRulerSize.Height();
	aPrivatDataGrid.SetPosPixel(aPos);
	aPrivatDataGrid.SetOutputSizePixel(aOutputSize);
	aPrivatDataGrid.SetHeightOfAllRows((USHORT)aSize.Height());
	aPrivatDataGrid.Invalidate();
	aPrivatRuler.Invalidate();
}

/*************************************************************************
#*	Member:		SetFont										Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Wenn von aussen der Font geaendert wird,
#*				so werden auch die Child-Wins geaendert.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::SetFont( const Font& rNewFont )
{
	aPrivatDataGrid.SetLatinFont( rNewFont );
	aPrivatRuler.SetFont( rNewFont );
	Font aFont=aPButton.GetFont();
	aFont.SetSize(rNewFont.GetSize());
	aFont.SetWeight(WEIGHT_BOLD);
	aPButton.SetFont(aFont);
	OutputDevice::SetFont( rNewFont );
	UpdateOutput();
}


/*************************************************************************
#*	Member:		DeleteRow									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Loescht, ab der Zeile nAt, die angegebene
#*				Anzahl nNum von Zeilen
#*
#*  Input:		ab Zeile, Anzahl
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::DeleteRow(USHORT nAt,USHORT nNum)
{
	aPrivatDataGrid.DeleteRow(nAt,nNum);
}

/*************************************************************************
#*	Member:		DeleteCol									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Loescht, ab der Spalte nAt, die angegebene
#*				Anzahl nNum von Spalten.
#*
#*  Input:		ab Spalte, Anzahl
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::DeleteCol(USHORT nAt,USHORT nNum)
{
	aPrivatDataGrid.DeleteCol(nAt,nNum);
}

/*************************************************************************
#*	Member:		ClearTable									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Loescht die gesamte Tabelle, sowie alle
#*				Seperatoren im Lineal
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::ClearTable()
{
   aPrivatRuler.ClearSeparators();
   aPrivatDataGrid.ClearTable();
}
/*************************************************************************
#*	Member:		UpdateArray									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Fuehrt ein Update durch.
#*
#*  Input:		Zeilen, Spalten
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::UpdateArray(USHORT Rows,USHORT Cols)
{
	aPrivatDataGrid.UpdateArray(Rows,Cols);
}


/*************************************************************************
#*	Member:		ScTableWithRuler							Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Liefert die Anzahl der eingestellten Spalten zurueck
#*
#*  Input:		---
#*
#*	Output:		Anzahl Spalten
#*
#************************************************************************/
USHORT ScTableWithRuler::GetNumberOfCols()
{
	return aPrivatDataGrid.GetNumberOfCols();
}

/*************************************************************************
#*	Member:		ScTableWithRuler							Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Liefert die Nummer der selektierten Spalte zurueck
#*
#*  Input:		---
#*
#*	Output:		sel. Spalte
#*
#************************************************************************/
long ScTableWithRuler::GetSelectedCol()
{
	return aPrivatDataGrid.GetSelectedCol();
}

/*************************************************************************
#*	Member:		SetSelectedCol								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Selektiert eine Spalte
#*
#*  Input:		sel. Spalte
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::SetSelectedCol(long nCol)
{
	aPrivatDataGrid.SetSelectedCol(nCol);
}

/*************************************************************************
#*	Member:		InsertRow									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Fuegt an der Position nAt, die angegebene
#*				Anzahl von Zeilen nNum ein.
#*
#*  Input:		Position, Anzahl
#*
#*	Output:		---
#*
#************************************************************************/

void ScTableWithRuler::InsertRow(USHORT nAt,USHORT nNum)
{
	aPrivatDataGrid.InsertRow(nAt,nNum);
}

/*************************************************************************
#*	Member:		InsertCol									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Fuegt an der Position nAt, die angegebene
#*				Anzahl von Spalten nNum ein.
#*
#*  Input:		Position, Anzahl
#*
#*	Output:		---
#*
#************************************************************************/

void ScTableWithRuler::InsertCol(USHORT nAt,USHORT nNum)
{
	aPrivatDataGrid.InsertCol(nAt,nNum);
}

/*************************************************************************
#*	Member:		SetDataAtRowCol								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Setzt an der Position [nRow,nCol] den String aDataStr.
#*				Wenn diese Position nicht vorhanden ist, werden die
#*				entsprechenden Zeilen oder Spalten eingefuegt!!!
#*
#*  Input:		Position [nRow,nCol], Text
#*
#*	Output:		---
#*
#************************************************************************/

void ScTableWithRuler::SetDataAtRowCol(USHORT nRow,
									   USHORT nCol,String aDataStr)
{
	aPrivatDataGrid.SetDataAtRowCol(nRow,nCol,aDataStr);
}


/*************************************************************************
#*	Member:		GetDataAtRowCol								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Liefert den Tabellenwert fuer die Position [nRow,nCol]
#*				zurueck
#*
#*  Input:		Position [nRow,nCol]
#*
#*	Output:		Text
#*
#************************************************************************/

String ScTableWithRuler::GetDataAtRowCol(USHORT nRow,USHORT nCol)
{
	return aPrivatDataGrid.GetDataAtRowCol(nRow,nCol);
}

/*************************************************************************
#*	Member:		SetXTablePos								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Setzt den Nullpunkt zum Zeichnen der Tabelle in
#*				X-Richtung
#*
#*  Input:		neuer X-Nullpunkt
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::SetXTablePos(short nX)
{
	String aSizeString('X');
	USHORT nWidth=(USHORT) GetTextWidth(aSizeString);

	if(nWidth!=0) aPrivatRuler.SetStartPos(nX/nWidth);

	aPrivatDataGrid.SetXTablePos(nX);
}

/*************************************************************************
#*	Member:		SetYTablePos								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Setzt den Nullpunkt zum Zeichnen der Tabelle in
#*				Y-Richtung
#*
#*  Input:		neuer Y-Nullpunkt
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::SetYTablePos(short nY)
{
	aPrivatDataGrid.SetYTablePos(nY);
}


/*************************************************************************
#*	Member:		GetXTablePos								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Liefert den X-Nullpunkt zurueck.
#*
#*  Input:		---
#*
#*	Output:		X-Nullpunkt
#*
#************************************************************************/
short ScTableWithRuler::GetXTablePos()
{
	return aPrivatDataGrid.GetXTablePos();
}

/*************************************************************************
#*	Member:		GetYTablePos								Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Liefert den Y-Nullpunkt zurueck.
#*
#*  Input:		---
#*
#*	Output:		Y-Nullpunkt
#*
#************************************************************************/
short ScTableWithRuler::GetYTablePos()
{
	return aPrivatDataGrid.GetYTablePos();
}

/*************************************************************************
#*	Member:		GetXMaxTableSize							Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Liefert die Gesamtgroesse der Tabelle in X-Richtung
#*				zurueck
#*
#*  Input:		---
#*
#*	Output:		groesster X-Wert
#*
#************************************************************************/
short ScTableWithRuler::GetXMaxTableSize()
{
	return aPrivatDataGrid.GetXMaxTableSize();
}

/*************************************************************************
#*	Member:		GetYMaxTableSize							Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Liefert die Gesamtgroesse der Tabelle in Y-Richtung
#*				zurueck
#*
#*  Input:		groesster Y-Wert
#*
#*	Output:		---
#*
#************************************************************************/
short ScTableWithRuler::GetYMaxTableSize()
{
	return aPrivatDataGrid.GetYMaxTableSize();
}

/*************************************************************************
#*	Member:		GetXMaxVisChars								Datum:10.12.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Liefert die Anzahl der maximal sichtbaren Zeichen
#*				in X-Richtung zurueck.
#*
#*  Input:		Anzahl max. Zeichen
#*
#*	Output:		---
#*
#************************************************************************/
USHORT ScTableWithRuler::GetXMaxVisChars()
{
	String aString('X');
	USHORT nSWidth=(USHORT)aPrivatDataGrid.GetTextWidth(aString);
	USHORT nResult=aPrivatDataGrid.GetOutputSizePixel().Width()/nSWidth;
	return nResult;
}

/*************************************************************************
#*	Member:		GetYMaxVisChars								Datum:10.12.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Liefert die Anzahl der maximal sichtbaren Zeichen
#*				in Y-Richtung zurueck.
#*
#*  Input:		Anzahl max. Zeichen
#*
#*	Output:		---
#*
#************************************************************************/
USHORT ScTableWithRuler::GetYMaxVisChars()
{
	USHORT nSHeight=(USHORT)aPrivatDataGrid.GetTextHeight();
	USHORT nResult=aPrivatDataGrid.GetOutputSizePixel().Height()/nSHeight;
	return nResult;
}

/*************************************************************************
#*	Member:		SetNumOfCharsForCol							Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Setzt die Anzahl der Zeichen, die in einer Spalte
#*				angezeigt werden koennen.
#*
#*  Input:		Spalte, Anzahl
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::SetNumOfCharsForCol(USHORT nCol,xub_StrLen nCount)
{
	String aString('X');
	USHORT nSWidth=(USHORT)aPrivatDataGrid.GetTextWidth(aString);

	if(nCol==0)
	{
		Point aPos(0,0);
		aPos.X()=nSWidth*nCount-1;
		//aPrivatRuler.SetXViewPosOffset((USHORT)nSWidth*nCount-1);
		aPrivatRuler.SetPosPixel(aPos);
		Size aPBSize=aPButton.GetOutputSizePixel();
		aPBSize.Width()=aPos.X();
		aPButton.SetOutputSizePixel(aPBSize);

	}

	aPrivatDataGrid.SetWidthOfCol(nCol,nSWidth*nCount);

	USHORT nXMax=aPrivatDataGrid.GetXMaxTableSize()
				-aPrivatDataGrid.GetWidthOfCol(0);
	String aSizeString('X');
	USHORT nWidth=(USHORT) GetTextWidth(aSizeString);
	if(nWidth!=0) aPrivatRuler.SetMaxRulerPos((short)nXMax/nWidth);

}

/*************************************************************************
#*	Member:		GetNumOfCharsForCol							Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Liefert die Anzahl der Zeichen, die in einer Spalte
#*				angezeigt werden koennen.
#*
#*  Input:		Spalte
#*
#*	Output:		Anzahl
#*
#************************************************************************/
xub_StrLen ScTableWithRuler::GetNumOfCharsForCol(USHORT nCol)
{
	String aString('X');
	USHORT nSWidth=(USHORT)aPrivatDataGrid.GetTextWidth(aString);
	USHORT nResult=aPrivatDataGrid.GetWidthOfCol(nCol)/nSWidth;
	return nResult;
}


/*************************************************************************
#*	Member:		RulerEnabled								Datum:05.12.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Schaltet das Lineal ein oder aus.
#*
#*  Input:		Flag
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::RulerEnabled(BOOL bFlag)
{
	if(bFlag)
	{
		aPButton.Enable();
		aPrivatRuler.Enable();
	}
	else
	{
		aPButton.Disable();
		aPrivatRuler.Disable();
	}
}

/*************************************************************************
#*	Member:		InsertContextEntry							Datum:09.12.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Fuegt Eintraege fuer das Context-Menu ein.
#*
#*  Input:		Id, Text, Eigenschaften, Pos
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::InsertContextEntry(USHORT nItemId, const XubString& rStr,
								MenuItemBits nItemBits,USHORT nPos)
{
	aPrivatDataGrid.InsertContextEntry(nItemId,rStr,nItemBits,nPos);
}

/*************************************************************************
#*	Handler:	SepRulerHdl									Datum:25.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Wird aufgerufen, wenn ein Separator im Lineal
#*				veraendert wird.
#*
#*  Input:		Zeiger auf Klasse
#*
#*	Output:		---
#*
#************************************************************************/

IMPL_LINK( ScTableWithRuler, SepRulerHdl, void *, ctrPtr)
{
	Size aOutputSize=GetOutputSizePixel();
	Point P1;
	Point P2;
	P1.Y()=0;
	P2.Y()=aOutputSize.Height();
	if(nMousePos>0)
	{
		P1.X()=nMousePos;
		P2.X()=nMousePos+1;

		Invert(Rectangle(P1,P2));
		nMousePos=0;
	}

	xub_StrLen nNumOfChars=0;
	if((ScRuler*)ctrPtr==&aPrivatRuler)
	{
		xub_StrLen nCount=0;
		USHORT nMax=aPrivatDataGrid.GetNumberOfCols();
		xub_StrLen n2Count=0;
		for(int i=1;i<nMax;i++)
		{
			nNumOfChars=GetNumOfCharsForCol(i);
			nCount+=nNumOfChars;
			if(nCount>aPrivatRuler.GetActiveSepPos())
			{
				break;
			}
			n2Count+=nNumOfChars;
		}

		if(i!=nMax)
		{
			USHORT nSelCol=(USHORT)aPrivatDataGrid.GetSelectedCol();

			InsertCol(i+1,1);

			if(nSelCol>i)
			{
				aPrivatDataGrid.SetSelectedCol(nSelCol+1);
			}

			SetNumOfCharsForCol(i+1,nCount-aPrivatRuler.GetActiveSepPos());
			nCount-=GetNumOfCharsForCol(i);
			nCount=aPrivatRuler.GetActiveSepPos()-nCount;
			SetNumOfCharsForCol(i,nCount);
			String aString;
			aString=GetDataAtRowCol(0,i);

			if(nDelCol-1==i)
			{
				SetDataAtRowCol(0,i+1,DelColType);
			}
			else
			{
				SetDataAtRowCol(0,i+1,aString);
				nDelCol=-1;
				DelColType.Erase();
			}

			for(int j=1;j<aPrivatDataGrid.GetNumberOfRows();j++)
			{
				aString=GetDataAtRowCol(j,i);
				SetDataAtRowCol( j, i, aString.Copy( 0, nCount ) );
				SetDataAtRowCol( j, i+1, aString.Copy( nCount, nNumOfChars ) );
			}

		}
		CtrModifyCol();
	}
	aPrivatRuler.SetActivSep(FALSE);
	aPButton.Check(FALSE);
	if(aPButton.HasFocus())GrabFocus();
	return( 0L );
}

/*************************************************************************
#*	Handler:	SepRulerMovHdl								Datum:20.11.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Wird aufgerufen, wenn die Maus im Lineal bewegt wird.
#*				Zeigt die Seperationsmarke an.
#*
#*  Input:		Zeiger auf Objekt
#*
#*	Output:		---
#*
#************************************************************************/

IMPL_LINK( ScTableWithRuler, SepRulerMovHdl, void *, ctrPtr)
{
	Size aOutputSize=GetOutputSizePixel();
	Point P1;
	Point P2;
	P1.Y()=0;
	P2.Y()=aOutputSize.Height();

	USHORT nNumOfChars=0;

	if((ScRuler*)ctrPtr==&aPrivatRuler)
	{
		if(nMousePos>0)
		{
			P1.X()=nMousePos;
			P2.X()=nMousePos+1;

			Invert(Rectangle(P1,P2));
		}
		P1.X()=aPrivatRuler.GetMousePos().X()
				+aPrivatRuler.GetPosPixel().X();


		long nY=aPrivatRuler.GetMousePos().Y();
		if(P1.X()>0 && P1.X()<aOutputSize.Width() &&
			nY>0 && nY<P2.Y())
		{
			P2.X()=P1.X()+1;
			Invert(Rectangle(P1,P2));
			nMousePos=(USHORT) P1.X();
		}
		else
		{
			aPrivatRuler.SetActivSep(FALSE);
			aPButton.Check(FALSE);
			aPrivatRuler.ReleaseMouse();
			nMousePos=0;
		}
	}
	return( 0L );
}

/*************************************************************************
#*	Handler:	ContextMenuHdl								Datum:06.12.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Wird aufgerufen, wenn das Kontextmenu aufgerufen wurde.
#*				Der entsprechende Eintrag wird uebernommen
#*
#*  Input:		Zeiger auf Objekt
#*
#*	Output:		---
#*
#************************************************************************/

IMPL_LINK( ScTableWithRuler, ContextMenuHdl, ScDataGrid *, ctrPtr)
{
	if(ctrPtr==&aPrivatDataGrid &&
		aPrivatDataGrid.GetSelectedContextCmd()>=0)
	{
		String aString=aPrivatDataGrid.GetSelectedContextText();
		USHORT nSelCol=(USHORT)aPrivatDataGrid.GetSelectedCol();
		aPrivatDataGrid.SetDataAtRowCol(0,nSelCol,aString);
		CtrModifyCol();
		CtrSelection();
	}
	return( 0L );
}

/*************************************************************************
#*	Handler:	MyModifyHdl									Datum:12.09.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Wird aufgerufen, wenn der Pushbutton ausgeloest wurde.
#*				Sorgt fuer ein Umlenken der Mouse-Events
#*
#*  Input:		Zeiger auf Objekt
#*
#*	Output:		---
#*
#************************************************************************/

IMPL_LINK( ScTableWithRuler, ButtonHdl, PushButton * ,pCtr)
{
	if(pCtr==&aPButton)
	{
		aPrivatRuler.SetActivSep();
		aPrivatRuler.CaptureMouse();
		aPButton.Check(TRUE);
	}
	return( 0L );
}
/*************************************************************************
#*	Handler:	SepRulerDownHdl								Datum:01.12.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		SvxWinOrientation
#*
#*  Funktion:	Wird ausgeloest, wenn die Maus gedrueckt wird,
#*				sorgt fuer die Selektion der entsprechenden Spalte,
#*				sowie dem Entfernen einer Separationsmarke.
#*
#*  Input:		Zeiger auf Objekt
#*
#*	Output:		---
#*
#************************************************************************/

IMPL_LINK( ScTableWithRuler, SepRulerDownHdl, void *, ctrPtr)
{
	String aString;
	Size aOutputSize=GetOutputSizePixel();
	Point P1;
	Point P2;
	P1.Y()=0;
	P2.Y()=aOutputSize.Height();

	xub_StrLen nNumOfChars=0;
	if((ScRuler*)ctrPtr==&aPrivatRuler)
	{
		if(!aPrivatRuler.IsActiveNew())
		{
			xub_StrLen nCount=0;
			USHORT nMax=aPrivatDataGrid.GetNumberOfCols();
			xub_StrLen n2Count=0;
			for(int i=1;i<nMax;i++)
			{
				nNumOfChars=GetNumOfCharsForCol(i);
				nCount+=nNumOfChars;
				if(nCount==aPrivatRuler.GetActiveSepPos())
				{
					break;
				}
				n2Count+=nNumOfChars;
			}


			if(i!=nMax)
			{
				nNumOfChars=GetNumOfCharsForCol(i)
							+GetNumOfCharsForCol(i+1);

				DelColType=GetDataAtRowCol(0,i+1);
				nDelCol=i+1;

				for(int j=1;j<aPrivatDataGrid.GetNumberOfRows();j++)
				{
					aString = GetDataAtRowCol(j,i);
					aString += GetDataAtRowCol(j,i+1);
					SetDataAtRowCol(j,i,aString);
				}
				DeleteCol(i+1);
				SetNumOfCharsForCol(i,nNumOfChars);
				aPrivatRuler.RemoveSeparator(aPrivatRuler.GetActiveSepPos());
			}
		}
	}
	else if((ScDataGrid*)ctrPtr==&aPrivatDataGrid)
	{
		Pair aPair;
		if(aPrivatDataGrid.GetSelectedRow()>0)
		{
			aPrivatDataGrid.SetSelectedRow(-1);
			aPair=aPrivatDataGrid.GetFirstVisibleCell();
		}
		else
		{
			aPair=aPrivatDataGrid.GetSelectedCell();
		}
		aPrivatDataGrid.SetSelectedCol(aPair.B());
		aPrivatDataGrid.Invalidate();
		aPrivatDataGrid.Update();
		CtrSelection();
	}

	return( 0L );
}

/*************************************************************************
#*	Member:		CtrSelection								Datum:11.12.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				eine Spalte selektiert wurde.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::CtrSelection()
{
	aSelectionLink.Call( this );
}

/*************************************************************************
#*	Member:		CtrModified									Datum:11.12.97
#*------------------------------------------------------------------------
#*
#*  Klasse:		ScTableWithRuler
#*
#*  Funktion:	Teilt einem installierten Handler mit, dass
#*				eine Spalte modifiziert wurde.
#*
#*  Input:		---
#*
#*	Output:		---
#*
#************************************************************************/
void ScTableWithRuler::CtrModifyCol()
{
	aModifyColLink.Call( this );
}


