/*************************************************************************
 *
 *  $RCSfile: XclExpDocContent.hxx,v $
 *
 *  $Revision: 1.2.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 16:28:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SC_XCLEXPDOCCONTENT_HXX
#define _SC_XCLEXPDOCCONTENT_HXX

#ifndef _SC_XCLTOOLS_HXX
#include "XclTools.hxx"
#endif

#ifndef SC_RANGELST_HXX
#include "rangelst.hxx"
#endif

#include "excrecds.hxx"


/* ============================================================================
Classes to export the big Excel document contents (related to several cells or
globals for the document).
- Label ranges
- Validation
============================================================================ */

// Label ranges ===============================================================

// XclExpRecLabelRanges -------------------------------------------------------

/** Provides export of the row/column label range list of a sheet. */
class XclExpRecLabelranges : public XclExpRecord
{
private:
    ScRangeList                 maRowRanges;    /// Cell range list for row labels.
    ScRangeList                 maColRanges;    /// Cell range list for column labels.

    /** Fills the specified range list with all label headers of the current sheet.
        @param rRanges  The cell range list to fill.
        @param xLabelRangesRef  The core range list with all ranges.
        @param nTab  The current sheet index. */
    void                        FillRangeList( ScRangeList& rRanges, ScRangePairListRef xLabelRangesRef, sal_uInt16 nTab );

    /** Writes the body of the LABELRANGES record. */
    virtual void                WriteBody( XclExpStream& rStrm );

public:
    /** Fills the cell range lists with all ranges of the current sheet. */
                                XclExpRecLabelranges( RootData& rRootData );

    /** Writes the LABELRANGES record if it contains at least one range. */
    virtual void                Save( XclExpStream& rStrm );
};


// Validation =================================================================

class ScValidationData;

// XclExpRecDv ----------------------------------------------------------------

/** Provides export of the data of a DV record. This record contains the
    settings for a data validation. In detail this is a pointer to the core
    validation data and a cell range list with all affected cells. The handle
    index is used to optimize list search algorithm. */
class XclExpRecDv : public XclExpRecord, public ExcRoot
{
private:
    ScRangeList             maRanges;   /// A list with all affected cells.
    const ScValidationData* mpValData;  /// Pointer to the core data (no ownership).
    sal_uInt32              mnHandle;   /// The core handle for quick list search.

    /** Writes the body of the DV record. */
    virtual void            WriteBody( XclExpStream& rStrm );

public:
                            XclExpRecDv( RootData& rRootData, sal_uInt32 nHandle );

    /** @return  The core handle of the validation data. */
    inline sal_uInt32       GetHandle() const       { return mnHandle; }

    /** Inserts a new cell range into the cell range list. */
    void                    InsertCellRange( const ScRange& rPos );
    /** Checks the record contents and crops the range list.
        @return  <FALSE> = Do not write this record. */
    sal_Bool                CheckWriteRecord();
};

// XclExpRecDval --------------------------------------------------------------

/** The DVAL record contains the number of following DV records. This class
    contains the DV record list too. */
class XclExpRecDval : public XclExpRecord, public ExcRoot
{
private:
    XclExpRecordList< XclExpRecDv > maDvList;   /// List of DV records
    XclExpRecDv*            mpLastFoundDv;      /// For search optimization.

    /** Searches for or creates a XclExpRecDv record object with the specified handle. */
    XclExpRecDv&            SearchOrCreateDv( sal_uInt32 nHandle );

    /** Writes the body of the DVAL record. */
    virtual void            WriteBody( XclExpStream& rStrm );

public:
                            XclExpRecDval( RootData& rRootData );

    /** Inserts the specified cell range into the range list of the DV record,
        that represents the validation with the specified handle. */
    void                    InsertCellRange( const ScRange& rRange, sal_uInt32 nHandle );

    /** Writes the DVAL record and the DV record list. */
    virtual void            Save( XclExpStream& rStrm );
};


// ============================================================================

#endif

