/*************************************************************************
 *
 *  $RCSfile: XclChartsApiHelper.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/28 16:41:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifndef _SC_XCLCHARTSAPIHELPER_HXX
#define _SC_XCLCHARTSAPIHELPER_HXX

#ifndef _COM_SUN_STAR_DRAWING_LINEDASH_HPP_
#include <com/sun/star/drawing/LineDash.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_LINESTYLE_HPP_
#include <com/sun/star/drawing/LineStyle.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FILLSTYLE_HPP_
#include <com/sun/star/drawing/FillStyle.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_GRADIENT_HPP_
#include <com/sun/star/awt/Gradient.hpp>
#endif

#ifndef _SC_FILTERAPIHELPER_HXX
#include "FilterApiHelper.hxx"
#endif


struct XclFontData;


//_____________________________________________________________________________

/// Helper class for usage of XMultiPropertySet for chart line settings.
class XclLineMultiPSHelper
{
private:
    ScfMultiPSHelper            aMultiPSHelper_NoDash;      /// Properties for solid lines.
    ScfMultiPSHelper            aMultiPSHelper_Dash;        /// Properties for dashed lines.

public:
                                XclLineMultiPSHelper();

                                /// Applies all line properties to the XMultiPropertySet.
    sal_Bool                    setProperties(
                                    const CSS::uno::Reference< CSS::beans::XMultiPropertySet >& xMultiPS,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet,
                                    CSS::drawing::LineStyle eStyle,
                                    const CSS::drawing::LineDash* pDash,
                                    sal_Int32 nWidth,
                                    sal_Int16 nTransp,
                                    sal_Int32 nRGBColor );
};


//_____________________________________________________________________________

/// Helper class for usage of XMultiPropertySet for chart area settings.
class XclAreaMultiPSHelper
{
private:
    ScfMultiPSHelper            aMultiPSHelper_Solid;       /// Properties for solid areas.
    ScfMultiPSHelper            aMultiPSHelper_Gradient;    /// Properties for gradients.

public:
                                XclAreaMultiPSHelper();

                                /// Applies solid area properties to the XMultiPropertySet.
    sal_Bool                    setProperties(
                                    const CSS::uno::Reference< CSS::beans::XMultiPropertySet >& xMultiPS,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet,
                                    CSS::drawing::FillStyle eStyle,
                                    sal_Int32 nRGBColor );
                                /// Applies gradient area properties to the XMultiPropertySet.
    sal_Bool                    setProperties(
                                    const CSS::uno::Reference< CSS::beans::XMultiPropertySet >& xMultiPS,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet,
                                    const CSS::awt::Gradient& rGradient );
};


//_____________________________________________________________________________

/// Helper class for usage of XMultiPropertySet for chart font settings.
class XclFontMultiPSHelper : private ScfMultiPSHelper
{
public:
                                XclFontMultiPSHelper();

                                /// Applies all properties contained in the Excel font object to the XMultiPropertySet.
    sal_Bool                    setProperties(
                                    const CSS::uno::Reference< CSS::beans::XMultiPropertySet >& xMultiPS,
                                    const CSS::uno::Reference< CSS::beans::XPropertySet >& xPropSet,
                                    const XclFontData& rFontData );
};


//_____________________________________________________________________________

#endif

