/*************************************************************************
 *
 *  $RCSfile: XclImpStyleBuffer.cxx,v $
 *
 *  $Revision: 1.8.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2003/03/26 13:19:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//___________________________________________________________________

#ifndef _SC_XCLIMPSTYLEBUFFER_HXX
#include "XclImpStyleBuffer.hxx"
#endif

#ifndef _SFX_PRINTER_HXX
#include <sfx2/printer.hxx>
#endif
#ifndef _SV_METRIC_HXX
#include <vcl/metric.hxx>
#endif
#ifndef _ZFORLIST_HXX
#include <svtools/zforlist.hxx>
#endif

#ifndef SC_ITEMS_HXX
#include "scitems.hxx"
#endif
#ifndef _SVX_WGHTITEM_HXX
#include <svx/wghtitem.hxx>
#endif
#ifndef _SVX_UDLNITEM_HXX
#include <svx/udlnitem.hxx>
#endif
#ifndef _SVX_POSTITEM_HXX
#include <svx/postitem.hxx>
#endif
#ifndef _SVX_CRSDITEM_HXX
#include <svx/crsditem.hxx>
#endif
#ifndef _SVX_ITEM_HXX
#include <svx/cntritem.hxx>
#endif
#ifndef _SVX_SHDDITEM_HXX
#include <svx/shdditem.hxx>
#endif
#ifndef _SVX_ESCPITEM_HXX
#include <svx/escpitem.hxx>
#endif
#ifndef _SVX_ALGITEM_HXX
#include <svx/algitem.hxx>
#endif
#ifndef _SVX_BOXITEM_HXX
#include <svx/boxitem.hxx>
#endif
#ifndef _SVX_ROTMODIT_HXX
#include <svx/rotmodit.hxx>
#endif
#ifndef _SVX_COLRITEM_HXX
#include <svx/colritem.hxx>
#endif
#ifndef _SVX_BRSHITEM_HXX
#include <svx/brshitem.hxx>
#endif
#ifndef _EEITEM_HXX
#include <svx/eeitem.hxx>
#endif

#ifndef SC_DOCUMENT_HXX
#include "document.hxx"
#endif
#ifndef SC_SCDOCPOL_HXX
#include "docpool.hxx"
#endif
#ifndef SC_SCATTR_HXX
#include "attrib.hxx"
#endif
#ifndef SC_STLPOOL_HXX
#include "stlpool.hxx"
#endif

#ifndef _SC_XCLTOOLS_HXX
#include "XclTools.hxx"
#endif
#ifndef _SC_XCLIMPSTREAM_HXX
#include "XclImpStream.hxx"
#endif

#ifndef _FONTBUFF_HXX
#include "fontbuff.hxx"
#endif


//___________________________________________________________________
// class XclImpFont

void XclImpFont::ReadFontData2( XclImpStream& rStrm )
{
    sal_uInt16 nFlags;
    rStrm >> nHeight >> nFlags;

    eUnderline  = ::hasFlag( nFlags, EXC_FONTATTR_UNDERLINE ) ? xlUnderlSingle : xlUnderlNone;
    nWeight     = ::hasFlag( nFlags, EXC_FONTATTR_BOLD ) ? EXC_FONTWGHT_BOLD : EXC_FONTWGHT_NORMAL;
    bItalic     = ::hasFlag( nFlags, EXC_FONTATTR_ITALIC );
    bStrikeout  = ::hasFlag( nFlags, EXC_FONTATTR_STRIKEOUT );
    bOutline    = ::hasFlag( nFlags, EXC_FONTATTR_OUTLINE );
    bShadow     = ::hasFlag( nFlags, EXC_FONTATTR_SHADOW );
}

void XclImpFont::ReadFontData5( XclImpStream& rStrm )
{
    sal_uInt16 nFlags, nEscapem;
    sal_uInt8 nUnderline;

    rStrm   >> nHeight
            >> nFlags
            >> nColor
            >> nWeight
            >> nEscapem
            >> nUnderline
            >> nFamily
            >> nCharSet;
    rStrm.Ignore( 1 );

    eUnderline  = static_cast< XclUnderline >( nUnderline );
    eEscapem    = static_cast< XclEscapement >( nEscapem );
    bItalic     = ::hasFlag( nFlags, EXC_FONTATTR_ITALIC );
    bStrikeout  = ::hasFlag( nFlags, EXC_FONTATTR_STRIKEOUT );
    bOutline    = ::hasFlag( nFlags, EXC_FONTATTR_OUTLINE );
    bShadow     = ::hasFlag( nFlags, EXC_FONTATTR_SHADOW );
}

void XclImpFont::ReadFontName2( XclImpStream& rStrm )
{
    aName.Erase();
    rStrm.AppendByteString( aName, sal_False );
}

void XclImpFont::ReadFontName8( XclImpStream& rStrm )
{
    aName.Erase();
    rStrm.AppendUniString( aName, rStrm.ReaduInt8() );
}

void XclImpFont::GuessScriptType()
{
    // #91658# find the script types for which the font contains characters
    SfxPrinter* pPrinter = pExcRoot->pDoc->GetPrinter();
    if( pPrinter )
    {
        Font aFont( aName, Size( 0, 10 ) );
        FontCharMap aCharMap;

        pPrinter->SetFont( aFont );
        if( pPrinter->GetFontCharMap( aCharMap ) )
        {
            bIsAsian = (aCharMap.HasChar( 0x4E01 ) ||       // CJK unified ideographs
                        aCharMap.HasChar( 0x7E01 ) ||       // CJK unified ideographs
                        aCharMap.HasChar( 0xAC01 ) ||       // Hangul syllables
                        aCharMap.HasChar( 0xCC01 ) ||       // Hangul syllables
                        aCharMap.HasChar( 0xF901 ));        // CJK compatibility ideographs
            //2do: complex characters

            bIsWestern = aCharMap.HasChar( 'A' ) || (!bIsAsian && !bIsComplex);
        }
    }
}

void XclImpFont::ReadFont( XclImpStream& rStrm, XclBiff eBiff )
{
    switch( eBiff )
    {
        case xlBiff2:
            ReadFontData2( rStrm );
            ReadFontName2( rStrm );
        break;
        case xlBiff3:
        case xlBiff4:
            ReadFontData2( rStrm );
            rStrm >> nColor;
            ReadFontName2( rStrm );
        break;
        case xlBiff5:
        case xlBiff7:
            ReadFontData5( rStrm );
            ReadFontName2( rStrm );
        break;
        case xlBiff8:
            ReadFontData5( rStrm );
            ReadFontName8( rStrm );
        break;
        default:
            ASSERT_UNKNOWNBIFF();
            return;
    }
    eFontFamily = GetScFontFamily( nFamily, aName, *pExcRoot->pCharset );
    eFontCharSet = GetScFontCharSet( nCharSet );
    GuessScriptType();
}

double XclImpFont::CalcColumnScale() const
{
    double fScale;
    switch( nHeight )
    {
        case 240:   fScale = 1.21860;   break;  // 12pt
        case 320:   fScale = 1.61040;   break;  // 16pt
        default:
        {
            SfxPrinter* pPrinter = pExcRoot->pDoc->GetPrinter();
            if( pPrinter )
            {
                Font aFont( aName, Size( 0, nHeight ) );
                aFont.SetFamily( eFontFamily );
                aFont.SetCharSet( eFontCharSet );
                pPrinter->SetFont( aFont );
                fScale = pPrinter->GetTextWidth( String( '0' ) );
                fScale /= 111.0;
            }
            else
            {
                fScale = nHeight;
                fScale /= 200.0;    // default height = 10pt = 200twips
            }
        }
    }
    return fScale;
}

void XclImpFont::FillToItemSet( SfxItemSet& rItemSet, XclFontWhichIDMode eMode ) const
{
    sal_Bool bEE = (eMode == xlFontEEIDs);

// aItem = the item to put into the ItemSet
// nScID = the Calc which ID of the item
// nEEID = the edit engine which ID of the item
#define PUTITEM( aItem, nScID, nEEID )  rItemSet.Put( aItem, (bEE ? nEEID : nScID) )

// Font item - #91658# set only for valid script types
    CharSet eTempCharSet = (bEE && (eFontCharSet == *pExcRoot->pCharset)) ?
        ScfTools::GetSystemCharSet() : eFontCharSet;

    SvxFontItem aFontItem( eFontFamily, aName, EMPTY_STRING, PITCH_DONTKNOW, eTempCharSet );
    if( bIsWestern )
        PUTITEM( aFontItem, ATTR_FONT,      EE_CHAR_FONTINFO );
    if( bIsAsian )
        PUTITEM( aFontItem, ATTR_CJK_FONT,  EE_CHAR_FONTINFO_CJK );
    if( bIsComplex )
        PUTITEM( aFontItem, ATTR_CTL_FONT,  EE_CHAR_FONTINFO_CTL );

// Font height (for all script types)
    sal_Int32 nScHeight = nHeight;
    if( bEE )
        nScHeight = static_cast< sal_Int32 >( HMM_PER_TWIPS * nScHeight );

    SvxFontHeightItem aHeightItem( nScHeight );
    PUTITEM( aHeightItem,   ATTR_FONT_HEIGHT,       EE_CHAR_FONTHEIGHT );
    PUTITEM( aHeightItem,   ATTR_CJK_FONT_HEIGHT,   EE_CHAR_FONTHEIGHT_CJK );
    PUTITEM( aHeightItem,   ATTR_CTL_FONT_HEIGHT,   EE_CHAR_FONTHEIGHT_CTL );

// Font color
    PUTITEM( *pExcRoot->pColor->GetColor( nColor ), ATTR_FONT_COLOR, EE_CHAR_COLOR );

// Font weight (for all script types)
    SvxWeightItem aWeightItem( GetScFontWeight( nWeight ) );
    PUTITEM( aWeightItem,   ATTR_FONT_WEIGHT,       EE_CHAR_WEIGHT );
    PUTITEM( aWeightItem,   ATTR_CJK_FONT_WEIGHT,   EE_CHAR_WEIGHT_CJK );
    PUTITEM( aWeightItem,   ATTR_CTL_FONT_WEIGHT,   EE_CHAR_WEIGHT_CTL );

// Font underline
    FontUnderline eSvxUnderl = GetScFontUnderline( eUnderline );
    if( bEE || (eSvxUnderl != UNDERLINE_NONE) )
        PUTITEM( SvxUnderlineItem( eSvxUnderl ), ATTR_FONT_UNDERLINE, EE_CHAR_UNDERLINE );

// Font posture (for all script types)
    if( bEE || bItalic )
    {
        SvxPostureItem aPostItem( bItalic ? ITALIC_NORMAL : ITALIC_NONE );
        PUTITEM( aPostItem, ATTR_FONT_POSTURE,      EE_CHAR_ITALIC );
        PUTITEM( aPostItem, ATTR_CJK_FONT_POSTURE,  EE_CHAR_ITALIC_CJK );
        PUTITEM( aPostItem, ATTR_CTL_FONT_POSTURE,  EE_CHAR_ITALIC_CTL );
    }

// Boolean attributes crossed out, contoured, shadowed
    if( bEE || bStrikeout )
        PUTITEM( SvxCrossedOutItem( bStrikeout ? STRIKEOUT_SINGLE : STRIKEOUT_NONE ),
            ATTR_FONT_CROSSEDOUT, EE_CHAR_STRIKEOUT );
    if( bEE || bOutline )
        PUTITEM( SvxContourItem( bOutline ), ATTR_FONT_CONTOUR, EE_CHAR_OUTLINE );
    if( bEE || bShadow )
        PUTITEM( SvxShadowedItem( bShadow ), ATTR_FONT_SHADOWED, EE_CHAR_SHADOW );

// Super-/subscript: only on edit engine objects
    if( bEE )
        rItemSet.Put( SvxEscapementItem( GetScFontEscapement( eEscapem ), EE_CHAR_ESCAPEMENT ) );

#undef PUTITEM
}

FontFamily XclImpFont::GetScFontFamily( sal_uInt8 nXclFamily, const String& aName, CharSet eDefCharSet )
{
    FontFamily eScFamily;
    // ! format differs from Windows documentation: family is in lower nibble, pitch unknown
    switch( nXclFamily & 0x0F )
	{
        case EXC_FONTFAM_ROMAN:         eScFamily = FAMILY_ROMAN;       break;
        case EXC_FONTFAM_SWISS:         eScFamily = FAMILY_SWISS;       break;
        case EXC_FONTFAM_MODERN:        eScFamily = FAMILY_MODERN;      break;
        case EXC_FONTFAM_SCRIPT:        eScFamily = FAMILY_SCRIPT;      break;
        case EXC_FONTFAM_DECORATIVE:    eScFamily = FAMILY_DECORATIVE;  break;
		default:
            eScFamily =
                ((eDefCharSet == RTL_TEXTENCODING_APPLE_ROMAN) &&
                 (aName.EqualsAscii( "Geneva" ) || aName.EqualsAscii( "Chicago" ))) ?
                FAMILY_SWISS : FAMILY_DONTKNOW;
	}
    return eScFamily;
}

CharSet XclImpFont::GetScFontCharSet( sal_uInt8 nXclCharSet )
{
    CharSet eScCharSet;
    switch( nXclCharSet )
	{
        case EXC_FONTCSET_MS_1252:  eScCharSet = RTL_TEXTENCODING_MS_1252;  break;
        case EXC_FONTCSET_IBM_850:  eScCharSet = RTL_TEXTENCODING_IBM_850;  break;
        case EXC_FONTCSET_SYMBOL:   eScCharSet = RTL_TEXTENCODING_SYMBOL;   break;
        default:                    eScCharSet = ScfTools::GetSystemCharSet();
	}
    return eScCharSet;
}

FontWeight XclImpFont::GetScFontWeight( sal_uInt16 nXclWeight )
{
    FontWeight eScWeight;

    if( !nXclWeight )               eScWeight = WEIGHT_DONTKNOW;
    else if( nXclWeight < 150 )     eScWeight = WEIGHT_THIN;
    else if( nXclWeight < 250 )     eScWeight = WEIGHT_ULTRALIGHT;
    else if( nXclWeight < 325 )     eScWeight = WEIGHT_LIGHT;
    else if( nXclWeight < 375 )     eScWeight = WEIGHT_SEMILIGHT;
    else if( nXclWeight < 450 )     eScWeight = WEIGHT_NORMAL;
    else if( nXclWeight < 550 )     eScWeight = WEIGHT_MEDIUM;
    else if( nXclWeight < 650 )     eScWeight = WEIGHT_SEMIBOLD;
    else if( nXclWeight < 750 )     eScWeight = WEIGHT_BOLD;
    else if( nXclWeight < 850 )     eScWeight = WEIGHT_ULTRABOLD;
    else                            eScWeight = WEIGHT_BLACK;

    return eScWeight;
}

FontUnderline XclImpFont::GetScFontUnderline( XclUnderline eXclUnderl )
{
    FontUnderline eScUnderl = UNDERLINE_NONE;
    switch( eXclUnderl )
    {
        case xlUnderlSingle:
        case xlUnderlSingleAcc: eScUnderl = UNDERLINE_SINGLE;  break;
        case xlUnderlDouble:
        case xlUnderlDoubleAcc: eScUnderl = UNDERLINE_DOUBLE;  break;
    }
    return eScUnderl;
}

SvxEscapement XclImpFont::GetScFontEscapement( XclEscapement eXclEscapem )
{
    SvxEscapement eScEscapem = SVX_ESCAPEMENT_OFF;
    switch( eXclEscapem )
    {
        case xlEscSuper:    eScEscapem = SVX_ESCAPEMENT_SUPERSCRIPT;    break;
        case xlEscSub:      eScEscapem = SVX_ESCAPEMENT_SUBSCRIPT;      break;
    }
    return eScEscapem;
}



//___________________________________________________________________
// class XclImpFontBuffer

void XclImpFontBuffer::ReadFont( XclImpStream& rStrm, XclBiff eBiff )
{
    // Font with index 4 is not stored in an Excel file -- create a dummy font.
    if( aFontList.Count() == 4 )
        aFontList.Append( new XclImpFont( *aFontList.GetObject( 0 ) ) );

    XclImpFont* pFont = new XclImpFont( *pExcRoot );
    pFont->ReadFont( rStrm, eBiff );
    aFontList.Append( pFont );

    // Calculate the column scale from first font and current printer.
    if( aFontList.Count() == 1 )
        pExcRoot->fColScale *= pFont->CalcColumnScale();
}

void XclImpFontBuffer::FillToItemSet(
        sal_uInt16 nFontIndex,
        SfxItemSet& rItemSet,
        XclFontWhichIDMode eMode ) const
{
    const XclImpFont* pFont = GetFont( (nFontIndex < aFontList.Count()) ? nFontIndex : 0 );
    if( pFont )
        pFont->FillToItemSet( rItemSet, eMode );
}



//___________________________________________________________________
// class XclImpNumFmtBuffer

/** Stores the SvNumberFormatter index offset of an Excel built-in number format. */
struct XclImpBuiltInFormat
{
    sal_uInt16                  nIndex;         /// Excel built-in index.
    NfIndexTableOffset          eOffset;        /// SvNumberFormatter format index.
    const sal_Char*             pFormat;        /// Format string, if no format index exists.
};

const XclImpBuiltInFormat pBuiltInFormats[] =
{
    {   0,      NF_NUMBER_STANDARD              },  // General
    {   1,      NF_NUMBER_INT                   },  // 0
    {   2,      NF_NUMBER_DEC2                  },  // 0.00
    {   3,      NF_NUMBER_1000INT               },  // #,##0
    {   4,      NF_NUMBER_1000DEC2              },  // #,##0.00
    // 5...8 contained in file
    {   9,      NF_PERCENT_INT                  },  // 0%
    {   10,     NF_PERCENT_DEC2                 },  // 0.00%
    {   11,     NF_SCIENTIFIC_000E00            },  // 0.00E+00
    {   12,     NF_FRACTION_1                   },  // # ?/?
    {   13,     NF_FRACTION_2                   },  // # ??/??
    {   14,     NF_DATE_SYS_DDMMYY              },  // DD.MM.YY
    {   15,     NF_DATE_SYS_DMMMYY              },  // DD. MMM YY
    {   16,     NF_DATE_SYS_DDMMM               },  // DD. MMM
    {   17,     NF_DATE_SYS_MMYY                },  // MMM YY
    {   18,     NF_TIME_HHMMAMPM                },  // h:mm AM/PM
    {   19,     NF_TIME_HHMMSSAMPM              },  // h:mm:ss AM/PM
    {   20,     NF_TIME_HHMM                    },  // hh:mm
    {   21,     NF_TIME_HHMMSS                  },  // hh:mm:ss
    {   22,     NF_DATETIME_SYSTEM_SHORT_HHMM   },  // DD.MM.YYYY hh:mm
    // 23...36 reserved
    {   37,     NF_NUMBER_STANDARD,             "#,##0 _$;-#,##0 _$",              },
    {   38,     NF_NUMBER_STANDARD,             "#,##0 _$;[Red]-#,##0 _$"          },
    {   39,     NF_NUMBER_STANDARD,             "#,##0.00 _$;-#,##0.00 _$"         },
    {   40,     NF_NUMBER_STANDARD,             "#,##0.00 _$;[Red]-#,##0.00 _$"    },
    // 41...44 contained in file
    {   45,     NF_NUMBER_STANDARD,             "mm:ss"                            },
    {   46,     NF_TIME_HH_MMSS                 },  // [h]:mm:ss
    {   47,     NF_TIME_MMSS00                  },  // mm:ss,0
    {   48,     NF_NUMBER_STANDARD,             "##0.0E+0"                         },
    {   49,     NF_TEXT                         }   // @
};

void XclImpNumFmtBuffer::InsertBuiltinFormats()
{
    sal_uInt32 nCount = sizeof( pBuiltInFormats ) / sizeof( XclImpBuiltInFormat );
    const XclImpBuiltInFormat* pLimit = pBuiltInFormats + nCount;

    String aFormat;
    xub_StrLen nCheckPos;
    sal_Int16 nType = NUMBERFORMAT_DEFINED;
    sal_uInt32 nKey;

    for( const XclImpBuiltInFormat* pCurr = pBuiltInFormats; pCurr < pLimit; ++pCurr )
    {
        if( pCurr->pFormat )
        {
            aFormat = String::CreateFromAscii( pCurr->pFormat );
            pExcRoot->pFormTable->PutandConvertEntry( aFormat, nCheckPos, nType, nKey,
                LANGUAGE_ENGLISH_US, pExcRoot->eDefLanguage );
        }
        else
            nKey = pExcRoot->pFormTable->GetFormatIndex( pCurr->eOffset, pExcRoot->eDefLanguage );
        InsertKey( nKey, pCurr->nIndex );
    }
}

void XclImpNumFmtBuffer::InsertKey( sal_uInt32 nFormatKey, sal_uInt16 nIndex )
{
    if( nIndex < aKeyList.Count() )
        aKeyList.Replace( nFormatKey, nIndex );
    else
    {
        while( aKeyList.Count() < nIndex )
            aKeyList.Append( nStandard );
        aKeyList.Append( nFormatKey );
    }
}

sal_uInt32 XclImpNumFmtBuffer::GetFormat( sal_uInt16 nIndex )
{
    if( aKeyList.Empty() )
        InsertBuiltinFormats();

    return (nIndex < aKeyList.Count()) ? aKeyList.GetValue( nIndex ) : nStandard;
}

void XclImpNumFmtBuffer::ReadFormat( XclImpStream& rStrm, XclBiff eBiff )
{
    if( aKeyList.Empty() && (eBiff >= xlBiff5) )
        InsertBuiltinFormats();

    String aFormat;
    sal_uInt16 nIndex;
    sal_Bool bAppend = sal_False;       // BIFF2-BIFF3: append, BIFF4+: read position from record

    switch( eBiff )
    {
        case xlBiff2:
        case xlBiff3:
            rStrm.AppendByteString( aFormat, sal_False );
            bAppend = sal_True;
        break;
        case xlBiff4:
            bAppend = sal_True;         // In BIFF4 the index field exists, but is undefined
        case xlBiff5:
        case xlBiff7:
            rStrm >> nIndex;
            rStrm.AppendByteString( aFormat, sal_False );
        break;
        case xlBiff8:
            rStrm >> nIndex;
            rStrm.AppendUniString( aFormat );
        break;
        default:
            ASSERT_UNKNOWNBIFF();
            return;
    }

    xub_StrLen nCheckPos;
    sal_Int16 nType = NUMBERFORMAT_DEFINED;
    sal_uInt32 nKey;

    pExcRoot->pFormTable->PutandConvertEntry( aFormat, nCheckPos, nType, nKey,
        LANGUAGE_ENGLISH_US, pExcRoot->eDefLanguage );

    if( bAppend )
        aKeyList.Append( nKey );
    else
        InsertKey( nKey, nIndex );
}



//___________________________________________________________________
// class XclImpXF

XclImpXF::~XclImpXF()
{
    if( pPattern )
        delete pPattern;
    if( pBorder )
        delete pBorder;
    if( pArea )
        delete pArea;
}

void XclImpXF::Init()
{
    pPattern = NULL;
    pBorder = NULL;
    pArea = NULL;
    eHorAlign = xlHAlignParent;
    eVerAlign = xlVAlignParent;
    eWrap = xlTextWrapParent;
    eOrient = xlTextOrientParent;
    nValFormat = 0;
    nIndent = nFont = nParent = 0;
    nRotation = 0;
    bCellXF = sal_True;     // default is cell XF
    bLocked = sal_True;     // default in Excel and Calc
    bHidden = bFontValid = bFmtValid = bProtValid = bMerged = sal_False;
}

void XclImpXF::ReadXF2( XclImpStream& rStrm, RootData& rRootData )
{
    sal_uInt8 nFont, nValFmt, nFlags;

    nFont = rStrm.ReaduInt8();
    rStrm.Ignore( 1 );
    rStrm >> nValFmt >> nFlags;

    GetBorder();
    pBorder->nLeftLine      = (nFlags & EXC_XF2_LLINE) ? 1 : 0;
    pBorder->nRightLine     = (nFlags & EXC_XF2_RLINE) ? 1 : 0;
    pBorder->nTopLine       = (nFlags & EXC_XF2_TLINE) ? 1 : 0;
    pBorder->nBottomLine    = (nFlags & EXC_XF2_BLINE) ? 1 : 0;
    pBorder->nLeftColor = pBorder->nRightColor = pBorder->nTopColor = pBorder->nBottomColor = 8;   // black

    nValFormat = rRootData.pNumFmtBuffer->GetFormat( nValFmt & EXC_XF2_VALFMT_MASK );
    eHorAlign = EXC_XF_GETHORALIGN( nFlags );
    eVerAlign = xlVAlignTop;
    eWrap = xlTextWrapNo;
    eOrient = xlTextOrientNoRot;
    bLocked = ::hasFlag( nValFmt, EXC_XF2_LOCKED );
    bHidden = ::hasFlag( nValFmt, EXC_XF2_HIDDEN );

    bFontValid = bFmtValid = bProtValid = sal_True;
}


void lcl_SetBorder34( XclImpXFBorder& rBorder, sal_uInt32 nData )
{
    rBorder.nTopLine     = static_cast< sal_uInt8 > (  nData & 0x00000007 );
    rBorder.nLeftLine    = static_cast< sal_uInt8 > ( (nData & 0x00000700) >> 8 );
    rBorder.nBottomLine  = static_cast< sal_uInt8 > ( (nData & 0x00070000) >> 16 );
    rBorder.nRightLine   = static_cast< sal_uInt8 > ( (nData & 0x07000000) >> 24 );
    rBorder.nTopColor    = static_cast< sal_uInt16 >( (nData & 0x000000F8) >> 3 );
    rBorder.nLeftColor   = static_cast< sal_uInt16 >( (nData & 0x0000F800) >> 11 );
    rBorder.nBottomColor = static_cast< sal_uInt16 >( (nData & 0x00F80000) >> 19 );
    rBorder.nRightColor  = static_cast< sal_uInt16 >( (nData & 0xF8000000) >> 27 );
}

void lcl_SetArea34( XclImpXFArea& rArea, sal_uInt16 nData )
{
    rArea.nPattern   = static_cast< sal_uInt8 > (  nData & 0x003F );
    rArea.nForeColor = static_cast< sal_uInt16 >( (nData & 0x07C0) >> 6 );
    rArea.nBackColor = static_cast< sal_uInt16 >( (nData & 0xF800) >> 11 );
}


void XclImpXF::ReadXF3( XclImpStream& rStrm, RootData& rRootData )
{
    sal_uInt32 nBorder;
    sal_uInt16 nFlags, nAlign, nArea;
    sal_uInt8 nValFmt;

    nFont = rStrm.ReaduInt8();
    rStrm >> nValFmt >> nFlags >> nAlign >> nArea >> nBorder;

    bCellXF = !::hasFlag( nFlags, EXC_XF_STYLE );                       // new in BIFF3
    nParent = EXC_XF_GETPARENT( nAlign );                               // new in BIFF3
    lcl_SetBorder34( GetBorder(), nBorder );
    lcl_SetArea34( GetArea(), nArea );                                  // new in BIFF3
    nValFormat = rRootData.pNumFmtBuffer->GetFormat( nValFmt );
    eHorAlign = EXC_XF_GETHORALIGN( nAlign );
    eVerAlign = xlVAlignTop;
    eWrap = EXC_XF_GETTEXTWRAP( nAlign );                               // new in BIFF3
    eOrient = xlTextOrientNoRot;
    bLocked = ::hasFlag( nFlags, EXC_XF_LOCKED );
    bHidden = ::hasFlag( nFlags, EXC_XF_HIDDEN );

    bFontValid = bFmtValid = bProtValid = sal_True;
}

void XclImpXF::ReadXF4( XclImpStream& rStrm, RootData& rRootData )
{
    sal_uInt32 nBorder;
    sal_uInt16 nFlags, nAlign, nArea;
    sal_uInt8 nValFmt;

    nFont = rStrm.ReaduInt8();
    rStrm >> nValFmt >> nFlags >> nAlign >> nArea >> nBorder;

    bCellXF = !::hasFlag( nFlags, EXC_XF_STYLE );
    nParent = EXC_XF_GETPARENT( nFlags );
    lcl_SetBorder34( GetBorder(), nBorder );
    lcl_SetArea34( GetArea(), nArea );
    nValFormat = rRootData.pNumFmtBuffer->GetFormat( nValFmt );
    eHorAlign = EXC_XF_GETHORALIGN( nAlign );
    eVerAlign = EXC_XF_GETVERALIGN( nAlign );                           // new in BIFF4
    eWrap = EXC_XF_GETTEXTWRAP( nAlign );
    eOrient = EXC_XF4_GETTEXTORIENT( nAlign );                          // new in BIFF4
    bLocked = ::hasFlag( nFlags, EXC_XF_LOCKED );
    bHidden = ::hasFlag( nFlags, EXC_XF_HIDDEN );

    bFontValid = bFmtValid = bProtValid = sal_True;
}

void XclImpXF::ReadXF5( XclImpStream& rStrm, RootData& rRootData )
{
    sal_uInt32 nArea, nBorder;
    sal_uInt16 nValFmt, nFlags, nAlign;
    rStrm >> nFont >> nValFmt >> nFlags >> nAlign >> nArea >> nBorder;

    GetBorder();
    pBorder->nTopLine       = static_cast< sal_uInt8 > (  nBorder & 0x00000007 );
    pBorder->nLeftLine      = static_cast< sal_uInt8 > ( (nBorder & 0x00000038) >> 3 );
    pBorder->nBottomLine    = static_cast< sal_uInt8 > ( (nArea   & 0x01C00000) >> 22);
    pBorder->nRightLine     = static_cast< sal_uInt8 > ( (nBorder & 0x000001C0) >> 6 );
    pBorder->nTopColor      = static_cast< sal_uInt16 >( (nBorder & 0x0000FE00) >> 9 );
    pBorder->nLeftColor     = static_cast< sal_uInt16 >( (nBorder & 0x007F0000) >> 16 );
    pBorder->nBottomColor   = static_cast< sal_uInt16 >( (nArea   & 0xFE000000) >> 25 );
    pBorder->nRightColor    = static_cast< sal_uInt16 >( (nBorder & 0x3F800000) >> 23 );

    GetArea();
    pArea->nPattern     = static_cast< sal_uInt8 > ( (nArea & 0x003F0000) >> 16 );
    pArea->nForeColor   = static_cast< sal_uInt16 >(  nArea & 0x0000007F );
    pArea->nBackColor   = static_cast< sal_uInt16 >( (nArea & 0x00001F80) >> 7 );

    bCellXF = !::hasFlag( nFlags, EXC_XF_STYLE );
    nParent = EXC_XF_GETPARENT( nFlags );
    nValFormat = rRootData.pNumFmtBuffer->GetFormat( nValFmt );
    eHorAlign = EXC_XF_GETHORALIGN( nAlign );
    eVerAlign = EXC_XF_GETVERALIGN( nAlign );
    eWrap = EXC_XF_GETTEXTWRAP( nAlign );
    eOrient = EXC_XF5_GETTEXTORIENT( nAlign );
    bLocked = ::hasFlag( nFlags, EXC_XF_LOCKED );
    bHidden = ::hasFlag( nFlags, EXC_XF_HIDDEN );

    bFontValid = bFmtValid = bProtValid = sal_True;
}

void XclImpXF::ReadXF8( XclImpStream& rStrm, RootData& rRootData )
{
    sal_uInt32 nBorder1, nBorder2;
    sal_uInt16 nReadFont, nValFmt, nFlags1, nAlign, nFlags2, nArea;
    rStrm >> nReadFont >> nValFmt >> nFlags1 >> nAlign >> nFlags2 >> nBorder1 >> nBorder2 >> nArea;

    bCellXF = !::hasFlag( nFlags1, EXC_XF_STYLE );
	if( bCellXF )
        nParent = EXC_XF_GETPARENT( nFlags1 );
    // Border
    if( bCellXF || !::hasFlag( nFlags2, EXC_XF_DIFF_BORDER ) )
	{
        GetBorder();
        pBorder->nLeftLine      = static_cast< sal_uInt8 > (  nBorder1 & 0x0000000F );
        pBorder->nRightLine     = static_cast< sal_uInt8 > ( (nBorder1 & 0x000000F0) >> 4 );
        pBorder->nTopLine       = static_cast< sal_uInt8 > ( (nBorder1 & 0x00000F00) >> 8 );
        pBorder->nBottomLine    = static_cast< sal_uInt8 > ( (nBorder1 & 0x0000F000) >> 12 );
        pBorder->nLeftColor     = static_cast< sal_uInt16 >( (nBorder1 & 0x007F0000) >> 16 );
        pBorder->nRightColor    = static_cast< sal_uInt16 >( (nBorder1 & 0x3F800000) >> 23 );
        pBorder->nTopColor      = static_cast< sal_uInt16 >(  nBorder2 & 0x0000007F );
        pBorder->nBottomColor   = static_cast< sal_uInt16 >( (nBorder2 & 0x00003F80) >> 7 );
	}
    // Area
    if( bCellXF || !::hasFlag( nFlags2, EXC_XF_DIFF_AREA ) )
	{
        GetArea();
        pArea->nPattern     = static_cast< sal_uInt8 > ( (nBorder2 & 0xFC000000) >> 26 );
        pArea->nForeColor   = static_cast< sal_uInt16 >(  nArea & 0x007F );
        pArea->nBackColor   = static_cast< sal_uInt16 >( (nArea & 0x3F80) >> 7 );
	}
    // Font
    bFontValid = bCellXF || !::hasFlag( nFlags2, EXC_XF_DIFF_FONT );
    if( bFontValid )
        nFont = nReadFont;
    // Value format
    bFmtValid = bCellXF || !::hasFlag( nFlags2, EXC_XF_DIFF_VALFMT );
    if( bFmtValid )
        nValFormat = rRootData.pNumFmtBuffer->GetFormat( nValFmt );
    // Alignment
    if( bCellXF || !::hasFlag( nFlags2, EXC_XF_DIFF_ALIGN ) )
	{
        eHorAlign = EXC_XF_GETHORALIGN( nAlign );
        eVerAlign = EXC_XF_GETVERALIGN( nAlign );
        eWrap = EXC_XF_GETTEXTWRAP( nAlign );
        nRotation = EXC_XF8_GETROT( nAlign );
        eOrient = (nRotation == EXC_ROT_STACKED) ? xlTextOrientTopBottom : xlTextOrientRot;
	}
    // Cell protection
    bProtValid = bCellXF || !::hasFlag( nFlags2, EXC_XF_DIFF_PROT );
    if( bProtValid )
	{
        bLocked = ::hasFlag( nFlags1, EXC_XF_LOCKED );
        bHidden = ::hasFlag( nFlags1, EXC_XF_HIDDEN );
	}
    nIndent = EXC_XF8_GETINDENT( nFlags2 );                             // new in BIFF8
    bMerged = ::hasFlag( nFlags2, EXC_XF8_MERGE );                      // new in BIFF8
}

void XclImpXF::ReadXF( XclImpStream& rStrm, RootData& rRootData, XclBiff eBiff )
{
    switch( eBiff )
    {
        case xlBiff2:
            ReadXF2( rStrm, rRootData );
        break;
        case xlBiff3:
            ReadXF3( rStrm, rRootData );
        break;
        case xlBiff4:
            ReadXF4( rStrm, rRootData );
        break;
        case xlBiff5:
        case xlBiff7:
            ReadXF5( rStrm, rRootData );
        break;
        case xlBiff8:
            ReadXF8( rStrm, rRootData );
        break;
        default:
            ASSERT_UNKNOWNBIFF();
    }
}

const ScPatternAttr& XclImpXF::GetPattern( RootData& rRootData )
{
    if( pPattern )
        return *pPattern;

    // create new set item
    pPattern = new ScPatternAttr( rRootData.pDoc->GetPool() );
    SfxItemSet& rItemSet = pPattern->GetItemSet();
    ColorBuffer& rColorBuffer = *rRootData.pColor;

    // value format
    if( bCellXF || bFmtValid )
        rItemSet.Put( SfxUInt32Item( ATTR_VALUE_FORMAT, static_cast< sal_uInt32 >( nValFormat ) ) );

    // font
    if( bCellXF || bFontValid )
        rRootData.pFontBuffer->FillToItemSet( nFont, rItemSet, xlFontScIDs );

    // locked/hidden
    if( bCellXF || bProtValid )
        rItemSet.Put( ScProtectionAttr( bLocked, bHidden ) );

    // border
    if( pBorder )
        SetBorder( rItemSet, rColorBuffer,
            pBorder->nLeftLine, pBorder->nLeftColor,
            pBorder->nRightLine, pBorder->nRightColor,
            pBorder->nTopLine, pBorder->nTopColor,
            pBorder->nBottomLine, pBorder->nBottomColor );

    // area
    if( pArea )
        SetArea( rItemSet, rColorBuffer, pArea->nPattern, pArea->nForeColor, pArea->nBackColor );

    // horizontal alignment
    if( bCellXF || (eHorAlign != xlHAlignParent) )
    {
        SvxCellHorJustify eHorJust = SVX_HOR_JUSTIFY_STANDARD;
        switch( eHorAlign )
        {
            case xlHAlignParent:
            case xlHAlignGeneral:       eHorJust = SVX_HOR_JUSTIFY_STANDARD;    break;
            case xlHAlignLeft:          eHorJust = SVX_HOR_JUSTIFY_LEFT;        break;
            case xlHAlignCenterAcrSel:
            case xlHAlignCenter:        eHorJust = SVX_HOR_JUSTIFY_CENTER;      break;
            case xlHAlignRight:         eHorJust = SVX_HOR_JUSTIFY_RIGHT;       break;
            case xlHAlignFill:          eHorJust = SVX_HOR_JUSTIFY_REPEAT;      break;
            case xlHAlignJustify:       eHorJust = SVX_HOR_JUSTIFY_BLOCK;       break;
            default:
                DBG_ERROR( "XclImpXF::GetPattern - unknown horizontal adjustment" );
        }
        rItemSet.Put( SvxHorJustifyItem( eHorJust ) );
    }

    // text wrap
    if( bCellXF || (eWrap != xlTextWrapParent) )
    {
        SfxBoolItem aWrap( ATTR_LINEBREAK );
        aWrap.SetValue( eWrap == xlTextWrapYes );
        rItemSet.Put( aWrap );
    }

    // vertical alignment
    if( bCellXF || (eVerAlign != xlVAlignParent) )
    {
        SvxCellVerJustify eVertJust = SVX_VER_JUSTIFY_STANDARD;
        switch( eVerAlign )
        {
            case xlVAlignParent:
            case xlVAlignTop:       eVertJust = SVX_VER_JUSTIFY_TOP;    break;
            case xlVAlignCenter:    eVertJust = SVX_VER_JUSTIFY_CENTER; break;
            case xlVAlignBottom:    eVertJust = SVX_VER_JUSTIFY_BOTTOM; break;
            case xlVAlignJustify:   eVertJust = SVX_VER_JUSTIFY_TOP;    break;
            default:
                DBG_ERROR( "XclImpXF::GetPattern - unknown vertical adjustment" );
        }
        rItemSet.Put( SvxVerJustifyItem( eVertJust ) );
    }

    // indent
    if( nIndent > 0 )
        rItemSet.Put( SfxUInt16Item( ATTR_INDENT, nIndent ) );

    // text orientation
    if( bCellXF || (eOrient != xlTextOrientParent) )
    {
        if( (eOrient == xlTextOrientRot) && (nRotation != EXC_ROT_STACKED) )
        {
            // set an angle in the range from -90 to 90 degrees
            DBG_ASSERT( nRotation <= 180, "XclImpXF::GetPattern - illegal rotation angle" );
            sal_Int32 nAngle = XclTools::GetScRotation( nRotation );
            if( nAngle == 9000 )
                rItemSet.Put( SvxOrientationItem( SVX_ORIENTATION_BOTTOMTOP ) );
            else if( nAngle == 27000 )
                rItemSet.Put( SvxOrientationItem( SVX_ORIENTATION_TOPBOTTOM ) );
            rItemSet.Put( SfxInt32Item( ATTR_ROTATE_VALUE, nAngle ) );
            rItemSet.Put( SvxRotateModeItem( SVX_ROTATE_MODE_STANDARD, ATTR_ROTATE_MODE ) );
        }
        else
        {
            // set "stacked" or standard values for rotation
            SvxCellOrientation eSvxOrient = SVX_ORIENTATION_STANDARD;
            switch( eOrient )
            {
                case xlTextOrientParent:
                case xlTextOrientNoRot:     eSvxOrient = SVX_ORIENTATION_STANDARD;   break;
                case xlTextOrientRot:
                    DBG_ASSERT( nRotation == EXC_ROT_STACKED,
                        "XclImpXF::GetPattern - stacked expected (0xFF)" );
                case xlTextOrientTopBottom: eSvxOrient = SVX_ORIENTATION_STACKED;    break;
                case xlTextOrient90ccw:     eSvxOrient = SVX_ORIENTATION_BOTTOMTOP;  break;
                case xlTextOrient90cw:      eSvxOrient = SVX_ORIENTATION_TOPBOTTOM;  break;
                default:
                    DBG_ERROR( "XclImpXF::GetPattern - unknown text orientation" );
            }
            rItemSet.Put( SvxOrientationItem( eSvxOrient ) );
        }
    }
    return *pPattern;
}

sal_uInt8 XclImpXF::GetMixedColor( sal_uInt8 nBack, sal_uInt8 nFore, sal_uInt16 nRatio )
{
    sal_Int32 nTemp = ((static_cast< sal_Int32 >( nBack ) - nFore) * nRatio) / 0x8000 + nFore;
    return static_cast< sal_uInt8 >( nTemp );
}

SvxBorderLine* XclImpXF::CreateBorderItem( sal_uInt8 nLine, sal_uInt16 nColor, ColorBuffer& rColorBuffer )
{
    if( !nLine )
        return NULL;
    else if( nLine > 7 )
        nLine = 1;

    if( nColor == 64 )      // auto for line -> black
        nColor = 0;

    const SvxColorItem* pColorItem = rColorBuffer.GetColor( nColor, sal_False );    // no defaults
    if( !pColorItem )
        return NULL;

    const static sal_uInt16 ppLineParam[ 8 ][ 3 ] =
    {
        //  outer width,        inner width,        distance
        {   0,                  0,                  0 },                // 0 = none
        {   DEF_LINE_WIDTH_1,   0,                  0 },                // 1 = thin
        {   DEF_LINE_WIDTH_2,   0,                  0 },                // 2 = medium
        {   DEF_LINE_WIDTH_1,   0,                  0 },                // 3 = dashed
        {   DEF_LINE_WIDTH_0,   0,                  0 },                // 4 = dotted
        {   DEF_LINE_WIDTH_3,   0,                  0 },                // 5 = thick
        {   DEF_LINE_WIDTH_1,   DEF_LINE_WIDTH_1,   DEF_LINE_WIDTH_1 }, // 6 = double
        {   DEF_LINE_WIDTH_0,   0,                  0 }                 // 7 = hair
    };

    SvxBorderLine* pItem = new SvxBorderLine;
    pItem->SetColor( pColorItem->GetValue() );
    pItem->SetOutWidth( ppLineParam[ nLine ][ 0 ] );
    pItem->SetInWidth( ppLineParam[ nLine ][ 1 ] );
    pItem->SetDistance( ppLineParam[ nLine ][ 2 ] );
    return pItem;
}

void XclImpXF::SetBorder(
        SfxItemSet& rItemSet,
        ColorBuffer& rColorBuffer,
        sal_uInt8 nLeftLine,    sal_uInt16 nLeftColor,
        sal_uInt8 nRightLine,   sal_uInt16 nRightColor,
        sal_uInt8 nTopLine,     sal_uInt16 nTopColor,
        sal_uInt8 nBottomLine,  sal_uInt16 nBottomColor )
{
    SvxBoxItem aBox( ATTR_BORDER );
    SvxBorderLine* pLineItem;

    pLineItem = CreateBorderItem( nLeftLine, nLeftColor, rColorBuffer );
    aBox.SetLine( pLineItem, BOX_LINE_LEFT );
    if( pLineItem ) delete pLineItem;

    pLineItem = CreateBorderItem( nRightLine, nRightColor, rColorBuffer );
    aBox.SetLine( pLineItem, BOX_LINE_RIGHT );
    if( pLineItem ) delete pLineItem;

    pLineItem = CreateBorderItem( nTopLine, nTopColor, rColorBuffer );
    aBox.SetLine( pLineItem, BOX_LINE_TOP );
    if( pLineItem ) delete pLineItem;

    pLineItem = CreateBorderItem( nBottomLine, nBottomColor, rColorBuffer );
    aBox.SetLine( pLineItem, BOX_LINE_BOTTOM );
    if( pLineItem ) delete pLineItem;

    rItemSet.Put( aBox );
}

void XclImpXF::SetArea(
        SfxItemSet& rItemSet,
        ColorBuffer& rColorBuffer,
        sal_uInt8 nPattern,
        sal_uInt16 nForeColor, sal_uInt16 nBackColor )
{
    static const sal_uInt16 pRatioTable[ 19 ] = // 0x8000 = 100%
    {
        0x8000, 0x0000, 0x4000, 0x2000,         // 00 - 03
        0x6000, 0x4000, 0x4000, 0x4000,         // 04 - 07
        0x4000, 0x4000, 0x2000, 0x6000,         // 08 - 11
        0x6000, 0x6000, 0x6000, 0x4800,         // 12 - 15
        0x5000, 0x7000, 0x7800                  // 16 - 18
    };

    // no background -> set nothing!
    if( nPattern != 0 )
    {
        Color aFore, aBack;

        if( nForeColor < 64 )
            aFore = rColorBuffer.GetColor( nForeColor )->GetValue();
        else
            aFore.SetColor( (nForeColor == 64) ? COL_BLACK : COL_WHITE );

        if( nBackColor < 64 )
            aBack = rColorBuffer.GetColor( nBackColor )->GetValue();
        else
            aBack.SetColor( (nBackColor == 64) ? COL_BLACK : COL_WHITE );

        if( nPattern < 19 )
        {
            sal_uInt16 nRatio = pRatioTable[ nPattern ];
            sal_uInt8 nRed = GetMixedColor( aBack.GetRed(), aFore.GetRed(), nRatio );
            sal_uInt8 nGreen = GetMixedColor( aBack.GetGreen(), aFore.GetGreen(), nRatio );
            sal_uInt8 nBlue = GetMixedColor( aBack.GetBlue(), aFore.GetBlue(), nRatio );
            rItemSet.Put( SvxBrushItem( Color( nRed, nGreen, nBlue ) ) );
        }
        else
            rItemSet.Put( SvxBrushItem( aFore ) );
    }
}


//___________________________________________________________________
// class XclImpXFBuffer

XclImpXFBuffer::XclImpXFBuffer( RootData& rRootData ) :
    ExcRoot( &rRootData ),
    aDefPattern( rRootData.pDoc->GetPool() )
{
}

void XclImpXFBuffer::ReadXF( XclImpStream& rStrm, XclBiff eBiff )
{
    XclImpXF* pXF = new XclImpXF;
    pXF->ReadXF( rStrm, *pExcRoot, eBiff );
    aXFList.Append( pXF );
}

void XclImpXFBuffer::ReadStyle( XclImpStream& rStrm, XclBiff eBiff )
{
    if( eBiff < xlBiff8 )
        return;
    if( eBiff > xlBiff8 )
    {
        ASSERT_UNKNOWNBIFF();
        return;
    }

    sal_uInt16 nXFIndex;
    rStrm >> nXFIndex;

    if( nXFIndex & EXC_STYLE_BUILTIN )  // do not read built-in styles
        return;

    nXFIndex &= EXC_STYLE_MASK;         // bits 0...11 are used for XF index
    String aStyleName( rStrm.ReadUniString() );
    if( aStyleName.Len() )
    {
        XclImpXF* pXF = aXFList.GetObject( nXFIndex );
        if( pXF && pXF->IsStyleXF() )
        {
            SfxItemSet& rItemSet = pExcRoot->pDoc->GetStyleSheetPool()->Make(
                aStyleName, SFX_STYLE_FAMILY_PARA, SFXSTYLEBIT_USERDEF ).GetItemSet();
            const ScPatternAttr& rAttr = pXF->GetPattern( *pExcRoot );
            rItemSet.Put( rAttr.GetItemSet() );
        }
    }
}

const ScPatternAttr& XclImpXFBuffer::GetPattern( sal_uInt16 nXFIndex )
{
    XclImpXF* pXF = aXFList.GetObject( nXFIndex );
    DBG_ASSERT( pXF || (pExcRoot->eHauptDateiTyp == Biff2), "XclImpXFBuffer::GetPattern - XF not found" );
    return pXF ? pXF->GetPattern( *pExcRoot ) : aDefPattern;
}

sal_uInt16 XclImpXFBuffer::GetFontIndex( sal_uInt16 nXFIndex ) const
{
    XclImpXF* pXF = aXFList.GetObject( nXFIndex );
    return pXF ? pXF->GetFont() : 0;
}

sal_Bool XclImpXFBuffer::HasEscapement( sal_uInt16 nXFIndex ) const
{
    const XclImpXF* pXF = aXFList.GetObject( nXFIndex );
    const XclImpFont* pFont = pXF ? pExcRoot->pFontBuffer->GetFont( pXF->GetFont() ) : NULL;
    return pFont ? pFont->HasEscapement() : sal_False;
}


//___________________________________________________________________
// class XclImpCellStyle

IMPL_FIXEDMEMPOOL_NEWDEL( XclImpCellStyle, 100, 500 )

sal_Bool XclImpCellStyle::Expand( sal_uInt16 nRow, sal_uInt16 nXFIndex )
{
    if( nXF != nXFIndex )
        return sal_False;

    if( nLastRow + 1 == nRow )
    {
        nLastRow++;
        return sal_True;
    }
    if( nFirstRow && (nFirstRow - 1 == nRow) )
    {
        nFirstRow--;
        return sal_True;
    }

    return sal_False;
}

sal_Bool XclImpCellStyle::Expand( const XclImpCellStyle& rNextStyle )
{
    DBG_ASSERT( nLastRow < rNextStyle.nFirstRow, "XclImpCellStyle::Expand - rows out of order" );
    if( (nXF == rNextStyle.nXF) && (nLastRow + 1 == rNextStyle.nFirstRow) )
    {
        nLastRow = rNextStyle.nLastRow;
        return sal_True;
    }
    return sal_False;
}


//___________________________________________________________________
// class XclImpCellStyleColumn

void XclImpCellStyleColumn::Find(
        XclImpCellStyle*& rpPrevStyle,
        XclImpCellStyle*& rpNextStyle,
        sal_uInt32& rnNextIndex,
        sal_uInt16 nRow ) const
{

    // test whether list is empty
    if( Empty() )
    {
        rpPrevStyle = rpNextStyle = NULL;
        rnNextIndex = 0;
        return;
    }

    rpPrevStyle = GetObject( 0 );
    rpNextStyle = GetObject( Count() - 1 );

    // test whether row is at end of list (contained in or behind last range)
    // rpPrevStyle will contain a possible existing row
    if( rpNextStyle->nFirstRow <= nRow )
    {
        rpPrevStyle = rpNextStyle;
        rpNextStyle = NULL;
        rnNextIndex = Count();
        return;
    }

    // test whether row is at beginning of list (really before first range)
    if( nRow < rpPrevStyle->nFirstRow )
    {
        rpNextStyle = rpPrevStyle;
        rpPrevStyle = NULL;
        rnNextIndex = 0;
        return;
    }

    // loop: find style entries before and after new row
    // break the loop if there is no more range between first and last -or-
    // if rpPrevStyle contains nRow (rpNextStyle will never contain nRow)
    sal_uInt32 nPrevIndex = 0;
    sal_uInt32 nMidIndex;
    rnNextIndex = Count() - 1;
    XclImpCellStyle* pMidStyle;
    while( ((rnNextIndex - nPrevIndex) > 1) && (rpPrevStyle->nLastRow < nRow) )
    {
        nMidIndex = (nPrevIndex + rnNextIndex) / 2;
        pMidStyle = GetObject( nMidIndex );
        DBG_ASSERT( pMidStyle, "XclImpCellStyleColumn::Find - missing style" );
        if( nRow < pMidStyle->nFirstRow )   // row is really before pMidStyle
        {
            rpNextStyle = pMidStyle;
            rnNextIndex = nMidIndex;
        }
        else                                    // row is in or after pMidStyle
        {
            rpPrevStyle = pMidStyle;
            nPrevIndex = nMidIndex;
        }
    }

    // find next rpNextStyle if rpPrevStyle contains nRow
    if( nRow <= rpPrevStyle->nLastRow )
    {
        rnNextIndex = nPrevIndex + 1;
        rpNextStyle = GetObject( rnNextIndex );
    }
}

void XclImpCellStyleColumn::TryConcatPrev( sal_uInt32 nIndex )
{
    if( !nIndex )
        return;

    XclImpCellStyle* pPrevStyle = GetObject( nIndex - 1 );
    XclImpCellStyle* pNextStyle = GetObject( nIndex );
    if( !pPrevStyle || !pNextStyle )
        return;

    if( pPrevStyle->Expand( *pNextStyle ) )
    {
        Remove( nIndex );
        delete pNextStyle;
    }
}

void XclImpCellStyleColumn::SetXF( sal_uInt16 nRow, sal_uInt16 nXFIndex )
{
    XclImpCellStyle* pPrevStyle;
    XclImpCellStyle* pNextStyle;
    sal_uInt32 nNextIndex;

    Find( pPrevStyle, pNextStyle, nNextIndex, nRow );

    // previous range:
    // try to overwrite XF (if row is contained in) or try to expand range
    if( pPrevStyle )
    {
        if( pPrevStyle->Contains( nRow ) )              // overwrite old XF
        {
            if( nXFIndex == pPrevStyle->nXF )
                return;

            sal_uInt16 nFirst = pPrevStyle->nFirstRow;
            sal_uInt16 nLast = pPrevStyle->nLastRow;
            sal_uInt32 nIndex = nNextIndex - 1;
            XclImpCellStyle* pThisStyle = pPrevStyle;
            pPrevStyle = nIndex ? GetObject( nIndex - 1 ) : NULL;

            if( nFirst == nLast )                   // replace solely XF
            {
                pThisStyle->nXF = nXFIndex;
                TryConcatPrev( nNextIndex );        // try to concat. next with this
                TryConcatPrev( nIndex );            // try to concat. this with previous
            }
            else if( nFirst == nRow )               // replace first XF
            {
                pThisStyle->nFirstRow++;
                // try to concatenate with previous of this
                if( !pPrevStyle || !pPrevStyle->Expand( nRow, nXFIndex ) )
                    Insert( new XclImpCellStyle( nRow, nXFIndex ), nIndex );
            }
            else if( nLast == nRow )                // replace last XF
            {
                pThisStyle->nLastRow--;
                if( !pNextStyle || !pNextStyle->Expand( nRow, nXFIndex ) )
                    Insert( new XclImpCellStyle( nRow, nXFIndex ), nNextIndex );
            }
            else                                    // insert in the middle of the range
            {
                pThisStyle->nFirstRow = nRow + 1;
                // List::Insert() moves entries towards end of list, so insert twice at nIndex
                Insert( new XclImpCellStyle( nRow, nXFIndex ), nIndex );
                Insert( new XclImpCellStyle( nFirst, nRow - 1, pThisStyle->nXF ), nIndex );
            }
            return;
        }
        else if( pPrevStyle->Expand( nRow, nXFIndex ) ) // try to expand
        {
            TryConcatPrev( nNextIndex );    // try to concatenate next with expanded
            return;
        }
    }

    // try to expand next range
    if( pNextStyle && pNextStyle->Expand( nRow, nXFIndex ) )
        return;

    // create new range
    Insert( new XclImpCellStyle( nRow, nXFIndex ), nNextIndex );
}


//___________________________________________________________________
// class XclImpCellStyleBuffer

const sal_uInt32 COLBUFFERCOUNT = MAXCOL + 1;   /// Number of allowed columns.


XclImpCellStyleBuffer::XclImpCellStyleBuffer( RootData& rRootData ) :
    ExcRoot( &rRootData ),
    ppColumns( new XclImpCellStyleColumn*[ COLBUFFERCOUNT ] ),
    nUsedCount( 0 )
{
    memset( ppColumns, 0, sizeof( XclImpCellStyleColumn* ) * COLBUFFERCOUNT );
}

XclImpCellStyleBuffer::~XclImpCellStyleBuffer()
{
    Reset();
    delete[] ppColumns;
}

void XclImpCellStyleBuffer::Reset()
{
    for( sal_uInt32 nCol = 0; nCol < nUsedCount; ++nCol )
        if( ppColumns[ nCol ] )
        {
            delete ppColumns[ nCol ];
            ppColumns[ nCol ] = NULL;
        }

    nUsedCount = 0;

    aMergeList.RemoveAll();
}

void XclImpCellStyleBuffer::SetXF( sal_uInt16 nCol, sal_uInt16 nRow, sal_uInt16 nXFIndex, sal_Bool bBlank )
{
    DBG_ASSERT( (nCol <= MAXCOL) && (nRow <= MAXROW), "XclImpCellStyleBuffer::SetXF - out of range" );

    // set cell XF's
    if( !ppColumns[ nCol ] )
        ppColumns[ nCol ] = new XclImpCellStyleColumn;
    if( nCol >= nUsedCount )
        nUsedCount = nCol + 1;
    ppColumns[ nCol ]->SetXF( nRow, nXFIndex );

    // set "center across selection" attribute
    const XclImpXF* pXF = pExcRoot->pXFBuffer->GetXF( nXFIndex );
    if( pXF && (pXF->GetHorAlign() == xlHAlignCenterAcrSel) )
    {
        // expand last merged range if this attribute is set repeatedly
        ScRange* pRange = aMergeList.Last();
        if( bBlank && pRange && (pRange->aEnd.Row() == nRow) && (pRange->aEnd.Col() + 1 == nCol) )
            pRange->aEnd.IncCol();
        else
            SetMerge( nCol, nRow );
    }
}

void XclImpCellStyleBuffer::SetRowDefXF( sal_uInt16 nRow, sal_uInt16 nXFIndex )
{
    for( sal_uInt16 nCol = 0; nCol <= MAXCOL; ++nCol )
        SetXF( nCol, nRow, nXFIndex, sal_True );
}

void XclImpCellStyleBuffer::SetBorderLine( const ScRange& rRange, sal_uInt16 nTab, sal_uInt16 nLine )
{
    sal_uInt16 nFromCol = (nLine == BOX_LINE_RIGHT) ? rRange.aEnd.Col() : rRange.aStart.Col();
    sal_uInt16 nFromRow = (nLine == BOX_LINE_BOTTOM) ? rRange.aEnd.Row() : rRange.aStart.Row();

    const SvxBoxItem* pFromItem = (const SvxBoxItem*)
        pExcRoot->pDoc->GetAttr( nFromCol, nFromRow, nTab, ATTR_BORDER );
    const SvxBoxItem* pToItem = (const SvxBoxItem*)
        pExcRoot->pDoc->GetAttr( rRange.aStart.Col(), rRange.aStart.Row(), nTab, ATTR_BORDER );

    SvxBoxItem aNewItem( *pToItem );
    aNewItem.SetLine( pFromItem->GetLine( nLine ), nLine );
    pExcRoot->pDoc->ApplyAttr( rRange.aStart.Col(), rRange.aStart.Row(), nTab, aNewItem );
}

void XclImpCellStyleBuffer::SetMerge( sal_uInt16 nCol, sal_uInt16 nRow )
{
    aMergeList.Append( ScRange( nCol, nRow, 0 ) );
}

void XclImpCellStyleBuffer::SetMerge( sal_uInt16 nFirstCol, sal_uInt16 nFirstRow, sal_uInt16 nLastCol, sal_uInt16 nLastRow )
{
    aMergeList.Append( ScRange( nFirstCol, nFirstRow, 0, nLastCol, nLastRow, 0 ) );
}

void XclImpCellStyleBuffer::Apply( sal_uInt16 nTab )
{
    ScDocument& rDoc = *pExcRoot->pDoc;
    // apply patterns
    XclImpXFBuffer& rXFBuffer = *pExcRoot->pXFBuffer;
    for( sal_uInt16 nCol = 0; nCol < nUsedCount; ++nCol )
    {
        // apply all cell styles of an existing column
        if( ppColumns[ nCol ] )
        {
            XclImpCellStyleColumn& rColumn = *ppColumns[ nCol ];
            for( XclImpCellStyle* pStyle = rColumn.First(); pStyle; pStyle = rColumn.Next() )
                rDoc.ApplyPatternAreaTab( nCol, pStyle->nFirstRow,
                    nCol, pStyle->nLastRow, nTab, rXFBuffer.GetPattern( pStyle->nXF ) );
        }
    }

    // apply cell merging
    for( ScRange* pRange = aMergeList.First(); pRange; pRange = aMergeList.Next() )
    {
        sal_Bool bMultiCol = (pRange->aStart.Col() != pRange->aEnd.Col());
        sal_Bool bMultiRow = (pRange->aStart.Row() != pRange->aEnd.Row());
        // set correct right border
        if( bMultiCol )
            SetBorderLine( *pRange, nTab, BOX_LINE_RIGHT );
        // set correct lower border
        if( bMultiRow )
            SetBorderLine( *pRange, nTab, BOX_LINE_BOTTOM );
        // do merge
        if( bMultiCol || bMultiRow )
            rDoc.DoMerge( nTab, pRange->aStart.Col(), pRange->aStart.Row(),
                pRange->aEnd.Col(), pRange->aEnd.Row() );
    }

    Reset();
}


//___________________________________________________________________

