/*************************************************************************
 *
 *  $RCSfile: XclImpHelper.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: dr $ $Date: 2001/11/28 16:38:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//___________________________________________________________________

#ifndef _SC_XCLIMPHELPER_HXX
#include "XclImpHelper.hxx"
#endif

#ifndef _UNOTOOLS_CHARCLASS_HXX
#include <unotools/charclass.hxx>
#endif

#ifndef SC_DOCUMENT_HXX
#include "document.hxx"
#endif
#ifndef SC_SCGLOB_HXX
#include "global.hxx"
#endif

#ifndef _EXCDEFS_HXX
#include "excdefs.hxx"
#endif
#ifndef _EXCFORM_HXX
#include "excform.hxx"
#endif
#ifndef _EXCSST_HXX
#include "excsst.hxx"
#endif
#ifndef _FONTBUFF_HXX
#include "fontbuff.hxx"
#endif


//___________________________________________________________________
// class XclImpHelper

ShStrTabEntry* XclImpHelper::CreateUnicodeEntry( XclImpStream& rStrm, sal_uInt16 nChars )
{
	ShStrTabEntry* pRet;

    sal_uInt8 nFlags = rStrm.ReaduInt8();
    sal_Bool b16Bit, bRich, bFarEast;
    sal_uInt16 nCrun;
    sal_uInt32 nExtInf;

    rStrm.ReadUniStringExtHeader( b16Bit, bRich, bFarEast, nCrun, nExtInf, nFlags );
    String sString( rStrm.ReadRawUniString( nChars, b16Bit ) );

	pRet = bRich ? new ShStrTabFormEntry( sString, rStrm, nCrun ) : new ShStrTabEntry( sString );

	rStrm.Ignore( nExtInf );
	return pRet;
}



//___________________________________________________________________
// class XclImpURLDecoder

void XclImpURLDecoder::DecodeURL_Impl(
        XclImpStream& rStrm, String& rFile, String& rTable,
        sal_Bool& rbSameWb, sal_uInt16 nChars, sal_Bool b16Bit )
{
    enum
    {
        xlURLInit, xlURLPath, xlURLFileName, xlURLSheetName, xlURLRaw
    } eState = xlURLInit;

    sal_Unicode cEnc;
    sal_uInt16 nCharsLeft = nChars;
    sal_Bool bEncoded = sal_True;
    rbSameWb = sal_False;

	while( nCharsLeft )
	{
        cEnc = ReadChar( rStrm, nCharsLeft, b16Bit );
		switch( eState )
		{
            case xlURLInit:
			{
				switch( cEnc )
				{
                    case 0x0000:                                    // empty
                    case 0x0001:                            break;  // encode
                    case 0x0002:                                    // self
                    case 0x0003:    rbSameWb = sal_True;    break;  // encode & self
                    default:
                        bEncoded = sal_False;
                        rFile += cEnc;
				}
                eState = xlURLPath;
			}
			break;
            case xlURLPath:
			{
				switch( cEnc )
				{
					case 0x0001:
					{
						if( nCharsLeft > 1 )
						{
                            cEnc = ReadChar( rStrm, nCharsLeft, b16Bit );
							if( cEnc == '@' )
                                rFile.AppendAscii( "\\\\" );
							else
							{
                                rFile += cEnc;
								rFile.AppendAscii( ":\\" );
							}
						}
						else
							rFile.AppendAscii( "<NULL-DRIVE!>" );
					}
					break;
					case 0x0002:
                    case 0x0003:
                        rFile.AppendAscii( "\\" );
                        if( !bEncoded )
                            eState = xlURLRaw;             // was DDE delimiter
                    break;
                    case 0x0004:    rFile.AppendAscii( "..\\"); break;
					case 0x0005:
					{
						if( nCharsLeft )
						{
                            sal_uInt16 nVolLen = static_cast< sal_uInt16 >( ReadChar( rStrm, nCharsLeft, b16Bit ) );
							if( nVolLen )
							{
								while( nVolLen-- )
								{
                                    cEnc = ReadChar( rStrm, nCharsLeft, b16Bit );
                                    rFile += cEnc;
								}
							}
							else
								rFile.AppendAscii( "<EMPTY MAC-LONG-VOLUME>" );

                            rFile += ':';
						}
						else
							rFile.AppendAscii( "<ERROR IN MAC-LONG-VOLUME>" );
					}
					break;
					case 0x0006:	rFile.AppendAscii( "<Startup Dir>:" );		break;
					case 0x0007:	rFile.AppendAscii( "<Alt Startup Dir>:" );	break;
					case 0x0008:	rFile.AppendAscii( "<Library>" );			break;
                    case '[':       eState = xlURLFileName;                     break;  // start of file name
                    default:        rFile += cEnc;
				}
			}
			break;
            case xlURLFileName:
			{
				switch( cEnc )
				{
                    case ']':   eState = xlURLSheetName;    break;  // end of file name
                    default:    rFile += cEnc;
				}
			}
			break;
            case xlURLSheetName:    rTable += cEnc;         break;
            case xlURLRaw:          rFile += cEnc;          break;
		}
	}
}

void XclImpURLDecoder::DecodeURL(
        XclImpStream& rStrm, String& rFile, String& rTable,
        sal_Bool& rbSameWb, sal_uInt16 nChars, sal_uInt8 nFlags )
{
	rStrm.PushPosition();
    sal_Bool b16Bit;
    rStrm.ReadUniStringExtHeader( b16Bit, nFlags );
    DecodeURL_Impl( rStrm, rFile, rTable, rbSameWb, nChars, b16Bit );
	rStrm.PopPosition();
	rStrm.IgnoreUniString( nChars, nFlags );
}



//___________________________________________________________________
// class XclImpCachedValue

XclImpCachedValue::XclImpCachedValue( XclImpStream& rStrm, ExcelToSc& rFmlConv ) :
    pStr( NULL ),
    fValue( 0.0 ),
    pTokArr( NULL )
{
    rStrm >> nType;
    switch( nType )
    {
        case EXC_CACHEDVAL_EMPTY:
            rStrm.Ignore( 8 );
        break;
        case EXC_CACHEDVAL_DOUBLE:
            rStrm >> fValue;
        break;
        case EXC_CACHEDVAL_STRING:
            pStr = new String( rStrm.ReadUniString() );
        break;
        case EXC_CACHEDVAL_BOOL:
        case EXC_CACHEDVAL_ERROR:
        {
            sal_Bool bIsErr = (nType == EXC_CACHEDVAL_ERROR);
            sal_uInt8 nErrBool;
            double fVal;
            rStrm.Ignore( 1 );
            rStrm >> nErrBool;
            rStrm.Ignore( 6 );

            const ScTokenArray* pTok = rFmlConv.GetBoolErr(
                XclTools::ErrorToEnum( fVal, bIsErr, nErrBool ) );
            pTokArr = pTok ? new ScTokenArray( *pTok ) : NULL;
        }
        break;
        default:
            DBG_ERROR( "XclImpCachedValue::XclImpCachedValue - unknown data type" );
    }
}

XclImpCachedValue::~XclImpCachedValue()
{
    if( pStr )
        delete pStr;
    if( pTokArr )
        delete pTokArr;
}


//___________________________________________________________________

