/*************************************************************************
 *
 *  $RCSfile: XclImpExternsheet.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: dr $ $Date: 2002/01/08 07:23:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#ifdef PCH
#include "filt_pch.hxx"
#endif

#pragma hdrstop

//___________________________________________________________________

#ifndef _SC_XCLIMPEXTERNSHEET_HXX
#include "XclImpExternsheet.hxx"
#endif

#ifndef SC_DOCUMENT_HXX
#include "document.hxx"
#endif
#ifndef SC_CELL_HXX
#include "cell.hxx"
#endif
#ifndef _SCEXTOPT_HXX
#include "scextopt.hxx"
#endif
#ifndef _ROOT_HXX
#include "root.hxx"
#endif

#ifndef _SC_XCLIMPSTREAM_HXX
#include "XclImpStream.hxx"
#endif
#ifndef _SC_XCLIMPHELPER_HXX
#include "XclImpHelper.hxx"
#endif
#ifndef _XCLADDINNAMETRANS_HXX
#include "XclAddInNameTrans.hxx"
#endif


//___________________________________________________________________
// class XclImpTabIdBuffer

void XclImpTabIdBuffer::ReadTabid8( XclImpStream& rStrm )
{
    ScfUInt16List::Clear();
    sal_uInt32 nReadCount = rStrm.GetRecLeft() / 2;
    DBG_ASSERT( nReadCount <= 0xFFFF, "XclImpTabIdBuffer::ReadTabid8 - record too long" );
    sal_uInt16 nTabId;
    for( sal_uInt32 nIndex = 0; nIndex < nReadCount; ++nIndex )
    {
        rStrm >> nTabId;
        // #93471# zero index is not allowed in BIFF8, but it seems that it occurs in real life
        ScfUInt16List::Append( nTabId );
    }
}

sal_uInt16 XclImpTabIdBuffer::GetIndex( sal_uInt16 nTabId, sal_uInt16 nMaxTabId ) const
{
    sal_uInt16 nReturn = 0;
    for( sal_uInt32 nIndex = 0; nIndex < Count(); ++nIndex )
    {
        sal_uInt16 nValue = ScfUInt16List::GetValue( nIndex );
        if( nValue == nTabId )
            return nReturn;
        if( nValue <= nMaxTabId )
            nReturn++;
    }
    return 0;
}



//___________________________________________________________________
// class XclImpExtName

XclImpExtName::XclImpExtName( XclImpStream& rStrm, RootData& rRootData )
{
    sal_uInt16 nFlags;
    sal_uInt8 nLen;
    rStrm >> nFlags >> nStorageId >> nLen;
    rStrm.AppendUniString( aName, nLen );

    if( (nFlags & EXC_EXTN_BUILTIN) || !(nFlags & 0xFFFE) )
    {
        eType = xienName;
        ScfTools::ConvertName( aName, sal_True );  // also a point is a valid char for func names!
        XclAddInNameTranslator* pTrans = rRootData.pAddInNameTranslator;
        if( pTrans )
            aName = pTrans->GetScName( aName );
    }
    else if( nFlags & EXC_EXTN_OLE )
        eType = xienOLE;
    else
        eType = xienDDE;
}



//___________________________________________________________________
// class XclImpExtNameList

const XclImpExtName* XclImpExtNameList::GetName( sal_uInt16 nXclIndex ) const
{
    DBG_ASSERT( nXclIndex, "XclImpExtNameList::GetName - index must be >0" );
    return GetObject( nXclIndex - 1 );
}



//___________________________________________________________________
// class XclImpCrn

XclImpCrn::XclImpCrn( XclImpStream& rStrm, ExcelToSc& rFmlaConv, sal_uInt16 _nCol, sal_uInt16 _nRow ) :
    XclImpCachedValue( rStrm, rFmlaConv ),
    nCol( _nCol ),
    nRow( _nRow )
{
}

void XclImpCrn::SetCell( ScDocument& rDoc, sal_uInt16 nTab )
{
    switch( nType )
    {
        case EXC_CACHEDVAL_DOUBLE:
            rDoc.SetValue( nCol, nRow, nTab, fValue );
        break;
        case EXC_CACHEDVAL_STRING:
        {
            DBG_ASSERT( pStr, "XclImpCrn::SetCell - missing string" );
            ScStringCell* pStrCell = new ScStringCell( *pStr );
            rDoc.PutCell( ScAddress( nCol, nRow, nTab ), pStrCell );
        }
        break;
        case EXC_CACHEDVAL_BOOL:
        case EXC_CACHEDVAL_ERROR:
        {
            ScAddress aPos( nCol, nRow, nTab );
            ScFormulaCell* pFmlaCell = new ScFormulaCell( &rDoc, aPos, pTokArr );
            pFmlaCell->SetDouble( fValue );
            rDoc.PutCell( aPos, pFmlaCell );
        }
        break;
    }
}



//___________________________________________________________________
// class XclImpSupbookTab

void XclImpSupbookTab::CreateTable( ScDocument& rDoc, const String& rURL )
{
    if( rDoc.LinkEmptyTab( nScTab, ScGlobal::GetDocTabName( rURL, aName ), rURL, aName ) )
    {
        for( XclImpCrn* pCrn = aCrnList.First(); pCrn; pCrn = aCrnList.Next() )
            pCrn->SetCell( rDoc, nScTab );
    }
    else
        nScTab = EXC_TAB_INVALID;
}



//___________________________________________________________________
// class XclImpSupbook

XclImpSupbook::XclImpSupbook( XclImpStream& rStrm )
{
    sal_uInt16 nTabCnt;
    rStrm >> nTabCnt;

    if( rStrm.GetRecLeft() < static_cast< sal_uInt32 >( 2 + 2 * nTabCnt ) )
    {
        bSelf = (rStrm.ReaduInt16() == 0x0401);
        return;
    }

    ReadDocName( rStrm, aFileName, bSelf );

    if( nTabCnt )
    {
        for( sal_uInt16 nTab = 0; nTab < nTabCnt; ++nTab )
        {
            String aTabName;
            ReadTabName( rStrm, aTabName );
            aSupbookTabList.Append( new XclImpSupbookTab( aTabName ) );
        }
    }
    else
        // create dummy list entry
        aSupbookTabList.Append( new XclImpSupbookTab( aFileName ) );
}

void XclImpSupbook::AppendCrn( XclImpCrn*& rpCrn )
{
    XclImpSupbookTab* pTab = aSupbookTabList.GetObject( nCurrExcTab );
    if( pTab )
        pTab->AppendCrn( rpCrn );
    else
        delete rpCrn;
    rpCrn = NULL;
}

//static
void XclImpSupbook::ReadDocName( XclImpStream& rStrm, String& rDocName, sal_Bool& rbSelf )
{
    String aTabName;
    XclImpURLDecoder::DecodeURL( rStrm, rDocName, aTabName, rbSelf );
}

//static
void XclImpSupbook::ReadTabName( XclImpStream& rStrm, String& rTabName )
{
    rStrm.AppendUniString( rTabName );
    ScfTools::ConvertName( rTabName );
}

void XclImpSupbook::ReadXct8( XclImpStream& rStrm )
{
    rStrm.Ignore( 2 );
    rStrm >> nCurrExcTab;
}

void XclImpSupbook::ReadCrn8( XclImpStream& rStrm, ExcelToSc& rFmlaConv )
{
    sal_uInt8 nLastCol, nFirstCol;
    sal_uInt16 nRow;
    rStrm >> nLastCol >> nFirstCol >> nRow;

    XclImpCrn* pCrn = NULL;
    for( sal_uInt16 nCol = nFirstCol; (nCol <= nLastCol) && (rStrm.GetRecLeft() > 1); ++nCol )
    {
        pCrn = new XclImpCrn( rStrm, rFmlaConv, nCol, nRow );
        AppendCrn( pCrn );
    }
}

void XclImpSupbook::ReadExternname8( XclImpStream& rStrm, RootData& rRootData )
{
    aExtNameList.Append( new XclImpExtName( rStrm, rRootData ) );
}

sal_Bool XclImpSupbook::GetLink( String& rApplic, String& rDoc ) const
{
    // first backslash is application name delimiter
    // (created by XclImpURLDecoder::DecodeURL())
    xub_StrLen nPos = aFileName.Search( '\\' );
    if( bSelf || !aFileName.Len() || (nPos == STRING_NOTFOUND) )
        return sal_False;
    rApplic = aFileName.Copy( 0, nPos );
    rDoc = aFileName.Copy( nPos + 1 );
    return (rApplic.Len() > 0) && (rDoc.Len() > 0);
}

sal_uInt16 XclImpSupbook::GetScTabNum( sal_uInt16 nExcTabNum ) const
{
    if( bSelf )
        return nExcTabNum;
    const XclImpSupbookTab* pTab = aSupbookTabList.GetObject( nExcTabNum );
    return pTab ? pTab->GetScTab() : EXC_TAB_INVALID;
}

sal_uInt16 XclImpSupbook::GetScTabNum( const String& rTabName ) const
{
    for( sal_uInt32 nIndex = 0; nIndex < aSupbookTabList.Count(); ++nIndex )
    {
        const XclImpSupbookTab* pTab = aSupbookTabList.GetObject( nIndex );
        if( pTab && (pTab->GetName() == rTabName) )
            return pTab->GetScTab();
    }
    return EXC_TAB_INVALID;
}

void XclImpSupbook::CreateTables( RootData& rRootData, sal_uInt16 nFirst, sal_uInt16 nLast ) const
{
    if( bSelf || (rRootData.pExtDocOpt->nLinkCnt >= 1) )
        return;

    String aURL( ScGlobal::GetAbsDocName( aFileName, rRootData.pDoc->GetDocumentShell() ) );

    for( sal_uInt16 nTab = nFirst; nTab <= nLast; ++nTab )
    {
        XclImpSupbookTab* pSBTab = aSupbookTabList.GetObject( nTab );
        if( pSBTab )
            pSBTab->CreateTable( *rRootData.pDoc, aURL );
    }
}



//___________________________________________________________________
// class XclImpSupbookList

const XclImpSupbook* XclImpSupbookList::GetSupbook( const String& rDocName ) const
{
    for( sal_uInt32 nIndex = 0; nIndex < Count(); ++nIndex )
    {
        const XclImpSupbook* pSupbook = GetObject( nIndex );
        if( pSupbook && (pSupbook->GetName() == rDocName) )
            return pSupbook;
    }
    return NULL;
}



//___________________________________________________________________
// class XclImpExtsheetBuffer

sal_Bool XclImpExtsheetBuffer::FindNextTabRange(
        sal_uInt16 nSupb, sal_uInt16 nStart,
        sal_uInt16& rnFirst, sal_uInt16& rnLast )
{
    rnFirst = rnLast = 0xFFFF;
    for( const XclImpXti* pXti = aXtiList.First(); pXti; pXti = aXtiList.Next() )
    {
        if( (nSupb == pXti->nSupbook) && (nStart <= pXti->nLast) && (pXti->nFirst < rnFirst) )
        {
            rnFirst = Max( nStart, pXti->nFirst );
            rnLast = pXti->nLast;
        }
    }
    return (rnFirst < 0xFFFF);
}

void XclImpExtsheetBuffer::ReadExternsheet8( XclImpStream& rStrm )
{
    sal_uInt16 nXtiCount;
    rStrm >> nXtiCount;

    XclImpXti* pXti;
    while( nXtiCount )
    {
        pXti = new XclImpXti;
        rStrm >> pXti->nSupbook >> pXti->nFirst >> pXti->nLast;
        aXtiList.Append( pXti );
        --nXtiCount;
    }
}

void XclImpExtsheetBuffer::ReadXct8( XclImpStream& rStrm )
{
    XclImpSupbook* pSupbook = aSupbookList.GetCurrSupbook();
    if( pSupbook )
        pSupbook->ReadXct8( rStrm );
}

void XclImpExtsheetBuffer::ReadCrn8( XclImpStream& rStrm, ExcelToSc& rFmlaConv )
{
    XclImpSupbook* pSupbook = aSupbookList.GetCurrSupbook();
    if( pSupbook )
        pSupbook->ReadCrn8( rStrm, rFmlaConv );
}

void XclImpExtsheetBuffer::ReadExternname8( XclImpStream& rStrm, RootData& rRootData )
{
    XclImpSupbook* pSupbook = aSupbookList.GetCurrSupbook();
    if( pSupbook )
        pSupbook->ReadExternname8( rStrm, rRootData );
}

void XclImpExtsheetBuffer::CreateTables( RootData& rRootData )
{
    DBG_ASSERT( !bCreated, "XclImpExtsheetBuffer::CreateTables - multiple call" );
    if( bCreated ) return;

    sal_uInt16 nFirst, nLast;

    for( sal_uInt16 nSupbook = 0; nSupbook < aSupbookList.Count(); ++nSupbook )
    {
        const XclImpSupbook* pSupbook = aSupbookList.GetSupbook( nSupbook );
        sal_Bool bLoop = FindNextTabRange( nSupbook, 0, nFirst, nLast );
        while( bLoop && pSupbook )
        {
            pSupbook->CreateTables( rRootData, nFirst, nLast );
            // #96263# don't search again if last sheet == 0xFFFF
            bLoop = (nLast < 0xFFFF) ? FindNextTabRange( nSupbook, nLast + 1, nFirst, nLast ) : sal_False;
        }
    }
    bCreated = sal_True;
}

const XclImpSupbook* XclImpExtsheetBuffer::GetSupbook( sal_uInt32 nXtiIndex ) const
{
    const XclImpXti* pXti = GetXti( nXtiIndex );
    return pXti ? aSupbookList.GetSupbook( pXti->nSupbook ) : NULL;
}


